/* erstes Beispielprogramm, Version 1b */

#include <stdio.h>
#include "beispiel1.h"

// Serielle Variante:
void quadrieren1(int *feld,int *ziel,int n)
{
 for(int i=0;i<n;i++)
  {
   ziel[i] = feld[i]*feld[i];
  }
}

// Variante mit CPU-Threads:
#include <thread>

void quadr(int *feld,int *ziel,int i0,int nt,int n)
{
 for(int i=i0;i<n;i+=nt)
   ziel[i] = feld[i]*feld[i];
}

void quadrieren2(int *feld,int *ziel,int n)
{
 int nt=std::thread::hardware_concurrency();
 std::thread tr[nt-1];
 for(int i=0;i<nt-1;i++)
   tr[i]=std::thread(quadr,feld,ziel,i,nt,n);
 quadr(feld,ziel,nt-1,nt,n);
 for(int i=0;i<nt-1;i++)
   tr[i].join();
}

#define N 100000000
int variante=0;
bool qflag=false; //Quiet-Flag, wenn gesetzt: ohne Ergebnisse ueberpruefen

void argscan(int argc,char **argv)
{
 bool ok=true;
 for(int i=1;i<argc;i++)
  {
   if(isdigit(*argv[i])) sscanf(argv[i],"%d",&variante);
   else if(*argv[i]=='q' || argv[i][1]=='q') qflag=true;
   else ok=false;
  }
 if(!ok)
  {
   printf("Aufruf:\n%s [-q] <Variante>\n",argv[0]);
   printf(" 2=CPU-Threads, 3=OpenCL, 4=CUDA\n");
   printf(" q=ohne Ueberpruefung der Ergebnisse\n");
   exit(0);
  }
}

int main(int argc,char **argv)
{
 int i;
 int *feld,*zielfeld;
 feld = new int[N];
 zielfeld = new int[N];
 if(argc>=2) argscan(argc,argv);
 for(i=0;i<N;i++)
  {
   feld[i] = random()&0x7FFF;
   zielfeld[i]=0;
  }
 printf("%d Zufallszahlen erstellt.\n",N);
 print_feld(feld); //Zufallszahlen anzeigen
 if(variante<=1)
  {printf("Seriell auf CPU gerechnet:\n");
   quadrieren1(feld,zielfeld,N); //alle N Zahlen quadrieren
  }
 else if(variante==2)
  {int nt=std::thread::hardware_concurrency();
   printf("Mit %d CPU-Threads gerechnet:\n",nt);
   quadrieren2(feld,zielfeld,N); //alle N Zahlen quadrieren
  }
 else if(variante==3)
  {printf("Auf Grafikkarte mit OpenCL gerechnet:\n");
   copy_to_device(feld,N);
   bool ok=opencl_kernel_compilieren("beispiel1_kernel.cc");
   if(!ok) {printf("Fehler3: opencl_kernel_compilieren() misslungen.\n"); exit(1);}
   quadrieren_opencl(feld,zielfeld,N);
   device_speicher_freigeben();
  }
 else //if(variante==4)
  {printf("Auf Grafikkarte mit CUDA gerechnet:\n");
   copy_to_device_cuda(feld,N);
   quadrieren_cuda(feld,zielfeld,N);
   device_speicher_freigeben_cuda();
  }
 print_feld(zielfeld); //Ergebnisse anzeigen
 if(!qflag)
  { //Ergebnisse ueberpruefen:
   bool ok=true;
   for(i=0;i<N;i++)
    if(zielfeld[i] != feld[i]*feld[i]) {ok=false; break;}
   if(ok) printf("Ergebnisse erfolgreich ueberprueft.\n");
   else printf("Fehlerhafte Ergebnisse!\n");
  }
 delete[] feld;
 delete[] zielfeld;
 return 0;
}

void print_feld(const int *feld)
{
 for(int i=0;i<3;i++) //erste Werte anzeigen
   printf(" %d",feld[i]);
 printf(" ...");
 for(int i=N-3;i<N;i++) //letzte Werte anzeigen
   printf(" %d",feld[i]);
 printf("\n");
}
