/* CUDA Teil vom ersten Beispielprogramm
*/

#include <stdio.h>
#include "beispiel1.h"

__global__
void cuda_quadr(const int *feld,int *ziel,int n)
{
 int nt = blockDim.x*gridDim.x; //Anzahl Threads
 int i0 = blockDim.x*blockIdx.x+threadIdx.x;
 for(int i=i0;i<n;i+=nt)
  {
   ziel[i] = feld[i]*feld[i];
  }
}

/********************* allgemeine CUDA-Routinen *********************/
bool errcheck(const char *text)
{
 cudaError_t err=cudaGetLastError();
 if(err != cudaSuccess)
   fprintf(stderr, "%s %d: %s\n",text,err,cudaGetErrorString(err));
 return (err==cudaSuccess);
}
/********************************************************************/

int *d_feld=NULL, *d_ziel=NULL;

bool copy_to_device_cuda(const int *feld,int n)
{
 int size=n*sizeof(int);
 cudaMalloc((void**)&d_feld, size);
 cudaMalloc((void**)&d_ziel, size); if(d_ziel==NULL) return false;
 cudaMemcpy(d_feld,feld,size,cudaMemcpyHostToDevice);
 return errcheck("Fehler bei cudaMemcpy()");
}

bool copy_from_device_cuda(int *ziel,int n)
{
 cudaMemcpy(ziel,d_ziel,n*sizeof(int),cudaMemcpyDeviceToHost);
 return true;
}

int divup(int obe,int une) //Division aufgerundet
{
 return (obe+une-1)/une;
}

extern void quadrieren_cuda(const int *feld,int *ziel,int n)
{
 if(d_ziel==NULL)
  {
   if(!copy_to_device_cuda(feld,n))
     {printf("Fehler1: copy_to_device_cuda() misslungen\n");}
  }
 int threadsPerBlock=32; //bis 1024 erlaubt
 int nBlocks=1024; //bis 65535 erlaubt
 //int nBlocks=divup(n,threadsPerBlock); //bis 65535 erlaubt
 //while(nBlocks>65535)
 // {threadsPerBlock *= 2; nBlocks=divup(n,threadsPerBlock);}
 if(threadsPerBlock>1024) printf("Fehler: threadsPerBlock zu gross\n");
 printf("threadsPerBlock=%d  nBlocks=%d\n",threadsPerBlock,nBlocks);//test
 cuda_quadr<<<nBlocks,threadsPerBlock>>>(d_feld,d_ziel,n);
 cudaDeviceSynchronize(); //auf Beenden aller Threads warten
 errcheck("Fehler2: Kernelaufruf misslungen");
 copy_from_device_cuda(ziel,n);
}

extern void device_speicher_freigeben_cuda()
{
 cudaFree(d_ziel); d_ziel=NULL;
 cudaFree(d_feld); d_feld=NULL;
}
