/* OpenCL Teil vom ersten Beispielprogramm
*/

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#define CL_TARGET_OPENCL_VERSION 120
#include <CL/cl.hpp>
#include "beispiel1.h"

// Vordeklarationen von Hilfsroutinen:
void opencl_init();
int filelaenge(const char *name);
void datei_einlesen(const char *name,char *ziel);

// Statische OpenCL-Objekte:
cl::Device default_device;
cl::Context context;
cl::CommandQueue queue;
cl::Kernel kernel_quadr;
cl::Buffer dfeld; //Zeiger auf Speicher auf dem Device
cl::Buffer dziel;
int size1=0; //Groesse der Puffer in Bytes

extern bool copy_to_device(const int *feld,int n)
{
 opencl_init();
 size1 = sizeof(int)*n;
 dfeld = cl::Buffer(context,CL_MEM_READ_WRITE,size1);
 dziel = cl::Buffer(context,CL_MEM_READ_WRITE,size1);
 queue=cl::CommandQueue(context,default_device);
 queue.enqueueWriteBuffer(dfeld,CL_TRUE,0,size1,feld);
 return true;
}

extern bool copy_from_device(int *ziel,int n)
{
 queue.enqueueReadBuffer(dziel,CL_TRUE,0,sizeof(int)*n,ziel);
 return true;
}

extern bool opencl_kernel_compilieren(const char *kernel_name)
{
 if(size1==0)
  {printf("Fehler1: kein Speicher auf dem Device reserviert.\n"); return false;}
 char *quellcode;
 int len=filelaenge(kernel_name);
 if(len==0)
  {printf("Fehler2: \"%s\" nicht gefunden\n",kernel_name); return false;}
 quellcode=new char[len]; if(quellcode==NULL) return false;
 datei_einlesen(kernel_name,quellcode);
 std::string code=quellcode;
 delete[] quellcode;
 cl::Program::Sources sources;
 sources.push_back({code.c_str(),code.length()});
 cl::Program program(context,sources);
 if(program.build({default_device})!=CL_SUCCESS) return false;
 kernel_quadr=cl::Kernel(program,"quadr");
 return true;
}

extern void quadrieren_opencl(const int *feld,int *ziel,int n)
{
 if(size1==0) copy_to_device(feld,n);
 kernel_quadr.setArg(0,dfeld);
 kernel_quadr.setArg(1,dziel);
 queue.enqueueNDRangeKernel(kernel_quadr,cl::NullRange,cl::NDRange(n),cl::NullRange);
 queue.finish(); //auf Beenden aller Threads warten?
 copy_from_device(ziel,n);
}

extern void device_speicher_freigeben()
{
}

// immer gleiche OpenCL Routinen:
void opencl_init()
{
 //get all platforms (drivers)
 std::vector<cl::Platform> all_platforms;
 cl::Platform::get(&all_platforms);
 if(all_platforms.size()==0)
  {std::cout<<" No platforms found. Check OpenCL installation!\n"; exit(1);}
 cl::Platform default_platform=all_platforms[0];
 //get default device of the default platform
 std::vector<cl::Device> all_devices;
 default_platform.getDevices(CL_DEVICE_TYPE_ALL, &all_devices);
 std::cout << "Using platform: "<<default_platform.getInfo<CL_PLATFORM_NAME>()<<"\n";
 if(all_platforms.size() > 1)
  {
   printf("Weitere platforms:\n");
   for(unsigned int i=1;i<all_platforms.size();i++)
    std::cout << ' ' << i << ": "<<all_platforms[i].getInfo<CL_PLATFORM_NAME>()<<"\n";
  }
 if(all_devices.size()==0)
  {std::cout<<" No devices found. Check OpenCL installation!\n"; exit(1);}
 default_device=all_devices[0];
 std::cout<< "Using device: "<<default_device.getInfo<CL_DEVICE_NAME>()<<"\n";
 if(all_devices.size() > 1)
  {
   printf("Weitere devices:\n");
   for(unsigned int i=1;i<all_devices.size();i++)
    std::cout << ' ' << i << ": "<<all_devices[i].getInfo<CL_DEVICE_NAME>()<<"\n";
  }
 context=cl::Context({default_device});
}
// Ende der OpenCL Routinen.

/*************************** kleinkram ***************************/
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
const int BLOCKS=0, BYTES=1, BSIZE=2;

int filelaenge(const char *name,int flag=BSIZE)
{
 struct stat buf;
 int n;
 if(lstat(name,&buf)<0) return -1;
 if(!S_ISREG(buf.st_mode)) return -2;
//fuer Inhalt von buf siehe "man lstat"
 if(flag==BLOCKS) n=buf.st_blocks;
 else if(flag==BSIZE) n=buf.st_blksize;
 else n=buf.st_size;
 return n;
}

int filelaenge(const char *name) {return filelaenge(name,BSIZE);}

int index(const char *s1,const char *s2)
{	             /* Sucht den String s2 innerhalb von s1           */
 int i,c;	     /* und gibt Position zurueck (nicht gefunden: -1) */
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void datei_einlesen(const char *name,char *ziel)
{
 char zeile[200];
 const char *s;
 int c;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("konnte \"%s\" nicht oeffnen\n",name); *ziel=0; return;}
 while(getline(fp,zeile,200))
  {
   for(s=zeile;*s==' ' || *s=='\t';s++) {}//Leerzeichen ueberlesen
   if(s[0]==0) continue; //Leerzeilen ueberlesen
   if(strncmp(s,"//",2)==0) continue; //Kommentare ueberlesen
   if(index(s,"//nur zum mit gcc testen") > 0) continue;//testzeilen ueberlesen
   for(int i=0;(c=zeile[i])!=0 && (c!='/' || zeile[i+1]!='/');i++)
     *ziel++ = c; //Zeile kopieren, aber Kommentare weglassen
   *ziel++ = '\n';
  }
 *ziel=0;
 fclose(fp);
}
/************************ ende kleinkram *************************/
