/* beispiel2.cc */

#include <stdio.h>
#include <iostream>
#include <thread>
#include "beispiel2.h"

#define N 1920
#define M 1080

#define FLOP (5L*N*M) //soviele "Floating OPerations" werden gebraucht

// CPU-Variante:
void grauwerte(const int*R,const int*G,const int*B,float*H, int i0,int nt)
{
 for(int i=i0;i<N;i+=nt)
  for(int j=0;j<M;j++)
  {
   H[j*N+i] = (0.299*R[j*N+i] + 0.587*G[j*N+i] + 0.114*B[j*N+i])/255;
  }
}

//leicht optimierte Variante:
void grauwerte_opt(const int*R,const int*G,const int*B,float*H, int j0,int nt)
{
 for(int j=j0;j<M;j+=nt)
  for(int i=0,k=j*N;i<N;i++,k++)
  {
   H[k] = (0.299/255)*R[k] + (0.587/255)*G[k] + (0.114/255)*B[k];
  }
}

int Rot[N*M],Gruen[N*M],Blau[N*M];
float Hwerte[N*M];

void calc_grauwerte(int *R,int *G,int *B,float *H,bool optimiert=false)
{
 int nt=std::thread::hardware_concurrency();
 std::thread tr[nt-1];
 if(optimiert)
  {
   for(int i=0;i<nt-1;i++)
    tr[i]=std::thread(grauwerte_opt,R,G,B,H,i,nt);
   grauwerte_opt(R,G,B,H,nt-1,nt);
  }
 else
  {
   for(int i=0;i<nt-1;i++)
    tr[i]=std::thread(grauwerte,R,G,B,H,i,nt);
   grauwerte(R,G,B,H,nt-1,nt);
  }
 for(int i=0;i<nt-1;i++)
   tr[i].join();
}

int variante=0;

void argscan(int argc,char **argv)
{
 bool ok=true;
 for(int i=1;i<argc;i++)
  {
   if(isdigit(*argv[i])) sscanf(argv[i],"%d",&variante);
   else ok=false;
  }
 if(!ok)
  {
   printf("Aufruf:\n%s <Variante>\n",argv[0]);
   printf(" 1=CPU-Threads, 2=CPU-Optimiert, 3=OpenCL, 4=CUDA\n");
   exit(0);
  }
}

int main(int argc,char **argv)
{
 int i,j;
 if(argc>=2) argscan(argc,argv);
 for(i=0;i<N;i++)
 for(j=0;j<M;j++)
  {
   Rot[j*N+i] = random()&0xFF;
   Gruen[j*N+i] = random()&0xFF;
   Blau[j*N+i] = random()&0xFF;
   Hwerte[j*N+i]=0;
  }
 printf("%d Zufallszahlen erstellt.\n",N*M);
 int nt=std::thread::hardware_concurrency();
 print_feld(Rot); //einige Zufallszahlen anzeigen
 if(variante<=1)
  {printf("auf CPU (%d Threads) gerechnet:\n",nt);
   stoppuhr_reset();
   calc_grauwerte(Rot,Gruen,Blau,Hwerte,false); //ohne Optimierung
   int usec=stoppuhr_read();
   printf("Rechenzeit CPU: ");
   zeit_print(usec,FLOP);
  }
 if(variante==2 || variante==0)
  {
   printf("auf CPU (%d Threads) leicht optimiert:\n",nt);
   for(int i=0;i<N*M;i++) Hwerte[i]=0; //Zielfeld loeschen
   stoppuhr_reset();
   calc_grauwerte(Rot,Gruen,Blau,Hwerte,true); //CPU-Code leicht optimiert
   int usec=stoppuhr_read();
   printf("Rechenzeit CPU (optimiert): ");
   zeit_print(usec,FLOP);
  }
 if(variante==3 || variante==0)
  {
   printf("Auf Grafikkarte mit OpenCL gerechnet:\n");
   for(int i=0;i<N*M;i++) Hwerte[i]=0; //Zielfeld loeschen
   copy_to_device(Rot,Gruen,Blau,Hwerte,N,M);
   bool ok=opencl_kernel_compilieren("beispiel2_kernel.cc");
   if(!ok) {printf("Fehler3: opencl_kernel_compilieren() misslungen.\n"); exit(1);}
   stoppuhr_reset();
   calc_opencl(Rot,Gruen,Blau,Hwerte,N,M);
   int usec=stoppuhr_read();
   copy_from_device(Hwerte,N*M);
   int usec2=stoppuhr_read();
   printf("Rechenzeit OpenCL: ");
   zeit_print(usec,FLOP);
   printf("   zurueckkopiert: ");
   zeit_print(usec2);
   device_speicher_freigeben();
  }
 if(variante==4 || variante==0)
  {
   printf("Auf Grafikkarte mit CUDA gerechnet:\n");
   for(int i=0;i<N*M;i++) Hwerte[i]=0; //Zielfeld loeschen
   copy_to_device_cuda(Rot,Gruen,Blau,Hwerte,N,M);
   stoppuhr_reset();
   calc_cuda(Rot,Gruen,Blau,Hwerte,N,M);
   int usec=stoppuhr_read();
   copy_from_device_cuda(Hwerte,N*M);
   int usec2=stoppuhr_read();
   printf(" Rechenzeit  CUDA: ");
   zeit_print(usec,FLOP);
   printf("   zurueckkopiert: ");
   zeit_print(usec2);
   device_speicher_freigeben_cuda();
  }
 print_feld(Hwerte); //Ergebnisse anzeigen
 //if(!qflag)
  { //Ergebnisse ueberpruefen:
   bool ok=true;
   float *Htest=new float[N*M];
   if(Htest==NULL) printf("Fehler: zu wenig RAM?\n");
   for(i=0;i<N*M;i++) Htest[i]=0;
   calc_grauwerte(Rot,Gruen,Blau,Htest,false);
   for(i=0;i<N*M;i++)
     if(!fastgleich(Hwerte[i],Htest[i])) {ok=false; break;}
   if(ok) printf("Ergebnisse erfolgreich ueberprueft.\n");
   else printf("Fehlerhafte Ergebnisse!\ni=%d: %f statt %f\n",i,Hwerte[i],Htest[i]);
   delete[] Htest;
  }
 return 0;
}

void print_feld(const float *feld)
{
 for(int i=0;i<4;i++) //erste Werte anzeigen
   printf(" %f",feld[i]);
 printf(" ...");
 for(int i=N-4;i<N;i++) //letzte Werte anzeigen
   printf(" %f",feld[(M-1)*N+i]);
 printf("\n");
}

void print_feld(const int *feld)
{
 for(int i=0;i<4;i++) //erste Werte anzeigen
   printf(" %d",feld[i]);
 printf(" ...");
 for(int i=N-4;i<N;i++) //letzte Werte anzeigen
   printf(" %d",feld[(M-1)*N+i]);
 printf("\n");
}

/****************************** Stoppuhr: ******************************/
#include <time.h>
#include <sys/time.h>
static struct timeval stoppuhr_tv0, stoppuhr_tv;
static struct timezone stoppuhr_tz0, stoppuhr_tz;

void stoppuhr_reset()
{
 gettimeofday(&stoppuhr_tv0,&stoppuhr_tz0);
}

int stoppuhr_read() //Zeit seit letztem stoppuhr_reset() in usec
{
 int usec,sec;
 gettimeofday(&stoppuhr_tv,&stoppuhr_tz);
 usec = stoppuhr_tv.tv_usec - stoppuhr_tv0.tv_usec;
 if((sec=stoppuhr_tv.tv_sec-stoppuhr_tv0.tv_sec)!=0) usec += sec*1000000;
 return usec;
}

void zeit_print(int usec,long flop)
{
 if(usec>=500000)
      printf("%d.%03d sec",usec/1000000,(usec/1000)%1000);
 else printf("%d.%03d ms",usec/1000,usec%1000);
 if(flop>0)
  {
   double gflops=flop/(usec*1e-6)/1e9;
   if(gflops<2)        printf("  (%.3f GFLOPS)\n",gflops);
   else if(gflops<200) printf("  (%.1f GFLOPS)\n",gflops);
   else                printf("  (%.0f GFLOPS)\n",gflops);
  }
 else printf("\n");
}
/**************************** Ende Stoppuhr ****************************/

bool fastgleich(float a,float b)
{
 const float fasteins=0.9999, guteins=1.0001;
 if(a==b) return true;
 if(a==0 || b==0) return false;
 double eins=a/b;
 return (eins>=fasteins && eins<=guteins);
}

int rup(int a,int b) //Aufrunden von a so dass durch b restlos teilbar
{
 return (a+b-1)/b*b;
}
