/* beispiel2_cuda.cu  CUDA Teil von Matrixmultiplikation */

#include <stdio.h>
#include "beispiel2.h"

__global__  //Kernel
void cuda_calc(const int*R,const int*G,const int*B,
               float*H,const int N,const int M)
{
 int i=blockDim.x*blockIdx.x+threadIdx.x;
 int j=blockDim.y*blockIdx.y+threadIdx.y;
 if(i<N && j<M)
  {
   int k=j*N+i;
   H[k] = (0.299/255)*R[k] + (0.587/255)*G[k] + (0.114/255)*B[k];
  }
}

/********************* allgemeine CUDA-Routinen *********************/
bool errcheck(const char *text)
{
 cudaError_t err=cudaGetLastError();
 if(err != cudaSuccess)
   fprintf(stderr, "%s %d: %s\n",text,err,cudaGetErrorString(err));
 return (err==cudaSuccess);
}
/********************************************************************/

int *d_r=NULL, *d_g=NULL, *d_b=NULL;
float *d_h=NULL;
static int size1=0;
static int size2=0;

bool copy_to_device_cuda(const int*R,const int*G,const int*B,float*H,int N,int M)
{
 size1 = N*M*sizeof(int);
 size2 = N*M*sizeof(float);
 cudaMalloc((void**)&d_r, size1);
 cudaMalloc((void**)&d_g, size1);
 cudaMalloc((void**)&d_b, size1);
 cudaMalloc((void**)&d_h, size2);
 if(d_r==NULL || d_g==NULL || d_b==NULL || d_h==NULL)
  {printf("Fehler1: konnte nicht genug CUDA-Speicher reservieren\n"); return false;}
 cudaMemcpy(d_r,R,size1,cudaMemcpyHostToDevice);
 cudaMemcpy(d_g,G,size1,cudaMemcpyHostToDevice);
 cudaMemcpy(d_b,B,size1,cudaMemcpyHostToDevice);
 cudaMemcpy(d_h,H,size2,cudaMemcpyHostToDevice);
 return errcheck("Fehler bei cudaMemcpy(d_mc,mc,size3,cudaMemcpyHostToDevice)");
}

bool copy_from_device_cuda(float *ziel,int n)
{
 cudaMemcpy(ziel,d_h,n*sizeof(int),cudaMemcpyDeviceToHost);
 return errcheck("Fehler bei cudaMemcpy() DeviceToHost");
}

int divup(int obe,int une) //Division aufgerundet
{
 return (obe+une-1)/une;
}

extern void calc_cuda(const int*R,const int*G,const int*B,float*H,int N,int M)
{
 if(d_h==NULL)
  {printf("Fehler1: zuerst copy_to_device_cuda() machen\n"); return;}
 dim3 threadsPerBlock(32,32); //bis x*y*z=1024 erlaubt
 dim3 nBlocks(divup(N,32),divup(M,32)); //bis x*y*z=65535 erlaubt
 cuda_calc<<<nBlocks,threadsPerBlock>>>(d_r,d_g,d_b,d_h,N,M);
 cudaDeviceSynchronize(); //auf Beenden aller Threads warten
 errcheck("Fehler3: Kernelaufruf misslungen");
}

extern void device_speicher_freigeben_cuda()
{
 cudaFree(d_r); d_r=NULL;
 cudaFree(d_g); d_g=NULL;
 cudaFree(d_b); d_b=NULL;
 cudaFree(d_h); d_h=NULL;
}
