/* beispiel2_opencl.cc */

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#define CL_TARGET_OPENCL_VERSION 120
#define __CL_ENABLE_EXCEPTIONS
#include <CL/cl.hpp>
#include "beispiel2.h"

//#define DEBUG

// Vordeklarationen von Hilfsroutinen:
void opencl_init();
int filelaenge(const char *name);
void datei_einlesen(const char *name,char *ziel);

// Statische OpenCL-Objekte:
cl::Device default_device;
cl::Context context;
cl::CommandQueue queue;
cl::Kernel kernel_calc;
cl::Buffer d_R,d_G,d_B,d_H; //Zeiger auf Felder auf dem Device
int size1=0; //Groesse der Felder R G B
int size2=0; //Groesse von Ergebnisfeld H

extern bool copy_to_device(const int*R,const int*G,const int*B,
			   float*H,int n,int m)
{
 opencl_init();
 size1 = n*m*sizeof(int);
 size2 = n*m*sizeof(float);
 try {
 d_R = cl::Buffer(context,CL_MEM_READ_WRITE,size1);
 d_G = cl::Buffer(context,CL_MEM_READ_WRITE,size1);
 d_B = cl::Buffer(context,CL_MEM_READ_WRITE,size1);
 d_H = cl::Buffer(context,CL_MEM_READ_WRITE,size2);
 } catch(cl::Error &error) {
  printf("Fehler1: konnte nicht genug Speicher reservieren\n");
  std::cout << error.what() << "(" << error.err() << ")" << std::endl;
  return false;
 }
 queue=cl::CommandQueue(context,default_device);
 try {
  queue.enqueueWriteBuffer(d_R,CL_TRUE,0,size1,R);
  queue.enqueueWriteBuffer(d_G,CL_TRUE,0,size1,G);
  queue.enqueueWriteBuffer(d_B,CL_TRUE,0,size1,B);
  queue.enqueueWriteBuffer(d_H,CL_TRUE,0,size2,H);
  return true;
 } catch(cl::Error &error) {
  printf("Fehler2: copy_to_device():\n");
  std::cout << error.what() << "(" << error.err() << ")" << std::endl;
  return false;
 }
}

extern bool copy_from_device(float *ziel,int n)
{
 try {
  queue.enqueueReadBuffer(d_H,CL_TRUE,0,n*sizeof(float),ziel);
  return true;
 } catch(cl::Error &error) {
  printf("Fehler3: copy_from_device():\n");
  std::cout << error.what() << "(" << error.err() << ")" << std::endl;
  return false;
 }
}

extern bool opencl_kernel_compilieren(const char *kernel_name)
{
 if(size1==0)
  {printf("Fehler5: kein Speicher auf dem Device reserviert.\n"); return false;}
 char *quellcode;
 int len=filelaenge(kernel_name)+1;
 if(len<=0)
  {printf("Fehler6: \"%s\" nicht gefunden\n",kernel_name); return false;}
 quellcode=new char[len];
#ifdef DEBUG
 if(quellcode==NULL) {printf("Fehler7: zu wenig RAM\n"); return false;}
#endif
 datei_einlesen(kernel_name,quellcode);
#ifdef DEBUG
 printf("-------------\neingelesene Datei:\n%s\n-------------\n",
	quellcode); //test: eingelesenen Kernel anzeigen
#endif
 std::string code=quellcode;
 delete[] quellcode;
 cl::Program::Sources sources;
 sources.push_back({code.c_str(),code.length()});
 cl::Program program(context,sources);
 try {
#ifdef DEBUG
 printf("program.build()\n");//test
#endif
 if(program.build({default_device})!=CL_SUCCESS)
  {printf("Fehler8\n"); return false;}
#ifdef DEBUG
 printf("program.build() fertig\n");//test
#endif
 } catch(cl::Error &error) {
  printf("Fehler9: ");
  std::cout << error.what() << "(" << error.err() << ")" << std::endl;
  return false;
 }
 kernel_calc=cl::Kernel(program,"calc");
#ifdef DEBUG
 printf("opencl_kernel_compilieren() erfolgreich\n");//test
#endif
 return true;
}

extern void calc_opencl(const int*R,const int*G,const int*B,float*H,int N,int M)
{
 if(size1==0)
  {printf("Fehler4: zuerst copy_to_device() machen\n"); return;}
#ifdef DEBUG
 printf("void calc_opencl()\n");//test
 printf("N=%d M=%d\n",N,M);//test
#endif
 try {
 kernel_calc.setArg(0,d_R);
 kernel_calc.setArg(1,d_G);
 kernel_calc.setArg(2,d_B);
 kernel_calc.setArg(3,d_H);
 kernel_calc.setArg(4,N);
 kernel_calc.setArg(5,M);
 
 queue.enqueueNDRangeKernel(kernel_calc, cl::NullRange,
			    cl::NDRange(rup(N,32),rup(M,32)), cl::NDRange(32,32));
 queue.finish();
 } catch(cl::Error &error) {
  printf("Fehler10: Kernelaufruf misslungen: ");
  std::cout << error.what() << "(" << error.err() << ")" << std::endl;
 }
#ifdef DEBUG
 printf("void calc_opencl() fertig\n");//test
#endif
}

extern void device_speicher_freigeben()
{
#ifdef DEBUG
 printf("device_speicher_freigeben()\n");//test
#endif
}

// immer gleiche OpenCL Routinen:
void opencl_init()
{
 //get all platforms (drivers)
 std::vector<cl::Platform> all_platforms;
 cl::Platform::get(&all_platforms);
 if(all_platforms.size()==0)
  {std::cout<<" No platforms found. Check OpenCL installation!\n"; exit(1);}
 cl::Platform default_platform=all_platforms[0];
 //get default device of the default platform
 std::vector<cl::Device> all_devices;
 default_platform.getDevices(CL_DEVICE_TYPE_ALL, &all_devices);
 std::cout << "Using platform: "<<default_platform.getInfo<CL_PLATFORM_NAME>()<<"\n";
 if(all_platforms.size() > 1)
  {
   printf("Weitere platforms:\n");
   for(unsigned int i=1;i<all_platforms.size();i++)
    std::cout << ' ' << i << ": "<<all_platforms[i].getInfo<CL_PLATFORM_NAME>()<<"\n";
  }
 if(all_devices.size()==0)
  {std::cout<<" No devices found. Check OpenCL installation!\n"; exit(1);}
 default_device=all_devices[0];
 std::cout<< "Using device: "<<default_device.getInfo<CL_DEVICE_NAME>()<<"\n";
 if(all_devices.size() > 1)
  {
   printf("Weitere devices:\n");
   for(unsigned int i=1;i<all_devices.size();i++)
    std::cout << ' ' << i << ": "<<all_devices[i].getInfo<CL_DEVICE_NAME>()<<"\n";
  }
 context=cl::Context({default_device});
}
// Ende der OpenCL Routinen.

/*************************** kleinkram ***************************/
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
const int BLOCKS=0, BYTES=1, BSIZE=2;

int filelaenge(const char *name,int flag=BSIZE)
{
 struct stat buf;
 int n;
 if(lstat(name,&buf)<0) return -1;
 if(!S_ISREG(buf.st_mode)) return -2;
//fuer Inhalt von buf siehe "man lstat"
 if(flag==BLOCKS) n=buf.st_blocks;
 else if(flag==BSIZE) n=buf.st_blksize;
 else n=buf.st_size;
 return n;
}

int filelaenge(const char *name) {return filelaenge(name,BSIZE);}

int index(const char *s1,const char *s2)
{	             /* Sucht den String s2 innerhalb von s1           */
 int i,c;	     /* und gibt Position zurueck (nicht gefunden: -1) */
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c=0;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

void datei_einlesen(const char *name,char *ziel)
{
 char zeile[200];
 const char *s;
 int c;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("konnte \"%s\" nicht oeffnen\n",name); *ziel=0; return;}
 while(getline(fp,zeile,200))
  {
   for(s=zeile;*s==' ' || *s=='\t';s++) {}//Leerzeichen ueberlesen
   if(s[0]==0) continue; //Leerzeilen ueberlesen
   if(strncmp(s,"//",2)==0) continue; //Kommentare ueberlesen
   if(index(s,"//nur zum mit gcc testen") > 0) continue;//testzeilen ueberlesen
   if(strncmp(s,"#include \"",10)==0)
    { //#include "name.h" --> name.h einfuegen
     char *t;
     for(t= &zeile[10];*t!='"' && *t!=0;t++) {} //Endzeichen " suchen
     *t=0; //Endzeichen durch 0 ersetzen
     datei_einlesen(&zeile[10],ziel);
     while(*ziel!=0) ziel++;
     continue;
    }
   for(int i=0;(c=zeile[i])!=0 && (c!='/' || zeile[i+1]!='/');i++)
     *ziel++ = c; //Zeile kopieren, aber Kommentare weglassen
   *ziel++ = '\n';
  }
 *ziel=0;
 fclose(fp);
}
/************************ ende kleinkram *************************/
