#ifdef CHECK
#include "kernelcheck.h"
#endif

#ifdef NUR_OPTIONEN
#define OPTIMIERUNG 1
#else

__kernel void hello(__global const float *A,__global const float *B,
		    __global float *C,const int X,const int Y)
{
 int x0=get_local_id(0);
 int x=get_global_id(0);
 const int TPB=get_local_size(0);
 __local float Blocal[1024]; //lokaler Speicher pro Block (max.48KB)
 float sum=0;
 int y;
 for(y=0;y<Y-TPB;y+=TPB)
  {
   Blocal[x0]=B[y+x0]; //aktuellen Teil von B in lokalen Speicher kopieren
   barrier(CLK_LOCAL_MEM_FENCE); //Warten bis alle Threads fertig
   for(int yb=0;yb<TPB;yb++)
      {
       sum += A[x]*Blocal[yb]; //B nur noch aus lokalem Speicher lesen
      }
   barrier(CLK_LOCAL_MEM_FENCE);
  }
 Blocal[x0]=B[y+x0]; //letzter Teil von B in lokalen Speicher kopieren
 barrier(CLK_LOCAL_MEM_FENCE);
 for(int yb=0;y+yb<Y;yb++)
  {
   sum += A[x]*Blocal[yb]; //B nur noch aus lokalem Speicher lesen
  }
 if(x<X) C[x] = sum;
}

#endif
