#ifdef CHECK
#include "kernelcheck.h"
#endif

#ifdef NUR_OPTIONEN
#define OPTIMIERUNG 1
#else

#define YMAX 12000 //maximal (48*1024/4) moeglich

__kernel void hello(__global const float *A,__global const float *B,
		    __global float *C,const int X,const int Y)
{
 int x0=get_local_id(0);
 //int x=get_global_id(0);
 int x=get_group_id(0)*1024+x0; //gleiches Resultat wie get_global_id(0)

 __local float Blocal[YMAX]; //lokaler Speicher pro Block (max.48KB)
 int ymax=(YMAX<Y)?YMAX:Y;
 for(int y=x0;y<ymax;y+=1024)
  {
   Blocal[y]=B[y]; //gemeinsam gesamtes B in lokalen Speicher kopieren
  }
 barrier(CLK_LOCAL_MEM_FENCE); //Warten bis alle Threads fertig mit
                               //speichern im lokalen Speicher.
 if(x<X)
  {
   float sum=0;
   float areg=A[x];
   for(int y=0;y<ymax;y++)
     sum += areg*Blocal[y]; //nur noch aus lokalem Speicher lesen
   
   for(int y=ymax;y<Y;y++) //falls Y groesser als YMAX ist, dann
     sum += areg*B[y];     //restliche Werte noch aus globalem Speicher
   
   C[x] = sum;
  }
}

#endif
