/* hello.cc  HelloWorld fuer OpenCL
Multiplikation von 2 Zahlenfeldern
Beschreibung auf http://www.rolfp.ch/computer/parallelprogramme/teil3.html
*/

#include <stdio.h>
#include <thread>
#include "hello.h"
#include "myopencl.h"

#define OPTIMIERUNG 0  // 0=ohne Optimierung, 5=staerkste Optimierung
//#define DEBUG

#if(OPTIMIERUNG==0)
static char kernel_name[200]="hello_kernel.cc";
#elif(OPTIMIERUNG==5)
static char kernel_name[200]="hello_kernel-opt5.cc";
#else
#error "weiter Optimierungen siehe teil3.html"
#endif

#define XMAX 100000
#define YMAX 12000
#define ZMAX XMAX

#define FLOP (2L*XMAX*YMAX) //soviele "Floating OPerations" werden gebraucht

// Serielle Variante:
void hello_calc(const float *A,const float *B,float *C,int X,int Y)
{
 for(int x=0;x<X;x++)
  {
   float sum=0;
   for(int y=0;y<Y;y++)
     sum += A[x]*B[y];
   C[x] = sum;
  }
}

int main(int argc,char **argv)
{
 int i;
 bool ok=true;
 float *ma,*mb,*mc; //Felder A B C
 ma = new float[XMAX]; //Feld A
 mb = new float[YMAX]; //Feld B
 mc = new float[ZMAX]; //Resultat-Feld
 for(i=0;i<XMAX;i++)
   ma[i] = (random()&0xFFFF)/float(0xFFFF)*10; //Zufallszahl zwischen 0 und 10
 for(i=0;i<YMAX;i++)
   mb[i] = (random()&0xFFFF)/float(0xFFFF)*10; //Zufallszahl zwischen 0 und 10
 for(i=0;i<ZMAX;i++) mc[i]=0; //Zielfeld loeschen
 printf("%d Zufallszahlen erstellt.\n",XMAX+YMAX);

 printf("\nAuf Grafikkarte mit OpenCL gerechnet:\n");
 for(i=0;i<ZMAX;i++) mc[i]=0; //Zielfeld loeschen
 copy_to_device(ma,mb,mc,XMAX,YMAX,ZMAX);
 ok=kernel_compilieren(kernel_name);
 if(!ok) {printf("Fehler3: kernel_compilieren() misslungen.\n"); exit(1);}
 stoppuhr_reset();
 ok=kernel_aufrufen(OPTIMIERUNG);
 if(ok)
  {
   int usec=stoppuhr_read();
   copy_from_device(mc,ZMAX);
   int usec2=stoppuhr_read();
   printf("Rechenzeit mit OpenCL: "); zeit_print(usec,FLOP);
   printf("  mit zurueckkopieren: "); zeit_print(usec2);
  }
 device_speicher_freigeben();
 if(ok)
  {
   printf("\nErgebnisfeld: "); //einige Ergebnisse anzeigen
   for(int i=0;i<3;i++) printf("%f ",mc[i]);
   printf(".... ");
   for(int i=ZMAX-3;i<ZMAX;i++) printf("%f ",mc[i]);
   printf("\n");
   //Ergebnisse ueberpruefen:
   float *mtest=new float[ZMAX];
   for(i=0;i<ZMAX;i++) mtest[i]=0; //neues Zielfeld loeschen
   hello_calc(ma,mb,mtest,XMAX,YMAX);
   for(i=0;i<ZMAX;i++)
    if(!fastgleich(mc[i],mtest[i]))
     {printf("Differenz an Position %d: %f statt %f\n",i,mc[i],mtest[i]);
      ok=false; break;
     }
   if(ok) printf("Ergebnisse erfolgreich ueberprueft.\n");
   else  {printf("Fehlerhafte Ergebnisse!\n");}
   delete[] mtest;
  }
 delete[] ma;
 delete[] mb;
 delete[] mc;
 return 0;
}

/****************************** Kleinkram ******************************/
bool fastgleich(float a,float b)
{
 const float fasteins=0.9999, guteins=1.0001;
 if(a==b) return true;
 if(a==0 || b==0) return false;
 double eins=a/b;
 return (eins>=fasteins && eins<=guteins);
}

/****************************** Stoppuhr: ******************************/
#include <time.h>
#include <sys/time.h>
static struct timeval stoppuhr_tv0, stoppuhr_tv;
static struct timezone stoppuhr_tz0, stoppuhr_tz;

void stoppuhr_reset()
{
 gettimeofday(&stoppuhr_tv0,&stoppuhr_tz0);
}

int stoppuhr_read() //Zeit seit letztem stoppuhr_reset() in usec
{
 int usec,sec;
 gettimeofday(&stoppuhr_tv,&stoppuhr_tz);
 usec = stoppuhr_tv.tv_usec - stoppuhr_tv0.tv_usec;
 if((sec=stoppuhr_tv.tv_sec-stoppuhr_tv0.tv_sec)!=0) usec += sec*1000000;
 return usec;
}

void zeit_print(int usec,long flop)
{
 if(usec>=500000)
      printf("%d.%03d sec",usec/1000000,(usec/1000)%1000);
 else printf("%d.%03d ms",usec/1000,usec%1000);
 if(flop>0)
  {
   double gflops=flop/(usec*1e-6)/1e9;
   if(gflops<2)        printf("  (%.3f GFLOPS)\n",gflops);
   else if(gflops<200) printf("  (%.1f GFLOPS)\n",gflops);
   else                printf("  (%.0f GFLOPS)\n",gflops);
  }
 else printf("\n");
}
/**************************** Ende Stoppuhr ****************************/
