/* tropf.cc			letzte nderung: 20.6.2004 */
#define VERSION "Version 0.0"
/*
Simulation des "Schwarzen Tropfens"

History:
20.6.2004	Erstellung (RP)
*/

#include <stdio.h>
#include <stream.h>
#include <stdlib.h>
#include <math.h>
#include <xtekplot1.h>
#include <vektorklasse.cc>

/************************* Vordeklarationen ***************************/
void tropf();

/************************* Men Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_para();

/***************************** Klassen ********************************/
class Fenster
{
 int maxcol;
 int breite,hoehe,tiefe,visklasse; //Fenstergroesse
 double xmin,ymin,xmax,ymax; //Userkoordinaten
 double bx,hy; //Schriftgroessen
public:
 Fenster(char*,int b=12500,int h=10000,int t=24);
 ~Fenster();
 int run(char *text=NULL);
};
Fenster::Fenster(char *name,int br,int ho,int ti)
{
 exitflag=0;
 xmin= -0.1; ymin=0.; xmax=1.1; ymax=1.;
 bx=(xmax-xmin)/100; hy=(ymax-ymin)/40;
 //tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>br) breite=br;
 if(hoehe>ho) hoehe=ho;
 if(tiefe>ti) tiefe=ti;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(1,"File");
 setmenu(1,"Parameter ...",&m_para);
 setmenu(1,"Exit",&m_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 set_tektitel(name);
 screenclear(1); color(0);
 term_refresh();
}
Fenster::~Fenster()
{
 term_exit();
}

/************************* Hauptprogramm ******************************/
const int imax=1024,jmax=768;

main(int argc,char *argv[])
{
 int ok;
 char fenstername[80];
 if(argc>1 && *argv[1]=='?')
	{printf("tropf  %s\n",VERSION);
	 exit(0);
	}
 sprintf(fenstername,"tropf  %s",VERSION);
 {
  Fenster gross(fenstername,imax,jmax,8);
  ok=gross.run();
 }
 return ok;
}/* ende von main */

int Fenster::run(char *text)
{
 int col=0,grau,ok=1;
 inital_new();
 screenclear(0);
 for(col=1;col<=255;col++)
  {grau=col;
   setcolor(col,grau,grau,grau);
  }
 tropf();
 term_refresh();
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
 return ok;
}

/*************************** kleinkram ***************************/
//const double PI=4*atan(1.0);
//const double ZWEIPI=2*PI;
inline int round(double x) {return (int)((x>=0.) ? x+0.5 : x-0.5);}
inline double abs(double x) {return (x<0.) ? -x : x;}	/* Betrag */
inline int imin(int a,int b) {return a<b ? a : b;}
inline double sq(double x) {return x*x;}	/* Quadrieren */
inline long idfix(double x) {return (x>=0.) ? x+0.5 : x-0.5;} /* Runden */
double xhochn(double x,int n)	/* Potenzieren mit Ganzzahligem Exponenten */
{
 double z=1.0;
 if(n>=0)
   while(n>0)
        {if(n&1) {z*=x; n--;}
         else    {x*=x; n=(n>>1);}
        }
 else
        z=1.0/xhochn(x,-n);
 return z;
}
/*************************** kleinkram ***************************/
class Pixel
{
 int xyfeld[imax][jmax];
public:
 Pixel() {int i,j; for(i=0;i<imax;i++) for(j=0;j<jmax;j++) xyfeld[i][j]=0;}
 void put(int,int,int);
 int get(int x,int y) {return (x<0 || x>=imax || y<0 || y>=jmax)
                              ? 0 : xyfeld[x][y];}
};
static Pixel pixel;

void Pixel::put(int x,int y,int farbe)
{
 if(x>=0 && x<imax && y>=0 && y<jmax)
    {xyfeld[x][y]=farbe;
     if(farbe>255) farbe=255;
     else if(farbe<1) farbe=1;
     ipunkt(x,y,farbe);
    }
}

inline void putpixel(int x,int y,int farbe) {pixel.put(x,y,farbe);}
inline int getpixel(int x,int y) {return pixel.get(x,y);}

static double unschaerfe=2,venusradius=12,schrittweite=1;
static int kontrast=1;

void m_para()
{
 int ok;
 ok=requester_input(4,"unschaerfe","%lf","%lf\n",&unschaerfe,
		    "venusradius","%lf","%lf\n",&venusradius,
		    "schrittweite","%lf","%lf\n",&schrittweite,
		    "Kontrast (1...3)","%d","%d",&kontrast);
 if(ok)
     {inital_new();
      screenclear(0);
      tropf();
      term_refresh();
     }
}

double fx(double x)
{
 double h=unschaerfe,zweih=2*h;
 if(x >= zweih) return 1.0;
 if(x <= -zweih) return 0.0;
 double y,k=0.5/(zweih*zweih);
 if(x<0) y=k*sq(x+zweih);
 else y=1.0-k*sq(x-zweih);
 return y;
}

void tropf()
{
 double r=venusradius,R=360,h,alfa,a;
 int i,j,k;
 vektor sonne(imax/2.0,jmax/2.0+10),venus[16],p;
 for(k=0,alfa=0;k<16;k++,alfa+=PI/8)
    {a=R-r-(k-8)*schrittweite;
     venus[k]=sonne+vektor(cos(alfa)*a,sin(alfa)*a);
    }
 for(i=0;i<imax;i++)
 for(j=0;j<jmax;j++)
   {p.x=i; p.y=j;
    h=xhochn(fx(R-abs(p-sonne)),kontrast);
    for(k=0;k<16;k++)
	h *= xhochn(fx(abs(p-venus[k])-r),kontrast);
    putpixel(i,j,idfix(255*h));
   }
}
