/* Filelaenge.cc */
/*
  Bestimmung der Lnge einer Datei

Auf VAX:
@LINK filelaenge,SYS$INPUT/OPT
SYS$SHARE:DECW$XLIBSHR/SHARE
*/

#include <stdio.h>
#include <ctype.h>
#include <math.h> //test
//#include <ulong.h>

const int BLOCKS=0, BYTES=1, BSIZE=2;
int filelaenge(char *name,int flag);  // odeer flag=BYTES

int main(int argc,char *argv[])
{
  int nbytes,nblocks,blockgroesse,i;
 char filename[80];
 //printf("Wurzel von 2 ist %f\n",sqrt(2));//test
 for(i=0;i<=10;i++)  printf("sqrt(%f) = %f\n",i*0.1,sqrt(i*0.1));//test
 if(argc>=2) sscanf(argv[1],"%s",filename);
 else {printf("File:"); i=scanf("%s",filename);}
 nblocks=filelaenge(filename,BLOCKS);
 blockgroesse=filelaenge(filename,BSIZE);
 printf("Die Datei '%s' hat %d Blocks. (Blockgroesse=%d)\n",
	filename,nblocks,blockgroesse);
 nbytes=filelaenge(filename,BYTES);
 printf(" und ist %d Bytes lang.\n",nbytes);
 printf("System ist '%s'\n",
#ifdef unix
	"unix"
#elif VAX
	"VAX"
#else
	"unbekannt"
#endif
       );
 return 0;
}/* ende von main */

#undef FILELAENGE

#ifdef unix
#include <sys/types.h>
#include <sys/stat.h>
//#include <ourhdr.h>

int filelaenge(char *name,int flag)
{
 struct stat buf;
 int n;
 if(lstat(name,&buf)<0) return -1;
 if(!S_ISREG(buf.st_mode)) return -2;
//fuer Inhalt von buf siehe "man lstat"
 if(flag==BLOCKS) n=buf.st_blocks;
 else if(flag==BSIZE) n=buf.st_blksize;
 else n=buf.st_size;
 return n;
}
#define FILELAENGE 1
#endif

#ifndef FILELAENGE
// auf unbekanntem System

int filelaenge(char *name,int flag)
{
 char str[80];
 FILE *fp;
 int n,c;
 const int blockgroesse=512; //Vermutung
 if(flag==BSIZE) return blockgroesse;
 if(!(fp=fopen(name,"rb"))) return -1;
 for(n=0;(c=getc(fp))!=EOF;n++)  ;
 fclose(fp);
 if(flag==BLOCKS) n=(n+blockgroesse-1)/blockgroesse;
 return n;
}
#endif
