/* astart.cc			letzte Aenderung: 14.1.2010 */
#define VERSION "Version 0.0"
// astart ueberall durch Programmname ersetzen !!
/*
Uebersetzen auf VAX/ALPHA:
;AVAX> cx astart
;AVAX> blink astart
;AVAX> pur astart.exe

Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: allgemeines Musterprogramm fuer C++

History:
1.1.2012	Erstellung (RP)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h> //test

/************************* Vordeklarationen ***************************/
void unterprog(FILE *fp1,FILE *fp2);

/************************* Globale Variablen **************************/
static int workbenchflag=0;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}
void showargflags()
{
 int i;
 printf("folgende Flags gesetzt:");
 for(i=0;i<128;i++)
   if(argflag[i])
	{printf(" %d",i);
	 if(i>' ' && i<127) printf("='%c'",i);
	}
 printf("\n");
}

/*************************** Kleinkram ********************************/
bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

/************** Klassen und Hauptteil des Programms *******************/

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c;
 printf("Wurzel von 3 ist %f\n",sqrt(3));//test
 for(i=0;i<=10;i++)
   printf("exp(%f) = %f\n",i*0.1,exp(i*0.1));//test
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
   workbenchflag=1;
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 if(argflag['?'] || j>MAXARG)
	{printf("astart  %s\n",VERSION);
	 printf("Anwendung: astart Quelle [Ziel]\n");
	 exit(0);
	}
 showargflags();
 if(*quellname==0) {printf("Quellname:"); i=scanf("%s",quellname);}
 if(*zielname==0)  {printf("Zielname:"); i=scanf("%s",zielname);}
 if(fp1=fopen(quellname,"r")) printf("Datei '%s' vorhanden\n",quellname);
 else printf("Datei '%s' nicht vorhanden\n",quellname);
 if(fp2=fopen(zielname,"r"))
  printf("Datei '%s' schon vorhanden\n",zielname);
 else if(fp2=fopen(zielname,"w"))
  {printf("Datei '%s' erfolgreich erstellt.\n",zielname);
  }
 else printf("Datei '%s' nicht vorhanden\n",zielname);
 if(fp1!=NULL && fp2!=NULL) unterprog(fp1,fp2);
 if(fp1) fclose(fp1);
 if(fp2) fclose(fp2);
 return 0;
}/* ende von main */

void unterprog(FILE *fp1,FILE *fp2)
{
 int c;
 printf("Datei wird kopiert\n");
 while((c=getc(fp1))!=EOF) putc(c,fp2);
}
