;; glcd.asm  Grafik-LCD-Modul ansteuern  letzte Aenderung: 14.9.2010
;; ausprobiert mit folgendem Modul: TG12864B-05 (Pollin 120423)
;; Anwendung: .include "glcd.asm" im Hauptprogramm

;; GLCD-Port definieren:
.equ LCD_PORT = PORTD
.equ LCD_DDR  = DDRD
.equ DI  = 2
.equ RW  = 3
.equ EN  = 4
.equ CS1 = 5
.equ CS2 = 6
.equ RST = 7
;Das nachfolgende Programm geht davon aus dass CS2 um 1 hoeher ist als CS1,
;ansonsten koennte man die Pins auch anders anschliessen.
;; GLCD-Datenport:
.equ LCD2_PORT = PORTC
.equ LCD2_PIN  = PINC
.equ LCD2_DDR  = DDRC

;; Daten die in c global mit static definiert sind:
;.equ glcd_datenA=SRAMSTART+x	 ;im Hauptprogramm machen
;.equ glcd_datenA=SRAMSTART+x+20 ;im Hauptprogramm machen
;.equ glcd_datenA=SRAMSTART     ;oder falls sonst kein SRAM benutzt wird.
.equ glcd_cs = glcd_datenA	;static char glcd_cs;
.equ glcd_x0 = glcd_datenA+1
.equ glcd_y0 = glcd_datenA+2	;static uchar glcd_x0=0, glcd_y0=0;
;; bei mehr als 20 Bytes: im Hauptprogramm glcd_datenB anpassen

glcd_init1:			;Vom Hauptprogramm vor sei aufzurufen
	push r16
	in r16, LCD_DDR
	ori r16, 0xFC
	out LCD_DDR, r16	;Steuer-Port mindestens obere 6 Bits Ausgaenge
	in r16, LCD_PORT
	andi r16, 3
	ori r16, 0xE0
	out LCD_PORT, r16	;RST,CS1,CS2 auf H; E,R/W,D/I auf L
	pop r16
	ret
glcd_init:	;Vom Hauptprogramm falls nicht init1, init nach sei aufrufen
	cli
	rcall glcd_init1
	sei
glcd_init2:			;Vom Hauptprogramm nach sei aufzurufen
	push r16
	push r17
	clr r16
	sts glcd_x0, r16
	sts glcd_y0, r16	;Initialisierung der static-Variablen
	clr r16
	out LCD2_DDR, r16	;Daten-Port auf Eingang
	cbi LCD_PORT, RST	;Reset ausfuehren (RST ist L-aktiv)
	ldi r16, 10
	rcall microwait		;etwa 10usec warten
	sbi LCD_PORT, RST	;RST-Bit wieder auf H
	ldi r16, CS1
	rcall glcd_wait		;auf Bereitschaft von CS1 warten
	ldi r16, CS2
	rcall glcd_wait		;auf Bereitschaft von CS2 warten
	ldi r17, 0x3F
	ldi r16, CS1
	rcall glcd_command	;Display ON
	ldi r16, CS2
	rcall glcd_command	;Display ON
	clr r16
	rcall glcd_clear
	pop r17
	pop r16
	ret

select_cs1_or_cs2:	; r16=cs
	;; if(cs==CS1) LCD_PORT &= ~(1<<CS1); else LCD_PORT &= ~(1<<CS2);
	cpi r16, CS1
	brne lcd_s1
	cbi LCD_PORT, CS1
	ret
lcd_s1:	cbi LCD_PORT, CS2
	ret

select_cs1_or_cs2_off:	; r16=cs
	;; if(cs==CS1) LCD_PORT |= (1<<CS1); else LCD_PORT |= (1<<CS2);
	cpi r16, CS1
	brne lcd_s2
	sbi LCD_PORT, CS1
	ret
lcd_s2:	sbi LCD_PORT, CS2
	ret

glcd_wait:		; r16=cs
	push r17	;char a;
	clr r17
	out LCD2_DDR, r17	;Daten-Port auf Eingang
	cbi LCD_PORT, DI	;Instruction 
	sbi LCD_PORT, RW	;Read
glcd_wait_1:
	rcall select_cs1_or_cs2
	sbi LCD_PORT, EN	;Enable
	rcall microwait1
;	rcall microwait10	; test
	in r17, LCD2_PIN	;a=LCD2_PIN
	cbi LCD_PORT, EN	;Enable aus
	rcall microwait1	; test
	rcall select_cs1_or_cs2_off
;	rcall microwait10	; test
	andi r17, 0x80		;while((a & 0x80)!=0);
	brne glcd_wait_1
	pop r17
	ret

glcd_command:		;r17=a, r16=cs
	sts glcd_cs, r16	;glcd_cs=cs
	cbi LCD_PORT, DI	;Instruction
glcd_comm1:		;r17=a
	push r16
	cbi LCD_PORT, RW	;Write
	ldi r16, 0xFF
	out LCD2_DDR, r16	;Port A auf Ausgang
	out LCD2_PORT, r17	;PORTA=a
	lds r16, glcd_cs
	rcall select_cs1_or_cs2
	rcall microwait1
	sbi LCD_PORT, EN	;Enable
	rcall microwait1
	cbi LCD_PORT, EN	;Enable aus
	rcall select_cs1_or_cs2_off
	rcall glcd_wait
	pop r16
	ret
glcd_data:		;r17=a
	sbi LCD_PORT, DI	;Instruction
	rjmp glcd_comm1

glcd_readdata:		; Resultat: r16
	push r18		; unsigned char a;
	sbi LCD_PORT, DI	;Data
	sbi LCD_PORT, RW	;Read
	ldi r18, 0x00
	out LCD2_DDR, r18	;Port A auf Eingang
	lds r16, glcd_cs
	rcall select_cs1_or_cs2
	rcall microwait1
	sbi LCD_PORT, EN	;Enable
	rcall microwait1
	in r18, LCD2_PIN
	cbi LCD_PORT, EN	;Enable aus
	rcall select_cs1_or_cs2_off
	rcall glcd_wait
	mov r16, r18		; return a;
	pop r18
	ret

glcd_clear:			; r16=farbe
	push r17
	push r18
	push r19
	push r20
	tst r16
	breq glcd_c1
	ldi r16, 0xFF		; if(farbe!=0) farbe=0xFF;
glcd_c1:mov r18, r16		; r18=farbe
;	ldi r18, 0x0F	;//farbe=0x0F;//test: Teststreifen beim Einschalten
	ldi r16, CS1	;for(cs=CS1;cs<=CS2;cs+=CS2-CS1)
glcd_c2:ldi r17, 0x40
	rcall glcd_command	;glcd_command(0x40,cs); //y-Start
;	rcall microwait10	;test
	clr r19		;for(x=0;x<8;x++)
glcd_c3:ldi r17, 0xB8
	add r17, r19
	rcall glcd_command	;glcd_command(0xB8+x,cs); //x-Start
;	rcall microwait10	;test
	ldi r20, 64	; for(i=0;i<64;i++) glcd_data(farbe);
glcd_c4:mov r17, r18
	rcall glcd_data
;	rcall microwait10	;test
	dec r20
	brne glcd_c4
	inc r19		;x++  //Ende der 2.for-Schlaufe
	cpi r19, 8	;x<8
	brne glcd_c3	;ja-->
	inc r16		;cs+=CS2-CS1 //Ende der 1.for-Schlaufe
	cpi r16, CS2+1	;cs<=CS2
	brcs glcd_c2	;ja-->
	pop r20
	pop r19
	pop r18
	pop r17
	ret

glcd_punkt:		;r16=x r17=y r18=farbe //(char x,char y,char farbe)
	push r16		; spaeter: r16=cs
	push r17		; r17=parameter fuer glcd_command()
	push r18		; r18=farbe, r18=a
	push r19		; r19=x
	push r20		; r20=maske
	push r21		; r21=y
	ldi r21, 63
	sub r21, r17		; y=63-y;
	mov r17, r21
	andi r17, 7
	inc r17
	clr r20
	sec
glcd_p1:rol r20			; maske = 1<<(y&7);
	dec r17
	brne glcd_p1
	asr r21
	asr r21
	asr r21			; y >>= 3;
	mov r19, r16		;r19=x
	ldi r16, CS2		; vorgezogenes else cs=CS2;
	cpi r19, 64
	brcs glcd_p2		; if(x>=64) {cs=CS1; x-=64;}
	subi r19, 64
	ldi r16, CS1
glcd_p2:ldi r17, 0x40
	add r17, r19
	rcall glcd_command	; glcd_command(0x40+x,cs); //y-Start
	ldi r17, 0xB8
	add r17, r21
	rcall glcd_command	; glcd_command(0xB8+y,cs); //x-Start
	push r16
	rcall glcd_readdata	; glcd_readdata();//dummy-read
	rcall glcd_readdata	; a=glcd_readdata();
	tst r18
	brne glcd_p3		; if(farbe==0) a &= ~maske; //Pixel loeschen
	mov r17, r20
	com r17
	and r16, r17
	rjmp glcd_p5
glcd_p3:cpi r18, 1		; else if(farbe==1) a |= maske; //Pixel setzen
	brne glcd_p4
	or r16, r20
	rjmp glcd_p5
glcd_p4:eor r16, r20		; else a ^= maske; //sonst Pixel umkehren
glcd_p5:mov r18, r16
	pop r16
	ldi r17, 0x40
	add r17, r19
	rcall glcd_command	; glcd_command(0x40+x,cs); //y-Start
	mov r17, r18
	rcall glcd_data		; glcd_data(a);
	pop r21
	pop r20
	pop r19
	pop r18
	pop r17
	pop r16
	ret

;;	const int fontbreite=6, fonthoehe=8;
.equ fontbreite = 6
.equ fonthoehe  = 8
.include "6x8_vertikal_LSB_1a.asm"
;font:
;.db 0x00,0x00,0x00,0x00,0x00,0x00,	; 0x00
;.db 0x00,0x3E,0x45,0x51,0x45,0x3E,	; 0x01
;...
;.db 0x00,0x00,0x42,0x7F,0x40,0x00,	; 0x31
;...
;.db 0x00,0x3C,0x26,0x23,0x26,0x3C	; 0x7F

glcd_writec:	; r16=ASCII-Zeichen
	push r16	; spaeter als cs benutzt  ; char cs,i;
	push r17	; r17=parameter fuer glcd_command()
	push r18	; r18=i
	push r19	; r19=x  ; int ypage,x
	push r20	; r20=c
	push r21	; r21=ypage
	push ZL
	push ZH
	mov r20, r16
	lds r21, glcd_y0
	lsr r21
	lsr r21
	lsr r21			; ypage=glcd_y0/8;
	andi r20, 0x7F		; c &= 0x7F;
	lds r19, glcd_x0
	ldi r16, CS2
	cpi r19, 64		; if(glcd_x0<64) {cs=CS2; x=glcd_x0&0x3F;}
	brcs glcd_w1
	ldi r16, CS1
	subi r19, 64		; else {cs=CS1;  x=(glcd_x0-64)&0x3F;}
glcd_w1:andi r19, 0x3F
	ldi r17, 0xB8
	add r17, r21		; glcd_command(0xB8+ypage,cs);
	rcall glcd_command	; //x-Start (senkrecht auf Display)
	ldi r17, 0x40
	add r17, r19		; glcd_command(0x40+x,cs);
	rcall glcd_command	; //y-Start (waagrecht auf Display)
	clr r18			; for(i=0;i<fontbreite;i++)
	rjmp glcd_w3
glcd_w2:lds r17, glcd_x0
	add r17, r18
	cpi r17, 64
	brne glcd_w3		;  {if(i>0 && glcd_x0+i==64)
	ldi r17, 0xC0		;    {//Wechsel auf rechte Display-Haelfte
	rcall glcd_command	;     glcd_command(0xC0,cs); //Display-Data
	ldi r17, 0xB8
	add r17, r21
	ldi r16, CS1		;     glcd_command(0xB8+ypage,cs=CS1);
	rcall glcd_command	;                            //x-Start=ypage
	ldi r17, 0x40
	rcall glcd_command	;     glcd_command(0x40,cs); //y-Start = 0
glcd_w3:			;    }
	rcall font_c_i
	rcall glcd_data		;   glcd_data(font[c][i]);
	inc r18			;  }
	cpi r18, fontbreite
	brne glcd_w2
	lds r17, glcd_x0
	subi r17, -fontbreite	; glcd_x0 += fontbreite;
	andi r17, 127		; auf kleiner 128 beschraenken
	sts glcd_x0, r17
	ldi r17, 0xC0
	rcall glcd_command	; glcd_command(0xC0,cs); //Display-Data
;ist im c-Programm ev. falsch:	; if(glcd_x0==128) glcd_x0=0;
;vermutlich besser:		; if(glcd_x0>=128) glcd_x0-=128;
;oder vielleicht:		; if(glcd_x0>=128) glcd_x0=0;
	pop ZH
	pop ZL
	pop r21
	pop r20
	pop r19
	pop r18
	pop r17
	pop r16
	ret

font_c_i:	; r20=c, r18=i, Ergebnis=r17=font[c][i], ZH:ZL zerstoert
	ldi ZL, low(font<<1)
	ldi ZH, high(font<<1)
	ldi r17, fontbreite
font_1:	add ZL, r20
	brcc font_2
	inc ZH
font_2:	dec r17
	brne font_1		; Z += fontbreite*c
	add ZL, r18
	adc ZH, r17		; Z += i
	lpm r17, Z
	ret

glcd_goto:	; r16=row=Zeile, r17=col=Spalte
	push r16
	push r17
	push r18
	push r19
	clr r19
	ldi r18, fontbreite
glcd_g1:add r19, r17
	dec r18
	brne glcd_g1		; col*fontbreite
	andi r19, 127
	sts glcd_x0, r19	; glcd_x0=(col*fontbreite) & 127;
	lsl r16
	lsl r16
	lsl r16			; r16 *= 8  (weil fonthoehe==8 ist)
	andi r16, 63
	sts glcd_y0, r16	; glcd_y0=(row*fonthoehe) & 63;
	pop r19
	pop r18
	pop r17
	pop r16
	ret
