/* ser.cc  Serielle Schnittstelle ansprechen    letzte Aenderung: 16.11.2010 */
#define VERSION "Version 0.2"
/*
History:
7.2.2004	Erstellung (RP)
12.11.2010	Baudrate Voreinstellung auf 9600 gesetzt
16.11.10   0.2  Anpassung fuer MacOSX

*/

#define MACOSX      //kann unter Linux auskommentiert werden
#define NONBLOCKMODUS //kann unter Linux auch auskommentiert werden

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <termios.h>
#include <unistd.h>

#include <sys/errno.h>
#ifdef MACOSX
#include <sys/ioctl.h>
#endif

/*************************** kleinkram ***************************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*********************** Serielle Schnittstelle ***********************/
#ifdef MACOSX
//static char sername[80]="/dev/tty.SLAB_USBtoUART";
static char sername[80]="/dev/tty.serial-0002";
#else
//static char sername[80]="/dev/ttyS0"; //richtiger Seriellport mit Linux
static char sername[80]="/dev/ttyUSB0"; //mit Linux-Kubuntu
//static char sername[80]="COM4"; //mit Cygwin unter Windows
#endif

static int baudrate=38400;
static int fdr,fdw;

static int baudcodliste[]={50,B50, 75,B75, 110,B110, 134,B134, 150,B150,
   300,B300, 600,B600, 1200,B1200, 1800,B1800, 2400,B2400, 4800,B4800,
   9600,B9600, 19200,B19200, 38400,B38400,
   57600,B57600, 115200,B115200,
   230400,B230400,
   /* 460800,B460800, 500000,B500000, 576000,B576000,
   921600,B921600, 1000000,B1000000, 1152000,B1152000, 1500000,B1500000,
   2000000,B2000000, 2500000,B2500000, 3000000,B3000000, 3500000,B3500000,
   4000000,B4000000, */
   0,0};

int ibaud(int x) //Baudcode in Baudrate umrechnen
{
 int *co,a;
 for(co=baudcodliste;(a= *co++)!=0;co++)
    if(x== *co) return a;
 printf("Fehler: unbekannter Baudratecode %d\n",x);
 return 0;
}

int baudi(int x) //Baudrate in Baudcode umrechnen
{
 int *co,b,min=0;
 for(co=baudcodliste;(b= *co++)>0;co++)
     if(x==b) return *co;
     else if(x>b) {min= *co;}
 printf("Warnung: unbekannte Baudrate %d, auf %d abgerundet\n",x,min);
 return min;
}

#ifdef MACOSX
static struct termios origbuf;
#endif

void noecho(int fd)
{
 int i;
 struct termios buf;
 if(tcgetattr(fd,&buf)<0)
   {printf("tcgetattr() Error\n"); return;}

#ifdef MACOSX
 memcpy(&buf,&origbuf,sizeof(struct termios));
 buf.c_cflag = CS8; //8 Bit ohne Parity
 buf.c_cflag |= CREAD;  //Enable input
 buf.c_cflag |= CLOCAL; //Ignore modem cntl
 buf.c_iflag = IGNBRK;
 buf.c_lflag = 0; //no echo input
 for(i=0; i<NCCS; i++)   // REF:JS12052003 Change to clear all option chars
   buf.c_cc[i] = 0;
 buf.c_cc[VMIN] = 0;     // Non blocking input
 buf.c_cc[VTIME] = 0;    // REF:JS12052003 Set to not wait
#else
 buf.c_lflag &= ~ECHO;
#endif

 if(baudrate!=0)
     {cfsetispeed(&buf,baudi(baudrate));
      cfsetospeed(&buf,baudi(baudrate));
     }

#ifdef MACOSX
 if(tcsetattr(fd,TCSANOW,&buf)<0)
#else
 if(tcsetattr(fd,TCSAFLUSH,&buf)<0)
#endif
   {printf("tcsetattr() Error\n"); return;}

 int a=cfgetispeed(&buf),b=cfgetospeed(&buf);
 printf("Baudraten: %d %d\n",ibaud(a),ibaud(b));
}

void seriell_open()
{
#ifdef NONBLOCKMODUS
 int modus = O_NONBLOCK;
#else
 int modus = 0;
#endif

#ifdef MACOSX
 fdr=open(sername, modus | O_RDWR | O_NOCTTY);
#else
 fdr=open(sername, modus | O_RDWR);
#endif

 if(fdr<0) {printf("Fehler: fdr = %d\n",fdr); exit(0);}
	   //wenn dieser Fehler kommt sollte /dev/ttyS0 ueberprueft werden
	   //Zugriffsberechtigung freigeben: chmod a+rw /dev/ttyS0
	   //oder vielleicht /dev/ttyS1 oder /dev/tty.*
#ifdef MACOSX
 ioctl(fdr, TIOCEXCL); //set for exclusive OPEN
#endif
 noecho(fdr);
 fdw=fdr;
}

void seriell_close()
{
#ifdef MACOSX
 if(fdr != -1) tcsetattr(fdr, TCSANOW, &origbuf);
#endif
 close(fdr);
}

const char* ser_error()
{
 static char buf[16];
 switch(errno)
  {case EBADF: return "EBADF";
   case EFAULT: return "EFAULT";
   case EIO: return "EIO";
   case EINTR: return "EINTR";
   case EINVAL: return "EINVAL";
   case EAGAIN: return "EAGAIN";
   case ENXIO: return "ENXIO";
   case ENOENT: return "ENOENT";
  }
 sprintf(buf,"%d",errno);
 return buf;
}

void ser_read(char *pc)
{
 int i;
 while((i=read(fdr,pc,1))==0 || (i<0 && errno==EAGAIN)) ;
 if(i<0) printf("ser_read() Error: %s\n",ser_error());
}

void seriell_readline(char *str,int max)
{
 int i;
 char *s,c;
 for(i=1,s=str;i<max;)
   {//read(fdr,&c,1);
    ser_read(&c);
    if(c=='\n') break;
    if(c==0) printf("\\0");//test
    else
      {*s++ = c; i++;}
   }
 if(s!=str && s[-1] == '\r')
   {--s;
    printf("CR empfangen\n");//test
   }
 *s=0;
}

void ser_write(char* wbuf,int n)
{
#ifdef NONBLOCKMODUS
 int i;
 while(n>0)
  {while((i=write(fdw,wbuf,n))==0 || (i<0 && errno==EAGAIN)) ;
   if(i<0) printf("ser_write() Error: %s\n",ser_error());
   if(i<n) wbuf = &wbuf[i];
   n -= i;
  }
#else
 write(fdw,wbuf,n);
#endif
}

void seriell_writeline(char *str)
{
 int n=strlen(str);
 char *wbuf=new char[n+3];
 if(argflag['C']) sprintf(wbuf,"%s\r\n",str);
 else sprintf(wbuf,"%s\n",str);
 //write(fdw,wbuf,n+1);
 ser_write(wbuf,n+1);
 delete wbuf;
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char name[80],zeile[80],rzeile[80];
 int i,j,wahl=1,c=0;
 char c1;
 name[0]=0;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(name,argv[i]);
	         else if(j==2) sscanf(argv[i],"%d",&baudrate);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("ser  %s\n",VERSION);
	 printf("Anwendung: ser [-flags] [/dev/ttyS1] [Baudrate]\n");
	 printf("      voreingestellt ist %s %d\n",sername,baudrate);
	 printf("   flags: c=CR vor LF senden\n");
	 exit(0);
	}
 if(j>=1)
     {if(isdigit(*name)) sprintf(sername,"/dev/ttyS%c",*name);
      else sprintf(sername,"%s",name);
     }
 printf("versuche '%s' zu oeffnen\n",sername);
 seriell_open();
 for(;;)
 {printf("Modus-Auswahl:\n");
  printf("0  Programm verlassen\n");
  printf("1  Zeilenweise schreiben/lesen\n");
  printf("2  Zeilenweise lesen/schreiben\n");
  printf("3  Einzelzeichen schreiben/lesen\n");
  printf("4  Einzelzeichen lesen/schreiben\n");
  printf("5  je 100000 Zeichen senden\n");
  printf("Auswahl:"); getline(stdin,zeile,80); sscanf(zeile,"%d",&wahl);
  if(wahl<1) break;
  if(wahl==1)
    {for(;;)
	{printf("(q=Abbruch) senden:"); getline(stdin,zeile,80);
	 if(*zeile=='q') break;
	 if(*zeile!=0) seriell_writeline(zeile);
	 do {
	  seriell_readline(rzeile,80);
	  printf("  zeile empfangen:'%s'\n",rzeile);
	 }while(*rzeile==0);
	}
    }
  else if(wahl==2)
    {for(;;)
	{do {
	  seriell_readline(rzeile,80);
	  printf("   Zeile empfangen:'%s'\n",rzeile);
	 }while(*rzeile==0);
	 printf("(q=Abbruch) senden:"); getline(stdin,zeile,80);
	 if(*zeile=='q') break;
	 if(*zeile!=0) seriell_writeline(zeile);
	}
    }
  else if(wahl==3)
    {for(;;)
	{printf("(q=Abbruch) senden:"); c1=getc(stdin);
	 if(c1=='q') break;
	 ser_write(&c1,1);
	 ser_read(&c1);
	 printf("Zeichen  empfangen: 0x%02X\n",c1&0xFF);
	}
    }
  else if(wahl==4)
    {for(;;)
        {ser_read(&c1);
	 printf("Zeichen  empfangen: 0x%02X\n",c1&0xFF);
	 printf("(q=Abbruch) senden:"); c1=getc(stdin);
	 if(c1=='q') break;
	 ser_write(&c1,1);
	}
    }
  else if(wahl==5)
    {for(;;)
	{printf("(q=Abbruch) senden:"); c1=getc(stdin);
	 if(c1=='q') break;
	 for(i=0;i<100000;i++) ser_write(&c1,1);
	}
    }
  getc(stdin);
 }
 seriell_close();
 return 0;
}/* ende von main */
