;* Genaue Uhr mit Timer1          letzte Aenderung: 7.9.2010
;* Controller: ATmega8, ATmega32
;* Copyright: Freeware
;-----------------------------------------------------------------------------
; minimales Hauptprogramm:
;.include "m8def.inc"		
.include "m32Adef.inc"
	jmp main2		; test: abwechselnd langsam u schnell Blinken
.org OC1Aaddr
	jmp timer1_match_A_test ; zu schnell zaehlende Interruptroutine

.org LARGEBOOTSTART
	jmp main		; mit test: immer im Sekundentakt blinken
.org LARGEBOOTSTART+OC1Aaddr
	jmp timer1_match_A	; richtige Interruptroutine

;-----------------------------------------------------------------------------
; Registerbelegungen:
; r11:r10 Millisekunden, r12 Sekunden, r13 Minuten, r14 Stunden, r15 Tage
.def millisecH=r11
.def millisecL=r10
.def sec=r12
.def min=r13
.def stunden=r14
.def tage=r15

;-----------------------------------------------------------------------------
; Hochgenaue Variante mit Timer1:
; Laeuft mit beliebiger Anzahl MHz sehr genau.

; Quarz moeglichst genau ausmessen und hier eintragen
; in Hertz und Tausendstel Hertz:
.equ F_CPU=8000000		; exakt 8 MHz
.equ MilliHz=0			; Nachkommastellen

;//Ausmessung-Beispiel: 3.6864MHz ist nach 20 Stunden 0.35 sec nachgegangen:
;// 3686400 / (3600*20) * 0.35 = 17.92  3686400-17.92=3686382.080
;.equ F_CPU=3686382
;.equ MilliHz=80

.equ Rest1 = F_CPU-F_CPU/1000*1000 ;//jede Sekunde zu korrigierender Fehler
.equ Rest2 = MilliHz*6/100	   ;//jede Minute
.equ Rest3 = ((MilliHz*6-Rest2*100)*60+50)/100 ;//jede Stunde
.equ NormalerCompwert = F_CPU/1000-1

timer1_init:
	push r16
	push r17
	ldi r16, (1<<WGM12)|(1<<CS10)	;CTC-OCR1A-Modus, Prescaler=1
	out TCCR1B, r16
	ldi r16, low(NormalerCompwert)
	ldi r17, high(Normalercompwert)
	out OCR1AH, r17
	out OCR1AL, r16
	ldi r16, 0		;Startwert des Timers = 0
	out TCNT1H, r16
	out TCNT1L, r16
	ldi r16, 1<<OCIE1A	;Timer1 Interrupts bei Vergleichswert
	out TIMSK, r16
	clr millisecH
	clr millisecL
	clr sec
	clr min
	clr stunden
	clr tage
	pop r17
	pop r16
	ret

timer1_match_A_test:
	push r16
	push r17
	push r18
	clr r18			;0 = normaler Compwert verwenden
	inc millisecL		;Millisekunden erhoehen
	inc millisecL		;test: um 2 erhoehen --> schnelleres Blinken
	brne tc1_L1
	inc millisecH
	rjmp tc1_L1
	
timer1_match_A:			;Interrupt-Routine
	push r16
	push r17
	push r18
	clr r18			;0 = normaler Compwert verwenden
	inc millisecL		;Millisekunden erhoehen
	brne tc1_L1
	inc millisecH
tc1_L1: ldi r16, low(1000)
	ldi r17, high(1000)
	cp  millisecL, r16
	cpc millisecH, r17	;1000 erreicht?
	breq tc1_sec		;ja-->
	ldi r16, low(1000-Rest1)
	ldi r17, high(1000-Rest1)
	cp  millisecL, r16
	cpc millisecH, r17	;millisec>=1000-Rest1 ?
	brcs tc1_fertig		;nein-->
	ldi r18, -1		;ja: r18 setzen
tc1_fertig:
	ldi r16, low(NormalerCompwert)
	ldi r17, high(Normalercompwert)
	sub r16, r18	;wenn r18 gesetzt: Compwert 1 mehr
	sbc r17, r18	;Trick: statt 1 addieren, -1 subtrahieren
			;damit sparen wir 1 Befehl
	out OCR1AH, r17
	out OCR1AL, r16
	pop r18
	pop r17
	pop r16
	reti
tc1_sec:			; Sekunden erhoehen
	clr millisecL
	clr millisecH
	inc sec
	ldi r17, 60
.if Rest2!=0
	ldi r16, 60-Rest2
	cp sec, r16		;sec >= 60-Rest2 ?
	brcs tc1_L3		;nein-->
	ldi r18, -1		;ja: r18 setzen
.endif
tc1_L3:	cp  sec, r17		;sec==60?
	brne tc1_fertig		;nein-->
	clr sec
	clr r18
	inc min			;Minuten erhoehen
.if Rest3!=0
	ldi r16, 60-Rest3
	cp min, r16		;min >= 60-Rest3 ?
	brcs tc1_L4		;nein-->
	ldi r18, -1		;ja: r18 setzen
.endif
tc1_L4:	cp min, r17
	brne tc1_fertig
	clr min
	clr r18
	inc stunden
	ldi r17, 24
	cp stunden, r17
	brne tc1_fertig
	clr stunden
	inc tage
	rjmp tc1_fertig

;-----------------------------------------------------------------------------
; milliwait  optimierte Variante  Wartezeit 1 bis 1000 Millisekunden
; in r11:r10 wird durch einen Timerinterrupt die aktuelle Millisekunde
; gespeichert (16Bit-Zahl von 0 bis 999).
; Die aktelle Sekunde ist in r12 (wird hier noch nicht benutzt, da nur
; bis maximal 1000ms gewartet werden soll).
milliwait1:			;Wartezeit: r16, 1 bis 255 msec
	push r17
	clr r17
	rjmp miL1
milliwait:			;Wartezeit: r17:r16 msec, 1 bis 1000
	push r17
miL1:	push r16
	push r18
	mov r18, r10
milop1:	cp  r18, r10
	breq milop1		;1. Millisekunde abwarten (0 bis 1 ms)
	add r16, r10
	adc r17, r11		;sollzeit = Wartezeit + aktuelle Millisek
	subi r16, low(1001)
	sbci r17, high(1001)	;sollzeit -= 1; sollzeit -= 1000;
	brpl milop2		;wenn sollzeit>=0 -->
	subi r16, low(-1000)	;sonst haben wir 1000 zuviel subtrahiert
	sbci r17, high(-1000)	;also wieder 1000 addieren (soll -= -1000)
milop2:	cp r16, r10
	cpc r17, r11		;auf sollzeit warten
	brne milop2
	cp r16, r10		;falls zwischen 1. u 2. cp ein Interrupt war
	brne milop2
	pop r18
	pop r16
	pop r17
	ret
	
;-----------------------------------------------------------------------------
; minimales Hauptprogramm:
main:	ldi r16, low(RAMEND)
        out SPL, r16		; Init Stackpointer L
        ldi r16, high(RAMEND)
        out SPH, r16		; Init Stackpointer H
	ldi r16, 0x0F
	out DDRB, r16		; Ausgaenge fuer LEDs

	ldi r17, (1<<IVCE)	;Veraendern von IVSEL vorankuendigen
	out GICR, r17
	ldi r17, (1<<IVSEL)	;Interrupttabelle auch bei Bootadresse
	out GICR, r17
	
	rcall timer1_init

	sei			; Interrupts einschalten

mainloop1:
	out PORTB, sec		; Laufende Sekunden auf den LEDs anzeigen
	rjmp mainloop1

;; test:
main2:	ldi r16, low(RAMEND)
        out SPL, r16		; Init Stackpointer L
        ldi r16, high(RAMEND)
        out SPH, r16		; Init Stackpointer H
	ldi r16, 0x0F
	out DDRB, r16		; Ausgaenge fuer LEDs
	rcall timer1_init

	sei			; Interrupts einschalten

	ldi r18, 5
mainloop3:
	mov r16, sec
	out PORTB, r16		; Laufende Sekunden auf den LEDs anzeigen
mainl1:	cp r16, sec
	breq mainl1
	dec r18			; 5 Sec lang
	brne mainloop3
mainloop4:
	ldi r16, 100
	rcall milliwait1
	inc r18
	out PORTB, r18
	cpi r18, 50		; 5 Sec schnell blinken
	brne mainloop4
	ldi r18, 5
	rjmp mainloop3
