;-----------------------------------------------------------------------------
;* Servomotor ansteuern
;* Version: 0.3 	letzte Aenderung: 9.4.2010
;* Prozessor: ATtiny13A, interner Oszillator 6.4MHz
;* Schaltschema: PB0 ueber Transistor zur Motorsteuerleitung
;*   ADC3 Poti als Eingabe zum austesten,
;*        oder Eingang vom Messgeraet: Negativer Puls startet Schuettelperiode
;* Autor: Rolf Pfister
;* Copyright: Freeware
;* History:
;* 24.3.2010	Erstellung
;* 26.3.2010	Auf negative Puls-Logik umgestellt (damit beim Ausstecken
;*              nicht dauernd geschuettelt wird)
;* 8.4.2010	Umstellung auf PWM-Modus des Timers
;*
;* globale Registerbelegung:
;* r20 = ADC-Kanal
;* r0 = Sicherung Statusregister im AD-Wandler-Interrupt
;* r25 = Reserve fuer PWM-Wert wenn er mehr als 8Bit sein muss
;* r24 = PWM-Wert in 10usec-Schritten, (Servo Pulse von etwa 0.50 bis 2.50 ms)
;* r10...r15 Zeiten (20msec bis Tage)
;* r9 = Zaehler im Timerinterrupt

;Werte in Microsekunden:
.equ MINPWM=500
.equ MAXPWM=2500
;.equ INVERS=1			;fuer Inversen Puls (wenn ueber Transistor)

;.equ FREQTEST=1
;.equ TIMERTEST=1
;.equ TEST1=1
;.equ TEST2=1			;fuer unabhaengigen Schuettler
;.equ TEST3=1			;fuer schalten des Ultraschallgeraets

.ifdef TEST3
.equ AUSPOS=150
.equ EINPOS=180
.else
.ifdef TEST2
.equ AUSPOS=80
.equ EINPOS=180
.else
.equ AUSPOS=88
.equ EINPOS=162
.endif
.endif
		
;-----------------------------------------------------------------------------
.include "tn13def.inc"		; Definitionsdatei fuer den Prozessortyp
; Reset und Interruptvectoren	;VNr. Beschreibung
begin:	rjmp	main		; 1   Power On Reset
	reti			; 2   IRQ0 Handler
	reti			; 3   PCINT0
	rjmp	tc0over		; 4   Timer0 Overflow
	reti			; 5   EEPROM ready
	reti			; 6   Analog Comperator
	reti			; 7   Timer0 CompareA
	rjmp	tc0compb	; 8   Timer0 CompareB
	reti			; 9   Watchdog Interrupt
	rjmp	adcomplete	; 10  ADC Conversion
;-----------------------------------------------------------------------------
; Variablen im SRAM:
.equ SRAMSTART=0x60
.equ richtung=SRAMSTART		;Motoransteuerung (0b01 oder 0b10)
.equ sensor1adwertL=SRAMSTART+1
.equ sensor1adwertH=SRAMSTART+2 ;Wert von AD-Wandler fuer Stromsensor
.equ poti1adwertL=SRAMSTART+3
.equ poti1adwertH=SRAMSTART+4 ;Wert von AD-Wandler fuer Poti1
.equ poti2adwertL=SRAMSTART+5
.equ poti2adwertH=SRAMSTART+6 ;Wert von AD-Wandler fuer Poti2

;-----------------------------------------------------------------------------
; Start, Power On, Reset
main:	ldi r16, low(RAMEND)
        out SPL, r16  	     ; Init Stackpointer
	ldi r16, 0x80
	out CLKPR, r16		; Vorbereitung zum Prescaler setzen
	ldi r16, 0
	out CLKPR, r16		; Clk-Prescaler auf 1 setzen --> 9.6MHz

;	ldi r16, 0x5A		; Wert ausprobieren fuer 8MHz
	ldi r16, 0x45		; Wert ausprobieren fuer 6.4MHz
	out OSCCAL, r16		; Oszillator kallibrieren --> 6.4MHz

	ldi r16, 0x03		;PB0, PB1 auf Ausgang
        out DDRB, r16		;Data Direction Register B setzen
	ldi r16, 0
	out PORTB, r16		;Motor aus

.ifdef FREQTEST
T1:	inc r16			; Test fuer Frequenzmessung
	out PORTB, r16		; Schlaufe braucht 4 Takte, eine Periode also 8
	rjmp T1			; Bei 8MHz muesste an B0 1MHz zu messen sein.
.endif

;; Timer auf 100kHz (10usec) und 250 setzen: 250*10usec=2.5msec
;; bei jedem 8. Durchgang (alle 20msec) PWM-Wert setzen
	ldi r17, 0x0A		;Interruptenable setzen: B=8 A=4 OVR=2
	out TIMSK0, r17
;	ldi r17, 2		;CTC-Modus
; Ohne benutzen von Pin OC0B:
	ldi r17, 3		;PWM-Modus 3 oder 7
; Wenn Pin OC0B (PB1 beim tiny13a) automatisch gesetzt werden soll:
;	ldi r17, (1<<COM0B1)+3	;OC0B benutzen und PWM-Modus 3 oder 7
	out TCCR0A, r17		;Timer-Modus setzen
; Fuer PWM-Modus 7:
	ldi r17, 3+8		;1=nicht teilen, 2=durch 8, 3=64, 4=256, 5=1024
; Fuer andere Moden:
;	ldi r17, 3		;1=nicht teilen, 2=durch 8, 3=64, 4=256, 5=1024
	out TCCR0B, r17		;Vorteiler auf 64 setzen (6.4MHz/64=100kHz)
	ldi r17, 249
	out OCR0A, r17		;TOP=249 fuer teilen durch 250
	ldi r17, 0
	out OCR0B, r17		;PWM-Wert loeschen
	ldi r17, 0
	out TCNT0, r17		;Counter auf Startwert setzen
	ldi r17, 1
	mov r9, r17		;Durchlaufzaehler setzen

	clr r10
	clr r11			; r11r10 = Millisec
	clr r12			; Sekunden
	clr r13			; Minuten
	clr r14			; Stunden
	clr r15			; Tage, auf 0 setzen
	sei			;Interrupt erlauben

; AD-Wandler initialisieren:
	ldi r20, 3		;mit ADC3  beginnen
	ldi r16, 0		;Referenz=VCC
;	ldi r16, 0x40		;Referenz= etwa 1.1V
	add r16, r20
	out ADMUX, r16
;Prescaler: 3=8 4=16 ... 6=64, 9.6MHz/64=150kHz (muss im Bereich 50-200 liegen)
;AD-Wandlung braucht jeweils 13 Takte also etwa 87usec
.equ	PRESCALER=6
;r16 = Prescaler+0b11001000 (ADEN+ADSC+ADIE = Enable,Einzelstart,Interrupt)
;ADIF (0x10) wird automatisch vom AD-Wandler gesetzt wenn Wandlung fertig.
	ldi r16, 0b11001000 + PRESCALER
	out ADCSRA, r16		;Prescaler und Enable
		;ab hier wird also der AD-Wandler dauernd laufen

;PWM-Steuerung initialisieren:
	ldi r24, low(MAXPWM/10)
	ldi r25, high(MAXPWM/10)

.ifdef TIMERTEST
T1:	nop
	rjmp T1
.endif

;-----------------------------------------------------------------------------
mainloop:

.ifdef TEST1
	ldi r24, MAXPWM/10	;Maximal-Position
	ldi r16, 3
	rcall secwait		;3 Sekunden laufen lassen
	ldi r24, MINPWM/10	;Minimal-Position
	ldi r16, 3
	rcall secwait		;3 Sekunden laufen lassen
	ldi r24, (MINPWM+MAXPWM)/20	;Mittel-Position
	ldi r16, 3
	rcall secwait		;3 Sekunden laufen lassen
	rjmp mainloop
.else
;; normaler Hauptloop
;; 50=0Grad, 200=180Grad --> xGrad=150/180*x+50
	ldi r24, AUSPOS		;Servo stellen: 45Grad = Ausposition
	lds r17, poti2adwertH
	lds r16, poti2adwertL	;r17:r16=adwert
	ldi r18, 3
	rcall div18		; auf Bereich 0...128 verkleinern
.ifndef TEST2
	cpi r16, 96		; Obere Poti-Stellung ?
	brcc minus		; ja-->
	cpi r16, 32		; Untere Poti-Stellung ?
	brcs plus		; ja-->
.endif
mitte:				;Poti ungefaehr in Mitte: automatische Sequenz
	mov r16, r12
.ifdef TEST2
	tst r16			; jede Minute schuetteln
.else
	andi r16, 0x0F
.endif
	brne mainloop		; ca 16 Sec auf Aus-Position bleiben
	ldi r24, EINPOS		; 135Grad
	rcall wait2einhalb	; 2.5 Sec auf neuer Position
	rjmp mainloop
plus:
	ldi r24, EINPOS		; 135Grad
	rcall wait2einhalb	; 2.5 Sec auf neuer Position
.ifdef TEST3
	ldi r16, low(300)
	ldi r17, high(300)
	rcall milliwait		; + 0.3 Sec, als total 2.8 Sec Ultraschall
.endif
	ldi r24, AUSPOS		; Servo auf Aus-Position
.ifdef TEST3
	ldi r16, low(200)
	ldi r17, high(200)	; 0.2 Sec reicht zum Ultraschall stoppen
.else
	ldi r16, low(500)
	ldi r17, high(500)
.endif
	rcall milliwait		; 0.5 Sec um Aus-Position zu erreichen
	rjmp mainloop
minus:
	ldi r24, AUSPOS		; Servo auf Aus-Position
	rjmp mainloop
.endif

div18:		;r17:r16 /= 2^r18 ,r18 zerstoert
	asr r17
	ror r16
	dec r18
	brne div18
	ret

wait2einhalb:			; 2.5 sec warten, r16r17 zerstoert
	ldi r16, low(500)
	ldi r17, high(500)
	rcall milliwait		; 0.5 Sec
	ldi r16, 2		; 2 Sec
	
secwait:	; r16 Sekunden lang warten
	push r16
	push r17
	push r18
	mov r18, r16
	add r18, r16
_sw1:	ldi r16, low(500)
	ldi r17, high(500)
	rcall milliwait
	dec r18
	brne _sw1
	pop r18
	pop r17
	pop r16
	ret

;-----------------------------------------------------------------------------
; OVR-Interrupt-Routine, wird alle 2.5msec aufgerufen
; Registerbelegungen:
; r9=Durchlaufzaehler, jeder 8.Durchlauf den PWM-Wert setzen (8*2.5=20msec)
; r11:r10 Millisekunden, r12 Sekunden, r13 Minuten, r14 Stunden, r15 Tage
tc0over:push r16
	in r16, SREG	;Statusregister sichern
	push r16
	ldi r16, 1
	sub r9, r16		;Durchlaufzaehler -= 1
	breq tc1		;nur jeder 8. Durchlauf ein PWM-Wert setzen
	brcs tc2
pop16reti:
	pop r16
	out SREG, r16	;Statusregister zurueckholen
	pop r16
	reti
tc1:	out OCR0B, r24	;PWM-Wert zetzen, ist erst beim naechsten mal aktiv
	rjmp pop16reti
tc2:
.ifdef INVERS
	cbi PORTB, 0		;Puls an PB0 starten
.else
	sbi PORTB, 0		;Puls an PB0 starten
.endif
	ldi r16, 0		;PWM ausschalten beim naechsten OVR-Interrupt
	out OCR0B, r16
	ldi r16, 7
	mov r9, r16
	sei			;Interrupts erlauben, fuer tc0compb
millisekzaehlen:
	push r17
	ldi r16, 20
	add r10, r16		;Millisekunden erhoehen
	brcc L1
	inc r11
L1:	ldi r16, low(1000)
	ldi r17, high(1000)	;r17:r16 = 1000
	cp r10, r16
	cpc r11, r17
	brne end1	;fertig wenn msec!=1000
	clr r10
	clr r11		;Millisekunden auf 0 setzen
	inc r12		;Sekunden erhoehen
	ldi r16, 60
	cp r12, r16
	brne end1	;fertig wenn sec!=60
	clr r12		;Sekunden auf 0 setzen
	inc r13		;Minuten erhoehen
	cp r13, r16
	brne end1	;fertig wenn min!=60
	clr r13		;Minuten auf 0 setzen
	inc r14		;Stunden erhoehen
	ldi r16, 24
	cp r14, r16
	brne end1	;fertig wenn std!=24
	clr r14		;Stunden auf 0 setzen
	inc r15		;Tage erhoehen
end1:	pop r17
	rjmp pop16reti

tc0compb:			;Ende des PWM-Pulses
.ifdef INVERS
	sbi PORTB, 0
.else
	cbi PORTB, 0
.endif
	reti

;-----------------------------------------------------------------------------
; Interrupt-Routine fuer AD-Wandler
; Rueckgabewert: sensor1adwert, poti1wert, poti2wert
adcomplete:
	push r16
	push r17
	in r17, ADCL	;L muss zuerst gelesen werden!
	in r16, ADCH
	sei		;Interrupt erlauben (fuer schnelles PWM)
	in r0, SREG	;Statusregister sichern
	cpi r20, 3
	breq _ad3
	cpi r20, 2
	breq _ad2
_ad1:	sts poti1adwertL, r17 	;Messwert im RAM
	sts poti1adwertH, r16	;zwischenspeichern.
	rjmp _ad4
_ad2:	sts sensor1adwertL, r17 	;Messwert im RAM
	sts sensor1adwertH, r16		;zwischenspeichern.
	rjmp _ad4
_ad3:	sts poti2adwertL, r17 	;Messwert im RAM
	sts poti2adwertH, r16	;zwischenspeichern.
_ad4:
	dec r20		;automatisch naechster AD-Kanal
	brne _ad5
	ldi r20, 3		;ADC3 als Anfangswert
_ad5:	ldi r16, 0		;Referenz=VCC
;	ldi r16, 0x40		;Referenz= etwa 1.1V
	add r16, r20		;ADC-Kanal
	out ADMUX, r16
	sbi ADCSRA, ADSC	;Starte naechste AD-Wandlung
	out SREG, r0	;Statusregister zurueckholen
	pop r17
	pop r16
	ret

;-----------------------------------------------------------------------------
milliwait:			;Wartezeit: r17:r16 msec, min 1 max 999
	; oder bei 20ms Schrittweite: min 20 max 980, durch 20 teilbar
	push r16
	push r17
	push r18
	push r19
	cli
	mov r18, r10
	mov r19, r11		;r19r18 = sollzeit = aktuelle Millisec
	sei
	add r18, r16
	adc r19, r17		;sollzeit += Wartezeit
	ldi r16, 0xE8		;auf 1000 testen
	cpi r19, 0x03		;oberes Byte testen
	brcs loop1		;sollzeit<1000 --> weiter
	brne subtra		;sollzeit>1000 --> subtrahiere 1000
	cp r18, r16		;unteres Byte testen
	brcs loop1		;sollzeit<1000 --> weiter
subtra:	sub r18, r16
	sbci r19, 0x03		;wenn sollzeit>=1000 dann sollzeit-=1000
loop1:	cp r18, r10
	brne loop1
	cp r19, r11		;auf sollzeit warten
	brne loop1
	pop r19
	pop r18
	pop r17
	pop r16
	ret
