;* lcdanz4.asm   Darstellung der Temperatur auf dem LCD
;* Wie lcdanz3.asm aber mit Timer1-Uhr
;History:			
;22.5.2009	Erstellung
;-----------------------------------------------------------------------------
.include "m8def.inc" 	; Definitionsdatei fuer den Prozessortyp
.equ SRAMSTART=0x60	;beim Atmega8

;-----------------------------------------------------------------------------
;Speicherbelegung:
;Global benutzt:
; r11:r10 Millisekunden, r12 Sekunden, r13 Minuten, r14 Stunden, r15 Tage
.def millisecL=r10
.def millisecH=r11
.def sec=r12
.def min=r13
.def stunden=r14
.def tage=r15
; r23:r22 Wert aus AD-Messung
; r9 Summieranzahl fuer AD-Wandlung
;
;im Hauptprogramm:
; r16, r17, r18, r19 = temporaere Variablen
; r30:r31 == ZH:ZL = Fuer lpm-Befehl
; 
;-----------------------------------------------------------------------------
.define VIERMHZ

;provi. ohne Datenspeicherung:
.equ DATENFORMAT=0

.ifdef MYAVR
.equ QUARTZ=3686400	;zum Austesten mit myAVR-Board
.else
.ifdef VIERMHZ
.equ QUARTZ=4194304	;2^22 Hz
.else
.equ QUARTZ=8000000	;Takt in MHz
.endif
.endif

; Reset und Interruptvectoren	;VNr. Beschreibung
begin:	rjmp	main		; 1   Power On Reset
	reti			; 2   Int0-Interrupt
	reti			; 3   Int1-Interrupt
	reti			; 4   TC2 Compare Match
	reti			; 5   TC2 Overflow
	reti			; 6   TC1 Capture
	rjmp timer1_match_A	; 7   TC1 Compare Match A
	reti			; 8   TC1 Compare Match B
	reti			; 9   TC1 Overflow
	reti			; 10  TC0 Overflow
	reti			; 11  SPI, STC = Serial Transfer Complete
	reti			; 12  UART Rx Complete
	reti			; 13  UART Data Register Empty
	reti			; 14  UART Tx Complete
	rjmp adcomplete		; 15  ADC Conversion Complete
	reti			; 16  EEPROM ready
	reti			; 17  Analog Comperator
	reti			; 18  TWI (I2C) Serial Interface
	reti			; 19  Store Program Memory ready
;-----------------------------------------------------------------------------
; Start, Power On, Reset
main:	ldi r16, RAMEND&0xFF
        out SPL, r16  	     ; Init Stackpointer L
	ldi r16, RAMEND>>8
        out SPH, r16  	     ; Init Stackpointer H

;; Init-Code
.ifdef VIERMHZ
	ldi r16, 0xFF		;Alle Leitungen auf Ausgang
        out DDRB, r16		;Data Direction Register B setzen
	ldi r16, 0x01		;Ladetransistor ein
	out PORTB, r16		;alle LEDs loeschen
        ldi r17, 0xF2
        out DDRD, r17		;PortD obere 4 Bits und Bit1 als Ausgaenge
        ldi r17, 0b00001110	;D2,D3 Pullupwiederstaende und Bit1 setzen
        out PORTD, r17	        ;PortD Pullupwiederstaende setzen
.else
	ldi r16, 0xFF		;Alle Leitungen auf Ausgang
        out DDRB, r16		;Data Direction Register B setzen
	ldi r16, 0
	out PORTB, r16		;alle LEDs loeschen
        ldi r17, 0xF0
        out DDRD, r17		;PortD obere 4 Bits als Ausgaenge
        ldi r17, 0b00001100	;D2,D3 Pullupwiederstaende setzen
        out PORTD, r17	        ;PortD Pullupwiederstaende setzen
.endif

; Timer Initialisieren:
	rcall timer1_init
	sei			;Interrupt erlauben

; AD-Wandler initialisieren:
	clr r9			;r9=0 erste Wandlung verwerfen
.ifdef VIERMHZ
	ldi r16, 0x40+4		;Bei dieser Testschaltung ADC4 verwenden
.else
	ldi r16, 0x40		;ADC0 u Referenz=AVCC (mit externem Condenser)
.endif
;Anschlussvariante2:
;	ldi r16, 0xC0		;ADC0 u Referenz=2.56V (ev.externer Condenser)
	out ADMUX,r16
;Prescaler: 5=32 6=64 7=128, 8MHz/64=125kHz (muss im Bereich 50-200 liegen)
;AD-Wandlung braucht jeweils 13 Takte also 104usec
.ifdef MYAVR
.equ	PRESCALER=5		;6 fuer 8MHz, 5 fuer 3.6864 oder 4.1943MHz
.else
.ifdef VIERMHZ
.equ	PRESCALER=5		;6 fuer 8MHz, 5 fuer 4.1943MHz
.else
.equ	PRESCALER=6		;6 fuer 8MHz, 5 fuer 4.1943MHz
.endif
.endif
;r16 = Prescaler+0b11001000 (ADEN+ADSC+ADIE = Enable,Einzelstart,Interrupt)
;ADIF (0x10) wird automatisch vom AD-Wandler gesetzt wenn Wandlung fertig.
	ldi r16, 0b11001000 + PRESCALER
	out ADCSRA, r16		;Prescaler und Enable
;-----------------------------------------------------------------------------
	clr r21			; Polaritaet fuer LCD
mainloop0:
	clr r8			; Zaehler fuer Umschaltung Zeit/Temp.
mainloop:
	rcall messung		;AD-Wandlung machen
	ldi r20, 25		; 25*20ms = 0.5sec
mloop1:	ldi r16, 20
	rcall milliwait1	; 20ms warten
	ldi r16, 10
	cp r8, r16
	brcs adwait
	mov r16, min
	ldi r17, 100
	mul r16, r17
	mov r16, r0
	mov r17, r1
	add r16, sec
	ldi r18, 2		; Dezimalpunkt in der Mitte
	rjmp mL1
adwait:	tst r9
	brne adwait		;ev. warten bis laufende Messung fertig
	out PORTB, r9		;LEDs loeschen
	mov r0, r22
	mov r1, r23		; r1:r0 = AD-Messwert
	rcall umrechnen
	mov r16, r0
	mov r17, r1		; r17:r16 = GradCelsius*10
	ldi r18, 1		; Dezimalpunkt vor letzter Stelle
.ifdef VIERMHZ
	ldi r19, 0x0E
	out PORTD, r19	;Messwiderstand2 auf ca. 0.167 Ohm setzen
	rjmp mL2
.endif
mL1:
.ifdef VIERMHZ
	ldi r19, 0x0C
	out PORTD, r19	;Messwiderstand2 auf 1.00 Ohm setzen
.endif
mL2:	ldi r19, 1
	sub r19, r21		; Polaritaet, einmal auf 1 dann auf 0
	mov r21, r19
	rcall zahlauflcdanzeigen ;zahlauflcdanzeigen(zahl,100,0);
	dec r20
	brne mloop1
	inc r8
	ldi r16, 20
	cp r8, r16
	brcc mainloop0
	rjmp mainloop

;-----------------------------------------------------------------------------
; Interrupt-Routine fuer Zeit
; Registerbelegungen:
; r11:r10 Millisekunden, r12 Sekunden, r13 Minuten, r14 Stunden, r15 Tage

; Quarz moeglichst genau ausmessen und hier eintragen
; in Hertz und Tausendstel Hertz:
	
;.equ Hz=3686400		; exakt 3.6864MHz
.equ MilliHz=0			; 3'686'400.000 Hz
.equ Hz=QUARTZ

;//Ausmessung-Beispiel: 3.6864MHz ist nach 20 Stunden 0.35 sec nachgegangen:
;// 3686400 / (3600*20) * 0.35 = 17.92  3686400-35.84=3686364.16
;.equ Hz=3686364
;.equ MilliHz=160

.equ Rest1 = Hz-Hz/1000*1000	;//jede Sekunde zu korrigierender Fehler
.equ Rest2 = MilliHz*6/100	;//jede Minute
.equ Rest3 = ((MilliHz*6-Rest2*100)*60+50)/100 ;//jede Stunde
.equ NormalerCompwert = Hz/1000-1

timer1_init:
	ldi r16, (1<<WGM12)|(1<<CS10)	;CTC-OCR1A-Modus, Prescaler=1
	out TCCR1B, r16
	ldi r16, low(NormalerCompwert)
	ldi r17, high(Normalercompwert)
	out OCR1AH, r17
	out OCR1AL, r16
	ldi r16, 0		;Startwert des Timers = 0
	out TCNT1H, r16
	out TCNT1L, r16
	ldi r16, 1<<OCIE1A	;Timer1 Interrupts bei Vergleichswert
	out TIMSK, r16
	clr millisecH
	clr millisecL
	clr sec
	clr min
	clr stunden
	clr tage
	ret

timer1_match_A:
	push r16
	push r17
	push r18		;uchar mehr;
	clr r18			;mehr=0
	inc millisecL		;++ms
	brne tc1_L1
	inc millisecH
tc1_L1: ldi r16, low(1000)
	ldi r17, high(1000)
	cp  millisecL, r16
	cpc millisecH, r17
	breq tc1_sec
	ldi r16, low(1000-Rest1)
	ldi r17, high(1000-Rest1)
	cp  millisecL, r16
	cpc millisecH, r17	;millisec>=1000-Rest1 ?
	brcs tc1_fertig		;nein-->
	ldi r18, 1		;ja: mehr=1
tc1_fertig:
	ldi r16, low(NormalerCompwert)
	ldi r17, high(Normalercompwert)
	add r16, r18
	brcc tc1_L2
	inc r17
tc1_L2:	out OCR1AH, r17
	out OCR1AL, r16
	pop r18
	pop r17
	pop r16
	reti
tc1_sec:			; Sekunden erhoehen
	clr millisecL
	clr millisecH
	inc sec
	ldi r17, 60
.if Rest2!=0
	ldi r16, 60-Rest2
	cp sec, r16		;if(++sec>=60-Rest2) mehr=1; else mehr=0;
	brcs tc1_L3
	ldi r18, 1
.endif
tc1_L3:	cp  sec, r17		;sec==60?
	brne tc1_fertig		;nein-->
	clr sec
	clr r18
	inc min
.if Rest3!=0
	ldi r16, 60-Rest3
	cp min, r16		;if(++min>=60-Rest3) mehr=1; else mehr=0;
	brcs tc1_L4
	ldi r18, 1
.endif
tc1_L4:	cp min, r17
	brne tc1_fertig
	clr min
	clr r18
	inc stunden
	ldi r17, 24
	cp stunden, r17
	brne tc1_fertig
	clr stunden
	inc tage		;{stunden=0; ++tage;}
	rjmp tc1_fertig

;-----------------------------------------------------------------------------
milliwait1:			;Wartezeit: r16, 1 bis 255 msec
	push r17
	clr r17
	rjmp miL1
milliwait:			;Wartezeit: r17:r16 msec, min 1 max 1000
	push r17
miL1:	push r16
	push r18
	mov r18, r10
loop1:	cp  r18, r10
	breq loop1		;1. Millisekunde abwarten (0 bis 1 ms)
	add r16, r10
	adc r17, r11		;sollzeit = Wartezeit + aktuelle Millisek
	subi r16, low(1001)
	sbci r17, high(1001)	;sollzeit -= 1; sollzeit -= 1000;
	brpl loop2		;wenn sollzeit>=0 -->
	subi r16, low(-1000)	;sonst haben wir 1000 zuviel subtrahiert
	sbci r17, high(-1000)	;also wieder 1000 addieren (soll -= -1000)
loop2:	cp r16, r10
	cpc r17, r11		;auf sollzeit warten
	brne loop2
	cp r16, r10		;falls zwischen 1. u 2. cp ein Interrupt war
	brne loop2
	pop r18
	pop r16
	pop r17
	ret

;void datenschieben(ulong n)
datenschieben:		;r16:r17:r18:r19 = zu schiebende 32 Bit
	push r20
	push r21
	ldi r20, 32	;for(int i=0;i<32;i++,n<<=1)
datL1:	in r21, PORTD
	andi r21, 0x0F	;untere 4 Bits unveraendert lassen
	ori r21, 0x20	;0x20=OE (vorhergehende Daten immer noch anzeigen)
	out PORTD, r21
	sbrc r16, 7		;if(n&0x80000000)
	ori r21, 0x40		;  c |= 0x40; //zu schiebendes Datenbit
	out PORTD, r21
	ori r21, 0x10		;c |= 0x10;//CLK
	out PORTD, r21		;PORTD = c;
	lsl r19
	rol r18
	rol r17
	rol r16			;n<<=1
	dec r20
	brne datL1
	ori r21, 0x80
	out PORTD, r21		;PORTD = c |= 0x80;//STR
	in r21, PORTD
	andi r21, 0x0F	;untere 4 Bits unveraendert lassen
	ori r21, 0x20
	out PORTD, r21		;PORTD=0x20;//OE
	pop r21
	pop r20
	ret

.equ SEG3DP=1
.equ SEG3E=2
.equ SEG3D=4
.equ SEG3C=8
.equ SEG2DP=0x10
.equ SEG2E=0x20
.equ SEG2D=0x40
.equ SEG2C=0x80
.equ SEG1DP=0x100
.equ SEG1E=0x200
.equ SEG1D=0x400
.equ SEG1C=0x800
.equ SEG1B=0x1000
.equ SEG1A=0x2000
.equ SEG1F=0x4000
.equ SEG1G=0x8000
.equ SEG2B=0x10000
.equ SEG2A=0x20000
.equ SEG2F=0x40000
.equ SEG2G=0x80000
.equ SEGPin28=0x100000
.equ SEG3B=0x200000
.equ SEG3A=0x400000
.equ SEG3F=0x800000
.equ SEG3G=0x1000000
.equ SEGPin38=0x2000000
.equ SEGPin39=0x4000000
.equ SEGPin3=0x8000000
.equ SEGPin2=0x10000000
.equ SEGCOM=0x20000000

.equ SEG4BC=SEGPin3		;//kann bei andern LCDs anders sein
.equ SEGMinus=SEGPin39		;//kann bei andern LCDs anders sein
.equ SEGBatt=SEGPin2		;//kann bei andern LCDs anders sein
.equ SEGOver=SEGPin38		;//kann bei andern LCDs anders sein
;.equ SEGDoppelpunkt=SEGPin28	;//bei diesem LCD nicht vorhanden
;static ulong siebensegdec1[10]={
siebensegdec1:
 .dw SEG1A+SEG1B+SEG1C+SEG1D+SEG1E+SEG1F ;//0
 .dw SEG1B+SEG1C ;//1
 .dw SEG1A+SEG1B+SEG1D+SEG1E+SEG1G ;//2
 .dw SEG1A+SEG1B+SEG1C+SEG1D+SEG1G ;//3
 .dw SEG1B+SEG1C+SEG1F+SEG1G ;//4
 .dw SEG1A+SEG1C+SEG1D+SEG1F+SEG1G ;//5
 .dw SEG1A+SEG1C+SEG1D+SEG1E+SEG1F+SEG1G ;//6
 .dw SEG1A+SEG1B+SEG1C ;//7
 .dw SEG1A+SEG1B+SEG1C+SEG1D+SEG1E+SEG1F+SEG1G ;//8
 .dw SEG1A+SEG1B+SEG1C+SEG1D+SEG1F+SEG1G ;//9
siebensegdec2:
 .dw (SEG2A+SEG2B+SEG2C+SEG2D+SEG2E+SEG2F)>>16,(SEG2A+SEG2B+SEG2C+SEG2D+SEG2E+SEG2F)&0xFFFF ;0
 .dw (SEG2B+SEG2C)>>16 , (SEG2B+SEG2C)&0xFFFF ;//1
 .dw (SEG2A+SEG2B+SEG2D+SEG2E+SEG2G)>>16, (SEG2A+SEG2B+SEG2D+SEG2E+SEG2G)&0xFFFF ;//2
 .dw (SEG2A+SEG2B+SEG2C+SEG2D+SEG2G)>>16, (SEG2A+SEG2B+SEG2C+SEG2D+SEG2G)&0xFFFF ;//3
 .dw (SEG2B+SEG2C+SEG2F+SEG2G)>>16, (SEG2B+SEG2C+SEG2F+SEG2G)&0xFFFF ;//4
 .dw (SEG2A+SEG2C+SEG2D+SEG2F+SEG2G)>>16, (SEG2A+SEG2C+SEG2D+SEG2F+SEG2G)&0xFFFF ;//5
 .dw (SEG2A+SEG2C+SEG2D+SEG2E+SEG2F+SEG2G)>>16, (SEG2A+SEG2C+SEG2D+SEG2E+SEG2F+SEG2G)&0xFFFF ;//6
 .dw (SEG2A+SEG2B+SEG2C)>>16, (SEG2A+SEG2B+SEG2C)&0xFFFF ;//7
 .dw (SEG2A+SEG2B+SEG2C+SEG2D+SEG2E+SEG2F+SEG2G)>>16, (SEG2A+SEG2B+SEG2C+SEG2D+SEG2E+SEG2F+SEG2G)&0xFFFF ;//8
 .dw (SEG2A+SEG2B+SEG2C+SEG2D+SEG2F+SEG2G)>>16, (SEG2A+SEG2B+SEG2C+SEG2D+SEG2F+SEG2G)&0xFFFF ;//9
siebensegdec3:
 .dw (SEG3A+SEG3B+SEG3C+SEG3D+SEG3E+SEG3F)>>16, (SEG3A+SEG3B+SEG3C+SEG3D+SEG3E+SEG3F)&0xFFFF ;//0
 .dw (SEG3B+SEG3C)>>16, (SEG3B+SEG3C)&0xFFFF ;//1
 .dw (SEG3A+SEG3B+SEG3D+SEG3E+SEG3G)>>16, (SEG3A+SEG3B+SEG3D+SEG3E+SEG3G)&0xFFFF ;//2
 .dw (SEG3A+SEG3B+SEG3C+SEG3D+SEG3G)>>16, (SEG3A+SEG3B+SEG3C+SEG3D+SEG3G)&0xFFFF ;//3
 .dw (SEG3B+SEG3C+SEG3F+SEG3G)>>16, (SEG3B+SEG3C+SEG3F+SEG3G)&0xFFFF ;//4
 .dw (SEG3A+SEG3C+SEG3D+SEG3F+SEG3G)>>16, (SEG3A+SEG3C+SEG3D+SEG3F+SEG3G)&0xFFFF ;//5
 .dw (SEG3A+SEG3C+SEG3D+SEG3E+SEG3F+SEG3G)>>16, (SEG3A+SEG3C+SEG3D+SEG3E+SEG3F+SEG3G)&0xFFFF ;//6
 .dw (SEG3A+SEG3B+SEG3C)>>16, (SEG3A+SEG3B+SEG3C)&0xFFFF ;//7
 .dw (SEG3A+SEG3B+SEG3C+SEG3D+SEG3E+SEG3F+SEG3G)>>16, (SEG3A+SEG3B+SEG3C+SEG3D+SEG3E+SEG3F+SEG3G)&0xFFFF ;//8
 .dw (SEG3A+SEG3B+SEG3C+SEG3D+SEG3F+SEG3G)>>16, (SEG3A+SEG3B+SEG3C+SEG3D+SEG3F+SEG3G)&0xFFFF ;//9

segdec1:			;r0=Ziffer --> r16:r17:r18:r19 |= Codierung
	ldi ZL, low(siebensegdec1<<1)
	ldi ZH, high(siebensegdec1<<1)
	add r0, r0		;r0 *= 2
	add ZL, r0
	brcc dec18
	inc ZH
	rjmp dec18
segdec2:			;r0=Ziffer --> r16:r17:r18:r19 |= Codierung
	ldi ZL, low(siebensegdec2<<1)
	ldi ZH, high(siebensegdec2<<1)
	rjmp dec3L0
segdec3:			;r0=Ziffer --> r16:r17:r18:r19 |= Codierung
	ldi ZL, low(siebensegdec3<<1)
	ldi ZH, high(siebensegdec3<<1)
dec3L0:	lsl r0
	lsl r0			;r0 *= 4
	add ZL, r0
	brcc dec3L1
	inc ZH
dec3L1:	lpm r0, Z+
	or r17, r0
	lpm r0, Z+
	or r16, r0
dec18:	lpm r0, Z+
	or r19, r0
	lpm r0, Z
	or r18, r0
	ret

zahlauflcdanzeigen:	;zahlauflcdanzeigen(int zahl,int teiler,int polaritaet)
; r17:r16 = zahl, r18 = log(teiler), r19 = polaritaet,  werden ueberschrieben
; Beispiel: zahl=1234  r18=2 (teiler=100) --> Anzeige="12.34"
	push r0
	push r2
	push r3
	push r6
	push r20	; ulong n; r16:r17:r18:r19 = n
	push ZL
	push ZH
	mov r6, r19	;r6=polaritaet
	cpi r18, 1	; switch(teiler)
	breq anzL1
	cpi r18, 2
	breq anzL2
	cpi r18, 3
	breq anzL3
	clr r18
	clr r19		;default: n=0; (r16,r17 weiter unten auf 0 gesetzt)
	rjmp anzL4
anzL1:	ldi r18, SEG1DP>>8
	ldi r19, 0		; case 10: n = SEG1DP; break;
	rjmp anzL4
anzL2:	ldi r18, 0
	ldi r19, SEG2DP		; case 100: n = SEG2DP; break;
	rjmp anzL4
anzL3:	ldi r18, 0
	ldi r19, SEG3DP		; case 1000: n = SEG3DP; break;
anzL4:	sbrs r17, 7		;if(zahl<0)
	rjmp anzL5
	clr r2
	clr r3
	sub r2, r16
	sbc r3, r17		; {zahl= -zahl; n |= SEGMinus;}
	ldi r16, SEGMinus>>24
	ldi r17, (SEGMinus>>16)&0xFF
	rjmp anzL6
anzL5:	mov r2, r16
	mov r3, r17
	clr r16
	clr r17
anzL6:		;Zahl ist jetzt in r3:r2, r16:r17:r18:r19 = initialisiertes n
;weggelassen if(zahl>1999) zahl=1999; //Fehler: darstellbare Zahlen auf 1999 beschraenkt
	ldi r20, 10
	rcall divmodr20	; z1=zahl%10; zahl/=10;
	rcall segdec1	; n += siebensegdec1[z1];
	rcall divmodr20	; z2=zahl%10; zahl/=10;
	rcall segdec2	; n += siebensegdec2[z2];
	rcall divmodr20	; z3=zahl%10; zahl/=10;
	rcall segdec3	; n += siebensegdec3[z3];
	tst r3		;if(zahl>999)
	brne anzBC	;Zahlen groesser 1999 trotzdem zuvorderst eine Eins
	tst r2		;normalerweise steht hier nur eine 0 oder eine 1
	breq anzL7
anzBC:	ori r16, SEG4BC>>24	;   n |= SEG4BC;
anzL7:
	tst r6		; if(polaritaet!=0)
	breq anzL8
	ldi r20, 0xFF
	eor r16, r20		; n ^= 0xFFFFFFFF;
	eor r17, r20
	eor r18, r20
	eor r19, r20
anzL8:
	rcall datenschieben	; datenschieben(n);
	pop ZH
	pop ZL
	pop r20
	pop r6
	pop r3
	pop r2
	pop r0
	ret

;-----------------------------------------------------------------------------
; divmodr20
;  16Bit vorzeichenlose Zahl dividieren durch 8Bit vorzeichenlosen Teiler
; Eingabe: r3:r2 = Zahl (16Bit), r20 = Teiler (8Bit) (unveraendert)
; Ausgabe: r3:r2 = Resultat, r0 = Rest
;-----------------------------------------------------------------------------
divmodr20:
	push r17
	clr r0
	ldi r17, 16
divL1:	lsl r2
	rol r3
	rol r0
	cp r0, r20
	brcs divL2
	sub r0, r20
	inc r2
divL2:	dec r17
	brne divL1
	pop r17
	ret

; aus eeconvert.cc
tabelle:	;static int tabelle[]=
	;; Temparaturen 10*mehr damit wir keine Fliesszahlen brauchen
	;; -550 ist also -55.0 GradCelsius
	.dw -550, 990, -500, 1040, -400, 1146, -300, 1260, -200, 1381
	.dw -100, 1510, 0, 1646, 100, 1790, 200, 1941, 250, 2020
	.dw 300, 2100, 400, 2267, 500, 2441, 600, 2623, 700, 2812
	.dw 800, 3009, 900, 3214, 1000, 3426, 1100, 3643, 1200, 3855
	.dw 1250, 3955, 1300, 4048, 1400, 4208, 1500, 4323, 0, 0
umrechnen:	;double umrechnen(int sensor,int variante,int wert)
.def wertL=r0	; Eingabe: wert=gemessen von AD-Wandler
.def wertH=r1	; Rueckgabe: r1:r0 = GradCelsius*10
.equ wr1=2000	;const double wr1=2000;
.equ wmax=1024	;const double wmax=1024;//Maximalwert 10-Bit-AD-Wandler + 1
	push r2
	push r3		;double r2,y; besser long wr2; int y
	push r16
	push r17
	push r18
	push r19
	push r20
	push r21
	push ZL
	push ZH
;bisher nur dieser Sensor und Variante:  if(sensor==222 && variante==1)
	ldi r16, low(wr1)	; wr2=wr1*wert/(wmax-wert);
	ldi r17, high(wr1)
	mov r18, r0
	mov r19, r1		;r19:r18 = wert
	mov r2, r16
	mov r3, r17
	rcall mul16		;r3:r2:r1:r0 = r1:r0 * r3:r2
	ldi r16, low(wmax)
	ldi r17, high(wmax)
	sub r16, r18
	sbc r17, r19
	rcall div16		;r3:r2:r1:r0 /= r17:r16
	mov r2, r0
	mov r3, r1		;r3:r2 = wr2 = Messwiderstand in Ohm
;;    int t0,t1;
;;    double w0,w1;
;;    for(i=0;tabelle[i+5]!=0 && wr2>tabelle[i+3];) i+=2;
;	clr r20			; i=0  (wegoptimiert)
	ldi ZL, low(tabelle<<1)
	ldi ZH, high(tabelle<<1)	; z = &tabelle[i]
forL1:	ldi r16, 5
	rcall getzi		; r17:r16 = z[5]
	tst r16
	brne forL2
	tst r17
	breq forende
forL2:	ldi r16, 3
	rcall getzi
	cp  r16, r2
	cpc r17, r3		; wr2>tabelle[i+3]?
	brcc forende		; nein-->
	adiw ZL, 4		;statt i+=2  z= &z[2] (4 wegen 2 Byte pro int)
	rjmp forL1
forende:
	lpm r18, Z+
	lpm r19, Z+		;r19:r18 = t0=tabelle[i];
	lpm r16, Z+
	lpm r17, Z+		;r17:r16 = w0=tabelle[i+1];
	lpm r0, Z+
	lpm r1, Z+		;r1:r0 = t1=tabelle[i+2];
	lpm r20, Z+
	lpm r21, Z+		;r21:r20 = w1=tabelle[i+3];
	sub r0, r18		;y=t0+(t1-t0)*(wr2-w0)/(w1-w0);
	sbc r1, r19		; (t1-t0)
	sub r2, r16
	sbc r3, r17		; (wr2-w0)
	rcall mul16		;r3:r2:r1:r0 = r1:r0 * r3:r2
	sub r20, r16
	sbc r21, r17		; (w1-w0)
	mov r16, r20
	mov r17, r21		;y=(t1-t0)*(wr2-w0)/(w1-w0)
	rcall div16		;r3:r2:r1:r0 /= r17:r16
	add r0, r18
	adc r1, r19		;y+=t0
	pop ZH
	pop ZL
	pop r21
	pop r20
	pop r19
	pop r18
	pop r17
	pop r16
	pop r3
	pop r2
	ret

getzi:	push ZL
	push ZH
	clr r17
	lsl r16
	add ZL, r16
	adc ZH, r17
	lpm r16, Z+
	lpm r17, Z+
	pop ZH
	pop ZL
	ret

mul16:		;r3:r2:r1:r0 = r1:r0 * r3:r2
	push r4
	push r5
	push r16
	push r17
	push r18
	push r19
	mov r16, r0
	mov r17, r1		; AB
	mov r18, r2
	mov r19, r3		; CD
	mul r17, r19		;A*C
	mov r2, r0		; EFGH = AB*CD --> EF=A*C GH=B*D EFG+=A*D+B*C
	mov r3, r1		; r3r2 = EF=A*C
	mul r16, r18		;B*D
	mov r4, r0
	mov r5, r1		; r5r4 = GH=B*D
	mul r17, r18		;A*D
	clr r17
	add r5, r0		; EFG+=A*D
	adc r2, r1
	adc r3, r17
	mul r16, r19		;B*C
	add r5, r0		; EFG+=B*C
	adc r2, r1
	adc r3, r17
	mov r0, r4
	mov r1, r5
	pop r19
	pop r18
	pop r17
	pop r16
	pop r5
	pop r4
	ret

div16:			;r3:r2:r1:r0 /= r17:r16, r17:r16 = Rest
	push r18
	push r19
	push r20
	clr r18
	clr r19
	ldi r20, 32
div16L1:lsl r0
	rol r1
	rol r2
	rol r3
	rol r18
	rol r19
	cp  r18, r16
	cpc r19, r17
	brcs div16L2
	sub r18, r16
	sbc r19, r17
	inc r0
div16L2:dec r20
	brne div16L1
	mov r16, r18
	mov r17, r19		;r17:r16 = Rest
	pop r20
	pop r19
	pop r18
	ret

;-----------------------------------------------------------------------------
;Interrupt-Routine fuer AD-Wandlung
; Registerbelegungen:
; r27:r26 == XH:XL = Zeiger auf zu speichernde Daten
; r9 = Datenspeichern-Flag, Anzahl Aufsummierungen,
;      auf 0 gesetzt wenn AD-Wandlung fertig
; r25:r24 Anzahl gespeicherte Messpunkte += 1
; r23:r22 = Rueckgabewert = Durchschnitt von 8 Wandlungen
adcomplete:
	push r16
	push r17
	in r17, SREG	;Statusregister sichern
	push r17
	tst r9		;allenfalls erste Wandlung verwerfen
	breq _end2
	in r16, ADCL	;L muss zuerst gelesen werden!
	in r17, ADCH
	add r22, r16
	adc r23, r17	;Summe += Messwert
	dec r9		;letzter Messert?
	brne _end3	;nein-->
	inc r9		; ja: r9 wieder richtig bovor sei..
	sei		;Interrupts erlauben
	asr r23		; ..und Durchschnitt berechnen.
	ror r22
	asr r23
	ror r22
	asr r23
	ror r22			;Summe /= 8 --> Rueckgabewert
;.if DATENFORMAT==0
;	mov r16, r23
;	rcall bytespeichern2 	;H zuerst speichern
;	mov r16, r22
;	rcall bytespeichern2	;L danach speichern
;.else ;if DATENFORMAT==1
;	rcall gepacktspeichern
;.endif
;	adiw r24, 1		;r25:r24 += 1
	dec r9			;erst auf 0 wenn Rueckgabe aktuell ist.
	out PORTB, r22		;test: aktueller Messwert auf LEDs
	rjmp _end4
_end2:	clr r22
	clr r23
	rjmp _end4
_end3:	sbi ADCSRA,6		;Starte naechste AD-Wandlung
_end4:	pop r17
	out SREG, r17	;Statusregister zurueckholen
	pop r17
	pop r16
	reti

;-----------------------------------------------------------------------------
; Messung starten
messung:
	tst r9
	brne messung		;ev. warten bis vorherige AD-Wandlung fertig
	ldi r22, 8		;Anzahl AD-Aufsummierungen
	mov r9, r22		;fuer naechste Wandlung setzen.
	clr r22
	clr r23			;Aufsummier-Register loeschen
	sbi ADCSRA,6		;Starte naechste AD-Wandlung
	ret
