;spmtest.asm

.include "m8def.inc"    ; Definitionsdatei fuer den Prozessortyp
.equ SRAMSTART=0x60	    ;beim Atmega8
.equ PAGESIZEB = PAGESIZE*2 ; PAGESIZEB is page size in BYTES, not words

.org LARGEBOOTSTART
; Reset und Interruptvectoren   ;VNr. Beschreibung
begin: rjmp	main		; 1   Power On Reset
	reti			; 2   Int0-Interrupt
	reti			; 3   Int1-Interrupt
	reti			; 4   TC2 Compare Match
	reti			; 5   TC2 Overflow
	reti			; 6   TC1 Capture
	reti			; 7   TC1 Compare Match A
	reti			; 8   TC1 Compare Match B
	reti			; 9   TC1 Overflow
	reti			; 10  TC0 Overflow
	reti			; 11  SPI, STC = Serial Transfer Complete
	reti			; 12  UART Rx Complete
	reti			; 13  UART Data Register Empty
	reti			; 14  UART Tx Complete
	reti			; 15  ADC Conversion Complete
	reti			; 16  EEPROM ready
	reti			; 17  Analog Comperator
	reti			; 18  TWI (I2C) Serial Interface
	reti			; 19  Store Program Memory ready
;-----------------------------------------------------------------------------
; Start, Power On, Reset
main:
	ldi r16, RAMEND&0xFF
        out SPL, r16  	     ; Init Stackpointer L
	ldi r16, RAMEND>>8
        out SPH, r16  	     ; Init Stackpointer H

	ldi r16, 0xFF		;Alle Leitungen auf Ausgang
        out DDRB, r16		;Data Direction Register B setzen
	ldi r16, 1
	out PORTB, r16		;rote LED an
	ldi YL, SRAMSTART
	ldi YH, 0
	clr r16
loop1:
	st Y+, r16
	inc r16
	brne loop1	;im SRAM Zahlen 0 bis 255 speichern
	ldi YL, SRAMSTART
	ldi YH, 0
	ldi ZL, 0x00
	ldi ZH, 0x00	;Startadresse im Flash=0x0000
	rcall write_page	;eine Page (=64Bytes beim Atmega8) speichern
	ldi r16, 2
	out PORTB, r16	;gruene LED an
	ldi XL, 0x80
	ldi XH, 0		;ab Byte-Adresse 0x0080 im Flash
	ldi YL, SRAMSTART
	ldi YH, 0
	ldi r17, 101		;101 Bytes speichern
loop2:	ld r16, Y+
	rcall imflashspeichern
	dec r17
	brne loop2
	ldi r16, 0xFF
	rcall endeimflashspeichern	;Rest der Page mit 0xFF fuellen
	ldi r16, 4
	out PORTB, r16	;gelbe LED an
fertig:
	rjmp fertig

imflashspeichern:		;1 Byte im Flash speichern
	;; zuerst Zwischenspeichern und dann 2 Byte aufs mal speichern
	;; jeweils Page loeschen bevor das erste Word gespeichert wird.
	;; r16 = zu speicherndes Byte
	;; XH:XL = Zeiger im Flash, wird um 1 erhoeht
	.def zwischenspeicher=r7
; oder falls kein Register belegt werden soll:
;	.equ ZWISCHENSPEICHER=SRAMSTART+256 ;2Byte im SRAM
	push r0
	push r1
	push r16
	push r17
	push ZL
	push ZH
	mov ZL, XL
	mov ZH, XH
	sbrs ZL, 0		;Z ungerade?
	rjmp zwischenspeichern	;nein--> erstes Byte zwischenspeichern
wordspeichern:
	dec ZL			;immer auf gerade Adresse 2 Bytes speichern
	mov r0, zwischenspeicher ;oder lds r0, ZWISCHENSPEICHER
	mov r1, r16
	ldi r17, (1<<SPMEN)
	rcall do_spm17
	adiw ZH:ZL, 2
	mov r17, ZL
	andi r17, PAGESIZEB-1	;wird beim naechsten Mal neue Page erreicht?
	brne incxandreturn	;nein-->
	subi ZL, low(PAGESIZEB)	;ja:  execute page write
	sbci ZH, high(PAGESIZEB) ;restore pointer
	ldi r17, (1<<PGWRT) + (1<<SPMEN)
	rcall do_spm17
	rjmp incxandreturn
zwischenspeichern:
	mov zwischenspeicher, r16	;oder sts ZWISCHENSPEICHER, r16
	mov r17, ZL
	andi r17, PAGESIZEB-1	;neue Page?
	brne incxandreturn	;nein-->
	ldi r17, (1<<PGERS) + (1<<SPMEN) ;ja: neue Page zuerst loeschen
	rcall do_spm17
incxandreturn:
	adiw XH:XL, 1
	pop ZH
	pop ZL
	pop r17
	pop r16
	pop r1
	pop r0
	ret
do_spm17:	;r17 ins SPMCR speichern und spm durchfuehren, r16 zerstoert
	in r16, SREG
	push r16	;; disable interrupts if enabled, store status
	cli
spmwait: in r16, SPMCR	;; check for previous SPM complete
	sbrc r16, SPMEN
	rjmp spmwait
	out SPMCR, r17	;; SPM timed sequence
	spm
	pop r16 ;; restore SREG (to enable interrupts if originally enabled)
	out SREG, r16
	ret
endeimflashspeichern:		;Rest der Page mit r16 auffuellen
	push r17
eflashloop:
	mov r17, XL
	andi r17, PAGESIZEB-1	;neue Page erreicht?
	breq eflashfertig	;ja-->
	rcall imflashspeichern
	rjmp eflashloop
eflashfertig:
	pop r17
	ret

;; This example shows SPM write of one page for devices with page write
;; - the routine writes one page of data from RAM to Flash
;;   the first data location in RAM is pointed to by the Y-pointer
;;   the first data location in Flash is pointed to by the Z-pointer
;; - error handling is not included
;; - the routine must be placed inside the boot space
;;   (at least the do_spm sub routine)
;; - registers used:	 r0, r1, temp1, temp2, looplo, loophi, spmcrval
;;   (temp1, temp2, looplo, loophi, spmcrval must be defined by the user)
	.def temp1= r2
	.def temp2= r3
	.def looplo= r24
	.def loophi= r25
	.def spmcrval= r16
;;   storing and restoring of registers is not included in the routine
;;   register usage can be optimized at the expense of code size
;  .equ PAGESIZEB = PAGESIZE*2 ; PAGESIZEB is page size in BYTES, not words
;  .org SMALLBOOTSTART
write_page:
	;; page erase
	ldi spmcrval, (1<<PGERS) + (1<<SPMEN)
	rcall do_spm
	;; transfer data from RAM to Flash page buffer
	ldi looplo, low(PAGESIZEB) ; init loop variable
	ldi loophi, high(PAGESIZEB) ; not required for PAGESIZEB<=256
wrloop:	ld r0, Y+
	ld r1, Y+
	ldi spmcrval, (1<<SPMEN)
	rcall do_spm
	adiw ZH:ZL, 2
	sbiw loophi:looplo, 2	; use subi for PAGESIZEB<=256
	brne wrloop
	;; execute page write
	subi ZL, low(PAGESIZEB)	; restore pointer
	sbci ZH, high(PAGESIZEB)	; not required for PAGESIZEB<=256
	ldi spmcrval, (1<<PGWRT) + (1<<SPMEN)
	rcall do_spm
	;; read back and check, optional
	ldi looplo, low(PAGESIZEB) ; init loop variable
	ldi loophi, high(PAGESIZEB) ; not required for PAGESIZEB<=256
	subi YL, low(PAGESIZEB)	; restore pointer
	sbci YH, high(PAGESIZEB)
rdloop:	lpm r0, Z+
	ld r1, Y+
	cpse r0, r1
	rjmp error
	sbiw loophi:looplo, 2	; use subi for PAGESIZEB<=256
	brne rdloop
error:		; provi. noch keine Fehlerbehandlung
	ret
do_spm:
	;; input:	 spmcrval determines SPM action
	;; disable interrupts if enabled, store status
	in temp2, SREG
	cli
	;; check for previous SPM complete
wait:	in temp1, SPMCR
	sbrc temp1, SPMEN
	rjmp wait
	;; SPM timed sequence
	out SPMCR, spmcrval
	spm
	;; restore SREG (to enable interrupts if originally enabled)
	out SREG, temp2
	ret
