/* heptris.cc			letzte nderung: 4.1.2003 */
#define VERSION "Version 0.3"
/*

 Kurzbeschreibung: 4-Dimensionales Tetris

History:
4.12.2002	Erstellung (RP)
17.12.02   0.1	erste spielbare Version
29.12.02   0.2  mit Punktezhlung
3.1.2003   0.3  Punktezhlung verbessert, kleine Fehler korrigiert
21.3.2015       makefile angepasst,
                Anpassungen an neue Compilerversion:
                 neu wird "include <string.h>" benoetigt,
                 in mehrzeiligem Strings wird bei Leerzeilen "\n\" benoetigt
		Kleiner Fehler korrigiert:
		 beim Testdruck von rawcode wird %04lX und (long)rawcode benoetigt
		 (damit es sowohl auf 32 Bit wie auch auf 64 Bit Maschinen funktioniert)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef AMIGA
#include "h:amitekplot1.h"
#else
#include <xtekplot1.h>
#endif
#include "vektorklasse.cc"
#include "matrixklasse.h"

const int TIEFE=5; //32 Farben reichen vorlufig
const int BREITE=1024,HOEHE=768;//test
const int SCHWARZ=0,WEISS=1,GRAU=2,ROT=3,GRUEN=4,BLAU=5,DUNKELGRAU=16;
const int DUNKEL=16;//ab ROT dazuzaehlen um dunkle Farbe zu erhalten
const int NFARBEN=32;//Anzahl definierte Farben
const int GESTOPPT=0,AMSTARTEN=1,GESTARTET=2;//Gamestatus
const char *heptname=".heptris"; //Dateiname fr Einstellungen
const char *hisname="heptris.hiscores"; //Dateiname der Ruhmeshalle
const int PUNKTEPROREIHE=10,PUNKTEPROEBENE=500,PUNKTEPROVOLUM=50000;

/************************* Vordeklarationen ***************************/
void fehler(char*s,int p1=0,int p2=0,int p3=0);
void fehler(char*s,char*p1=0,char*p2=0,char*p3=0);
void mauspre(),mausrel(),mausmot();
void redraw(),redraw1();

class Scores
{
 int topten[10];
 char topname[10][80];
public:
 Scores();
 void zeichnen();
 void show();
 void save(int);
};

/************************ Globale Variablen ***************************/
static double xmin=0.0,ymin=0.0,xmax=33.5,ymax=25.7;
static double bx=0.20,hy=0.35, //kleine Schrift
	      bx1=0.40,hy1=0.50, //mittlere Schrift
	      bx2=0.50,hy2=0.70, //grosse Schrift
	      hy0=0.0; //wirkliche Hhe der kleinen Schrift
const double ybo=4.0; //Bodenhhe der 3D-Darstellung
static vektor u1(2.0,ybo),u2(12.0,ybo),u3(19.0,ybo),u4(26.0,ybo),
	      u5(26.0,ybo+12.5);
static Scores scores;
static char scratch[400];

/*************************** Kleinkram ********************************/
void pause(int n=10) {for(int i=0;i<n;i++) waitTOF();}
inline int STEINFARBE(int n) {return (n-1)%12+3;}

void farbensetzen(int n,UBYTE farbtabelle[][3])
{
 for(int i=0;i<n;i++)
     setcolor(i,farbtabelle[i][0],farbtabelle[i][1],farbtabelle[i][2]);
}

void zufallstart()
{
 int startwert=7845;
 double x;
 FILE *fp=fopen("/proc/uptime","r");
 if(fp) {fscanf(fp,"%lf",&x); fclose(fp); startwert=int(100*x);}
 srand(startwert);
}

/*************************** Vectoren *********************************/
class Vektor4 //einfacher 4-D-Vektor
{
public:
 double x,y,z,t;
 Vektor4() {}
 Vektor4(double a,double b,double c,double d) {x=a; y=b; z=c; t=d;}
 Vektor4 operator+=(Vektor4 v) {x+=v.x; y+=v.y; z+=v.z; t+=v.t; return *this;}
 Vektor4 operator-=(Vektor4 v) {x-=v.x; y-=v.y; z-=v.z; t-=v.t; return *this;}
 friend Vektor4 operator+(Vektor4,Vektor4);
 friend Vektor4 operator*(Vektor4,double);
};
Vektor4 operator+(Vektor4 v1,Vektor4 v2)
{
 Vektor4 z; z.x=v1.x+v2.x; z.y=v1.y+v2.y; z.z=v1.z+v2.z; z.t=v1.t+v2.t;
 return z;
}
Vektor4 operator*(Vektor4 v1,double c)
{
 Vektor4 z; z.x=v1.x*c; z.y=v1.y*c; z.z=v1.z*c; z.t=v1.t*c;
 return z;
}

const int ZY=0,YZ=1,XZ=2,ZX=3,YX=4,XY=5,XT=6,TX=7,YT=8,TY=9,ZT=10,TZ=11;
Matrix drehmatrix(double co,double si,int tausch)
{
 Matrix a(4,4);
 switch(tausch)
 {case YX: {double f[]={co,-si,0,0, si,co,0,0, 0,0,1,0, 0,0,0,1}; a.set(f);}
           break;
  case XY: {double f[]={co,si,0,0, -si,co,0,0, 0,0,1,0, 0,0,0,1}; a.set(f);}
           break;
  case ZX: {double f[]={co,0,-si,0, 0,1,0,0, si,0,co,0, 0,0,0,1}; a.set(f);}
           break;
  case XZ: {double f[]={co,0,si,0, 0,1,0,0, -si,0,co,0, 0,0,0,1}; a.set(f);}
           break;
  case ZY: {double f[]={1,0,0,0, 0,co,-si,0, 0,si,co,0, 0,0,0,1}; a.set(f);}
           break;
  case YZ: {double f[]={1,0,0,0, 0,co,si,0, 0,-si,co,0, 0,0,0,1}; a.set(f);}
           break;
  case TX: {double f[]={co,0,0,-si, 0,1,0,0, 0,0,1,0, si,0,0,co}; a.set(f);}
           break;
  case XT: {double f[]={co,0,0,si, 0,1,0,0, 0,0,1,0, -si,0,0,co}; a.set(f);}
           break;
  case TY: {double f[]={1,0,0,0, 0,co,0,-si, 0,0,1,0, 0,si,0,co}; a.set(f);}
           break;
  case YT: {double f[]={1,0,0,0, 0,co,0,si, 0,0,1,0, 0,-si,0,co}; a.set(f);}
           break;
  case TZ: {double f[]={1,0,0,0, 0,1,0,0, 0,0,co,-si, 0,0,si,co}; a.set(f);}
           break;
  case ZT: {double f[]={1,0,0,0, 0,1,0,0, 0,0,co,si, 0,0,-si,co}; a.set(f);}
           break;
 }
 return a;
}
Matrix drehmatrix(double alfa,int tausch)
{
 double co=cos(alfa),si=sin(alfa);
 return drehmatrix(co,si,tausch);
}
Matrix drehmatrix(int grad,int tausch)
{
 double co=1,si=0;
 switch(grad)
   {case 90: case -270: co=0; si=1; break;
    case -90: case 270: co=0; si= -1; break;
    case 180: case -180: co= -1; si=0; break;
   }
 return drehmatrix(co,si,tausch);
}
Vektor4 vdrehen(Vektor4 v,int zy,	//Vektor um Winkel w drehen im zy-Sinn
		double si,double co)	//si=sin(w) co=cos(w)
{
 Vektor4 z;
 switch(zy)
  {case XY:
      z.x=v.x*co-v.y*si;
      z.y=v.x*si+v.y*co;
      z.z=v.z; z.t=v.t; break;
   case YZ:
      z.y=v.y*co-v.z*si;
      z.z=v.y*si+v.z*co;
      z.x=v.x; z.t=v.t; break;
   case ZY:
      z.z=v.z*co-v.y*si;
      z.y=v.z*si+v.y*co;
      z.x=v.x; z.t=v.t; break;
   default: fehler("falscher Sinn in vdrehen: zy=%d",zy);
  }
 return z;
}
inline Vektor4 vdrehen(Vektor4 v,int zy,double w)
{
 return vdrehen(v,zy,sin(w),cos(w));
}

/********************* Beschriftungen, Gadgets ************************/
class Hgadget
{
 char text[80];
 int nwert,maxn;
 bool aktivflag;
 double textbreite,texth;
 vektor box[2];
public:
 void init(char* s,double b,double h,int n,int max,
	   double x1,double y1,double x2,double y2);
 void settext(char* s) {strcpy(text,s);}
 void zeichnen();
 int getn() {return nwert;}
 bool istinbox(double x,double y)
	{return x>=box[0].x && x<=box[1].x && y>=box[0].y && y<=box[1].y;}
 void klick(double x,double y);
 bool istaktiv() {return aktivflag;}
 void aktiv(bool b) {aktivflag=b;}
};
void Hgadget::init(char* s,double b,double h,int n,int max,
		  double x1,double y1,double dx,double dy)
{
 strcpy(text,s); textbreite=b; texth=h;
 nwert=n; maxn=max;
 box[0]=vektor(x1,y1); box[1]=vektor(x1+dx,y1+dy);
}
void Hgadget::klick(double x,double y)
{
 double ymitte=(box[0].y+box[1].y)/2.0;
 if(y>ymitte && nwert<maxn) nwert++;
 if(y<ymitte && nwert>0) nwert--;
}
void Hgadget::zeichnen()
{
 if(hy0==0.0) hy0=textsize(bx,hy);
 schrift(box[0].x-textbreite,box[0].y+texth,text);
 char str[40]; sprintf(str,"%d",nwert);
 schrift((box[0].x+box[1].x-bx)/2.0,(box[0].y+box[1].y-hy0)/2.0,str);
 if(aktivflag) color(ROT);
 drawbox(box[0].x,box[0].y,box[1].x,box[1].y);
 if(aktivflag) color(SCHWARZ);
}

/************************ Steine, Spielfeld ***************************/
const int HEPT=7;

class Stein
{
 Matrix wuerfel,altw;
public:
 Stein() {wuerfel.resize(HEPT,4);}
 void set(double a[HEPT*4]) {wuerfel.set(a);}
 double& elem(int i,int k) {return wuerfel.elem(i,k);}
 double& e(int i,int k) {return wuerfel.e(i,k);}
 Vektor4 operator[](int);
 void drehen(int grad,int tausch);
 void drehundo() {wuerfel=altw;}
};
static double steineliste[]={
/* Pentris-Steine
//sehr flache Steine (2D, Heptomino-Steine):
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 4,0,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 0,1,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 1,1,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 0,2,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 1,1,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 2,1,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 1,1,0,0, 1,2,0,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 2,1,0,0, 3,1,0,0,
 0,0,0,0, 1,0,0,0, 1,1,0,0, 1,2,0,0, 2,1,0,0,
 0,0,0,0, 1,0,0,0, 1,1,0,0, 1,2,0,0, 2,2,0,0,
 0,0,0,0, 1,0,0,0, 1,1,0,0, 2,1,0,0, 2,2,0,0,
 1,0,0,0, 1,1,0,0, 0,1,0,0, 1,2,0,0, 2,1,0,0,
//flache Steine (3D):
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 0,0,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 1,0,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 2,0,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 0,1,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 1,1,0,0, 1,0,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 1,1,0,0, 1,1,1,0,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 1,1,0,0, 1,1,1,0,
 0,0,0,0, 1,0,0,0, 1,1,0,0, 1,0,1,0, 2,0,1,0, 
 0,0,0,0, 1,0,0,0, 1,1,0,0, 1,1,1,0, 0,1,1,0, 
//wirklich 4-dimensional:
 0,0,0,0, 1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 0,0,1,0, 1,0,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 1,0,1,0, 0,1,0,1
*/
//flache Steine (3D):
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 4,0,0,0, 0,1,0,0, 0,0,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 1,1,0,0, 0,1,0,0, 1,0,1,0,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 2,1,0,0, 0,1,0,0, 2,0,1,0,
 0,0,0,0, 1,0,0,0, 1,1,0,0, 2,1,0,0, 1,0,1,0, 2,0,1,0, 2,0,2,0,
 0,0,0,0, 1,0,0,0, 1,1,0,0, 1,1,1,0, 2,1,1,0, 0,1,1,0, 0,1,2,0, 
 0,0,0,0, 1,0,0,0, 2,0,0,0, 1,1,0,0, 1,2,0,0, 1,0,1,0, 1,0,2,0,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 0,2,0,0, 1,1,0,0, 1,1,1,0, 1,1,2,0,
//wirklich 4-dimensional:
 0,0,0,0, 1,0,0,0, 2,0,0,0, 3,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1,
 0,0,0,0, 1,0,0,0, 2,0,0,0, 0,1,0,0, 0,2,0,0, 0,0,1,0, 1,0,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 1,0,1,0, 1,0,2,0, 1,0,3,0, 0,1,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 2,0,0,0, 1,0,1,0, 1,0,2,0, 0,1,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 2,0,0,0, 2,0,1,0, 1,0,1,0, 0,1,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 0,1,1,0, 0,1,2,0, 0,2,2,0, 0,1,0,1,
 0,0,0,0, 1,0,0,0, 0,1,0,0, 1,1,0,0, 1,1,1,0, 1,1,2,0, 0,1,0,1
};

const int anzhept= //Anzahl vorhandene Heptrissteine
	sizeof(steineliste)/(4*HEPT*sizeof(double));

static Stein hept[anzhept];

void hept_init()
{
// printf("anzhept=%d\n",anzhept);//test
 for(int i=0;i<anzhept;i++)
     hept[i].set(&steineliste[4*HEPT*i]);
}

Vektor4 Stein::operator[](int i)
{
 Vektor4 v;
 v.x=e(i,0); v.y=e(i,1); v.z=e(i,2); v.t=e(i,3);
 return v;
}
void Stein::drehen(int grad,int tausch)
{
 altw=wuerfel;
 wuerfel=wuerfel*drehmatrix(grad,tausch);
}
//Ecken des Schachts in den die Steine fallen
const int WX=35;
static Vektor4
    eck1(0,0,0,0), eck2(0,10,0,0), eck3(0,10,10,0), eck4(0,0,10,0),
   eck5(WX,0,0,0),eck6(WX,10,0,0),eck7(WX,10,10,0),eck8(WX,0,10,0);

const int ngadgets=4;

const double KZX=0.5;//Kuerzung von z bei Abbildung auf x
const double KZY=0.4;//Kuerzung von z bei Abbildung auf y

class Spielfeld
{
 Stein stein; int steinnr;//einzusetzender Stein
 int spx,spy,spz,spt;//momentane Steinposition
 Hgadget gadget[ngadgets];
 Stein zufallstein();
 int ausblend;//Ausgeblendete Koordinate (t,z oder y)
 int ansicht;//0 = Darstellung des Schachts,
             //1 = Darstellung des Raums bei x=0 (=auszufllender Bereich)
 int nreihen,nebenen,nvolums;//Ausgefllte Teile fr Punktezhlung
 void screenclear(int);
 int raumcheck(int);
public:
 BYTE welt[WX][10][10][10]; //[x][y][z][t]
 int punkte,gamestatus; char spielername[80];
 Spielfeld();
 ~Spielfeld();
 void neuerstein(int n);
 int getsteinnr() {return steinnr;}
 void steinsetzen(int ix,int iy,int iz,int it);
 bool steintesten(int ix,int iy,int iz,int it);
 bool steinschieben(int ix,int iy,int iz,int it);
 bool steinschieben2(int ix,int iy,int iz,int it);
 void steinfallenlassen();
 void steinentfernen();
 bool steindrehen(int);
 void ansichtdrehen(int w);
 int getausblend() {return ausblend;}
 void ausblenden(int c);
 void startgame();
 void stopgame();
 int zusatzpunkte();
//Dinge zum Zeichnen in Bildschirmkoordinaten
 void zeichnen();
protected:
 vektor ursprung;
 int bereich;
 double bskal;
 int flag3d;
 int alfa; //Gedrehte 3D-Ansicht in Grad
 double sinalfa,cosalfa,kzx,kzy;
 int getwelt(int,int,int,int);
 int getwelt3d(int,int,int,int);
public:
 void drawinit(vektor u,char achse1,char achse2,char achse3=0);
 void move2(Vektor4 v,int pen);
 vektor punkt2(Vektor4 v);
 void move(Vektor4 v) {move2(v,PENUP);}
 void draw(Vektor4 v) {move2(v,PENDOWN);}
 void quadrat(int x,int y);
 void wuerfel(int fa,double x,double y);
 void wuerfel2(int fa,int ix,int iy,int iz);
//Reaktionen auf Maus
 bool mausklick(double x,double y);
 bool mausmove(double x,double y);
//Spielstand
 void save(FILE*);
 void load(FILE*);
};
bool Spielfeld::mausklick(double x,double y)
{
 for(int i=0;i<ngadgets;i++)
     if(gadget[i].istinbox(x,y))
      {gadget[i].klick(x,y); return true;}
 return false;
}
bool Spielfeld::mausmove(double x,double y)
{
 bool update=false;
 for(int i=0;i<ngadgets;i++)
     if(gadget[i].istinbox(x,y))
      {if(gadget[i].istaktiv()) return false;
       gadget[i].aktiv(true); return true;
      }
 for(int i=0;i<ngadgets;i++)
     if(gadget[i].istaktiv()) {gadget[i].aktiv(false); update=true;}
 return update;
}
Spielfeld::Spielfeld()
{
 zufallstart();
 hept_init();
 for(int x=0;x<WX;x++)
 for(int y=0;y<10;y++)
 for(int z=0;z<10;z++)
 for(int t=0;t<10;t++)
     welt[x][y][z][t]=0;
 neuerstein(0);
 gadget[0].init("Schnitt durch 4-dimensionalen Raum bei t=",7.3,0.2,
		0,9, 7.8,ybo-2, 0.4,0.8);
 gadget[1].init("x-y-Ebene z=",2.4,0.2, 0,9, 14.9,ybo-2, 0.4,0.8);
 gadget[2].init("x-z-Ebene y=",2.4,0.2, 0,9, 21.9,ybo-2, 0.4,0.8);
 gadget[3].init("z-y-Ebene x=",2.4,0.2, 0,34, 28.9,ybo-2, 0.4,0.8);
 flag3d=0; alfa=0; sinalfa=0.0; cosalfa=1.0;
 kzx=KZX; kzy=KZY;
 punkte=0; gamestatus=0; strcpy(spielername,"Name");
 ausblend='t'; ansicht=0;
 FILE *fp=fopen(heptname,"r");
 if(fp!=NULL)
   {fscanf(fp,"%s %s",scratch,spielername);
    fscanf(fp,"%lf %lf %lf %lf %lf %lf",&bx,&hy,&bx1,&hy1,&bx2,&hy2);
    fclose(fp);
   }
 startgame();
}
Spielfeld::~Spielfeld()
{
 FILE *fp;
 if(spielername[0]!=0 && (fp=fopen(heptname,"w"))!=NULL)
   {fprintf(fp,"HeptrisEinstellungen\n%s\n",spielername);
    fprintf(fp,"%lf %lf %lf %lf %lf %lf\n",bx,hy,bx1,hy1,bx2,hy2);
    fclose(fp);
   }
}
bool Spielfeld::steintesten(int ix,int iy,int iz,int it)
{
 Vektor4 v;
 int x,y,z,t;
 for(int i=0;i<HEPT;i++)
   {v=stein[i];
    x=ix+int(v.x); y=iy+int(v.y); z=iz+int(v.z); t=it+int(v.t);
    if(x<0 || x>=WX) return false;
    if(y<0 || y>=10) return false;
    if(z<0 || z>=10) return false;
    if(t<0 || t>=10) return false;
    if(welt[x][y][z][t]!=0) return false;
   }
 return true;
}
void Spielfeld::steinsetzen(int ix,int iy,int iz,int it)
{
 Vektor4 v;
 for(int i=0;i<HEPT;i++)
   {v=stein[i];
    welt[ix+int(v.x)][iy+int(v.y)][iz+int(v.z)][it+int(v.t)]=steinnr;
   }
 spx=ix; spy=iy; spz=iz; spt=it;
}
void Spielfeld::steinentfernen()
{
 Vektor4 v;
 for(int i=0;i<HEPT;i++) //Stein aus welt entfernen
   {v=stein[i];
    welt[spx+int(v.x)][spy+int(v.y)][spz+int(v.z)][spt+int(v.t)]=0;
   }
}
bool Spielfeld::steinschieben(int ix,int iy,int iz,int it)
{
 steinentfernen();
 if(steintesten(spx+ix,spy+iy,spz+iz,spt+it)==false)
     {steinsetzen(spx,spy,spz,spt);//entfernter Stein wieder einsetzen
      return false;
     }
 steinsetzen(spx+ix,spy+iy,spz+iz,spt+it);//Stein an neuer Position einsetzen
 return true;
}
bool Spielfeld::steinschieben2(int ix,int iy,int iz,int it)
{
 if(ausblend=='z') return steinschieben(ix,iy,it,iz);
 if(ausblend=='y') return steinschieben(ix,it,iz,iy);
 return steinschieben(ix,iy,iz,it);
}
bool Spielfeld::steindrehen(int tausch)
{
//ZY=0,YZ=1,XZ=2,ZX=3,YX=4,XY=5,XT=6,TX=7,YT=8,TY=9,ZT=10,TZ=11;
 const int tay[]={ZT,TZ,XZ,ZX,TX,XT,XY,YX,TY,YT,ZY,YZ}; //Y<->T
 const int taz[]={TY,YT,XT,TX,YX,XY,XZ,ZX,YZ,ZY,TZ,ZT}; //Z<->T
 int tau;
 switch(ausblend)
   {case 'y': tau=tay[tausch]; break;
    case 'z': tau=taz[tausch]; break;
    case 't': default: tau=tausch;
   }
 steinentfernen();
 stein.drehen(90,tau);
 if(steintesten(spx,spy,spz,spt)==false)
     {stein.drehundo();
      steinsetzen(spx,spy,spz,spt);//entfernter Stein wieder einsetzen
      return false;
     }
 steinsetzen(spx,spy,spz,spt);//gedrehter Stein einsetzen
 return true;
}
void Spielfeld::save(FILE *fp)
{
 fprintf(fp,"%d %d %d %d %d\n",steinnr,spx,spy,spz,spt);
 fprintf(fp,"%d\n",punkte);
 for(int i=0;i<WX-2*HEPT;i++)
   for(int y=0;y<10;y++)
   for(int z=0;z<10;z++)
    {for(int t=0;t<10;t++)
	fprintf(fp,"%d ",welt[i][y][z][t]);
     if(z&1) fprintf(fp,"\n");
    }
}
void Spielfeld::load(FILE *fp)
{
 int we;
 steinentfernen();
 fscanf(fp,"%d %d %d %d %d",&steinnr,&spx,&spy,&spz,&spt);
 stein=hept[steinnr-1];
 fscanf(fp,"%d",&punkte);
 ausblend='t'; ansicht=0;
 flag3d=0; alfa=0; sinalfa=0.0; cosalfa=1.0;
 for(int i=0;i<WX-2*HEPT;i++)
   for(int y=0;y<10;y++)
   for(int z=0;z<10;z++)
    {for(int t=0;t<10;t++)
	{fscanf(fp,"%d",&we); welt[i][y][z][t]=we;}
    }
 steinsetzen(spx,spy,spz,spt);
 zufallstart();
}
void Spielfeld::screenclear(int farbe)
{
 color(farbe); fillbox(xmin,ymin,xmax,ymax);
}
void Spielfeld::steinfallenlassen()
{
 if(ansicht==1) {ausblenden('x'); return;}
 inital_new();
 for(bool schieb=true;schieb!=false;)
     {schieb=steinschieben(-1,0,0,0);
      waitBOF();//Bildaufbau abwarten
      screenclear(GRAU);
      zeichnen();
     }
 term_refresh();
 int n;
 if((n=raumcheck(WX-HEPT))!=0)
    janeinrequester("Schacht ist voll - Spiel wird beendet");
 neuerstein(0);
 punkte++;
 punkte+=zusatzpunkte();
 if(gamestatus==AMSTARTEN) gamestatus=GESTARTET;
 if(n!=0) stopgame();
 return;
}
Stein Spielfeld::zufallstein()
{
 static int startflag=1;
 if(startflag) //allererster Stein soll einfach sein
     {steinnr=rand()%anzhept/4+1; startflag=0;}
 else steinnr=rand()%anzhept+1;
 //printf("Naechster Stein ist Nummer %d\n",steinnr);//test
 return hept[steinnr-1];
}
void Spielfeld::neuerstein(int n)
{
 if(n>0 && n<=anzhept) stein=hept[(steinnr=n)-1];
 else stein=zufallstein();
 steinsetzen(WX-HEPT,0,0,0);
}
void Spielfeld::ansichtdrehen(int w)
{
 alfa=(w==0)?0:alfa+w;
 if(alfa >  180)  alfa -= 360;
 if(alfa < -180)  alfa += 360;
 sinalfa=sin(alfa*GRAD); cosalfa=cos(alfa*GRAD);
}
void Spielfeld::drawinit(vektor u,char achse1,char achse2,char achse3)
{
 bskal=0.5;
 if(achse1=='x' && achse2=='y' && achse3=='z') bereich=1;
 else if(achse1=='x' && achse2=='y' && achse3==0) bereich=2;
 else if(achse1=='x' && achse2=='z' && achse3==0) bereich=3;
 else if(achse1=='z' && achse2=='y' && achse3==0) bereich=4;
 else {fehler("falsche Achsen %c%c%c",achse1,achse2,achse3); bereich=4;}
 ursprung=u;
}
void Spielfeld::move2(Vektor4 v,int pen)
{
 double x,y;
 if(flag3d && alfa!=0)
     {static Vektor4 drehpunkt(0,5,5,0);
      v-=drehpunkt;
      v=vdrehen(v,YZ,sinalfa,cosalfa);
      v+=drehpunkt;
      kzx=KZX; kzy=KZY;
      //kzx=KZX/2+KZX/2*cos(alfa*GRAD*2);//test
      //kzy=KZY/2-KZY/2*sin(alfa*GRAD*2);//test
     }
 else {kzx=KZX; kzy=KZY;}//provi. Konzept neu ueberdenken
 switch(bereich)
 {case 1: x=v.y+v.z*kzx; y=v.x+v.z*kzy; break;
  case 2: x=v.y; y=v.x; break;
  case 3: x=v.z; y=v.x; break;
  case 4: x=v.y; y=v.z; break;
  default: fehler("falscher bereich=%d",bereich);
 }
 x=x*bskal+ursprung.x; y=y*bskal+ursprung.y;
 plot(x,y,pen);
}
vektor Spielfeld::punkt2(Vektor4 v)
{
 vektor v2;
 double x,y;
 if(flag3d && alfa!=0)
     {static Vektor4 drehpunkt(0,5,5,0);
      v-=drehpunkt;
      v=vdrehen(v,YZ,sinalfa,cosalfa);
      v+=drehpunkt;
     }
 switch(bereich)
 {case 1: x=v.y+v.z*kzx; y=v.x+v.z*kzy; break;
  case 2: x=v.y; y=v.x; break;
  case 3: x=v.z; y=v.x; break;
  case 4: x=v.y; y=v.z; break;
  default: fehler("falscher bereich=%d",bereich);
 }
 v2.x=x*bskal+ursprung.x; v2.y=y*bskal+ursprung.y;
 return v2;
}
void Spielfeld::quadrat(int x,int y)
{
 double x1,y1,x2,y2;
 x1=x*bskal+ursprung.x; x2=x1+bskal;
 y1=y*bskal+ursprung.y; y2=y1+bskal;
 fillbox(x1,y1,x2,y2);
 color(DUNKELGRAU);//Kanten zeichnen
 drawbox(x1,y1,x2,y2);
}
void Spielfeld::wuerfel(int fa,double x,double y)
{
 double x1,y1,x2,y2,dx,dy,xf[4],yf[4],xg[4],yg[4];
 x1=x*bskal+ursprung.x; x2=x1+bskal;
 y1=y*bskal+ursprung.y; y2=y1+bskal;
 color(fa);
 fillbox(x1,y1,x2,y2);
 color(fa+DUNKEL);
 dx=bskal*kzx; dy=bskal*kzy;
 xf[0]=xf[3]=x2; yf[0]=y1;
 xf[1]=xf[2]=x2+dx; yf[1]=y1+dy;
 yf[2]=y2+dy;
 yf[3]=y2;
 fillpolygon(4,xf,yf);
// color(fa+HELLER);
 color(fa);
 yg[0]=yg[3]=y2; xg[0]=x1;
 yg[1]=yg[2]=y2+dy; xg[1]=x1+dx;
 xg[2]=x2+dx;
 xg[3]=x2;
 fillpolygon(4,xg,yg);
 color(DUNKELGRAU);//Kanten zeichnen
 drawbox(x1,y1,x2,y2); plot(x2,y2,PENUP); plot(x2+dx,y2+dy,PENDOWN);
 plot(x2+dx,y1+dy,PENDOWN); plot(x2,y1,PENDOWN);
 plot(x2+dx,y2+dy,PENUP); plot(x1+dx,y2+dy,PENDOWN); plot(x1,y2,PENDOWN);
}
/*
void fillpolygon(int n,vektor vf[])
{
 double xf[n],yf[n];
 for(int i=0;i<n;i++) {xf[i]=vf[i].x; yf[i]=vf[i].y;}
 fillpolygon(n,xf,yf);
}
*/
inline void plot(vektor v,int pen) {plot(v.x,v.y,pen);}
void flaeche(vektor p1,vektor p2,vektor p3,vektor p4)
{
 double xf[4],yf[4];
 xf[0]=p1.x; xf[1]=p2.x; xf[2]=p3.x; xf[3]=p4.x;
 yf[0]=p1.y; yf[1]=p2.y; yf[2]=p3.y; yf[3]=p4.y;
 fillpolygon(4,xf,yf);
}
void Spielfeld::wuerfel2(int fa,int ix,int iy,int iz)
{
// double x1,y1,x2,y2,dx,dy,xf[4],yf[4],xg[4],yg[4];
 vektor p1,p2,p3,p4,p5,p6,p7,p8;
 int pflags=0;//1=p1 4=p4 8=p8 2=p5
 double dx;
 const double halb=0.4;
// color(fa+HELLER);
 color(fa); //obere Seite
 p2=punkt2(Vektor4(ix+1,iy,iz,0));
 p3=punkt2(Vektor4(ix+1,iy+1,iz,0));
 p6=punkt2(Vektor4(ix+1,iy,iz+1,0));
 p7=punkt2(Vektor4(ix+1,iy+1,iz+1,0));
 flaeche(p2,p3,p7,p6);
 if((dx=p3.x-p2.x)>0)
   {if(dx>halb) color(fa); //vordere Seite
    else color(fa+DUNKEL); //rechte oder linke Seite
    p1=punkt2(Vektor4(ix,iy,iz,0));
    p4=punkt2(Vektor4(ix,iy+1,iz,0)); pflags|=5;
    flaeche(p1,p2,p3,p4);
   }
 if((dx=p7.x-p3.x)>0)
   {if(dx>halb) color(fa); else color(fa+DUNKEL);
    if(!(pflags&4)) {p4=punkt2(Vektor4(ix,iy+1,iz,0)); pflags|=4;}
    p8=punkt2(Vektor4(ix,iy+1,iz+1,0)); pflags|=8;
    flaeche(p4,p3,p7,p8);
   }
 if((dx=p6.x-p7.x)>0)
   {if(dx>halb) color(fa); else color(fa+DUNKEL);
    if(!(pflags&8)) {p8=punkt2(Vektor4(ix,iy+1,iz+1,0)); pflags|=8;}
    p5=punkt2(Vektor4(ix,iy,iz+1,0)); pflags|=2;
    flaeche(p8,p7,p6,p5);
   }
 if((dx=p2.x-p6.x)>0)
   {if(dx>halb) color(fa); else color(fa+DUNKEL);
    if(!(pflags&1)) {p1=punkt2(Vektor4(ix,iy,iz,0)); pflags|=1;}
    if(!(pflags&2)) {p5=punkt2(Vektor4(ix,iy,iz+1,0)); pflags|=2;}
    flaeche(p5,p6,p2,p1);
   }
 color(DUNKELGRAU);//Kanten zeichnen
 plot(p2,PENUP); plot(p3,PENDOWN); plot(p7,PENDOWN); plot(p6,PENDOWN);
 plot(p2,PENDOWN);
 if(pflags&1)
   {plot(p1,PENDOWN); if(pflags&4) {plot(p4,PENDOWN); plot(p3,PENDOWN);}}
 else if(pflags&4) {plot(p3,PENUP); plot(p4,PENDOWN);}
 if(pflags&8)
   {plot(p7,PENUP); plot(p8,PENDOWN); if(pflags&4) plot(p4,PENDOWN);}
 if(pflags&2)
   {plot(p6,PENUP); plot(p5,PENDOWN);
    if(pflags&8) plot(p8,PENDOWN);
    if(pflags&1) {plot(p5,PENUP); plot(p1,PENDOWN);}
   }
}
int Spielfeld::getwelt(int ix,int iy,int iz,int it)
{
 if(ausblend=='z') return welt[ix][iy][it][iz];
 if(ausblend=='y') return welt[ix][it][iz][iy];
 return welt[ix][iy][iz][it];
}
int Spielfeld::getwelt3d(int ix,int iy,int iz,int it)
{
 if(ansicht==1)
  {if(ix<10) {return welt[0][iy][iz][ix];}
   else if(ix>=WX-10)
     {int n,t=ix-(WX-10);
      for(int i=WX;--i>=WX-10;)
	 if((n=welt[i][iy][iz][t])!=0) return n;
      return n;
     }
  }
 return getwelt(ix,iy,iz,it);
}
void Spielfeld::zeichnen()
{
 int n,ix,iy,iz,it;
 it=gadget[0].getn();

 //3D-Schacht zeichnen:
 flag3d=1;
 drawinit(u1,'x','y','z');
 color(SCHWARZ);
 move(eck1); draw(eck2); draw(eck3); draw(eck4); draw(eck1); draw(eck5);
 draw(eck6); draw(eck7); draw(eck8); draw(eck5);
 move(eck2); draw(eck6); move(eck3); draw(eck7); move(eck4); draw(eck8);
 if(ansicht==1)
  {Vektor4 xw10(WX-10,0,0,0);
   move(eck1+xw10); draw(eck2+xw10); draw(eck3+xw10); draw(eck4+xw10);
   draw(eck1+xw10);
  }
 if(alfa >= -65 && alfa<=25) //also im Bereich 0 Grad
  {for(iz=10;--iz>=0;)
   for(iy=0;iy<10;iy++)
   for(ix=0;ix<WX;ix++)
     {n=getwelt3d(ix,iy,iz,it);
      if(n>0) wuerfel2(STEINFARBE(n),ix,iy,iz);
     }
   color(SCHWARZ);
   move(eck1); draw(eck2); draw(eck3); draw(eck7);
   move(eck1); draw(eck5); draw(eck6); draw(eck7);
   move(eck2); draw(eck6);
  }
 else if(alfa>25 && alfa<=115) //also im Bereich 90 Grad
  {for(iy=10;--iy>=0;)
   for(iz=10;--iz>=0;)
   for(ix=0;ix<WX;ix++)
     {n=getwelt3d(ix,iy,iz,it);
      if(n>0) wuerfel2(STEINFARBE(n),ix,iy,iz);
     }
   color(SCHWARZ);
   move(eck4); draw(eck1); draw(eck2); draw(eck6);
   move(eck4); draw(eck8); draw(eck5); draw(eck6);
   move(eck1); draw(eck5);
  }
 else if(alfa < -65 && alfa >= -155) //also im Bereich -90 Grad
  {for(iy=0;iy<10;iy++)
   for(iz=0;iz<10;iz++)
   for(ix=0;ix<WX;ix++)
     {n=getwelt3d(ix,iy,iz,it);
      if(n>0) wuerfel2(STEINFARBE(n),ix,iy,iz);
     }
   color(SCHWARZ);
   move(eck2); draw(eck3); draw(eck4); draw(eck8);
   move(eck2); draw(eck6); draw(eck7); draw(eck8);
   move(eck3); draw(eck7);
  }
 else //alfa<-155 || alfa>115 //also im Bereich 180 Grad
  {for(iz=0;iz<10;iz++)
   for(iy=10;--iy>=0;)
   for(ix=0;ix<WX;ix++)
     {n=getwelt3d(ix,iy,iz,it);
      if(n>0) wuerfel2(STEINFARBE(n),ix,iy,iz);
     }
   color(SCHWARZ);
   move(eck3); draw(eck4); draw(eck1); draw(eck5);
   move(eck3); draw(eck7); draw(eck8); draw(eck5);
   move(eck4); draw(eck8);
  }
 if(ansicht==1)
  {Vektor4 x10(10,0,0,0);
   move(eck1+x10); draw(eck2+x10); draw(eck3+x10); draw(eck4+x10);
   draw(eck1+x10);
  }
 flag3d=0;

 //Ansicht von Vorne zeichnen:
 drawinit(u2,'x','y');
 iz=gadget[1].getn();
 for(ix=0;ix<WX;ix++)
 for(iy=0;iy<10;iy++)
   {n=getwelt(ix,iy,iz,it);
    if(n>0)
     {color(STEINFARBE(n)); quadrat(iy,ix);}
   }
 color(SCHWARZ);
 move(eck5); draw(eck1); draw(eck2); draw(eck6);

 //Ansicht von Seite zeichnen:
 drawinit(u3,'x','z');
 iy=gadget[2].getn();
 for(ix=0;ix<WX;ix++)
 for(iz=0;iz<10;iz++)
   {n=getwelt(ix,iy,iz,it);
    if(n>0)
     {color(STEINFARBE(n)); quadrat(iz,ix);}
   }
 color(SCHWARZ);
 move(eck5); draw(eck1); draw(eck4); draw(eck8);

 //Ansicht von Oben zeichnen:
 drawinit(u4,'z','y');
 ix=gadget[3].getn();
 for(iy=0;iy<10;iy++)
 for(iz=0;iz<10;iz++)
   {n=getwelt(ix,iy,iz,it);
    if(n>0)
     {color(STEINFARBE(n)); quadrat(iy,iz);}
   }
 color(SCHWARZ);
 move(eck1); draw(eck2); draw(eck3); draw(eck4); draw(eck1);

 //Neuer Stein Ansicht von Oben zeichnen:
 drawinit(u5,'z','y');
 int imax;
 for(n=0,imax=WX-1;imax>=WX-2*HEPT;imax--)
  {for(iy=0;iy<10 && n==0;iy++)
   for(iz=0;iz<10 && n==0;iz++)
     n=getwelt(imax,iy,iz,it);
   if(n!=0) break;
  }
 for(ix=WX-2*HEPT;ix<=imax;ix++)
 for(iy=0;iy<10;iy++)
 for(iz=0;iz<10;iz++)
   {n=getwelt(ix,iy,iz,it);
    if(n>0)
     {if(ix==imax) color(STEINFARBE(n)); else color(STEINFARBE(n)+DUNKEL);
      quadrat(iy,iz);
     }
   }
 color(SCHWARZ);
 move(eck1); draw(eck2); draw(eck3); draw(eck4); draw(eck1);

 //Beschriftungen und Gadgets:
 for(int i=0;i<ngadgets;i++)
     gadget[i].zeichnen();
 char text[80],yt[8],zt[8];
 if(ansicht==0)
  {sprintf(text,"3D-Ansicht (%c-Achse unsichbar)",ausblend);
   schrift(1.5,ybo+17.3,"x");
   sprintf(yt,"%s",ausblend=='y'?"t":"y");
   sprintf(zt,"%s",ausblend=='z'?"t":"z");
  }
 else //ansicht==1
  {sprintf(text,"Stein in tyz-Raum projeziert");
   schrift(1.5,ybo+17.3,"t");
   schrift(6.8,ybo-0.5+12.5,"y");
   schrift(9.7,ybo+1.8+12.5,"z");
   schrift(2.5,ybo+7.5,"Ansicht des Fuellraums bei x=0");
   schrift(1.5,ybo+5.0,"t");
   strcpy(yt,"y"); strcpy(zt,"z");
  }
 schrift(25.5,ybo+12.5-1.0,"Sicht von Oben auf 3D-Ansicht des Steins");
 schrift(2.5,ybo+20.0,text);
 schrift(6.8,ybo-0.5,yt);
 schrift(9.7,ybo+1.8,zt);
 scores.zeichnen();//Punktestand
}

void Spielfeld::ausblenden(int c)
{
 if(c=='x' || (ansicht==1 && c=='t'))
   {ansicht=1-ansicht; c='t';}
 if(c==ausblend)
   ;//gibt nichts zu tun
 else if(c=='t' || c=='z' || c=='y')
   {ausblend=c;
    switch(c)
     {case 't':
	gadget[0].settext("Schnitt durch 4-dimensionalen Raum bei t=");
	gadget[1].settext("x-y-Ebene z=");
	gadget[2].settext("x-z-Ebene y=");
	gadget[3].settext("z-y-Ebene x="); break;
      case 'z':
	gadget[0].settext("Schnitt durch 4-dimensionalen Raum bei z=");
	gadget[1].settext("x-y-Ebene t=");
	gadget[2].settext("x-t-Ebene y=");
	gadget[3].settext("t-y-Ebene x="); break;
      case 'y':
	gadget[0].settext("Schnitt durch 4-dimensionalen Raum bei y=");
	gadget[1].settext("x-t-Ebene z=");
	gadget[2].settext("x-z-Ebene t=");
	gadget[3].settext("z-t-Ebene x="); break;
     }
    if(c!='t') ansicht=0;
   }
 else {fehler("falsche Variable in ausblenden() c=%c",c);}
}

void Spielfeld::startgame()
{
 steinentfernen();
 for(int x=0;x<WX;x++)
 for(int y=0;y<10;y++)
 for(int z=0;z<10;z++)
 for(int t=0;t<10;t++)
     welt[x][y][z][t]=0;
 steinsetzen(spx,spy,spz,spt);//Stein wieder einsetzen
 punkte=0; nreihen=nebenen=nvolums=0;
 gamestatus=AMSTARTEN;
}
void Spielfeld::stopgame()
{
 if(gamestatus==GESTARTET) scores.save(punkte);
 gamestatus=0;
}

int Spielfeld::raumcheck(int x)
{
 int n=0;
 for(int y=0;y<10;y++)
 for(int z=0;z<10;z++)
 for(int t=0;t<10;t++)
     if(welt[x][y][z][t]!=0) n++;
 return n;
}
int Spielfeld::zusatzpunkte()
{
 int x,y,z,t,n;
 int nrei=0,nebe=0,nvol=0;
 for(x=0;(n=raumcheck(x))>0;x++)
   {for(t=0;t<10;t++)
    for(z=0;z<10;z++)
     {for(y=0;y<10 && welt[x][y][z][t]!=0;y++) ;
      if(y==10) nrei++;
     }
    for(t=0;t<10;t++)
    for(y=0;y<10;y++)
     {for(z=0;z<10 && welt[x][y][z][t]!=0;z++) ;
      if(z==10) nrei++;
     }
    for(y=0;y<10;y++)
    for(z=0;z<10;z++)
     {for(t=0;t<10 && welt[x][y][z][t]!=0;t++) ;
      if(t==10) nrei++;
     }
    for(t=0;t<10;t++) //yz-Ebene pruefen
     {for(y=10,z=0;z<10 && y==10;z++)
       {for(y=0;y<10 && welt[x][y][z][t]!=0;y++) ;}
      if(z==10 && y==10) nebe++;
     }
    for(z=0;z<10;z++) //yt-Ebene pruefen
     {for(y=10,t=0;t<10 && y==10;t++)
       {for(y=0;y<10 && welt[x][y][z][t]!=0;y++) ;}
      if(t==10 && y==10) nebe++;
     }
    for(y=0;y<10;y++) //tz-Ebene pruefen
     {for(t=10,z=0;z<10 && t==10;z++)
       {for(t=0;t<10 && welt[x][y][z][t]!=0;t++) ;}
      if(z==10 && t==10) nebe++;
     }
    if(n==1000) nvol++;
   }
 int pu=(nrei-nreihen)*PUNKTEPROREIHE
       +(nebe-nebenen)*PUNKTEPROEBENE
       +(nvol-nvolums)*PUNKTEPROVOLUM;
 nreihen=nrei; nebenen=nebe; nvolums=nvol;
 return pu;
}

/********************weitere Globale Variablen ************************/
static Spielfeld spielfeld;

/************************* Men Behandlung ****************************/
static int exitflag=0;
void menu_exit() {spielfeld.stopgame(); exitflag=1;}
void m_about(),m_start(),m_save(),m_load(),m_scores(),m_tast();
void m_allstein(),m_stein4d(),m_punkte(),m_redraw();
void m_schrift();

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int col=0,maxcol;
 int breite,hoehe,tiefe,visklasse;
 char titel[80];
 UBYTE farbtabelle[NFARBEN][3]={0,0,0, 255,255,255, 180,180,180,//grau
	255,0,0, 0,240,0, 80,80,255,//rot,gruen,blau
	240,240,0, 255,0,255, 0,255,255,//gelb,violet,gruenblau
	255,128,128, 128,255,128, 63,191,255,//hellrot,hellgruen,himmelblau
	255,255,120, 255,159,63, 160,255,255,//hellgelb,gold,hellgruenblau
	190,160,90,//braun
	100,100,100, 140,140,140, 160,160,160,//grautoene
	//gleiche Farben nochmals aber dunkler:
	190,0,0, 0,190,0, 0,0,190,//rot,gruen,blau
	175,175,0, 190,0,190, 0,190,190,//gelb,violet,gruenblau
	190,108,108, 108,190,108, 43,171,190,//hellrot,hellgruen,hellblau
	190,190,80, 190,139,43, 108,190,190,//hellgelb,gold,hellgruenblau
	160,130,60//braun
 };
 //tek_setdebug(1);//test
 if(argc>1 && *argv[1]=='?')
	{printf("heptris  %s\n",VERSION);
	 exit(0);
	}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
// if(hoehe>HOEHE) hoehe=HOEHE; if(breite>BREITE) breite=BREITE;//test
 maxcol=(1<<TIEFE);
 setsize(breite,hoehe,tiefe);
 setmenu(3,"File",     "Hilfe",             "Einstellungen");
 setmenu(3,"About",    "alle Steine zeigen","Schriftgroesse ...",
	 m_about,m_allstein,m_schrift);
 setmenu(2,"Spielstand sichern ...","Testaturbelegung",m_save,m_tast);
 setmenu(2,"Spielstand laden ...","aktueller Stein zeigen",m_load,m_stein4d);
 setmenu(2,"New Game ...","Punkte",m_start,m_punkte);
 setmenu(2,"HiScores","redraw",m_scores,m_redraw);
 setmenu(1,"Exit",&menu_exit);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 // setzergbtabelle(NFARBEN,farbtabelle); //problem mit alter xtekplot1-Vers.
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 farbensetzen(NFARBEN,farbtabelle);//unproblematische Variante
 sprintf(titel,"Heptris  %s",VERSION);
 set_tektitel(titel);
 pause();
 screenclear(GRAU);
 spielfeld.zeichnen();
 term_refresh();
 int ft=0,shift=0;//ftaste,shifttaste
 while(exitflag==0 && waitmenu(0)==0)
   {waitBOF();//Bildaufbau abwarten
    int in,asci; ULONG rawcode;
    if(keyget(&in,&asci,&rawcode) != 0)
      {//Taste gedrueckt
       switch(in==0?rawcode:asci)
        {case 0xFF53: spielfeld.steinschieben2(0,1,0,0); break;
	 case 0xFF51: spielfeld.steinschieben2(0,-1,0,0); break;
	 case 0xFF52: if(shift) spielfeld.steinschieben2(0,0,0,1);
	              else      spielfeld.steinschieben2(0,0,1,0); break;
	 case 0xFF54: if(shift) spielfeld.steinschieben2(0,0,0,-1);
	              else      spielfeld.steinschieben2(0,0,-1,0); break;
	 case 0xFF98: case '6': spielfeld.steindrehen(ZY); break;
	 case 0xFF96: case '4': spielfeld.steindrehen(YZ); break;
	 case 0xFF97: case '8': spielfeld.steindrehen(XZ); break;
	 case 0xFF99: case '2': spielfeld.steindrehen(ZX); break;
	 case 0xFF9C: case '1': spielfeld.steindrehen(YX); break;
	 case 0xFF9B: case '3': spielfeld.steindrehen(XY); break;
	 case 0xFF95: case '7': spielfeld.steindrehen(YT); break;
	 case 0xFF9A: case '9': spielfeld.steindrehen(TY); break;
	 case 0xFF9D: case '5': spielfeld.steindrehen(TZ); break;
	 case 0xFF9E: case '0': spielfeld.steindrehen(ZT); break;
	 case 0xFF9F: case '.': spielfeld.steindrehen(TX); break;
	 case 0xFFAB: case '+': case ',': spielfeld.steindrehen(XT); break;
	 case 'A': case 'a': spielfeld.ansichtdrehen(-10); break;
	 case 'S': case 's': spielfeld.ansichtdrehen(10); break;
	 case 'D': case 'd': spielfeld.ansichtdrehen(0); break;
	 case 'Q': case 'q': spielfeld.ansichtdrehen(-90); break;
	 case 'W': case 'w': spielfeld.ansichtdrehen(90); break;
	 case 'T': case 't': spielfeld.ausblenden('t'); shift=0; break;
	 case 'Z': case 'z': spielfeld.ausblenden('z'); shift=0; break;
	 case 'Y': case 'y': spielfeld.ausblenden('y'); shift=0; break;
	 case 'X': case 'x': spielfeld.ausblenden('x'); shift=0; break;
	 case 0xFF0D: case 0x0D: spielfeld.steinfallenlassen(); shift=0; break;
	 case 0xFFBE: ft=1; break; //noch nicht benutzt
	 case 0xFFBF: ft=2; break;
	 case 0xFFC0: ft=3; break;
	 case 0xFFC1: ft=4; break;
	 case 0xFFE1: shift=1-shift; break;
	 case 0xFFE2: shift=1-shift; break;
	 default:
	        printf("rawcode=0x%04lX asci=%02X\n",(unsigned long)rawcode,asci);//test
		if(in) printf("   asci='%c'\n",asci);//test
	}
       redraw();
      }
   }
 inital_new();
 screenclear();
 term_exit();
 return 0;
}/* ende von main */

void warte_auf_taste()
{
 while(exitflag==0 && waitmenu(0)==0)
   {waitTOF();//Bildaufbau abwarten
    int in,asci; ULONG rawcode;
    if(keyget(&in,&asci,&rawcode) != 0)
       break;//Taste gedrueckt
   }
}

void m_allstein() //alle Steine zeigen
{
 vektor ur(1.2,5.0);
 int ix,iy,iz,it=0,n,altnr=spielfeld.getsteinnr();
 spielfeld.steinentfernen();
 inital_new();
 hy0=textsize(bx,hy);
 screenclear(GRAU);
 for(int k=1;k<=anzhept;k++)
    {spielfeld.neuerstein(k);
     spielfeld.drawinit(ur,'x','y','z');
     for(iz=10;--iz>=0;)
     for(iy=0;iy<10;iy++)
     for(ix=WX-HEPT;ix<WX;ix++)
      {n=spielfeld.welt[ix][iy][iz][it];
       if(n>0)
        {spielfeld.wuerfel(STEINFARBE(n),iy+KZX*iz,ix+KZY*iz);}
      }
     char str[40]; sprintf(str,"%d",k);
     schrift(ur.x,ur.y+13.4,str);
     spielfeld.steinentfernen();
     if((ur.x+=2.5)>30) {ur.x=1.0; ur.y-=4.0;}
    }
 textsize(bx1,hy1); hy0=0.0;
 schrift(1.0,2.0,"weiter mit <Return>-Taste");
 term_refresh();
 warte_auf_taste();
 spielfeld.neuerstein(altnr);
 redraw();
}
void system2(char*s,int p)
{
 char str[80];
 sprintf(str,s,p);
 system(str);
}
void m_stein4d() //aktueller Stein zeigen
{
 int ok,n=spielfeld.getsteinnr();
 ok=requester_input(1,"Zeige Stein Nr","%d","%d",&n);
 if(ok)
   {janeinrequester("4D-Perspektivische Stein-Darstellung noch nicht programmiert");
    //system2("steinansicht %d&",n);
   }
 pause();
 redraw();
}
void m_punkte()
{
 sprintf(scratch,"Punktezaehlung\n==============\n\
Pro gesetzten Stein gibt es 1 Punkt,\n\
jede vollstaendige Reihe gibt %d Zusatzpunkte,\n\
jede vollstaendige Ebene gibt %d Zusatzpunkte,\n\
das vollstaendig gefuellte Volumen gibt %d Zusatzpunkte.\n\n\
Eigentlich sollte ein vollstaendig gefuelltes Volumen\n\
analog der 2D-Variante abgeraeumt werden. Da dies aber\n\
so schwer zu erreichen ist habe ich das noch nicht eingebaut.",
PUNKTEPROREIHE,PUNKTEPROEBENE,PUNKTEPROVOLUM);
 janeinrequester(scratch);
}

void mausbewegung(int flag)
{
 static double x1,y1,x2,y2;
 double x,y,xm,ym,f1,f2;
 int tasten;
 bool update=false;
 tasten=mausposition(&x,&y);
 if((tasten&LIMAUS)!=0)
  {if(flag==1) //Linke Maustaste gedrueckt
      update=spielfeld.mausklick(x,y);
  }
 else if(flag==0) //Maus bewegt
     {//wenn Position auf einem Gadget dann dieses markieren
      update=spielfeld.mausmove(x,y);
     }
 if(update) redraw1();
}
void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
void mausmot() {mausbewegung(0);}

static char savename[160]="a.heptspielstand";
void m_save()
{
 int ok;
 FILE *fp;
 char str[200];
 ok=nachfilenamefragen("Spielstand sichern",savename,160);
 if(ok)
  {if((fp=fopen(savename,"r"))!=NULL)
      {//sprintf(str,"'%s' wirklich ueberschreiben ?",savename);
       //ok=janeinrequester(str);
       sprintf(str,"'%s' existiert schon, anderer Name verwenden",savename);
       janeinrequester(str); ok=0;//provi.
      }
   if(ok)
    {fp=fopen(savename,"w");
     if(fp) {spielfeld.save(fp); fclose(fp);}
     else fehler("kann %s nicht erstellen",savename);
    }
  }
 redraw();
}
void m_load()
{
 int ok=1;
 if(spielfeld.gamestatus==GESTARTET)
     ok=janeinrequester("Aktuelles Spiel beenden ?","ja","nein");
 if(ok)
  {spielfeld.stopgame();
   spielfeld.startgame();
   ok=nachfilenamefragen("Spielstand laden",savename,160);
   if(ok)
    {FILE *fp=fopen(savename,"r");
     if(fp) {spielfeld.load(fp); fclose(fp);}
     else fehler("kann %s nicht oeffnen",savename);
     spielfeld.zusatzpunkte();
    }
  }
 pause();
 redraw();
}
void m_start()
{
 int ok=1;
 char name[80]; strcpy(name,spielfeld.spielername);
 if(spielfeld.gamestatus==GESTARTET)
     ok=janeinrequester("Aktuelles Spiel beenden ?","ja","nein");
 if(ok)
   {spielfeld.stopgame();
    ok=requester_input(1,"SpielerName fuer neues Spiel","%s","%s",
		       spielfeld.spielername);
    if(ok) spielfeld.startgame();
   }
 redraw();
}
void m_scores()
{
 scores.show();
 redraw();
}
void m_redraw()
{
 pause();
 redraw();
}
void redraw()
{
 inital_new();
 //screenclear(GRAU);
 color(GRAU); fillbox(xmin,ymin,xmax,ymax); //weniger flimmer bei Linux
 spielfeld.zeichnen();
 term_refresh();
}
void redraw1() //nur Bereich mit neuem Stein neu zeichnen
{
 inital_new();
 color(GRAU); fillbox(xmin,ymin,xmax,ymax); spielfeld.zeichnen();//provi.
 term_refresh();
}

void m_schrift()
{
 int ok;
 char s1[80],s2[80],s3[80];
 sprintf(s1,"%.3lf  %.3lf",bx,hy);
 sprintf(s2,"%.3lf  %.3lf",bx1,hy1);
 sprintf(s3,"%.3lf  %.3lf",bx2,hy2);
 ok=requester_input(3,"kleine Schrift, Breite Hoehe","%s","%s\n",s1,
		    "mittlere Schrift, Breite Hoehe","%s","%s\n",s2,
		    "grosse Schrift, Breite Hoehe","%s","%s\n",s3);
 if(ok)
   {sscanf(s1,"%lf %lf",&bx,&hy);
    sscanf(s2,"%lf %lf",&bx1,&hy1);
    sscanf(s3,"%lf %lf",&bx2,&hy2);
    hy0=0.0;
   }
 redraw();
}

/*********************** Scores Punktezhlung *************************/
int pruefsumme(char*nam,int n)
{
 int i,k,sum=0;
 char *s,c;
 for(k=i=0,s=nam;i<8 && *s!=0;i++)
    {if(i&1) {c=(n>>k)&0xFF; if(k<24) k+=8;}
     else {if(*s==0) s=nam;  c= *s++;}
     sum=(sum<<1)+c;
    }
 return sum;
}
Scores::Scores()
{
 int i,sum[10];
 FILE *fp=fopen(hisname,"r");
 if(fp==NULL)
   {strcpy(topname[0],"Anton"); topten[0]=500000;
    strcpy(topname[1],"Berta"); topten[1]=100000;
    strcpy(topname[2],"Chris"); topten[2]=50000;
    strcpy(topname[3],"Doris"); topten[3]=10000;
    strcpy(topname[4],"Eugen"); topten[4]=5000;
    strcpy(topname[5],"Flora"); topten[5]=1000;
    strcpy(topname[6],"Georg"); topten[6]=500;
    strcpy(topname[7],"Hegar"); topten[7]=100;
    strcpy(topname[8],"Iris"); topten[8]=50;
    strcpy(topname[9],"Josef"); topten[9]=10;
   }
 else
   {for(i=0;i<10;i++)
       fscanf(fp,"%s %d %d",topname[i],&topten[i],&sum[i]);
    for(i=10;--i>=0;)
        if(sum[i]!=pruefsumme(topname[i],topten[i]))
	  {strcpy(topname[i],"Niemand"); topten[i]=(i==9)?0:topten[i+1];}
    fclose(fp);
   }
}
void Scores::zeichnen()
{
 char s1[80];
 int hi=(spielfeld.punkte>topten[0])?spielfeld.punkte:topten[0];
 textsize(bx2,hy2); hy0=0.0;
 if(spielfeld.gamestatus>=AMSTARTEN)
      sprintf(s1,"Score: %d   Hiscore: %d",spielfeld.punkte,hi);
 else sprintf(s1,"            Hiscore: %d",hi);
 schrift(14.0,ybo+20.0,s1);
}
void Scores::save(int punkte)
{
 int i,x,sum,ok;
 for(i=0;i<10;i++)
    {if(topten[i]<punkte)
      {sprintf(scratch,"%d. Rang mit %d Punkten",i+1,punkte);
       ok=requester_input(2,"Bravo, Ruhmeshalle erreicht","%s","%s\n",scratch,
			    "      Spieler-Name         ","%s","%s",
			 spielfeld.spielername);
       if(ok)
	 {for(int j=10;--j>i;)
	     {topten[j]=topten[j-1];
	      strcpy(topname[j],topname[j-1]);
	     }
	  strcpy(topname[i],spielfeld.spielername); topten[i]=punkte;
	 }
       break;
      }
    }
 if(i<10)
  {FILE *fp=fopen(hisname,"w");
   if(fp!=NULL)
    {for(i=0;i<10;i++)
       {sum=pruefsumme(topname[i],topten[i]);
	fprintf(fp,"%s %d %d\n",topname[i],topten[i],sum);
       }
     fclose(fp);
    }
   else printf("kann hiscores-datei nicht anlegen\n");
  }
}
void Scores::show()
{
 double x=10.0,y=24.0,dy=1.5;
 char str[120],str2[60],abst[60],*s;
 inital_new();
 screenclear(GRAU);
 textsize(bx2,hy2); hy0=0.0;
 schrift(x,y,"Top Ten Scores"); y-=1.5*dy;
 textsize(bx1,hy1);
 for(int i=0;i<10;i++)
   {int j,n=strlen(topname[i]);
    for(s=abst,j=0;j<60-2.2*n;j++) *s++ = '.';
    *s=0;
    sprintf(str,"%2d.  %s  ..%s..",i+1,topname[i],abst);
    sprintf(str2,"%d",topten[i]);
    schrift(x,y,str);
    schrift(x+30*bx1,y,str2); y-=dy;
   }
 schrift(x,y-dy,"weiter mit <Return>-Taste");
 term_refresh();
 warte_auf_taste();
}
/************************* Fehlerbehandlung ***************************/
void fehler(char*s,int p1,int p2,int p3)
  {printf("FEHLER: "); printf(s,p1,p2,p3);}
void fehler(char*s,char*p1,char*p2,char*p3)
  {printf("FEHLER: "); printf(s,p1,p2,p3);}

/**************************** Hilfetexte ******************************/
void m_about()
{
 char str[600];
 sprintf(str,"Heptris %s\n\n\
Dies ist ein 4-Dimensionales Tetris.  Ziel des Spiels ist es einen Raum\n\
lueckenlos auszufuellen (Analog einer Linie beim 2D- oder einer Flaeche\n\
bei der 3D-Version).\n\
Die 3D-Darstellung ist ein Schnitt durch den 4D-Raum.\n\
Die 2D-Darstellungen sind Schnitte durch die 3D-Darstellung\n\
\nDezember 2002 / Rolf Pfister",VERSION);
 janeinrequester(str);
}
void m_tast()
{
 janeinrequester("Tastaturbelegung:\n\
----------------\n\
 4 6  um xt-Ebene drehen (entspricht x-Drehachse im 3D-Raum)\n\
 2 8  um yt-Ebene drehen\n\
 1 3  um zt-Ebene drehen\n\
 7 9  um xz-Ebene drehen (180 Grad entspricht Spiegelung im 3D-Raum)\n\
 0 5  um xy-Ebene drehen\n\
 . +  um yz-Ebene drehen\n\
 <Return> oder <Enter>  Stein fallen lassen\n\
 a s  3D-Ansicht drehen (10-Grad-Schritte)\n\
 q w  3D-Ansicht drehen (90-Grad-Schritte)\n\
 d    3D-Ansicht zurueckdrehen auf Ausgangsposition\n\
\n\
 In 3D-Darstellung bleibt immer 1 Achse unsichtbar:\n\
 t    t-Achse unsichtbar (Voreinstellung)\n\
 z    z-Achse unsichtbar (z und t in den Darstellungen vertauscht)\n\
 y    y-Achse unsichtbar (y und t vertauscht)\n\
 x    Auszufuellender Raum vollstaendig darstellen, x-Achse unsichtbar,\n\
      Dabei wird aktueller Stein als Projektion in den tyz-Raum dargestellt.\n\
\n\
 -->  Stein nach rechts schieben\n\
 <--  Stein nach links schieben\n\
 /\\   (Pfeil rauf) Stein nach hinten schieben\n\
 \\/   (Pfeil runter) Stein nach vorn schieben\n\
 SHIFT (Umschalt-Taste) Stein mit /\\ oder \\/ in t-Richtung verschieben,\n\
       in x-Ansicht also nach oben und unten statt nach hinten und vorn\n\
");
}
