/* matrixklasse.cc

 Rechnen mit Matrizen
Anwendung:
  matrixklasse.h einfgen in C++ Programmen
  matrixklasse.o dazulinken (siehe makefile)
*/

#include "matrixklasse.h"

// Konstruktoren, Destruktor
Matrix::Matrix()
{
 n=m=0; feld=NULL;
}
Matrix::Matrix(int i,int j) //i=Hoehe j=Breite
{
 m=i; n=j;
 feld=new double[n*m];
//test:
 for(int i=0;i<m;i++)
 for(int j=0;j<n;j++)
      e(i,j)=(i+1)*10+(j+1);//test
}
Matrix::~Matrix()
{
 //if(feld!=NULL) delete feld;  !!nicht machen, ergibt sonst Fehler!!
}

// interne Kleinigkeiten
void Matrix::resize(int i,int j)
{
 if(feld!=NULL) delete feld;
 m=i; n=j;
 feld=new double[n*m];
}

// Wichtige Funktionen
Matrix Matrix::operator=(Matrix a)
{
 if(m!=a.m || n!=a.n) resize(a.m,a.n);
 for(int i=0;i<m;i++)
 for(int j=0;j<n;j++)
	 e(i,j) = a.e(i,j);
 return *this;
}
void Matrix::set(double *f)
{
 int i,imax=n*m;
 double *z;
 for(z=feld,i=0;i<imax;i++)  *z++ = *f++;
}
double Matrix::det()
{
 double a=0;
 if(n!=m) return 0;//Fehler
 if(n==1) return e(0,0);
 if(n==2) return e(0,0)*e(1,1)-e(1,0)*e(0,1);
// da gibts noch was zu tun
// for(int v=1,i=0;i<n;i++,v= -v)
//     a += v*e(i,0)*restmatrix(i).det();
 return a;
}

// friends
Matrix operator+(Matrix a,Matrix b)
{
 int i,j,imax=(a.m<b.m)?a.m:b.m, jmax=(a.n<b.n)?a.n:b.n;
 Matrix c(imax,jmax);
 for(i=0;i<imax;i++)
     for(j=0;j<jmax;j++)
	 c.e(i,j) = a.e(i,j) + b.e(i,j);
 return c;
}
Matrix operator-(Matrix a,Matrix b)
{
 int i,j,imax=(a.m<b.m)?a.m:b.m, jmax=(a.n<b.n)?a.n:b.n;
 Matrix c(imax,jmax);
 for(i=0;i<imax;i++)
     for(j=0;j<jmax;j++)
	 c.e(i,j) = a.e(i,j) - b.e(i,j);
 return c;
}
Matrix operator*(Matrix a,Matrix b)
{
 if(a.n!=b.m) {Matrix c(1,1); c.elem(1,1)=0; return c;}//provi. Fehler-Abfang;
 int i,j,r,imax=a.m, jmax=b.n, rmax=a.n;
 Matrix c(imax,jmax);
 for(i=0;i<imax;i++)
 for(j=0;j<jmax;j++)
    {double h=0;
     for(r=0;r<rmax;r++)  h += a.e(i,r)*b.e(r,j);
     c.e(i,j)=h;
    }
 return c;
}
Matrix trans(Matrix a)
{
 int i,j,imax=a.n, jmax=a.m;
 Matrix c(imax,jmax);
 for(i=0;i<imax;i++)
 for(j=0;j<jmax;j++)
     c.e(i,j)=a.e(j,i);
 return c;
}
