//steinansicht.cc
#define VERSION "Version 0.1"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif
#if GCC_VERSION>=3000
#include <iostream>
using namespace std;
#else
#include <stream.h>
#endif
#ifdef AMIGA
#include <amitekplot1.h>
#else
#include <xtekplot1.h>
#endif
#include "vectorklasse.h"

const int XMAX=640,YMAX=512,TIEFE=5;
const int NFARBEN=32;//Anzahl definierte Farben
const int ROT=3,GRUEN=4,BLAU=5,GELB=6,VIOLET=7,
          GRUENBLAU=8,HELLROT=9,HELLGRUEN=10;
static int breite,hoehe,tiefe,visklasse; //Globale Variablen
static double xmin= -2.2, ymin= -2.0, xmax=2.2, ymax=2.0;
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_methode();

/*************************** Kleinkram ********************************/
//void pause(int n=10) {for(int i=0;i<n;i++) waitTOF();}

void farbensetzen(int n,UBYTE farbtabelle[][3])
{
 for(int i=0;i<n;i++)
     setcolor(i,farbtabelle[i][0],farbtabelle[i][1],farbtabelle[i][2]);
}

/****************** 3D-Kamera und Projektion auf Flche *****************/
class Kante
{
 int ka,kb,kc,kd; //Kante von a nach b mit Linker Flaeche c und Rechter d
public:
 int iv; //Index des zugehrigen Volumens
 void set(int a,int b,int c,int d) {ka=a; kb=b; kc=c; kd=d;}
 int a() {return ka;}
 int b() {return kb;}
 int c() {return kc;}
 int d() {return kd;}
};

class Flaeche
{
 int k[6]; //Indexe auf maximal 6 Ecken
public:
 int nk,farbe;
 int iv; //Index des zugehrigen Volumens
 void set(int fa,int a,int b,int c)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; nk=3;}
 void set(int fa,int a,int b,int c,int d)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; nk=4;}
 void set(int fa,int a,int b,int c,int d,int e)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; k[4]=e; nk=5;}
 void set(int fa,int a,int b,int c,int d,int e,int f)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; k[4]=e; k[5]=f; nk=6;}
 int operator[](int i) {return k[i];}
};

class Figur
{
protected:
 int maxn,neck,nkant,nf;
 Vector *eck;
 Kante *kant;
 Flaeche *flaech;
public:
 Figur() {maxn=0; neck=nkant=nf=0; eck=NULL; kant=NULL; flaech=NULL;}
 Figur(int n);
//~Figur() {delete eck; delete kant; delete flaech;} //funktioniert nicht!
 ~Figur() {}
 int getn() {return neck;}
 int getnf() {return nf;}
 int ecke(double x,double y,double z) {eck[neck]=Vector(x,y,z); return neck++;}
 int kante(int a,int b,int c,int d) {kant[nkant].set(a,b,c,d); return nkant++;}
 int kante(Kante& k) {kant[nkant]=k; return nkant++;}
 int flaeche(int fa,int a,int b,int c) {flaech[nf].set(fa,a,b,c); return nf++;}
 int flaeche(int fa,int a,int b,int c,int d) {flaech[nf].set(fa,a,b,c,d); return nf++;}
 int flaeche(int fa,int a,int b,int c,int d,int e) {flaech[nf].set(fa,a,b,c,d,e); return nf++;}
 int flaeche(int fa,int a,int b,int c,int d,int e,int f) {flaech[nf].set(fa,a,b,c,d,e,f); return nf++;}
 int flaeche(Flaeche& f) {flaech[nf]=f; return nf++;}
 void zeichnen(int farbe,int met);
 Figur& operator=(Figur&);
 Vector& operator[](int i) {return eck[i];}
 void clear(int);
 Flaeche& getflaeche(int i) {return flaech[i];}
};

void Figur::clear(int n)
{
 if(n!=maxn)
  {if(eck) delete eck;
   if(kant) delete kant;
   if(flaech) delete flaech;
   int n2=n*n/2, n3=n2*2/3;
   eck=new Vector[maxn=n];
   kant=new Kante[n2];
   flaech=new Flaeche[n3];
  }
 neck=nkant=nf=0;
}
Figur::Figur(int n)
{
 int n2=n*n/2, n3=n2*2/3;
 eck=new Vector[maxn=n];
 kant=new Kante[n2];
 flaech=new Flaeche[n3];
 neck=0; nkant=0; nf=0;
}
Figur& Figur::operator=(Figur& f)
{
 int i,n2=f.maxn*f.maxn/2, n3=n2*2/3;
 if(maxn!=f.maxn)
    {delete eck; eck=new Vector[maxn=f.maxn];
     delete kant; kant=new Kante[n2];
     delete flaech; flaech=new Flaeche[n3];
    }
 neck=f.neck; nkant=f.nkant; nf=f.nf;
 for(i=0;i<neck;i++)
     eck[i]=f.eck[i];
 for(i=0;i<n2;i++)
     kant[i]=f.kant[i];
 for(i=0;i<n3;i++)
     flaech[i]=f.flaech[i];
 return *this;
}
void linie(Vector a,Vector b)
{
 plot(a[0],a[1],PENUP); plot(b[0],b[1],PENDOWN);
}
void Figur::zeichnen(int farbe,int met)
{
 Vector p1,p2,p3,p4,p[6];
 double wi;
 color(farbe);
 if(met==1) //alle Kanten zeichnen
    {for(int i=0;i<nkant;i++)
	 linie(eck[kant[i].a()],eck[kant[i].b()]);
    }
 else if(met>=2) //verdeckte Kanten nicht zeichnen
  {if(met==3)
    {for(int i=0;i<nf;i++) //Flaechen zeichnen
      {p[0]=p1=eck[flaech[i][0]];
       p[1]=p2=eck[flaech[i][1]];
       p[2]=p3=eck[flaech[i][2]]; p3-=p1;
       wi=atan2(p2[1]-p1[1],p2[0]-p1[0]);
       p3.drehen(wi,1,0);
       if(p3[1]>0)
        {int j,jmax=flaech[i].nk;
         double xf[6],yf[6];
	 if(farbe!=0) color(flaech[i].farbe);
	 for(j=3;j<jmax;j++) p[j]=eck[flaech[i][j]];
	 for(j=0;j<jmax;j++) {xf[j]=p[j][0]; yf[j]=p[j][1];}
	 fillpolygon(jmax,xf,yf);
	}
      }
     if(farbe!=0) color(farbe);
    }
   for(int i=0;i<nkant;i++) //Kanten zeichnen, ohne verdeckte
    {p1=eck[kant[i].a()];
     p2=eck[kant[i].b()];
     p3=eck[kant[i].c()]; p3-=p1;
     p4=eck[kant[i].d()]; p4-=p1;
     wi=atan2(p2[1]-p1[1],p2[0]-p1[0]);
     p3.drehen(wi,1,0);
     p4.drehen(wi,1,0);
     if(p3[1]>=0 || p4[1]<=0)
	 linie(p1,p2);
    }
  }
}

class Figureintrag
{
public:
 Figureintrag *next;
 Figur fig;
 double xpos;
 Figureintrag() {next=NULL;}
 ~Figureintrag() {}
};
class Figurliste
{
public:
 Figureintrag *next;
 Figurliste() {next=NULL;}
 //~Figurliste() {if(next) clear();}
 ~Figurliste() {}
 void put(Figur&,double);
 void clear();
 void operator=(Figurliste&);
 void zeichnen(int,int);
};
void Figurliste::put(Figur& f,double x1)
{ //nach steigendem x1 einsortieren
 Figureintrag *p,*p2;
 p2=new Figureintrag[1];
 p2->fig=f; p2->xpos=x1;
 if(next==NULL) next=p2; //erster Eintrag
 else if(next->xpos>x1) //x1 kleiner als erster Eintrag ?
  {p2->next=next; next=p2;} //ja: als erster eintragen
 else
  {for(p=next;p->next!=NULL && p->next->xpos<=x1;p=p->next) ;
   p2->next=p->next; //zwischen p und p->next eintragen
   p->next=p2;
  }
}
void Figurliste::clear()
{
 Figureintrag *p,*p2;
 for(p=next;p!=NULL;p=p2)
   {p2=p->next;
    //delete p;
   }
 next=NULL;
}
void Figurliste::operator=(Figurliste& f)
{
 clear();
 Figureintrag *p;
 for(p=f.next;p!=NULL;p=p->next)
     put(p->fig,p->xpos);
}
void Figurliste::zeichnen(int f,int m)
{
 Figureintrag *p;
 for(p=next;p!=NULL;p=p->next)
     p->fig.zeichnen(f,m);
}

class Kamera
{
 Vector ka;//Position der Kamera
 Vector beob;//Beobachtungspunkt
 double ab;//Abstand Brennpunkt-Bildebene
 double alfa,beta,gamma;//Winkel in rad, aus obigen Variablen zu berechnen
 double sina,cosa,sinb,cosb,sing,cosg,absk;
 Figurliste bild1,bild2;//zuletzt gezeichnetes, und neues Bild
 int gezeichnet,met;
 void rechnen();
 Vector projektion(Vector);
public:
 Kamera() {ka=Vector(0,-20,0); beob=Vector(0,0,0); gamma=0;
	   ab=10; gezeichnet=0; met=1; rechnen();}
 void rotieren();
 void foto(Figurliste&);
 void zeichnen();
 int getmethode() {return met;}
 void setmethode(int m) {if(m>0 && m<=3) met=m;}
};
static Kamera kamera;

void Kamera::rechnen()
{
 Vector k;
 k=ka-beob; absk=abs(k);
 alfa=atan2(k[1],k[0])+PIHALBE;
 beta=atan2(sqrt(k[0]*k[0]+k[1]*k[1]),k[2]);
 sina=sin(alfa); cosa=cos(alfa);
 sinb=sin(beta); cosb=cos(beta);
 sing=sin(gamma); cosg=cos(gamma);
}
void Kamera::rotieren()
{
 static int betri=1;
 double alf;
 ka.drehen(alf=alfa,1,0);
 alf += 1.0*GRAD;
 if(betri==1 && beta<=GRAD) {betri=0;}
 else if(betri==0 && beta>=179*GRAD) {betri=1;}
 if(betri==1) ka.drehen(0.1*GRAD,2,1);
 else ka.drehen(0.1*GRAD,1,2);
 ka.drehen(alf,0,1);
 rechnen();
}
void Kamera::foto(Figurliste& w)
{
 Figureintrag *p;
 int i,k,n,nf;
 double x,x1;
 Figurliste bild;
 Flaeche fla;
 bild=w;
 for(p=bild.next;p!=NULL;p=p->next)
  {n=p->fig.getn();
   for(i=0;i<n;i++)
	p->fig[i]=projektion(p->fig[i]-beob);
   nf=p->fig.getnf();
   for(x1= -1e9,i=0;i<nf;i++)
       {fla=p->fig.getflaeche(i);
        for(k=0;k<fla.nk;k++)
	     {x=p->fig[fla[k]][2]; if(x>x1) x1=x;}
       }
   p->xpos=x1;
  }
 if(gezeichnet==1) bild2=bild;
 else  bild1=bild;
 bild.clear();
}
Vector Kamera::projektion(Vector p)
{
 p.drehen(sina,cosa,1,0);
 p.drehen(sinb,cosb,2,1);
 p.drehen(sing,cosg,0,1);
 return p/(absk-p[2])*ab;
}
void Kamera::zeichnen()
{
 if(gezeichnet==1)
	{bild1.zeichnen(0,met); bild2.zeichnen(1,met); gezeichnet=2;}
 else if(gezeichnet==2)
	{bild2.zeichnen(0,met); bild1.zeichnen(1,met); gezeichnet=1;}
 else {bild1.zeichnen(1,met); gezeichnet=1;}
}

/***************** 4D-Kamera und Projektion auf Volumen *****************/
class Volumen
{
 int k[8]; //Indexe auf maximal 8 Ecken
public:
 int nk,farbe;
 void set(int fa,int a,int b,int c,int d)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; nk=4;}
 void set(int fa,int a,int b,int c,int d,int e,int f= -1,int g= -1,int h= -1);
 int operator[](int i) {return k[i];}
};
void Volumen::set(int fa,int a,int b,int c,int d,int e,int f,int g,int h)
{
 farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; k[4]=e; nk=5;
 if(f>=0)
  {k[nk++]=f;
   if(g>=0)
    {k[nk++]=f;
     if(h>=0) k[nk++]=f;
  } }
}

class Hyperfigur
{
protected:
 int maxn,neck,nkant,nf,nv,iv;
 Vector *eck;
 Kante *kant;
 Flaeche *flaech;
 Volumen *vol;
public:
 Hyperfigur() {maxn=0; eck=NULL; kant=NULL; flaech=NULL; vol=NULL; iv=0;}
 Hyperfigur(int n);
 ~Hyperfigur() {} //eck... freigeben geht nicht!
 int getn() {return neck;}
 int getnk() {return nkant;}
 int getnf() {return nf;}
 int getnv() {return nv;}
 int ecke(double x,double y,double z,double t) {eck[neck]=Vector(x,y,z,t); return neck++;}
 int kante(int a,int b,int c,int d)
	{kant[nkant].set(a,b,c,d); kant[nkant].iv=iv; return nkant++;}
 int flaeche(int fa,int a,int b,int c)
	{flaech[nf].set(fa,a,b,c); flaech[nf].iv=iv; return nf++;}
 int flaeche(int fa,int a,int b,int c,int d,int e= -1,int f= -1);
 int volumen(int F,int a,int b,int c,int d)
	{vol[nv].set(F,a,b,c,d); return nv++;}
 int volumen(int F,int a,int b,int c,int d,int e,int f= -1,int g= -1,int h= -1)
	{vol[nv].set(F,a,b,c,d,e,f,g,h); return nv++;}
 void zeichnen(int farbe,int met);
 // Hyperfigur& operator=(Hyperfigur&);
 Vector& operator[](int i) {if(i>=neck) neck=i+1;  return eck[i];}
 Kante& getkante(int i) {return kant[i];}
 Flaeche& getflaeche(int i) {return flaech[i];}
 bool sichtbarvol(int);
};
Vector strip(Vector e)
{
 Vector p(3);
 for(int i=0;i<3;i++) p[i]=e[i+1];
 return p;
}
bool Hyperfigur::sichtbarvol(int j)
{
 Vector p[4];
 int i;
 double alfa,sa,ca;
 for(i=0;i<4;i++) p[i]=strip(eck[vol[j][i]]);
 for(i=1;i<4;i++) p[i] -= p[0]; //Koordinatensystem durch p0
 alfa=atan2(p[1][1],p[1][0]);
 sa=sin(alfa); ca=cos(alfa);
 for(i=1;i<4;i++) p[i].drehen(sa,ca,1,0);
 alfa=atan2(p[1][2],p[1][0]);
 sa=sin(alfa); ca=cos(alfa);
 for(i=2;i<4;i++) p[i].drehen(sa,ca,2,0); //p1 auf x-Achse drehen
 alfa=atan2(p[2][2],p[2][1]);
 sa=sin(alfa); ca=cos(alfa);
 p[3].drehen(sa,ca,2,1); //p2 auf xy-Ebene drehen
 return (p[3][2]>0);
}
Hyperfigur::Hyperfigur(int n)
{
 int n2=n*n/2, n3=n2*2/3, n4=n3*2/4;
 eck=new Vector[maxn=n];
 kant=new Kante[n2];
 flaech=new Flaeche[n3];
 vol=new Volumen[n4];
 neck=0; nkant=0; nf=0; iv=0;
}
int Hyperfigur::flaeche(int fa,int a,int b,int c,int d,int e,int f)
{
 if(e<0) flaech[nf].set(fa,a,b,c,d);
 else if(f<0) flaech[nf].set(fa,a,b,c,d,e);
 else flaech[nf].set(fa,a,b,c,d,e,f);
 flaech[nf].iv=iv;
 return nf++;
}

class Hyperwuerfel:public Hyperfigur
{
 void wuerfel(int f,int a0,int a1,int a2,int a3,int a4,int a5,int a6,int a7);
public:
 Hyperwuerfel();
};
void Hyperwuerfel::wuerfel(int f,int a0,int a1,int a2,int a3,
				 int a4,int a5,int a6,int a7)
{
 iv=volumen(f,a2,a0,a5,a1,a3,a6,a4,a7);
 kante(a0,a1,a2,a5); kante(a1,a2,a3,a6); kante(a2,a3,a0,a7);kante(a3,a0,a1,a4);
 kante(a5,a4,a7,a0); kante(a6,a5,a4,a1); kante(a7,a6,a5,a2);kante(a4,a7,a6,a3);
 kante(a0,a4,a5,a7); kante(a1,a5,a6,a4); kante(a2,a6,a7,a5);kante(a3,a7,a4,a6);
 flaeche(f,a0,a1,a2,a3); flaeche(f,a7,a6,a5,a4); flaeche(f,a1,a5,a6,a2);
 flaeche(f,a3,a7,a4,a0); flaeche(f,a1,a0,a4,a5); flaeche(f,a3,a2,a6,a7);
}
/* 'oberer' (t=1) Wrfel:             'unterer' (t=-1) Wrfel:
     1 _______________ 0                9 _______________ 8
      /:             /|                  /:             /|
     / :            / |                 / :            / |
    /  :           /  |                /  :           /  |
 2 +--------------+ 3 |             10+--------------+11 |
   |   :          |   |               |   :          |   |
   |   :__________|___|               |   :__________|___|
   |  /5          |  / 4              |  /13         |  / 12
   | /            | /                 | /            | /
   |/             |/                  |/             |/
 6 +--------------+ 7               14+--------------+ 15
*/
Hyperwuerfel::Hyperwuerfel():Hyperfigur(16)
{
 ecke(1,1,1,1);  ecke(-1,1,1,1);  ecke(-1,-1,1,1); ecke(1,-1,1,1);
 ecke(1,1,-1,1); ecke(-1,1,-1,1); ecke(-1,-1,-1,1); ecke(1,-1,-1,1);
 ecke(1,1,1,-1);  ecke(-1,1,1,-1);  ecke(-1,-1,1,-1); ecke(1,-1,1,-1);
 ecke(1,1,-1,-1); ecke(-1,1,-1,-1); ecke(-1,-1,-1,-1); ecke(1,-1,-1,-1);
//oberes Volumen (bei t=1):
 wuerfel(ROT,4,5,6,7, 0,1,2,3);
//unteres Volumen (bei t=-1):
 wuerfel(GRUEN,12,13,14,15, 8,9,10,11);
//6 Zwischenvolumen:
 wuerfel(BLAU, 0,1,2,3, 8,9,10,11);
 wuerfel(GELB, 4,5,6,7, 12,13,14,15);
 wuerfel(VIOLET, 0,4,5,1, 8,12,13,9);
 wuerfel(GRUENBLAU, 1,5,6,2, 9,13,14,10);
 wuerfel(HELLROT, 2,6,7,3, 10,14,15,11);
 wuerfel(HELLGRUEN, 3,7,4,0, 11,15,12,8);
}
static Hyperwuerfel hyperwuerfel;

class Hyperkamera
{
 Vector ka;//Position der Hyperkamera
 Vector beob;//Beobachtungspunkt
 double ab;//Abstand Brennpunkt-Bildvolumen
 double alfa,beta,gamma;//Winkel in rad, aus obigen Variablen zu berechnen
//alfa ist der auf yz-Ebene projezierte Winkel (Bereich -180...+180 Grad)
//beta  = 90Grad - t-Hhe der Kamera ber der yz-Ebene (Bereich 0...180 Grad)
//gamma = 90Grad - x-Hhe der Kamera ber dem yzt-Volumen (Bereich 0...180)
 double sina,cosa,sinb,cosb,sing,cosg,absk;
 int met2;
 Hyperfigur bild1;
 void rechnen();
 Vector projektion(Vector);
public:
 Figurliste figlist;
 Hyperkamera()
   {ka=Vector(20,20,20,20); beob=Vector(0,0,0,0);
    ab=40; //Willkrliche Einheiten, xmin..ymax in gleichen Einheiten
    met2=2;
    rechnen();
   }
 void foto(Hyperfigur&);
 int getmethode() {return met2;}
 void setmethode(int m) {if(m>0 && m<=3) met2=m;}
};
static Hyperkamera hyperkamera;

void Hyperkamera::rechnen()
{
 Vector k;
 k=ka-beob; absk=abs(k);
 double q2=k[1]*k[1]+k[2]*k[2];
 alfa=atan2(k[2],k[1]);
 beta=atan2(sqrt(q2),k[3]);
 gamma=atan2(sqrt(q2+k[3]*k[3]),k[0]);
 sina=sin(alfa); cosa=cos(alfa);
 sinb=sin(beta); cosb=cos(beta);
 sing=sin(gamma); cosg=cos(gamma);
}
void Hyperkamera::foto(Hyperfigur& w)
{
 bild1=w;
 int i,j,k,ne=bild1.getn(),nv=bild1.getnv();
 double x,x1;
 Figur fig;
 Kante kan;
 Flaeche fla;
 Vector p(4);
 for(i=0;i<ne;i++)
   bild1[i]=projektion(bild1[i]-beob);
 figlist.clear();
 for(x1= -1e9,j=0;j<nv;j++)
  if(met2<2 || bild1.sichtbarvol(j))
  {fig.clear(ne);
   for(i=0;i<ne;i++)
     {p=bild1[i]; fig.ecke(p[1],p[2],p[3]);}
   for(i=0;i<bild1.getnk();i++)
     {kan=bild1.getkante(i); if(kan.iv==j) fig.kante(kan);}
   for(i=0;i<bild1.getnf();i++)
     {fla=bild1.getflaeche(i);
      if(fla.iv==j)
	  {fig.flaeche(fla);
	   for(k=0;k<fla.nk;k++)
	     {x=bild1[fla[k]][0]; if(x>x1) x1=x;}
	  }
     }
   figlist.put(fig,x1);
  }
}
Vector Hyperkamera::projektion(Vector p)
{
 p.drehen(sina,cosa,2,1);
 p.drehen(sinb,cosb,3,1);
 p.drehen(sing,cosg,1,0);
 return p/(absk-p[0])*ab;
}

/**************************** Hauptprogramm *****************************/
void grafik_ersteszeichnen()
{
 hyperkamera.foto(hyperwuerfel);
 kamera.foto(hyperkamera.figlist);
 kamera.zeichnen();
}
void grafik_rotieren()
{
 kamera.rotieren();
 kamera.foto(hyperkamera.figlist);
 kamera.zeichnen();
}

main(int argc,char *argv[])
{
 UBYTE farbtabelle[NFARBEN][3]={0,0,0, 255,255,255, 180,180,180,//grau
	255,0,0, 0,240,0, 80,80,255,//rot,gruen,blau
	240,240,0, 255,0,255, 0,255,255,//gelb,violet,gruenblau
	255,128,128, 128,255,128, 63,191,255,//hellrot,hellgruen,himmelblau
	255,255,120, 255,159,63, 160,255,255,//hellgelb,gold,hellgruenblau
	190,160,90,//braun
	100,100,100, 140,140,140, 160,160,160,//grautoene
	//gleiche Farben nochmals aber dunkler:
	190,0,0, 0,190,0, 0,0,190,//rot,gruen,blau
	175,175,0, 190,0,190, 0,190,190,//gelb,violet,gruenblau
	190,108,108, 108,190,108, 43,171,190,//hellrot,hellgruen,hellblau
	190,190,80, 190,139,43, 108,190,190,//hellgelb,gold,hellgruenblau
	160,130,60//braun
 };
 //tek_setdebug(1);//test
 if(argc>1 && *argv[1]=='?')
    {printf("programmname  %s\n",VERSION); exit(0);}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>XMAX) breite=XMAX;  if(hoehe>YMAX) hoehe=YMAX;
 if(tiefe>TIEFE) tiefe=TIEFE;
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File","Darstellung");
 setmenu(2,"Exit","Methode ...",&menu_exit,m_methode);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 farbensetzen(NFARBEN,farbtabelle);
 grafik_ersteszeichnen();
 //term_refresh();
 while(exitflag==0 && waitmenu(0)==0)
   {waitBOF();//Bildaufbau abwarten
    grafik_rotieren();
    tek_flush();
   }
 //inital_new();
 term_exit();
 return 0;
}// ende von main

void m_methode()
{
 int ok,me=kamera.getmethode(),me2=hyperkamera.getmethode();
 term_refresh();
 ok=requester_input(2,
		    "3D-Darstellungsmethode (1=Gitter 2=Verdeckt 3=Flaechen)",
		    "%d","%d\n",&me,
		    "4D-Darstellungsmethode (1=durchsichtig, 2=verdeckt)",
		    "%d","%d",&me2);
 if(ok)
     {kamera.setmethode(me);
      hyperkamera.setmethode(me2);
     }
 inital_new();
 screenclear();
}
