/* vectorklasse.cc
 Rechnen mit Vektoren beliebiger Grsse
Anwendung: vectorklasse.h einfgen in C++ Programmen, linken mit vectorklasse.o
*/

#include "vectorklasse.h"
extern "C" {
    int printf(...);//test
}
inline double dabs(double x) {return x<0?-x:x;}

Vector::Vector(int n)
{
 if(n<2) n=2;
// aa=new double[imax=n];
 imax=n;//test
 for(int i=0;i<n;i++) aa[i]=0;
}
Vector::~Vector()
{} //aa _nicht_ freigeben! (vom Betriebssystem schon automatisch gemacht ?)
//{if(aa) {delete aa; aa=0;}} //test

void Vector::resize(int n)
{
 if(n<2) n=2;
 if(imax==n) return;
/*
 delete aa;
 aa=new double[imax=n];
*/
 imax=n; if(imax>4) printf("Vector auf 4 beschraenkt\n");//test
}
Vector::Vector(double a,double b)
{
/*
 aa=new double[imax=2];
*/ imax=2;//test
 aa[0]=a; aa[1]=b;
}
Vector::Vector(double a,double b,double c)
{
/*
 aa=new double[imax=3];
*/ imax=3;//test
 aa[0]=a; aa[1]=b; aa[2]=c;
}
Vector::Vector(double a,double b,double c,double d)
{
/*
 aa=new double[imax=4];
*/ imax=4;//test
 aa[0]=a; aa[1]=b; aa[2]=c; aa[3]=d;
}
//bei Bedarf hier weitere Konstruktoren anfuegen

Vector Vector::operator=(double a)
{
 aa[0]=a; for(int i=1;i<imax;i++) aa[i]=0;
 return *this;
}
Vector Vector::operator=(Vector v)
{
 int n=v.getn();
 if(imax!=n) resize(n);
 for(int i=0;i<n;i++) aa[i]=v[i];
 return *this;
}
Vector Vector::operator+=(Vector v)
{
 int n=v.getn();
 if(imax==n)
     for(int i=0;i<n;i++) aa[i]+=v[i];
 return *this;
}
Vector Vector::operator-=(Vector v)
{
 int n=v.getn();
 if(imax==n)
     for(int i=0;i<n;i++) aa[i]-=v[i];
 return *this;
}
Vector Vector::operator*=(Vector v)
{
 int n=v.getn();
 if(imax==n)
     for(int i=0;i<n;i++) aa[i]*=v[i];
 return *this;
}
Vector Vector::operator/=(Vector v)
{
 int n=v.getn();
 if(imax==n)
     for(int i=0;i<n;i++) aa[i]/=v[i];
 return *this;
}
Vector operator+(Vector v1,Vector v2)
{
 int n=v1.getn();
 if(v2.getn()<n) n=v2.getn();//Addition braucht 2 gleich grosse Vectoren
 Vector v(n);
 for(int i=0;i<n;i++) v[i]=v1[i]+v2[i];
 return v;
}
Vector operator-(Vector v1,Vector v2)
{
 int n=v1.getn();
 if(v2.getn()<n) n=v2.getn();
 Vector v(n);
 for(int i=0;i<n;i++) v[i]=v1[i]-v2[i];
 return v;
}
Vector operator*(Vector v1,double c)
{
 int n=v1.getn();
 Vector v(n);
 for(int i=0;i<n;i++) v[i]=v1[i]*c;
 return v;
}
Vector operator*(double c,Vector v1)
{
 int n=v1.getn();
 Vector v(n);
 for(int i=0;i<n;i++) v[i]=v1[i]*c;
 return v;
}
Vector operator*(Vector v1,Vector v2)
{
 int n=v1.getn();
 Vector v(n);
 if(v2.getn()==n) //nur fuer gleich grosse Vektoren definiert
     for(int i=0;i<n;i++) v[i]=v1[i]*v2[i];
 return v;
}
Vector operator/(Vector v1,double c)
{
 int n=v1.getn();
 Vector v(n);
 for(int i=0;i<n;i++) v[i]=v1[i]/c;
 return v;
}
Vector operator-(Vector v1)
{
 int n=v1.getn();
 Vector v(n);
 for(int i=0;i<n;i++) v[i] = -v1[i];
 return v;
}

double Vector::abs()			//Betrag eines Vektors
{
 double wu=0,*p;
 int i;
 for(i=0,p=aa;i<imax;i++,p++)
     wu += *p * *p;
 return sqrt(wu);
}
double abs(Vector v)			//Betrag eines Vektors
{
 double wu=0;
 int n=v.getn();
 for(int i=0;i<n;i++)
     wu += v[i]*v[i];
 return sqrt(wu);
}
Vector Vector::einheitsvektor()		//v=v/abs(v)
{
 double wu=0,*p;
 int i;
 for(i=0,p=aa;i<imax;i++,p++)
     wu += *p * *p;
 wu=sqrt(wu);
 for(i=0,p=aa;i<imax;i++)
     *p++ /= wu;
 return *this;
}
double xwinkel(Vector v)		//Winkel zwischen Vektor und x-Achse
{	//kommt im Bereich +-PI heraus
 double wu=0;
 int i,n=v.getn();
 for(i=1;i<n;i++)
     wu += v[i]*v[i];
 return atan2(sqrt(wu),v[0]);
}

Vector vektorkreuzprodukt(Vector a,Vector b)	//Kreuzprodukt fuer 3D
{
/*
 v.x =  a.y*b.z-a.z*b.y;
 v.y = -a.x*b.z+a.z*b.x;
 v.z =  a.x*b.y-a.y*b.x;
*/
 double x=0,y=0,z=0;
 const int n=3; //Das Kreuzprodukt ist nur fuer 3D-Vektoren definiert
 if(a.getn()==n || b.getn()==n)
  {x=a[1]*b[2]-a[2]*b[1];
   y=a[2]*b[0]-a[0]*b[2];
   z=a[0]*b[1]-a[1]*b[0];
  }
 Vector v(x,y,z);
 return v;
}

Vector sin(Vector a)
 {int i,n=a.getn(); Vector v(n); for(i=0;i<n;i++) v[i]=sin(a[i]); return v;}
Vector cos(Vector a)
 {int i,n=a.getn(); Vector v(n); for(i=0;i<n;i++) v[i]=cos(a[i]); return v;}

double vektorwinkel(Vector v1,Vector v2)	//Winkel zwischen 2 Vektoren
{
 //geht nur in 3D
 double sina=abs(vektorkreuzprodukt(v1,v2))/(abs(v1)*abs(v2));
 return asin(sina);
}
double sinvektorwinkel(Vector v1,Vector v2)	//sin(Winkel) zw. 2 Vektoren
{
 //geht nur in 3D
 return abs(vektorkreuzprodukt(v1,v2))/(abs(v1)*abs(v2));
}

void Vector::drehen(double sina,double cosa,int a,int b)
{					//Vektor in ab-Ebene drehen
 double x=aa[a],y=aa[b];		//von Achse a richtung Achse b
 aa[a]=x*cosa-y*sina;
 aa[b]=x*sina+y*cosa;
}
