//wuerfeltest.cc
//Perspektivische Darstellung eines sich drehenden Wrfels
#define VERSION "Version 1.0"
#include <stdio.h>
#include <stdlib.h>
#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif
#if GCC_VERSION>=3000
#include <iostream>
using namespace std;
#else
#include <stream.h>
#endif
#ifdef AMIGA
#include <amitekplot1.h>
#else
#include <xtekplot1.h>
#endif
#include "vectorklasse.h"

const int XMAX=640,YMAX=512,TIEFE=4;
static int breite,hoehe,tiefe,visklasse; //Globale Variablen
static double xmin= -2.2, ymin= -2.0, xmax=2.2, ymax=2.0;
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_methode();

class Kante
{
 int ka,kb,kc,kd; //Kante von a nach b mit Linker Flaeche c und Rechter d
public:
 void set(int a,int b,int c,int d) {ka=a; kb=b; kc=c; kd=d;}
 int a() {return ka;}
 int b() {return kb;}
 int c() {return kc;}
 int d() {return kd;}
};

class Flaeche
{
 int k[6]; //Indexe auf maximal 6 Ecken
public:
 int nk,farbe;
 void set(int fa,int a,int b,int c)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; nk=3;}
 void set(int fa,int a,int b,int c,int d)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; nk=4;}
 void set(int fa,int a,int b,int c,int d,int e)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; k[4]=e; nk=5;}
 void set(int fa,int a,int b,int c,int d,int e,int f)
	{farbe=fa; k[0]=a; k[1]=b; k[2]=c; k[3]=d; k[4]=e; k[5]=f; nk=6;}
 int operator[](int i) {return k[i];}
};

//const int MAXECK=16, MAXn2=MAXECK*MAXECK/2, MAXn3=MAXn2*2/3;//test

class Figur
{
protected:
 int maxn,neck,nkant,nf;
 Vector *eck;
 Kante *kant;
 Flaeche *flaech;
/*
 Vector eck[MAXECK];//test
 Kante kant[MAXn2];//test
 Flaeche flaech[MAXn3];//test
*/
public:
 Figur() {maxn=0; eck=NULL; kant=NULL; flaech=NULL;}
 Figur(int n);
 //~Figur() {delete eck; delete kant; delete flaech;} //funktioniert nicht!
 ~Figur() {}
 int getn() {return neck;}
 int ecke(double x,double y,double z) {eck[neck]=Vector(x,y,z); return neck++;}
 int kante(int a,int b,int c,int d) {kant[nkant].set(a,b,c,d); return nkant++;}
 int flaeche(int fa,int a,int b,int c) {flaech[nf].set(fa,a,b,c); return nf++;}
 int flaeche(int fa,int a,int b,int c,int d) {flaech[nf].set(fa,a,b,c,d); return nf++;}
 int flaeche(int fa,int a,int b,int c,int d,int e) {flaech[nf].set(fa,a,b,c,d,e); return nf++;}
 int flaeche(int fa,int a,int b,int c,int d,int e,int f) {flaech[nf].set(fa,a,b,c,d,e,f); return nf++;}
 void zeichnen(int farbe,int met);
 Figur& operator=(Figur&);
 Vector& operator[](int i) {return eck[i];}
};
class Wuerfel:public Figur
{
public:
 Wuerfel();
};
Wuerfel::Wuerfel():Figur(8)
{
 ecke(1,1,1);  ecke(-1,1,1);  ecke(-1,-1,1); ecke(1,-1,1);
 ecke(1,1,-1); ecke(-1,1,-1); ecke(-1,-1,-1); ecke(1,-1,-1);
 kante(0,1,2,5);  kante(1,2,3,6);  kante(2,3,0,7); kante(3,0,1,4);
 kante(5,4,7,0);  kante(6,5,4,1);  kante(7,6,5,2); kante(4,7,6,3);
 kante(0,4,5,7);  kante(1,5,6,4);  kante(2,6,7,5); kante(3,7,4,6);
 flaeche(2,0,1,2,3); flaeche(3,7,6,5,4); flaeche(4,1,5,6,2);
 flaeche(5,3,7,4,0); flaeche(6,1,0,4,5); flaeche(7,3,2,6,7);
}
static Wuerfel wuerfel;

Figur::Figur(int n)
{
 int n2=n*n/2, n3=n2*2/3;
 eck=new Vector[maxn=n];
 kant=new Kante[n2];
 flaech=new Flaeche[n3];
 neck=0; nkant=0; nf=0;
}
Figur& Figur::operator=(Figur& f)
{
 int i,n2=f.maxn*f.maxn/2, n3=n2*2/3;
 if(maxn!=f.maxn)
    {delete eck; eck=new Vector[maxn=f.maxn];
     delete kant; kant=new Kante[n2];
     delete flaech; flaech=new Flaeche[n3];
    }
 neck=f.neck; nkant=f.nkant; nf=f.nf;
 for(i=0;i<neck;i++)
     eck[i]=f.eck[i];
 for(i=0;i<n2;i++)
     kant[i]=f.kant[i];
 for(i=0;i<n3;i++)
     flaech[i]=f.flaech[i];
 return *this;
}
void linie(Vector a,Vector b)
{
 plot(a[0],a[1],PENUP); plot(b[0],b[1],PENDOWN);
}
void Figur::zeichnen(int farbe,int met)
{
 Vector p1,p2,p3,p4,p[6];
 double wi;
 color(farbe);
 if(met==1) //alle Kanten zeichnen
    {for(int i=0;i<nkant;i++)
	 linie(eck[kant[i].a()],eck[kant[i].b()]);
    }
 else if(met>=2) //verdeckte Kanten nicht zeichnen
  {if(met==3)
    {for(int i=0;i<nf;i++) //Flaechen zeichnen
      {p[0]=p1=eck[flaech[i][0]];
       p[1]=p2=eck[flaech[i][1]];
       p[2]=p3=eck[flaech[i][2]]; p3-=p1;
       wi=atan2(p2[1]-p1[1],p2[0]-p1[0]);
       p3.drehen(wi,1,0);
       if(p3[1]>0)
        {int j,jmax=flaech[i].nk;
         double xf[6],yf[6];
	 if(farbe!=0) color(flaech[i].farbe);
	 for(j=3;j<jmax;j++) p[j]=eck[flaech[i][j]];
	 for(j=0;j<jmax;j++) {xf[j]=p[j][0]; yf[j]=p[j][1];}
	 fillpolygon(jmax,xf,yf);
	}
      }
     if(farbe!=0) color(farbe);
    }
   for(int i=0;i<nkant;i++) //Kanten zeichnen, ohne verdeckte
    {p1=eck[kant[i].a()];
     p2=eck[kant[i].b()];
     p3=eck[kant[i].c()]; p3-=p1;
     p4=eck[kant[i].d()]; p4-=p1;
     wi=atan2(p2[1]-p1[1],p2[0]-p1[0]);
     p3.drehen(wi,1,0);
     p4.drehen(wi,1,0);
     if(p3[1]>=0 || p4[1]<=0)
	 linie(p1,p2);
    }
  }
}

class Kamera
{
 Vector ka;//Position der Kamera
 Vector beob;//Beobachtungspunkt
 double ab;//Abstand Brennpunkt-Bildebene
 double alfa,beta,gamma;//Winkel in rad, aus obigen Variablen zu berechnen
 double sina,cosa,sinb,cosb,sing,cosg,absk;
 Figur bild1,bild2;//zuletzt gezeichnetes, und neues Bild
 int gezeichnet,met;
 void rechnen();
 Vector projektion(Vector);
public:
 Kamera() {ka=Vector(0,-20,0); beob=Vector(0,0,0);
	   ab=10; gezeichnet=0; met=1; rechnen();}
 void rotieren();
 void foto(Figur&);
 void zeichnen();
 int getmethode() {return met;}
 void setmethode(int m) {if(m>0 && m<=3) met=m;}
};
static Kamera kamera;

void Kamera::rechnen()
{
 Vector k;
 k=ka-beob; absk=abs(k);
 alfa=atan2(k[1],k[0])+PIHALBE;
 beta=atan2(sqrt(k[0]*k[0]+k[1]*k[1]),k[2]);
 sina=sin(alfa); cosa=cos(alfa);
 sinb=sin(beta); cosb=cos(beta);
 sing=sin(gamma); cosg=cos(gamma);
}
void Kamera::rotieren()
{
 static int betri=1;
 double alf;
 ka.drehen(alf=alfa,1,0);
 alf += 1.0*GRAD;
 if(betri==1 && beta<=GRAD) {betri=0;}
 else if(betri==0 && beta>=179*GRAD) {betri=1;}
 if(betri==1) ka.drehen(0.1*GRAD,2,1);
 else ka.drehen(0.1*GRAD,1,2);
 ka.drehen(alf,0,1);
 rechnen();
}
void Kamera::foto(Figur& w)
{
 if(gezeichnet==1)
     {bild2=w;
      for(int i=0;i<bild2.getn();i++)
	  bild2[i]=projektion(bild2[i]-beob);
     }
 else
     {bild1=w;
      for(int i=0;i<bild1.getn();i++)
	 bild1[i]=projektion(bild1[i]-beob);
     }
}
Vector Kamera::projektion(Vector p)
{
 p.drehen(sina,cosa,1,0);
 p.drehen(sinb,cosb,2,1);
 p.drehen(sing,cosg,0,1);
 return p/(absk-p[2])*ab;
}
void Kamera::zeichnen()
{
 if(gezeichnet==1)
	{bild1.zeichnen(0,met); bild2.zeichnen(1,met); gezeichnet=2;}
 else if(gezeichnet==2)
	{bild2.zeichnen(0,met); bild1.zeichnen(1,met); gezeichnet=1;}
 else {bild1.zeichnen(1,met); gezeichnet=1;}
}
void grafik_ersteszeichnen()
{
 kamera.foto(wuerfel);
 kamera.zeichnen();
}
void grafik_rotieren()
{
 kamera.rotieren();
 kamera.foto(wuerfel);
 kamera.zeichnen();
}

main(int argc,char *argv[])
{
 //tek_setdebug(1);//test
 if(argc>1 && *argv[1]=='?')
    {printf("programmname  %s\n",VERSION); exit(0);}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>XMAX) breite=XMAX;  if(hoehe>YMAX) hoehe=YMAX;
 if(tiefe>TIEFE) tiefe=TIEFE;
 setsize(breite,hoehe,tiefe);
 setmenu(2,"File","Darstellung");
 setmenu(2,"Exit","Methode ...",&menu_exit,m_methode);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 grafik_ersteszeichnen();
 //term_refresh();
 while(exitflag==0 && waitmenu(0)==0)
   {waitBOF();//Bildaufbau abwarten
    grafik_rotieren();
    tek_flush();
   }
 //inital_new();
 term_exit();
 return 0;
}// ende von main

void m_methode()
{
 int ok,me=kamera.getmethode();
 term_refresh();
 ok=requester_input(1,"Darstellungsmethode (1=Gitter 2=Verdeckt 3=Flaechen)",
		    "%d","%d",&me);
 if(ok)
     kamera.setmethode(me);
 inital_new();
 screenclear();
}
