/*---------------------------------------------------------------------------*
 * File Name:	uvimport.c
 * Creation: 	Rolf Pfister
 * Purpose: OriginC Source C file to import UV files of format UVOD2
 * Copyright (c) Freeware 2003
 * Modification Log:
   28.3.2003  first usable version
   31.3.2003  Version 1.0  make it shorter and using dialog for filename
   13.10.03   Version 1.1  supporting SPEX2 format

 *---------------------------------------------------------------------------*/

#include <origin.h>
//#include <string.h>
// NAG routines
//#include <OC_nag.h> // this contains all the NAG headers, 

// Prototype of all functions in this file:
int OpenFile(string strFileName);
int CloseFile();
int ReadFile();
void spex_parameter_lesen(int c,FILE *fp,char* substanzname);

// Declare the file, and file name as a global variable to provide access from all functions
	file fScan;
	string strFileName;

///////////////////////////////////////////////////////////////////////////////
// OpenFile: This function opens the file for reading
//
int OpenFile(string strName)
{
	strFileName = strName;
	bool bRet;
	bRet = fScan.Open(strFileName, file::modeRead);
	if(!bRet) return 1;	
	printf("Opened file: %s\n",strFileName);	
	return 0;
}

///////////////////////////////////////////////////////////////////////////////
// CloseFile: This function closes the file
//
int CloseFile()
{
	// close file
	bool bRet;
	bRet = fScan.Close();
	if(!bRet) return 1;
	return 0;
}	


///////////////////////////////////////////////////////////////////////////////
// Standard C functions missing in OriginC
//
#define FILE int
#define EOF (-1)

/* in older Origin-Versions this was also needed:
int strcmp(char *s,char *t)
{
 int c,c2;
 while((c= *s++) == (c2= *t++))
   {if(c==0) return 0;}
 return c2-c;
}
strcpy(char *z,char *q)
{
 while(*z++ = *q++) ;
}
/* */

/* maybe in newer Origin-Versions this can be commented out: */
int isdigit(int c)
{
 return c>='0' && c<='9';
}
int toupper(int c)
{
 if(c>='a' && c<='z') c += 'A'-'a';
 return c;
}
/* */

///////////////////////////////////////////////////////////////////////////////
// Common functions for reading UV files
//

// LONG must be 4-Byte int, WORD must be 2-Byte int
#define LONG long
//#define WORD int
#define CASE break;case

#define OD		1
#define EPSILON		2
#define LOGEPSILON	4
#define TRANSMISSION	8
#define SIGMA		0x10
#define EPSILONMASK	0x16 /* (EPSILON | LOGEPSILON | SIGMA) */

int mygetc()
{
 int ierr;
 byte b;
 ierr=fScan.Read(&b, 1);
 if(ierr<0) return EOF;
 return b&0xFF;
}

struct uv_kopf
{       LONG    start,ende,delta,slit;   /* Werte in PicoMeter (0.001nm) */
        WORD    period;   /* Daempfung in Millisekunden */
        WORD    multi;    /* Anzahl Multiscans, Daten aber bereits dividiert */
        LONG    conz;     /* Konzentration * Schichtdicke in NanoMol/l*cm    */
        LONG    yfaktor;  /* Die y-Werte sind um diesen Faktor vergroessert  */
};

int gepacktlesen(FILE *fp,LONG *y)
{
 /* Wenn erstes Bit gesetzt (c & 0x80 == 0x80), dann sind die restlichen 7 Bits
    die Differenz zum vorherigen Wert.
    Wenn das erste Bit nicht, aber das 2.Bit gesetzt ist (c & 0xC0 == 0x40),
    dann sind die restlichen 6 Bits + das naechste Byte die Differenz zum
    vorherigen Wert.
    Wenn weder das erste noch das 2. Bit gesetzt sind (c & 0xC0 == 0), dann
    sind die restlichen 6 Bits + die naechsten 3 Bytes ein absoluter Wert.
 */
 static long letzterwert=0;
 long dy;
 int c,c2,c3,c4;
 if((c=mygetc())==EOF) {*y=0; return EOF;}
 if(c & 0x80)
        {dy=c & 0x7F; if(dy & 0x40) dy |= 0xFFFFFF80;
         *y=letzterwert+=dy;
        }
 else if(c & 0x40)
        {c2=mygetc();
         dy=((c & 0x3F)<<8)+c2; if(dy & 0x2000) dy |= 0xFFFFC000;
         *y=letzterwert+=dy; c=c2;
        }
 else
        {c2=mygetc(); c3=mygetc(); c4=mygetc();
         dy=(c<<24)+(c2<<16)+(c3<<8)+c4; if(dy & 0x20000000) dy |= 0xC0000000;
         *y=letzterwert=dy; c=c4;
        }
 return c;
}

int wordlesen(FILE *fp)
{
 int c1,c2; WORD x;
 c1=mygetc(); c2=mygetc();
 x=(c1<<8)+c2;
 return x;
}

LONG longlesen(FILE *fp)
{
 LONG c1,c2,c3,c4,x;
 c1=mygetc(); c2=mygetc(); c3=mygetc(); c4=mygetc();
 x=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 return x;
}

double mody_umrechnung(double y,int mody,double conz)
{						/* y enthlt den OD-Wert und */
 if(mody & EPSILONMASK)				/* wird dann gemss mody auf */
	{y /= conz;				/* die gewnschte Einheit    */
	 if(mody==LOGEPSILON)			/* umgerechnte.              */
		{if(y < 0.001) y=0.001;
		 y=log10(y); /* log(Epsilon) */
		}
	 else if(mody==SIGMA)
		{y *= 0.3823;}
	}
 else if(mody==TRANSMISSION)
	y=100.*pow(10.,-y); /* Prozent Transmission */
 return y;
}

static uv_kopf kopf;
static float yfeld[32000+2];

////////////////////////////////////////////////////////////////////////////////////
// ReadFile: This function reads from the opened file
//
int ReadFile()
{
 FILE *fp=NULL;
 char format[10],*s,substanzname[200];
 string strComments;
 int i,c,npkt,iCountPts,jj;
 LONG x,y,j;
 float start,ende,*py;
 double konz,yfakt;
 //fp=fopen(filename,"r");
 for(i=0;i<8;i++) format[i]=mygetc();
 format[8]=0;
 printf("Format='%s'\n",format);
 if(strcmp(format,"UVOD2   ")==0)
	{//uvformat=UVOD2;
	 for(s=substanzname;(c=mygetc())>=' ';)  *s++ = c;
	 *s=0;
	 kopf.start=longlesen(fp); kopf.ende=longlesen(fp);
	 kopf.delta=longlesen(fp); kopf.slit=longlesen(fp);
	 kopf.period=wordlesen(fp); kopf.multi=wordlesen(fp);
	 kopf.conz=longlesen(fp); konz=kopf.conz/1e9;
	 kopf.yfaktor=longlesen(fp); yfakt=(double)kopf.yfaktor;
	 start=kopf.start/1e3; ende=kopf.ende/1e3; //Umrechnung in nm
	 npkt=(kopf.start-kopf.ende)/kopf.delta+1; //Anzahl y-Werte
	 if(npkt>32000) {printf("too much points - restricted to 32000\n"); npkt=32000;}//provi.
	 for(py=yfeld,x=kopf.start,jj=0; x>=kopf.ende; x-=kopf.delta,py++,jj++)
           {if(gepacktlesen(fp,&y)==EOF) printf("Fehler in UV-Datei\n");
            *py=mody_umrechnung(y/yfakt,OD,konz);
	    if(jj>=32000) break;//provi.
	   }
	 iCountPts=npkt;
	 strComments.Format("Slit=%.2lf nm    Conz*d=%lg mol/l*cm",kopf.slit/1e3,konz);
	 //strComments="some trash because nobody knows how to create a OTW file";

	 // now create a worksheet using custom template
	 Worksheet wksData;
	 // Dont know yet how to create uv.otw,
	 // so it contains trash from BinaryImport example.
	 string strWksTemplate = GetAppPath() + "OriginC\uv.otw";
	 int nOptionW = CREATE_VISIBLE_SAME;
	 bool bRetW = wksData.Create(strWksTemplate, nOptionW);

	 // now assign datasets to columns in the new worksheet
	 Dataset dsnm(wksData, 0);	// Wavelength in nm in first column
	 Dataset dsod(wksData, 1);	// OD in second column

	 // set dataset length to number of points in scan	
	 dsnm.SetSize(iCountPts);
	 dsod.SetSize(iCountPts);
		
	 // update labels in the worksheet using LabTalk
	 string strLabel = "IDFileName.text$ = \\b(File Name:) \\v( " + strFileName + ")";
	 LT_execute(strLabel);

	 strLabel = "IDSample.text$ = \\b(Sample:) " + substanzname;
	 LT_execute(strLabel);

	 strLabel = "IDComments.text$ = \\b(Comments:) " + strComments;
	 LT_execute(strLabel);

	 // now read all points in current scan and assign to dataset
	 for(int jj = 0; jj < iCountPts; jj++)
		{
		  dsnm[jj] = (kopf.start-jj*kopf.delta)*1e-3;
		  dsod[jj] = yfeld[jj];
		}
	 printf("Done reading UV spectrum.\n");
	}
 else if(strcmp(format,"SPEX2   ")==0)
	{LONG period;
	 int nfehler=0;
	 kopf.conz=0;
	 while((c=mygetc())<30 && c!=EOF)
	   spex_parameter_lesen(c,fp,substanzname);
	 if(c!=0xFF) printf("Fehler bei spex_parameter_lesen c=%02X\n",c);
	 period = (kopf.period<0) ? -1000*kopf.period : kopf.period;
	 kopf.yfaktor=1000*period*kopf.multi;
	 yfakt=(double)kopf.yfaktor;
	 //printf("yfakt=%lf\n",yfakt);//test
	 konz=kopf.conz/1e9;
	 start=kopf.start/1e3; ende=kopf.ende/1e3;
	 npkt=(kopf.start-kopf.ende)/kopf.delta+1;
	 if(npkt>32000) {printf("too much points - restricted to 32000\n"); npkt=32000;}//provi.
	 for(py=yfeld,x=kopf.start,jj=0; x>=kopf.ende; x-=kopf.delta,py++,jj++)
	   {if(gepacktlesen(fp,&y)==EOF) nfehler++;
	    *py=y; //*py=mody_umrechnung(y/yfakt,*mody,konz);
	    if(jj>=32000) break;//provi.
	   }
	 iCountPts=npkt;
	 strComments.Format("Slit=%.2lf nm    Conz*d=%lg mol/l*cm",kopf.slit/1e3,konz);
	 // now create a worksheet using custom template
	 Worksheet wksData;
	 // Dont know yet how to create uv.otw,
	 // so it contains trash from BinaryImport example.
	 string strWksTemplate = GetAppPath() + "OriginC\uv.otw";
	 int nOptionW = CREATE_VISIBLE_SAME;
	 bool bRetW = wksData.Create(strWksTemplate, nOptionW);

	 // now assign datasets to columns in the new worksheet
	 Dataset dsnm(wksData, 0);	// Wavelength in nm in first column
	 Dataset dsod(wksData, 1);	// OD in second column

	 // set dataset length to number of points in scan	
	 dsnm.SetSize(iCountPts);
	 dsod.SetSize(iCountPts);
		
	 // update labels in the worksheet using LabTalk
	 string strLabel = "IDFileName.text$ = \\b(File Name:) \\v( " + strFileName + ")";
	 LT_execute(strLabel);

	 strLabel = "IDSample.text$ = \\b(Sample:) " + substanzname;
	 LT_execute(strLabel);

	 strLabel = "IDComments.text$ = \\b(Comments:) " + strComments;
	 LT_execute(strLabel);

	 // now read all points in current scan and assign to dataset
	 for(int jj = 0; jj < iCountPts; jj++)
		{
		  dsnm[jj] = (kopf.start-jj*kopf.delta)*1e-3;
		  dsod[jj] = yfeld[jj];
		}
	 printf("Done reading SPEX spectrum.\n");
	}
 else printf("unknown format %s\n",format);
 return 0;
}

void uvimport(string strPath)
{
 if(strPath.IsEmpty())
  {StringArray saFiletypes;
   saFiletypes.SetSize(4);
   saFiletypes[0]="[UV-Spectrum (*.UV)] *.UV";
   saFiletypes[1]="[UV-Matrix (*.UVX)] *.UVX";
   saFiletypes[2]="[Emission (*.SPEX)] *.SPEX";
   saFiletypes[3]="[all files (*.*)] *.*";
   //strPath = GetOpenBox(saFiletypes); // or
   strPath = GetOpenBox(saFiletypes, GetAppPath() ); // or
   //strPath = GetOpenBox( saFiletypes, "C:\\Programme\\OriginLab\\","Origin7");//or
   //strPath = GetOpenBox( saFiletypes, "C:\\Program Files\\", "Origin", "OpenOPJ" );
   if(strPath.IsEmpty())
     {out_str("cancelled Open dialog box\n"); return;}
  }
 if(OpenFile(strPath)==0)
  {ReadFile();
   CloseFile();
  }
 else
  printf("cant open '%s'\n",strPath);
}

/*************************** kleinkram ***************************/
long idfix(double x) {return (x>=0.) ? x+0.5 : x-0.5;} /* Runden */

int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=mygetc())!=EOF && c!='\n' && c!=0)
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/*************************** SPEX2-Format ********************************/
LONG picometer(char *zeile)
{
 char *s;
 int c,c2;
 double x;
 for(s=zeile;(c= *s++) && (isdigit(c) || c=='.' || c==' ');) ;
 if(c!=0) {c=toupper(c); c2=toupper(*s);}
 //sscanf(zeile,"%lf",&x);
 x=atof(zeile);
 if(c=='A' && c2=='U') x*=0.1; //von Angstrom in nm umrechnen
 else if(c=='C' && c2=='M') x=1e7/x; //von cm-1 in nm umrechnen
 return (LONG)(1000*x+0.5);
}
double xlesen(char *zeile)
{
 double x;
 //sscanf(zeile,"%lf",&x);
 x=atof(zeile);
 return x;
}
long nlesen(char *zeile)
{
 long x;
 //sscanf(zeile,"%ld",&x);
 x=atol(zeile);
 return x;
}

//#include "spex2.h"

void spex_parameter_lesen(int c,FILE *fp,char* substanzname)
{
 char *s,zeile[120];
 double x;
 getline(fp,zeile,120);
 if(c<0 || c>=30) printf("Fehler: spexstring %d ungueltig\n",c);
 //else printf("%2d %s  %s\n",c,ptext[c],zeile);//test
 else printf("%2d  %s\n",c,zeile);//test
 switch(c)
  {case 2: strcpy((char*)substanzname,zeile);
   CASE 20: kopf.start=picometer(zeile);
   CASE 21: kopf.ende=picometer(zeile);
   CASE 22: kopf.delta=picometer(zeile);
   CASE 16: kopf.slit=picometer(zeile);//provi.
   CASE 28: x=xlesen(zeile);
	    kopf.period=idfix((x>32.767)?-x:1000*x);
   CASE 24: kopf.multi=nlesen(zeile);
   CASE 8:  kopf.conz=(int)(1e9*xlesen(zeile));
  }
}

/* in custom.ogs use this:
 uvimport("");
*/
