/* GasExp.cc		Simulation eines Gases   letzte Aenderung: 1.12.99 */
#define VERSION "Version 0.4"
//#define MAC 1
//#define TEST
//#define TEST1
//#define KEINESTOESSE /* Test: keine Stoesse zwischen Atomen */
/*
History
28.10.98  V0.1	Erstellung (RPF)
24.11.98  V0.2  Stoesse beruecksichtigen
28.10.99	Option GANZOFFEN
1.11.99   V0.4  Verbessertes check_collision()
15.11.99        Variante zur Darstellung von Diffusion
10.11.2016      Fehler bei delete korrigiert, unbenutzte Variablen auskommentiert
16.11.          ueberfluessiges "riwexel" auskommentiert
*/

#define GANZOFFEN
//#define MITKURVE
//#define DIFFUSION

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#ifdef MAC
#include "tekplot.h"
#else
#include <xtekplot1.h>
#endif
//#include <atan2.h>
#include "vektorklasse.cc"

#ifndef bool
#define bool int
#define true 1
#define false 0
#endif

#ifndef CASE
#define CASE break;case
#define DEFAULT break;default
#endif

//Sicherstellen dass nicht durch 0 dividiert wird:
#define divisor(z) (((z)==0)?1:(z))

const int XMAX=640,YMAX=512,TIEFE=4;	/* 16 Farben reichen */
//const int XMAX=320,YMAX=256,TIEFE=4;	/* 16 Farben reichen */
//const int XMAX=480,YMAX=384,TIEFE=4;	/* 16 Farben reichen */

/************************ Testfunktionen *********************************/
#ifdef TEST1
#define ifillcircle idrawcircle
#define TESTprintf printf
#else
inline void TESTprintf(...) {}
#endif

void testhalt(char *str)
{
// printf("%s, weiter mit RETURN",str); getc(stdin); getc(stdin);//test
 inital_new(0.,0.,XMAX,YMAX);//test
 janeinrequester(str,"ok",NULL);
}

void testprintf(char *s,double p1=0,double p2=0)
{
 char str[200];
 sprintf(str,s,p1,p2);
 janeinrequester(str,"ok",NULL);
}

/*********************** Vordeklarationen ********************************/
void setmenus();
void verteilung_zeichnen();
void verteilung_loeschen();
void verteilung_reset();
void verteilung_reset_all();
bool kantenstoss(vektor p1,vektor p2,vektor wp,double r,vektor& p2s,vektor& v2);

/*********************** globale Variablen *******************************/
#ifdef TEST
static int atomradius=30,natome=2;//test
static int offen= 1;//test
#else
static int atomradius=7; //gute Werte: 5 bis 9
static int natome=40; //guter Wert: 40
static int offen= -1;//provi.
#endif
#ifdef GANZOFFEN
static int nwaende=5;
#else
static int nwaende=7; //oder 9
#endif
static double atomdurchm=atomradius+atomradius,atomradiusquad=atomradius*atomradius;
void set_atomradius(int r) {atomradius=r; atomdurchm=r+r; atomradiusquad=r*r;}

/********************* Klassendeklarationen ******************************/
class Fenster
{
 double xmin,ymin,xmax,ymax;
 int breite,hoehe,tiefe,visklasse;
public:
 Fenster();
 ~Fenster();
};

static Fenster *fenster;

Fenster::Fenster()
{
 xmin=0.,ymin=0.,xmax=XMAX,ymax=YMAX;
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(breite>XMAX) breite=XMAX;
 if(hoehe>YMAX) hoehe=YMAX;
 if(tiefe>TIEFE) tiefe=TIEFE;
 setsize(breite,hoehe,tiefe);
 setmenus();
 inital(xmin,ymin,xmax,ymax);
 setcolor(4,80,150,255);//4 auf hellblau setzen
 term_refresh();
 inital_new();
}
Fenster::~Fenster()
{
 term_exit();
}

class Wand
{
public:
 int typ;
#define SENKRECHT 1
#define WAAGRECHT 2
 vektor p1,p2;
 void init(double x1,double y1,double x2,double y2);
 void zeichnen();
};
void Wand::init(double x1,double y1,double x2,double y2)
{
 p1.x=x1; p1.y=y1;
 p2.x=x2; p2.y=y2;
 if(x1==x2) typ=SENKRECHT; else typ=WAAGRECHT;
}
void Wand::zeichnen()
{
 plot(p1.x,p1.y,PENUP); plot(p2.x,p2.y,PENDOWN);
}

static Wand *waende=NULL;

class Atom
{
public:
 int	ix,iy;		//aktuelle Position in Pixelkoordinaten
 int altix,altiy;//provi.
 vektor pos,v,altpos,altv;
 //int	riwexel;	//Richtungswechsel
 Atom() {/*riwexel=0;*/}
 ~Atom() {}
 void init(vektor neupos,vektor neuv);
 void zeichnen() {ifillcircle(altix=ix,altiy=iy,atomradius,atomradius);}
 void loeschen() {ifillcircle(altix,altiy,atomradius,atomradius);}//provi.
 void neuposv(double dt);
 void altposv() {pos=altpos; v=altv;}
};

void Atomkopieren(Atom& y,Atom& x) //provi. wegen Compilererror in Codewarrior
{
 y.ix=x.ix; y.iy=x.iy;
 y.altix=x.altix; y.altiy=x.altiy;
 y.pos=x.pos; y.v=x.v; y.altpos=x.altpos; y.altv=x.altv;
 //y.riwexel=x.riwexel;
}

void eventspiegeln(Wand *w,vektor *altpos,vektor *pos,vektor *v,int flag)
{
 double x,x1,x2,y1,y2,xw,yw1,yw2,ys;
 int spiegeln=0;
 if(flag==SENKRECHT)
	{x=w->p1.x;
	 if((altpos->x < x  &&  pos->x > (xw=x-atomradius))
	    || (altpos->x > x  &&  pos->x < (xw=x+atomradius)))
	    {spiegeln=1; yw1=w->p1.y-atomradius; yw2=w->p2.y+atomradius;
	     x1=altpos->x; x2=pos->x; y1=altpos->y; y2=pos->y;
	    }
	}
 else
	{x=w->p1.y;
	 if((altpos->y < x  &&  pos->y > (xw=x-atomradius))
	    || (altpos->y > x  &&  pos->y < (xw=x+atomradius)))
	    {spiegeln=1; yw1=w->p1.x-atomradius; yw2=w->p2.x+atomradius;
	     x1=altpos->y; x2=pos->y; y1=altpos->x; y2=pos->x;
	    }
	}
 if(spiegeln)
  {ys=(y2-y1)*(xw-x1)/(x2-x1)+y1;
   if(yw1<=ys && ys<=yw2)
    {if(flag==SENKRECHT)
	{if(ys>=w->p1.y && ys<=w->p2.y) //Abprall von senkrechter Wand
	   {pos->x = xw-(x1-xw); v->x= -v->x;}
	 else //Abprall von Ecke
	   {vektor wp=(ys<w->p1.y)?w->p1:w->p2;
	    kantenstoss(*altpos,*pos,wp,atomradius,*pos,*v);
	   }
	}
     else //Waagrechte Waende haben keine Kanten (in diesem Progi)
 	{pos->y = xw-(x1-xw); v->y= -v->y;}
  } }
 return;
}

void Atom::neuposv(double dt) //neue Position und Geschwindigkeit
{
 altpos=pos; altv=v;
 pos += v*dt;
 Wand *w;
 int i;
 for(w=waende,i=0;i<nwaende;w++,i++)
   if(i!=offen)
    switch(w->typ)
     {case SENKRECHT: eventspiegeln(w,&altpos,&pos,&v,SENKRECHT);
      CASE WAAGRECHT: eventspiegeln(w,&altpos,&pos,&v,WAAGRECHT);
     }
 if(pos.x<waende[0].p1.x) pos.x=waende[0].p1.x+atomradius;//Hinter Linker Wand ? provi.
 if(pos.x>waende[2].p1.x) pos.x=waende[2].p1.x-atomradius;//Hinter Rechter Wand ? //provi.
 if(pos.y>waende[3].p1.y) pos.y=waende[3].p1.y-atomradius;//ueber Decke ? //provi.
 if(pos.y<waende[4].p1.y) pos.y=waende[4].p1.y+atomradius;//unter Boden ? //provi. 
 koorduser2pix(pos.x,pos.y,&ix,&iy);
}

void Atom::init(vektor neupos,vektor neuv)
{
 pos=altpos=neupos;
 v=neuv;
 //riwexel=0;
 koorduser2pix(pos.x,pos.y,&ix,&iy);
}

/********************* weitere Vordeklarationen **************************/
void atome_initialisieren();
void atome_loeschen();
bool check_collision(Atom *at,Atom *at2);
void do_collision(Atom *at,Atom *at2,double dt);
double zufall(double y=0.);
vektor zufallspunkt(vektor p1,vektor p2);
vektor zufallsgeschwindigkeit(vektor p1,vektor p2);
vektor verteilung_testen(vektor z);
void verteilung_testen(vektor z,int x);

/************************ Minifunktionen *********************************/
inline int innerhalb(int ix,int iy,int x1,int y1,int x2,int y2)
{
 return (ix>x1 && iy>y1 && ix<x2 && iy<y2);
}

inline long idfix(double x) {return x<0.?(long)(x-0.5):(long)(x+0.5);}

/*********************** Globale Variablen *******************************/
/*
static double
	minposx,minposy,maxposx,maxposy, //Bereich fuer Atome
	zweimal_maxposx,zweimal_maxposy,
	zweimal_minposx,zweimal_minposy;
*/
static double
	vmaxbetrag=YMAX; //Maximale Geschwindigkeit beim Atome Initialisieren
static double
	vmaxbetrag2=1.5*YMAX;//test
//static int natome=20,nwaende=5;  schon weiter oben gemacht
//static
 Atom *atome=NULL;
#ifdef DIFFUSION
 Atom *atome2=NULL;
#endif
//static AltAtom *alteatome;
//static Wand *waende=NULL;
struct _maus {int zustand,x,y;} maus;
static short exitflag=0,waitflag=0,sparflag=0,kolliflag=1,statflag=1;
//static short statflag2=0;
static int zeitlupe=0;
//static int weiss=1,rot=2,gruen=3;

void waende_zeichnen()
{
 color(1);
 for(int i=0;i<nwaende;i++)
   if(i!=offen) waende[i].zeichnen();
}

void wand_loeschen(int i) //provi.
{
 static int flag=0;
 if(flag==0)
 	{color(0); waende[i].zeichnen(); flag=1;}
}

void atome_zeichnen()
{
 color(3);
 for(int i=0;i<natome;i++)
 	{atome[i].zeichnen();
#ifdef DIFFUSION
	 color(4);
 	 atome2[i].zeichnen();
 	 color(3);
#endif
 	}
// color(5); atome[0].zeichnen(); //test: oberste Atome andere Farbe
// color(4); atome[1].zeichnen();
// color(3);
// for(int i=2;i<natome;i++) atome[i].zeichnen();
}

void atome_sortieren()
{
//so sortieren dass die oberen Atome zuerst gezeichnet werden
 int i,j=1,n=1,y0,y;
 int jmax=3; //natome fuer optimalstes Sortieren
 Atom at;
 for(;n>0 && j<jmax;j++)
  {for(y0=atome[j-1].iy,n=0,i=j;i<natome;i++)
	{if((y=atome[i].iy) < y0)
		{//vertausche(i-1,i)
		 //at=atome[i]; atome[i]=atome[i-1]; atome[i-1]=at;
		 Atomkopieren(at,atome[i]);
		 Atomkopieren(atome[i],atome[i-1]);
		 Atomkopieren(atome[i-1],at);
		 n++;
		}
	 else y0=y;
	}
  }
#ifdef DIFFUSION
 for(n=1,j=1;n>0 && j<jmax;j++)
  {for(y0=atome2[j-1].iy,n=0,i=j;i<natome;i++)
	{if((y=atome2[i].iy) < y0)
		{//at=atome2[i]; atome2[i]=atome2[i-1]; atome2[i-1]=at;
		 Atomkopieren(at,atome2[i]);
		 Atomkopieren(atome2[i],atome2[i-1]);
		 Atomkopieren(atome2[i-1],at);
		 n++;
		}
	 else y0=y;
	}
  }
#endif
}

void atome_loeschen() //provi.
{
 color(0);
 for(int i=0;i<natome;i++) atome[i].loeschen();
}

/**************************** Klassen ************************************/

/***************************** Hauptprogramm **************************/
double altesfeld[26];

void myscreenclear()
{
 screenclear(); //auf alten MACs zu langsam
 //iviereck(0,0,tekplot_breite-1,tekplot_hoehe-1,0);
 //verteilung_loeschen();
 //atome_loeschen();
}

char	menu_text0[]="%R 0",
	menu_text1[]="%r 1",
	menu_text5[]="%r 5",
	menu_text25[]="%r 25",
	menu_textspar[]="%q Spardarstellung ",
	menu_textkolli[]="%Q Kollisionen";
long zeitl_ids[4];
void menuflip(long id,short *flag,int c1,int c0,char *text)
{
 text[1]=(*flag ^= 1)?c1:c0;
 changemenu(id,text);
}
void zeitlmarke(long id,char *text)
{
 if(zeitl_ids[0]==0) getmenuids(id,zeitl_ids);
 menu_text0[1]=menu_text1[1]=menu_text5[1]=menu_text25[1]='r';
 text[1]='R';
 changemenu(zeitl_ids[0],menu_text0);
 changemenu(zeitl_ids[1],menu_text1);
 changemenu(zeitl_ids[2],menu_text5);
 changemenu(zeitl_ids[3],menu_text25);
}

void menu_exit() {exitflag=1;}
void menu_start() {waitflag=0;}
void menu_stop() {waitflag=1;}
void zeitlupe_0(long id) {zeitlupe=0; zeitlmarke(id,menu_text0);}
void zeitlupe_1(long id) {zeitlupe=1; zeitlmarke(id,menu_text1);}
void zeitlupe_5(long id) {zeitlupe=5; zeitlmarke(id,menu_text5);}
void zeitlupe_25(long id) {zeitlupe=25; zeitlmarke(id,menu_text25);}
void menu_refresh() {screenclear();
		     waende_zeichnen();
		     atome_zeichnen();
		    }
void menu_spar(long id) {menuflip(id,&sparflag,'Q','q',menu_textspar);}
void menu_anzatome() {int ok;
		      long n=natome; int r=atomradius; double vm=vmaxbetrag;
		      ok=requester_input(3,"Anzahl Atome","%ld","%ld\n",&n,
		      			"Atomradius","%d","%d",&r,
		      			"Maximale Geschwindigkeit","%.2lf","%lf",&vm);
		      if(ok)
		       {//testhalt("Testhalt vor delete(atome)");//test
		        //delete(atome);// <-- hier unerfindlicher Absturz
			delete[] atome;
		        //testhalt("Testhalt nach delete(atome)");//test
		        set_atomradius(r); vmaxbetrag=vm;
		        atome=new Atom[natome=n];
#ifdef DIFFUSION
		        atome2=new Atom[natome=n];
#endif
		        atome_initialisieren();
		       }
		      menu_refresh();
		     }
void menu_atomradi(){int r=atomradius;
		     int ok=requester_input(1,"Atomradius","%d","%d",&r);
		     if(ok) set_atomradius(r);
		    }
void menu_kolli(long id) {menuflip(id,&kolliflag,'Q','q',menu_textkolli);}
void menu_geschw() {int ok;
		    ok=requester_input(1,"Maximale Geschwindigkeit","%.2lf","%lf",&vmaxbetrag);
		    if(ok) atome_initialisieren();
		   }
void m_stat() {statflag=1-statflag;}
void m_statreset() {verteilung_reset_all();}

void setmenus()
{
 setmenu(3,"File","Control","Diverses");
 setmenu(3,"Statistik","Start","Anzahl Atome",m_stat,menu_start,menu_anzatome);
 setmenu(3,"Quit", "Stop",   "AtomRadius",menu_exit,menu_stop,menu_atomradi);
 setmenu(3, NULL, "Zeitlupe  ->","Geschwindigkeit", NULL,NULL,menu_geschw);
 setsubmenu(2,NULL,menu_text0,NULL,zeitlupe_0);
 setsubmenu(2,NULL,menu_text1,NULL,zeitlupe_1);
 setsubmenu(2,NULL,menu_text5,NULL,zeitlupe_5);
 setsubmenu(2,NULL,menu_text25,NULL,zeitlupe_25);
 setmenu(3,NULL,menu_textspar,"Statistik reset",NULL,menu_spar,m_statreset);
 setmenu(2,NULL,menu_textkolli,NULL,menu_kolli);
 setmenu(2,NULL,"Refresh",NULL,menu_refresh);
}

void atome_initialisieren()
{
 int i;
 Atom *at;
 vektor rv(atomradius+1.,atomradius+1.);
 vektor vmax(vmaxbetrag/1.414,vmaxbetrag/1.414);
 vektor h1(waende[0].p1+rv), h2(waende[1].p2-rv);
 verteilung_reset();
#ifdef TEST
 vektor p0(XMAX/2-60,YMAX/2), v0(100,0), p1(60,60), v1(10,10);
 atome[0].init(p0,verteilung_testen(v0));
 atome[1].init(p1,verteilung_testen(v1));
 for(i=2,at= &atome[i];i<natome;i++,at++)
	at->init(zufallspunkt(h1,h2),
		 verteilung_testen(zufallsgeschwindigkeit(-vmax,vmax)));
#else
 for(i=0,at=atome;i<natome;i++,at++)
	at->init(zufallspunkt(h1,h2),
		 verteilung_testen(zufallsgeschwindigkeit(-vmax,vmax)));
#ifdef DIFFUSION
 vektor h3(waende[1].p1+rv), h4(waende[2].p2-rv);
 for(i=0,at=atome2;i<natome;i++,at++)
	at->init(zufallspunkt(h3,h4),
		 verteilung_testen(zufallsgeschwindigkeit(-vmax,vmax)));
#endif
#endif
}

int main(int argc,char *argv[])
{
 Atom *at,*at2;
 int i,j;
// long tim=0;
// double dt=0.025,t=0.;//provi.
 double dt=0.01;
 //tek_setdebug(1);//test
#ifndef MAC
 if(argc>1)
	{printf("GasExp.cc %s  (ohne Parameter aufrufen)\n",VERSION);
	 tek_setdebug(1);
	}
#endif
 fenster=new Fenster[1];
 waende=new Wand[nwaende];
 waende[0].init(2.,2.,2.,YMAX-2.); //linke Wand
 waende[1].init(XMAX/2.,2.,XMAX/2.,YMAX-2.); //mittlere Wand zu
 waende[2].init(XMAX-2.,2.,XMAX-2.,YMAX-2.); //rechte Wand
 waende[3].init(2.,YMAX-2.,XMAX-2.,YMAX-2.); //Decke
 waende[4].init(2.,2.,XMAX-2.,2.); //Boden
 if(nwaende>=7)
   {waende[5].init(XMAX/2.,YMAX-YMAX/3.,XMAX/2.,YMAX-2.); //mittlere Wand oberer Teil
    waende[6].init(XMAX/2.,2.,XMAX/2.,YMAX/3.); //mittlere Wand unterer Teil
    if(nwaende>7) //provi. Hilfswaende
     {waende[7].init(XMAX/2.-1,YMAX-YMAX/3.,XMAX/2.+1,YMAX-YMAX/3.);
      waende[8].init(XMAX/2.-1,YMAX/3.,XMAX/2.+1,YMAX/3.);
   } }
 waende_zeichnen();
 atome=new Atom[natome];
#ifdef DIFFUSION
 atome2=new Atom[natome];
#endif
 atome_initialisieren();
 atome_zeichnen();
 int jd=0;
 while(exitflag==0 && waitmenu(waitflag)==0)
	{//waitTOF();//test
	 ++jd;
	 verteilung_reset();
	 for(i=0,at=atome;i<natome;i++,at++)
	 	{at->neuposv(dt);
	 	 if(statflag) verteilung_testen(at->v,at->ix);
	 	}
#ifdef DIFFUSION
	 for(i=0,at=atome2;i<natome;i++,at++)
	 	{at->neuposv(dt);
	 	 if(statflag) verteilung_testen(at->v,at->ix);
	 	}
#endif
	 //if(jd%5==0) //test
	  {//if(statflag) verteilung_berechnen(); //so koennte man noch kritische Zeit sparen
	   maus.zustand=imausposition(&maus.x,&maus.y);
	   waitBOF(); //damit warten wir bis das Bild fertig aufgebaut ist
	   myscreenclear(); //Loeschen und Neuzeichnen muss dann in der Austastluecke passieren
	   waende_zeichnen();
	   atome_zeichnen();
	  }
	 if(statflag) verteilung_zeichnen();
	 //hier sollten alle Zeichnen-Befehle abgeschlossen sein
	 // und der Rasterstrahl das Bild noch nicht erreicht haben.
	 if(kolliflag)
#ifdef DIFFUSION
	   {for(i=1,at=atome;i<natome*2;i++,at++)
	     {if(i==natome) at=atome2;
	      for(j=i,at2=at;j<natome*2;j++)
		{if(j==natome-1) at2=atome2; else ++at2;
		 if(check_collision(at,at2)) do_collision(at,at2,dt);
	     }  }
	    //for(i=0,at=atome;i<natome;i++,at++)  at->riwexel >>= 1;
	    //for(i=0,at=atome2;i<natome;i++,at++)  at->riwexel >>= 1;
	   }
#else
	   {for(i=1,at=atome;i<natome;i++,at++)
	     for(j=i,at2=at;j<natome;j++)
		if(check_collision(at,++at2)) do_collision(at,at2,dt);
	    //for(i=0,at=atome;i<natome;i++,at++)  at->riwexel >>= 1;
	   }
#endif
	 atome_sortieren(); //hier ist genug Zeit um Liste fuers Zeichnen zu optimieren
	 if(zeitlupe) for(i=0;i<zeitlupe;i++) waitBOF();
#ifdef GANZOFFEN
	 if(maus.zustand!=0 && offen!=1) wand_loeschen(offen=1);
#else
	 if((t+=dt)>2.0) wand_loeschen(offen=1);//provi.
#endif
	}
 delete[] fenster;
 return 0;
}/* ende von main */

/*************************** Diverses ************************************/
/*
double zufall(double y)  // liefert Zufallszahl zwischen 0.0 und 1.0
{
 static double x=1.3757;
 if(y!=0.) x=y;
 x=(100.+x)/(100.*(x-(long)(x))+0.7);
 y=10.*x;
 return (y-(long)(y));
}
*/
double zufall(double y)  // liefert Zufallszahl zwischen 0.0 und 1.0
{			 // diese Variante ist bisher bester Zufallsgenerator
 static double x=581;
 if(y!=0.) x=y;
 if(x==0.) x=581;
 x/=1.163;
 x-=(long)(x);
 y=10.*x;
 x*=1000.;
 return (y-(long)(y));
}

vektor zufallspunkt(vektor p1,vektor p2)
{
 vektor z;
 z.x=p1.x+(p2.x-p1.x)*zufall();
 z.y=p1.y+(p2.y-p1.y)*zufall();
 return z;
}

vektor zufallsgeschwindigkeit(vektor p1,vektor p2)
{
 vektor z;
 z.x=p1.x+(p2.x-p1.x)*zufall();
 z.y=p1.y+(p2.y-p1.y)*zufall();
 return z;
}

#define k20 24
#define k21 25

class Verteilung
{
 int i,jv;
 int n2; //fuer Durchschnittsberechnung
 double feld2[k21]; //fuer Durchschnittswerte
public:
 int nlinks,nrechts; //Anzahl Atome im linken und rechten Teil
 int feld[k21];
 void reset_all() {for(i=0;i<k21;i++) {feld[i]=0; feld2[i]=0;} n2=0; nlinks=nrechts=0;jv=0;}
 Verteilung() {reset_all();}
 void reset() {for(i=0;i<k21;i++) feld[i]=0; nlinks=nrechts=0;}
 void neuerdurchschnitt();
 double getfeld2(int j) {return (n2==0)?0.0:feld2[j]/n2;}
#ifdef MITKURVE
 void kurve_zeichnen();
#endif
};
static Verteilung vert;

void Verteilung::neuerdurchschnitt()
{
 for(i=0;i<k21;i++)
 	feld2[i] += feld[i];
 n2++;
}

/** langsame Variante
void Verteilung::kurve_zeichnen()//provi.
{
 //const int nn=20,nmax=20;//provi.
 const int nn=400,nmax=1;
 //const double f5=YMAX/2.; //f5=YMAX/(double)nmax;
 const double f6=YMAX/2./(double)nmax;
 static double xa[nn],ya[nn],dx;//provi.
 static int n=0;
 char str[80];
 ++n;
 if(offen>0)
 {if(jv<nn)
  {if(jv==0) {xa[jv]=XMAX/2.; ya[jv]=0; dx=(XMAX-xa[0])/nn;}
   else {ya[jv] += f6*nrechts/divisor(nlinks);}
   if(n==nmax)
     {//ya[jv] = f5*nrechts/divisor(nlinks);
      if(++jv<nn) {ya[jv]=0.; xa[jv]=xa[0]+dx*jv;}
     }
  }
  if(n==nmax)
  {color(4);
   plot(xa[0],ya[0],PENUP);
   for(i=1;i<jv;i++)
	plot(xa[i],ya[i],PENDOWN);
   double x1=XMAX*0.85,y1=YMAX/40.,x2=XMAX-2,y2=YMAX/10.;
   sprintf(str,"%3d %3d",nlinks,nrechts);
   color(0); fillbox(x1,y1,x2,y2);
   color(4); schrift(x1,y1,str);
   n=0;
  }
 } else
  if(n==nmax)
  {double x1=XMAX*0.85,y1=YMAX/40.,x2=XMAX-2,y2=YMAX/10.;
   sprintf(str,"%3d %3d",nlinks,nrechts);
   color(0); fillbox(x1,y1,x2,y2);
   color(4); schrift(x1,y1,str);
   n=0;
  } 
}
**/

#ifdef MITKURVE
/*
void Verteilung::kurve_loeschen()//provi.
{
}
void Verteilung::kurve_berechnen()//provi.
{
}
*/
void Verteilung::kurve_zeichnen()//provi.
{
 const int nn=400;
 const double f6=YMAX/2.;
 static double xa[nn],ya[nn],dx;//provi.
 char str[80];
 if(offen>0)
  {if(jv<nn)
   {if(jv==0) {xa[jv]=XMAX/2.; ya[jv]=0; dx=(XMAX-xa[0])/nn;}
    else {ya[jv] += f6*nrechts/divisor(nlinks);}
    if(++jv<nn) {ya[jv]=0.; xa[jv]=xa[0]+dx*jv;}
   }
   color(4);
   plot(xa[0],ya[0],PENUP);
   for(i=1;i<jv;i++)
	plot(xa[i],ya[i],PENDOWN);
   double x1=XMAX*0.85,y1=YMAX/40.; //double x2=XMAX-2,y2=YMAX/10.;
   sprintf(str,"%3d %3d",nlinks,nrechts);
   color(4); schrift(x1,y1,str);
  }
 else
  {double x1=XMAX*0.85,y1=YMAX/40.; //double x2=XMAX-2,y2=YMAX/10.;
   sprintf(str,"%3d %3d",nlinks,nrechts);
   color(4); schrift(x1,y1,str);
  } 
}
#endif

void verteilung_reset() {vert.reset();}
void verteilung_reset_all() {vert.reset_all();}

vektor verteilung_testen(vektor z)
{
 double x,dx,b;
 int i;
 b=sqrt(z.x*z.x+z.y*z.y);
 for(i=0,dx=vmaxbetrag2/k20,x=0;(x+=dx)<vmaxbetrag2;i++)
   if(b<x) break;
 vert.feld[i]++;
 return z;
}
void verteilung_testen(vektor z,int ix) //provi.
{
 if(ix>(XMAX/2)) vert.nrechts++; else vert.nlinks++;
 verteilung_testen(z);
}

void verteilung_zeichnen()
{
 const double f=10;
 int i;
 color(2);
/*
 for(int i=0;i<k20;i++)
   {drawbox(f*i, 0.0, f*i+10.0, 2*f*vert.feld[i]);
    altesfeld[i]=vert.feld[i];
   }
*/
 vert.neuerdurchschnitt();
 for(i=0;i<k20;i++)
   {drawbox(f*i, 0.0, f*i+10.0, 2*f*vert.getfeld2(i));
    altesfeld[i]=vert.getfeld2(i);
   }
#ifdef MITKURVE
 vert.kurve_zeichnen();
#endif
}

void verteilung_loeschen()
{
 const double f=10;
 color(0);
 for(int i=0;i<k20;i++)
   drawbox(f*i, 0.0, f*i+10.0, 2*f*altesfeld[i]);
}

/*************************** Kollisionen *********************************/
void schieben(vektor p1,vektor *p2,vektor *p3,vektor *p4)
{
 *p2 -= p1;
 *p3 -= p1;
 *p4 -= p1;
}

void drehen(double sina,double cosa,double& x,double& y) //im Gegenuhrzeigersinn drehen
{
 double x1=x,y1=y;
 x=cosa*x1-sina*y1;
 y=sina*x1+cosa*y1;
}
void drehen(double alfa,vektor& p1,vektor& p2) //im Uhrzeigersinn drehen
{
 double sina=sin(-alfa),cosa=cos(-alfa);
 drehen(sina,cosa,p1.x,p1.y);
 drehen(sina,cosa,p2.x,p2.y);
}
void drehen(double alfa,vektor& p1,vektor& p2,vektor& p3,vektor& p4)
{
 double sina=sin(-alfa),cosa=cos(-alfa);
 drehen(sina,cosa,p1.x,p1.y);
 drehen(sina,cosa,p2.x,p2.y);
 drehen(sina,cosa,p3.x,p3.y);
 drehen(sina,cosa,p4.x,p4.y);
}

/** diese Variante erzeugt ungewollte Molekuele:
bool check_collision(Atom *at,Atom *at2)
{
 double x,w,alfa,atomdurchm=atomradius*2;
 vektor p1=at->pos,p2=at2->pos,p1a=at->altpos,p2a=at2->altpos;
 if(abs(p1-p2)<atomdurchm || abs(p1a-p2a)<atomdurchm) //Abstand kleiner als Atomdurchmesser ?
				return true;//ja-> Kollision erkannt
 alfa=atan2(p1a.y-p1.y,p1a.x-p1.x); //Winkel zwischen Bahn des ersten Atoms und x-Achse
 drehen(alfa,p1,p2,p1a,p2a); //drehen (im Uhrzeigersinn) und
 schieben(p1,&p1a,&p2,&p2a); //schieben so dass p1 in Koordinatenursprung zu liegen kommt
 if((p2.y>0. && p2a.y>0.) || (p2.y<0. && p2a.y<0.)) //schneidet Bahn des 2.Atoms die x-Achse ?
 				return false; //nein-> keine Kollision
 w=p2.y-p2a.y; if(w==0.) return false; //parallele Bahnen-> keine Kollision
 x=p2.y*p2a.x/w;
 return (x>=0. && x<=p1a.x); //Kollision erkannt wenn Schnittpunkt richtig liegt.
}

void do_collision(Atom *at,Atom *at2,double dt)
{
 double alfa,c,w,cosa,x,t,ddt;
 vektor p1=at->altpos,p2=at2->altpos,p1a=at->pos,p2a=at2->pos, p3,p3dt;
 vektor v1=at->altv, v2=at2->altv, v3,h1,h2;
 p3=(p1+p2)/2.0; //p3=Schwerpunkt
 p3dt=(p1+dt*v1+p2+dt*v2)/2.0;
 v3=(p3dt-p3)/dt; //v3=Geschwindigkeit des Schwerpunkts

 v1 -= v3;  v2 -= v3; //Betrachtung der Szene vom Schwerpunkt aus
 //Da der Schwerpunkt jetzt unveraendert bleibt muss  v1 == -v2  sein.
 //Cosinussatz und Aufloesen der Quadratischen Gleichung ergibt Zeitpunkt der Kollision:
 alfa=vektorwinkelv(p1-p2,v2);
 cosa=cos(alfa); c=abs(p3-p2);
 w=c*c*cosa*cosa+atomradius*atomradius;
 if(w<=0.) //{printf("da stimmt was nicht sqrt(w=%lf)\n",w); return;}//test
 	w=0.;//Absturz verhindern
 x=c*cosa+sqrt(w);
 t=x/abs(v2); //t=Zeitpunkt der Kollision
 t=dt/2.;//test
 vektor p1s=p1+t*v1, p2s=p2+t*v2; //Positionen bei der Kollision
 alfa=atan2(p2s.x-p1s.x,p1s.y-p2s.y); //Winkel zwischen Abprallebene und x-Achse
 drehen(alfa,v1,v2); //so drehen dass x-Achse gleich Abprallebene ist
 v1.y = -v1.y;  v2.y = -v2.y;
 drehen(-alfa,v1,v2); //Zurueckdrehen
 v1 += v3; v2 += v3; //Ende der Betrachtung vom Schwerpunkt aus.
 
// if(t>dt || t<0.) {printf("da stimmt was nicht t=%lf dt=%lf\n",t,dt); return;}//test
 at->altposv(); at2->altposv();
 at->neuposv(t); at2->neuposv(t); //Bewegung bis zur Kollision mit alten Geschwindigkeiten
 at->v=v1; at2->v=v2; //neue Geschwindigkeiten
 at->neuposv(dt-t); at2->neuposv(dt-t); //restliche Bewegung mit neuen Geschwindigkeiten
}
** :diese Variante erzeugt ungewollte Molekuele **/

bool check_collision(Atom *at,Atom *at2)
{
#ifdef KEINESTOESSE
 return false;
#else
 double x,alfa,h;
 vektor p1=at->pos,p2=at2->pos,p1a=at->altpos,p2a=at2->altpos;
 if((h=abs(p1-p2))<atomdurchm) //Abstand kleiner als Atomdurchmesser ?
    return (h<abs(p1a-p2a));   //Kollision erkannt wenn kleiner als vorheriger Abstand
 alfa=atan2(p1a.y-p1.y,p1a.x-p1.x); //Winkel zwischen Bahn des ersten Atoms und x-Achse
 drehen(alfa,p1,p2,p1a,p2a); //drehen (im Uhrzeigersinn) und
 schieben(p1,&p1a,&p2,&p2a); //schieben so dass p1 in Koordinatenursprung zu liegen kommt
 p2a -= p1a;	//Betrachtungspunkt auf erstes Atom setzen
		//p1a entspricht der Geschw. vom 1.Atom,
		//somit ist p2a jetzt die Geschw. des 2.Atoms bezueglich des 1.
 alfa=atan2(p2.y-p2a.y,p2.x-p2a.x); //so weit im Uhrzeigersinn drehen dass
 drehen(alfa,p2,p2a); //das 2. Atom parallel zur x-Achse laeuft.
 if(p2.y>=atomdurchm || p2.y<=-atomdurchm) return false; //keine Kollision wenn Bahn weiter weg
 x=sqrt(atomdurchm*atomdurchm-p2.y*p2.y);
 if(p2a.x>=x) return p2.x<x; //Kollision erkannt wenn die Strecke von p2.x nach p2a.x
 if(p2a.x<=-x) return p2.x>-x; //entweder x oder -x schneidet.
 return false; //keine Kollision wenn vorher schon innerhalb eines Atomdurchmessers war.
#endif
}

void do_collision(Atom *at,Atom *at2,double dt)
{
 double alfa,c,w,cosa,x,t;
 vektor p1=at->altpos,p2=at2->altpos, p3,p3dt;
 //vektor p1a=at->pos,p2a=at2->pos;
 vektor v1=at->altv, v2=at2->altv, v3,h1,h2;
 p3=(p1+p2)/2.0; //p3=Schwerpunkt
 p3dt=(p1+dt*v1+p2+dt*v2)/2.0;
 v3=(p3dt-p3)/dt; //v3=Geschwindigkeit des Schwerpunkts

 v1 -= v3;  v2 -= v3; //Betrachtung der Szene vom Schwerpunkt aus
 //Da der Schwerpunkt jetzt unveraendert bleibt muss  v1 == -v2  sein.
 //Cosinussatz und Aufloesen der Quadratischen Gleichung ergibt Zeitpunkt der Kollision:
 alfa=vektorwinkelv(p1-p2,v2);
 cosa=cos(alfa); c=abs(p3-p2);
 w=c*c*cosa*cosa+atomradiusquad;
 if(w<=0.)
   {//testprintf("da stimmt was nicht sqrt(w=%lf)\n",w);//test
    return;//Absturz verhindern
   }
 x=c*cosa+sqrt(w);
 t=x/abs(v2); //t=Zeitpunkt der Kollision
 if(t>dt || t<0.) t=dt/2.;//test
 vektor p1s=p1+t*v1, p2s=p2+t*v2; //Positionen bei der Kollision
 alfa=atan2(p2s.x-p1s.x,p1s.y-p2s.y); //Winkel zwischen Abprallebene und x-Achse
 drehen(alfa,v1,v2); //so drehen dass x-Achse gleich Abprallebene ist
 v1.y = -v1.y;  v2.y = -v2.y;
 drehen(-alfa,v1,v2); //Zurueckdrehen
 v1 += v3; v2 += v3; //Ende der Betrachtung vom Schwerpunkt aus.
 
// if(t>dt || t<0.) {testprintf("da stimmt was nicht t=%lf dt=%lf\n",t,dt); return;}//test
 at->altposv(); at2->altposv();
 at->neuposv(t); at2->neuposv(t); //Bewegung bis zur Kollision mit alten Geschwindigkeiten
 at->v=v1; at2->v=v2; //neue Geschwindigkeiten
 at->neuposv(dt-t); at2->neuposv(dt-t); //restliche Bewegung mit neuen Geschwindigkeiten
//Test ob Abstand ok:
/* static double minabst=2*atomradius;
 x=abs(at->pos-at2->pos);
 if(x<minabst) {testprintf("Atome sind zu nah: x=%lf\n",x); minabst=x;}
*/
}

//double sq(double x) {return x*x;}
bool istzwischen(double x,double x1,double x2)
{
 if(x1<x2) return (x1<=x && x<=x2);
 return (x2<=x && x<=x1);
}

bool kantenstoss(vektor p1,vektor p2,vektor wp,double r,vektor& p2s,vektor& v2)
{
//provisorische Variante um restliches Progi zu testen.
 v2= -v2; p2s= p1;
 return true;
}
/*
bool kantenstoss(vektor p1,vektor p2,vektor wp,double r,vektor& p2s,vektor& v2)
{
// Berechnet neue Position und Geschwindigkeit (p2s und v2) nach Stoss
// am Eckpunkte wp. p1 oder p2 sind Start- und End-Position des Atoms wenn
// kein Stoss stattfindet. r ist der Atomradius.
// Der Rueckgabwert ist true wenn ein Stoss stattfindet.
 double a,a2,wu,A,B,C,xa,xb,xs,ys,sp2;
 double wig,alfa,gamma;
 const double grad180=180*GRAD;
 p1-=wp; p2-=wp; //Koordinatensystem auf wp setzen
 double x1=p1.x, y1=p1.y;
 if(p2.x==x1) //Spezialfall: Atom fliegt senkrecht
  {wu=r*r-x1*x1;
   TESTprintf("Spezialfall erkannt\n");//test
   if(wu<0.0) return false; //kein Zusammenstoss
   xs=x1;
   if(p2.y<=y1)
	ys=sqrt(wu); //Atom kommt von oben
   else ys= -sqrt(wu);//Atom kommt von unten
  }
 else
  {a=(p2.y-y1)/(p2.x-x1); a2=a*a;
   A=a2+1; B=a*y1-a2*x1; C=y1*y1-2*a*x1*y1+a2*x1*x1-r*r;
   wu=B*B-A*C;
   if(wu<0.0) return false; //kein Zusammenstoss
   TESTprintf("\nkantenstoss()\n p1=[%.2lf %.2lf] p2=[%.2lf %.2lf] wp=[%.2lf %.2lf],r=%.1lf\n",
	  p1.x,p1.y, p2.x,p2.y, wp.x,wp.y, r);//test
   TESTprintf("steigung: a=%lf\n",a);//test
   wu=sqrt(wu);
   xa=(wu-B)/A; xb=(-wu-B)/A;
   TESTprintf("Loesungen von Quad.Gl: %lf %lf\n",xa,xb);//test
   if(p2.x>=p1.x) //Atom bewegt sich von links nach rechts
    {if(istzwischen(xb,p1.x,p2.x)) xs=xb; //kleinerer Wert zuerst pruefen
     else if(istzwischen(xa,p1.x,p2.x)) xs=xa;
     else return false; //Kreis wird noch nicht geschnitten
    }
   else //Atom bewegt sich von rechts nach links
    {if(istzwischen(xa,p1.x,p2.x)) xs=xa; //groesserer Wert zuerst pruefen
     else if(istzwischen(xb,p1.x,p2.x)) xs=xb;
     else return false; //Kreis wird noch nicht geschnitten
    }
   ys=y1+(xs-x1)*a; //(xs ys) ist erster Schnittpunkt
  }
 TESTprintf("erster Schnittpunkt: [%lf %lf]\n",xs,ys);//test
 wig=atan2(ys,xs);
 alfa=atan2(p2.y-p1.y,p2.x-x1);
 gamma=2*wig-alfa-grad180;
 TESTprintf("wig=%.1lf alfa=%.1lf gamma=%.1lf\n",
	wig/GRAD,alfa/GRAD,gamma/GRAD);//test
#ifdef TEST1
 {vektor s(xs,ys),p; //test
  double a=gamma-alfa;
  p=p2-s;
  drehen(sin(a),cos(a),p.x,p.y);
  p+=s;
  TESTprintf("neues p2 mit drehen() berechnet: [%lf %lf]\n",p.x,p.y);
 }
#endif
 sp2=sqrt(sq(p2.x-xs)+sq(p2.y-ys));
 p2.x=xs+cos(gamma)*sp2;
 p2.y=ys+sin(gamma)*sp2;
 TESTprintf("neues p2: [%lf %lf]\n",p2.x,p2.y);//test
 p2s=p2+wp; //Rueckgabe wieder in urspruenglichem Koordinatensystem
 TESTprintf("altes v2: [%lf %lf] |v2|=%lf\n",v2.x,v2.y,abs(v2));//test
 gamma-=alfa;
 drehen(sin(gamma),cos(gamma),v2.x,v2.y);
 TESTprintf("neues v2: [%lf %lf] |v2|=%lf\n",v2.x,v2.y,abs(v2));//test
 return true;
}
*/
