/* GasSimul.cc		Simulation eines Gases   letzte Aenderung: 16.11.2016 */
#define VERSION "Version 1.05"
/*
Uebersetzen auf AMIGA:
;>c++ GasSimul.cc h:tekplot.o h:amigalib.a -o GasSimul
Uebersetzen auf ALPHA oder VAX:
;VAX> gx2new GasSimul
;VAX> blink GasSimul,[PFISTER.OBJ]xtekplot,xmenu
;ALPHA> cx GasSimul
;ALPHA> blink GasSimul,[PFISTER.obj]xtekplot1
;ALPHA> pur gassimul.exe

History
8.2.95  V0.1     Erstellung (RPF)
24.2.95	V1.0     mit Kollisionen
8.11.2016 V1.04  Verbessertes check_collision() von gasexp.cc uebernommen
16.11.    V1.05  Statistik von gasexp.cc auch hier eingebaut.
                 damit wird die mittlere Geschwindigkeitsverteilung dargestellt

*/

//#define KEINESTOESSE /* Test: keine Stoesse zwischen Atomen */

#define ALPHA
//#define VAX
//#define MAC
//#define AMIGA

#ifdef VAX
#define XWINDOWS 11
#endif
#ifdef ALPHA
#define XWINDOWS 11
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#ifdef MAC
#include "tekplot.h"
#endif
#ifdef AMIGA
#include "h:tekplot.h"
#endif
#ifdef XWINDOWS
#include <xtekplot1.h>
#endif

#define XMAX 640
#define YMAX 512
#define TIEFE 4	/* 16 Farben reichen */

static double Radius=7.0; /* Radius der Atome */
static int iradius;	  /* Radius in Pixel  */
#define atomradius Radius

/************************ Testfunktionen *********************************/
/*void testhalt()
{
 printf("weiter mit RETURN"); getc(stdin); getc(stdin);//test
// inital_new(0.,0.,XMAX,YMAX);//test
// janeinrequester("Testhalt","ok",NULL);
}*/

/********************* Klassendeklarationen ******************************/
#include "vektorklasse.cc"

struct ivektor2 {int x1,y1,x2,y2;};

/*
class Atom
{
public:
 vektor pos,v,altpos;
 int	ix,iy,		//aktuelle Position in Pixelkoordinaten
	riwexel;	//Richtungswechsel
// double radius;
 void init(vektor neupos,vektor neuv);
 void zeichnen() {ifillcircle(ix,iy,iradius,iradius);}
// void loeschen() {fillcircle(altpos.x,altpos.y,radius,radius);}
 void neuposv();
};
*/

// neu aus gasexp.cc:
class Atom
{
public:
 int	ix,iy;		//aktuelle Position in Pixelkoordinaten
 int altix,altiy;//provi.
 vektor pos,v,altpos,altv;
 //int	riwexel;	//Richtungswechsel
 Atom() {/*riwexel=0;*/}
 ~Atom() {}
 void init(vektor neupos,vektor neuv);
 void zeichnen() {ifillcircle(altix=ix,altiy=iy,atomradius,atomradius);}
 void loeschen() {ifillcircle(altix,altiy,atomradius,atomradius);}//provi.
 void neuposv();
 void neuposv(double dt);
 void altposv() {pos=altpos; v=altv;}
};

class skolben
{
 int	xf[20],yf[20],	//Hilfsfelder fuer iline() beim Stempelzeichnen
	gezeichnet,	//gesetzt wenn schon mal gezeichnet
	dhalb,		//halbe Dicke des Stempels
	imitte;		//y-Mitte in Pixelkoordinaten
 short	box1flag,box2flag,  //Flags um Aktivierung der Schalter zu starten
	box1aktiv,box2aktiv;//Aktivierungsflags der Schalter
 ivektor2 box1,box2;	//Positionen der Schalter in Pixelkoordinaten
public:
 int	ix1,iy1,ix2,iy2;//Maximaler Atombereich in Pixelkoordinaten
 vektor p1,p2; //Bereich des Gases
 double sposx; //Stempelposition
 int	isposx;//Stempelposition in Pixelkoordinaten
 double svx,zweisvx;//Stempelgeschwindigkeit
 double smin,  //minimale Stempelposition
	smax;  //maximale Stempelposition
 void init(double x1,double y1,double x2,double y2,double xra);
 void setminmax();
 void zeichnen(int);
 void schaltboxen_zeichnen(int farbe);
 void stempelzeichnen(int);
 void neuposv();
};

/************************ Vordeklarationen *******************************/
void allocatome();
void atome_loeschen();
//void kollisioncheck(Atom *at,Atom *at2);
bool check_collision(Atom *at,Atom *at2);
void do_collision(Atom *at,Atom *at2,double dt);
double zufall(double y=0.);
vektor zufallspunkt(vektor p1,vektor p2);

/************************ Minifunktionen *********************************/
inline int innerhalb(int ix,int iy,int x1,int y1,int x2,int y2)
{
 return (ix>x1 && iy>y1 && ix<x2 && iy<y2);
}

inline long idfix(double x) {return x<0.?(long)(x-0.5):(long)(x+0.5);}

/*********************** Globale Variablen *******************************/
static double
	minposx,minposy,maxposx,maxposy, //Bereich fuer Atome
	zweimal_maxposx,zweimal_maxposy,
	zweimal_minposx,zweimal_minposy,
	dt,		 //Zeit eines Bildwechsels
	vmaxbetrag=YMAX; //Maximale Geschwindigkeit beim Atome Initialisieren
static int natome=40;
static Atom *atome=NULL;
struct _maus {int zustand,x,y;} maus;
static short exitflag=0,waitflag=0,sparflag=0,kolliflag=1,statflag=1;
static int zeitlupe=0;
static int weiss=1,rot=2,gruen=3;
static double atomdurchm=atomradius+atomradius,atomradiusquad=atomradius*atomradius;
void set_atomradius(int r) {atomradius=r; atomdurchm=r+r; atomradiusquad=r*r;}

/***************** Verteilung aus gasexp.cc uebernommen ******************/
#define k20 24
#define k21 25
double altesfeld[26];

class Verteilung
{
 int i,jv;
 int n2; //fuer Durchschnittsberechnung
 double feld2[k21]; //fuer Durchschnittswerte
public:
 int nlinks,nrechts; //Anzahl Atome im linken und rechten Teil
 int feld[k21];
 void reset_all() {for(i=0;i<k21;i++) {feld[i]=0; feld2[i]=0;} n2=0; nlinks=nrechts=0;jv=0;}
 Verteilung() {reset_all();}
 void reset() {for(i=0;i<k21;i++) feld[i]=0; nlinks=nrechts=0;}
 void neuerdurchschnitt();
 double getfeld2(int j) {return (n2==0)?0.0:feld2[j]/n2;}
#ifdef MITKURVE
 void kurve_zeichnen();
#endif
};
static Verteilung vert;

void Verteilung::neuerdurchschnitt()
{
 for(i=0;i<k21;i++)
 	feld2[i] += feld[i];
 n2++;
}

void verteilung_reset() {vert.reset();}
void verteilung_reset_all() {vert.reset_all();}

vektor verteilung_testen(vektor z)
{
 double vmaxbetrag2=1.5*vmaxbetrag;
 double x,dx,b;
 int i;
 b=sqrt(z.x*z.x+z.y*z.y);
 for(i=0,dx=vmaxbetrag2/k20,x=0;(x+=dx)<vmaxbetrag2;i++)
   if(b<x) break;
 vert.feld[i]++;
 return z;
}
void verteilung_testen(vektor z,int ix) //provi.
{
 if(ix>(XMAX/2)) vert.nrechts++; else vert.nlinks++;
 verteilung_testen(z);
}

void verteilung_zeichnen()
{
 const double f=10;
 int i;
 double x0=11.0,y0=21.0;// 0.0, 0.0 in gasexp.cc
 color(2);
/*
 for(int i=0;i<k20;i++)
   {drawbox(f*i, 0.0, f*i+10.0, 2*f*vert.feld[i]);
    altesfeld[i]=vert.feld[i];
   }
*/
 vert.neuerdurchschnitt();
 for(i=0;i<k20;i++)
   {drawbox(x0+f*i, y0, x0+f*i+10.0, y0+2*f*vert.getfeld2(i));
    altesfeld[i]=vert.getfeld2(i);
   }
#ifdef MITKURVE
 vert.kurve_zeichnen();
#endif
}

void verteilung_loeschen()
{
 const double f=10;
 double x0=11.0,y0=21.0;// 0.0, 0.0 in gasexp.cc
 color(0);
 for(int i=0;i<k20;i++)
   drawbox(x0+f*i, y0, x0+f*i+10.0, y0+2*f*altesfeld[i]);
}

/**************************** Klassen ************************************/
void skolben::init(double x1,double y1,double x2,double y2,double xra)
{
 double mitte=(y1+y2)/2.;
 p1.x=x1; p1.y=y1; p2.x=x2; p2.y=y2;
 sposx=x2; smax=XMAX-xra; smin=x1+xra;
 isposx=int(sposx+0.5);
 box1flag=box2flag=box1aktiv=box2aktiv=0;
/*
 printf("x1=%lf y1=%lf  smax=%lf y2=%lf\n",x1,y1,smax,y2);//test
 koorduser2pix(0.,0.,&ix1,&iy1);//test
 koorduser2pix(double(XMAX),double(YMAX),&ix2,&iy2);//test
 printf("Zeichenbarer Bereich: %d %d  %d %d\n",ix1,iy1,ix2,iy2);//test
*/
 koorduser2pix(x1,y1,&ix1,&iy1); ix1++; iy1--;
 koorduser2pix(smax,y2,&ix2,&iy2); ix2--; iy2++;
 imitte=(iy1+iy2+1)/2;
// printf("ix1=%d iy1=%d  ix2=%d iy2=%d  imitte=%d\n",
//	ix1,iy1,ix2,iy2,imitte);//test
 setminmax();
 dt=1./60.;	//provi. im NTSC-Modus
 dhalb=6;	//halbe Dicke des Stempels
 koorduser2pix(XMAX-xra,mitte-dhalb,&box1.x1,&box1.y1);
 koorduser2pix(XMAX-xra/2.-1.,mitte+dhalb,&box1.x2,&box1.y2);
 koorduser2pix(XMAX-xra/2.,mitte-dhalb,&box2.x1,&box2.y1);
 koorduser2pix(XMAX-1.,mitte+dhalb,&box2.x2,&box2.y2);
}
void skolben::setminmax()
{
 int h;
 zweisvx=svx=0.; gezeichnet=0;
 minposx=p1.x+Radius+1; minposy=p1.y+Radius+1;
 maxposx=p2.x-Radius-1; maxposy=p2.y-Radius-1;
 zweimal_maxposx=2*maxposx; zweimal_maxposy=2*maxposy;
 zweimal_minposx=2*minposx; zweimal_minposy=2*minposy;
 deltakoorduser2pix(Radius,0.,&iradius,&h);
}
void skolben::zeichnen(int farbe)
{
 color(farbe);
 plot(smax,p1.y,UP); plot(p1.x,p1.y,DOWN);
 plot(p1.x,p2.y,DOWN); plot(smax,p2.y,DOWN);
}
void aktivatebox(ivektor2 *box,int flag,int farbnr)
{
 color(flag?farbnr:0);
 idrawbox(box->x1,box->y1+1,box->x2,box->y2);
}
void skolben::schaltboxen_zeichnen(int farbe)
{
 int xf[4],yf[4];
 color(farbe);
 xf[0]=xf[3]=box1.x1+1; yf[0]=yf[3]=imitte;
 xf[1]=xf[2]=box1.x2-1; yf[1]=box1.y1; yf[2]=box1.y2;
 iline(4,xf,yf);
 xf[0]=xf[3]=box2.x2-1; yf[0]=yf[3]=imitte;
 xf[1]=xf[2]=box2.x1+1; yf[1]=box2.y1; yf[2]=box2.y2;
 iline(4,xf,yf);
}
void skolben::stempelzeichnen(int farbe)
{
// if(gezeichnet<5) printf("skolben::stempelzeichnen(%d)\n",farbe);//test
 if(gezeichnet)
	{color(0);
	 iline(8,xf,yf);//alter Linienzug loeschen
	}
 else	schaltboxen_zeichnen(farbe);
 if(box1flag!=box1aktiv) aktivatebox(&box1,box1aktiv=box1flag,farbe);
 if(box2flag!=box2aktiv) aktivatebox(&box2,box2aktiv=box2flag,farbe);
 isposx=int(sposx+0.5);
/* Stempel zeichnen: */
 yf[0]=yf[1]=imitte+dhalb+1; yf[7]=yf[6]=imitte-dhalb-1;
 xf[0]=xf[7]=XMAX-1;	  xf[1]=xf[2]=xf[6]=xf[5]=isposx+dhalb+dhalb;
 yf[2]=yf[3]=iy1; yf[4]=yf[5]=iy2;
 xf[3]=xf[4]=isposx;
 color(farbe);
 iline(8,xf,yf);
 gezeichnet=1;
// gezeichnet++;//test
}
void skolben::neuposv()
{
 //printf("skolben::neuposv() sposx=%lf svx=%lf dt=%lf\n",sposx,svx,dt);//test
 sposx+=svx*dt;
 if(sposx>smax) {sposx=smax; zweisvx=svx=0.;}
 else if(sposx<smin) {sposx=smin; zweisvx=svx=0.;}
 maxposx=sposx-Radius-1; zweimal_maxposx=maxposx+maxposx;
 if((maus.zustand & LIMAUS)
    && innerhalb(maus.x,maus.y,box1.x1,box1.y2,box2.x2,box2.y1))
	{if(maus.x>=box2.x1) {svx+=1.; zweisvx+=2.; box2flag=1; box1flag=0;}
	 else {svx-=1.; zweisvx-=2.; box1flag=1; box2flag=0;}
	}
 else	{box1flag=box2flag=0;
	 if(svx > 1.) {svx-=1.; zweisvx-=2.;}
	 else if(svx < -1.) {svx+=1.; zweisvx+=2.;}
	 else zweisvx=svx=0.;
	}
}

skolben kolben;

void Atom::neuposv() {neuposv(dt);}

void Atom::neuposv(double dt)
{
 altpos=pos; altv=v;
 pos += v*dt;
 if(pos.x>maxposx)
//  {if(kolben.svx==0.) //einfache Formel wenn Kolben nicht in Bewegung
//	{v.x= -v.x; pos.x=zweimal_maxposx-pos.x;}
//   else // bewegter Kolben
	{pos.x=zweimal_maxposx-altpos.x+(kolben.zweisvx-v.x)*dt;
	 v.x=kolben.zweisvx-v.x;
	}
//  }
 else if(pos.x<minposx) {v.x= -v.x; pos.x=zweimal_minposx-pos.x;}
 if(pos.y>maxposy) {v.y= -v.y; pos.y=zweimal_maxposy-pos.y;}
 else if(pos.y<minposy) {v.y= -v.y; pos.y=zweimal_minposy-pos.y;}
 koorduser2pix(pos.x,pos.y,&ix,&iy);
}

void Atom::init(vektor neupos,vektor neuv)
{
 pos=altpos=neupos;
 v=neuv;
 //riwexel=0;
// radius=Radius;
 koorduser2pix(pos.x,pos.y,&ix,&iy);
 zeichnen();
}

/***************************** Hauptprogramm **************************/
char	menu_text0[]="%R 0",
	menu_text1[]="%r 1",
	menu_text5[]="%r 5",
	menu_text25[]="%r 25",
	menu_textspar[]="%q Spardarstellung ",
	menu_textkolli[]="%Q Kollisionen";
long zeitl_ids[4];
void menuflip(long id,short *flag,int c1,int c0,char *text)
{
 text[1]=(*flag ^= 1)?c1:c0;
 changemenu(id,text);
}
void zeitlmarke(long id,char *text)
{
 if(zeitl_ids[0]==0) getmenuids(id,zeitl_ids);
 menu_text0[1]=menu_text1[1]=menu_text5[1]=menu_text25[1]='r';
 text[1]='R';
 changemenu(zeitl_ids[0],menu_text0);
 changemenu(zeitl_ids[1],menu_text1);
 changemenu(zeitl_ids[2],menu_text5);
 changemenu(zeitl_ids[3],menu_text25);
}

void menu_exit() {exitflag=1;}
void menu_start() {waitflag=0;}
void menu_stop() {waitflag=1;}
void zeitlupe_0(long id) {zeitlupe=0; zeitlmarke(id,menu_text0);}
void zeitlupe_1(long id) {zeitlupe=1; zeitlmarke(id,menu_text1);}
void zeitlupe_5(long id) {zeitlupe=5; zeitlmarke(id,menu_text5);}
void zeitlupe_25(long id) {zeitlupe=25; zeitlmarke(id,menu_text25);}
void menu_refresh() {screenclear(); kolben.zeichnen(weiss);
		     kolben.schaltboxen_zeichnen(rot);
		     kolben.stempelzeichnen(rot);
		    }
void menu_spar(long id) {menuflip(id,&sparflag,'Q','q',menu_textspar);}
void menu_anzatome() {printf("(%d) Anzahl Atome:",natome); scanf("%d",&natome);
		      allocatome();
		     }
void menu_atomradi(){printf("(%.2lf) Atomradius:",Radius);scanf("%lf",&Radius);
                     set_atomradius(Radius);
		     kolben.setminmax();
		    }
void menu_kolli(long id) {menuflip(id,&kolliflag,'Q','q',menu_textkolli);}
void menu_geschw() {printf("(%.2lf) Maximale Geschwindigkeit:",vmaxbetrag);
		    scanf("%lf",&vmaxbetrag); allocatome();
		   }
void m_stat() {statflag=1-statflag;}
void m_statreset() {verteilung_reset_all();}

void allocatome()
{
 int i;
 vektor rv(Radius+1,Radius+1), vmax(vmaxbetrag/1.414,vmaxbetrag/1.414);
 verteilung_reset();
 if(atome) delete[] atome;
 atome=new Atom[natome];
 color(gruen);
 if(natome<=3) //test
  for(i=0;i<natome;i++)
	{vektor p=(kolben.p1+kolben.p2)/2., v((i&1)?50.:-50.,0.);
	 if(i==0) p.x=kolben.p1.x;
	 else if(i==1) p.x=kolben.p2.x-Radius;
	 else {p.y+=Radius; p.x+=2*Radius;}
	 atome[i].init(p,v);
	}
 else
 for(i=0;i<natome;i++)
	{color(rot+i%3);//test
	 atome[i].init(zufallspunkt(kolben.p1+rv,kolben.p2-rv),
			zufallspunkt(-vmax,vmax));
	}
}

int main(int argc,char *argv[])
{
 double xmin=0.,ymin=0.,xmax=XMAX,ymax=YMAX;
 Atom *at,*at2;
 int i,j,breite,hoehe,tiefe,visklasse;
 long tim=0;
 //tek_setdebug(1);//test
#ifndef MAC
 if(argc>1)
	{printf("GasSimul.cc %s  (ohne Parameter aufrufen)\n",VERSION);
	 tek_setdebug(1);
	}
#endif
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe<2) {sparflag=1; menu_textspar[1]='Q'; rot=gruen=weiss;}
 setsize(XMAX,YMAX,TIEFE);
 setmenu(3,"File",     "Control","Diverses");
 setmenu(3,"Statistik","Start",  "Anzahl Atome",m_stat,menu_start,menu_anzatome);
 setmenu(3,"Quit",     "Stop",   "AtomRadius",menu_exit,menu_stop,menu_atomradi);
 setmenu(3, NULL, "Zeitlupe  ->","Geschwindigkeit", NULL,NULL,menu_geschw);
 setsubmenu(2,NULL,menu_text0,NULL,zeitlupe_0);
 setsubmenu(2,NULL,menu_text1,NULL,zeitlupe_1);
 setsubmenu(2,NULL,menu_text5,NULL,zeitlupe_5);
 setsubmenu(2,NULL,menu_text25,NULL,zeitlupe_25);
 setmenu(3,NULL,menu_textspar,"Statistik reset", NULL,menu_spar,m_statreset);
 setmenu(2,NULL,menu_textkolli,NULL,menu_kolli);
 setmenu(2,NULL,"Refresh",NULL,menu_refresh);
 inital(xmin,ymin,xmax,ymax);
// getsize(&breite,&hoehe,&tiefe,&visklasse);
// if(tiefe<2) rot=gruen=weiss;
 kolben.init(	10.,20.,	  //p1 = links unten des Atombereichs
		XMAX/2.,YMAX-20., //p2 = rechts oben
		40.		  //rechter Rand
	    );
 kolben.zeichnen(weiss);
 kolben.stempelzeichnen(rot);
 allocatome();
 while(exitflag==0 && waitmenu(waitflag)==0)
	{waitBOF();
	 //waitTOF();//test
	 verteilung_reset();
	 if(sparflag==0 || ++tim%10==0)
	  {atome_loeschen();
	   if(statflag) verteilung_loeschen();
	   kolben.stempelzeichnen(rot);
	   color(gruen);
	   for(i=0,at=atome;i<natome;i++,at++)
	    {
	     at->zeichnen();
	     if(statflag) verteilung_testen(at->v,at->ix);
	    }
	   if(statflag) verteilung_zeichnen();
	  }
	 maus.zustand=imausposition(&maus.x,&maus.y);
	 kolben.neuposv();
	 for(i=0,at=atome;i<natome;i++,at++) at->neuposv();
	 if(kolliflag)
	   {for(i=1,at=atome;i<natome;i++,at++)
	     for(j=i,at2=at;j<natome;j++)
	        //kollisioncheck(at,++at2);
	        {if(check_collision(at,++at2)) do_collision(at,at2,dt);}
	    //for(i=0,at=atome;i<natome;i++,at++)  at->riwexel >>= 1;
	   }
	 if(zeitlupe) for(i=0;i<zeitlupe;i++) waitBOF();
	}
 term_exit();
 return 0;
}/* ende von main */

vektor zufallspunkt(vektor p1,vektor p2)
{
 vektor z;
 z.x=p1.x+(p2.x-p1.x)*zufall();
 z.y=p1.y+(p2.y-p1.y)*zufall();
 return z;
}

void atome_loeschen()
{
 color(0);
// for(i=0,at=atome;i<natome;i++,at++) at->loeschen(); //zu langsam
 ifillbox(kolben.ix1,kolben.iy1,
	  kolben.isposx,kolben.iy2);//ohne Doublebuffering auch zu langsam
}

#define testprintf if(natome<10) printf

/*************************** Kollisionen *********************************/
void schieben(vektor p1,vektor *p2,vektor *p3,vektor *p4)
{
 *p2 -= p1;
 *p3 -= p1;
 *p4 -= p1;
}

void drehen(double sina,double cosa,double& x,double& y) //im Gegenuhrzeigersinn drehen
{
 double x1=x,y1=y;
 x=cosa*x1-sina*y1;
 y=sina*x1+cosa*y1;
}
void drehen(double alfa,vektor& p1,vektor& p2) //im Uhrzeigersinn drehen
{
 double sina=sin(-alfa),cosa=cos(-alfa);
 drehen(sina,cosa,p1.x,p1.y);
 drehen(sina,cosa,p2.x,p2.y);
}
void drehen(double alfa,vektor& p1,vektor& p2,vektor& p3,vektor& p4)
{
 double sina=sin(-alfa),cosa=cos(-alfa);
 drehen(sina,cosa,p1.x,p1.y);
 drehen(sina,cosa,p2.x,p2.y);
 drehen(sina,cosa,p3.x,p3.y);
 drehen(sina,cosa,p4.x,p4.y);
}

/*
void kollisioncheck(Atom *at1,Atom *at2)
{
 if(at1->riwexel || at2->riwexel)
	{//testprintf("Richtungswechsel\n");
	 return;//Richtung wurde eben gewechselt
	}
 vektor vb=at2->v;
 vektor va = at1->v - vb,  dist = at2->pos - at1->pos;
 double s=abs(dist), zweiR=Radius+Radius;
 if(s>zweiR && abs(at2->altpos-at1->altpos)>zweiR) return;//nicht in der Nhe
 double alfa=vektorwinkelv(dist,va);
// if(abs(alfa)>=asin(zweiR/s)) return;//keine Kollision
// testprintf("Kollision erkannt, alte Geschw.: %lf %lf  %lf %lf\n",
//	at1->v.x,at1->v.y,vb.x,vb.y);//test
 vektor va2,vb2;
 double beta=s/zweiR*sin(alfa);
 if(beta>=1. || beta <= -1.) return;//doch keine Kollision
 beta=asin(beta);
 double gamma=PI-beta-beta;
// testprintf("alfa=%.1lf beta=%.1lf gamma=%.1lf\n",
//		alfa/GRAD,beta/GRAD,gamma/GRAD);//test
 vektorsplit(va,gamma,beta,&va2,&vb2);
 s=abs(va)/(abs(va2)+abs(vb2));
 at1->v=s*va2+vb;
 at2->v=s*vb2+vb;
 at1->riwexel=at2->riwexel=2;
//eigentlich mssten auch noch neue Positionen berechnet werden - aber wie ?
// testprintf("neue Geschw.: %lf %lf  %lf %lf\n",
//	at1->v.x,at1->v.y,at2->v.x,at2->v.y);//test
}
*/

bool check_collision(Atom *at,Atom *at2)
{
#ifdef KEINESTOESSE
 return false;
#else
 double x,alfa,h;
 vektor p1=at->pos,p2=at2->pos,p1a=at->altpos,p2a=at2->altpos;
 if((h=abs(p1-p2))<atomdurchm) //Abstand kleiner als Atomdurchmesser ?
    return (h<abs(p1a-p2a));   //Kollision erkannt wenn kleiner als vorheriger Abstand
 alfa=atan2(p1a.y-p1.y,p1a.x-p1.x); //Winkel zwischen Bahn des ersten Atoms und x-Achse
 drehen(alfa,p1,p2,p1a,p2a); //drehen (im Uhrzeigersinn) und
 schieben(p1,&p1a,&p2,&p2a); //schieben so dass p1 in Koordinatenursprung zu liegen kommt
 p2a -= p1a;	//Betrachtungspunkt auf erstes Atom setzen
		//p1a entspricht der Geschw. vom 1.Atom,
		//somit ist p2a jetzt die Geschw. des 2.Atoms bezueglich des 1.
 alfa=atan2(p2.y-p2a.y,p2.x-p2a.x); //so weit im Uhrzeigersinn drehen dass
 drehen(alfa,p2,p2a); //das 2. Atom parallel zur x-Achse laeuft.
 if(p2.y>=atomdurchm || p2.y<=-atomdurchm) return false; //keine Kollision wenn Bahn weiter weg
 x=sqrt(atomdurchm*atomdurchm-p2.y*p2.y);
 if(p2a.x>=x) return p2.x<x; //Kollision erkannt wenn die Strecke von p2.x nach p2a.x
 if(p2a.x<=-x) return p2.x>-x; //entweder x oder -x schneidet.
 return false; //keine Kollision wenn vorher schon innerhalb eines Atomdurchmessers war.
#endif
}

void do_collision(Atom *at,Atom *at2,double dt)
{
 double alfa,c,w,cosa,x,t;
 vektor p1=at->altpos, p2=at2->altpos, p3,p3dt;
 //vektor  p1a=at->pos, p2a=at2->pos;
 vektor v1=at->altv, v2=at2->altv, v3,h1,h2;
 p3=(p1+p2)/2.0; //p3=Schwerpunkt
 p3dt=(p1+dt*v1+p2+dt*v2)/2.0;
 v3=(p3dt-p3)/dt; //v3=Geschwindigkeit des Schwerpunkts

 v1 -= v3;  v2 -= v3; //Betrachtung der Szene vom Schwerpunkt aus
 //Da der Schwerpunkt jetzt unveraendert bleibt muss  v1 == -v2  sein.
 //Cosinussatz und Aufloesen der Quadratischen Gleichung ergibt Zeitpunkt der Kollision:
 alfa=vektorwinkelv(p1-p2,v2);
 cosa=cos(alfa); c=abs(p3-p2);
 w=c*c*cosa*cosa+atomradiusquad;
 if(w<=0.)
   {testprintf("da stimmt was nicht sqrt(w=%lf)\n",w);//test
    return;//Absturz verhindern
   }
 x=c*cosa+sqrt(w);
 t=x/abs(v2); //t=Zeitpunkt der Kollision
 if(t>dt || t<0.) t=dt/2.;//test
 vektor p1s=p1+t*v1, p2s=p2+t*v2; //Positionen bei der Kollision
 alfa=atan2(p2s.x-p1s.x,p1s.y-p2s.y); //Winkel zwischen Abprallebene und x-Achse
 drehen(alfa,v1,v2); //so drehen dass x-Achse gleich Abprallebene ist
 v1.y = -v1.y;  v2.y = -v2.y;
 drehen(-alfa,v1,v2); //Zurueckdrehen
 v1 += v3; v2 += v3; //Ende der Betrachtung vom Schwerpunkt aus.
 
 //if(t>dt || t<0.) {testprintf("da stimmt was nicht t=%lf dt=%lf\n",t,dt); return;}//test
 at->altposv(); at2->altposv();
 at->neuposv(t); at2->neuposv(t); //Bewegung bis zur Kollision mit alten Geschwindigkeiten
 at->v=v1; at2->v=v2; //neue Geschwindigkeiten
 at->neuposv(dt-t); at2->neuposv(dt-t); //restliche Bewegung mit neuen Geschwindigkeiten
 /* Test ob Abstand ok: * /
 static double minabst=2*atomradius;
 x=abs(at->pos-at2->pos);
 if(x<minabst) {testprintf("Atome sind zu nah: x=%lf\n",x); minabst=x;}
 / * */
}

/*************************** Diverses ************************************/
double zufall(double y)  /* liefert Zufallszahl zwischen 0.0 und 1.0 */
{
 static double x=1.3757;
 if(y!=0.) x=y;
 x=(100.+x)/(100.*(x-(long)(x))+0.7);
 y=10.*x;
 return (y-(long)(y));
}
