//ausg.cc  Ausgleichsgerade	letzte Aenderungen: 8.12.2016, 12.6.2018
#define VERSION "Version 1.1"
/*
Uebersetzen:
;AVAX> cx ausg
;AVAX> blink ausg,[pfister.obj]xtekplot1
;AVAX> pur ausg.exe

History:
12.5.95	V0.1	Erstellung RPf (erste lauffaehige Version mit Ausdruck)
26.5.		Integral (Summierung, Simpson vorbereitet)
15.9.	V0.2	Integral nach Simpson
3.9.96   0.3	Anpassung an Exponentialkurve eingefuegt
29.10.   0.4	Grenze von Chiquadrat-Verbesserung jetzt einstellbar
4.11.	 1.0	Moeglichkeit der Parameterangabe und automatische Ausfuehrung
11.11.		Grenzen mit %.3lg statt %lf ausgegeben
10.9.97		dg2 angefuegt, kfeld eingefuehrt fuer ausgeklammerte Punkte
		npkt nicht mehr long sondern int
8.1.97		auch in ausgleichsgerade() ausgeklammerte Punkte beruecksicht.
23.2.99		Anpassung an Polynom
21.7.99		Beschriftung mit Anpassungs-Formel
18.12.2000	Neue Diffgleichungen: dg6, dg7
17.1.2001	Kreuzgrsse einstellbar
30.4.2001	zum Ausgleich zu verwendender Bereich bei Aufruf angebbar
22.8.2001	Gaussfunktion eingebaut
30.4.2002	Spline-Kurven
28.5.2014 1.1   Warnung fuer fehlendes PLOTSAVE eingefuegt, makefile angepasst
                Defaultwerte fuer Bildgroesse erhoeht
8.12.2016       Zweite Gaussfunktion fuer Maxwell-Boltzmann-Verteilung
12.6.2018       mycolor() fuer 24-Bit Farbtiefe

*/

#define UNITYLEISTE 24 //Hoehe der nicht ausblendbaren Unity-Leiste

#define DIFFGL
#define INT int

#define ALPHA
//#define MAC
//#define OHNEINTEGRAL

#ifdef unix
#undef ALPHA
#define XWINDOW
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#ifdef ALPHA
#define XWINDOW
#endif
#ifdef MAC
#include "tekplot.h"
#endif
#ifdef XWINDOW
#include <xtekplot1.h>
#endif
#ifdef AMIGA
#include "h:amitekplot.h"
#endif
#ifdef MAC
#include "ulong.h"
#else
#include <ulong.h>
#endif

double sq(double x) {return x*x;}
inline long idfix(double x) {if(x>=0.) return long(x+0.5); else return long(x-0.5);}
double abs(double x) {if(x<0.) return -x; else return x;}

#ifdef MAC
#define BREITE 600
#define HOEHE  400
#define TIEFE  4
void mycolor(int nr) {color(nr);}
#elseif AMIGA
#define BREITE 640
#define HOEHE  512
#define TIEFE  4
void mycolor(int nr) {color(nr);}
#else
#define BREITE 1280
#define HOEHE  1024
#define TIEFE  24
void mycolor(int nr)
{
 if(nr==0) rgbcolor(50,50,50);
 else if(nr==1) rgbcolor(255,255,255);
 else if(nr==2) rgbcolor(255,0,0);
 else if(nr==3) rgbcolor(0,255,0);
 else color(nr);
}
#endif

#define WEISS 1
static int ROT=2,
	   GRUEN=3;

#if BREITE<=640
#define NX 500
//#define NXKREUZ 80.
//#define NYKREUZ 70.
static double NXKREUZ=800., NYKREUZ=700.;
#define BUCHSTABENBREITE  9
#define BUCHSTABENHOEHE  13
#else
#define NX 1000
static double NXKREUZ=200., NYKREUZ=160.;
#define BUCHSTABENBREITE 14
#define BUCHSTABENHOEHE  20
#endif
static int NTYP=0;

/******** globale Parameter fuer Automatische Ausfuehrung ************/
static int autoflag=0, anpassnr, splineord=2;
static char psfilename[80]="";

/*********************** Vordeklarationen ********************************/
void koordinatenzeichnen(double x0,double y0);
INT dateneinlesen(FILE *fp,double *x0,double *y0,double **pxf,double **pyf,
		  int **pkf);
void messwerte_darstellen(INT n,double *xf,double *yf);
void direktverbinden(INT n,double *xf,double *yf);
void ausgleichsgerade(INT n,double *xf,double *yf);
void vertraugrenzen();
void schrift2f(double x,double y,const char *text,
		double p1=0.,double p2=0.,double p3=0.);
void stradd(const char *s,const char *t,char *z);
double tfaktor(double p,int phi);
int hatpunkt(char *name,int c='.');
void ohnepunkt(char *name);
void error(const char *s);
void myrefresh();
int fastgleich(double x,double y,double diff);
void ausglexp(int nfu);
void exp_funktion_zeichnen(double *y0=NULL);

/************************** Spline-Klasse *****************************/
#include <vektorklasse.cc>
class Spline
{
 int np,npmax,n,t;
 vektor *pu;
 void neufeld();
 int u(int k);
 double N(int k,int t,double v);
public:
 Spline() {t=3; pu=NULL; npmax=80; clear();}
 ~Spline() {delete pu;}
 void clear() {np=0; if(pu!=NULL) delete pu; pu=new vektor[npmax];}
 void setord(int i) {t=i;}
 void put(vektor p);
 vektor p(double v);
};
void Spline::neufeld()
{
 vektor* pu2=new vektor[npmax*=2];
 for(int i=0;i<np;i++) pu2[i]=pu[i];
 delete pu;
 pu=pu2;
}
void Spline::put(vektor p)
{
 if(np==npmax) neufeld();
 pu[np++]=p; n=np-1;
}
int Spline::u(int k)
{
 return (k<t) ? 0 : ((k>n) ? n-t+2 : k-t+1);
}
double Spline::N(int k,int t,double v)
{
/** rekursive Variante (elegant aber langsam) **
 if(t==1) {return (u(k)<=v && v<u(k+1)) ? 1.0 : 0.0;}
 int teiler1,teiler2; double wert1,wert2;
 teiler1=u(k+t-1)-u(k); teiler2=u(k+t)-u(k+1);
 wert1 = (teiler1==0) ? 0.0 : (v-u(k))/teiler1*N(k,t-1,v);
 wert2 = (teiler2==0) ? 0.0 : (u(k+t)-v)/teiler2*N(k+1,t-1,v);
 return wert1+wert2;
** Schleifen-Variante (schnell aber unuebersichtlich) **/
 int ti,ki,k2=k+(t-1), kt=k+t, teiler1,teiler2;
 double wert; double* nkt=new double[kt*t];
 for(ki=0;ki<=k2;ki++)
   {nkt[ki]=(u(ki)<=v && v<u(ki+1)) ? 1.0 : 0.0;}
 for(ti=2;ti<=t;ti++)
 {--k2;
  for(ki=0;ki<=k2;ki++)
   {teiler1=u(ki+ti-1)-u(ki); teiler2=u(ki+ti)-u(ki+1);
    wert = ((teiler1==0) ? 0.0 : (v-u(ki))/teiler1*nkt[ki+(ti-2)*kt])
         + ((teiler2==0) ? 0.0 : (u(ki+ti)-v)/teiler2*nkt[ki+1+(ti-2)*kt]);
    nkt[ki+(ti-1)*kt]=wert;
   }
 }
 delete nkt;
 return wert;
/**/
}
vektor Spline::p(double v)
{
 vektor pv(0);
 for(int k=0;k<=n;k++)  {pv += pu[k]*N(k,t,v);}
 return pv;
}

/************************** Parabel-Klasse *****************************/
class Parab
{
 int np,npmax,n;
 vektor *pu;
 void neufeld();
 void p1(vektor& pv,int k1,double v);
 void q1(vektor& pv,int k1,double v);
public:
 Parab() {pu=NULL; npmax=80; clear();}
 ~Parab() {delete pu;}
 void clear() {np=0; if(pu!=NULL) delete pu; pu=new vektor[npmax];}
// void setord(int i) {t=i;}
 void put(vektor p);
 vektor p(double v);
 vektor q(double v);
};
void Parab::neufeld()
{
 vektor* pu2=new vektor[npmax*=2];
 for(int i=0;i<np;i++) pu2[i]=pu[i];
 delete pu;
 pu=pu2;
}
void Parab::put(vektor p)
{
 if(np==npmax) neufeld();
 pu[np++]=p; n=np-1;
}
void Parab::p1(vektor& pv,int k1,double v)
{
 // vektor pv;
 double x1,y1,x2,y2,x3,y3,a,b,c,e;
 int k2=k1+1,k3=k1+2;
 x1=pu[k1].x; y1=pu[k1].y;
 x2=pu[k2].x; y2=pu[k2].y;
 x3=pu[k3].x; y3=pu[k3].y;
 e=(x3-x1)/(x2-x1);
 a=(y3-(y2-y1)*e-y1)/(x3*x3-x1*x1-(x2*x2-x1*x1)*e);
 b=(y2-a*(x2*x2-x1*x1)-y1)/(x2-x1);
 c=y1-a*x1*x1-b*x1;
 if(v<k2)
   pv.x=pu[k1].x+(pu[k2].x-pu[k1].x)*(v-k1);
 else
   pv.x=pu[k2].x+(pu[k3].x-pu[k2].x)*(v-k2);
 pv.y=a*pv.x*pv.x+b*pv.x+c;
}
vektor Parab::p(double v)
{
 vektor pv,pv1,pv2;
 int k1,k2,k3;
 // static int test=0;
 // if(v<1) {k1=0; test=0;}
 if(v<1) k1=0;
 else  k1 = int(v-1.0);
 if(k1>n-2) k1=n-2;
 k2=k1+1; k3=k1+2;
 // if(k1>test) {test=k1; color(test+1);}
 p1(pv1,k1,v);
 if(v>k2 && k1<n-2)
   {p1(pv2,k2,v);
    pv=(k3-v)*pv1+(v-k2)*pv2;
   }
 else pv=pv1;
 return pv;
}

void Parab::q1(vektor& pv,int k1,double v)
{
 // v fungiert hier als Virtuelle x-Achse im Bereich k1 bis k3
 vektor a,b,c;
 double x1,x2,x3,y1,y2,y3,e;
 int k2=k1+1,k3=k1+2;
 x1=pu[k1].x; y1=pu[k1].y;
 x2=pu[k2].x; y2=pu[k2].y;
 x3=pu[k3].x; y3=pu[k3].y;
 e=(k3-k1)/double(k2-k1);
 a.y=(y3-(y2-y1)*e-y1)/(k3*k3-k1*k1-(k2*k2-k1*k1)*e);
 b.y=(y2-a.y*(k2*k2-k1*k1)-y1)/(k2-k1);
 c.y=y1-a.y*k1*k1-b.y*k1;
 a.x=(x3-(x2-x1)*e-x1)/(k3*k3-k1*k1-(k2*k2-k1*k1)*e);
 b.x=(x2-a.x*(k2*k2-k1*k1)-x1)/(k2-k1);
 c.x=x1-a.x*k1*k1-b.x*k1;
 pv=a*(v*v)+b*v+c;
}
vektor Parab::q(double v)
{
 vektor pv,pv1,pv2;
 int k1,k2,k3;
 //static int test=0;
 //if(v<1) {k1=0; test=0;}
 if(v<1) {k1=0;}
 else  k1 = int(v-1.0);
 if(k1>n-2) k1=n-2;
 k2=k1+1; k3=k1+2;
 // if(k1>test) {test=k1; color(test+1);}
 q1(pv1,k1,v);
 if(v>k2 && k1<n-2)
   {q1(pv2,k2,v);
    pv=(k3-v)*pv1+(v-k2)*pv2;
   }
 else pv=pv1;
 return pv;
}

/********************** Menu Aktualisierung *****************************/
char	menu_textproz683[]="%r 68.3 % ",
	menu_textproz955[]="%R 95.5 % ",
	menu_textproz997[]="%r 99.7 % ",
	menu_textintsum[]="%R Summieren",
	menu_textintsim[]="%r Simpson",
	menu_text_funktionellzu[]="%Q Funktioneller Zusammenhang";
long proz_ids[3],ints_ids[2];
void menuflip(long id,short *flag,int c1,int c0,char *text)
{
 text[1]=(*flag ^= 1)?c1:c0;
 changemenu(id,text);
}
void vpmarke(long id,char *text)
{
 if(proz_ids[0]==0) getmenuids(id,proz_ids);
 menu_textproz683[1]=menu_textproz955[1]=menu_textproz997[1]='r';
 text[1]='R';
 changemenu(proz_ids[0],menu_textproz683);
 changemenu(proz_ids[1],menu_textproz955);
 changemenu(proz_ids[2],menu_textproz997);
}
void intmarke(long id,char *text)
{
 if(ints_ids[0]==0) getmenuids(id,ints_ids);
 menu_textintsum[1]=menu_textintsim[1]='r';
 text[1]='R';
 changemenu(ints_ids[0],menu_textintsum);
 changemenu(ints_ids[1],menu_textintsim);
}

/************************* Hauptprogramm *********************************/
static const char *DEFAULTFILE="ausg.dat";
static double xmin,ymin,xmax,ymax,*xfeld,*yfeld,xnull=0.,ynull=0.;
static int *kfeld;
static double vproz=95.5;
static int bux=BUCHSTABENBREITE,buy=BUCHSTABENHOEHE,menuwaitflag=1,titeltext_gesetzt=0;
static INT npkt,npkta,plotstatus=0;
#define PLOTSTATUS_AUSGL  1
#define PLOTSTATUS_DIREKT 2
#define PLOTSTATUS_VGRENZ 4
#define PLOTSTATUS_INTEGR 8
#define PLOTSTATUS_EXP   16
#define AUSGL_OR_VGRENZ (PLOTSTATUS_AUSGL|PLOTSTATUS_VGRENZ)
#define DIREKT_OR_INTEGR (PLOTSTATUS_DIREKT|PLOTSTATUS_INTEGR)
static short exitflag=0,intmethode=0,funktionellflag=1,vertrau_startflag=0;
static char titeltext[80]="Titel";
#ifndef OHNEINTEGRAL
static double integ_x1=0.,integ_x2=0.;
static int na1=0,na2=0; //zum Ausgleich benutzter Bereich (wenn >0)
int do_integral();
void term_refresh_check(int err);
#define ERR_INTNUM 1
#define ERR_INTSIMP 2
#endif

void menu_exit() {exitflag=1;}
void menu_printsetup();
void menu_print();
void menu_ausgl() {inital_new(xmin,ymin,xmax,ymax); screenclear();
		   messwerte_darstellen(npkt,xfeld,yfeld);
		   ausgleichsgerade(npkt,xfeld,yfeld);
		   plotstatus&= ~PLOTSTATUS_DIREKT;
		   plotstatus|=PLOTSTATUS_AUSGL;
		   if(plotstatus&PLOTSTATUS_VGRENZ) vertraugrenzen();
		   term_refresh();
		  }
void menu_ausglexp()  {ausglexp(1);}
void menu_ausglexp2() {ausglexp(2);}
void menu_ausglexp3() {ausglexp(3);}
void menu_ausglexp4() {ausglexp(12);}
void menu_ausgldg1() {ausglexp(4);}
void menu_ausgldg2() {ausglexp(5);}
void menu_ausgldg3() {ausglexp(6);}
void menu_ausgldg4() {ausglexp(7);}
void menu_ausgldg5() {ausglexp(8);}
void menu_ausgldg6() {ausglexp(9);}
void menu_ausgldg7() {ausglexp(10);}
void menu_ausglpoly() {ausglexp(11);}
void menu_ausglgauss()  {ausglexp(13);}
void menu_ausglgauss2()  {ausglexp(14);}
void menu_direkt() {requester_input(1,
			"Spline-Ordnung (2=direkt, 3=glatt, 4=sehr glatt)",
			"%d","%d", &splineord);
		    inital_new(xmin,ymin,xmax,ymax); screenclear();
		    messwerte_darstellen(npkt,xfeld,yfeld);
		    direktverbinden(npkt,xfeld,yfeld);
		    plotstatus &= ~(PLOTSTATUS_AUSGL|PLOTSTATUS_VGRENZ);
		    plotstatus|=PLOTSTATUS_DIREKT;
#ifndef OHNEINTEGRAL
		    int err=0;
		    if(plotstatus&PLOTSTATUS_INTEGR) err=do_integral();
		    term_refresh_check(err);
#else
		    term_refresh();
#endif
		   }
void menu_integral();
void menu_intsum(long id) {intmethode=0; intmarke(id,menu_textintsum);}
void menu_intsim(long id) {intmethode=1; intmarke(id,menu_textintsim);}
void menu_vertrau() {vertrau_startflag=5; menuwaitflag=0;}
void vertrau_start()
{
 inital_new(xmin,ymin,xmax,ymax); vertraugrenzen(); term_refresh();
 vertrau_startflag=0; menuwaitflag=1;
 plotstatus|=PLOTSTATUS_VGRENZ;
}
void menu_vproz683(long id) {vproz=68.3; vpmarke(id,menu_textproz683);}
void menu_vproz955(long id) {vproz=95.5; vpmarke(id,menu_textproz955);}
void menu_vproz997(long id) {vproz=99.7; vpmarke(id,menu_textproz997);}
void menu_funkzu(long id)
	{menuflip(id,&funktionellflag,'Q','q',menu_text_funktionellzu);}
void menu_saveps();
void menu_zoomin();
void menu_zoomout();
void menu_numberzoom();
void menu_refresh() {myrefresh();}
void menu_betitel();
void menu_beachs();
void menu_bekreuz();
void menu_printvorschau();//test

void readdefaultfile(char *filename,const char *name)
{
 FILE *fp;
 if(fp=fopen(name,"r"))
	{fscanf(fp,"%s",filename); fclose(fp);}
 else strcpy(filename,"Ausgleichsgerade.dat");
}
void writedefaultfile(char *filename,const char *name)
{
 FILE *fp;
 if(fp=fopen(name,"w"))
	{fprintf(fp,"%s\n",filename); fclose(fp);
#ifdef ALPHA
	 char str[80];
	 sprintf(str,"pur %s",name); system(str);
#endif
	}
}

void usage(const char *s=" ")
{
 if(*s!=' ') printf("Error: %s\n",s);
 printf("Anwendung: ausg [Name.dat] [anpassNr \"Name\" Name.ps]\n");
 printf("     oder: ausg Name.dat n1 n2\n");
 printf("           (Bereich fuer Ausgleich: n1. bis n2. Messpunkt)\n");
 printf(" Beispiel: ausg test1.dat anpass2 \"Test 1\" tmptest1.ps\n");
 exit(0);
}

int main(int argc,char *argv[])
{
 FILE *fp;
 char filename[80],text[100];
 int breite,hoehe,tiefe,visklasse,ok;
// janeinrequester("ja/nein-Requester testen","ja","nein");//test
// janeinrequester("ok-Requester testen","aha");//test
 if(argc>1) //es wurden Parameter angegeben (Start von Shell)
  {if((argc!=2 && argc!=5 && argc!=4) || *argv[1]=='?' || *argv[1]=='-')
		usage();
   fp=fopen(argv[1],"r");
   if(fp==NULL) {printf("Error: '%s' not found\n",argv[1]); return 0;}
   if(argc==5)
     {autoflag=1;
      if(strncmp(argv[2],"anpass",6)!=0) usage("wrong Parameter 2");
      sscanf(&argv[2][6],"%d",&anpassnr);
      strcpy(titeltext,argv[3]); titeltext_gesetzt=1;
      strcpy(psfilename,argv[4]);
     }
   else if(argc==2)
     {strcpy(titeltext,argv[1]); titeltext_gesetzt=1;
      ohnepunkt(argv[1]); stradd(argv[1],".ps",psfilename);
     }
   else if(argc==4)
     {strcpy(titeltext,argv[1]); titeltext_gesetzt=1;
      ohnepunkt(argv[1]); stradd(argv[1],".ps",psfilename);
      sscanf(argv[2],"%d",&na1); sscanf(argv[3],"%d",&na2); //Bereich lesen
      if(na2<=na1 || na1<1) usage();
     }
  }
 else //keine Parameter angegeben (Start von WorkBench)
 {readdefaultfile(filename,DEFAULTFILE);
  do
  {ok=requester_input(1," Datei mit Messwerten ","%s","%s", filename);
   if(ok==0) return 0;
   fp=fopen(filename,"r");
   if(fp==NULL && !hatpunkt(filename))
	{stradd(filename,".dat",filename); fp=fopen(filename,"r");}
   if(fp==NULL)
	{sprintf(text," '%s' nicht gefunden ! ",filename);
	 ok=janeinrequester(text,"andrer Name","Abbruch");
	 if(ok==0) return 0;
	}
  }
  while(fp==NULL);
  writedefaultfile(filename,DEFAULTFILE);
 }
 npkt=dateneinlesen(fp,&xnull,&ynull,&xfeld,&yfeld,&kfeld);
 fclose(fp);
// tek_setdebug(1);//test
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
#ifdef UNITYLEISTE 
 hoehe -= UNITYLEISTE;
#endif
 if(breite>BREITE) breite=BREITE;
 if(hoehe>HOEHE) hoehe=HOEHE;
 //printf("getmaxsize() --> tiefe=%d\n",tiefe);//test
 if(tiefe>TIEFE) tiefe=TIEFE;
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File","Darstellung","Berechnungen","Beschriftungen");
/*
 setmenu(2,"New",menu_);
 setmenu(2,"Open",menu_);
 setmenu(2,"Close",menu_);
 setmenu(2,"Save",menu_);
 setmenu(2,"Save As",menu_);
*/
 setmenu(4,"Save POSTSCRIPT   ","direkt verbinden oder Spline ...","Integral Metode  ->","Titeltext",
		menu_saveps,menu_direkt,NULL,menu_betitel);
 setsubmenu(3,NULL,NULL,menu_textintsum,NULL,NULL,menu_intsum);
 setsubmenu(3,NULL,NULL,menu_textintsim,NULL,NULL,menu_intsim);
 setmenu(4,"%~~~~~~~~~~~~~~~~","Ausgleichsgerade","Integral","Achseneinteilung",
		NULL,menu_ausgl,menu_integral,menu_beachs);
 setmenu(4,"Print Setup","Anpassung an Funktion  ->",NULL,   "Kreuzgroesse",
	 menu_printsetup,NULL,NULL,menu_bekreuz);
 setsubmenu(2,NULL,"k1*exp(-k2*x) + y0",NULL,menu_ausglexp);
 setsubmenu(2,NULL,"k1*exp(-k2*x)",NULL,menu_ausglexp2);
 setsubmenu(2,NULL,"k1*exp(-k2*x) - k1",NULL,menu_ausglexp3);
 setsubmenu(2,NULL,"k1*exp(-x/T1) + k3*exp(-x/T2)",NULL,menu_ausglexp4);
#ifdef DIFFGL
 setsubmenu(2,NULL,"Dg: B'=k2*A-k3*B  A'=-k1*A",NULL,menu_ausgldg1);
 setsubmenu(2,NULL,"Dg: C'=k3*B  B'=k2*A-C'  A'=-k1*A",NULL,menu_ausgldg2);
 setsubmenu(2,NULL,"Dg: Reakt. A->B->C nach B geloest",NULL,menu_ausgldg3);
 setsubmenu(2,NULL,"Dg: A->C+B->2C->D  nach C geloest",NULL,menu_ausgldg4);
 setsubmenu(2,NULL,"Berke-Fit-Funktion",NULL,menu_ausgldg5);
 setsubmenu(2,NULL,"Dg: U'=c1*e^(t/Tau)-U/RC",NULL,menu_ausgldg6);
 setsubmenu(2,NULL,"Dg: U'=c1*e^(t/T)+c2*e^(t/T2)-U/RC",NULL,menu_ausgldg7);
#endif
 setsubmenu(2,NULL,"Polynom: Summe[An*x^n]",NULL,menu_ausglpoly);
 setsubmenu(2,NULL,"Gauss: k1*exp(-k2*x^2)+y0",NULL,menu_ausglgauss);
 setsubmenu(2,NULL,"Gauss2: k1*x^2*exp(-k2*x^2)",NULL,menu_ausglgauss2);
 setmenu(2,"Print","%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~",menu_print,NULL);
 setmenu(2,"%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~","VertrauensProzente  ->",NULL,NULL);
 setsubmenu(2,NULL,menu_textproz683,NULL,menu_vproz683);
 setsubmenu(2,NULL,menu_textproz955,NULL,menu_vproz955);
 setsubmenu(2,NULL,menu_textproz997,NULL,menu_vproz997);
 setmenu(2,"Quit",menu_text_funktionellzu,menu_exit,menu_funkzu);
#ifdef MAC /* TEST */
 setmenu(2,"Print Vorschau","Vertrauensgrenzen zeichnen",
	 menu_printvorschau,menu_vertrau);
#else
 setmenu(2,NULL,"Vertrauensgrenzen zeichnen",NULL,menu_vertrau);
#endif
 setmenu(2,NULL,"%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~",NULL,NULL);
 setmenu(2,NULL,"Zoom In",NULL,menu_zoomin);
 setmenu(2,NULL,"Zoom Out",NULL,menu_zoomout);
 setmenu(2,NULL,"NumberZoom",NULL,menu_numberzoom);
 setmenu(2,NULL,"%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~",NULL,NULL);
 setmenu(2,NULL,"Refresh",NULL,menu_refresh);
 inital(xmin,ymin,xmax,ymax);
 getsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe<2) ROT=GRUEN=WEISS;
 messwerte_darstellen(npkt,xfeld,yfeld);
 if(autoflag)
  {term_refresh();
   switch(anpassnr)
     {case 1:menu_ausglexp();
      CASE 2:menu_ausglexp2();
      CASE 3:menu_ausglexp3();
#ifdef DIFFGL
      CASE 4:menu_ausgldg1();
      CASE 5:menu_ausgldg2();
      CASE 6:menu_ausgldg3();
      CASE 7:menu_ausgldg4();
      CASE 8:menu_ausgldg5();
      CASE 9:menu_ausgldg6();
      CASE 10:menu_ausgldg7();
#endif
      CASE 11:menu_ausglpoly();
      CASE 12:menu_ausglexp4();
      CASE 13:menu_ausglgauss();
      CASE 14:menu_ausglgauss2();
      DEFAULT:menu_ausgl();
     }
   menu_saveps();
  }
 else
  {ausgleichsgerade(npkt,xfeld,yfeld); plotstatus=PLOTSTATUS_AUSGL;
   //vertraugrenzen(); plotstatus=PLOTSTATUS_AUSGL|PLOTSTATUS_VGRENZ;
   term_refresh();
   while(waitmenu(menuwaitflag)==0 && exitflag==0)
	if(vertrau_startflag>0)
		{if(--vertrau_startflag==0) vertrau_start();
		 else Delay(1);
		}
  }
 term_exit();
 delete xfeld; delete yfeld; delete kfeld;
 return 0;
}

int anzsigstellen(double x) //ermittle Anzahl Signifikante Stellen
{
 int ix,n;
 if(x==0.) return 0;
 while(x<1e6) x*=10.;
 for(ix=idfix(x);ix%10==0;ix/=10) ;
 for(n=0;ix>0;n++,ix/=10) ;
 return n;
}

void setcstr(char *str,double z1,double z2,double dz)
{
//Beisp: 0.01 0.03 0.005
 int n,m,t1,t2;
 z1=abs(z1); z2=abs(z2); dz=abs(dz);
 if(z1<10000 && z2<10000. && dz>=0.001)
  {str[4]='f';
   t1=idfix((dz-int(dz+5e-5))*1e4); t2=idfix((z1-int(z1+5e-5))*1e4);
   for(n=4;n>0;n--,t1/=10,t2/=10)
	if(t1%10!=0 || t2%10!=0) break;
   if(n==0 && z2<100.) n=1;
   str[2]='0'+n;
  }
 else
  {str[4]='e';
   n=anzsigstellen(z1+dz);
   if((m=anzsigstellen(z1))>n) n=m;
   if((m=anzsigstellen(z2))>n) n=m;
   if((m=anzsigstellen(dz))>n) n=m;
   str[2]='0'+n;
  }
}

void zeichnexachse(double x1,double y1,double x2,double y2)
{
 double x,dx,y0,y0s,z1,z2,dz;
 int i,imax;
 char str[]="%.4lg";
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
 dx=(x2-x1)/10.;
 z1=rundezahl(x1,x1+dx); z2=rundezahl(x2,x2-dx);
 dz=rundezahl((z2-z1)/10.,(z2-z1)/4.);
 dx=(x2-x1)/50.;
 y0=y1-(ymax-ymin)/20.;
 if(ymax>ymin)	{if(y0<ymin) y0=ymin;}
 else		{if(y0>ymin) y0=ymin;}
 y0s=(y0+y1)/2.;
 setcstr(str,z1,z2,dz);
 for(i=0,imax=idfix(abs(z2-z1)/dz);i<=imax;i++)
	{x=z1+i*dz;
	 plot(x,y1,PENUP); plot(x,y0s,PENDOWN);
	 schrift2f(x-dx,y0,str,x,0.);
	}
}
void zeichneyachse(double x1,double y1,double x2,double y2)
{
 double y,dy,x0,x0s,z1,z2,dz;
 int i,imax;
 char str[]="%.4lg";
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
 dy=(y2-y1)/10.;
 z1=rundezahl(y1,y1+dy); z2=rundezahl(y2,y2-dy);
 dz=rundezahl((z2-z1)/10.,(z2-z1)/4.);
 dy=(y2-y1)/80.;
 x0=x1-(xmax-xmin)/12.;
 if(xmax>xmin)	{if(x0<xmin) x0=xmin;}
 else		{if(x0>xmin) x0=xmin;}
 x0s=x1-(xmax-xmin)/60.;
 if(x0s<(x0+x1)/2.) x0s=(x0+x1)/2.;
 setcstr(str,z1,z2,dz);
 for(i=0, imax=idfix(abs(z2-z1)/dz);i<=imax;i++)
	{y=z1+i*dz;
	 plot(x1,y,PENUP); plot(x0s,y,PENDOWN);
	 schrift2f(x0,y-dy,str,y,0.);
	}
}
void koordinatenzeichnen(double x0,double y0)
{
 int ix,iy;
 koorduser2pix(x0,ymax*0.95,&ix,&iy);
 itextsize(bux,buy,NULL);
// ischrift(ix-2*bux,iy,"y");
 koorduser2pix(xmax*0.95,y0,&ix,&iy);
// ischrift(ix,iy+2*buy,"x");
 zeichnexachse(xmin,y0,xmax,y0);
 zeichneyachse(x0,ymin,x0,ymax);
}

double werteinlesen(FILE *fp)
{
 int c;
 double x=0;
 if((c=getc(fp))=='0' && (c=getc(fp))=='=')
	fscanf(fp,"%lf",&x);
 else error("Syntaxerror in Eingabedatei");
 return x;
}
int texteinlesen(FILE *fp,char *text)
{
 int c,c0;
 char *p=text;
 while((c=getc(fp))!='=' && c!=EOF) ;
 if((c0=getc(fp))>='A') {ungetc(c0,fp); c0='\n';}
 while((c=getc(fp))!=c0 && c!=EOF && c!='\n')
	*p++ = c;
 *p=0;
 return p!=text;
}

void vergroessern(long m,double **px,double **py)
{
 double *x,*y,*x0,*y0,*x1,*y1;
 long i;
 x1=x=new double[m]; y1=y=new double[m];
 if(x==NULL || y==NULL) {error("zu wenig Speicher"); exit(0);}
 for(x0= *px,y0= *py,i=0;i<m;i++) {*x1++ = *x0++; *y1++ = *y0++;}
 delete *px; delete *py;
 *px=x; *py=y;
}

INT dateneinlesen(FILE *fp,double *x0,double *y0,double **pxf,double **pyf,
		  int **pkf)
{
 INT i,m=1024;
 int c,klammauf;
 int klamm; //ausgeklammerter Punkt --> zeichnen aber nicht fuer Ausgl. verw.
 double *xf,*yf,x,y,rand; int *kf;
 xf=new double[m]; yf=new double[m]; kf=new int[m];
 xmin=ymin=xmax=ymax=0.;
 for(i=0;(c=getc(fp))!=EOF;)
	{while(isspace(c)) c=getc(fp);
	 if(c==EOF) break;
	 if(c=='(') {klammauf=c; klamm=1; c=getc(fp);}
	 else {klammauf=0; klamm=0;}
	 if(na2>0 && (i<na1-1 || i>na2-1)) klamm=1;
	 if(isalpha(c))
	  {c=toupper(c);
	   if(c=='X') {*x0=xmax=xmin=werteinlesen(fp); continue;}
	   else if(c=='Y') {*y0=ymax=ymin=werteinlesen(fp); continue;}
	   else if(c=='T')
		{titeltext_gesetzt=texteinlesen(fp,titeltext); continue;}
	   else error("Syntaxerror in Eingabedatei");
	  }
	 else ungetc(c,fp);
	 if(i>=m) vergroessern(m+=m,&xf,&yf);
	 if(klamm && klammauf=='(') fscanf(fp,"%lf%*c%lf)",&x,&y);
	 else fscanf(fp,"%lf%*c%lf",&x,&y);
	 xf[i]=x; yf[i]=y; kf[i]=klamm;
	 if(x>xmax) xmax=x; else if(x<xmin) xmin=x;
	 if(y>ymax) ymax=y; else if(y<ymin) ymin=y;
	 i++;
	}
 *pxf=xf; *pyf=yf; *pkf=kf;
 rand=(xmax-xmin)/12.; xmin-=rand; xmax+=rand;
 rand=(ymax-ymin)/10.; ymin-=rand; ymax+=rand;
 return i;
}

void kreuzzeichnen(double x,double y)
{
 double dx=(xmax-xmin)/NXKREUZ, dy=(ymax-ymin)/NYKREUZ;
 switch(NTYP)
   {case 1: plot(x,y,PENDOWN); break;
    case 2: drawcircle(x,y,10*dx,10*dy); break;
    case 3: fillcircle(x,y,10*dx,10*dy); break;
    default:
      plot(x+dx,y,PENUP); plot(x-dx,y,PENDOWN);
      plot(x,y+dy,PENUP); plot(x,y-dy,PENDOWN);
   }
}
void ausgeklammertes_kreuzzeichnen(double x,double y)
{
 double dx=(xmax-xmin)/NXKREUZ, dy=(ymax-ymin)/NYKREUZ;
 plot(x+dx,y+dy,PENUP); plot(x-dx,y-dy,PENDOWN);
 plot(x-dx,y+dy,PENUP); plot(x+dx,y-dy,PENDOWN);
}
void gestrichelte_linie(double x1,double y1,double x2,double y2)
{
 tek_pen("LSTRICH");
 plot(x1,y1,PENUP); plot(x2,y2,PENDOWN);
 tek_pen("NORM");
}

void messwerte_darstellen(INT n,double *xf,double *yf)
{
 INT i; int *kf=kfeld;
 koordinatenzeichnen(xnull,ynull);
 if(na2>0)
  {for(i=0;i<n;i++)
	if(*kf++)
	  {if(*kf==0 || (i>1 && kf[-2]==0))
	     gestrichelte_linie(*xf,*yf,*xf,0.0);
	   ausgeklammertes_kreuzzeichnen(*xf++,*yf++);
	  }
	else kreuzzeichnen(*xf++,*yf++);
  }
 else
  {for(i=0;i<n;i++)
	if(*kf++) ausgeklammertes_kreuzzeichnen(*xf++,*yf++);
	else kreuzzeichnen(*xf++,*yf++);
  }
}
void direktverbinden(INT n,double *xf,double *yf)
{
 INT i;
 if(splineord==2)
   {plot(*xf++,*yf++,PENUP);
    for(i=1;i<n;i++)
	plot(*xf++,*yf++,PENDOWN);
   }
 else if(splineord>2)
   {int pen=PENUP,t;
    double v,vmax,dv;
    vektor p;
    Spline spline;
    t=(splineord>n)?n:splineord;
    spline.setord(t);
    for(i=0;i<n;i++)
      {p.x = *xf++;  p.y = *yf++;  spline.put(p);}
    vmax=(n-1)-t+2; //n in der B-Spline-Formel entspricht n-1
    dv=vmax/500;
    for(v=0;v<vmax;v+=dv)
      {p=spline.p(v); plot(p.x,p.y,pen); pen=PENDOWN;}
   }
 else  //1=Parabel 0=Virtuelle Parabel
   {int pen=PENUP;
    double v,vmax,dv;
    vektor p;
    Parab parab;
    for(i=0;i<n;i++)
      {p.x = *xf++;  p.y = *yf++;  parab.put(p);}
    vmax=(n-1); //n in der B-Spline-Formel entspricht n-1
    dv=vmax/1000;
    for(v=0;v<vmax;v+=dv)
      {p=(splineord==1)?parab.p(v):parab.q(v);
       plot(p.x,p.y,pen); pen=PENDOWN;
      }
   }
}

/************************* Beschriftungen ********************************/
void schrift2f(double x,double y,const char *text,double p1,double p2,double p3)
{
 int ix,iy;
 static char str[120];
 sprintf(str,text,p1,p2,p3);
 koorduser2pix(x,y,&ix,&iy);
// printf("sprintf(..'%s'..); ischrift(%d,%d,'%s')\n",text,ix,iy,str);//test
 ischrift(ix,iy,str);
}
void schrift1d2f(double x,double y,const char *text,long p1,double p2,double p3=0)
{
 int ix,iy;
 static char str[120];
 sprintf(str,text,p1,p2,p3);
 koorduser2pix(x,y,&ix,&iy);
 ischrift(ix,iy,str);
}
/*********************** Ausgleichsgerade ********************************/
class ausgerklasse
{
public:
 int n;
 double steig,absch,xquer,yquer,s,Sxx,Syy,Sxy,sigmaa,sigmab;
 double y(double x) {return steig*x+absch;}
 double sigmabx(double x);
 void geradezeichnen();
 double korrel() {return Sxy/sqrt(Sxx*Syy);}
};

void ausgerklasse::geradezeichnen()
{
 double x,dx=(xmax-xmin)/NX;
 int pen=PENUP;
 for(x=xmin;x<=xmax;x+=dx)
	{plot(x,y(x),pen); pen=PENDOWN;}
}
double ausgerklasse::sigmabx(double x)
{
 double y=1.0/n+sq(x-xquer)/Sxx;
 if(!funktionellflag) y+=1.0;
 return s*sqrt(y);
}

static ausgerklasse ger;

void ausgleichsgerade(INT n,double *xf,double *yf)
{
 INT i;
 double x,y,sx,sxy,sx2,sy,sy2,xstep,ystep;
 double delta,varianz,summe,t;
/*
 ger.n=n;
 for(sx=sxy=sx2=sy=sy2=0.,i=0;i<n;i++)
	{x=xf[i]; y=yf[i];
	 sx+=x; sy+=y;
	 sxy+=x*y; sx2+=x*x; sy2+=y*y;
	}
*/
/** neu: ausgeklammerte Punkte weglassen **/
 int na=0;
 for(sx=sxy=sx2=sy=sy2=0.,i=0;i<n;i++)
	{x=xf[i]; y=yf[i];
	 if(kfeld[i]==0)
	   {sx+=x; sy+=y;
	    sxy+=x*y; sx2+=x*x; sy2+=y*y;
	    na++;
	   }
	}
 ger.n=n=na;
/** :ausgeklammerte Punkte weglassen **/
 ger.yquer=sy/n;
 ger.xquer=sx/n;
 ger.steig=(sxy-ger.yquer*sx)/(sx2-ger.xquer*sx);
 ger.absch=ger.yquer-ger.steig*ger.xquer;
 ger.geradezeichnen();
 if(n>2)
	{for(summe=0.,i=0;i<n;i++) summe+=sq(yf[i]-ger.y(xf[i]));
	 varianz=summe/(n-2);
	 delta=n*sx2-sx*sx;
	 ger.s=sqrt(varianz);
	 ger.sigmaa=sqrt(n*varianz/delta);
	 ger.sigmab=sqrt(varianz*sx2/delta);
	 ger.Sxx=sx2-n*sq(ger.xquer);
	 ger.Syy=sy2-n*sq(ger.yquer);
	 ger.Sxy=sxy-n*ger.xquer*ger.yquer;
	}
 else	{ger.s=ger.sigmaa=ger.sigmab=0.; ger.Sxx=ger.Syy=ger.Sxy=1.;}
 deltakoordpix2user(bux/2,buy*3/2,&xstep,&ystep);
 if(xnull<(xmax-xmin)/3.) x=xnull; else x=xmin;
 y=ymax-ystep;
 if(ger.steig>0.)
	{x+=xstep;}
 else	{x=(xmax+xmin)/2.;}
 itextsize(bux,buy,NULL);
 int phi=ger.n-2;
 if(phi<1) t=0.;
 else t=tfaktor(vproz,phi);
 if(titeltext_gesetzt)
	{schrift2f(x,y,titeltext); y-=ystep;}
 if(funktionellflag)
  schrift2f(x,y,"%.1lf%% Sicherheit, mit funktionellem Zusammenhang",vproz,0.);
 else
  schrift2f(x,y,"%.1lf%% Sicherheit, ohne funktionellen Zusammenhang",vproz,0.);
 schrift2f(x,y-=ystep,"Steigung = %lg +- %.3lg",ger.steig,ger.sigmaa*t);
// schrift2f(x,y-=ystep,"Achsenab.= %lf +- %lf",ger.absch,ger.sigmab*t);
 schrift2f(x,y-=ystep,"Achsenab.= %lg +- %.3lg",ger.absch,ger.sigmabx(0.)*t);
 schrift2f(x,y-=ystep,"Korrelationskoeff.= %lf",ger.korrel());
}

double tfaktor(double p,int phi)
{
 static double pktab[]=
  {0.675,51.,1.0,80.,2.0,96.4,2.2,97.8,2.4,98.7,2.6,99.3,2.8,99.6,3.0,100.},
	ttab95[]= {12.71,4.3,3.18,2.78,2.57,2.45,2.37,2.31,2.26,2.2467},
	ttab997[]={23.5,19.2,9.22,6.62,5.51,4.90,4.53,4.27,4.09,4.0400};
 double k,t,*pk,*ttab;
 for(pk=pktab;;)
	{k= *pk++; if(*pk++ >= p) break;}
 if(k>2.5) ttab=ttab997;
 else if(k>1.5) ttab=ttab95;
 else ttab=NULL;
 if(ttab)
	{int n=phi-1;
	 if(n>9) {t=ttab[9]-(n-9)*(ttab[8]-ttab[9]); if(t<k) t=k;}
	 else	t=ttab[n];
	}
 else	t=k;
 return t;
}
void vertraugrenzen()
{
 double x,dx=(xmax-xmin)/NX,t;
 int pen,phi=ger.n-2;
 if(phi<1) {error("zu wenig Punkte fuer Vertrauensgrenzen"); return;}
 t=tfaktor(vproz,phi);
 mycolor(GRUEN);
 for(pen=PENUP,x=xmin;x<=xmax;x+=dx)
	{plot(x,ger.y(x)-t*ger.sigmabx(x),pen); pen=PENDOWN;}
 mycolor(ROT);
 for(pen=PENUP,x=xmin;x<=xmax;x+=dx)
	{plot(x,ger.y(x)+t*ger.sigmabx(x),pen); pen=PENDOWN;}
 mycolor(WEISS);
}

/******************** Bild speichern/ausdrucken **************************/
#ifdef unix
void system2(const char *s,const char *p1,const char *p2=NULL)
{
 char str[120];
 sprintf(str,s,p1,p2); system(str);
}
#else
extern char *bildname;
#endif

void myrefresh()
{
 inital_new(xmin,ymin,xmax,ymax); screenclear();
 messwerte_darstellen(npkt,xfeld,yfeld);
 if(plotstatus&PLOTSTATUS_AUSGL) ausgleichsgerade(npkt,xfeld,yfeld);
 else if(plotstatus&PLOTSTATUS_DIREKT) direktverbinden(npkt,xfeld,yfeld);
 else if(plotstatus&PLOTSTATUS_EXP) exp_funktion_zeichnen();
 if((plotstatus&AUSGL_OR_VGRENZ)==AUSGL_OR_VGRENZ) vertraugrenzen();
#ifndef OHNEINTEGRAL
 int err=0;
 if((plotstatus&DIREKT_OR_INTEGR)==DIREKT_OR_INTEGR) err=do_integral();
 term_refresh_check(err);
#else
 term_refresh();
#endif
}

#ifdef ALPHA
void printf_system(char* str,char* p1)
{
 static char strsys[80];
 sprintf(strsys,str,p1);
 if(str[0]!=' ') printf("%s\n",strsys);
 system(strsys);
}
#endif

void menu_saveps()
{
 char *s;
 int ok;
 if(autoflag) ok=1;
 else
  {if(*psfilename==0)
     {if(s=getenv("PLOTSAVE")) strcpy(psfilename,s);
      else strcpy(psfilename,"Ausg.ps");
     }
   ok=requester_input(1,"Speichern unter:","%s","%s",psfilename);
  }
 if(ok)
#ifndef unix
  {
#ifdef MAC
   if(*psfilename=='?') tek_test(); else//test
#endif
   setenv("PLOTSAVE",bildname=psfilename);
   plotsave("POST"); myrefresh(); plotsave("OFF");
#ifndef MAC
   printf("Bild als '%s' gespeichert\n",bildname);//test
#endif
  }
#else  /* unix */
  {s=getenv("PLOTSAVE");
   plotsave("POST"); myrefresh(); plotsave("OFF");
   if(s) system2("mv %s %s",s,psfilename);
   else fprintf(stderr,"missing env variable PLOTSAVE\n\
add this line to .bashrc:\n export PLOTSAVE=\"tmpbild.ps\"\n");
  }
#endif /* unix */
 if(autoflag) {for(int i=0;i<10;i++) waitTOF();} //Bild kurz stehen lassen
}

void menu_print()
{
#ifdef unix
 plotsave("POST"); myrefresh(); plotsave("OFF");
 system2("lpr %s",getenv("PLOTSAVE"));
#else
#ifdef ALPHA
 plotsave("POST"); myrefresh(); plotsave("OFF");
 printf_system("PSLASER/DEL %s",bildname);
#else
 tek_print(myrefresh);
#endif
#endif
}
void menu_printsetup()
{
#ifdef unix
 printf("menu_printsetup() unter unix (noch) nicht definiert\n");//provi
#else
#ifdef ALPHA
 printf("menu_printsetup()\n");//provi
#else
 tek_printsetup();
#endif
#endif
}

#ifdef MAC /* TEST */
void menu_printvorschau()
{
 tek_print_vorschau(myrefresh);
}
#endif

/************************ Grenzen aendern ********************************/
void zoomset(double faktor,double *min,double *max)
{
 double d;
 d=(*max - *min)*(faktor-1.)/2.;
 *max += d; *min -= d;
}

void menu_zoomin()
{
 zoomset(1./1.5,&xmin,&xmax); zoomset(1./1.5,&ymin,&ymax); 
// printf("xmin=%lf xmax=%lf   ymin=%lf ymax=%lf\n",xmin,xmax,ymin,ymax);//test
 myrefresh();
}
void menu_zoomout()
{
 zoomset(1.5,&xmin,&xmax); zoomset(1.5,&ymin,&ymax);
// printf("xmin=%lf xmax=%lf   ymin=%lf ymax=%lf\n",xmin,xmax,ymin,ymax);//test
 myrefresh();
}
void menu_numberzoom()
{
 requester_input(4,"      xmin      ","%.12lf","%lf",  &xmin,
		   "      xmax      ","%.12lf","%lf\n",&xmax,
		   "      ymin      ","%.12lf","%lf",  &ymin,
		   "      ymax      ","%.12lf","%lf\n",&ymax);
 myrefresh();
}

/************************ Beschriftungen *********************************/
void menu_betitel()
{
 if(requester_input(1,"         Titeltext         ","%s","%s",titeltext))
	{titeltext_gesetzt=1; myrefresh();}
}
void menu_beachs()
{
 requester_input(2,"  Ursprung x-Achse  ","%lg","%lf\n",&xnull,
		   "  Ursprung y-Achse  ","%lg","%lf\n",&ynull);
 myrefresh();
}
void menu_bekreuz()
{
 requester_input(3," X/Kreuzgroesse ","%lg","%lf\n",&NXKREUZ,
		   " Y/Kreuzgroesse ","%lg","%lf\n",&NYKREUZ,
		   "Typ (0=Kreuz, 1=Linie, 2=Kreis, 3=gefuellter Kreis)",
		       "%d","%d\n",&NTYP);
 myrefresh();
}

/************************** Integrieren **********************************/
#ifdef OHNEINTEGRAL
void menu_integral()
{
 janeinrequester("Integrieren geht noch nicht");
}
#else
double integral(int npkt,double *xf,double *yf,int simpsonflag=0);
void integral_beschriftung(double integralwert,double xstart,double xende);

void menu_integral()
{
 int i;
 if(integ_x1==0. && integ_x2==0.)
	{integ_x1=integ_x2=xfeld[0];
	 for(i=1;i<npkt;i++)
		{if(integ_x1>xfeld[i]) integ_x1=xfeld[i];
		 if(integ_x2<xfeld[i]) integ_x2=xfeld[i];
	}	}
 i=requester_input(2," Untere Grenze ","%lg","%lf\n",&integ_x1,
		   " Obere Grenze  ","%lg","%lf\n",&integ_x2);
 if(i!=0) plotstatus |= PLOTSTATUS_INTEGR;
 else	plotstatus &= ~PLOTSTATUS_INTEGR;
 myrefresh();
}
int do_integral()
{
 int i;
 if(intmethode==0) /* Summieren */
	{//double x,x0,y,y0,ymin,ymax;
	 int n,n1,n2=0;
	 for(i=0;i<npkt && xfeld[i]<integ_x1;i++) ;
	 n1=i;
	 for(;i<npkt && xfeld[i]<=integ_x2;i++) ;
	 n2=i;
	 n=n2-n1;
	 if(n>2)
	  {//double *xf=new double[n], *yf=new double[n];
	   //ist noetig wenn erster oder letzter Punkt nicht identisch Messpkt.
	   double *xf= &xfeld[n1], *yf= &yfeld[n1];//provi.
	   integral(n-1,xf,yf);
	  }
	 else return ERR_INTNUM;
	}
 else if(intmethode==1) /* nach Simpson */
	{//double x,x0,y,y0,ymin,ymax;
	 double x1,dx,diff;
	 int n,n1,n2,konst=0;
	 for(i=0;i<npkt && xfeld[i]<integ_x1;i++) ;
	 n1=i; x1=xfeld[i++];
	 for(;i<npkt && xfeld[i]<=integ_x2;i++)
		if(konst==0) {dx=xfeld[i]-x1; diff=dx/100.; konst++;}
		else if(!fastgleich(xfeld[i]-xfeld[i-1],dx,diff)) konst++;
	 n2=i;
	 n=n2-n1;
	 if(n>2 && konst==1)
	  {double *xf= &xfeld[n1], *yf= &yfeld[n1];
	   integral(n-1,xf,yf,intmethode);
	  }
	 else
	  {if(n<=2) return ERR_INTNUM;
	   else return ERR_INTSIMP; //provi.
	  }
	}
 return 0;
}

double integral(int npkt,double *xf,double *yf,int simpsonflag)
{
 double sum=0.,faktor,y,y0,y1,x,x0,xstart,dsimp;
 int i,i0,simp=1;
 mycolor(ROT);
 if(simpsonflag)
	{faktor=(xf[npkt]-xf[0])/3./npkt; plot(xstart= *xf,sum,PENUP); i0=0;}
 else	{faktor=0.5; plot(xstart= *xf++,sum,PENUP); y0= *yf++; i0=1;}
 for(x0=xstart,i=i0;i<=npkt;i++,x0=x,y0=y)
   {x= *xf++; y= *yf++;
    if(simpsonflag)
	{y1=y*faktor;
	 dsimp=simp;
	 if(i>=npkt-1) /* Spezialbehandlung der Endpunkte */
		{if(i==npkt) {if(--simp==3) dsimp=1.5; else dsimp=1.;}
	         else if(simp==2) {dsimp=2.5;}
		}
	 if(simp<4 && i>i0) plot(x,i==npkt?sum+y1*dsimp:sum+y1,PENDOWN);
	 simp=(simp==4)?2:4;
	 sum+=y1*dsimp;
	}
    else
	{y1=(y+y0)*faktor;
	 sum+=y1*(x-x0);
	 plot(x,sum,PENDOWN);
	}
   }
 mycolor(WEISS);
/* jetzt noch Beschriftungen: */
 integral_beschriftung(sum,xstart,x);
 return sum;
}
void integral_beschriftung(double integralwert,double xstart,double xende)
{
 double x,y,xstep,ystep;
 deltakoordpix2user(bux/2,buy*3/2,&xstep,&ystep);
 if(xnull<(xmax-xmin)/3.) x=xnull; else x=xmin;
 y=ymax-ystep;
 if(ger.steig>0.)
	{x+=xstep;}
 else	{x=(xmax+xmin)/2.;}
 itextsize(bux,buy,NULL);
 if(titeltext_gesetzt)
	{schrift2f(x,y,titeltext); y-=ystep;}
 schrift2f(x,y,"Integral von %lg bis %lg = %lg",xstart,xende,integralwert);
 y-=ystep;
}

void term_refresh_check(int err)
{
 char str[80];
 term_refresh();
 switch(err)
  {case 0: return;
   CASE ERR_INTNUM:
	error("zum Integrieren werden \nmindestens 3 Messpunkte gebraucht");
   CASE ERR_INTSIMP:
	error("Integration nach Simpson geht nur \n\
mit konstantem Abstand der Messpunkte");//provi.
  DEFAULT:	sprintf(str,"ERROR %ld\n",(long)error);
		error(str);
  }
}

#endif /* else OHNEINTEGRAL */

/*************************** kleinkram ***************************/
/* schon in xtekplot1.cc:
void stradd(const char *s,const char *t,char *z)        //  s + t --> z
{
 char c;
 while (c = *s++) *z++ = c;
 while (*z++ = *t++)    ;
}
*/

int hatpunkt(char *name,int c)
{
 int c2;
 while(c2= *name++) if(c2==c) return 1;
 return 0;
}
void ohnepunkt(char *name)
{
 int c;
 for(;c= *name;name++)  if(c=='.') {*name=0; return;}
}

void error(const char *s)
{
 janeinrequester(s,"ok");
}

int fastgleich(double x,double y,double diff)
{
 double d;
 if(diff<0.) diff= -diff;
 if(x>y) d=x-y; else d=y-x;
 return (d<diff);
}

double xhochn(double x,int n)   /* Potenzieren mit Ganzzahligem Exponenten */
{
 double z=1.0;
 if(n>=0)
   while(n>0)
        {if(n&1) {z*=x; n--;}
         else    {x*=x; n=(n>>1);}
        }
 else
        z=1.0/xhochn(x,-n);
 return z;
}

/*********** neu ab Version 0.3 *************/
typedef double DOUBFUNK(double);
typedef DOUBFUNK *FUNKZEIGER;
#define MAXPOLYN 20

class _funk_params
{
public:
 double x0,aj[MAXPOLYN];
 int n;
 _funk_params() {n=0; x0=0.0; for(int i=0;i<MAXPOLYN;i++) aj[i]=0.0;}
};

static _funk_params funk_params,alte_params;
static double anpass_delta=1e-8,dt=0.1;
static double exp_chiq=0.;
static int anpass_imax=100,anpass_stark=1,anpass_mitx0=0,anpass_testprint=0,
	   nfu=0;
static double anpass_vgrenze=0.01; //Abbruch bei weniger als 1% Verbesserung

#define N1 funk_params.n
#define AJ funk_params.aj
#define X0 funk_params.x0
#define Y0 funk_params.aj[2]
#define A1 funk_params.aj[0]
#define A2 funk_params.aj[1]
#define A3 funk_params.aj[3]
#define A4 funk_params.aj[4]

void anpassung_machen(double *hf0,FUNKZEIGER funktion);
void anpassung_exp(int npkt,double *xfeld,double *yfeld,double *y0,int nfu);

void ausglexp(int nfu1)
{
 double k2,k4,vgrenze,T1,T2;
 int ok=1;
 nfu=nfu1;
 if(nfu==1) //y=k1*exp(-k2*x) + y0
  {if(N1==0) {A1=1.0; Y0=0.0; A2= -0.1; X0=0.0;}
   N1=3; k2= -A2;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(10,
	" Startwert k1 ","%lg","%lf",&A1,
	" Endwert Y0 ","%lg","%lf\n",&Y0,
	" Anfangskonstante k2 ","%lg","%lf",&k2,
	" Startwert X0 ","%lg","%lf\n",&X0,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" anpass_mitx0 (0 oder 1) ","%d","%d\n",&anpass_mitx0,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
  }
 else if(nfu==2) //y=k1*exp(-k2*x)
  {if(N1==0) {A1=1.0; Y0=0.0; A2= -0.1; X0=0.0;}
   N1=2; k2= -A2;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(8,
	" Startwert k1 ","%lg","%lf\n",&A1,
	" Anfangskonstante k2 ","%lg","%lf",&k2,
	" Startwert X0 ","%lg","%lf\n",&X0,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 else if(nfu==3) //y=k1*exp(-k2*x)-k1
  {if(N1==0) {A1= -1.0; Y0=0.0; A2= -0.1; X0=0.0;}
   N1=2; k2= -A2;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(8,
	" Startwert k1 ","%lg","%lf\n",&A1,
	" Anfangskonstante k2 ","%lg","%lf",&k2,
	" Startwert X0 ","%lg","%lf\n",&X0,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 else if(nfu==9) //U'=Y0+c1*exp(-t/Tau)-c3*U  c3=1/RC
  {if(N1==0) {A1=1.0; Y0=0.0; k2=100; A2= -1/k2; X0=0.0; dt=0.5;}
   N1=3;
   k2= -1/A2;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(8,
	" Startwert c1 ","%lg","%lf\n",&A1,
	" Anfangskonstante Tau ","%lg","%lf",&k2,
	" Startwert Y0 ","%lg","%lf\n",&Y0,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1...3) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   A2= -1/k2;
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 else if(nfu==10) //U'=c1*exp(-t/Tau)+c2*exp(-t/Tau2)-c3*U  c3=1/RC
  {if(N1==0) {A1=1.0; Y0=0.0; k2=100;A2= -1/k2; A3=1.0; k4=20;A4= -1/k4; X0=0.0; dt=0.5;}
   N1=5;
   k2= -1/A2; k4= -1/A4;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(10,
	" Startwert c1 ","%lg","%lf",&A1,
	" Anfangskonstante Tau ","%lg","%lf\n",&k2,
	" Startwert c2 ","%lg","%lf",&A3,
	" Anfangskonstante Tau2 ","%lg","%lf\n",&k4,
	" Startwert Y0 ","%lg","%lf\n",&Y0,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1...3) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   A2= -1/k2; A4= -1/k4;
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 else if(nfu==8) //Berke-Fit-Funktion
  {if(N1==0) {A1= 1.0; A2= 0.1; A3= -0.82; A4=0.05;}
   N1=2;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(9,
	" Startwert K ","%lg","%lf",&A1,
	" Startwert d2 ","%lg","%lf\n",&A2,
	" Konstante d1 ","%lf","%lf",&A3,
	" Konstante re ","%lf","%lf\n",&A4,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 else if(nfu==11) //Polynom-Fit-Funktion
  {if(N1==0)
    {funk_params.aj[0]= 1.0; funk_params.aj[1]= 0.1; funk_params.aj[2]= 0.1;
     N1=2; X0=0.0;
    }
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(11,
	" Nmax ","%d","%d",&N1, " X0 ","%lg","%lf\n",&X0,
	" A0 ","%lg","%lf",&funk_params.aj[0],
	" A1 ","%lg","%lf\n",&funk_params.aj[1],
	" A2 ","%lf","%lf",&funk_params.aj[2],
	" A3 ","%lf","%lf\n",&funk_params.aj[3],
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=1;
  }
 else if(nfu==12) //Biexponentialzerfall:  y=k1*exp(-x/T1)+k2*exp(-x/T2)
  {if(N1==0) {A1=1.0; A2=1.0; X0=0.0; A3=0.01; Y0=0.01;}
   else if(N1<4 && N1>=2) {A3= -A2; A2=1.0; X0=0.0; Y0=0.01;}
   N1=4; T1=1/A3; T2=1/Y0;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(9,
	" Startwert k1 ","%lg","%lf",&A1,
	" Anfangskonstante T1 ","%lg","%lf\n",&T1,
	" Startwert k2 ","%lg","%lf",&A2,
	" Anfangskonstante T2 ","%lg","%lf\n",&T2,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   A3=1/T1; Y0=1/T2;
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 else if(nfu==13) //y=k1*exp(-k2*x^2) + y0  [Gauss-Funktion]
  {if(N1==0) {A1=1.0; Y0=0.0; A2=1.0; X0=0.0; anpass_mitx0=1;}
   N1=3;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(10,
	" Startwert k1 (= ymax-y0)","%lg","%lf",&A1,
	"    y0        ","%lg","%lf\n",&Y0,
	" Startwert k2 (ca. 1/Breite^2)","%lg","%lf",&A2,
	" Startwert X0 (= Mitte)","%lg","%lf\n",&X0,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" anpass_mitx0 (0 oder 1) ","%d","%d\n",&anpass_mitx0,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
  }
 else if(nfu==14) //y=k1*x^2*exp(-k2*x^2)  [Gauss2: Maxwell-Boltzmann-Verteilung]
  {if(N1==0) {A1=5.18e-5; A2=8.07e-4; Y0=0.0; X0=0.0; anpass_mitx0=0;}
   N1=2;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(8,
	" Startwert k1 (4Pi*(m/(2PiKbT))^(3/2))","%lg","%lf",&A1,
	" Startwert k2 (m/(2KbT))","%lg","%lf",&A2,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" anpass_mitx0 (0 oder 1) ","%d","%d\n",&anpass_mitx0,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
  }
 else //if(nfu==4) //Diffgleichung: A'= -k1*A  B'=k2*A-k3*B  nach B aufloesen.
      //if(nfu==5) //Diffgleichung: A'= -k1*A  B'=k2*A-C'  C'=k3*B nach C aufl.
      //if(nfu==7) //Diffgleichung: A->C+B->2C->D  nach C geloest
  {if(N1==0) {Y0=1.0; A1=0.002; A2=0.0016; A3=0.0001; dt=0.5;}
   N1=4;
   vgrenze=anpass_vgrenze*100.;
   if(!autoflag)
    ok=requester_input(10,
	" Startwert k1 ","%lg","%lf",&A1, " Startwert k2 ","%lg","%lf\n",&A2,
	" Startwert k3 ","%lg","%lf\n",&A3,
	" Y0 ","%lg","%lf",&Y0,		  " dt ","%lf","%lf\n",&dt,
	" anpass_delta ","%lg","%lf",&anpass_delta,
	" anpass_imax ","%d","%d\n",&anpass_imax,
	" anpass_stark (0, 1 oder 2) ","%d","%d",&anpass_stark,
	" mit Testausdruck (0 oder 1) ","%d","%d\n",&anpass_testprint,
	" Abbruch bei Chiquadrat-Verbesserung kleiner ",
		      "%.2lf %%","%lf",&vgrenze);
   anpass_vgrenze=vgrenze/100.;
   anpass_mitx0=0;
  }
 if(ok==0) return;
 if(anpass_testprint) printf("npkt=%d\n",npkt);
 if(nfu<=3) {A2= -k2; /*if(N1==5) A4= -k4;*/}
 double altes_chiq=0.0, verbesserung, y0=ymax;
 inital_new(xmin,ymin,xmax,ymax); screenclear();
 messwerte_darstellen(npkt,xfeld,yfeld);
 term_refresh();
 do {inital_new(xmin,ymin,xmax,ymax);
     anpassung_exp(npkt,xfeld,yfeld,&y0,nfu);
     term_refresh();
     if(altes_chiq==0.0) altes_chiq=2*exp_chiq;
     if(exp_chiq==0.0) break;
     verbesserung=altes_chiq/exp_chiq;
     altes_chiq=exp_chiq;
    }
 while(verbesserung>=1.0+anpass_vgrenze);
 plotstatus = PLOTSTATUS_EXP;
 if(verbesserung>=1.0+anpass_vgrenze/10.0)
  {inital_new(xmin,ymin,xmax,ymax); screenclear();
   messwerte_darstellen(npkt,xfeld,yfeld);
   anpassung_exp(npkt,xfeld,yfeld,NULL,nfu);
   term_refresh();
  }
 else
  myrefresh();
}

const char *formel[]={NULL,"k1*exp(-k2*x)+y0","k1*exp(-k2*x)","k1*exp(-k2*x)-k1",
#ifdef DIFFGL
 "B'=k2*A-k3*B  A'=-k1*A",
 "C'=k3*B  B'=k2*A-C'  A'=-k1*A",
 "Dg: A->B->C nach B geloest",
 "Dg: A->C+B->2C->D  nach C geloest",
 "Berke-Fit-Funktion",
 "U'=c1*e^(-t/T)-U/RC nach U geloest",
 "U'=c1*e^(-t/T)+c2*e^(-t/T2)-U/RC nach U geloest",
#endif
 "Polynom: Summe[An*x^n]",
 "y=k1*exp(-x/T1)+k2*exp(-x/T2)",
 "Gausskurve: y=k1*exp(-k2*(x-x0)^2)+y0",
 "Gausskurve2: y=k1*x^2*exp(-k2*x^2)",
 NULL};
#ifdef DIFFGL
static int formel_ntexte=13;
#else
static int formel_ntexte=6;
#endif

double funk_exp(double x)
{
 double xwert=A2*(x-X0);
 if(xwert>85.1956) return 1e37;
 return A1*exp(xwert)+Y0;
}

double funk_gauss(double x)
{
 double xwert=x-X0;
 xwert= -A2*xwert*xwert;
 if(xwert>85.1956) return 1e37;
 return A1*exp(xwert)+Y0;
}

double funk_gauss2(double x)
{
 double x2=x*x;
 double xwert= -A2*x2;
 if(xwert>85.1956) return 1e37;
 return A1*x2*exp(xwert);
}

double funk_exp2(double x)
{
 double xwert=A2*x;
 if(xwert>85.1956) return 1e37;
 return A1*exp(xwert);
}
double funk_exp3(double x)
{
 double xwert=A2*(x-X0);
 if(xwert>85.1956) return 1e37;
 return A1*exp(xwert)-A1;
}
double funk_exp4(double x)
{
 const double xwmax=85.1956;
 double x1= -x*A3, x2= -x*Y0;
 if(x1>xwmax || x2>xwmax) return 1e37;
 return A1*exp(x1)+A2*exp(x2);
}

double funk_dg1(double x)
{
// double a=1.0,b=0.0,A1dt=A1*dt,A2dt=A2*dt,A3dt=A3*dt;
 double a=Y0,b=0.0,A1dt=A1*dt,A2dt=A2*dt,A3dt=A3*dt;
 int i=int(x/dt+0.5);
 while(--i>=0)
   {a -= a*A1dt;
    b += A2dt*a-A3dt*b;
    if(b>1e37 || b < -1e37) return b;
   }
 return b;
}

double funk_dg2(double x)
{
 double a=Y0,b=0.0,A1dt=A1*dt,A2dt=A2*dt,A3dt=A3*dt,c=0.0,cstrich;
 int i=int(x/dt+0.5);
 while(--i>=0)
   {a -= a*A1dt;
    b += A2dt*a-(cstrich=A3dt*b);
    c += cstrich;
    if(c>1e37 || c < -1e37) break;
   }
 return c;
}
double funk_dg3(double x)
{
 double a=Y0,b=0.0,A1dt=A1*dt,A2dt=A2*dt;
 int i=int(x/dt+0.5);
 while(--i>=0)
   {a -= a*A1dt;
    b += A1dt*a-A2dt*b;
    if(b>1e37 || b < -1e37) return b;
   }
 return b;
}
double funk_dg4(double x)
{
 double a=Y0,b=0.0,A1dt=A1*dt,A2dt=A2*dt,A3dt=A3*dt,
	c=0.0,astrich,h2;
 int i=int(x/dt+0.5);
 while(--i>=0)
   {a -= (astrich=a*A1dt);
    b += astrich-(h2=A2dt*b);
//    c2 += (c2strich=h2-A3dt*c2);
//    c += astrich+c2strich;
    c += astrich+h2-A3dt*c;
    if(c>1e37 || c < -1e37) break;
   }
 return c;
}
double funk_dg5(double x)
{ //Berke-Funktion
 double k=A1, d2=A2, d1=A3, re=A4;
 double y,a,wu,kx=k*x;
 a=k*re-kx+1.0;
 if((wu=a*a+4*kx)<=0.0) wu= -0.5*a;
 else wu=0.5*(sqrt(wu)-a);
 y=(d1+d2*wu)/(1.0+wu);
 return y;
}
double funk_dg6(double x)
{ //U'=c1*exp(-t/tau)-c3*U   mit c3=1/RC
 double c1=A1, tau= -1/A2, c3=1.0/22; //c3=1.0/A3;
 double u=Y0,t=0;
 double c1dt=c1*dt,c3dt=c3*dt;
 int i=int(x/dt+0.5);
 while(--i>=0)
   {u += c1dt*exp(-t/tau)-c3dt*u;
    t += dt;
    if(u>1e37 || u < -1e37) break;
   }
 return u;
}
double funk_dg7(double x)
{ //U'=c1*exp(-t/tau)+c2*exp(-t/tau2)-c3*U   mit c3=1/RC
 double c1=A1, tau= -1/A2, c2=A3, tau2= -1/A4;
 double c3=1.0/22; //RC-Glied: 22usec
 double u=Y0,t=0;
 double c1dt=c1*dt,c2dt=c2*dt,c3dt=c3*dt;
 int i=int(x/dt+0.5);
 while(--i>=0)
   {u += c1dt*exp(-t/tau)+c2dt*exp(-t/tau2)-c3dt*u;
    t += dt;
    if(u>1e37 || u < -1e37) break;
   }
 return u;
}

double funk_poly(double x)
{ //Polynom
 int i; double y,xw=(x-X0);
 y=funk_params.aj[0];
 for(i=1;i<=N1;i++)
   y += funk_params.aj[i]*xhochn(xw,i);
 return y;
}

void kurvezeichnen(FUNKZEIGER fun)
{
 double x,dx=(xmax-xmin)/NX;
 int pen=PENUP;
 for(x=xmin;x<=xmax;x+=dx)
	{plot(x,(*fun)(x),pen); pen=PENDOWN;}
}

void anpassung_exp(int npkt,double *xfeld,double *yfeld,double *y0,int nfu)
{
 int i;
 double *h, *hf0=new double[npkt*2];
 for(npkta=0,i=0,h=hf0;i<npkt;i++)
   if(kfeld[i]==0) {*h++ = xfeld[i]; *h++ = yfeld[i]; npkta++;}
 if(nfu==1) anpassung_machen(hf0,funk_exp);
 else if(nfu==2) anpassung_machen(hf0,funk_exp2);
 else if(nfu==3) anpassung_machen(hf0,funk_exp3);
 else if(nfu==4)  anpassung_machen(hf0,funk_dg1);
 else if(nfu==5)  anpassung_machen(hf0,funk_dg2);
 else if(nfu==6)  anpassung_machen(hf0,funk_dg3);
 else if(nfu==8)  anpassung_machen(hf0,funk_dg5);
 else if(nfu==9)  anpassung_machen(hf0,funk_dg6);
 else if(nfu==10) anpassung_machen(hf0,funk_dg7);
 else if(nfu==11) anpassung_machen(hf0,funk_poly);
 else if(nfu==12) anpassung_machen(hf0,funk_exp4);
 else if(nfu==13) anpassung_machen(hf0,funk_gauss);
 else if(nfu==14) anpassung_machen(hf0,funk_gauss2);
 else  anpassung_machen(hf0,funk_dg4);
 delete hf0;
 exp_funktion_zeichnen(y0);
}

void exp_funktion_zeichnen(double *y0)
{
 double x,y,xstep,ystep;
 deltakoordpix2user(bux/2,buy*3/2,&xstep,&ystep); itextsize(bux,buy,NULL);
 y=(ymax+ymin)/2; x=(xmax+xmin)/2;
 if(nfu==1) kurvezeichnen(funk_exp);
 else if(nfu==2) kurvezeichnen(funk_exp2);
 else if(nfu==3) kurvezeichnen(funk_exp3);
 else if(nfu==4) kurvezeichnen(funk_dg1);
 else if(nfu==5) kurvezeichnen(funk_dg2);
 else if(nfu==6) kurvezeichnen(funk_dg3);
 else if(nfu==8) kurvezeichnen(funk_dg5);
 else if(nfu==9) kurvezeichnen(funk_dg6);
 else if(nfu==10) kurvezeichnen(funk_dg7);
 else if(nfu==11) kurvezeichnen(funk_poly);
 else if(nfu==12) kurvezeichnen(funk_exp4);
 else if(nfu==13) kurvezeichnen(funk_gauss);
 else if(nfu==14) kurvezeichnen(funk_gauss2);
 else  kurvezeichnen(funk_dg4);
 if(titeltext_gesetzt) {schrift2f(x,y,titeltext); y-=ystep;}
 if(nfu<=formel_ntexte && formel[nfu]!=NULL)
   {schrift2f(x,y,formel[nfu]); y-=ystep;}
 if(nfu<=3)
 {if(y0!=NULL)
  {schrift2f(x,*y0 -= ystep,"k2=%lg  chi^2 = %lg",-A2,exp_chiq);}
  else
  {schrift2f(x,y-=ystep,"k1 = %lf  k2 = %lg",A1,-A2);
   if(N1==2)
	 {if(nfu!=3) schrift2f(x,y-=ystep," A = %lf",funk_exp2(X0));}
   else	 schrift2f(x,y-=ystep," A = %lf  Y0 = %lf",funk_exp(X0),Y0);
   schrift2f(x,y-=ystep,"chi^2 = %lg",exp_chiq);
  }
 }
 else if(nfu<=5)
 {if(y0!=NULL)
  {schrift2f(x,*y0 -= ystep,"k2=%lg k3=%lg chi^2 = %lg",A2,A3,exp_chiq);}
  else
  {schrift2f(x,y-=ystep,"k1 = %lg  k2 = %lg",A1,A2);
   schrift2f(x,y-=ystep,"k3 = %lg",A3);
   if(nfu==4)
     schrift2f(x,y-=ystep," A = %lf  Y0 = %lf",funk_dg1(0.0),Y0);
   else
     schrift2f(x,y-=ystep," A = %lf  Y0 = %lf",funk_dg2(0.0),Y0);
   schrift2f(x,y-=ystep,"chi^2 = %lg",exp_chiq);
  }
 }
 else if(nfu==9 || nfu==10)
   {schrift2f(x,y-=ystep,"Y0 = %lg",Y0);
    schrift2f(x,y-=ystep,"c1 = %lg  Tau = %lg",A1,-1/A2);
    if(nfu==10)
      schrift2f(x,y-=ystep,"c2 = %lg  Tau2 = %lg",A3,-1/A4);
    schrift2f(x,y-=ystep,"RC = %lg usec (alle Zeiten in Microsec.)",22);
    schrift2f(x,y-=ystep,"chi^2 = %lg",exp_chiq);
   }
 else if(nfu==11)
 {if(y0!=NULL)
  {schrift1d2f(x,*y0 -= ystep,"N=%ld a0=%lg chi^2 = %lg",
	     (long)N1,funk_params.aj[0],exp_chiq);}
  else
  {for(int i=0;i<N1;i++)
    schrift1d2f(x,y-=ystep,"a%d = %lg",i,funk_params.aj[i]);
   schrift2f(x,y-=ystep,"X0 = %lg  chi^2 = %lg",X0,exp_chiq);
  }
 }
 else if(nfu==12)
 {if(y0!=NULL)
  {schrift2f(x,*y0 -= ystep,"T1=%lg T2=%lg  chi^2 = %lg",
	     1/A3,1/Y0,exp_chiq);
  }
  else
  {schrift2f(x,y-=ystep,"k1=%lf T1=%lg",A1,1/A3);
   schrift2f(x,y-=ystep,"k2=%lf T2=%lg",A2,1/Y0);
   schrift2f(x,y-=ystep," A = %lf",funk_exp4(X0));
   schrift2f(x,y-=ystep,"chi^2 = %lg",exp_chiq);
  }
 }
 else if(nfu==13)
 {if(y0!=NULL)
  {schrift2f(x,*y0 -= ystep,"k1=%lf  k2=%lg  chi^2 = %lg",A1,A2,exp_chiq);}
  else
  {schrift2f(x,y-=ystep,"k1 = %lf  k2 = %lg",A1,A2);
   schrift2f(x,y-=ystep,"X0 = %lf  Y0 = %lf",X0,Y0);
   schrift2f(x,y-=ystep,"chi^2 = %lg",exp_chiq);
  }
 }
 else //if(nfu==8 || nfu==7)
 {schrift2f(x,y-=ystep,"k1 = %lg  k2 = %lg",A1,A2);
  if(nfu==6)
     {schrift2f(x,y-=ystep," A = %lf  Y0 = %lf",funk_dg3(0.0),Y0);
     }
  else
     {schrift2f(x,y-=ystep,"k3 = %lg",A3);
      schrift2f(x,y-=ystep," A = %lf  Y0 = %lf",funk_dg3(0.0),Y0);
     }
  schrift2f(x,y-=ystep,"chi^2 = %lg",exp_chiq);
 }
}

/****************** Anpassungsalgorythmus aus uvshow.c *****************/
#ifdef VAX_OR_ALPHA
double random2()         /* Zufallszahl zwischen -1. und 1. */
{
 return (1. - rand()/1073741824.);
}
#endif
#ifdef unix
#define random random01
inline double random()        // Zufallszahl zwischen 0. und 1.
{
 return (1. - rand()/(double)RAND_MAX);
}
inline double random2()        // Zufallszahl zwischen -1. und 1.
{
 return (1.0 - rand()/(RAND_MAX/2.0));
}
#endif

void parameter_aendern(double delta)
{
 int j;
 alte_params.x0=X0;
 if(anpass_mitx0) X0 += random2()*delta;
 for(j=0;j<N1;j++)
	{alte_params.aj[j]=AJ[j];
	 AJ[j] += random2()*delta;
	}
}
/** nicht unbedingt noetig: **/
void ein_parameter_aendern(double delta)
{
 int j;
 alte_params.x0=X0; 
 for(j=0;j<N1;j++) alte_params.aj[j]=AJ[j];
 if(anpass_mitx0)
   j=int(random()*(N1+0.9999)); //Zufallszahl zwischen 0 und N1 (mit Grenzen)
 else j=int(random()*(N1-0.0001));
 if(j==N1)	X0 += random2()*delta;
 else		AJ[j] += random2()*delta;
}
void parameter_einzel_aendern(int j,double delta)
{
 int i;
 alte_params.x0=X0; 
 for(i=0;i<N1;i++) alte_params.aj[i]=AJ[i];
 if(random()<0.5)
  {if(j==N1)	X0 += random2()*delta;
   else		AJ[j] += random2()*delta;
  }
 else
  {if(j==N1)	X0 *= 1.0+random2()*delta;
   else		AJ[j] *= 1.0+random2()*delta;
  }
}
/**/
void parameter_stark_aendern(double delta)
{
 int j;
 alte_params.x0=X0;
 if(anpass_mitx0) X0 *= 1.+random2()*delta;
 for(j=0;j<N1;j++)
	{alte_params.aj[j]=AJ[j];
	 AJ[j] *= 1.+random2()*delta;
	}
}
void parameter_zurueck()
{
 int j;
 X0=alte_params.x0;
 for(j=0;j<N1;j++) AJ[j]=alte_params.aj[j];
}
void parameter_testausdruck(double chiq=0.0)
{
 int j;
 if(anpass_mitx0) printf(" X0=%lg  ",X0);
 for(j=0;j<N1;j++) printf("A%d=%lg  ",j,AJ[j]);
 if(chiq!=0.0) printf("chiq=%lg",chiq);
 printf("\n");
}

double chiquadrat(double *hf0,FUNKZEIGER funktion)
{
 double chiq=0.,chi,x,y;
 for(int i=0;i<npkta;i++)
	{x= *hf0++; y= *hf0++;
	 chi=y-(*funktion)(x);
	 chiq += chi*chi;
	 if(chiq>1e74) return chiq;
	}
 return chiq;
}

void anpassung_machen(double *hf0,FUNKZEIGER funktion)
{
 int i,besser,para,paramax;
 int j,jj=0,jjmax=10+anpass_stark*10;
 double abweichung,abw2,delta;
 static int jap=0;
/*
  funk_params irgendwie anpassen so dass (*funktion)(x) mglichst gut
  mit hf0[] bereinstimmt
*/
 paramax=N1; if(anpass_mitx0) paramax++;
 abweichung=chiquadrat(hf0,funktion);
 if(anpass_testprint)
   {printf("vor %d.Anpassung:",++jap); parameter_testausdruck(abweichung);}
 else jap=0;
 while(++jj<jjmax)
 {if(anpass_testprint>1) printf("Durchlauf %d von %d\n",jj,jjmax);
  if(anpass_stark)
   {do for(besser=0,delta=1.;delta>=anpass_delta;delta/=2.)
	{parameter_stark_aendern(delta);
	 abw2=chiquadrat(hf0,funktion);
	 if(abw2>=abweichung) {parameter_zurueck();}
	 else	{abweichung=abw2; besser++;}
	}
    while(besser && ++jj<jjmax);
   }
  do
  {for(besser=0,delta=1.,j=0;delta>=anpass_delta;delta/=2.,j++)
    {if(anpass_testprint>2)
      printf("innere Schlaufe: j=%d delta=%lf anpass_delta=%lf\n",j,delta,anpass_delta);
     for(i=0;i<anpass_imax;i++)
	{parameter_aendern(delta); abw2=chiquadrat(hf0,funktion);
	 if(abw2>=abweichung)
	   {parameter_zurueck();
	    ein_parameter_aendern(delta); abw2=chiquadrat(hf0,funktion);
	   }
	 if(abw2>=abweichung) {parameter_zurueck();}
	 else	{abweichung=abw2; besser=1;}
	}
    }
  } while(besser && ++jj<jjmax);
/** nicht unbedingt noetig: **/
  if(anpass_stark>=2)
   for(para=0;para<paramax;para++)
    do
     {for(besser=0,delta=1.;delta>=anpass_delta;delta/=2.)
	{for(i=0;i<anpass_imax;i++)
	   {parameter_einzel_aendern(para,delta);
	    abw2=chiquadrat(hf0,funktion);
	    if(abw2>=abweichung) {parameter_zurueck();}
	    else {abweichung=abw2; besser=1;}
	   }
	}
     } while(besser && ++jj<jjmax);
/**/
 }
 if(anpass_testprint)
   {printf("nach %d.Anpassung:",jap); parameter_testausdruck(abweichung);}
 exp_chiq=abweichung;
}

/** uvshow-Version:
void anpassung_machen(double *hf0,double *hf,FUNKZEIGER funktion)
{
....
 for(i=0,x=kopf.ende*0.001,dx=kopf.delta*0.001;i<npkt;i++,x+=dx)
		hf[i]=(*funktion)(x);
}
double chiquadrat(double *hf0,FUNKZEIGER funktion)
{
 double chiq=0.,chi,x,y,dx;
 int i;
 for(i=0,x=kopf.ende*0.001,dx=kopf.delta*0.001;i<npkt;i++,x+=dx)
// for(i=0,x=xkstart,dx=xkdelta;i<NPKT;i++,x+=dx)
   if((y= *hf0++)!=0.)
	{chi=y-(*funktion)(x);
	 chiq += chi*chi;
	}
 return chiq;
}
**/
