/* spline.cc			letzte nderung: 6.5.2002 */
#define VERSION "Version 0.3"
/*
 Kurzbeschreibung: Testen der Formeln fr Spline-Kurven

History:
26.4.2002	Erstellung (RP)
30.4.2002	Daten von Datei einlesen, N(k,t,v) optimiert
6.5.		Parabelanpassung
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <xtekplot1.h>
#include <vektorklasse.cc>

#define XMAX 640
#define YMAX 512
#define TIEFE 4

/************************** Spline-Klasse *****************************/
class Spline
{
 int np,npmax,n,t;
 vektor *pu;
 void neufeld();
 int u(int k);
 double N(int k,int t,double v);
public:
 Spline() {t=3; pu=NULL; npmax=80; clear();}
 ~Spline() {delete pu;}
 void clear() {np=0; if(pu!=NULL) delete pu; pu=new vektor[npmax];}
 void setord(int i) {t=i;}
 void put(vektor p);
 vektor p(double v);
};
void Spline::neufeld()
{
 vektor* pu2=new vektor[npmax*=2];
 for(int i=0;i<np;i++) pu2[i]=pu[i];
 delete pu;
 pu=pu2;
}
void Spline::put(vektor p)
{
 if(np==npmax) neufeld();
 pu[np++]=p; n=np-1;
}
int Spline::u(int k)
{
 return (k<t) ? 0 : ((k>n) ? n-t+2 : k-t+1);
}
double Spline::N(int k,int t,double v)
{
/** rekursive Variante (elegant aber langsam) **
 if(t==1) {return (u(k)<=v && v<u(k+1)) ? 1.0 : 0.0;}
 int teiler1,teiler2; double wert1,wert2;
 teiler1=u(k+t-1)-u(k); teiler2=u(k+t)-u(k+1);
 wert1 = (teiler1==0) ? 0.0 : (v-u(k))/teiler1*N(k,t-1,v);
 wert2 = (teiler2==0) ? 0.0 : (u(k+t)-v)/teiler2*N(k+1,t-1,v);
 return wert1+wert2;
** Schleifen-Variante (schnell aber unuebersichtlich) **/
 int ti,ki,k2=k+(t-1), kt=k+t, teiler1,teiler2;
 double wert; double* nkt=new double[kt*t];
 for(ki=0;ki<=k2;ki++)
   {nkt[ki]=(u(ki)<=v && v<u(ki+1)) ? 1.0 : 0.0;}
 for(ti=2;ti<=t;ti++)
 {--k2;
  for(ki=0;ki<=k2;ki++)
   {teiler1=u(ki+ti-1)-u(ki); teiler2=u(ki+ti)-u(ki+1);
    wert = ((teiler1==0) ? 0.0 : (v-u(ki))/teiler1*nkt[ki+(ti-2)*kt])
         + ((teiler2==0) ? 0.0 : (u(ki+ti)-v)/teiler2*nkt[ki+1+(ti-2)*kt]);
    nkt[ki+(ti-1)*kt]=wert;
   }
 }
 delete nkt;
 return wert;
/**/
}
vektor Spline::p(double v)
{
 vektor pv(0);
 for(int k=0;k<=n;k++)  {pv += pu[k]*N(k,t,v);}
 return pv;
}

/************************* Vordeklarationen ***************************/
void splinekurve(int n,int t);
void parabelkurve(int n);

/***************************** Optionen *******************************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Men Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void m_spline(),m_parabel(),m_vparabel(),m_clear();

/************************* Hauptprogramm ******************************/
static double *px,*py;
static int splineord=4,nn=0;

void usage(const char *s=" ")
{
 if(*s!=' ') printf("Error: %s\n",s);
 printf("Anwendung: spline [-flags] [Name.dat] [ord]\n");
 printf(" flags: s=Spline (voreingestellt)\n");
 printf("        p=Parabelanpassung\n");
 printf("        v=Parabel-Variante mit Virtueller x-Achse\n");
 printf(" ord=SplineOrdnung (meist 3 bis 4)\n");
 exit(0);
}

int main(int argc,char *argv[])
{
 FILE *fp;
 char filename[80];
 int c,i,j,breite,hoehe,tiefe,visklasse,ok,n;
 double xmin= -1.0,ymin=0.0,xmax=11.0,ymax=10.0;
 filename[0]=0;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(filename,argv[i]);
		 else if(j==2) sscanf(argv[i],"%d",&splineord);
	}	}
 if(argflag['?'] || j>MAXARG)
	usage();
 if(filename[0]!=0) //Datei als Parameter angegeben
  {double x,y;
   fp=fopen(filename,"r");
   if(fp==NULL) {printf("Error: '%s' not found\n",filename); return 0;}
   n=0;
   xmin=xmax=ymin=ymax=0.0;
   while(fscanf(fp,"%lf%*c%lf",&x,&y)==2)
     {n++;
      if(x<xmin) xmin=x; else if(x>xmax) xmax=x;
      if(y<ymin) ymin=y; else if(y>ymax) ymax=y;
     }
   fclose(fp);
   px=new double[n]; py=new double[n];
   fp=fopen(filename,"r");
   for(int i=0;i<n;i++)
     {fscanf(fp,"%lf%*c%lf",&px[i],&py[i]);}
   fclose(fp);
   --n;
  }
 else //keine Parameter angegeben
  {//Beispielpunkte direkt hier:
   double x[]={1.7, 2.8, 5.3, 6.45, 8.2};
   double y[]={5.0, 3.2, 7.8, 5.2,  4.9};
   n=sizeof(x)/sizeof(double);
   px=new double[n]; py=new double[n];
   for(int i=0;i<n;i++) {px[i]=x[i]; py[i]=y[i];}
   --n;
  }
 nn=n;
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 setsize(XMAX,YMAX,tiefe);
 setmenu(2,"File","Kurve");
 setmenu(2,"Exit","Spline",&menu_exit,&m_spline);
 setmenu(2,NULL,  "Parabel",NULL,m_parabel);
 setmenu(2,NULL,  "Virtuelle Parabel",NULL,m_vparabel);
 setmenu(2,NULL,  "Bild loeschen",NULL,m_clear);
 if(argflag['P'] || argflag['V'])
   {double dy=ymax-ymin;
    ymin -= dy/8; ymax += dy/8;
   }
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 if(argflag['P'] || argflag['V'])
   parabelkurve(n);
 else
   splinekurve(n,splineord);
 term_refresh();
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
 term_exit();
 return 0;
}/* ende von main */

void splinekurve(int n,int t)
{
 int pen=PENUP,i;
 double v,vmax,dv;
 vektor p;
 Spline spline;
 spline.setord(t);
 for(i=0;i<=n;i++)
   {p.x=px[i]; p.y=py[i]; spline.put(p);}
 color(2);
 for(i=0;i<=n;i++)
   {plot(px[i],py[i],pen); pen=PENDOWN;}
 color(1);
 pen=PENUP;
 vmax=n-t+2;
 dv=vmax/500;
 for(v=0;v<vmax;v+=dv)
   {p=spline.p(v);
    plot(p.x,p.y,pen); pen=PENDOWN;
   }
 plot(px[n],py[n],pen);
}

/************************** Parab-Klasse *****************************/
class Parab
{
 int np,npmax,n;
 vektor *pu;
 void neufeld();
 void p1(vektor& pv,int k1,double v);
 void q1(vektor& pv,int k1,double v);
public:
 Parab() {pu=NULL; npmax=80; clear();}
 ~Parab() {delete pu;}
 void clear() {np=0; if(pu!=NULL) delete pu; pu=new vektor[npmax];}
// void setord(int i) {t=i;}
 void put(vektor p);
 vektor p(double v);
 vektor q(double v);
};
void Parab::neufeld()
{
 vektor* pu2=new vektor[npmax*=2];
 for(int i=0;i<np;i++) pu2[i]=pu[i];
 delete pu;
 pu=pu2;
}
void Parab::put(vektor p)
{
 if(np==npmax) neufeld();
 pu[np++]=p; n=np-1;
}
void Parab::p1(vektor& pv,int k1,double v)
{
 // vektor pv;
 double x1,y1,x2,y2,x3,y3,a,b,c,e;
 int k2=k1+1,k3=k1+2;
 x1=pu[k1].x; y1=pu[k1].y;
 x2=pu[k2].x; y2=pu[k2].y;
 x3=pu[k3].x; y3=pu[k3].y;
 e=(x3-x1)/(x2-x1);
 a=(y3-(y2-y1)*e-y1)/(x3*x3-x1*x1-(x2*x2-x1*x1)*e);
 b=(y2-a*(x2*x2-x1*x1)-y1)/(x2-x1);
 c=y1-a*x1*x1-b*x1;
 if(v<k2)
   pv.x=pu[k1].x+(pu[k2].x-pu[k1].x)*(v-k1);
 else
   pv.x=pu[k2].x+(pu[k3].x-pu[k2].x)*(v-k2);
 pv.y=a*pv.x*pv.x+b*pv.x+c;
}
vektor Parab::p(double v)
{
 vektor pv,pv1,pv2;
 int k1,k2,k3;
 // static int test=0;
 // if(v<1) {k1=0; test=0;}
 if(v<1) k1=0;
 else  k1 = int(v-1.0);
 if(k1>n-2) k1=n-2;
 k2=k1+1; k3=k1+2;
 // if(k1>test) {test=k1; color(test+1);}
 p1(pv1,k1,v);
 if(v>k2 && k1<n-2)
   {p1(pv2,k2,v);
    pv=(k3-v)*pv1+(v-k2)*pv2;
   }
 else pv=pv1;
 return pv;
}

void Parab::q1(vektor& pv,int k1,double v)
{
 // v fungiert hier als Virtuelle x-Achse im Bereich k1 bis k3
 vektor a,b,c;
 double x1,x2,x3,y1,y2,y3,e;
 int k2=k1+1,k3=k1+2;
 x1=pu[k1].x; y1=pu[k1].y;
 x2=pu[k2].x; y2=pu[k2].y;
 x3=pu[k3].x; y3=pu[k3].y;
 e=(k3-k1)/double(k2-k1);
 a.y=(y3-(y2-y1)*e-y1)/(k3*k3-k1*k1-(k2*k2-k1*k1)*e);
 b.y=(y2-a.y*(k2*k2-k1*k1)-y1)/(k2-k1);
 c.y=y1-a.y*k1*k1-b.y*k1;
 a.x=(x3-(x2-x1)*e-x1)/(k3*k3-k1*k1-(k2*k2-k1*k1)*e);
 b.x=(x2-a.x*(k2*k2-k1*k1)-x1)/(k2-k1);
 c.x=x1-a.x*k1*k1-b.x*k1;
 pv=a*(v*v)+b*v+c;
}
vektor Parab::q(double v)
{
 vektor pv,pv1,pv2;
 int k1,k2,k3;
 //static int test=0;
 //if(v<1) {k1=0; test=0;}
 if(v<1) {k1=0;}
 else  k1 = int(v-1.0);
 if(k1>n-2) k1=n-2;
 k2=k1+1; k3=k1+2;
 // if(k1>test) {test=k1; color(test+1);}
 q1(pv1,k1,v);
 if(v>k2 && k1<n-2)
   {q1(pv2,k2,v);
    pv=(k3-v)*pv1+(v-k2)*pv2;
   }
 else pv=pv1;
 return pv;
}

void parabelkurve(int n)
{
 int pen=PENUP,i;
 double v,vmax,dv;
 vektor p;
 Parab parab;
 // parab.setord(t);
 for(i=0;i<=n;i++)
   {p.x=px[i]; p.y=py[i]; parab.put(p);}
 color(2);
 for(i=0;i<=n;i++)
   {plot(px[i],py[i],pen); pen=PENDOWN;}
 color(1);
 pen=PENUP;
 vmax=n;
 dv=vmax/1000;
 for(v=0;v<vmax;v+=dv)
   {if(argflag['V'])
      p=parab.q(v);
    else
      p=parab.p(v);
    plot(p.x,p.y,pen); pen=PENDOWN;
   }
 plot(px[n],py[n],pen);
}

void m_spline()
{
 inital_new();
 splinekurve(nn,splineord);
 term_refresh();
}
void m_parabel()
{
 inital_new();
 argflag['P']=1; argflag['V']=0;
 parabelkurve(nn);
 term_refresh();
}
void m_vparabel()
{
 inital_new();
 argflag['P']=0; argflag['V']=1;
 parabelkurve(nn);
 term_refresh();
}
void m_clear()
{
 inital_new(); screenclear(); term_refresh();
}
