/* spline.cc			letzte nderung: 26.4.2002 */
#define VERSION "Version 0.1"
/*
 Kurzbeschreibung: Testen der Formel fr Spline-Kurven

History:
26.4.2002	Erstellung (RP)
*/

#include <stdio.h>
//#include <stream.h>
#include <stdlib.h>
#include <xtekplot1.h>
#include <vektorklasse.cc>

#define XMAX 640
#define YMAX 512
#define TIEFE 4

/************************** Spline-Klasse *****************************/
class Spline
{
 int np,npmax,n,t;
 vektor *pu;
 void neufeld();
 int u(int k);
 double N(int k,int t,double v);
public:
 Spline() {t=3; pu=NULL; npmax=80; clear();}
 ~Spline() {delete pu;}
 void clear() {np=0; if(pu!=NULL) delete pu; pu=new vektor[npmax];}
 void setord(int i) {t=i;}
 void put(vektor p);
 vektor p(double v);
};
void Spline::neufeld()
{
 vektor* pu2=new vektor[npmax*=2];
 for(int i=0;i<np;i++) pu2[i]=pu[i];
 delete pu;
 pu=pu2;
}
void Spline::put(vektor p)
{
 if(np==npmax) neufeld();
 pu[np++]=p; n=np-1;
}
int Spline::u(int k)
{
 return (k<t) ? 0 : ((k>n) ? n-t+2 : k-t+1);
}
double Spline::N(int k,int t,double v)
{
 if(t==1) {return (u(k)<=v && v<u(k+1)) ? 1.0 : 0.0;}
 int teiler1,teiler2; double wert1,wert2;
 teiler1=u(k+t-1)-u(k); teiler2=u(k+t)-u(k+1);
 wert1 = (teiler1==0) ? 0.0 : (v-u(k))/teiler1*N(k,t-1,v);
 wert2 = (teiler2==0) ? 0.0 : (u(k+t)-v)/teiler2*N(k+1,t-1,v);
 return wert1+wert2;
}
vektor Spline::p(double v)
{
 vektor pv(0);
 for(int k=0;k<=n;k++)  {pv += pu[k]*N(k,t,v);}
 return pv;
}

/************************* Vordeklarationen ***************************/
void splinekurve();

/************************* Men Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 int col=0;
 int breite,hoehe,tiefe,visklasse;
 double xmin= -1.0,ymin=0.0,xmax=11.0,ymax=10.0;
 //tek_setdebug(1);//test
 if(argc>1 && *argv[1]=='?')
	{printf("spline  %s\n",VERSION);
	 exit(0);
	}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 //int maxcol=(1<<TIEFE);
 setsize(XMAX,YMAX,tiefe);
 setmenu(1,"File");
 setmenu(1,"Exit",&menu_exit);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 splinekurve();
 term_refresh();
 while(exitflag==0 && waitmenu(1)==0)
	;// auf Benutzereingaben warten
 term_exit();
 return 0;
}/* ende von main */

//Beispielpunkte direkt hier:
static double px[]={1.7, 2.8, 5.3, 6.45, 8.2};
static double py[]={5.0, 3.2, 7.8, 6.5,  4.8};

void splinekurve()
{
 int pen=PENUP,i,n,t=4;
 double v,vmax,dv;
 vektor p;
 Spline spline;
 spline.setord(t);
 n=sizeof(px)/sizeof(double)-1;
 for(i=0;i<=n;i++)
   {p.x=px[i]; p.y=py[i]; spline.put(p);}
 color(2);
 for(i=0;i<=n;i++)
   {plot(px[i],py[i],pen); pen=PENDOWN;}
 color(1);
 pen=PENUP;
 vmax=n-t+2;
 dv=vmax/64;
 for(v=0;v<vmax;v+=dv)
   {p=spline.p(v);
    plot(p.x,p.y,pen); pen=PENDOWN;
   }
 plot(px[n],py[n],pen);
}
