/* bilbo.cc			letzte nderung: 30.3.2008 */
#define VERSION "Version 0.4"
#define COPYRIGHT "Freeware"
/*
Bild-Bearbeitungs-Programm  (Bilbo der kleine Hobbi-Bildbearbeiter)
---  -              -

History:
Datum  Version  Bemerkungen
28.12.2003	Erstellung (RP)
2.1.2004  0.1	erste brauchbare Version um Bilder zu addieren
18.1.04	  0.3	Vergrssern und Drehen eingebaut
30.3.08   0.4   Unterstuetzung von PPM-Dateien im ASCII-Format

noch zu tun:
- zuschneiden mit Maus, zoomen mit Maus
- Bilder-Infos (Aufnahmedatum, Belichtungszeit ..)
- Dokumentation
- Unbedingt erwaehnen: es wird noch ImageMagick gebraucht (fuer convert)
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <xtekplot1.h>
#include "vektorklasse.cc"

#define XMAX 1200
#define YMAX 900
#define TIEFE 16
#define MAXBR 12200
#define MAXHO 8200

/************************* Vordeklarationen ***************************/
void neuzeichnen(int a0=0);
void scrollen(int richtung);
void scrollblau(int richtung);
void zoomblau(int proz);
void bildertauschen(int i,int j);
void bilderrollen(int richtung);
void mauspre();
void mausrel();
void mausmot();

/************************ Globale Variablen ***************************/
const int test=1; //Testausdrucke (0=ohne 1=mit)
const int MAXB=20; //Maximale Anzahl Bilder, die geladen werden knnen
static int nbilder=0; //Anzahl geladene Bilder
static int jreihenfolge[MAXB+1]; //Bilder-Reihenfolge
inline int jr(int i) {return (i==nbilder)?nbilder:jreihenfolge[i];}

static int ansicht_modus=0,uebersicht_modus=0;
const int EINZELN=0,UEBERLAGERT=1,VERDECKT=2,UEBERSICHT=3; //Werte fr modus

static int undo_aktion=0; //letzte rckgngig machbare Aktion
const int ADDIEREN=1,DIVIDIEREN=2;

static int ramenx=0,rameny=0,ramenbreite=0,ramenhoehe=0; //Zielbildrahmen
static int sichtx=0,sichty=0; //Position des Sicht-Fensters
static int sichtx2=0,sichty2=0; //im Uebersicht-Modus
static int sichtstep=XMAX/4;
static int zoomfaktor=100; //Grsse in Prozent

static int schneidmodus=0; //Zuschneide-Modus
const int SMSAVE=0,SMADD=1;

/*************************** kleinkram ***************************/
#define N80 160

int index(char *s1,char *s2) /* Sucht den String s2 innerhalb von s1 und  */
{			     /* gibt Position zurueck (nicht gefunden: -1)*/
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

char *ohnepunkt(char *name)  /* in Filename die Erweiterung .xxx loeschen */
{
 char c,*s=name;
 while((c= *s)!='.' && c!=0) s++;
 if(c=='.') *s='\0';
 return name;
}
void ohnepfad(char *ziel,char *name,int max)
{
 char c,*s,*z;
 int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='/' && c!=':' && c!='\\')
	{--i; --s;}
 for(i=1,z=ziel;i<max && (c= *s++)!=0;i++)
	*z++ = c;
 *z=0;
}

void system2(char *s,char *p1,char *p2=NULL)
{
 char str[3*N80];
 sprintf(str,s,p1,p2); system(str);
}
bool isspace(int c)
{
 return (c=='\n' || c==' ');
}

vektor drehenl(vektor& v,double sina,double cosa) //Vektor nach links drehen
{
 return vektor(v.x*cosa-v.y*sina, v.x*sina+v.y*cosa);
}

vektor drehenr(vektor& v,double sina,double cosa) //Vektor nach rechts drehen
{
 return vektor(v.x*cosa+v.y*sina, v.y*cosa-v.x*sina);
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/*************************** Haupt-Klassen ****************************/
class Intvector2
{
public:
 int x,y;
};

class Fvector
{
public:
 double r,g,b;
 Fvector(double r0,double g0,double b0) {r=r0; g=g0; b=b0;}
 Fvector operator+(Fvector p) {return Fvector(r+p.r,g+p.g,b+p.b);}
 Fvector operator*(double z) {return Fvector(z*r,z*g,z*b);}
};

class Farbvector
{
public:
 UWORD r,g,b;
 Farbvector() {}
 Farbvector(int n) {r=g=b=n;}
 Farbvector(Fvector f) {r=int(f.r); g=int(f.g); b=int(f.b);}
 void operator+=(Farbvector& y) {r+=y.r; g+=y.g; b+=y.b;}
 void operator*=(int n) {r*=n; g*=n; b*=n;}
 void operator*=(double z) {r=int(r*z+0.5); g=int(g*z+0.5); b=int(b*z+0.5);}
 void operator/=(int n) {r/=n; g/=n; b/=n;}
 void operator^=(int p2) {r=p2-r; g=p2-g; b=p2-b;}
 Fvector operator*(double z) {return Fvector(z*r,z*g,z*b);}
};
class Bild
{
 Farbvector *p;
 int nsum;
public:
 int imax,jmax;
 int offsetx,offsety;
 char bildname[80];
 Bild() {imax=jmax=0; offsetx=offsety=0; nsum=1; *bildname=0;}
 ~Bild() {clear();}
 void clear()
	{if(imax!=0) {imax=jmax=0; delete[] p;}
	 offsetx=offsety=0;
	}
 int init(int i,int j,int offx=0,int offy=0)
	{imax=i; jmax=j; int n=imax*jmax; offsetx=offx; offsety=offy;
	 p=new Farbvector[n];
	 if(p==NULL) {printf("zu wenig RAM in init\n"); return -1;}
	 return 0;
	}
 void setrgb(int i,int j,int r,int g,int b);
 void zeichnen();
 int save(char*);
 Bild& operator=(Bild& y);
 void operator+=(Bild& y); //y dazuaddieren ohne Bildgrsse zu ndern
 void operator|=(Bild& y); //y dazuaddieren und Bildgrsse anpassen
 void operator&=(Bild& y); //mit y ueberschreiben und Bildgrsse anpassen
 void operator/=(int);
 void operator*=(int);
 void operator*=(double);
// void setoffset(int x,int y) {offsetx=x; offsety=y;}
 int cut(int br,int ho,int ox,int oy,Bild& y);
 Farbvector getpixel(int i,int j)
	{return (i>=0 && i<imax && j>=0 && j<jmax)?p[j*imax+i]:Farbvector(0);}
 void getminmaxpixel(int* pmin,int* pmax);
 void getminmaxpixel(int* rmin,int* rmax,int* gmin,int* gmax,int* bmin,int* bmax);
 void addpix(int r,int g,int b,bool ug,bool og);
 void mulpix(double r,double g,double b,bool ug,bool og);
 void negativ();
 void vergroessern(bool zwi,Bild& b1,double v);
 void drehen(bool zwi,Bild& b1,double sina,double cosa,double v=1.0);
};
Bild& Bild::operator=(Bild& y)
{
 int er=init(y.imax,y.jmax,y.offsetx,y.offsety);
 int i,n=imax*jmax;
 if(er==0)
  for(i=0;i<n;i++)
     {p[i] = y.p[i];}
 strcpy(bildname,y.bildname);
 return *this;
}
void Bild::operator+=(Bild& y)
{
 int i,j,iy,jy,n=0,ny;
 for(j=0,jy=offsety-y.offsety;j<jmax;j++,jy++)
 for(i=0,iy=offsetx-y.offsetx;i<imax;i++,iy++,n++)
    if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
     {ny=jy*y.imax+iy;
      p[n] += y.p[ny];
     }
}
int Bild::cut(int br,int ho,int ox,int oy,Bild& y)
{
 int er=init(br,ho,ox,oy);
 int i,j,iy,jy,n=0,ny;
 if(er==0)
 for(j=0,jy=offsety-y.offsety;j<jmax;j++,jy++)
 for(i=0,iy=offsetx-y.offsetx;i<imax;i++,iy++,n++)
    if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
     {ny=jy*y.imax+iy;
      p[n] = y.p[ny];
     }
 return er;
}
void Bild::operator|=(Bild& y)
{
 if(offsetx==y.offsetx && offsety==y.offsety && imax==y.imax && jmax==y.jmax)
    {operator+=(y); return;}
 int n,im,jm,ox,oy,i,j,iy,jy,ny,iz,jz,nz;
 UWORD u1,u2;
 Farbvector *np;
 if(offsetx>=y.offsetx)
   {ox=y.offsetx; im=offsetx-ox+imax; if(y.imax>im) im=y.imax;}
 else
   {ox=offsetx; im=y.offsetx-ox+y.imax; if(imax>im) im=imax;}
 if(offsety>=y.offsety)
   {oy=y.offsety; jm=offsety-oy+jmax; if(y.jmax>jm) jm=y.jmax;}
 else
   {oy=offsety; jm=y.offsety-oy+y.jmax; if(jmax>jm) jm=jmax;}
 n=im*jm;
 np=new Farbvector[n];
 if(np==NULL) {printf("zu wenig RAM in operator|=\n"); return;}
 for(j=0,n=0;j<jm;j++)
 for(i=0;i<im;i++,n++)
    {iz=i+ox-offsetx; jz=j+oy-offsety;
     iy=i+ox-y.offsetx; jy=j+oy-y.offsety;
     if(iz>=0 && iz<imax && jz>=0 && jz<jmax) {nz=jz*imax+iz; u1=p[nz].r;}
     else {nz= -1; u1=0;}
     if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
	  {ny=jy*y.imax+iy; u2=y.p[ny].r;}
     else {ny= -1;  u2=0;}
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].r=u1+u2;
     if(nz>=0) u1=p[nz].g; else u1=0;
     if(ny>=0) u2=y.p[ny].g; else u2=0;
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].g=u1+u2;
     if(nz>=0) u1=p[nz].b; else u1=0;
     if(ny>=0) u2=y.p[ny].b; else u2=0;
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].b=u1+u2;
    }
 delete[] p;
 p=np;
 imax=im; jmax=jm; offsetx=ox; offsety=oy;
 nsum++;
}
void Bild::operator&=(Bild& y)
{
 if(offsetx==y.offsetx && offsety==y.offsety && imax==y.imax && jmax==y.jmax)
    {operator+=(y); return;}
 int n,im,jm,ox,oy,i,j,iy,jy,ny,iz,jz,nz;
 UWORD u1,u2;
 Farbvector *np;
 if(offsetx>=y.offsetx)
   {ox=y.offsetx; im=offsetx-ox+imax; if(y.imax>im) im=y.imax;}
 else
   {ox=offsetx; im=y.offsetx-ox+y.imax; if(imax>im) im=imax;}
 if(offsety>=y.offsety)
   {oy=y.offsety; jm=offsety-oy+jmax; if(y.jmax>jm) jm=y.jmax;}
 else
   {oy=offsety; jm=y.offsety-oy+y.jmax; if(jmax>jm) jm=jmax;}
 n=im*jm;
 np=new Farbvector[n];
 if(np==NULL) {printf("zu wenig RAM in operator&=\n"); return;}
 for(j=0,n=0;j<jm;j++)
 for(i=0;i<im;i++,n++)
    {iz=i+ox-offsetx; jz=j+oy-offsety;
     iy=i+ox-y.offsetx; jy=j+oy-y.offsety;
     if(iz>=0 && iz<imax && jz>=0 && jz<jmax) {nz=jz*imax+iz; u1=p[nz].r;}
     else {nz= -1; u1=0;}
     if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
	  {ny=jy*y.imax+iy; u2=y.p[ny].r;}
     else {ny= -1;  u2=u1;}
     np[n].r=u2;
     if(nz>=0) u1=p[nz].g; else u1=0;
     if(ny>=0) u2=y.p[ny].g; else u2=u1;
     np[n].g=u2;
     if(nz>=0) u1=p[nz].b; else u1=0;
     if(ny>=0) u2=y.p[ny].b; else u2=u1;
     np[n].b=u2;
    }
 delete[] p;
 p=np;
 imax=im; jmax=jm; offsetx=ox; offsety=oy;
}
void Bild::operator/=(int m)
{
 int i,n=imax*jmax;
 if(m==0) m=nsum;
 for(i=0;i<n;i++)
     {p[i] /= m;}
 nsum=1;
}
void Bild::operator*=(int m)
{
 int i,n=imax*jmax;
 for(i=0;i<n;i++)
     {p[i] *= m;}
}
void Bild::operator*=(double z)
{
 int i,n=imax*jmax;
 for(i=0;i<n;i++)
     {p[i] *= z;}
}
void Bild::setrgb(int i,int j,int r,int g,int b)
{
 int n=i+j*imax; p[n].r=r; p[n].g=g; p[n].b=b;
}
inline int farbnummer(int r,int g,int b)
{
// if(TIEFE==8) return (r&0xE0)+((g>>3)&0x1C)+((b>>6)&0x03);
 if(TIEFE==16)
 {while(r<8 && g<8 && b<8 && (r>1 || g>1 || b>1)) {r<<=1; g<<=1; b<<=1;}
  return ((r&0xF8)<<8)+((g&0xF8)<<3)+((b&0xF8)>>2);
 }
 if(TIEFE==18)
 {while(r<4 && g<4 && b<4 && (r>1 || g>1 || b>1)) {r<<=1; g<<=1; b<<=1;}
  return ((r&0xFC)<<10)+((g&0xFC)<<4)+((b&0xFC)>>2);
 }
//if(TIEFE==24)
//return (r<<16)+(g<<8)+b; //24-Bit-Farbtiefe geht mit xtekplot1 in Linux nicht
}
void farben_init()
{
 int r,g,b;
/* if(TIEFE==8)
 {for(r=0x20;r<=0xE0;r+=0x20)
  for(g=0x20;g<=0xE0;g+=0x20)
  for(b=0x40;b<=0xC0;b+=0x40)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
 else */
 if(TIEFE==16)
 {for(r=0;r<0x08;r++)
  for(g=0;g<0x08;g++)
  for(b=0;b<0x08;b++)
    setcolor(farbnummer(r,g,b),r,g,b);
  for(r=0;r<=0xF8;r+=0x08)
  for(g=0;g<=0xF8;g+=0x08)
  for(b=0;b<=0xF8;b+=0x08)
    setcolor(farbnummer(r,g,b),r,g,b);
   }
 else if(TIEFE==18)
 {for(r=0;r<0x04;r++)
  for(g=0;g<0x04;g++)
  for(b=0;b<0x04;b++)
    setcolor(farbnummer(r,g,b),r,g,b);
  for(r=0;r<=0xFC;r+=0x04)
  for(g=0;g<=0xFC;g+=0x04)
  for(b=0;b<=0xFC;b+=0x04)
    setcolor(farbnummer(r,g,b),r,g,b);
   }
}
void Bild::zeichnen()
{
/* ramenx,y
     +------------Zielbild-------------+  ramenbreite,ramenhoehe
     |  offsetx,y                      |
     |   +------------Bild-------------+----+  imax,jmax  i,j
     |   |  sichtx,y                   |    |
     |   |    +--Sichtfenster--+       |    |  XMAX,YMAX  ix,iy
     |   |    |                |       |    |
     |   |    |                |       |    |
     |   |    |                |       |    |
     |   |    +----------------+       |    |
     +---+-----------------------------+    |
         |                                  |
         +----------------------------------+
*/
 int ix,iy,ix0,iy0; //Koordinaten im Sichtfenster
 int i,j,i1,i2,j1,j2; //Koordinaten im Bild
 int nr,n,nj;
 if(ramenbreite==0 || ramenhoehe==0)
   {ramenbreite=imax; ramenhoehe=jmax;
    if(sichtx==0 && sichty==0)
	{sichtx=(ramenbreite-XMAX)/2; if(sichtx<0) sichtx=0;
	 sichty=(ramenhoehe-YMAX)/2; if(sichty<0) sichty=0;
	}
   }
 if(uebersicht_modus==UEBERSICHT)
  {i1=sichtx2-offsetx; j1=sichty2-offsety;}
 else
  {i1=sichtx-offsetx; j1=sichty-offsety;}
 i2=i1+XMAX; j2=j1+YMAX;
 koorduser2pix(0.0,YMAX,&ix0,&iy0);
 if(zoomfaktor==100)
  {for(j=j1,nj=j1*imax,iy=iy0;j<j2;j++,nj+=imax,iy++)
   for(i=i1,ix=ix0;i<i2;i++,ix++)
    {if(j>=0 && j<jmax && i>=0 && i<imax)
	  {n=i+nj; nr=farbnummer(p[n].r,p[n].g,p[n].b);}
     else {nr=farbnummer(0x80,0x80,0x80);} //Ausserhalb Bilddaten: Grau
     ipunkt(ix,iy,nr);
    }
  }
 else
  {double fa=zoomfaktor*0.01;
   int ii,jj;
   for(j=0,iy=iy0;j<YMAX;j++,iy++)
   for(i=0,ix=ix0;i<XMAX;i++,ix++)
    {jj=j1+int(j/fa+0.5);
     ii=i1+int(i/fa+0.5);
     if(jj>=0 && jj<jmax && ii>=0 && ii<imax)
	  {n=jj*imax+ii; nr=farbnummer(p[n].r,p[n].g,p[n].b);}
     else {nr=farbnummer(0x80,0x80,0x80);} //Ausserhalb Bilddaten: Grau
     ipunkt(ix,iy,nr);
    }
  }
}
int Bild::save(char *filename)
{
 int i,j,n,ti=255,c;
 for(j=n=0;j<jmax && ti==255;j++)
 for(i=0;i<imax;i++,n++)
    if(p[n].r>255 || p[n].g>255 || p[n].b>255) {ti=65535; break;}
 FILE *fp=fopen(filename,"wb");
 if(fp==NULL) return -1;
 fprintf(fp,"P6\n%d %d %d\n",imax,jmax,ti);
 if(ti==255)
  {for(j=n=0;j<jmax;j++)
   for(i=0;i<imax;i++,n++)
    {putc(p[n].r,fp); putc(p[n].g,fp); putc(p[n].b,fp);
    }
  }
 else
  {for(j=n=0;j<jmax;j++)
   for(i=0;i<imax;i++,n++)
    {c=p[n].r; putc(c>>8,fp); putc(c&0xFF,fp);
     c=p[n].g; putc(c>>8,fp); putc(c&0xFF,fp);
     c=p[n].b; putc(c>>8,fp); putc(c&0xFF,fp);
    }
  }
 fclose(fp);
 return 0;
}
void Bild::getminmaxpixel(int* pmin,int* pmax)
{
 int i,n=imax*jmax;
 *pmin=0xFFFF; *pmax=0;
 for(i=0;i<n;i++)
   {if(*pmin>p[i].r) *pmin=p[i].r;
    if(*pmin>p[i].g) *pmin=p[i].g;
    if(*pmin>p[i].b) *pmin=p[i].b;
    if(*pmax<p[i].r) *pmax=p[i].r;
    if(*pmax<p[i].g) *pmax=p[i].g;
    if(*pmax<p[i].b) *pmax=p[i].b;
   }
}
void Bild::getminmaxpixel(int* rmin,int* rmax,int* gmin,int* gmax,int* bmin,int* bmax)
{
 int i,n=imax*jmax;
 *rmin= *gmin= *bmin=0xFFFF;  *rmax= *gmax= *bmax=0;
 for(i=0;i<n;i++)
   {if(*rmin>p[i].r) *rmin=p[i].r;
    if(*gmin>p[i].g) *gmin=p[i].g;
    if(*bmin>p[i].b) *bmin=p[i].b;
    if(*rmax<p[i].r) *rmax=p[i].r;
    if(*gmax<p[i].g) *gmax=p[i].g;
    if(*bmax<p[i].b) *bmax=p[i].b;
   }
}
void Bild::addpix(int r,int g,int b,bool ug,bool og)
{
 int i,n=imax*jmax,rn,gn,bn;
 for(i=0;i<n;i++)
   {rn=p[i].r+r;
    gn=p[i].g+g;
    bn=p[i].b+b;
    if(ug) {if(rn<0) rn=0; if(gn<0) gn=0; if(bn<0) bn=0;}
    if(og) {if(rn>255) rn=255; if(gn>255) gn=255; if(bn>255) bn=255;}
    p[i].r=rn;
    p[i].g=gn;
    p[i].b=bn;
   }
}
void Bild::mulpix(double r,double g,double b,bool ug,bool og)
{
 int i,n=imax*jmax,rn,gn,bn;
 for(i=0;i<n;i++)
   {rn=int(p[i].r*r+0.5);
    gn=int(p[i].g*g+0.5);
    bn=int(p[i].b*b+0.5);
    if(ug) {if(rn<0) rn=0; if(gn<0) gn=0; if(bn<0) bn=0;}
    if(og) {if(rn>255) rn=255; if(gn>255) gn=255; if(bn>255) bn=255;}
    p[i].r=rn;
    p[i].g=gn;
    p[i].b=bn;
   }
}
void Bild::negativ()
{
 int i,n=imax*jmax,pmin,pmax,p2;
 getminmaxpixel(&pmin,&pmax);
 p2=pmax+2*pmin;
 for(i=0;i<n;i++)
   {p[i] ^= p2; //p[i].r=pmax-(p[i].r-pmin)+pmin;
   }
}
void Bild::vergroessern(bool zwi,Bild& b1,double v)
{
 int i,j,k; //Laufvariablen neues Bild
 int i1,j1,i2,j2; //Indexe auf altes Bild
 double x,y;
 double w1,w2,wj1,wj2; //Gewichtungsfaktoren
 if(zwi) //Zwischenwerte berechnen
  for(j=0,k=0;j<jmax;j++)
   {y=(j+0.5)/v-0.5;
    j1=int(y); j2=j1+1; //j1 ist abgerundeter, j2 aufgerundeter Wert
    wj1=j2-y; wj2=y-j1; //Gewicht ist Abstand zwischen gerundet und exakt
    if(j2>=b1.jmax) j2=j1;
    for(i=0;i<imax;i++,k++)
     {x=(i+0.5)/v-0.5;
      i1=int(x); i2=i1+1; w1=i2-x; w2=x-i1;
      if(i2>=b1.imax) i2=i1;
      p[k] = (b1.getpixel(i1,j1)*w1+b1.getpixel(i2,j1)*w2)*wj1
	    +(b1.getpixel(i1,j2)*w1+b1.getpixel(i2,j2)*w2)*wj2;
     }
   }
 else //ohne Zwischenwerte
  for(j=0,k=0;j<jmax;j++)
   {j1=int((j+0.5)/v); //entspricht idfix((j+0.5)/v-0.5)
    for(i=0;i<imax;i++,k++)
     {i1=int((i+0.5)/v);
      p[k] = b1.getpixel(i1,j1);
     }
   }
}
void Bild::drehen(bool zwi,Bild& b1,double sina,double cosa,double v)
{
 int i,j,k; //Laufvariablen neues Bild
 int i1,j1,i2,j2; //Indexe auf altes Bild
 vektor q0,q;
 double w1,w2,wj1,wj2; //Gewichtungsfaktoren
 vektor mb(b1.imax*0.5,b1.jmax*0.5); //Mitte altes Bild
 vektor ma(imax*0.5,jmax*0.5); //Mitte neues Bild
 if(zwi) //Zwischenwerte berechnen
  for(j=0,k=0;j<jmax;j++)
   {q0.y=(j-ma.y)/v;
    for(i=0;i<imax;i++,k++)
     {q0.x=(i-ma.x)/v;
      q=drehenr(q0,sina,cosa)+mb;
      j1=int(q.y); j2=j1+1; //j1 ist abgerundeter, j2 aufgerundeter Wert
      wj1=j2-q.y; wj2=q.y-j1; //Gewicht ist Abstand zwischen gerundet und exakt
      if(j2>=b1.jmax) j2=j1;
      i1=int(q.x); i2=i1+1; w1=i2-q.x; w2=q.x-i1;
      if(i2>=b1.imax) i2=i1;
      if(j1<0 || j1>=b1.jmax || i1<0 || i1>=b1.imax)
	  p[k]=0; //Hintergrund schwarz
      else
	  p[k] = (b1.getpixel(i1,j1)*w1+b1.getpixel(i2,j1)*w2)*wj1
	        +(b1.getpixel(i1,j2)*w1+b1.getpixel(i2,j2)*w2)*wj2;
     }
   }
 else //ohne Zwischenwerte
  for(j=0,k=0;j<jmax;j++)
   {q0.y=(j-ma.y)/v;
    for(i=0;i<imax;i++,k++)
     {q0.x=(i-ma.x)/v;
      q=drehenr(q0,sina,cosa)+mb;
      i1=int(q.x+0.5);
      j1=int(q.y+0.5);
      if(j1<0 || j1>=b1.jmax || i1<0 || i1>=b1.imax)
	  p[k]=0; //Hintergrund schwarz
      else
	  p[k] = b1.getpixel(i1,j1);
     }
   }
}
static Bild bilder[MAXB+1],tmpbild;

void convertieren(char *filename,char *name)
{
 if(index(filename,".pef")>0)
   {if(argflag['A']) system2("dcraw -a %s",filename); //Farben falsch
    else {system2("parse %s >bilbo.tmp 2>&1",filename); //Qualitt ?
          system2("convert %s.thumb %s.ppm",filename,name);
	  system2("rm %s.thumb",filename);
         }
   }
 else
   system2("convert %s %s.ppm",filename,name);
}

void bild_laden(char *filename)
{
 char name[N80];
 FILE *fp;
 int c,i,j,br,ho,ti,r,g,b;
 if(index(filename,".ppm")<0)
   {strcpy(name,filename); ohnepunkt(name);
    convertieren(filename,name);
    sprintf(filename,"%s.ppm",name);
   }
 fp=fopen(filename,"r");
 if(fp==NULL) {printf("cant open '%s'\n",filename); return;}
 if(getc(fp)!='P' || ((c=getc(fp))!='6' && c!='3'))
  {printf("wrong fileformat: '%s' is not PPM\n",filename); fclose(fp); return;}
 bool ppmascii=(c=='3'); //wenn PPM-Datei mit P6 beginnt binaer, mit P3 ASCII
 while(isspace(c=getc(fp))) ;
 while(c=='#') {while(getc(fp)!='\n') ;  c=getc(fp);}
 ungetc(c,fp);
 fscanf(fp,"%d %d %d",&br,&ho,&ti);
 if((c=getc(fp))!='\n' && c!=' ')
   {printf("Error: missing whitespace in PPM\n"); return;}
 if(br>MAXBR || ho>MAXHO)
   {printf("Bild zu Gross: %dx%d (auf %dx%d beschraenkt)\n",br,ho,MAXBR,MAXHO); fclose(fp); return;}
 printf("Loading '%s' br=%d ho=%d ti=%d\n",filename,br,ho,ti);
 if(ti!=255 && ti!=65535)
     printf("Warnung: Ungewoehnliche Farbtiefe, Bild wird moeglicherweise nicht korrekt dargestellt\n");//test
 int er=bilder[nbilder].init(br,ho);
 if(er!=0) {fclose(fp); janeinrequester("Speicherprobleme"); return;}
 ohnepfad(bilder[nbilder].bildname,filename,80);
 if(ppmascii)
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {fscanf(fp,"%d %d %d",&r,&g,&b);
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
     }
 else if(ti<=255)
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; g=getc(fp)&0xFF; b=getc(fp)&0xFF;
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
     }
 else
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; r=(r<<8)+(getc(fp)&0xFF);
	g=getc(fp)&0xFF; g=(g<<8)+(getc(fp)&0xFF);
	b=getc(fp)&0xFF; b=(b<<8)+(getc(fp)&0xFF);
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
     }
 fclose(fp);
 jreihenfolge[nbilder]=nbilder; nbilder++;
 neuzeichnen();
}

/************************* Men Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_about()
{
 int ok;
 char str[80];
 sprintf(str,"Bilbo.cc   %s\nCopyright: %s\n",VERSION,COPYRIGHT);
 janeinrequester(str);
}
void m_load()
{
 int ok;
 char filename[N80]="imgp0000.pef";
 if(nbilder>=MAXB)
   {janeinrequester("kann keine weiteren Bilder laden","ok"); return;}
 ok=nachfilenamefragen("Load picture",filename,N80);
 if(ok) bild_laden(filename);
}
void m_save()
{
 int ok,nr=nbilder-1,er=0;
 char filename[N80]="neu.ppm", str[80];
 sprintf(str,"Bildnummer (0..%d,%d=alles)",nbilder-1,nbilder);
 ok=requester_input(1,str,"%d","%d",&nr);
 if(ok)
  {ok=nachfilenamefragen("Save picture",filename,N80);
   if(ok)
     {if(nr==nbilder) bilder[nr]=tmpbild;//aktuelle Komposition
      if(schneidmodus==SMSAVE)
	{tmpbild.clear();
	 er=tmpbild.cut(ramenbreite,ramenhoehe,ramenx,rameny,bilder[jr(nr)]);
	 if(er==0) tmpbild.save(filename);
	}
      else bilder[jr(nr)].save(filename);
      if(nr==nbilder) bilder[nr].clear();
     }
  }
}
void m_clear()
{
 int i,k;
 if(nbilder>1)
   {bilder[k=jr(nbilder-1)].clear();
    nbilder--;
    for(i=k;i<nbilder;i++)
	{bilder[i].clear(); bilder[i]=bilder[i+1];}
    for(i=0;i<nbilder;i++)
	if(jreihenfolge[i]>k) jreihenfolge[i]--;
    neuzeichnen();
   }
 undo_aktion=0;
}
void m_undo()
{
 if(undo_aktion==ADDIEREN)
   {bilder[--nbilder].clear();}
 else if(undo_aktion==DIVIDIEREN)
   {int m=nbilder-1; bilder[nbilder-1] *= m;}
 else janeinrequester("Keine ruecknehmbare Aktion vorhanden.","ok");
 if(undo_aktion!=0) 
   {undo_aktion=0; neuzeichnen();}
}
void m_refresh()
{
 neuzeichnen();
}
void neuzeichnen(int a0)
{
 static int altzoom;
 int i;
 inital_new();
 if(uebersicht_modus==UEBERSICHT)
   {int xmi=0,ymi=0,xma=0,yma=0,ra=10,q;
    altzoom=zoomfaktor;
    for(i=0;i<nbilder;i++)
	{if(bilder[i].offsetx<xmi) xmi=bilder[i].offsetx;
	 if(bilder[i].offsety<ymi) ymi=bilder[i].offsety;
	 if((q=bilder[i].imax+bilder[i].offsetx)>xma) xma=q;
	 if((q=bilder[i].jmax+bilder[i].offsety)>yma) yma=q;
	}
    sichtx2=xmi-ra; sichty2=ymi-ra;
    zoomfaktor=100*XMAX/(xma+ra-sichtx2);
    if((q=100*YMAX/(yma+ra-sichty2))<zoomfaktor) zoomfaktor=q;
    if(zoomfaktor==0) zoomfaktor=1; //darf nicht kleiner 1% sein
   }
 if(ansicht_modus==UEBERLAGERT && nbilder>=2)
   {tmpbild.clear();
    tmpbild=bilder[jr(0)];
    for(i=a0+1;i<nbilder;i++)  tmpbild |= bilder[jr(i)];
    tmpbild /= nbilder;
    tmpbild.zeichnen();
   }
 else if(ansicht_modus==VERDECKT && nbilder>=2)
   {tmpbild.clear();
    tmpbild=bilder[jr(0)];
    for(i=a0+1;i<nbilder;i++)  tmpbild &= bilder[jr(i)];
    tmpbild.zeichnen();
   }
 else
   for(int i=a0;i<nbilder;i++) bilder[jr(i)].zeichnen();
 if(uebersicht_modus==UEBERSICHT)
   {double fa=zoomfaktor/100.0,fa0=altzoom/100.0;
    int ix0,iy0,ix,iy;
    koorduser2pix(0.0,YMAX,&ix0,&iy0);
    color(farbnummer(0,0,255)); //blauer Rahmen um Zielbild
    ix=int((ramenx-sichtx2)*fa);
    iy=int((rameny-sichty2)*fa);
    idrawbox(ix0+ix,iy0+iy,
	     ix0+ix+int(ramenbreite*fa),iy0+iy+int(ramenhoehe*fa));
    color(farbnummer(255,0,0)); //roter Rahmen um Ansichtfenster
    ix=int((sichtx-sichtx2)*fa);
    iy=int((sichty-sichty2)*fa);
    idrawbox(ix0+ix,iy0+iy,
	     ix0+ix+int(XMAX/fa0*fa),iy0+iy+int(YMAX/fa0*fa));
    zoomfaktor=altzoom;
   }
 term_refresh();
}

//Menu Bearbeiten
void m_add()
{
 int er=0;
 if(nbilder<2) {janeinrequester("Kein zweites Bild zum addieren vorhanden.\n\
Tipp: zuerst zu addierendes Bild laden.","ok"); return;}
 if(nbilder>=MAXB)
   {janeinrequester("kein Platz fuer weiteres Bild","ok"); return;}
 int neu=nbilder++;
 jreihenfolge[neu]=neu;
 if(schneidmodus==SMADD)
      er=bilder[neu].cut(ramenbreite,ramenhoehe,ramenx,rameny,bilder[jr(0)]);
 else bilder[neu]=bilder[jr(0)];
 if(er==0)
  {for(int i=1;i<neu;i++)
     bilder[neu] += bilder[jr(i)];
   undo_aktion=ADDIEREN;
  }
 else janeinrequester("Speicherprobleme");
 neuzeichnen();
}
void m_divid()
{
 int m=nbilder-1;
 if(m==0) {janeinrequester("dividieren geht bisher nur nach Bildaddition(en)","ok"); return;}//provi.
 bilder[jr(nbilder-1)] /= m;
 undo_aktion=DIVIDIEREN;
 neuzeichnen();
}
void m_hell()
{
 int ok,nr=jr(nbilder-1),pmin,pmax,pix;
 double fa;
 static char gro[16]="n",gru[16]="j";
 bilder[nr].getminmaxpixel(&pmin,&pmax);
 printf("Bildnr=%d  pmin=%d pmax=%d  255-pmax=%d\n",nr,pmin,pmax,255-pmax);//provi.
 pix= -pmin;
 fa=255.0/(pmax-pmin);
 ok=requester_input(4,"Pixelwert addieren","%d","%d",&pix,
		    "dann Multiplizieren","%lf","%lf\n",&fa,
		    "Pixelwerte auf 255 begrenzen? (j,n)","%s","%s\n",gro,
		    "Werte kleiner 0 auf 0 setzen? (j,n)","%s","%s\n",gru);
 if(ok)
    {if(pix!=0) bilder[nr].addpix(pix,pix,pix,gru[0]!='n',gro[0]!='n');
     if(fa!=1.0) bilder[nr].mulpix(fa,fa,fa,gru[0]!='n',gro[0]!='n');
     neuzeichnen();
    }
}
void m_farben()
{
 int ok,nr=jr(nbilder-1),rmin,rmax,gmin,gmax,bmin,bmax,pixr,pixg,pixb;
 double far,fag,fab;
 static char gro[16]="n",gru[16]="j";
 bilder[nr].getminmaxpixel(&rmin,&rmax,&gmin,&gmax,&bmin,&bmax);
 printf("Bildnr=%d  rmin=%d rmax=%d  255-rmax=%d\n",nr,rmin,rmax,255-rmax);//provi.
 printf("           gmin=%d gmax=%d  255-gmax=%d\n",gmin,gmax,255-gmax);//provi.
 printf("           bmin=%d bmax=%d  255-bmax=%d\n",bmin,bmax,255-bmax);//provi.
 pixr = -rmin;  far=255.0/(rmax-rmin);
 pixg = -gmin;  fag=255.0/(gmax-gmin);
 pixb = -bmin;  fab=255.0/(bmax-bmin);
 ok=requester_input(8,"Rot-Pixelwert addieren","%d","%d",&pixr,
		    "Rot-Pixel Multiplizieren","%lf","%lf\n",&far,
		    "Gruen-Pixelwert addieren","%d","%d",&pixg,
		    "Grune-Pixel Multiplizieren","%lf","%lf\n",&fag,
		    "Blau-Pixelwert addieren","%d","%d",&pixb,
		    "Blau-Pixel Multiplizieren","%lf","%lf\n",&fab,
		    "Pixelwerte auf 255 begrenzen? (j,n)","%s","%s\n",gro,
		    "Werte kleiner 0 auf 0 setzen? (j,n)","%s","%s\n",gru);
 if(ok)
    {if(pixr!=0 || pixg!=0 || pixb!=0)
	bilder[nr].addpix(pixr,pixg,pixb,gru[0]!='n',gro[0]!='n');
     if(far!=1.0 || fag!=1.0 || fab!=1.0)
	 bilder[nr].mulpix(far,fag,fab,gru[0]!='n',gro[0]!='n');
     neuzeichnen();
    }
}
void m_farbe()
{
 int ok,nr=jr(nbilder-1),rmin,rmax,gmin,gmax,bmin,bmax,pix;
 double fa;
 static char gro[16]="n",gru[16]="j",srgb[16]="r";
 bilder[nr].getminmaxpixel(&rmin,&rmax,&gmin,&gmax,&bmin,&bmax);
 printf("Bildnr=%d  rmin=%d rmax=%d  255-rmax=%d\n",nr,rmin,rmax,255-rmax);//provi.
 printf("           gmin=%d gmax=%d  255-gmax=%d\n",gmin,gmax,255-gmax);//provi.
 printf("           bmin=%d bmax=%d  255-bmax=%d\n",bmin,bmax,255-bmax);//provi.
 if(*srgb=='r')		{pix = -rmin;  fa=255.0/(rmax-rmin);}
 else if(*srgb=='g')	{pix = -gmin;  fa=255.0/(gmax-gmin);}
 else			{pix = -bmin;  fa=255.0/(bmax-bmin);}
 ok=requester_input(5,"Einzelne Farbe (r,g,b)","%s","%s\n",srgb,
		    "Pixelwert addieren","%d","%d",&pix,
		    "dann Multiplizieren","%lf","%lf\n",&fa,
		    "Pixelwerte auf 255 begrenzen? (j,n)","%s","%s\n",gro,
		    "Werte kleiner 0 auf 0 setzen? (j,n)","%s","%s\n",gru);
 if(ok)
    {int pixr,pixg,pixb;
     double far,fag,fab;
     if(*srgb=='r')	 {pixg=pixb=0; pixr=pix; fag=fab=1.0; far=fa;}
     else if(*srgb=='g') {pixr=pixb=0; pixg=pix; far=fab=1.0; fag=fa;}
     else		 {pixr=pixg=0; pixb=pix; far=fag=1.0; fab=fa;}
     if(pix!=0) bilder[nr].addpix(pixr,pixg,pixb,gru[0]!='n',gro[0]!='n');
     if(fa!=1.0) bilder[nr].mulpix(far,fag,fab,gru[0]!='n',gro[0]!='n');
     neuzeichnen();
    }
}
void m_negativ()
{
 bilder[jr(nbilder-1)].negativ();
 neuzeichnen();
}
void m_posit()
{
 int ok,offx,offy,offx2,offy2,offx3,offy3,n,nr=nbilder-1;
 int nr2=nbilder-2,nr3=nbilder-3;
 offx=bilder[jr(nr)].offsetx; offy=bilder[jr(nr)].offsety;
 if(nr2>=0) {offx2=bilder[jr(nr2)].offsetx; offy2=bilder[jr(nr2)].offsety;}
 if(nr3>=0) {offx3=bilder[jr(nr3)].offsetx; offy3=bilder[jr(nr3)].offsety;}
 if(nr3>=0) n=9; else if(nr2>=0) n=6; else n=3;
 ok=requester_input(n," Nr ","%d","%d",&nr,
		    "Offsetx","%d","%d",&offx,
		    "Offsety","%d","%d\n",&offy,
		    " Nr ","%d","%d",&nr2,
		    "Offsetx","%d","%d",&offx2,
		    "Offsety","%d","%d\n",&offy2,
		    " Nr ","%d","%d",&nr3,
		    "Offsetx","%d","%d",&offx3,
		    "Offsety","%d","%d",&offy3);
 if(ok)
   {bilder[jr(nr)].offsetx=offx; bilder[jr(nr)].offsety=offy;
    if(nr2>=0) {bilder[jr(nr2)].offsetx=offx2; bilder[jr(nr2)].offsety=offy2;}
    if(nr3>=0) {bilder[jr(nr3)].offsetx=offx3; bilder[jr(nr3)].offsety=offy3;}
    neuzeichnen();
   }
}
void m_schneid()
{
 int ok;
 char mod[40];
 switch(schneidmodus)
   {case SMADD: strcpy(mod,"add"); break;
    case SMSAVE: default: strcpy(mod,"save"); break;
   }
 ok=requester_input(5,"Wann zuschneiden? (add, save)","%s","%s\n",mod,
		    "Position x","%d","%d",&ramenx,
		    "Position y","%d","%d\n",&rameny,
		    "  Breite  ","%d","%d",&ramenbreite,
		    "  Hoehe   ","%d","%d\n",&ramenhoehe);
 if(ok)
     {if(strcmp(mod,"add")==0) schneidmodus=SMADD;
      else schneidmodus=SMSAVE;
      neuzeichnen();
     }
}
void m_groess()
{
 if(nbilder>=MAXB)
   {janeinrequester("kein Platz fuer weiteres Bild","ok"); return;}
 int ok;
 double v=1.0;
 char antw[16]="n";
 ok=requester_input(2,"Vergroesserungsfaktor","%.1lf","%lf\n",&v,
		    "Zwischenwerte berechnen? (j,n)","%s","%s",antw);
 if(ok)
   {int neu=nbilder++,alt=jr(neu-1),i2,j2;
    jreihenfolge[neu]=neu;
    i2=int(bilder[alt].imax*v+0.5);
    j2=int(bilder[alt].jmax*v+0.5);
    int er=bilder[neu].init(i2,j2);
    if(er==0)
	{bilder[neu].vergroessern(*antw!='n',bilder[alt],v);
	 undo_aktion=ADDIEREN;
	}
    else janeinrequester("Speicherprobleme");
   }
 neuzeichnen();
}
void m_dreh()
{
 if(nbilder>=MAXB)
   {janeinrequester("kein Platz fuer weiteres Bild","ok"); return;}
 int ok;
 double w=0.0;
 ok=requester_input(1,"Drehwinkel in Grad","%.1lf","%lf\n",&w);
 if(ok)
   {int neu=nbilder++,alt=jr(neu-1),i2,j2;
    jreihenfolge[neu]=neu;
    double x1,y1,x2,y2,xma,yma,alfa=w*GRAD;
    double sina=sin(alfa),cosa=cos(alfa);
    xma=bilder[alt].imax*0.5;
    yma=bilder[alt].jmax*0.5;
    vektor p1(-xma,-yma),p2(-xma,yma),p3(xma,yma),p4(xma,-yma);
    p1=drehenl(p1,sina,cosa); p2=drehenl(p2,sina,cosa);
    p3=drehenl(p3,sina,cosa); p4=drehenl(p4,sina,cosa);
    if(p1.x>xma) xma=p1.x; if(p1.y>yma) yma=p1.y;
    if(p2.x>xma) xma=p2.x; if(p2.y>yma) yma=p2.y;
    if(p3.x>xma) xma=p3.x; if(p3.y>yma) yma=p3.y;
    if(p4.x>xma) xma=p4.x; if(p4.y>yma) yma=p4.y;
    i2=int(xma*2+0.5);
    j2=int(yma*2+0.5);
    int er=bilder[neu].init(i2,j2);
    if(er==0)
	{bilder[neu].drehen(1,bilder[alt],sina,cosa);
	 undo_aktion=ADDIEREN;
	}
    else janeinrequester("Speicherprobleme");
   }
 neuzeichnen();
}
void m_drehgroe()
{
 if(nbilder>=MAXB)
   {janeinrequester("kein Platz fuer weiteres Bild","ok"); return;}
 int ok;
 double v=1.0,w=0.0;
 char antw[16]="j";
 ok=requester_input(3,"Drehwinkel in Grad","%.1lf","%lf\n",&w,
		    "Vergroesserungsfaktor","%.1lf","%lf\n",&v,
		    "Zwischenwerte berechnen? (j,n)","%s","%s",antw);
 if(ok)
   {int neu=nbilder++,alt=jr(neu-1),i2,j2;
    jreihenfolge[neu]=neu;
    double x1,y1,x2,y2,xma,yma,alfa=w*GRAD;
    double sina=sin(alfa),cosa=cos(alfa);
    xma=bilder[alt].imax*0.5;
    yma=bilder[alt].jmax*0.5;
    vektor p1(-xma,-yma),p2(-xma,yma),p3(xma,yma),p4(xma,-yma);
    p1=drehenl(p1,sina,cosa); p2=drehenl(p2,sina,cosa);
    p3=drehenl(p3,sina,cosa); p4=drehenl(p4,sina,cosa);
    if(p1.x>xma) xma=p1.x; if(p1.y>yma) yma=p1.y;
    if(p2.x>xma) xma=p2.x; if(p2.y>yma) yma=p2.y;
    if(p3.x>xma) xma=p3.x; if(p3.y>yma) yma=p3.y;
    if(p4.x>xma) xma=p4.x; if(p4.y>yma) yma=p4.y;
    i2=int(xma*2*v+0.5);
    j2=int(yma*2*v+0.5);
    int er=bilder[neu].init(i2,j2);
    if(er==0)
	{bilder[neu].drehen(*antw!='n',bilder[alt],sina,cosa,v);
	 undo_aktion=ADDIEREN;
	}
    else janeinrequester("Speicherprobleme");
   }
 neuzeichnen();
}

//Menu Ansicht
void m_einzeln()
{
 ansicht_modus=EINZELN;
 neuzeichnen();
}
void m_ueberlag()
{
 ansicht_modus=UEBERLAGERT;
 neuzeichnen();
}
void m_verdeck()
{
 ansicht_modus=VERDECKT;
 neuzeichnen();
}
void m_uebers()
{
 uebersicht_modus ^= UEBERSICHT;
 neuzeichnen();
}
void m_fenster()
{
 int ok;
 ok=requester_input(3,"Sichtfenster x","%d","%d",&sichtx,
		    "Sichtfenster y","%d","%d\n",&sichty,
		    "Scroll-Schrittweite","%d","%d",&sichtstep);
 if(ok) neuzeichnen();
}
void m_zoom()
{
 int ok;
 ok=requester_input(1,"Vergroesserung","%d%%","%d",&zoomfaktor);
 if(ok) neuzeichnen();
}
void zoom(double z)
{
 zoomfaktor=int(zoomfaktor*z); if(zoomfaktor<=0) zoomfaktor=1;
 neuzeichnen();
}
void bilder_reihenfolge(int nr[])
{
 int i,j;
 for(i=0;i<nbilder;i++)
     {j=nr[i];
      if(j>=0 && j<nbilder) {jreihenfolge[i]=j;}
     }
 neuzeichnen();
}
void m_reihe()
{
 int ok,i,j,nr[MAXB];
 char str[MAXB*4],*s;
 printf("Liste der geladenen Bilder:\n");
 for(i=0,s=str;i<nbilder;i++)
   {j=jr(i);
    printf(" %d\t%s\n",j,bilder[j].bildname);
    sprintf(s,"%d ",j); if(j>99) s+=4; else if(j>9) s+=3; else s+=2;
   }
 *s=0;
 ok=requester_input(1,"Reihenfolge der Bilder (siehe auch Shell-Fenster)",
		    "%s","%s",str);
 if(ok)
  {for(i=0;i<nbilder;i++)  nr[i] = -1;
   for(i=0,s=str;i<nbilder;i++)
     {sscanf(s,"%d",&nr[i]);
      if(nr[i]>99) s+=4; else if(nr[i]>9) s+=3; else s+=2;
     }
   bilder_reihenfolge(nr);
  }
}

void m_hilfe()
{
 char text[]=
"  Hilfe zu Bilbo\n\
  ==============\n\
Einschraenkungen:\n\
----------------\n\
- Es koennen maximal 20 Bilder geladen werden\n\
  (fuer mehr: Quellprogi editieren und MAXB erhoehen)\n\
- Bildgroesse auf 12200 x 8200 beschraenkt\n\
  soll Speicherprobleme bei fehlerhaften Dateien verhindern\n\
  (zum erhoehen einfach entsprechende Zeilen editieren)\n\
\n\
Tastenbelegung:\n\
---------------\n\
Taste Funktion\n\
  >   Vergroessern\n\
  <   Verkleinern\n\
  n   100% einstellen\n\
  x   Oberste beiden Bilder vertauschen\n\
  r   Bilderstapel rollen: vorderstes nach hinten\n\
  t   Bilderstapel zurueckrollen: hinterstes nach vorne\n\
  y   neu zeichnen (wie Menu refresh)\n\
  z   oberste 2 Bilder neu zeichnen\n\
nur in Uebersichtmodus:\n\
  2   Ausschneidefenster nach unten schieben\n\
  4   Ausschneidefenster nach links schieben\n\
  6   Ausschneidefenster nach rechts schieben\n\
  8   Ausschneidefenster nach oben schieben\n\
  1   Ausschneidefenster 20% verkleinern\n\
  3   Ausschneidefenster 25% vergroessern\n\
  7   Ausschneidefenster um Faktor 2 verkleinern\n\
  9   Ausschneidefenster um Faktor 2 vergroessern\n\
\n";
//\n\english: see 'Help ...'";
 janeinrequester(text);
}
void m_help()
{
 char text[]="sorry, not yet translated\ndeutsch: siehe 'Hilfe ...'";//provi.
 janeinrequester(text);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 int c,i,j;
 int breite,hoehe,tiefe,visklasse;
 double xmin=0,ymin=0,xmax=XMAX,ymax=YMAX;
 char erstedatei[N80],zweitedatei[N80];
 //tek_setdebug(1);//test
 for(j=0,i=1;i<argc;i++)
        {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
         else   {if(++j==1) strcpy(erstedatei,argv[i]);
                 else if(j==2) strcpy(zweitedatei,argv[i]);
        }       }
 if(argflag['?'] || j>MAXARG)
	{printf("bilbo  %s\n",VERSION);
	 printf("Anwendung: bilbo [-Flags] datei.pef [oder .ppm]\n");
	 printf("  Flags: a=RAW-Dateien (.pef) mit dcraw in PPM wandeln\n");
	 printf("           (sonst wird parse verwendet)\n");
	 exit(0);
	}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
// printf("breite=%d hoehe=%d tiefe=%d visklasse=%d\n",breite,hoehe,tiefe,visklasse);//test
 if(tiefe>TIEFE) tiefe=TIEFE;
 else if(tiefe<TIEFE)
     printf("Warnung: Farbtiefe kleiner als %d: tiefe=%d\n",TIEFE,tiefe);
 setsize(XMAX,YMAX,tiefe);
 setmaxfarben(1<<tiefe);
 setmenu(4,"File","Bearbeiten","Ansicht","Help");
 setmenu(4,"About ...","undo","einzeln","Hilfe ...",m_about,m_undo,m_einzeln,m_hilfe);
 setmenu(4,"Load ...","addieren","ueberlagern","Help ...",m_load,m_add,m_ueberlag,m_help);
 setmenu(3,"Save ...","dividieren","verdecken",m_save,m_divid,m_verdeck);
 setmenu(3,"Clear","Helligkeit, Farben ->","Uebersicht ein/aus",m_clear,NULL,m_uebers);
 setsubmenu(2,NULL,"Helligkeit,Kontrast ...",NULL,m_hell);
 setsubmenu(2,NULL,"alle Farben veraendern  ...",NULL,m_farben);
 setsubmenu(2,NULL,"einzelne Farbe veraendern  ...",NULL,m_farbe);
 setsubmenu(2,NULL,"Negativ",NULL,m_negativ);
 setmenu(3,"Exit",  "Positionen ...","Sichtfenster ...",m_exit,m_posit,m_fenster);
 setmenu(3,NULL,  "Zuschneiden ...","Zoom ...",NULL,m_schneid,m_zoom);
 setmenu(3,NULL,  "Drehen/Vergroessern ->","Reihenfolge ...",NULL,NULL,m_reihe);
 setsubmenu(2,NULL,"drehen ...",NULL,m_dreh);
 setsubmenu(2,NULL,"vergroessern ...",NULL,m_groess);
 setsubmenu(2,NULL,"drehen und vergroessern gleichzeitig ...",NULL,m_drehgroe);
 setmenu(3,NULL,  NULL,        "refresh",NULL,NULL,m_refresh);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 char titel[80];
 sprintf(titel,"bilbo %s",VERSION);
 set_tektitel(titel);
 farben_init();
 term_refresh();
 if(j>=1) bild_laden(erstedatei);
 if(j>=2) bild_laden(zweitedatei);
 int taste,asci; ULONG rawcode;
 while(exitflag==0 && waitmenu(0)==0)
   {waitTOF(); //auf Beginn des Bildaufbaus warten
    if(keyget(&taste,&asci,&rawcode)!=0)
      {if(rawcode>=0xFF51 && rawcode<=0xFF54) scrollen(rawcode-0xFF50);
       else if(taste==1)
	   {if(asci=='>') zoom(2);
	    else if(asci=='<') zoom(0.5);
	    else if(asci=='n') {zoomfaktor=100; zoom(1);}
	    else if(asci=='<') zoom(0.5);
	    else if(asci=='4') scrollblau(1);
	    else if(asci=='8') scrollblau(2);
	    else if(asci=='6') scrollblau(3);
	    else if(asci=='2') scrollblau(4);
	    else if(asci=='1') zoomblau(80);
	    else if(asci=='3') zoomblau(125);
	    else if(asci=='7') zoomblau(50);
	    else if(asci=='9') zoomblau(200);
	    else if(asci=='x') bildertauschen(nbilder-1,nbilder-2);
	    else if(asci=='r') bilderrollen(1);
	    else if(asci=='t') bilderrollen(-1);
	    else if(asci=='y') m_refresh();
	    else if(asci=='z') neuzeichnen(nbilder>1?nbilder-2:0);
	    else if(test) printf("asci=0x%02X,rawcode=0x%04X\n",asci,rawcode);
	   }
       else if(rawcode==0xFFE1 || rawcode==0xFFE2) ;//shifttaste
       else if(rawcode==0xFF96) scrollblau(1);
       else if(rawcode==0xFF97) scrollblau(2);
       else if(rawcode==0xFF98) scrollblau(3);
       else if(rawcode==0xFF99) scrollblau(4);
       else if(rawcode==0xFF9C) zoomblau(80);
       else if(rawcode==0xFF9B) zoomblau(125);
       else if(rawcode==0xFF95) zoomblau(50);
       else if(rawcode==0xFF9A) zoomblau(200);
       else if(test) printf("taste=%d=%02X asci=0x%02X,rawcode=0x%04X\n",taste,taste,asci,rawcode);
      }
   }
 term_exit();
 return 0;
}/* ende von main */

void scrollen(int richtung)
{
 int step = (zoomfaktor>100) ? sichtstep*100/zoomfaktor : sichtstep;
 switch(richtung)
   {case 1: sichtx -= step;  break;
    case 2: sichty -= step;  break;
    case 3: sichtx += step;  break;
    case 4: sichty += step;  break;
   }
 neuzeichnen();
}
void scrollblau(int richtung)
{
 if(uebersicht_modus==0) return;
 int step = (zoomfaktor>100) ? sichtstep*100/zoomfaktor : sichtstep;
 switch(richtung)
   {case 1: ramenx -= step;  break;
    case 2: rameny -= step;  break;
    case 3: ramenx += step;  break;
    case 4: rameny += step;  break;
   }
 neuzeichnen();
}
void zoomblau(int proz)
{
 ramenbreite=ramenbreite*proz/100; if(ramenbreite<8) ramenbreite=8;
 ramenhoehe=ramenhoehe*proz/100; if(ramenhoehe<8) ramenhoehe=8;
 sichtstep=sichtstep*proz/100; if(sichtstep<1) sichtstep=1;
 neuzeichnen();
}
void bildertauschen(int i,int j)
{
 if(nbilder>1 && j!=i && j>=0 && j<nbilder && i>=0 && i<nbilder)
   {int h=jreihenfolge[i];
    jreihenfolge[i]=jreihenfolge[j];
    jreihenfolge[j]=h;
   }
 neuzeichnen();
}
void bilderrollen(int richtung)
{
 int ok,i,j,nr[MAXB];
 if(nbilder<2 || abs(richtung)>=nbilder) return;
 for(i=0;i<nbilder;i++)
   {j=jr(i)+richtung;
    if(j<0) j+=nbilder;
    else if(j>=nbilder) j-=nbilder;
    nr[i]=j;
   }
 bilder_reihenfolge(nr);
}

void mausbewegung(int flag)
{
 int ix,iy,tasten;
 Farbvector pixel;
 tasten=imausposition(&ix,&iy);
 if(flag==1) //Maustaste gedrckt
  {pixel=bilder[jr(nbilder-1)].getpixel(ix,iy);//provi.
   printf("Mousepress %d x=%d y=%d  R=%d G=%d B=%d (stimmt noch nicht!)\n",
	  tasten,ix,iy,pixel.r,pixel.g,pixel.b);
  }
 //else if(flag==2) //Maustaste losgelassen
}
void mauspre() {mausbewegung(1);}
void mausrel() {} //{mausbewegung(2);}
void mausmot() {} //{mausbewegung(0);}
