/* diasort.cc			letzte Aenderung: 27.10.2017

Neuste Verbesserungen:
- Anpassungen fuer lange Dateinamen
- "convert -auto-orient" um Bilder zurecht zu drehen anhand des exif-Eintrags
  und Korrektur des exif-Eintrags mit exiftool?
- Idee: Untertitel-Text in Exif.Photo.UserComment speichern
  und anzeigen etwa so:
  > convert quelle.jpg -resize 1920x1080 -pointsize 25 -annotate +50+1000 "Text im Bild" ziel.jpg

 */
#define VERSION "Version 1.12, update 26.10.2017"
#define COPYRIGHT "Freeware, Open Source"
#define AUTHOR "Rolf Pfister"
//#define DEBUGMODUS
#define SICHERHEITS_WARNUNG
/*
Bilder sortieren fuer Diashow mit Gwenview
neu seit Version 0.5: Diashow direkt mit diasort

History:
Datum  Version  Bemerkungen
31.1.2007	Erstellung aus bilbo.cc (RP)
                Klasse Bild fast unveraendert: zusaetzlich noch sortiernummer
6.2.07  0.2     Bild::zeichnen() optimiert, umbenennen vereinfacht
7.2.07  0.3     Mehr Optionen (c, s, f), Bilder drehen (rotnr)
18.2.07         Menu fuer groessere Vorschaubildchen (m_gross)
4.3.07          Anpassung an 24-Bit-Farbtiefe
7.3.07  0.4     provisorischer Vollbildmodus
                Bilder loeschen (loeschflag in class Bild)
9.3.07  0.5	gepufferter Bildwechsel im Vollbildmodus
                kleine Fehler korrigiert (z.B. loeschflag ruecksetzen)
11.3.07         in *bild_laden() Farbtiefe auf 1 Byte pro Farbe beschraenkt
15.3.07 0.6     flexiblere Anpassung an Bildschirmgroesse/Beameraufloesung.
                Vereinfachungen beim Programmstart im Vollbildmodus.
		Selektiertes Bild (selektbildnr!=0) auch beim Neuzeichnen
		mit rotem Rahmen versehen (Bild::zeichnen(int ramenflag)).
20.3.07 0.7     Fehler beim Bild rotieren und gleichzeitig verschieben:
		es wurde beim Speichern falsches Bild rotiert.
		Behebung: in Bild::init() und in umbenennen() rotnr
		zurueckgesetzt und schon vorhandenes -rot%d- ersetzt.
20.5.07  0.8    Start von Grafischer Benutzeroberflaeche fuer Demo-DVD
                Menupunkt "Ordner..." zum wechseln in anderes Verzeichnis
8.6.07   0.9    Menu Info eingefuehrt. +provisorische Untertitel
11.6.07  1.0    Untertitel jetzt richtig: class Textliste, Menu "Kommentar.."
26.6.07  1.01   Textliste haeufiger speichern
6.12.08  1.02   Taste i fuer m_info, neues Flag a um gewisse Anzahl Bilder
                automatisch zu laden.
20.12.08        Versuch eines Fehlerabfangs bei tmpppm und tmptxt
21.12.08        Probleme bei m_info provisorisch geloest. Anzahl geloeschte
                Bilder beim Umschalten auf Vollbild beruecksichtigt.
23.12.08 1.03   Direkter Aufruf von Bilbo (Bildbearbeitung) aus Diasort
                heraus. (Spezieller Menupunkt in Bilbo auch angepasst)
25.-28.12.08	Neues Menu "Auswahl..." fuer schnelle Bildauswahl:
		Beim ersten Benutzen mit Auswahl des Einsortiermodus.
		Bei Start mit -v werden im Auswahlordner vorhandene
		Bilder im Vollbildmodus mit A markiert.
28.12.08        Versuch das Problem bei tmptxt zu umgehen: lokalen
                tmp-Ordner erstellen und erst bei Programmende wieder
		loeschen. --> Problem trotzdem noch ab und zu.
		(gleiches Problem bei tmpppm auch noch nicht behoben).
3.1.2009 1.04	selektbildnr beim Ausschalten vom Vollbildmodus
		aktualisieren. Allfaellige Fehler abfangen: system(),
		symlink(), scanf(), fscanf()
		Neu: Automodus: Durchlaufen lassen im Vollbildmodus.
4.1.09		Schlimmer Fehler korrigiert: wenn es doppelte Nummern
		gab und nicht alle Bilder geladen wurden, gerieten die
		Bilder durcheinander. Mit tmptxtaktualisieren() provisorisch
		behoben.
11.1.09  1.05   tmptxt wegoptimiert mit class Dateiliste und mylsmit().
		Speicherleck in class Bild in init() geflickt. Statt
		tmptxtaktualisieren() jetzt tmpdateiliste_aktualisieren()
14.1.09		Bildspeicher am Schluss wieder freigeben.
		m_pwd korrigiert
17.1.09		Speicherleck in vollpfad korrigiert.
18.1.09  1.06	in m_auswahl2() sortmode=1 als Voreinstellung.
		Falsche Fehlermeldung bei aktbildnr_ausrechnen()
		beseitigt, dafuer Fehlerabfang in nummeranpassen().
1.2.09          TMPVOR2 fuer wenn Ordner readonly ist.
9.2.09   1.07   Problem mit Leerstellen in Dateinamen versucht zu
		loesen mit anzahlblanks() und escapeblanks().
		Neues Flag 'Q' um schreiben in aktuellen Ordner zu verhindern.
14.2.09  1.08   Verwendung von rexifsort zum jpg-Dateien vorsortieren
10.1.2010 1.09	Anpassung fuer Start von Desktop (Workbench) her.
		Neue Option z fuer Hardlinks.
		Aenderungen in m_pwd() fuer Benutzung vom Desktop her.
		Kleiner Fehler in m_about() korrigiert (Buffer war zu klein)
11.-14.1.10	Fuer Leerstellen in Dateinamen Anpassungen gemacht. Es waren
		auch Anpassungen in xtekplot1.cc noetig.
		Bilbo braucht auch noch Anpassungen!
15.1.10		Log-Datei eingerichtet: wenn vom GUI gestartet wird jetzt
		mit fprintf(STDERR,...) in die Datei ~/.diasort/log.txt
		geschrieben.
16.1.10		wirklichloeschen eingefuegt
17.1.10   1.10	Datenaustausch zu und von Bilbo vereinfacht.
22.1.10		mylsmit() noch eingeschraenkt auf nur Bilddateien.
		Fehlerabfang in exifdatum() und sortstr() bei zu kurzem
		Zeitstempel (10.1.22 statt 2010.1.22),
23.1.10		aber eigentliches Problem war in class Exif:
		bei "Offset nach dem TIFF-Header" fehlendes nb++; eingefuegt.
		Umlaute in Untertitel jetzt auch ok.
24.1.10		Automatische Diaschau mit Taste 't'
27.1.10   1.11	Aufraeumen.. an Stelle save&exit.. verschoben
		(save&exit brauchts nicht mehr)
		Automatisch aufraeumen nach Aufruf von bilbo
28.1.10		Auswahl von Aktionen beim Starten vom Terminal aus in einem
		noch nicht sortierten Ordner. (entweder oder in Requester)
29.1.10		Auswahlordner erweitert auf vollen Pfad.
		argflag['B'] und tmpvorbehalten neu in m_test() einstellbar
		(wenn nicht in NURLESE-Modus)
1.2.10		Bei Aufruf vom Terminal fehlendes pwd.set() eingefuegt.
11.10.17  1.12  Offensichtliche Fehler korrigiert,
                Fehler in Exif::headerlesen() korrigiert (k+=2 statt k++)
		untertitelflag jetzt mit 3 Moeglichkeiten
23.10.17        Fehlerkorrektur: bisher waren nur 80 Zeichen fuer Dateinamen
                moeglich. Die meisten aktuellen Filesysteme uenterstuetzen
		aber 255 Bytes. (Raiserfs sogar noch viel mehr)
                Also auf 256 inklusive 0-Byte geaendert. Also vor allem N80
		und M80 auf MAXP und MAXD gesetzt.

*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <xtekplot1.h>
#include "vektorklasse.cc"

/* fuer fixe aktuelle Aufloesung des Beamers:
#define MAXBR 1920
#define MAXHO 1080
*/
#define MAXBR 2600
#define MAXHO 2000
static int XMAX=MAXBR,YMAX=MAXHO,TIEFE=24;//ersetzbar: gbreite,ghoehe,gtiefe
const int TIEFE2=12;
static int BB=95,DB=5; //Bildbreite und Abstand der Vorschaubildchen

/************************* Vordeklarationen ***************************/
void grafikfenster_oeffnen();
void neuzeichnen(int a0=0);
void scrollen(int richtung,int step=0);
void bildertauschen(int i,int j);
void mauspre();
void mausrel();
void mausmot();
void bilder_laden();
void bild_loeschen();
bool vorhanden(const char *dateiname);
bool istordner(char *dateiname);
int system2(const char *s,const char *p1,const char *p2=NULL);
void mycolor(int r,int g,int b);
char *untertitel(char *name);
char *komextrahieren(FILE *fp);
char *namelesen(FILE *fp);
bool vorhandeninauswahl(const char *kernname);
void fehlermeldung(int err);
void event_speichern();
bool ordner_erstellen(char *ordner);
int file_linken_oder_kopieren(char *name,int nummer,char *ordner);
void m_pwd2(char *ordner);
void verlink_in_ueberordner(const char *name);
void strcpy_umlaut(char *ziel,const char *txt,int max);
void setautomodus();
bool aufraeumen(int sofortflag);
void tmpdateiliste_aktualisieren(int sofortflag=0);
void splitpfad(const char *name,char *pfad,char *file,int max,int max2);

#ifdef DEBUGMODUS
void xdebug(const char *ctxt,int p1=0,int p2=0)
{
 char text[400];
 sprintf(text,ctxt,p1,p2);
 janeinrequester(text);
}
#endif

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int test=0; //Testausdrucke (0=ohne 1=mit 2=noch mehr)
static int sortiermethode=1;//1=Dateiname, 2=Aufnahmedatum, 3=Zahl in Name
static int kopiermethode=2;//1=Softlinks, 2=Hardlinks, 3=Kopieren
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=2;
   if(c=='V') test++;
   if(c=='O' && isdigit(*s)) sortiermethode= *s++ - '0';
  }
}

/*************************** etwas kleinkram ***************************/
#define MAXD MAX_DATEINAME_LAENGE
#define MAXP MAX_PFADNAME_LAENGE

static FILE *STDERR=stderr;
static int g_stdflag=0;
static char bilbo1log[MAXD]="/tmp/bilbo1.log";
static char bilbo2log[MAXD]="/tmp/bilbo2.log";
const int NTIT=80;//max. Laenge der Titelzeile
static char titelzeile[NTIT]="";
static char scratch[MAXP];

void logdatei_oeffnen()
{
 int i,imax=10000;
 char logname[MAXP],*s;
 sprintf(logname,"%s/.diasort",getenv("HOME"));
 sprintf(bilbo1log,"%s/bilbo1.log",logname);
 sprintf(bilbo2log,"%s/bilbo2.log",logname);
 if(!vorhanden(logname)) system2("mkdir \"%s\"",logname);
 for(i=1;i<imax;i++)
   {sprintf(logname,"%s/.diasort/log%d.txt",getenv("HOME"),i);
    if(!vorhanden(logname)) break;
   }
 if(i<imax) STDERR=fopen(logname,"w");
 else STDERR=fopen(logname,"a");//bei zu vielen an letzte anhaengen
 if(STDERR==NULL)  {g_stdflag=0; STDERR=stderr;}
 else g_stdflag=1;
}
void logdatei_schliessen()
{
 if(g_stdflag!=0 && STDERR!=NULL)
  {fclose(STDERR); STDERR=NULL;}
}
#ifdef DEBUGMODUS
void logdatei_reopen()
{
 if(g_stdflag==0 || STDERR==NULL) return;
 logdatei_schliessen();
 logdatei_oeffnen();
}
#endif

bool istja(char *s)
{
 int c= *s;
 return (c=='j' || c=='J' || c=='y' || c=='Y');
}

int lastchar(const char *s)
{
 int c,c1=0;
 while((c= *s++)!=0) c1=c;
 return c1;
}
void replacelastchar(char *s,int c)
{
 int i=0;
 while(*s != 0) {s++; i++;}
 if(i>0) *--s=c;
}

int anzahlblanks(const char *s) //zaehle Anzahl Leerstellen im String
{                               //und Klammern auch
 int c,n=0;
 while((c= *s++)!=0)
    if(c==' ' || c=='(' || c==')') n++;
 return n;
}

char *escapeblanks(const char *s,int nb)
{
 char *name2=new char[strlen(s)+nb+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(--nb>=0 && (c==' ' || c=='(' || c==')'))
       *p++ = '\\'; //vor jede Leerstelle oder Klammer ein \ setzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

char *entferneblanks(const char *s)
{
 char *name2=new char[strlen(s)+1];
 char *p=name2;
 int c;
 while((c= *s++)!=0)
   {if(c==' ' || c=='(' || c==')')
       c = '_'; //Leerstelle oder Klammer durch _ ersetzen
    *p++ = c;
   }
 *p=0;
 return name2;
}

void zeichen_anhaengen(char *str,char c)
{
 while(*str!=0) ++str;
 *str++ = c;
 *str=0;
}

const int MAXL=1000;

class Aktuellerpfad
{
 char *pfad;
 char *liste[MAXL];//fuer Speicherrueckgabe
 int imax;
public:
 Aktuellerpfad() {pfad=NULL; imax=0;}
 ~Aktuellerpfad() {if(pfad!=NULL) delete[] pfad; loeschen();}
 void set(const char *arg0)
	{char *s; int n=strlen(arg0);
	 if(pfad!=NULL) delete[] pfad;
	 pfad=new char[n+1];
	 strcpy(pfad,arg0);
	 for(s= &pfad[n];*--s!='/';) ;
	 *s=0;
	 setenv("PWD",pfad,1);
	}
 void cd(const char* ordner);
 FILE *fopen2(const char *name,const char *rw);
 const char *vollpfad(const char *name);
 char *getpfad() {if(pfad) return pfad; else return getenv("PWD");}
 void loeschen() {while(imax>0) delete[] liste[--imax];}
};
static Aktuellerpfad pwd;

void set_tektitel2(const char *str)
{
 int i;
 if((i=strlen(str))>NTIT-1) strcpy_umlaut(titelzeile,&str[i-NTIT+1],NTIT);
 else strcpy_umlaut(titelzeile,str,NTIT);
 set_tektitel(titelzeile);
}
void set_tektitel3(const char *str)
{
 if(argflag['Q'])
   {sprintf(scratch,"%s   NURLESE-Modus",str); str=scratch;}
 set_tektitel2(str);
}

void Aktuellerpfad::cd(const char* ordner)
{
 const char *s,*altpfad=pfad;
 if(ordner[0]=='/') s="";
 else if(altpfad==NULL) s=getenv("PWD");
 else s=altpfad;
 int n=strlen(s)+strlen(ordner)+2;
 pfad=new char[n];
 if(*s==0) strcpy(pfad,ordner);
 else sprintf(pfad,"%s/%s",s,ordner);
 if(test) printf("cd() pfad='%s'\n",pfad);//test
 while(!istordner(pfad) && (n=strlen(pfad))>1)
   {while(--n>1 && pfad[n]!='/') ;
    pfad[n]=0;
   }
 if(test) printf(" gepruefter pfad='%s' --> tektitel\n",pfad);//test
 set_tektitel2(pfad);
 if(altpfad) delete[] altpfad;
}

FILE *Aktuellerpfad::fopen2(const char *name,const char *rw)
{
 FILE *fp;
 if(pfad!=NULL && *name!='/')
  {char str[strlen(pfad)+strlen(name)+2];
   sprintf(str,"%s/%s",pfad,name);
   fp=fopen(str,rw);
  }
 else fp=fopen(name,rw);
 return fp;
}
const char *Aktuellerpfad::vollpfad(const char *name)
{
 if(name==NULL || *name=='/' || pfad==NULL) return name;
 char *name2=NULL;
 int nb;
 if((nb=anzahlblanks(name))>0) //falls in name Leerstellen sind
   name=name2=escapeblanks(name,nb);
 char vollname[strlen(pfad)+strlen(name)+2];
 if(lastchar(pfad)=='/') sprintf(vollname,"%s%s",pfad,name);
 else sprintf(vollname,"%s/%s",pfad,name);
 for(int i=0;i<imax;i++)
   if(strcmp(vollname,liste[i])==0) {return liste[i];}
 char *str=new char[strlen(vollname)+1];
 strcpy(str,vollname);
 if(imax<MAXL)
   {liste[imax++]=str;
    if(imax==MAXL && test>0)
     fprintf(STDERR,"Aktuellerpfad::vollpfad() liste fuer Speicherrueckgabe voll.\n");
   }
 if(name2!=NULL) delete[] name2;
 return str;
}
inline FILE *fopen2(const char *na,const char *rw) {return pwd.fopen2(na,rw);}
inline const char *vollpfad(const char *s) {return pwd.vollpfad(s);}

/************************ Globale Variablen ***************************/
const int N80=MAXP; //Platz fuer Dateinamen samt Pfad
const int MAXB=4000; //Maximale Anzahl Bilder, die geladen werden koennen
static int nbilder=0; //Anzahl geladene Bilder
static int anzahl=1; //Anzahl Bilder die automatisch geladen werden sollen
static int tmpvorbehalten=0;//gesetzt wenn tmpvor behalten werden soll
                            //(tmpvor ist der Ordner fuer
                            //Vorschaubildchen)
const char *TMPVOR1="tmpvor";
const char *TMPVOR2="/tmp/tmpvor"; //wenn aktueller Ordner readonly
const char *TMPVOR=TMPVOR1;
static int jreihenfolge[MAXB+1]; //Bilder-Reihenfolge
inline int jr(int i) {return (i==nbilder)?nbilder:jreihenfolge[i];}

static int ansicht_modus=0,alter_modus=0,startflag=1;
const int NORMAL=0,GROSS=1,VOLLBILD=2; //Werte fuer ansicht_modus
static int vollbildnr=1; //aktuelles Bild im Vollbildmodus
static int maxvollbilder=2;
static int automodus=0; //automatisches Durchlaufen lassen im Vollbildmodus
static int autopause= -1;

/* nur in bilbo benoetigt
static int ramenx=0,rameny=0,ramenbreite=XMAX,ramenhoehe=YMAX; //Zielbildrahmen
*/

static int sichtx=0,sichty=0; //Position des Sicht-Fensters
static int maxsichty=0,altes_sichty=0;
static int sichtstep=5*(BB+DB);
static int zoomfaktor=100; //Groesse in Prozent

static int gbreite,ghoehe,gtiefe;
static int nochnichtgespeichert=0;
static int gedruecktemaustaste=0;
static char reihenfolgedatei[N80];

static const char *tmpppm="/tmp/tmp.ppm";

static const char *listetxt="textliste.txt",*listetxtbak="textliste.txt.bak";
static int selektbildnr=0; //aktuell selektiertes Bild (0 = keins selektiert)
static int hintergrundgrau=0x808080;

static int untertitelflag=1; //neu: 0=keine Untertitel anzeigen, 1=anzeigen wenn in textliste.txt gefunden, 2=immer
static int workbenchflag=0; //0=von Terminal, 1=von GUI gestartet, 2=mit Datei mit "Oeffnen mit..." gestartet
static bool wirklichloeschen=false;//als geloescht markiertes wirklich loeschen

/*************************** kleinkram ***************************/
inline bool istselekt(int nr)
   {return (selektbildnr>0 && nr==jreihenfolge[selektbildnr-1]);}

int index(const char *s1,const char *s2) /* Sucht den String s2 innerhalb von */
{			 /* s1 und  gibt Position zurueck (nicht gefunden: -1)*/
 int i,c;
 const char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

char *ohneletztenpunkt(char *name)  /* die Endung .xxx loeschen */
{
 char c=0,*s; int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='.')
        {--i; --s;}
 if(c=='.') *s='\0';
 return name;
}
void ohnepfad(char *ziel,const char *name,int max)
{
 char c,*z;
 const char *s;
 int i;
 for(i=0,s=name;*s!=0;s++,i++) ;
 while(i>0 && (c= *s)!='/' && c!=':' && c!='\\')
	{--i; --s;}
 for(i=1,z=ziel;i<max && (c= *s++)!=0;i++)
	*z++ = c;
 *z=0;
}
const char *ohnevornummer(const char *name)
{
 int c;
 const char *s;
 for(s=name;(c= *s++)!=0 && isdigit(c);) ;
 if(c!='-' && s!=name) --s;
 return s;
}
char *anhaengen(char *name,const char *t)
{
 char *s;
 for(s=name;*s!=0;s++) ;
 for(;*s++ = *t++;) ;
 return name;
}
char *endungersetzen(char *neu,const char *name,const char *endung)
{
 strcpy(neu,name); ohneletztenpunkt(neu); anhaengen(neu,endung);
 return neu;
}

int system1(const char *s,int k)
{
 if(test>=2) fprintf(STDERR,"system%d> %s\n",k,s);
 int n=system(s);
 if(n!=0)
   {if(n==127) fprintf(STDERR,"Fehler %d in system(): fehlendes /bin/sh\n",n);
    else if(n<0) {fprintf(STDERR,"Fehler %d in system(%s)\n",n,s); fehlermeldung(n);}
    else if(test>=2) fprintf(STDERR,"Rueckgabewert von system() = %d\n",n);
   }
 return n;
}
//void system2(const char *s,char *p1,const char *p2=NULL) weiter oben
int system2(const char *s,const char *p1,const char *p2)
{
 char str[2*N80+80];
 sprintf(str,s,vollpfad(p1),vollpfad(p2));
 return system1(str,2);
}
void system2ds(const char *s,int n1,const char *p2)
{
 char str[N80+80];
 sprintf(str,s,n1,vollpfad(p2));
 system1(str,2);
}
void system3(const char *s,int p1,const char *p2,const char *p3)
{
 char str[2*N80+80];
 sprintf(str,s,p1,vollpfad(p2),vollpfad(p3));
 system1(str,3);
}

void rename2(const char *p1,const char *p2)
{
 int err=rename(vollpfad(p1),vollpfad(p2));
 if(err) fprintf(STDERR,"Fehler %d: rename2(%s,%s)\n",err,p1,p2);
}

bool istspace(int c)
{
 return (c=='\n' || c==' ');
}

/* nicht gebraucht
vektor drehenl(vektor& v,double sina,double cosa) //Vektor nach links drehen
{
 return vektor(v.x*cosa-v.y*sina, v.x*sina+v.y*cosa);
}
*/
vektor drehenr(vektor& v,double sina,double cosa) //Vektor nach rechts drehen
{
 return vektor(v.x*cosa+v.y*sina, v.y*cosa-v.x*sina);
}

bool vorhanden(const char *dateiname)
{
 struct stat buf;
 return (lstat(dateiname,&buf)>=0);
}
inline bool vorhanden2(const char *name) {return vorhanden(vollpfad(name));}

bool istordner(char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 //if(buf.st_mode & S_IFDIR) return true;
 if((buf.st_mode & S_IFMT)==S_IFDIR) return true;
 return false;
}
bool istregulaer(char *dateiname) //Regulaere Datei ohne Softlink ohne Ordner
{
 struct stat buf; //siehe man lstat
 //(Fehler in man lstat: S_IFMT ist nicht 0017000 sondern 0170000)
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFREG) return true;
 return false;
}
bool istsoftlink(const char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;
 if((buf.st_mode & S_IFMT)==S_IFLNK) return true;
 return false;
}
bool isteinlink(const char *dateiname)
{
 struct stat buf;
 if(lstat(dateiname,&buf)<0) return false;//nicht vorhanden
 if((buf.st_mode & S_IFMT)==S_IFLNK) return true;//Softlink
 if(buf.st_nlink>1) return true;//Hardlink
 return false;
}

void machklein(char *s)
{
 int c;
 while(c= *s++)
     if(c>='A' && c<='Z')
	 {c += 'a'-'A';
	  *--s = c;
	  s++;
	 }
}

bool isttext(int c)
{
 // return (isprint(c));
 // return ((c>='a' && c<'z') || (c>='A' && c<='Z') || (c>='0' && c<='9')
 //    || c=='.' || c==':' || c==' ' || c==',' || c=='-' || c=='+' || c=='_');
 return (c>=' ' && c<='z');
}

bool istunsinn(char *s)
{
 int c,n1=0,n2=0;
 while(c= *s++) if(isttext(c)) n1++; else n2++;
 return (2*n2>=n1);
}

bool istbilddatei(const char *name)
{
 int n=strlen(name);
 if(n<5) return false;
 if(name[n-4]=='.')
   return (strcmp(&name[n-3],"jpg")==0 || strcmp(&name[n-3],"gif")==0 ||
	   strcmp(&name[n-3],"JPG")==0 || strcmp(&name[n-3],"GIF")==0 ||
	   strcmp(&name[n-3],"TIF")==0 || strcmp(&name[n-3],"tif")==0 ||
	   strcmp(&name[n-3],"png")==0 || strcmp(&name[n-3],"PNG")==0);
 else if(n>5 && name[n-5]=='.')
   return (strcmp(&name[n-4],"jpeg")==0 || strcmp(&name[n-4],"JPEG")==0 ||
	   strcmp(&name[n-4],"tiff")==0 || strcmp(&name[n-4],"TIFF")==0
	   );
 return false;
}

/* Ab Version 1.08 zum nach Aufnahmedatum sortieren (wie in rexifsort.cc) */
/*********************** Exif extrahieren *********************************/
//TODO: #include "exifklasse.cc"
const int MAXTAG=200,MAXPU=20000;
static char puffer[MAXPU];//provi.

class Exif
{
 unsigned char head1[16];
 bool bigendian;
 long nb;//Anzahl gelesene Bytes nach "Exif\0\0"
 long offset,zeit1,zeit2,zeit3;
 int ntags;
 int tag[MAXTAG],tagtyp[MAXTAG];
 long tagwert[MAXTAG],taganz[MAXTAG];
 int pufferlesen2(char *p0=NULL);
 long pufferlesen4(char *p0=NULL);
public:
 char szeit[32];
 Exif() {bigendian=false; ntags=0; nb=0; *szeit=0;}
 int headerlesen(FILE *fp);
 int wordlesen(FILE *fp);
 long longlesen(FILE *fp);
 void tagslesen(FILE *fp,int n=0);
 const char *tagauswerten(int t);
 const char *einentagauswerten(int i);
 void alletagsauswerten();
};
static Exif exif;

int Exif::headerlesen(FILE *fp) //Rueckgabe im Fehlerfall=0
{
 int c,i,j;
 ntags=0; nb=0; *szeit=0;
 for(i=0;i<16 && (c=getc(fp))!=EOF;i++)
    head1[i]=c;
 if((head1[0]&0xFF)!=0xFF || (head1[1]&0xFF)!=0xD8)
   {/*fprintf(STDERR,"SOI fehlt\n");*/ return 0;}
 if((head1[2]&0xFF)!=0xFF || (head1[3]&0xFF)!=0xE1)
   {for(j=0;j<100 && ((head1[2]&0xFF)!=0xFF || (head1[3]&0xFF)!=0xE1);j++)
       {for(int k=2;k<14;k+=2)  //k++ war offenbar falsch, Warnung mit neuerem Compiler
	   {head1[k]=head1[k+2]; head1[k+1]=head1[k+3];}
	head1[14]=getc(fp); head1[15]=getc(fp);
       }
     if(j==100) {/*fprintf(STDERR,"APP1 fehlt\n");*/ return 0;}
   }
 const char *head2=(char*)&head1[6];
 if(strcmp(head2,"Exif")!=0) {/*fprintf(STDERR,"Exif fehlt\n");*/ return 0;}
 nb=4;
 if(test>1) fprintf(STDERR,"Exif ");
 bigendian=(head2[6]=='M');
 if(test>1) fprintf(STDERR,"%s\n",(bigendian)?"Big-Endian":"Little-Endian");
 if(head2[7]!=head2[6])
    fprintf(STDERR,"Fehler im TIFF-Header: Exif %s\n",&head2[6]);
 if(bigendian) c=head2[9]+(head2[8]<<8);
 else c=head2[8]+(head2[9]<<8);
 if(c!=0x2A) fprintf(STDERR,"Fehler im TIFF-Header: %s 0x%04X\n",&head2[6],c);
 long n1=longlesen(fp);
 for(long j=8;j<n1;j++)
   {getc(fp); nb++;}//Offset nach dem TIFF-Header ueberlesen
 return i;
}
long Exif::longlesen(FILE *fp)
{
 long n;
 unsigned char c1,c2,c3,c4;
 c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
 nb+=4;
 if(bigendian)
      n=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 else n=(c4<<24)+(c3<<16)+(c2<<8)+c1;
 return n;
}
int Exif::wordlesen(FILE *fp)
{
 int n;
 unsigned char c1,c2;
 c1=getc(fp); c2=getc(fp);
 nb+=2;
 if(bigendian)
      n=(c1<<8)+c2;
 else n=(c2<<8)+c1;
 return n;
}
int Exif::pufferlesen2(char *p0)
{
 static unsigned char *p=NULL;
 int n;
 unsigned char c1,c2;
 if(p0!=NULL) p=(unsigned char*)p0;
 c1= *p++; c2= *p++;
 if(bigendian)
      n=(c1<<8)+c2;
 else n=(c2<<8)+c1;
 return n;
}
long Exif::pufferlesen4(char *p0)
{
 static unsigned char *p=NULL;
 long n;
 unsigned char c1,c2,c3,c4;
 if(p0!=NULL) p=(unsigned char*)p0;
 c1= *p++; c2= *p++;
 c3= *p++; c4= *p++;
 if(bigendian)
      n=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 else n=(c4<<24)+(c3<<16)+(c2<<8)+c1;
 return n;
}

const int TYP_BYTE=1,TYP_ASCII=2,TYP_SHORT=3,TYP_LONG=4,TYP_RATIONAL=5;
const int TYP_UNDEFINED=7,TYP_SLONG=9,TYP_SRATIONAL=10;

//LONG-Tags:
const int TAG_ExifIFD=0x8769,TAG_GPSIFD=0x8825,TAG_Interop=0xA005,
  TAG_ExifWidth=0xA002,TAG_ExifHeight=0xA003,
//ASCII-Tags:
  TAG_DateTime=0x132, //Datum und Zeit in der Form "2008:11:30 08:15:00"
  TAG_DateOrig=0x9003,//Aufnahme-Datum+Zeit
  TAG_DateDigi=0x9004,//Digitalisierungs-Datum+Zeit
  TAG_Make=0x10F, //Kamera-Hersteller
  TAG_Model=0x110,//Kamera-Modell
  TAG_ImageDesc=0x10E,TAG_Software=0x131,TAG_Artist=0x13B,TAG_Copyr=0x8298;

void Exif::tagslesen(FILE *fp,int n)
{
 int i;
 bool nullterifd;
 if(test>=2) fprintf(STDERR,"tagslesen() nb=0x%lX\n",nb);//test
 if(n==0)
   {n=wordlesen(fp);
    if(test>1) fprintf(STDERR,"Anzahl Exif-Tags n=%d\n",n);
    nb+=offset;
    nullterifd=false;
   }
 else
   nullterifd=true;
 offset=0;
 ntags=0;
 if(n>MAXTAG)
   {if(test) fprintf(STDERR,"Fehler: n=%d ist groesser MAXTAG=%d\n",n,MAXTAG);
    return;
   }
 for(i=0;i<n;i++)
   {tag[ntags]=wordlesen(fp);
    tagtyp[ntags]=wordlesen(fp);
    taganz[ntags]=longlesen(fp);
    tagwert[ntags]=longlesen(fp);
    if(test>=2) printf("tag=0x%X typ=%d anzahl=%ld wert=0x%04lX\n",
		    tag[ntags],tagtyp[ntags],taganz[ntags],tagwert[ntags]);
    if(nullterifd==false)
      {bool istzeiger;
       int k;
       switch(tagtyp[ntags])
	{case TYP_ASCII: case TYP_UNDEFINED:
	                 k=1; istzeiger=(taganz[ntags]>4); break;
	 case TYP_SHORT: k=2; istzeiger=(taganz[ntags]>2); break;
	 case TYP_LONG: case TYP_SLONG: k=4; istzeiger=(taganz[ntags]>1); break;
	 default: k=8; istzeiger=true; //RATIONAL oder SRATIONAL
	}
       if(istzeiger)
	 {long m=tagwert[ntags]+k*taganz[ntags];
	  if(m>offset) offset=m;
	 }
      }
    switch(tag[ntags])
      {case TAG_ExifIFD:
	  offset=tagwert[ntags];
	  if(test>1) fprintf(STDERR," ExifID-Pointer Offset=0x%lX\n",offset);
	  break;
       case TAG_DateTime: zeit1=tagwert[ntags]; break;
       case TAG_DateOrig: zeit2=tagwert[ntags];	break;
       case TAG_DateDigi: zeit3=tagwert[ntags]; break;
       case TAG_Make: case TAG_Model:
	  break;
       case TAG_ImageDesc: case TAG_Software: case TAG_Artist: case TAG_Copyr:
	  break;
       default:
	 if(test>=2) fprintf(STDERR,"Unbekannter Tag: 0x%X Typ=%d\n",
			    tag[ntags],tagtyp[ntags]);
      }
    if(ntags>=MAXTAG-1) fprintf(STDERR,"zu wenig Platz fuer %d Tags\n",n);
    else ntags++;
   }
 if(nullterifd)
   {if(offset==0) {fprintf(STDERR,"fehlender ExifID-Pointer\n"); offset=2000;}
    offset -= nb;
   }
 else
   {if(offset==0) {fprintf(STDERR,"Fehler: offset==0\n"); offset=2000;}
    //else offset+=100;//test
    offset -= nb;
   }
 char *s;
 if(offset<=0) {fprintf(STDERR,"Fehler: offset zu klein\n"); offset=0;}
 if(test>=2) printf("%ld Bytes einlesen\n",offset);
 if(offset>MAXPU)
   {fprintf(STDERR,"Offset=0x%lX zu gross\n",offset); offset=MAXPU;}
 for(i=0,s=puffer;i<offset;i++)
   *s++ = getc(fp);
 if(test>=2) for(i=0;i<32;i++) //test
   {printf("%02X",puffer[i]); if(i&1) printf(" "); if(i%16==15) printf("\n");}
}
const char* Exif::tagauswerten(int t)
{
 //if(test) fprintf(STDERR,"Exif::tagauswerten(0x%X)  nb=0x%X\n",t,nb);//test
 int i;
 for(i=0;i<ntags && tag[i]!=t;i++) ;
 if(i==ntags) return NULL;
 return einentagauswerten(i);
}
const char* Exif::einentagauswerten(int i)
{
 static char str[80];
 long uk=nb;
 if(tagtyp[i]==TYP_ASCII)
   {if(taganz[i]<=4) return (char*)tagwert[i];
    return &puffer[tagwert[i]-uk];
   }
 if(tagtyp[i]==TYP_SHORT)
   {unsigned short a,b,c;
    if(taganz[i]==1) {a=tagwert[i]>>16; sprintf(str,"%d",a);}
    else if(taganz[i]==2) {a=tagwert[i]>>16; b=tagwert[i]&0xFFFF;
                           sprintf(str,"%d",a);}
    else
       {a=pufferlesen2(&puffer[tagwert[i]-uk]);
	b=pufferlesen2(); c=pufferlesen2();
	if(taganz[i]==3) sprintf(str,"0x%04X 0x%04X 0x%04X",a,b,c);
	else sprintf(str,"0x%04X 0x%04X 0x%04X ...",a,b,c);
       }
    return str;
   }
 if(tagtyp[i]==TYP_LONG)
   {if(taganz[i]==1) sprintf(str,"%ld",tagwert[i]);
    else {unsigned long a=pufferlesen4(&puffer[tagwert[i]-uk]),
	                b=pufferlesen4();
          if(taganz[i]==2) sprintf(str,"0x%08lX 0x%08lX",a,b);
          else sprintf(str,"0x%08lX 0x%08lX ...",a,b);
         }
    return str;
   }
 if(tagtyp[i]==TYP_SLONG)
   {if(taganz[i]==1) sprintf(str,"%ld",tagwert[i]);
     else {long a=pufferlesen4(&puffer[tagwert[i]-uk]),b=pufferlesen4();
          if(taganz[i]==2) sprintf(str,"0x%08lX 0x%08lX",a,b);
          else sprintf(str,"0x%08lX 0x%08lX ...",a,b);
         }
    return str;
   }
 if(tagtyp[i]==TYP_RATIONAL)
   {unsigned long a=pufferlesen4(&puffer[tagwert[i]-uk]), b=pufferlesen4();
     sprintf(str,"%ld/%ld=%lf",a,b,a/double(b)); return str;
   }
 if(tagtyp[i]==TYP_SRATIONAL)
   {long a=pufferlesen4(&puffer[tagwert[i]-uk]), b=pufferlesen4();
    sprintf(str,"%ld/%ld=%lf",a,b,a/double(b)); return str;
   }
 if(tagtyp[i]==TYP_UNDEFINED)
   {unsigned char *a;
    if(taganz[i]<=4) sprintf(str,"0x%08lX",tagwert[i]);
    else
     {a=(unsigned char*)&puffer[tagwert[i]-uk];
      if(taganz[i]==5)
	sprintf(str,"%02X %02X %02X %02X %02X %02X",a[0],a[1],a[2],a[3],a[4],a[5]);
      else sprintf(str,"%02X %02X %02X %02X %02X %02X...",a[0],a[1],a[2],a[3],a[4],a[5]);
     }
    return str;}
 fprintf(STDERR,"unbekannter tagtyp=%d\n",tagtyp[i]);
 return NULL;
}
void Exif::alletagsauswerten()
{
 const char *s;
 for(int i=0;i<ntags;i++)
   {s=einentagauswerten(i);
    printf("Tag=0x%04X Typ=%d '%s'\n",tag[i],tagtyp[i],s);
   }
}

/*
void exiflist(const char *name)
{
 int i,k1;
 const char *s;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("'%s' nicht gefunden.\n",name); return;}
 if(exif.headerlesen(fp)==0) return;
 k1=exif.wordlesen(fp); //Anzahl Tags im 0.IFD
 if(test) fprintf(STDERR,"Anzahl Tags im 0.IFD = %d\n",k1);
 exif.tagslesen(fp,k1);
 s=exif.tagauswerten(TAG_DateTime); //identisch mit Aufnahmezeit?
 if(s!=NULL) printf("Zeitstempel: '%s'\n",s);
 s=exif.tagauswerten(TAG_Make);
 if(s!=NULL) printf("Kameraherst: '%s'\n",s);
 s=exif.tagauswerten(TAG_Model);
 if(s!=NULL) printf("  Kameratyp: '%s'\n",s);
 if(argflag['L'])
   {printf("Alle 0.IFD-Tags auswerten:\n");
    exif.alletagsauswerten();
   }
 exif.tagslesen(fp); //jetzt die Tags im Exif-IFD lesen
 s=exif.tagauswerten(TAG_DateOrig); //Das muesste die Aufnahmezeit sein
 if(s!=NULL) printf("Zeitstempel2: '%s'\n",s);
 s=exif.tagauswerten(TAG_DateDigi); //identisch oder kurz danach (1 Sek)
 if(s!=NULL) printf("Zeitstempel3: '%s'\n",s);
 s=exif.tagauswerten(TAG_ExifWidth);
 if(s!=NULL)
   {char s1[strlen(s)+1]; strcpy(s1,s);
    s=exif.tagauswerten(TAG_ExifHeight);
    printf("Exif-Aufloesung: %sx%s\n",s1,s);
   }
 fclose(fp);
 if(argflag['L'])
   {printf("Alle Exif-IFD-Tags auswerten:\n");
    exif.alletagsauswerten();
   }
}
*/

char* exifdatum(const char *name)
{
 int i,k1,szeitok=0;
 static char szeit[32];
 const char *s;
 *szeit=0;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {fprintf(STDERR,"exifdatum() '%s' nicht gefunden.\n",name); return szeit;}
 if(exif.headerlesen(fp)==0) return szeit;
 k1=exif.wordlesen(fp); //Anzahl Tags im 0.IFD
 exif.tagslesen(fp,k1);
 s=exif.tagauswerten(TAG_DateTime); //identisch mit Aufnahmezeit?
 if(s!=NULL)
   {if(strlen(s)!=19) {fprintf(STDERR,"\"%s\" Falscher Zeitstempel: '%s'\n",name,s);}
    else szeitok=1;
    strncpy(szeit,s,32-1); szeit[32-1]=0;
   }
 if(test>=2) exif.alletagsauswerten();//Alle 0.IFD-Tags auswerten
 exif.tagslesen(fp); //jetzt die Tags im Exif-IFD lesen
 s=exif.tagauswerten(TAG_DateOrig);
 if(s!=NULL)
   {if(strlen(s)!=19) fprintf(STDERR,"\"%s\" falscher Zeitstempel2: '%s'\n",name,s);
    else if(*szeit==0 || szeitok==0) {strcpy(szeit,s); szeitok=1;}
    else if((i=strcmp(s,szeit))!=0)
       {fprintf(STDERR,"\"%s\" unterschiedlicher Zeitstempel2: '%s'\n",name,s);
	if(i<0) strcpy(szeit,s);//fruehere Zeit behalten
       }
   }
 s=exif.tagauswerten(TAG_DateDigi);
 if(s!=NULL)
   {if(strlen(s)!=19) fprintf(STDERR,"\"%s\" falscher Zeitstempel3: '%s'\n",name,s);
    else if(*szeit==0 || szeitok==0) {strcpy(szeit,s); szeitok=1;}
    else if((i=strcmp(s,szeit))!=0)
       {fprintf(STDERR,"\"%s\" unterschiedlicher Zeitstempel3: '%s'\n",name,s);
	if(i<0) strcpy(szeit,s);//fruehere Zeit behalten
       }
   }
 fclose(fp);
 //fprintf(STDERR,"Testpunkt exifdatum(): return \"%s\"\n",szeit);//test
 return szeit;
}

/********* Ab Version 1.05 mylsmit() zum wegoptimieren von tmp.txt *********/
const int M80=MAXD;//maximale laenge von Dateinamen
const int NORM=1,VERZ=2,SPEZ=3,LINK=4;//Dateitypen

class Dateiliste
{
public:
 char name[N80],sort[N80];
 int typ;
 Dateiliste *next;
 Dateiliste() {name[0]=0; typ=0; next=NULL;}
 ~Dateiliste() {if(next!=NULL) delete[] next;}
 //char& operator[](int i) {return name[i];}
 bool operator<=(Dateiliste& y);
 Dateiliste* einsortieren(const char *neuername,int t,const char *so="zzz");
 Dateiliste* einsortieren(Dateiliste *neu);
};
static Dateiliste *tmpdateiliste=NULL,*tmpdateiliste2=NULL;

bool Dateiliste::operator<=(Dateiliste& y)
{
 int i,c1,c2;
 for(i=0;(c1=sort[i])!=0 && (c2=y.sort[i])!=0;i++)
   {c1 &= 0xFF; c2 &= 0xFF;
    if(c1<c2) return true;
    else if(c1>c2) return false;
   }
 if(sort[i]==0 && y.sort[i]!=0) return true;
 if(sort[i]!=0 && y.sort[i]==0) return false;
 for(i=0;(c1=name[i])!=0 && (c2=y.name[i])!=0;i++)
   {c1 &= 0xFF; c2 &= 0xFF;
    if(c1<c2) return true;
    else if(c1>c2) return false;
   }
 if(name[i]==0) return true;
 if(y.name[i]==0) return false;
 fprintf(STDERR,"Dateiliste::operator<=() kein eindeutiges Resultat:\n\
 sort1='%s' sort2='%s' name1='%s' name2='%s'\n",sort,y.sort,name,y.name);//test
 return true;
}
Dateiliste* Dateiliste::einsortieren(const char *neuername,int t,const char *so)
{
 if(name[0]==0 && next==NULL)
   {//erster Eintrag in leere Liste
    strncpy(name,neuername,N80); name[N80-1]=0;
    strncpy(sort,so,N80); sort[N80-1]=0;
    typ=t;
    return this;
   }
 Dateiliste *neu=new Dateiliste[1];
 if(neu==NULL) {fprintf(STDERR,"Fehler: new fehlgeschlagen.\n"); return this;}
 strncpy(neu->name,neuername,N80); neu->name[N80-1]=0;
 strncpy(neu->sort,so,N80); neu->sort[N80-1]=0;
 neu->typ=t;
 return einsortieren(neu);
}
Dateiliste* Dateiliste::einsortieren(Dateiliste *neu)
{
 if((*neu) <= (*this)) {neu->next=this; return neu;}
 if(next==NULL) next=neu;
 else next=next->einsortieren(neu);
 return this;
}

const char *typ2str(int typ)
{
 const char *styp;
 static char str[40];
 switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: sprintf(str,"(%03X)",typ); styp=str;
      }
 return styp;
}

const char *nummerextrakt(const char *s)
{
 static char str[16];
 int c,i,n,nmax=0;
 for(i=0;(c= *s)!=0;s++,i++)
   if(isdigit(c))
     {sscanf(s,"%d",&n); if(n>nmax) nmax=n;
      while(isdigit(c= *++s)) ;
      if(c==0) break;
     }
 sprintf(str,"%06d",n);
 return str;
}

const char *sortstr(const char *name)
{
 if(sortiermethode==3) return nummerextrakt(name);
 else if(sortiermethode==1) return name;
 //else (sortiermethode==2)
 const char *s=exifdatum(vollpfad(name));
 if(s==NULL || *s==0) return "zzz";//kein Zeitstempel
 if(strlen(s)!=19) //falscher Zeitstempel
  {static int korr17=0,autoflag=0;
   static char sneu[32];
   int ok;
   if(strlen(s)==17)
    {if(korr17==0)
      {sprintf(scratch,"\"%s\" hat falschen Zeitstempel\noder fehlerhafte Zeit:'%s'\n\
Sollen alle entsprechenden Zeiten mit einem vorangestellten \"20\" korrigiert werden?",name,s);
       ok=janeinrequester(scratch,"ja","nein");
       if(ok) korr17=1;
      }
     if(korr17==1) {sprintf(sneu,"20%s",s); return sneu;}
    }
   if(autoflag==0)
      {char fehlermeldung[N80],zeit[80];
       int flag=0;
       sprintf(fehlermeldung,"\"%s\" hat fehlerhaften Zeitstempel",name);
       strcpy(zeit,s);
       ok=requester_input(2,fehlermeldung,"%s","%s\n",zeit,
		"fehlerhafte Zeit trotzdem nehmen? 0=nein 1=ja 2=niemals 3=immer",
		"%d","%d",&flag);
       if(!ok) flag=0;
       if(flag==3 || flag==1)
	{strncpy(sneu,zeit,32-1); sneu[32-1]=0; s=sneu; if(flag==3) autoflag=flag;}
       else if(flag==2) {autoflag=flag; s="zzz";}
       else s="zzz";
      }
   else if(autoflag==2) s="zzz";//nie fehlerhafte Zeit nehmen
   //else if(autoflag==3) ;//immer trotzdem nehmen
  }
 return s;
}

Dateiliste* mylsmit(const char *ordner)
{ //erstellt nach sortiermethode sortierte Dateiliste
 char *pfadname=NULL;
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 int j,typ;
 Dateiliste *liste=new Dateiliste[1];
 if(ordner==NULL || *ordner==0) ordner=".";
 ordner=vollpfad(ordner);
 pfadname=new char[strlen(ordner)+M80+2];
 dp=opendir(ordner);
 if(dp==NULL) {fprintf(STDERR,"kann Ordner '%s' nicht oeffnen.\n",ordner); return NULL;}
 for(j=0;(dirp=readdir(dp))!=NULL;j++)
   {//if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    if(dirp->d_name[0]=='.') continue;//alle versteckten Dateien ignorieren
    sprintf(pfadname,"%s/%s",ordner,dirp->d_name);
    if(lstat(pfadname,&statbuf) < 0)
      typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    if((typ==NORM || typ==LINK) //nur gewoehnliche Dateien und Links
       && istbilddatei(dirp->d_name)) //und nur Bilddateien
      {if(sortiermethode==1) liste=liste->einsortieren(dirp->d_name,typ);
       else liste=liste->einsortieren(dirp->d_name,typ,sortstr(dirp->d_name));
      }
   }
 closedir(dp);
 delete[] pfadname;
/* test:
 Dateiliste *p;
 for(p=liste;p!=NULL;p=p->next)
   if(p->typ==NORM) printf("%s\n",&p[0]);
   else printf("%s  \t%s\n",&p[0],typ2str(p->typ));
 printf("%d Dateien.\n",j);
*/
 return liste;
}

/*************************** Haupt-Klassen ****************************/
class Intvector2
{
public:
 int x,y;
};

class Fvector
{
public:
 double r,g,b;
 Fvector(double r0,double g0,double b0) {r=r0; g=g0; b=b0;}
 Fvector operator+(Fvector p) {return Fvector(r+p.r,g+p.g,b+p.b);}
 Fvector operator*(double z) {return Fvector(z*r,z*g,z*b);}
};

class Farbvector
{
public:
 UWORD r,g,b;
 Farbvector() {}
 Farbvector(int n) {r=g=b=n;}
 Farbvector(Fvector f) {r=int(f.r); g=int(f.g); b=int(f.b);}
 void operator+=(Farbvector& y) {r+=y.r; g+=y.g; b+=y.b;}
 void operator*=(int n) {r*=n; g*=n; b*=n;}
 void operator*=(double z) {r=int(r*z+0.5); g=int(g*z+0.5); b=int(b*z+0.5);}
 void operator/=(int n) {r/=n; g/=n; b/=n;}
 void operator^=(int p2) {r=p2-r; g=p2-g; b=p2-b;}
 Fvector operator*(double z) {return Fvector(z*r,z*g,z*b);}
 //void setrgb(int r1,int g1,int b1) {r=r1; g=g1; b=b1;}//test
};
class Bild
{
 Farbvector *p;
 int nsum;
public:
 int imax,jmax;
 int offsetx,offsety,sortiernummer,rotnr,loeschflag;
 char bildname[N80];
 Bild() {imax=jmax=0; p=NULL; offsetx=offsety=sortiernummer=rotnr=loeschflag=0; nsum=1; *bildname=0;}
 ~Bild() {clear();}
 void clear()
	{if(imax!=0) {imax=jmax=0; delete[] p;}
	 offsetx=offsety=0;
	}
 int init(int i,int j,int offx=0,int offy=0)
	{if(imax!=0) {delete[] p;}
	 imax=i; jmax=j; offsetx=offx; offsety=offy;
	 rotnr=loeschflag=0;
	 p=new Farbvector[imax*jmax];
	 if(p==NULL) {fprintf(STDERR,"zu wenig RAM in init\n"); return -1;}
	 return 0;
	}
 void setrgb(int i,int j,int r,int g,int b);
 void zeichnen(int ramenflag=0);
 int save(const char*);
 Bild& operator=(Bild& y);
 void operator+=(Bild& y); //y dazuaddieren ohne Bildgroesse zu aendern
 void operator|=(Bild& y); //y dazuaddieren und Bildgroesse anpassen
 void operator&=(Bild& y); //mit y ueberschreiben und Bildgroesse anpassen
 void operator/=(int);
 void operator*=(int);
 void operator*=(double);
// void setoffset(int x,int y) {offsetx=x; offsety=y;}
 int cut(int br,int ho,int ox,int oy,Bild& y);
 Farbvector getpixel(int i,int j)
	{return (i>=0 && i<imax && j>=0 && j<jmax)?p[j*imax+i]:Farbvector(0);}
 void getminmaxpixel(int* pmin,int* pmax);
 void getminmaxpixel(int* rmin,int* rmax,int* gmin,int* gmax,int* bmin,int* bmax);
 void addpix(int r,int g,int b,bool ug,bool og);
 void mulpix(double r,double g,double b,bool ug,bool og);
 void negativ();
 void vergroessern(bool zwi,Bild& b1,double v);
 void drehen(bool zwi,Bild& b1,double sina,double cosa,double v=1.0);
 void einfachesdrehen(int grad);
 void umbenennen();
};
Bild& Bild::operator=(Bild& y)
{
 int er=init(y.imax,y.jmax,y.offsetx,y.offsety);
 int i,n=imax*jmax;
 if(er==0)
  for(i=0;i<n;i++)
     {p[i] = y.p[i];}
 strcpy(bildname,y.bildname);
 sortiernummer=y.sortiernummer;
 rotnr=y.rotnr;
 loeschflag=y.loeschflag;
 return *this;
}
void Bild::operator+=(Bild& y)
{
 int i,j,iy,jy,n=0,ny;
 for(j=0,jy=offsety-y.offsety;j<jmax;j++,jy++)
 for(i=0,iy=offsetx-y.offsetx;i<imax;i++,iy++,n++)
    if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
     {ny=jy*y.imax+iy;
      p[n] += y.p[ny];
     }
}
int Bild::cut(int br,int ho,int ox,int oy,Bild& y)
{
 int er=init(br,ho,ox,oy);
 int i,j,iy,jy,n=0,ny;
 if(er==0)
 for(j=0,jy=offsety-y.offsety;j<jmax;j++,jy++)
 for(i=0,iy=offsetx-y.offsetx;i<imax;i++,iy++,n++)
    if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
     {ny=jy*y.imax+iy;
      p[n] = y.p[ny];
     }
 return er;
}
void Bild::operator|=(Bild& y)
{
 if(offsetx==y.offsetx && offsety==y.offsety && imax==y.imax && jmax==y.jmax)
    {operator+=(y); return;}
 int n,im,jm,ox,oy,i,j,iy,jy,ny,iz,jz,nz;
 UWORD u1,u2;
 Farbvector *np;
 if(offsetx>=y.offsetx)
   {ox=y.offsetx; im=offsetx-ox+imax; if(y.imax>im) im=y.imax;}
 else
   {ox=offsetx; im=y.offsetx-ox+y.imax; if(imax>im) im=imax;}
 if(offsety>=y.offsety)
   {oy=y.offsety; jm=offsety-oy+jmax; if(y.jmax>jm) jm=y.jmax;}
 else
   {oy=offsety; jm=y.offsety-oy+y.jmax; if(jmax>jm) jm=jmax;}
 n=im*jm;
 np=new Farbvector[n];
 if(np==NULL) {fprintf(STDERR,"zu wenig RAM in operator|=\n"); return;}
 for(j=0,n=0;j<jm;j++)
 for(i=0;i<im;i++,n++)
    {iz=i+ox-offsetx; jz=j+oy-offsety;
     iy=i+ox-y.offsetx; jy=j+oy-y.offsety;
     if(iz>=0 && iz<imax && jz>=0 && jz<jmax) {nz=jz*imax+iz; u1=p[nz].r;}
     else {nz= -1; u1=0;}
     if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
	  {ny=jy*y.imax+iy; u2=y.p[ny].r;}
     else {ny= -1;  u2=0;}
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].r=u1+u2;
     if(nz>=0) u1=p[nz].g; else u1=0;
     if(ny>=0) u2=y.p[ny].g; else u2=0;
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].g=u1+u2;
     if(nz>=0) u1=p[nz].b; else u1=0;
     if(ny>=0) u2=y.p[ny].b; else u2=0;
     if(nz>=0 && ny<0) u2=u1/nsum; else if(nz<0 && ny>=0) u1=u2;
     np[n].b=u1+u2;
    }
 delete[] p;
 p=np;
 imax=im; jmax=jm; offsetx=ox; offsety=oy;
 nsum++;
}
void Bild::operator&=(Bild& y)
{
 if(offsetx==y.offsetx && offsety==y.offsety && imax==y.imax && jmax==y.jmax)
    {operator+=(y); return;}
 int n,im,jm,ox,oy,i,j,iy,jy,ny,iz,jz,nz,higrund=0x80;
 UWORD u1,u2;
 Farbvector *np;
 if(offsetx>=y.offsetx)
   {ox=y.offsetx; im=offsetx-ox+imax; if(y.imax>im) im=y.imax;}
 else
   {ox=offsetx; im=y.offsetx-ox+y.imax; if(imax>im) im=imax;}
 if(offsety>=y.offsety)
   {oy=y.offsety; jm=offsety-oy+jmax; if(y.jmax>jm) jm=y.jmax;}
 else
   {oy=offsety; jm=y.offsety-oy+y.jmax; if(jmax>jm) jm=jmax;}
 n=im*jm;
 np=new Farbvector[n];
 if(np==NULL) {fprintf(STDERR,"zu wenig RAM in operator&=\n"); return;}
 for(j=0,n=0;j<jm;j++)
 for(i=0;i<im;i++,n++)
    {iz=i+ox-offsetx; jz=j+oy-offsety;
     iy=i+ox-y.offsetx; jy=j+oy-y.offsety;
     if(iz>=0 && iz<imax && jz>=0 && jz<jmax) {nz=jz*imax+iz; u1=p[nz].r;}
     else {nz= -1; u1=higrund;} //grauer Hintergrund
     if(iy>=0 && iy<y.imax && jy>=0 && jy<y.jmax)
	  {ny=jy*y.imax+iy; u2=y.p[ny].r;}
     else {ny= -1;  u2=u1;}
     np[n].r=u2;
     if(nz>=0) u1=p[nz].g; else u1=higrund;
     if(ny>=0) u2=y.p[ny].g; else u2=u1;
     np[n].g=u2;
     if(nz>=0) u1=p[nz].b; else u1=higrund;
     if(ny>=0) u2=y.p[ny].b; else u2=u1;
     np[n].b=u2;
    }
 delete[] p;
 p=np;
 imax=im; jmax=jm; offsetx=ox; offsety=oy;
}
void Bild::operator/=(int m)
{
 int i,n=imax*jmax;
 if(m==0) m=nsum;
 for(i=0;i<n;i++)
     {p[i] /= m;}
 nsum=1;
}
void Bild::operator*=(int m)
{
 int i,n=imax*jmax;
 for(i=0;i<n;i++)
     {p[i] *= m;}
}
void Bild::operator*=(double z)
{
 int i,n=imax*jmax;
 for(i=0;i<n;i++)
     {p[i] *= z;}
}
void Bild::setrgb(int i,int j,int r,int g,int b)
{
 int n=i+j*imax; p[n].r=r; p[n].g=g; p[n].b=b;
}

int farbnummer(int r,int g,int b)
{
 if(TIEFE>=24)
   return (r<<16)+(g<<8)+b;
 if(TIEFE==16)
 {while(r<8 && g<8 && b<8 && (r>1 || g>1 || b>1)) {r<<=1; g<<=1; b<<=1;}
  return ((r&0xF8)<<8)+((g&0xF8)<<3)+((b&0xF8)>>2);
 }
 if(TIEFE==12)
   return ((r&0xF0)<<4)+(g&0xF0)+((b&0xF0)>>4);
 //if(TIEFE==8)
 return (r&0xE0)+((g>>3)&0x1C)+((b>>6)&0x03);
}
void farben_init()
{
 int r,g,b;
 if(TIEFE==8)
 {for(r=0;r<=0xE0;r+=0x20)
  for(g=0;g<=0xE0;g+=0x20)
  for(b=0;b<=0xC0;b+=0x40)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
 else if(TIEFE==12)
 {for(r=0;r<=0xF0;r+=0x10)
  for(g=0;g<=0xF0;g+=0x10)
  for(b=0;b<=0xF0;b+=0x10)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
 else if(TIEFE==16)
 {for(r=0;r<0x08;r++)
  for(g=0;g<0x08;g++)
  for(b=0;b<0x08;b++)
    setcolor(farbnummer(r,g,b),r,g,b);
  for(r=0;r<=0xF8;r+=0x08)
  for(g=0;g<=0xF8;g+=0x08)
  for(b=0;b<=0xF8;b+=0x08)
    setcolor(farbnummer(r,g,b),r,g,b);
 }
}

void Bild::zeichnen(int ramenflag)
{
/* ramenx,y  Skizze aus bilbo.cc
     +------------Zielbild-------------+  ramenbreite,ramenhoehe
     |  offsetx,y                      |
     |   +------------Bild-------------+----+  imax,jmax  i,j
     |   |  sichtx,y                   |    |
     |   |    +--Sichtfenster--+       |    |  XMAX,YMAX  ix,iy
     |   |    |                |       |    |
     |   |    |                |       |    |
     |   |    |                |       |    |
     |   |    +----------------+       |    |
     +---+-----------------------------+    |
         |                                  |
         +----------------------------------+

  Neue Skizze fuer diasort.cc:
  +-----------Gesamtbild-------------+
  |                                  |
  |                                  |
  +----------Sichtfenster------------+ --sichty  ix,iy
  |                                  |
  |   +-Bild-+ i,j                   |
  |   |      |                       |
  |   +------+                       |
  |                                  |
  |                                  |
  |                                  |
  +----------------------------------+
  |                                  |
  |                                  |
  +----------------------------------+
*/
 int ix,iy,ix0,iy0; //Koordinaten im Sichtfenster
 int i,j,i1,i2,j1,j2; //Koordinaten im Bild
 int nr,n,nj;
 /** nur in bilbo benoetigt
 if(ramenbreite==0 || ramenhoehe==0)
   {ramenbreite=imax; ramenhoehe=jmax;
    if(sichtx==0 && sichty==0)
	{sichtx=(ramenbreite-XMAX)/2; if(sichtx<0) sichtx=0;
	 sichty=(ramenhoehe-YMAX)/2; if(sichty<0) sichty=0;
	}
   }
 **/
 i1=sichtx-offsetx; j1=sichty-offsety;
 i2=i1+XMAX; j2=j1+YMAX;
 koorduser2pix(0.0,YMAX,&ix0,&iy0);
 // if(zoomfaktor==100)
  {if(imax>=XMAX) //fuer grosse Bilder bilbo-Variante
    {for(j=j1,nj=j1*imax,iy=iy0;j<j2;j++,nj+=imax,iy++)
     for(i=i1,ix=ix0;i<i2;i++,ix++)
      {if(j>=0 && j<jmax && i>=0 && i<imax)
	  {n=i+nj; nr=farbnummer(p[n].r,p[n].g,p[n].b);}
       else {nr=hintergrundgrau;} //Ausserhalb Bilddaten: Grau
       ipunkt(ix,iy,nr);
      }
    }
   else //fuer kleine Bilder diasort-Variante
    {for(iy=iy0+offsety-sichty,nj=j=0;j<jmax;j++,nj+=imax,iy++)
     for(ix=ix0+offsetx,i=0;i<imax;i++,ix++)
	 {if(iy>=iy0 && iy<YMAX && ix>=ix0 && ix<XMAX)
	    {n=i+nj; ipunkt(ix,iy,farbnummer(p[n].r,p[n].g,p[n].b));}
	 }
    }
  }
 /* else
  {double fa=zoomfaktor*0.01;
   int ii,jj;
   for(j=0,iy=iy0;j<YMAX;j++,iy++)
   for(i=0,ix=ix0;i<XMAX;i++,ix++)
    {jj=j1+int(j/fa+0.5);
     ii=i1+int(i/fa+0.5);
     if(jj>=0 && jj<jmax && ii>=0 && ii<imax)
	  {n=jj*imax+ii; nr=farbnummer(p[n].r,p[n].g,p[n].b);}
     else {nr=hintergrundgrau;} //Ausserhalb Bilddaten: Grau
     ipunkt(ix,iy,nr);
    }
  }
 */
 if(loeschflag) //wenn als geloescht markiert, rot durchstreichen
  {int ix=ix0+offsetx, iy=iy0+offsety-sichty;
   color(farbnummer(255,0,0));
   moveto(ix,iy); lineto(ix+imax,iy+jmax);
   moveto(ix+imax,iy); lineto(ix,iy+jmax);
  }
 if(ramenflag) //wenn selektiert, Rahmen zeichnen
  {int ix=ix0+offsetx, iy=iy0+offsety-sichty, d=(imax>jmax)?imax:jmax;
   color(farbnummer(255,0,0));
   idrawbox(ix,iy,ix+d,iy+d);
  }
}
int Bild::save(const char *filename)
{
 int i,j,n,ti=255,c;
 for(j=n=0;j<jmax && ti==255;j++)
 for(i=0;i<imax;i++,n++)
    if(p[n].r>255 || p[n].g>255 || p[n].b>255) {ti=65535; break;}
 FILE *fp=fopen2(filename,"wb");
 if(fp==NULL) return -1;
 fprintf(fp,"P6\n%d %d %d\n",imax,jmax,ti);
 if(ti==255)
  {for(j=n=0;j<jmax;j++)
   for(i=0;i<imax;i++,n++)
    {putc(p[n].r,fp); putc(p[n].g,fp); putc(p[n].b,fp);
    }
  }
 else
  {for(j=n=0;j<jmax;j++)
   for(i=0;i<imax;i++,n++)
    {c=p[n].r; putc(c>>8,fp); putc(c&0xFF,fp);
     c=p[n].g; putc(c>>8,fp); putc(c&0xFF,fp);
     c=p[n].b; putc(c>>8,fp); putc(c&0xFF,fp);
    }
  }
 fclose(fp);
 return 0;
}
void Bild::getminmaxpixel(int* pmin,int* pmax)
{
 int i,n=imax*jmax;
 *pmin=0xFFFF; *pmax=0;
 for(i=0;i<n;i++)
   {if(*pmin>p[i].r) *pmin=p[i].r;
    if(*pmin>p[i].g) *pmin=p[i].g;
    if(*pmin>p[i].b) *pmin=p[i].b;
    if(*pmax<p[i].r) *pmax=p[i].r;
    if(*pmax<p[i].g) *pmax=p[i].g;
    if(*pmax<p[i].b) *pmax=p[i].b;
   }
}
void Bild::getminmaxpixel(int* rmin,int* rmax,int* gmin,int* gmax,int* bmin,int* bmax)
{
 int i,n=imax*jmax;
 *rmin= *gmin= *bmin=0xFFFF;  *rmax= *gmax= *bmax=0;
 for(i=0;i<n;i++)
   {if(*rmin>p[i].r) *rmin=p[i].r;
    if(*gmin>p[i].g) *gmin=p[i].g;
    if(*bmin>p[i].b) *bmin=p[i].b;
    if(*rmax<p[i].r) *rmax=p[i].r;
    if(*gmax<p[i].g) *gmax=p[i].g;
    if(*bmax<p[i].b) *bmax=p[i].b;
   }
}
void Bild::addpix(int r,int g,int b,bool ug,bool og)
{
 int i,n=imax*jmax,rn,gn,bn;
 for(i=0;i<n;i++)
   {rn=p[i].r+r;
    gn=p[i].g+g;
    bn=p[i].b+b;
    if(ug) {if(rn<0) rn=0; if(gn<0) gn=0; if(bn<0) bn=0;}
    if(og) {if(rn>255) rn=255; if(gn>255) gn=255; if(bn>255) bn=255;}
    p[i].r=rn;
    p[i].g=gn;
    p[i].b=bn;
   }
}
void Bild::mulpix(double r,double g,double b,bool ug,bool og)
{
 int i,n=imax*jmax,rn,gn,bn;
 for(i=0;i<n;i++)
   {rn=int(p[i].r*r+0.5);
    gn=int(p[i].g*g+0.5);
    bn=int(p[i].b*b+0.5);
    if(ug) {if(rn<0) rn=0; if(gn<0) gn=0; if(bn<0) bn=0;}
    if(og) {if(rn>255) rn=255; if(gn>255) gn=255; if(bn>255) bn=255;}
    p[i].r=rn;
    p[i].g=gn;
    p[i].b=bn;
   }
}
void Bild::negativ()
{
 int i,n=imax*jmax,pmin,pmax,p2;
 getminmaxpixel(&pmin,&pmax);
 p2=pmax+2*pmin;
 for(i=0;i<n;i++)
   {p[i] ^= p2; //p[i].r=pmax-(p[i].r-pmin)+pmin;
   }
}
void Bild::vergroessern(bool zwi,Bild& b1,double v)
{
 int i,j,k; //Laufvariablen neues Bild
 int i1,j1,i2,j2; //Indexe auf altes Bild
 double x,y;
 double w1,w2,wj1,wj2; //Gewichtungsfaktoren
 if(zwi) //Zwischenwerte berechnen
  for(j=0,k=0;j<jmax;j++)
   {y=(j+0.5)/v-0.5;
    j1=int(y); j2=j1+1; //j1 ist abgerundeter, j2 aufgerundeter Wert
    wj1=j2-y; wj2=y-j1; //Gewicht ist Abstand zwischen gerundet und exakt
    if(j2>=b1.jmax) j2=j1;
    for(i=0;i<imax;i++,k++)
     {x=(i+0.5)/v-0.5;
      i1=int(x); i2=i1+1; w1=i2-x; w2=x-i1;
      if(i2>=b1.imax) i2=i1;
      p[k] = (b1.getpixel(i1,j1)*w1+b1.getpixel(i2,j1)*w2)*wj1
	    +(b1.getpixel(i1,j2)*w1+b1.getpixel(i2,j2)*w2)*wj2;
     }
   }
 else //ohne Zwischenwerte
  for(j=0,k=0;j<jmax;j++)
   {j1=int((j+0.5)/v); //entspricht idfix((j+0.5)/v-0.5)
    for(i=0;i<imax;i++,k++)
     {i1=int((i+0.5)/v);
      p[k] = b1.getpixel(i1,j1);
     }
   }
}
void Bild::drehen(bool zwi,Bild& b1,double sina,double cosa,double v)
{
 int i,j,k; //Laufvariablen neues Bild
 int i1,j1,i2,j2; //Indexe auf altes Bild
 vektor q0,q;
 double w1,w2,wj1,wj2; //Gewichtungsfaktoren
 vektor mb(b1.imax*0.5,b1.jmax*0.5); //Mitte altes Bild
 vektor ma(imax*0.5,jmax*0.5); //Mitte neues Bild
 if(zwi) //Zwischenwerte berechnen
  for(j=0,k=0;j<jmax;j++)
   {q0.y=(j-ma.y)/v;
    for(i=0;i<imax;i++,k++)
     {q0.x=(i-ma.x)/v;
      q=drehenr(q0,sina,cosa)+mb;
      j1=int(q.y); j2=j1+1; //j1 ist abgerundeter, j2 aufgerundeter Wert
      wj1=j2-q.y; wj2=q.y-j1; //Gewicht ist Abstand zwischen gerundet und exakt
      if(j2>=b1.jmax) j2=j1;
      i1=int(q.x); i2=i1+1; w1=i2-q.x; w2=q.x-i1;
      if(i2>=b1.imax) i2=i1;
      if(j1<0 || j1>=b1.jmax || i1<0 || i1>=b1.imax)
	  p[k]=0; //Hintergrund schwarz
      else
	  p[k] = (b1.getpixel(i1,j1)*w1+b1.getpixel(i2,j1)*w2)*wj1
	        +(b1.getpixel(i1,j2)*w1+b1.getpixel(i2,j2)*w2)*wj2;
     }
   }
 else //ohne Zwischenwerte
  for(j=0,k=0;j<jmax;j++)
   {q0.y=(j-ma.y)/v;
    for(i=0;i<imax;i++,k++)
     {q0.x=(i-ma.x)/v;
      q=drehenr(q0,sina,cosa)+mb;
      i1=int(q.x+0.5);
      j1=int(q.y+0.5);
      if(j1<0 || j1>=b1.jmax || i1<0 || i1>=b1.imax)
	  p[k]=0; //Hintergrund schwarz
      else
	  p[k] = b1.getpixel(i1,j1);
     }
   }
}
void Bild::einfachesdrehen(int grad) //einfache 90-Grad-Drehungen
{
 int i,j,i2,j2,n;
 Bild tmp;
 tmp= *this;
 if(tmp.init(jmax,imax,offsetx,offsety)!=0)
   fprintf(STDERR,"Speicherproblem in Bild::einfachesdrehen()\n");
 tmp.rotnr=rotnr; //erst ruecksetzen wenn auch das gespeicherte Bild gedreht
 if(grad==90)
   {for(n=j=0;j<jmax;j++)
     for(i=0;i<imax;i++)
       {i2=jmax-j-1; j2=i;
        tmp.p[j2*jmax+i2]=p[n++];
       }
   }
 else if(grad==270)
   {for(n=j=0;j<jmax;j++)
     for(i=0;i<imax;i++)
       {i2=j; j2=imax-i-1;
        tmp.p[j2*jmax+i2]=p[n++];
       }
   }
 else
   {fprintf(STDERR,"Fehler: einfachesdrehen(%d) nur 90 oder 270 Grad erlaubt.\n",grad);
    return;
   }
 *this=tmp;
}

#include <errno.h>
void fehlermeldung(int err)
{
 if(err== -1) err=errno;
#ifdef EEXIST
 if(err==EEXIST) fprintf(STDERR,"EEXIST - Datei schon vorhanden.\n");
 else if(err==EROFS) fprintf(STDERR,"EROFS - nur lesbar\n");
 else if(err==ENOMEM) fprintf(STDERR,"ENOMEM - nicht genug Kernelspeicher\n");
 else if(err==EACCES) fprintf(STDERR,"EACCES - kein Schreibrecht\n");
 else if(err==ENOENT) fprintf(STDERR,"ENOENT - No such file or directory\n");
 else
#endif
    fprintf(STDERR,"Fehlercode %d: siehe 'more /usr/include/asm*/errno*.h'\n",err);
 automodus=0;
}
void fehlerscanf(int soll,int n)
{
 fprintf(STDERR,"Fehler in scanf() oder fscanf() n=%d (statt %d)\n",n,soll);
}

void mylink(const char *von,const char* nach)
{
 int err=link(von,nach);//Hardlink
 if(err)
  {fprintf(STDERR,"Fehler bei link(%s,%s);\n",von,nach); fehlermeldung(err);}
}

void Bild::umbenennen()
{
 char neuername[N80],*z=bildname;
 int nr,err;
 if(rotnr!=0)
   {while(rotnr<0) rotnr+=4;
    rotnr=rotnr%4;
   }
 if(isdigit(z[0]) && isdigit(z[1])
    && isdigit(z[2]) && isdigit(z[3]) && z[4]=='-')
   {sscanf(bildname,"%d",&nr);
    if(nr==sortiernummer && rotnr==0 && loeschflag==0) return;//kein Umbenennen noetig
    z= &bildname[5];
   }
 else if(loeschflag)//kein Umbenennen noetig
   {if(wirklichloeschen && strncmp(bildname,"zzzz-",5)==0)
     {err=unlink(vollpfad(bildname));
      if(err) fprintf(STDERR,"unlink-Error %d: '%s'\n",err,bildname);
     }
    return;
   }
 else if(strncmp(bildname,"zzzz-",5)==0) z= &bildname[5];
 if(rotnr==0)
   {if(loeschflag)
      {if(strncmp(z,"zzzz-",5)==0) strcpy(neuername,z);
       else sprintf(neuername,"zzzz-%s",z);//geloeschte mit zzzz- markieren
      }
    else sprintf(neuername,"%04d-%s",sortiernummer,z);
    err=rename(vollpfad(bildname),vollpfad(neuername));
    if(err) fprintf(STDERR,"Error %d: rename(%s,%s)\n",err,bildname,neuername);
    if(loeschflag && wirklichloeschen) unlink(vollpfad(neuername));
   }
 else
   {int n;
    if(strncmp(z,"rot",3)==0 && isdigit(z[3]) && z[4]=='-')
      {n=(rotnr+z[3]-'0')%4; z= &z[5];} //neue rotnr berechnen, altes weglassen
    else n=rotnr;
    if(n==0)
      {if(loeschflag) sprintf(neuername,"%s",z);
       else sprintf(neuername,"%04d-%s",sortiernummer,z);
      }
    else
      {if(loeschflag) sprintf(neuername,"rot%d-%s",n,z);
       else sprintf(neuername,"%04d-rot%d-%s",sortiernummer,n,z);
      }
    system3("convert -rotate %d \"%s\" \"%s\"",rotnr*90,bildname,neuername); //TODO: nur Exif-Eintrag aendern
    if(vorhanden2(neuername)) {err=0; unlink(vollpfad(bildname));}
    else {fprintf(STDERR,"Bild '%s' rotieren fehlgeschlagen.\n",bildname); err= -1;}
    rotnr=0;
   }
 if(err==0) strcpy(bildname,neuername);
 else if(err>0) fehlermeldung(err);
}

static Bild bilder[MAXB+1],vollbild;
//static char scratch[400];  //schon weiter oben

int bild_laden(const char *name,int bildnr)
{
 char cstr[80];
 const char *tmpvor=tmpppm;
 FILE *fp;
 int c,i,j,br,ho,ti,r,g,b;
 static int xoffs=DB,yoffs=DB;
 if(bildnr==1) {xoffs=yoffs=DB;}
 if(bildnr>nbilder)
  {c=(ansicht_modus==GROSS)?'g':'k';
   if(!vorhanden2(TMPVOR))
        {system2("mkdir \"%s\"",TMPVOR);
	 if(!vorhanden2(TMPVOR))
	   {system2("mkdir \"%s\"",TMPVOR2); TMPVOR=TMPVOR2;
	    if(!vorhanden2(TMPVOR))
	      {fprintf(STDERR,"kann Ordner '%s' fuer Vorschaubilder nicht erstellen\n",TMPVOR);
	       exit(0);
	      }
	   }
	}
   sprintf(scratch,"%s/%c%s",TMPVOR,c,ohnevornummer(name));
   ohneletztenpunkt(scratch);
   anhaengen(scratch,".ppm");
   tmpvor=scratch;
   if(!vorhanden2(tmpvor))
     {if(argflag['R'])
           sprintf(cstr,"convert -auto-orient -size %dx%d \"%%s\" -resize %dx%d \"%%s\"",BB,BB,BB,BB);
      else sprintf(cstr,"convert -size %dx%d \"%%s\" -resize %dx%d \"%%s\"",BB,BB,BB,BB);
      system2(cstr,name,tmpvor);
     }
   fp=fopen2(tmpvor,"r");
   if(fp==NULL)
     {fprintf(STDERR,"Fehler in bild_laden(%s,%d): kann '%s' nicht oeffnen - versuche nochmals\n",name,bildnr,vollpfad(tmpvor));
      Delay(10); fp=fopen2(tmpvor,"r");
      if(fp==NULL) {fprintf(STDERR,"auch beim 2. Versuch nicht\n"); exit(0);}
      else fprintf(STDERR,"beim 2. Versuch ok.\n");
     }
   if(getc(fp)!='P' || getc(fp)!='6')
     {fprintf(STDERR,"%s fileformat: '%s' is not PPM\n",name,tmpvor);
      fclose(fp); return -1;
     }
   while(istspace(c=getc(fp))) ;
   while(c=='#') {while(getc(fp)!='\n') ;  c=getc(fp);}
   ungetc(c,fp);
   c=fscanf(fp,"%d %d %d",&br,&ho,&ti); if(c!=3) fehlerscanf(3,c);
   if((c=getc(fp))!='\n' && c!=' ')
     {fprintf(STDERR,"%s Error: missing whitespace in PPM\n",name); return -1;}
   if(br>MAXBR || ho>MAXHO)
     {fprintf(STDERR,"Bild zu Gross: %dx%d (auf %dx%d beschraenkt)\n",br,ho,MAXBR,MAXHO); fclose(fp); return 0;}
   //if(test) printf("Loading '%s' br=%d ho=%d ti=%d\n",tmpvor,br,ho,ti);//test
   if(ti!=255 && ti!=65535)
     fprintf(STDERR,"Warnung: Ungewoehnliche Farbtiefe, Bild wird moeglicherweise nicht korrekt dargestellt\n");//test
   if(bilder[nbilder].init(br,ho,xoffs,yoffs)!=0)
     {fclose(fp); fprintf(STDERR,"bild_laden(%s) Speicherprobleme\n",name); return 0;}
   ohnepfad(bilder[nbilder].bildname,name,N80);
   if(ti<=255)
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; g=getc(fp)&0xFF; b=getc(fp)&0xFF;
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
     }
   else //if(ti==65535)
     {for(j=0;j<ho;j++)
      /* fuer volle Farbtiefe:
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; r=(r<<8)+(getc(fp)&0xFF);
        g=getc(fp)&0xFF; g=(g<<8)+(getc(fp)&0xFF);
	b=getc(fp)&0xFF; b=(b<<8)+(getc(fp)&0xFF);
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
      /* Farbtiefe auf 1 Byte pro Farbe beschraenkt: */
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; getc(fp);
        g=getc(fp)&0xFF; getc(fp);
	b=getc(fp)&0xFF; getc(fp);
	bilder[nbilder].setrgb(i,j,r,g,b);
       }
      /* */
     }
   fclose(fp);
   bilder[nbilder].sortiernummer=nbilder+1;
   jreihenfolge[nbilder]=nbilder;
   if(!isdigit(bilder[nbilder].bildname[0])) nochnichtgespeichert=1;
   bilder[nbilder].zeichnen(istselekt(nbilder));
   if(nbilder==MAXB)
     {fprintf(STDERR,"Fehler: zu viele Bilder MAXB=%d\n",MAXB);
      fprintf(STDERR,"Abhilfe: MAXB in diasort.cc erhoehen und neu compilieren.\n");
     }
   else nbilder++;
  }
 else if(yoffs>=sichty) bilder[bildnr-1].zeichnen(istselekt(bildnr-1));
 xoffs+=BB+DB;
 if(xoffs>gbreite-BB-DB)
   {yoffs+=BB+DB; xoffs=DB;
    if(yoffs-sichty>ghoehe-BB) return 0;
   }
 return 1;
}

int aktbildnr_ausrechnen(const char *name)
{
 int nr,n,resultat= -1;
 for(nr=1;nr<=nbilder;nr++)
   {n=jreihenfolge[nr-1];
    if(strcmp(name,bilder[n].bildname)==0)
      {resultat=nr; break;}
   }
 if(resultat<1 && test>=2)
   {fprintf(STDERR,"aktbildnr_ausrechnen(%s) --> %d\n",name,resultat);//test
   }
 return resultat;
}

static int vollbildaktnr=0;//provi.

int vollbild_laden(char *name,int bildnr)
{
 char cstr[80];
 FILE *fp;
 int c,i,j,br,ho,ti,r,g,b;
 if(bildnr!=vollbildnr)
    return 1;//immer 1 zurueckgeben weil Bilder gezaehlt werden sollen
 vollbildaktnr=aktbildnr_ausrechnen(name);
 if(argflag['R'])
  sprintf(cstr,"convert -auto-orient -size %dx%d \"%%s\" -resize %dx%d \"%%s\"",
	  gbreite,ghoehe,gbreite,ghoehe); //TODO: nachlesen warum -size und -resize
 else
  sprintf(cstr,"convert -size %dx%d \"%%s\" -resize %dx%d \"%%s\"",
	  gbreite,ghoehe,gbreite,ghoehe);
 system2(cstr,name,tmpppm);
 fp=fopen(tmpppm,"r");
 if(fp==NULL)
   {fprintf(STDERR,"Error in vollbild_laden: %s cant open '%s' - Trying again: ",
	   name,tmpppm);
    unlink(tmpppm); Delay(10); 
    system2(cstr,name,tmpppm);
    fp=fopen(tmpppm,"r");
    if(fp==NULL) {fprintf(STDERR,"no success.\n"); return -1;}
    else fprintf(STDERR,"ok.\n");
   }
 if(getc(fp)!='P' || getc(fp)!='6')
  {fprintf(STDERR,"%s fileformat: '%s' is not PPM\n",name,tmpppm);fclose(fp);return -1;}
 while(istspace(c=getc(fp))) ;
 while(c=='#') {while(getc(fp)!='\n') ;  c=getc(fp);}
 ungetc(c,fp);
 c=fscanf(fp,"%d %d %d",&br,&ho,&ti); if(c!=3) fehlerscanf(3,c);
 if((c=getc(fp))!='\n' && c!=' ')
   {fprintf(STDERR,"%s Error: missing whitespace in PPM\n",name); return -1;}
 if(br>MAXBR || ho>MAXHO)
   {fprintf(STDERR,"Bild zu Gross: %dx%d (auf %dx%d beschraenkt)\n",br,ho,MAXBR,MAXHO); fclose(fp); return 0;}
 //if(test) printf("Loading '%s' br=%d ho=%d ti=%d\n",tmpppm,br,ho,ti);//test
 if(ti!=255 && ti!=65535)
     fprintf(STDERR,"Warnung: Ungewoehnliche Farbtiefe, Bild wird moeglicherweise nicht korrekt dargestellt\n");//test
 int dx=(gbreite-br)/2, dy=(ghoehe-ho)/2;
 if(vollbild.init(br,ho,dx,dy)!=0)
   {fclose(fp); fprintf(STDERR,"vollbild_laden(%s) Speicherprobleme\n",name); return 0;}
 ohnepfad(vollbild.bildname,name,N80);
 if(ti<=255)
     {for(j=0;j<ho;j++)
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; g=getc(fp)&0xFF; b=getc(fp)&0xFF;
	vollbild.setrgb(i,j,r,g,b);
       }
     }
    else
     {for(j=0;j<ho;j++)
      /* Farbtiefe auf 1 Byte beschraenkt: */
      for(i=0;i<br;i++)
       {r=getc(fp)&0xFF; getc(fp);
        g=getc(fp)&0xFF; getc(fp);
	b=getc(fp)&0xFF; getc(fp);
	vollbild.setrgb(i,j,r,g,b);
       }
     }
 fclose(fp);
 unlink(tmpppm);
 vollbild.zeichnen();
 if(untertitelflag!=0) untertitel(name);
 changebuffer(0,1);
 return 1;
}

/********************** Untertitel, Textanzeigen ***********************/
int getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

class Textliste
{
 Textliste *next;
 char bildname[MAXD]; //Name ohne Pfad und ohne fuehrende Nummer
 char textzeile[200]; //Text fuer maximal eine Zeile
 int textfarbe,bfarbe;
 char *kern(char *s);
 int firstflag;
public:
 int gespeichert;
 Textliste()
	{next=NULL; *bildname = *textzeile = 0;
	  textfarbe=0xFFFFFF; bfarbe= -1; gespeichert=1; firstflag=1;
	}
 ~Textliste() {if(next!=NULL) delete next;}
 bool put(char *name,char *text,int farbe=0xFFFFFF,int bpen= -1);
 char *get(char *name,int *farbe,int *bpen);
 void set(char *name,char *text,int farbe,int bpen);
 void laden();
 void speichern();
 void loeschen()
   {if(next!=NULL) {delete next; next=NULL;}
    *bildname = *textzeile = 0;
    textfarbe=0xFFFFFF; bfarbe= -1; gespeichert=1; firstflag=1;
   }
};
static Textliste textliste;

#define M200 (MAXD+16)
void Textliste::laden()
{
 FILE *fp=fopen2(listetxt,"r");
 if(fp==NULL) return;
 Textliste *p,*p0;
 char zeile[M200],*s;
 for(p0=p=this;getline(fp,zeile,M200);)
   if(strncmp(zeile,"<text ",6)==0)
    {if(strncmp(&zeile[6],"name=\"",6)==0)
      {for(s= &zeile[12];*s!=0 && *s!='"';s++) ;
       *s=0;
       strncpy(p->bildname,&zeile[12],80);
       getline(fp,p->textzeile,200);
       for(;getline(fp,zeile,M200) && *zeile!='<';)
	{if(strncmp(zeile,"farbe=",6)==0) sscanf(&zeile[6],"%d",&p->textfarbe);
	 else if(strncmp(zeile,"bpen=",5)==0) sscanf(&zeile[5],"%d",&p->bfarbe);
	}
       if(strncmp(zeile,"</text>",7)!=0)
	 fprintf(STDERR,"Syntaxfehler in textliste.txt: fehlendes </text>\n");
       p0=p;
       p=p0->next=new Textliste;
       if(p==NULL) fprintf(STDERR,"Fehler: zu wenig Speicher?\n");//test
      }
     else
      fprintf(STDERR,"Syntaxfehler in textliste.txt: <text name=\"..\"> erwartet.\n");
    }
 fclose(fp);
 if(p!=this) {delete p; p0->next=NULL;}
}

void Textliste::speichern()
{
 const char *vlistetxt=vollpfad(listetxt);
 if(firstflag)
   {if(vorhanden(vlistetxt)) rename(vlistetxt,vollpfad(listetxtbak));
    firstflag=0;
   }
 FILE *fp=fopen(vlistetxt,"w");
 if(fp==NULL)
   {fprintf(STDERR,"Fehler: kann %s nicht erstellen.\n",vlistetxt); return;}
 Textliste *p;
 for(p=this;p!=NULL;p=p->next)
  if(p->bildname[0]!=0 && p->textzeile[0]!=0)
   {fprintf(fp,"<text name=\"%s\">\n",p->bildname);
    fprintf(fp,"%s\n",p->textzeile);
    fprintf(fp,"farbe=%d\nbpen=%d\n",p->textfarbe,p->bfarbe);
    fprintf(fp,"</text>\n");
   }
 fclose(fp);
 gespeichert=1;
}

char* Textliste::kern(char *s)
{
 char *z=s;
 int c,numflag=1;
 while(c= *s++)
   {if(c=='/') {z=s; numflag=1;}
    else if(numflag && c=='-') {z=s; numflag=0;}
    else if(!isdigit(c)) numflag=0;
   }
 return z;
}
char* Textliste::get(char *name,int *farbe,int *bpen)
{
 char *s=kern(name);
 Textliste *p;
 if(strlen(s)>=MAXD) {fprintf(STDERR,"Fehler: Dateiname zu lang.\n"); return NULL;}
 for(p=this;p!=NULL;p=p->next)
   if(strcmp(s,p->bildname)==0)
       {*farbe=p->textfarbe; *bpen=p->bfarbe;
	if(test>0 && vorhandeninauswahl(s))
	  {static char text[200];
	   sprintf(text,"A - %s",(p->textzeile==NULL) ? name : p->textzeile);
	   return text;
	  }
	return p->textzeile;
       }
 return NULL;
}
bool Textliste::put(char *name,char *text,int farbe,int bpen)
{
 char *s=kern(name);
 Textliste *p;
 if(strlen(s)>=MAXD) {fprintf(STDERR,"Fehler: Dateiname zu lang.\n"); return 0;}
 if(*bildname==0)
   {strcpy(bildname,s); strncpy(textzeile,text,200);}
 else
   {for(p=this;p->next!=NULL;p=p->next) ;
    p->next=new Textliste;
    p=p->next;
    strcpy(p->bildname,s); strncpy(p->textzeile,text,200);
    p->textfarbe=farbe; p->bfarbe=bpen;
   }
 gespeichert=0;
 return 1;
}
void Textliste::set(char *name,char *text,int farbe,int bpen)
{
 char *s=kern(name);
 Textliste *p;
 if(strlen(s)>=MAXD) {fprintf(STDERR,"Fehler: Dateiname zu lang.\n"); return;}
 for(p=this;p!=NULL;p=p->next)
   if(strcmp(s,p->bildname)==0)
     {p->textfarbe=farbe; p->bfarbe=bpen;
      strcpy(p->textzeile,text);
      gespeichert=0;
      return;
     }
 put(name,text,farbe,bpen);
}

void mycolor2(int farbe) {mycolor(farbe>>16,(farbe&0xFF00)>>8,farbe&0xFF);}
void mybpencolor(int farbe)
{
 if(farbe<0) bpencolor(farbe);
 else bpencolor(farbnummer(farbe>>16,(farbe&0xFF00)>>8,farbe&0xFF));
}

int umlaut(unsigned int c2) //Umlaute als isolatin1-codes
{
 c2&=0xFF;
 if(c2=='A') return 0xC4;
 if(c2=='O') return 0xD6;
 if(c2=='U') return 0xDC;
 if(c2=='a') return 0xE4;
 if(c2=='o') return 0xF6;
 if(c2=='u') return 0xFC;
 if(c2==0x84) return 0xC4; //UTF-8 auch in isolatin1 umrechnen
 if(c2==0x96) return 0xD6;
 if(c2==0x9C) return 0xDC;
 if(c2==0xA4) return 0xE4;
 if(c2==0xB6) return 0xF6;
 if(c2==0xBC) return 0xFC;
 return c2;
}
/* int utf8umlaut(char c2) //Umlaute als UTF-8-codes
{
 //erstes Byte immer 0xC3
 if(c2=='A') return 0x84;
 if(c2=='O') return 0x96;
 if(c2=='U') return 0x9C;
 if(c2=='a') return 0xA4;
 if(c2=='o') return 0xB6;
 if(c2=='u') return 0xBC;
 return c2;
}*/
void strcpy_umlaut(char *ziel,const char *txt,int max)
{
 char *s;
 int i,c,c2;
 for(s=ziel,i=1;(c= *txt++) && i<max;i++)
  {c &= 0xFF;
   if(c=='\\' && *txt=='\"' && (c2=txt[1])!=0)
    {c=umlaut(c2); txt++; txt++;}
   else if(c==0xC3)
    {c=umlaut(*txt++);}
   *s++ = c;
  }
 *s=0;
}
void schrift_mitumlauten(double x,double y,const char *txt)
{
 char text[200],*s;
 int i,c,c2;
 for(s=text,i=1;(c= *txt++) && i<200;i++)
  {c &= 0xFF;
   if(c=='\\' && *txt=='\"' && (c2=txt[1])!=0)
    {c=umlaut(c2); txt++; txt++;}
   else if(c==0xC3)
    {c=umlaut(*txt++);}
   *s++ = c;
  }
 *s=0;
 schrift(x,y,text);
}

char *untertitel(char *name)
{
 int farbe=0xFFFFFF,bpen= -1;
 char *text=textliste.get(name,&farbe,&bpen);
 if(text==NULL)
   {FILE *fp=fopen2(name,"r");
    if(fp) {text=komextrahieren(fp); fclose(fp);}
    //if(text==NULL && test>0)
    if(text==NULL && (test>0 || untertitelflag>=2))
      {if(vorhandeninauswahl(ohnevornummer(name)))
	  {static char text2[200];
	   sprintf(text=text2,"A - %s",name);
	  }
       else text=name;
      }
    if(text==NULL) return NULL;
   }
 mycolor2(farbe);
 mybpencolor(bpen);
 double h=ghoehe/25,b=h/2,ho,x,y=ghoehe/100;
 ho=textsize(b,h);
 x=(gbreite-strlen(text)*b)/2;
 //printf("schrift(x=%lf,y=%lf,'%s')\n",x,y,text);//test
 schrift_mitumlauten(x,y,text);
 return text;
}
/************************* Menue Behandlung ****************************/
static int exitflag=0;
void m_exit() {exitflag=1;}
void m_about()
{
 sprintf(scratch,"Diasort.cc   %s\nCopyright: %s\nAuthor: %s\n",
	 VERSION,COPYRIGHT,AUTHOR);
 janeinrequester(scratch);
}
void m_pwd() //Menu "Ordner..."
{
 m_pwd2(NULL);
}
void m_pwd2(char *ordner) //Menu "Ordner..."
{
 char pfad[N80+2];
 int ok,n;
 if(ordner==NULL)
  {event_speichern();
   strncpy(pfad,pwd.getpfad(),N80); pfad[N80]=0;
   ok=nachfilenamefragen("Lade aktuellen Ordner",pfad,N80);
   if(test) fprintf(STDERR,"Lade aktuellen Ordner: ok=%d pfad='%s'\n",ok,pfad);
  }
 else
  {strncpy(pfad,ordner,N80); pfad[N80]=0;
   ok=1;
  }
 if(ok)
   {if(test) fprintf(STDERR,"m_pwd() pfad='%s'\n",pfad);//test
    if((n=index(pfad,"$DISKS/"))>=0 || (n=index(pfad,"(disk)")+100)>=100)
     {if(n>=100) n=0; else n+=7;
      if(strncmp(&pfad[n],"ROOT",4)==0) strcpy(pfad,"/");
      else if(strncmp(&pfad[n],"HOME",4)==0) strcpy(pfad,getenv("HOME"));
      else if(strncmp(&pfad[n],"CDROM",4)==0) strcpy(pfad,"/cdrom/");
      if(test) fprintf(STDERR," $DISKS angepasst: pfad='%s'\n",pfad);//test
     }
    //if(strcmp(&pfad[n=strlen(pfad)-2],"..")==0) pfad[n]=0;//.. am Ende weglassen
    if(index(pfad,'/')>=0) //Datei weglassen, nur Pfad verwenden
      for(int n=strlen(pfad);n>0 && pfad[n-1]!='/';pfad[--n]=0) ;
    if(tmpdateiliste!=NULL)  {delete[] tmpdateiliste;  tmpdateiliste=NULL;}
    if(tmpdateiliste2!=NULL) {delete[] tmpdateiliste2; tmpdateiliste2=NULL;}
    for(int i=0;i<nbilder;i++) bilder[i].clear();
    vollbild.clear();
    nbilder=0; sichty=maxsichty=0;
    textliste.loeschen();
    if(tmpvorbehalten==0) system2("rm -r \"%s\"",TMPVOR);
    nochnichtgespeichert=0;
    if(test) fprintf(STDERR,"pwd.cd(%s)\n",pfad);//test
    pwd.cd(pfad);
    // ermitteln ob der Ordner als Nurlese-Ordner behandelt werden soll:
    int k=0;
    Dateiliste *p;
    tmpdateiliste_aktualisieren();
    if(strncmp(pfad,"/cdrom",6)!=0)
      for(p=tmpdateiliste;p!=NULL;p=p->next)
	if(isdigit(p->name[0]) && isdigit(p->name[1]) &&
	   isdigit(p->name[2]) && isdigit(p->name[3]))	k++;
    if(argflag['Q']<2) argflag['Q'] = (k<2) ? 1 : 0;
    if(test) printf("argflag['Q']=%d\n",argflag['Q']);//test
    set_tektitel3(pfad);
    if(argflag['Q']) TMPVOR=TMPVOR2; else TMPVOR=TMPVOR1;
    const char *tmpvor=vollpfad(TMPVOR);
    if(vorhanden(tmpvor))  tmpvorbehalten=1;
    else  {system2("mkdir \"%s\"",tmpvor); tmpvorbehalten=(argflag['B'])?1:0;}
    bilder_laden();
    textliste.laden();
   }
}
void m_neuord() //Menu "Neuer Ordner...", neu ab Version 1.09
{
 char pfad[N80+2],antw[80]="Pfad ok? falls nicht CANCEL druecken!";
 char neuordner[N80]="diashow",pfadordner[N80+80];
 int ok,n,i;
 event_speichern();
 strncpy(pfad,pwd.getpfad(),N80); pfad[N80]=0;
 if(lastchar(pfad)!='/') anhaengen(pfad,"/");
 for(i=1;vorhanden2(neuordner) && i<1000;i++)
   sprintf(neuordner,"diashow%d",i);
 if(i==1000) fprintf(STDERR,"wirklich soo viele Ordner?\n");
 sortiermethode=2;
 ok=requester_input(4,
	pfad,"%s","%s\n",antw,
	"Neuer Ordner fuer neue Sortierung","%s","%s\n",neuordner,
	"Sortiermethode: 1=nach Namen, 2=Aufnahmedatum, 3=Nummer in Dateiname",
		    "%d","%d\n",&sortiermethode,
	"Kopiermethode: 1=Softlinks, 2=Hardlinks, 3=Wirklich kopieren",
		    "%d","%d\n",&kopiermethode);
 if(ok)
  {Dateiliste *p;
   int nummer;
   sprintf(pfadordner,"%s%s",pfad,neuordner);
   if(ordner_erstellen(pfadordner)==false) return;
   if(tmpdateiliste!=NULL) delete[] tmpdateiliste;
   tmpdateiliste=mylsmit(".");
   for(nummer=1,p=tmpdateiliste;p!=NULL;p=p->next)
    {if(p->typ!=NORM)
       fprintf(STDERR,"m_neuord() Datei '%s' vom falschen Typ: typ=%d\n",
	       p->name,p->typ);
     else
       nummer=file_linken_oder_kopieren(p->name,nummer,neuordner);
    }
   sortiermethode=1;//fuer Diashow immer nach Dateinamen sortieren
   anhaengen(pfadordner,"/");
   m_pwd2(pfadordner);
  }
 else sortiermethode=1;//fuer Diashow immer nach Dateinamen sortieren
}
void m_save()
{
 int i;
 if(argflag['Q'])
  {int ok=janeinrequester("Eigentlich sind wir im Nurlese-Modus.\n\
Sind Sie sicher dass trotzdem gespeichert werden soll?","nein","ja");
   if(ok) return;
  }
 if(!textliste.gespeichert) textliste.speichern();
 if(test) printf("%d Bilder auf aktuelle Nummern umbenennen\n",nbilder);
 for(i=0;i<nbilder;i++)
    bilder[i].umbenennen();
 if(test) printf("fertig umbenannt.\n");
 nochnichtgespeichert=0;
}
void m_refresh()
{
 if(ansicht_modus==VOLLBILD) bilder_laden();
 else neuzeichnen();
}

void mycolor(int r,int g,int b)
{
 if(TIEFE==24) rgbcolor(r,g,b); else color(farbnummer(r,g,b));
}

void neuzeichnen(int a0)
{
 int i;
 inital_new();
 color(hintergrundgrau); ifillbox(0,0,XMAX,YMAX);//grauer Hintergrund
 for(i=a0;i<nbilder;i++)  bilder[jr(i)].zeichnen(istselekt(jr(i)));
 //if(untertitelflag && selektbildnr>0 && test>0)
 if(untertitelflag && selektbildnr>0 && (test>0 || untertitelflag>=2))
     {int nr=jreihenfolge[selektbildnr-1];
      untertitel(bilder[nr].bildname);
     }
 term_refresh();
}
void neuzeichnen_nur1bild(int nr)
{
 int ix0,iy0,x1,y1,x2,y2;
 inital_new();
 koorduser2pix(0.0,YMAX,&ix0,&iy0);
 x1=ix0+bilder[nr].offsetx;
 y1=iy0+bilder[nr].offsety-sichty;
 x2=x1+BB-1; y2=y1+BB-1;
 color(hintergrundgrau); ifillbox(x1,y1,x2,y2);//grauer Hintergrund
 bilder[nr].zeichnen(istselekt(nr));
 term_refresh();
}

//Menu Ansicht
void event_speichern()
{
 if(argflag['Q']) return;
 if(!textliste.gespeichert) textliste.speichern();
 if(nochnichtgespeichert)
   {int ok;
    if(wirklichloeschen) ok=1;
    else ok=janeinrequester("Aktuelle Reihenfolge speichern?","Ja","Nein");
    if(ok) m_save();
   }
}
void m_normal()
{
 if(ansicht_modus!=NORMAL)
   {ansicht_modus=NORMAL;
    event_speichern();
    BB=95; DB=5; sichtstep=5*(BB+DB);
    if(tmpdateiliste!=NULL) {delete[] tmpdateiliste; tmpdateiliste=NULL;}
    nbilder=0; sichty=maxsichty=0; bilder_laden();
   }
 else
   neuzeichnen();
}
void m_gross()
{
 if(ansicht_modus!=GROSS)
   {ansicht_modus=GROSS;
    event_speichern();
    BB=195; DB=5; sichtstep=2*(BB+DB);
    if(tmpdateiliste!=NULL) {delete[] tmpdateiliste; tmpdateiliste=NULL;}
    nbilder=0; sichty=maxsichty=0; bilder_laden();
   }
 else
   neuzeichnen();
}

bool aufraeumen(int sofortflag)
{
 int ok;
 char a1[80]="ja";
 if(sofortflag) ok=1;
 else ok=requester_input(1,"Geloeschte Bilder wirklich loeschen?","%s","%s",a1);
 if(!ok) return false;
 wirklichloeschen = istja(a1);
 if(anzahl<nbilder) anzahl=nbilder;
 event_speichern();
 if(tmpdateiliste!=NULL) {delete[] tmpdateiliste; tmpdateiliste=NULL;}
 nbilder=0; sichty=maxsichty=0; bilder_laden();
 if(wirklichloeschen) {wirklichloeschen=0; anzahl=nbilder;}
 return true;
}
void m_aufraeum()
{
 if(ansicht_modus!=VOLLBILD)
   {if(argflag['Q']) {janeinrequester("wir sind im NURLESE-Modus!\nnichts veraendert."); return;}
    aufraeumen(0);
   }
}

static int vollmodus=1; //in m_test veraenderbar

void vollbild_ein()
{
 int tiefe,visklasse;
 double xmin=0,ymin=0,xmax,ymax;
 if(startflag==0) term_exit();
 fullscreen_modus(vollmodus);
 getmaxsize(&gbreite,&ghoehe,&tiefe,&visklasse);
 setsize(XMAX=gbreite,YMAX=ghoehe,gtiefe);
 xmax=gbreite; ymax=ghoehe;
 inital(xmin,ymin,xmax,ymax);
 hintergrundgrau=farbnummer(0,0,0);//schwarzer statt grauer Hintergrund
}
int anzahlgeloeschte(int nr)
{
 int n,z=0;
 for(n=0;n<nr;n++)
   if(bilder[jr(n)].loeschflag) z++;
 return z;
}
void m_vollb()
{
 if(ansicht_modus!=VOLLBILD)
   {alter_modus=ansicht_modus;
    ansicht_modus=VOLLBILD;
    event_speichern(); vollbild_ein();
    vollbildnr=(selektbildnr>0)?selektbildnr:1;
    vollbildnr -= anzahlgeloeschte(selektbildnr);
    altes_sichty=sichty; sichty=0;
    if(tmpdateiliste!=NULL) {delete[] tmpdateiliste; tmpdateiliste=NULL;}
    bilder_laden();
   }
}
void vollbild_aus()
{
 term_exit();
 fullscreen_modus(0);
 grafikfenster_oeffnen();
 if(vollbildnr>1) selektbildnr=vollbildnr;
 ansicht_modus=alter_modus;
 sichty=altes_sichty;
 if(nbilder==0) bilder_laden();
 waitTOF();
 m_refresh();
}
/* void zoom(double z)
{
 zoomfaktor=int(zoomfaktor*z); if(zoomfaktor<=0) zoomfaktor=1;
 neuzeichnen();
} */
void bilder_reihenfolge(int nr[])
{
 int i,j;
 for(i=0;i<nbilder;i++)
     {j=nr[i];
      if(j>=0 && j<nbilder) {jreihenfolge[i]=j;}
     }
 neuzeichnen();
}
void m_reihe()
{
 int ok,i,j,nr[MAXB];
 char str[MAXB*4],*s;
 printf("Liste der geladenen Bilder:\n");
 for(i=0,s=str;i<nbilder;i++)
   {j=jr(i);
    printf(" %d\t%s\n",j,bilder[j].bildname);
    sprintf(s,"%d ",j); if(j>99) s+=4; else if(j>9) s+=3; else s+=2;
   }
 *s=0;
 ok=requester_input(1,"Reihenfolge der Bilder (siehe auch Shell-Fenster)",
		    "%s","%s",str);
 if(ok)
  {for(i=0;i<nbilder;i++)  nr[i] = -1;
   for(i=0,s=str;i<nbilder;i++)
     {sscanf(s,"%d",&nr[i]);
      if(nr[i]>99) s+=4; else if(nr[i]>9) s+=3; else s+=2;
     }
   bilder_reihenfolge(nr);
  }
}

void m_hilfe()
{
 char text[]=
"  Hilfe zu Diasort\n\
  ================\n\
Einschraenkungen:\n\
----------------\n\
- Es koennen maximal 4000 Bilder geladen werden\n\
  (fuer mehr: Quellprogi editieren und MAXB erhoehen)\n\
\n\
Tastenbelegung:\n\
---------------\n\
Taste  Funktion\n\
Home   Auf erste Seite zurueck (oder Taste <)\n\
End    Auf bisher letzte Seite gehen (oder Taste >)\n\
PgUp   Vorherige Seite (oder Pfeiltaste rauf)\n\
PgDn   Naechste Seite (oder Pfeiltaste runter)\n\
y      neu zeichnen (wie Menu refresh)\n\
Del    Bild als geloescht markieren\n\
p      Vollbildmodus (Praesentation) ein/aus\n\
i      Wie Menu Info\n\
k      Wie Menu Kommentar...\n\
d      Wie Menu Display (Vergroesserte Anzeige)\n\
b      Wie Menu Bilbo...\n\
a      Wie Menu Auswahl (aktuelles Bild in Auswahlordner kopieren)\n\
u      Untertitel ein/aus\n\
t      Automodus - Bilder im Vollbildmodus automatisch durchlaufen lassen\n\
r      Rotation: Exif beruecksichtigen ein/aus\n\
q      Programm Verlassen (falls es nichts zu speichern gibt)\n\
\n\
Ordner-Auswahl:\n\
--------------\n\
Wenn ein anderer Ordner gewaehlt wird, wird der Pfad in der Titelleiste\n\
angezeigt. Dahinter \"NURLESE-Modus\" bedeutet dass Diasort da\n\
nicht hineinschreiben will. Dann ist \"Neuer Ordner...\" angesagt.\n\
\nenglish: see 'Help...'\n";
/* rausgenommene Zeilen der Hilfe:
v      Vollbildmodus (Praesentation) ein/aus\n
Ctrl   Vollbildmodus wieder verlassen (oder 2*Esc)\n
(v funktioniert noch aber nicht mehr in der Hilfe, Ctrl nicht mehr getestet)
*/
 janeinrequester(text);
}

void m_help()
{
 char text[]=
"  Help for Diasort\n\
  ================\n\
Limitations:\n\
------------\n\
- Maximum loaded pictures is 4000\n\
  (if you need more: change MAXB in the source)\n\
\n\
keyboard functions:\n\
------------------\n\
Key        Function\n\
Home or <  Go to first page\n\
End  or >  Go to last page yet loaded\n\
PgUp       Previous page (or arrow up)\n\
PgDn       Next page (or arrow down)\n\
y          Refresh (same as menu refresh)\n\
Del        Mark picture as deleted\n\
p          Presentation mode  on/off  (same as menu Vollbild)\n\
i          Like Menu Info\n\
k          Like Menu Kommentar...\n\
d          Like Menu Display\n\
b          Like Menu Bilbo...\n\
a          Like Menu Auswahl (copy actual picture to selection folder)\n\
u          Subtitels on/off\n\
t          Automodus - in fullscreen mode scroll automatic\n\
q          Quit programm (if no needs to save)\n\
\ndeutsch: siehe 'Hilfe...'\n";
 janeinrequester(text);
}

void m_test()
{
 int ok,n,bflag=(argflag['B'])?2:tmpvorbehalten;
 n = (TMPVOR==TMPVOR2) ? 2 : 3;
 ok=requester_input(n,
	"Praesentation jeweils im Vollbildmodus? (1=ja, 0=nein)"
		    ,"%d","%d\n",&vollmodus,
	"Mit Testausdrucken (entspricht -v beim Aufruf): 0=ohne"
		    ,"%d","%d\n",&test,
	"Behalten von temporaeren Vorschaubildern: 0=nein, 1=ja, 2=immer"
		    ,"%d","%d\n",&bflag);
 if(ok)
   {if(bflag==2) argflag['B']=1;
    if(bflag>=1) tmpvorbehalten=1;
    else {tmpvorbehalten=0; argflag['B']=0;}
   }
}

void infoextrahieren(FILE *fp,char *text,int max)
{
 int b0,b1,b2,b3,c,i,j,laenge,textstart=0,nzeilen=0,maxzeil=20;
 char *z,*start;
 //printf("infoextrahieren()\n");//test
 b0=(getc(fp)&0xFF);
 b1=(getc(fp)&0xFF);
 for(z=text,j=0;j<max && nzeilen<maxzeil;)
   {if(j==0)
      {j=1;
       if(b0=='G' && b1=='I') //GIF
          {*z++ = b0; if(++j<max) *z++ = b1;
	   while((c=getc(fp))!=EOF && isttext(c) && ++j<max) *z++ = c;
	   *z=0; return;
	  }
      }
    else
      {while((b0=getc(fp))!=EOF && (b0&0xFF)!=0xFF) ;
       b1=getc(fp); if(b1==EOF) break;
      }
    if(b1==0) continue;
    b1&=0xFF;
    if(b1==0xD9) break;//EOI
    if(b1!=0xD8)
      {b2=(getc(fp)&0xFF); b3=(getc(fp)&0xFF);
       laenge=(b2<<8)+b3;
       //printf("Kennung 0x%02X laenge=%d\n",b1,laenge);//test
       if(b1==0xE1 || b1==0xFE) //Exif erkannt, oder in JFIF Creator-Eintrag
	 {for(i=2;i<laenge && j<max && nzeilen<maxzeil;i++)
	   {c=getc(fp);
	    if(isttext(c))
	      {if(textstart==0) {textstart=1; start=z;}
	       *z++ = c; j++;
	      }
	    else if(textstart>0 && c==0)
	      {if(z>start+3)
	         {*z=0;
		  if(strcmp("PrintIM",start)==0) {*start=0; nzeilen=maxzeil;}
		  else {*z++ = '\n'; j++; nzeilen++;}
		 }
	       else z=start;
	       textstart=0;
	      }
	   }
	 }
       else
	 {for(i=2;i<laenge;i++) getc(fp);}//Eintrag ueberlesen
      }
   }
 *z=0;
 return;
}

char *komextrahieren(FILE *fp) //Kommentar extrahieren aus jpg-Datei
{
 const int max=160;
 static char text[max];
 int b0,b1,b2,b3,c,i,k,j,jmax=4*max,laenge;
 char *z;
 *text=0;
 b0=(getc(fp)&0xFF);
 b1=(getc(fp)&0xFF);
 for(j=0;j<jmax;)
   {if(j==0)
       {if(b0=='G' && b1=='I') return NULL;//GIF enthaelt kein Kommentar
        ++j;
       }
    else
       {while((b0=getc(fp))!=EOF && (b0&0xFF)!=0xFF && ++j<jmax) ;
        b1=getc(fp); if(b1==EOF) return NULL;//kein Kommentar gefunden
       }
    if(b1==0) continue;
    b1&=0xFF;
    if(b1==0xD9) return NULL;//EOI
    if(b1!=0xD8)
      {b2=(getc(fp)&0xFF); b3=(getc(fp)&0xFF);
       laenge=(b2<<8)+b3;
       //printf("Kennung 0x%02X laenge=%d\n",b1,laenge);//test
       if(b1==0xFE) //Kommentar-Kennung
	 {for(z=text,i=2,k=0;i<laenge;i++)
	     {c=getc(fp);
	      if(c>0 && ++k<max) *z++ = c;
	     }
	  *z=0;
	  if(strncmp(text,"CREA",4)==0 || istunsinn(text)) *text=0;
	  else break;
	 }
       else
	 {for(i=2;i<laenge;i++) getc(fp);}//Eintrag ueberlesen
      }
   }
 if(*text==0) return NULL;
 return text;
}

int nummeranpassen(int aktnr)
{
 int nr;
 if(ansicht_modus==VOLLBILD)
      {
       //nr=aktnr-1; //Variante1
       //nr=jreihenfolge[aktnr-1]; //Variante2
       //hier gibts einen unerklaerlichen Fehler:
       //Variante1: wenn Reihenfolge veraendert wurde, stimmt Nummer nicht.
       //Variante2: wenn es geloeschte Bilder hat, stimmt Nummer nicht.
       //komplizierte provisorische Loesung:
       if(vollbildaktnr<1)
	 {fprintf(STDERR,"Fehler in nummeranpassen() vollbildaktnr=%d\n",vollbildaktnr);
	  vollbildaktnr=1;
	 }
       nr=jreihenfolge[vollbildaktnr-1];//provi.
      }
 else nr=jreihenfolge[aktnr-1];
 return nr;
}

void m_info()
{
 char text[400], *name;
 int n,nr,aktnr;
 FILE *fp;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
	sprintf(text,"Bild %d: Bildname unbekannt.",aktnr);
    else if((fp=fopen2(name,"r"))==NULL)
	sprintf(text,"Kann '%s' nicht oeffnen.",name);
    else
      {//printf("name='%s'\n",name);//test
       sprintf(text,"%s\n",name); n=strlen(text);
       infoextrahieren(fp,&text[n],400-n); fclose(fp);
      }
   }
 else strcpy(text,"Fuer Info zuerst ein Bild selektieren.");
 janeinrequester(text);
}

void m_kom() //Bildkommentar
{
 char *s,text[160],cstr1[80], *name;
 int nr,aktnr,ok,fehler=0,farbe=0xFFFFFF,bpen= -1;
 FILE *fp;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else if((s=textliste.get(name,&farbe,&bpen))!=NULL)
      {strcpy(text,s);
      }
    else if((fp=fopen2(name,"r"))==NULL)
      {sprintf(text,"Kann '%s' nicht oeffnen.",name); fehler=1;}
    else
      {s=komextrahieren(fp); fclose(fp);
       if(s!=NULL) strcpy(text,s); else text[0]=0;
      }
    if(fehler) janeinrequester(text);
    else
      {sprintf(cstr1,"Bildkommentar f\\\"ur %s",name);
       ok=requester_input(3,cstr1,"%s","%s\n",text,
			  "Textfarbe (FFFFFF=weiss)","%X","%X",&farbe,
			  "Hintergrundfarbe (-1=ohne)","%X","%X",&bpen);
       if(ok)
         {textliste.set(name,text,farbe,bpen);
	 }
      }
   }
 else
   {janeinrequester("Fuer Bildkommentar zuerst ein Bild selektieren.");}
 m_refresh();
}

bool bildnameanalyse(const char *name,char *stamm,int *reinr,int *fotonr)
{
 /* Beispiele:
    0123-imgp4567.ppm
    0123-rot1-imgp4567.ppm --> stamm="imgp" *reinr=123 *fotonr=4567
 */
 int n=4,i,imax=40,c;
 if(name[n++]!='-') return false;
 sscanf(name,"%d",reinr);
 if(strncmp(&name[n],"rot",3)==0 && isdigit(name[n+3]))
   {if(name[n+4]=='-') n+=5;
    else if(isdigit(name[n+4]) && name[n+5]=='-') n+=6;
   }
 for(i=1;i<imax && (c=name[n])!=0 && !isdigit(c);n++,i++)
   *stamm++ = c;
 *stamm = 0;
 if(!isdigit(name[n])) return false;
 sscanf(&name[n],"%d",fotonr);
 return true;
}

bool vorhanden3(const char *kernname)
{
 Dateiliste *p;
 for(p=tmpdateiliste;p!=NULL;p=p->next)
   if(strcmp(ohnevornummer(p->name),kernname)==0)
     return true;
 return false;
}

void neuernamekonstruieren(char *neuername,const char *name)
{
 int c2,i=0;
 strcpy(neuername,name);
 do
  {ohneletztenpunkt(neuername);
   c2=lastchar(neuername);
   if(c2>='a' && c2<'z') replacelastchar(neuername,c2+1);
   else anhaengen(neuername,"a");
   anhaengen(neuername,".jpg");
  }
 while(vorhanden3(ohnevornummer(neuername))); //vorhanden in tmpdateiliste?
}
void m_bilbo() //Bildbearbeitung
{
 char altername[N80],neuername[N80],text[2*N80+80];
 const char *name,*tmpziel="tmpvonbilbo.jpg",*vtmpziel;
 int nr,aktnr,ok,fehler=0,reinr,fotonr,n;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {if(argflag['Q'] &&
       janeinrequester("NURLESE-Modus - soll Bilbo trotzdem aufgerufen werden?",
		       "ja","nein")==false)  {m_refresh(); return;}
    nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else if(strlen(name)>=N80)
      {fprintf(STDERR,"Fehler: Dateiname zu lang '%s'\n",name);
       sprintf(text,"Fehler: Dateiname zu lang"); fehler=1;
      }
    else
      {if(vorhanden(vtmpziel=vollpfad(tmpziel))) unlink(vtmpziel);
       sprintf(text,"bilbo -bz \"%%s\" \"%%s\" 1>%s 2>%s",bilbo1log,bilbo2log);
       n=system2(text,name,tmpziel);
       if(n!=0) {sprintf(text,
"Konnte bilbo nicht oeffnen. Ist bilbo installiert?\n\
aktuelle Version: www.rolfp.ch/computer/archiv/"); fehler=1;}
      }
    if(fehler) janeinrequester(text);
    else
     if(vorhanden(vtmpziel)) //wenn bilbo in tmpziel gespeichert hat
      {char a1[80]="nein",a2[80]="ja"; if(argflag['Q']) strcpy(a2,"nein");
       strcpy(altername,name);
       neuernamekonstruieren(neuername,name);
       ok=requester_input(4,"  Alter Bildname  ","%s","%s",altername,
	"Altes Bild loeschen falls es ein Link ist?","%s","%s\n",a1,
			    "  Neuer Bildname  ","%s","%s",neuername,
	"Neues Bild als Hardlink in Ueberordner kopieren?","%s","%s",a2);
       if(ok)
	{system2("mv \"%s\" \"%s\"",tmpziel,neuername);
	 if(vorhanden2(neuername))
	     {strcpy(bilder[nr].bildname,neuername);
	      if(istja(a1) && isteinlink(vollpfad(altername)))
	            unlink(vollpfad(altername));
	      //else rename2(altername,ohnevornummer(altername));
	      //Eigentlich will man altes Bild noch an selber Position
	      //um mit neuem Bild zu vergleichen (z.B. nach Aufhellung) -
	      //dann 2 mal selbe Bildnummer wird mit aufraeumen.. geloest.
	      if(istja(a2))
	         verlink_in_ueberordner(neuername);
	      aufraeumen(1);
	     }
	 else fprintf(STDERR,"Neue Bilddatei '%s' nicht gefunden.",neuername);
	}
      }
   }
 else
   {janeinrequester("Fuer Bilbo zuerst ein Bild selektieren.");}
 m_refresh();
}

static char auswahlordner[N80]="auswahl"; //jetzt mit vollem Pfad benutzen

bool vorhandeninauswahl(const char *kernname)
{
 if(!vorhanden2(auswahlordner)) return false;
 Dateiliste *p;
 if(tmpdateiliste2!=NULL) delete[] tmpdateiliste2;
 tmpdateiliste2=mylsmit(auswahlordner);
 for(p=tmpdateiliste2;p!=NULL;p=p->next)
   if(strcmp(ohnevornummer(p->name),kernname)==0)
     return true;
 return false;
}

int nachfotonreinordnen(const char *name,const char *ordner)
{
 int nr,k,reinr,fotonr,reinr2,fotonr2;
 char stamm[40],stamm2[40],*name2;
 if(bildnameanalyse(name,stamm,&reinr,&fotonr)==false) return -1;
 Dateiliste *p;
 if(tmpdateiliste2!=NULL) delete[] tmpdateiliste2;
 p=tmpdateiliste2=mylsmit(ordner);
 for(nr=k=0;p!=NULL && (name2=p->name)!=NULL;p=p->next)
   {if(!isdigit(name2[0])) continue;
    if(bildnameanalyse(name2,stamm2,&reinr2,&fotonr2)==false) continue;
    if(fotonr2<fotonr)
      {if(k<3) {nr=reinr2; k=0;}//wenn noch nicht 3 groessere Nummern
      }                         //hintereinander, dann hier einordnen.
    else if(fotonr2==fotonr && strcmp(stamm,stamm2)==0)
      {nr= -2; break;}//Bild schon vorhanden
    else if(fotonr2>fotonr) k++;
   }
 return nr;
}

void m_auswahl2(int flag) //Aktuelles Bild in Auswahlordner kopieren
{
 static int nachfrageflag=1,sortmode=1,sortposition=0;
 char *name,text[N80];
 int nr,aktnr,ok,fehler=0;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else
      {int c=0,c2=sortmode,c3=sortposition;
       char a2[80]="nein";
       if(nachfrageflag || flag)
	{ok=requester_input(5,
		"Auswahlordner, in den Bild kopiert werden soll:","%s","%s\n",auswahlordner,
		"Nachfragen fuer anderen Auswahlordner?","%s","%s\n",a2,
		"Bei Aufruf ueber A-Taste auch nachfragen? (1=ja, 0=nein)","%d","%d\n",&c,
		"Sortiermodus (0=Sortiernummer, 1=Fotonummer, 2=bestimmte Position):","%d","%d\n",&c2,
		"Bei Sortiermodus 2 an folgender Position einsortieren:","%d","%d",&c3);
	 if(!ok) return;
	 nachfrageflag=c;
	 sortmode=c2; sortposition=c3;
	 c=strlen(auswahlordner);
	 if(istja(a2) || c<2 || auswahlordner[0]=='.' || auswahlordner[0]=='/')
	   {strcpy(auswahlordner,vollpfad(auswahlordner));
	    ok=nachfilenamefragen("Lade Auswahlordner",auswahlordner,N80);
	    if(!ok) {strcpy(text,"Auswahl abgebrochen"); fehler=1;}
	   }
	 else
	   {if(auswahlordner[c-1]=='/') auswahlordner[c-1]=0;
	    strcpy(auswahlordner,vollpfad(auswahlordner));
	    if(!vorhanden(auswahlordner))
	       system2("mkdir \"%s\"",auswahlordner);
	   }
	}
       if(fehler==0 && !vorhanden(auswahlordner))
	 {sprintf(text,"Ordner '%s' nicht gefunden.",auswahlordner); fehler=1;}
      }
    if(fehler) {nachfrageflag=1; janeinrequester(text);}
    else
      {int ok=1;
       if(sortmode==2)
	 sprintf(scratch,"%s/%04d-%s",auswahlordner,sortposition,ohnevornummer(name));
       else if(sortmode==1)
	 {int nr=nachfotonreinordnen(name,auswahlordner);
	  if(nr>=0)
	    sprintf(scratch,"%s/%04d-%s",auswahlordner,nr,ohnevornummer(name));
	  else if(nr== -2) ok=0;//schon vorhanden, nicht nochmals kopieren
	  else sprintf(scratch,"%s/%s",auswahlordner,ohnevornummer(name));
	 }
       else //(sortmode==0)
	 {sprintf(scratch,"%s/%s",auswahlordner,name);
	 }
       if(ok)
	 {if(istsoftlink(vollpfad(name)))
	    system2("cp -L \"%s\" \"%s\"",name,scratch);
	  else mylink(vollpfad(name),scratch);
	 }
       else fprintf(STDERR,"Error in m_auswahl2(): '%s' schon vorhanden\n",name);
      }
   }
 else
   {janeinrequester("Fuer Auswahl zuerst ein Bild selektieren.");}
 m_refresh();
}
void m_auswahl() {m_auswahl2(1);}

void m_display() //Vergroessertes Anzeigen
{
 char text[80],*name;
 int nr,aktnr,ok,fehler=0;
 //printf("selektbildnr=%d\n",selektbildnr);//test
 if(ansicht_modus==VOLLBILD)
   {aktnr=vollbildnr;
    if(aktnr>nbilder) aktnr=0;//provi.
   }
 else aktnr=selektbildnr;
 if(aktnr>0)
   {nr=nummeranpassen(aktnr);
    name=bilder[nr].bildname;
    if(name==NULL || *name==0)
      {sprintf(text,"Bild %d: Bildname unbekannt.",nr); fehler=1;}
    else
      {system2("display \"%s\"",name);
      }
    if(fehler) janeinrequester(text);
   }
 else
   {janeinrequester("Fuer Vergroesserte Ansicht zuerst ein Bild selektieren.");}
 m_refresh();
}

/************************ neue Funktionen *****************************/
static char nummernliste[10000];

bool keinedoppeltenummern(Dateiliste *p)
{
 const char *z;
 int i,nr,anzahldoppelte=0;
 for(i=1;i<10000;i++) nummernliste[i]=0;
 nummernliste[0]=1;//Nummer 0000 wird zu 0001 was dann eine doppelte Nr gibt.
 for(;p!=NULL && (z=p->name)!=NULL;p=p->next)
   {if(isdigit(z[0]) && isdigit(z[1])
       && isdigit(z[2]) && isdigit(z[3]) && z[4]=='-')
       {sscanf(z,"%d",&nr);
	if(nummernliste[nr]++) anzahldoppelte++;
       }
   }
 return (anzahldoppelte==0);
}
void bildnummernkorrigieren(Dateiliste *p)
{
 char neuername[M80+8];
 const char *z;
 int nr,aktnr,err;
 for(aktnr=1;p!=NULL && (z=p->name)!=NULL;aktnr++,p=p->next)
   if(isdigit(z[0]) && isdigit(z[1])
      && isdigit(z[2]) && isdigit(z[3]) && z[4]=='-')
       {sscanf(z,"%d",&nr);
	if(aktnr==1 && nr>aktnr) aktnr=nr;//erste Nummer kann groesser 1 sein
	if(nr!=aktnr)
	  {sprintf(neuername,"%04d-%s",aktnr,&z[5]);
	   err=rename(vollpfad(z),vollpfad(neuername));
	   if(err)
	     {fprintf(STDERR,"Fehler %d: rename(%s,%s)\n",err,z,neuername);
	      fehlermeldung(err);
	      exit(0);
	     }
	  }
       }
}

void tmpdateiliste_aktualisieren(int sofortflag)
{
 if(tmpdateiliste!=NULL) delete[] tmpdateiliste;
 tmpdateiliste=mylsmit(".");
 bool ok=keinedoppeltenummern(tmpdateiliste);
 if(!ok)
  {if(sofortflag || wirklichloeschen) ok=1;
   else ok=janeinrequester("Es gibt doppelte Nummern.\nAlle Dateien auf eindeutige Nummern umbenennen?",
		       "ja - umbenennen","nein - Programm abbrechen");
    if(!ok) {fprintf(STDERR,"Nichts umbenennen - Programm abgebrochen um zu verhindern dass Bilder durcheinander geraten!\n"); exit(0);}
    bildnummernkorrigieren(tmpdateiliste);
    delete[] tmpdateiliste;
    tmpdateiliste=mylsmit(".");
   }
}

Dateiliste *listeausdateilesen(FILE *fp)
{
 char zeile[M80],*s;
 int nb;
 Dateiliste *liste=new Dateiliste[1];
 while(getline(fp,zeile,M80))
   {if((nb=anzahlblanks(zeile))>0) //falls in name Leerstellen sind
       {s=escapeblanks(zeile,nb);
	strncpy(zeile,s,M80);
	delete[] s;
       }
    liste=liste->einsortieren(zeile,0);
   }
 return liste;
}

void bilder_laden() //Bilder einlesen und als Vorschaubildchen zeichnen
{
 Dateiliste *p;
 if(argflag['F'])
   {FILE *fp;
    if(reihenfolgedatei[0]==0)
       {fprintf(STDERR,"Fehler: keine Reihenfolgedatei.\n"); exit(0);}
    fp=fopen(reihenfolgedatei,"r");
    if(fp==NULL)
      {fprintf(STDERR,"Fehler: kann '%s' nicht oeffnen.\n",reihenfolgedatei); exit(0);}
    p=tmpdateiliste=listeausdateilesen(fp);
    fclose(fp);
   }
 else
   {if(tmpdateiliste==NULL) tmpdateiliste_aktualisieren();
    p=tmpdateiliste;
   }
 inital_new();
 color(hintergrundgrau); ifillbox(0,0,XMAX,YMAX);//grauer Hintergrund
 int nr=1,ok=1;
 for(;ok && p!=NULL;p=p->next)
   if(istbilddatei(p->name))
       {
	if(ansicht_modus==VOLLBILD) ok=vollbild_laden(p->name,nr++);
	else ok=bild_laden(p->name,nr++);
       }
 if(ansicht_modus==VOLLBILD) maxvollbilder=nr-1;
 term_refresh();
}

char *namelesen(FILE *fp)
{
 static char name[MAXD];
 *name=0;
 while(getline(fp,name,MAXD) && index(name,".")<1) *name=0;
 if(*name==0) return NULL;
 return name;
}

bool rueckfragen(const char *text)
{
 int ok,n;
 if(startflag==0) ok=janeinrequester(text);
 else
  {char antw[40];
   printf("%s",text); n=scanf("%s",antw); if(n!=1) {fehlerscanf(1,n); *antw=0;}
   ok=istja(antw);
  }
 return ok;
}

bool ordner_erstellen(char *ordner)
{
 int n;
 char text[400];
 if(istordner(ordner))
   {sprintf(text,"Ordner '%s' schon vorhanden,\n\
Dateien werden vielleicht ueberschrieben.\n\
Trotzdem diesen Ordner verwenden? ",ordner);
    if(rueckfragen(text)==false) return false;
   }
 else if(vorhanden2(ordner))
  {fprintf(STDERR,"'%s' ist kein Ordner.\n",ordner); return false;}
 else
   {//if(test) fprintf(STDERR,"erstelle Ordner '%s'\n",ordner);//test
    system2("mkdir \"%s\"",ordner);
   }
 if(istordner(ordner)) return true;
 else fprintf(STDERR,"konnte Ordner '%s' nicht erstellen.\n",ordner);
 return false;
}
int file_linken_oder_kopieren(char *name,int nummer,char *ordner)
{
 int nb,err;
 char *name2,*str=NULL, sname[N80],neuername[N80];
 if((nb=anzahlblanks(name))>0) //falls in name Leerstellen sind
   name2=str=entferneblanks(name);
 else name2=name;
 if(isdigit(name2[0]) && isdigit(name2[1]) && isdigit(name2[2])
    && isdigit(name2[3]) && name2[4]=='-')
   sprintf(neuername,"%s/%04d-%s",ordner,nummer,&name2[5]);
 else sprintf(neuername,"%s/%04d-%s",ordner,nummer,name2);
 //if(vorhanden2(neuername)) unlink(neuername);
 fprintf(STDERR,"%s --> %s\n",name,neuername);
 const char *sneu=vollpfad(neuername);//braucht es unbedingt!
 if(kopiermethode==1)
   {sprintf(sname,"../%s",name); err=symlink(sname,sneu);//Softlink
    if(err) {fprintf(STDERR,"Fehler bei symlink(%s,%s)\n",sname,neuername);
             fehlermeldung(err);}
   }
 else if(kopiermethode==2)
   {const char *s;
    mylink(s=vollpfad(name),sneu);//Hardlink
   }
 else system2("cp \"%s\" \"%s\"",vollpfad(name),sneu);//kopiermethode==3
 if(str!=NULL) delete[] str;
 return nummer+1;
}
void kopiermethode_setzen()
{
 if(argflag['S']) {kopiermethode=1; printf("Softlinks werden angelegt:\n");}
 else if(argflag['Z'])
    {kopiermethode=2; printf("Hardlinks werden angelegt:\n");}
 else {kopiermethode=3; printf("Dateien werden kopiert:\n");}
}

void verlink_in_ueberordner(const char *name)
{
 char ueberpfad[N80];
 strcpy(ueberpfad,vollpfad(""));
 if(*ueberpfad!='/' || strlen(ueberpfad)<4) return;
 if(lastchar(ueberpfad)=='/') replacelastchar(ueberpfad,0);
 while(lastchar(ueberpfad)!='/') replacelastchar(ueberpfad,0);
 anhaengen(ueberpfad,ohnevornummer(name));
 if(vorhanden(ueberpfad))
  {sprintf(scratch,"\"%s\"\nschon vorhanden - kein neuer Link gesetzt.",ueberpfad);
   janeinrequester(scratch);
  }
 else
  {fprintf(STDERR,"link(\"%s\",\"%s\");\n",vollpfad(name),ueberpfad);//test
   mylink(vollpfad(name),ueberpfad);
  }
}

void sode(char *reihenfolge,char *ordner)
{ //macht Vorbereitungen: Reihenfolgedatei lesen, Bilder kopieren
 int ok,nummer,err;
 char *name;
 if(*reihenfolge==0)
  {//nach tmpdateiliste einsortieren:
   if(ordner_erstellen(ordner)==false) return;
   kopiermethode_setzen();
   Dateiliste *p;
   for(nummer=1,p=tmpdateiliste;p!=NULL;p=p->next)
    {if(p->typ!=NORM)
      fprintf(STDERR,"sode() Datei '%s' vom falschen Typ: typ=%d\n",
	      p->name,p->typ);
     else
      {name=p->name; nummer=file_linken_oder_kopieren(name,nummer,ordner);}
    }
  }
 else
  {//nach reihenfolge sortieren:
   FILE *fp=fopen(reihenfolge,"r");
   if(!fp)
     {fprintf(STDERR,"sode() %s nicht gefunden.\n",reihenfolge); return;}
   if(ordner_erstellen(ordner)==false) {fclose(fp); return;}
   kopiermethode_setzen();
   for(nummer=1;(name=namelesen(fp))!=NULL;)
    {ok=vorhanden2(name);
     if(!ok) {machklein(name); ok=vorhanden2(name);}
     if(ok)
       nummer=file_linken_oder_kopieren(name,nummer,ordner);
     else
       fprintf(STDERR,"sode() Datei '%s' nicht gefunden.\n",name);
    }
   fclose(fp);
  }
}

/************************* Hauptprogramm ******************************/
void grafikfenster_oeffnen()
{
 double xmin=0,ymin=0,xmax=XMAX,ymax=YMAX;
 setmenu(4,"File",           "Ansicht",   "Bearbeitung", "Help");
 setmenu(4,"About ...",      "Normal",    "Info",        "Hilfe ...",m_about,m_normal,m_info,m_hilfe);
 setmenu(4,"Ordner ...",     "Gross",     "Kommentar...","Help ...", m_pwd, m_gross, m_kom, m_help);
 setmenu(4,"Neuer Ordner...","Vollbild",  "Display",     "Test ...", m_neuord, m_vollb, m_display, m_test);
 setmenu(3,"Save",           "Refresh" ,  "Bilbo ...", m_save,m_refresh,m_bilbo);
 setmenu(3,"Aufraeumen...",    NULL,      "Auswahl...", m_aufraeum,NULL,m_auswahl);
 setmenu(1,"Exit", m_exit);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(xmin,ymin,xmax,ymax);
 set_tektitel3(pwd.getpfad());
 if(gtiefe<24) farben_init();
 hintergrundgrau=farbnummer(128,128,128);
 waitTOF();
 term_refresh();
 waitTOF();
 startflag=0;
}

//ab xtekplot1-Version 2.87 sollte direkter Aufruf von waitmenu() auch gehen
inline int mywaitmenu(int n) {return (startflag==0 ? waitmenu(n) : 0);}

static char ordnername[MAXP];

int main(int argc,char *argv[])
{
 int c,i,j,visklasse;
 reihenfolgedatei[0]=0; ordnername[0]=0;
 
 logdatei_oeffnen(); //test
 fprintf(STDERR,"diasort-%s argc=%d\n",VERSION,argc);//test
 for(i=0;i<argc;i++) fprintf(STDERR," argv[%d]=\"%s\"\n",i,argv[i]);//test

 for(j=0,i=1;i<argc;i++) //falls argc<=0 wird die Schlaufe gar nie ausgefuehrt
        {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else if(isdigit(c)) sscanf(argv[i],"%d",&anzahl);
         else   {if(++j==1) strcpy(reihenfolgedatei,argv[i]);
	         else if(j==2) strcpy(ordnername,argv[i]);
        }       }
 // im Starter mit xfce4 sollte man das Flag -W setzen (zwingend wenn Terminal=true)
 //if(argc<=0 || (argc>=1 && *argv[0]=='/') || argflag['W']) //Start von Grafischer Oberflaeche
 if(argc<=0 || (argc>=1 && *argv[0]=='/') || (argc>=2 && *argv[1]=='/') || argflag['W']) //test
   { // von WorkBench (Amiga) oder von z.B. xfce4-Desktop (Linux) gestartet
    if(argflag['W']) workbenchflag=1; //mit Starter gestartet
    else workbenchflag=2; //wahrscheinlich mit "Oeffnen mit..." gestartet
    //test logdatei_oeffnen();
    fprintf(STDERR,"Test: workbenchflag=%d argc=%d j=%d\n",workbenchflag,argc,j);//test
    fprintf(STDERR,"Testpunkt1: getenv(\"PWD\")=\"%s\"\n",getenv("PWD"));//test
    if(!argflag['W']) argflag['Q']=1;//Start im Nurlese-Modus
    // Wenn ein Bild per Mausklicks gestartet, dann ist argv[0] der absolute Pfad zum Programm
    // und argv[1] ist dann der absolute Pfad zum entsprechenden Bild:
    if(argc==2 && *argv[0]=='/' && *argv[1]=='/')
     {
      char dateiname[MAXD];
      splitpfad(argv[1],ordnername,dateiname,MAXP,MAXD);
      if(lastchar(ordnername)!='/') zeichen_anhaengen(ordnername,'/');
      pwd.set(ordnername);
      setargflags("RB"); //Flags setzen: Exif-Rotieren, Vorschaubilder behalten
     }
    else //sonst gehen wir auf $HOME/Bilder/
     {
      sprintf(ordnername,"%s/Bilder/",getenv("HOME"));
      pwd.set(ordnername);
      //pwd.set("/cdrom/fotos/diashow/"); //fuer Demo-DVD
      //pwd.set("/musik/knxmaster/fotos/diashow/");//test
     }
    //test=1;//test
    fprintf(STDERR,"Testpunkt2: argc=%d ordnername=\"%s\"\n",argc,ordnername);//test
    fprintf(STDERR," getenv(\"PWD\")=\"%s\"\n",getenv("PWD"));//test
   }
 if(argflag['?'] || argflag['H'] || j>MAXARG)
	{printf("diasort  %s\n",VERSION);
	 printf("Anwendung: diasort [-Flags] [reihenfolge.txt] [ordner]\n");
	 printf("  Flags: v=Verbose (also mit Testausdrucken)\n");
	 printf("         h=diese Hilfe (geht auch mit -?)\n");
	 printf("         t=andere Farbtiefe (%d statt %dBit)\n",TIEFE2,TIEFE);
	 printf("         c=Kopiere die Bilddateien in neuen Ordner\n");
	 printf("         s=Softlinks der Bilddateien in neuem Ordner erstellen\n");
	 printf("         z=Hardlinks der Bilddateien in neuem Ordner erstellen\n");
	 printf("         o=Sortiermethode: 1=Dateinamen 2=Aufnahmedatum 3=Nummern\n");
	 printf("         f=Reihenfolgedatei lesen und nur diese Bilder verwenden\n");
	 printf("         p=Praesentation im Vollbildmodus\n");
	 printf("         a=Automatisch eine Anzahl Bilder einlesen\n");
	 printf("         b=Behalte Temporaere Vorschaubilder\n");
	 printf("         Q=nichts automatisch in aktuellen Ordner schreiben\n");
	 printf("         U=Automodus\n");
	 printf("         W=wie Start von Workbench (GUI)\n"); //W-R sind neue Flags ab Version 1.12
	 printf("         X=auf NURLESE-Modus verzichten\n");
	 printf("         R=Rotieren der Bilder gemaess Exif-Eintrag\n"); //also jeweils "convert -auto-orient"
	 printf("Beispiele:\n");
	 printf(">diasort -z diashow   #typischer erster Aufruf\n");
	 printf(">diasort -zo2 diashow #oder zum Sortieren nach Aufnahmedatum\n");
	 printf(">cd diashow           #in neuen Ordner wechseln\n");
         printf(">diasort -p           #starten im Vollbildmodus\n");
	 printf("etwas speziellere Beispiele:\n");
	 printf(">diasort -zf reihenfolge.txt diashow\n");
	 printf(">diasort -va 200   #mit Testausdrucken, erste 200 Bilder einlesen\n");
	 printf(">diasort -vv       #mit noch mehr Testausdrucken\n");
	 exit(0);
	}
 if(argflag['Q']) {TMPVOR=TMPVOR2;}

 if(!workbenchflag) {

 if(test) printf("sortiermethode=%d\n",sortiermethode);//test
 if(argflag['T']) TIEFE=TIEFE2;
 if(argflag['F'] && reihenfolgedatei[0]==0)
   {printf("Reihenfolgedatei: "); c=scanf("%s",reihenfolgedatei);}
 if(argflag['C'] || argflag['S'] || argflag['Z'])
   {if(!argflag['F'])
      {strcpy(ordnername,reihenfolgedatei); reihenfolgedatei[0]=0;
       if(!argflag['O'])
	 {printf("Wonach sortieren? (1=Dateinamen, 2=Aufnahmedatum, 3=Nummern in Dateinamen) ?");
	  int n=scanf("%d",&sortiermethode);
	 }
       tmpdateiliste=mylsmit(".");
      }
    if(ordnername[0]==0)
      {printf("neuer Ordner: "); c=scanf("%s",ordnername);}
    sode(reihenfolgedatei,ordnername);
    if(tmpdateiliste!=NULL) delete[] tmpdateiliste;
    exit(0);
   }
 //if(argflag['V'] && test>=2) tek_setdebug(test-1);//test
 if(argflag['A'] && anzahl<2)
   {printf("Minimale Anzahl zu ladende Bilder:"); c=scanf("%d",&anzahl);}
 if(argflag['B'] || vorhanden(TMPVOR)) tmpvorbehalten=1;
 if(!argflag['F'] && j==1)
   {sprintf(ordnername,"%s/%s/",getenv("PWD"),reihenfolgedatei);
    reihenfolgedatei[0]=0;
   }
 else
   {sprintf(ordnername,"%s/",getenv("PWD"));
   }
 pwd.set(ordnername);
 if(argflag['U'] && autopause<0)
   {printf("Wartezeit im Automodus:"); c=scanf("%d",&autopause);
    if(autopause>2) autopause-=2; //Ladezeit subtrahieren
    autopause *= 60; //Anzahl Bilddurchlaeufe pro Sekunde
    printf("Anzahl Durchlaufen lassen aller Bilder:"); c=scanf("%d",&automodus);
    if(automodus<1) automodus=1;
   }

 } //if(!workbenchflag)

 getmaxsize(&gbreite,&ghoehe,&gtiefe,&visklasse);
 if(argflag['V']) printf("gbreite=%d ghoehe=%d gtiefe=%d visklasse=%d\n",
			 gbreite,ghoehe,gtiefe,visklasse);
 if(gtiefe>TIEFE) gtiefe=TIEFE;
 else if(gtiefe<TIEFE)
   {fprintf(STDERR,"Warnung: Farbtiefe kleiner als %d: gtiefe=%d\n",TIEFE,gtiefe);}
 setsize(XMAX=gbreite,YMAX=ghoehe,TIEFE=gtiefe);
 //XMAX,YMAX,TIEFE koennten noch wegoptimiert werden.
 if(gtiefe<24) setmaxfarben(1<<gtiefe);
 int vollbildstartflag = (argflag['P']) ? 1 : 0;//ev. Start im Vollbildmodus
 grafikfenster_oeffnen();

#ifdef DEBUGMODUS
 {char text[400];//test
  sprintf(text,"DEBUGMODUS: Der aktuelle Ordner ist '%s'\n\
argc=%d argv[0]='%s' workbenchflag=%d",getenv("PWD"),argc,argv[0],workbenchflag);
  janeinrequester(text);
 }
#endif

 if(!workbenchflag) {

 //testen ob Dateinamen mit Nummern beginnen:
 if(!argflag['F'] && tmpdateiliste==NULL)
   {int k=0,ok;
    Dateiliste *p;
    tmpdateiliste=mylsmit(".");
    for(p=tmpdateiliste;p!=NULL;p=p->next)
      if(isdigit(p->name[0]) && isdigit(p->name[1]) &&
	 isdigit(p->name[2]) && isdigit(p->name[3]))	k++;
    if(k<2)
      {if(argflag['Q']) ok=1;
       else ok=janeinrequester("Willkommen bei Diasort\n\
Es gibt noch keine nummerierte Dateien,\n\
Sie haben jetzt verschiedene Moeglichkeiten,\n\
die Ihnen gleich zur Auswahl gestellt werden.","Weiter","Abbruch");
       if(!ok) exit(0);
       char a1[80]="nein",a2[80]="nein",anderer[80]="diashow";
       strcpy(ordnername,"diashow");
       sortiermethode=2;
       for(int i=1;vorhanden(ordnername) && i<100;i++)
	 sprintf(ordnername,"diashow%d",i);
       if(argflag['Q']) {*a2='j';}
       else ok=requester_input(5,
	"entweder: Diashow in neuem Ordner erstellen","%s","%s",a1,
	"Name des neuen Ordners","%s","%s\n",ordnername,
	"Sortiermethode: 1=Dateinamen 2=Aufnahmedatum 3=Nummern in Dateinamen",
			  "%d","%d\n",&sortiermethode,
	"oder: Bilder so anzeigen wie sie sind (immer im NURLESE-Modus bleiben)","%s","%s\n",a2,
	"oder: in einen anderen Ordner wechseln","%s","%s\n",anderer);
       if(!ok) exit(0);
       printf("sortiermethode=%d ordnername='%s'\n",sortiermethode,ordnername);//test
       if(istja(a2))
	 {argflag['Q']=2; TMPVOR=TMPVOR2; sortiermethode=1;}
       else if(istja(a1))
	 {system2ds("diasort -zo%d \"%s\"",sortiermethode,ordnername);
	  if(!vorhanden(ordnername))
	    {fprintf(STDERR,"Fehler: konnte Ordner '%s' nicht erstellen.\n",ordnername); exit(0);}
	  if(tmpdateiliste!=NULL)  {delete[] tmpdateiliste;  tmpdateiliste=NULL;}
	  sortiermethode=1;
	  pwd.cd(ordnername);
	 }
       else
	 {sortiermethode=1;//fuer Diashow immer nach Dateinamen sortieren
	  argflag['Q']=1;
	  if(istordner(anderer)) strcpy(ordnername,anderer);
	  else *ordnername=0;
	  workbenchflag=1;
	 }
      }
   }

 } //Ende von if(!workbenchflag)

 bilder_laden();//erst mal normaler Start
 textliste.laden();

 if(workbenchflag==1) //Wenn vom GUI gestartet (aber nicht mit "Oeffnen mit...")
  {argflag['Q']=1; //vorerst mal keine Veraenderungen erlauben
   if(*ordnername!=0) pwd.cd(ordnername);
   m_pwd();        //und Ordner auswaehlen lassen
  }
 else if(workbenchflag==2) //Wenn mit "Oeffnen mit..." gestartet
  {
#ifdef SICHERHEITS_WARNUNG
   int ok=janeinrequester("Unsicherheits-Flag X setzen?","Ja","Nein");
   if(ok)
#endif
   argflag['X']=1; //TODO: so ist es bequemer zu bedienen, aber gefaehrlicher dass man
                   //      versehentlich was an den Bildern veraendert.
  }
 if(argflag['X']) argflag['Q']=0; //Wenn Unsicherheitsflag X gesetzt, dann NURLESEMODUS ausschalten
 set_tektitel3(pwd.getpfad());

 if(nbilder>0) selektbildnr=1;
 int taste,asci,vorher= -1,ipause=0; ULONG rawcode;
 while(exitflag==0 && mywaitmenu(0)==0)
  {waitTOF(); //auf Beginn des Bildaufbaus warten
   if(nbilder<anzahl && nbilder>vorher) //mindestens "anzahl" Bilder einlesen
      {vorher=nbilder; scrollen(4);}
   else if(vollbildstartflag) {m_vollb(); vollbildstartflag=0;}
   else if(keyget(&taste,&asci,&rawcode)!=0)
     {switch(rawcode)
	{case 0xFF51: case 0xFF52: case 0xFF53: case 0xFF54://Pfeiltasten
			scrollen(rawcode-0xFF50);
	 CASE 0xFF1B: case 0xFFE3: //Esc oder Ctrl
			if(ansicht_modus==VOLLBILD) vollbild_aus();
	 CASE 0xFFFF: case 0xFF60: case 0xFF08://Delete oder Backspace
		if(ansicht_modus!=VOLLBILD && selektbildnr>0) bild_loeschen();
	 CASE 0xFFE1: case 0xFFE2://Shifttaste
			//noch auswerten zum mehrere Bilder verschieben
	 CASE 0xFF55: scrollen(2); //Page Up
	 CASE 0xFF56: scrollen(4); //Page Down
	 CASE 0xFF50: case '<'://Home
		if(ansicht_modus==VOLLBILD) scrollen(2,1);
		else if(sichty>0) scrollen(2,sichty);
	 CASE 0xFF57: case '>'://End
		if(ansicht_modus==VOLLBILD) scrollen(4,1);
		else if(sichty<maxsichty) scrollen(4,maxsichty-sichty);
	 CASE 'y': case 'Y': m_refresh();
	 CASE 'v': case 'V': case 'p': case 'P':
		if(ansicht_modus==VOLLBILD) vollbild_aus(); else m_vollb();
	 //CASE 'u': case 'U': untertitelflag^=1; m_refresh();
	 CASE 'u': case 'U': if(++untertitelflag==3) {untertitelflag=0;} m_refresh();
	 CASE 'q': case 'Q':
		     if(ansicht_modus==VOLLBILD) vollbild_aus();
		     else if(nochnichtgespeichert==0 && textliste.gespeichert)
		        exitflag=1;
	 CASE 'i': case 'I': m_info();
	 CASE 'k': case 'K': m_kom();
	 CASE 'd': case 'D': m_display();
	 CASE 'b': case 'B': m_bilbo();
	 CASE 'a': case 'A': m_auswahl2(0);
	 CASE 't': case 'T': setautomodus();
	 CASE 'r': case 'R': if(argflag['R']) argflag['R']=0; else argflag['R']=2;
		     m_refresh(); //TODO: Problem Vorschaubilder werden so nicht gedreht
	 DEFAULT:
	   if(test) printf("taste=%d=%02X asci=0x%02X='%c' rawcode=0x%04lX\n",
			   taste,taste,asci,asci,(long)rawcode);
	}
     }
   else if(automodus && ansicht_modus==VOLLBILD)
     {if(++ipause>=autopause)
	 {if(vollbildnr<nbilder) scrollen(4); //Page Down
	  else {if(--automodus>0) vollbildnr=0;}
	  ipause=0;
	 }
     }
  }
 if(!argflag['Q'])
  {if(!textliste.gespeichert)
     textliste.speichern();//ohne Rueckfrage
   if(nochnichtgespeichert)
     {int ok=janeinrequester("Aktuelle Reihenfolge speichern?","Ja","Nein");
      if(ok) m_save();
     }
  }
 term_exit();
 //temporaere Dateien loeschen:
 if(vorhanden(tmpppm)) {unlink(tmpppm); if(test) printf("unlink(%s)\n",tmpppm);}
 if(tmpvorbehalten==0) system2("rm -r \"%s\"",TMPVOR);
 vollbild.clear(); //Bildspeicher wieder freigeben
 for(i=0;i<nbilder;i++) bilder[i].clear(); //Bildspeicher wieder freigeben
 textliste.loeschen(); //Speicher von Textliste auch freigeben
 pwd.loeschen(); //Speicher in pwd auch freigeben
 logdatei_schliessen();
 return 0;
}/* ende von main */

void scrollen(int richtung,int step)
{
 //printf("scrollen(%d,%d)\n",richtung,step);//test
 if(ansicht_modus==VOLLBILD)
   {if(richtung==2 && vollbildnr>1)
        {vollbildnr--; if(step>0) vollbildnr=1;}
    else if(richtung==4 && vollbildnr<maxvollbilder)
        {vollbildnr++; if(step>0) vollbildnr=maxvollbilder;}
    bilder_laden();
    return;
   }
 if(richtung==1 || richtung==3)
    {
     if(selektbildnr>0 && !argflag['Q']) //Bild drehen
        {int nr=jreihenfolge[selektbildnr-1];
	 bilder[nr].einfachesdrehen((4-richtung)*90);
	 bilder[nr].rotnr += (richtung==1)?-1:1;
	 nochnichtgespeichert=1;
	 neuzeichnen_nur1bild(nr);
	}
     return;
    }
 if(step==0) step = (zoomfaktor>100) ? sichtstep*100/zoomfaktor : sichtstep;
 switch(richtung)
   {case 1: sichtx -= step;  break;
    case 2: sichty -= step;  break;
    case 3: sichtx += step;  break;
    case 4: sichty += step;  break;
   }
 if(sichty>maxsichty) {bilder_laden(); maxsichty=sichty;}
 else neuzeichnen();
}
void bild_loeschen()
{
 int nr=jreihenfolge[selektbildnr-1];
 bilder[nr].loeschflag ^= 1;
 nochnichtgespeichert=1;
 neuzeichnen_nur1bild(nr);
}
void bildertauschen(int i,int j)
{
 if(nbilder>1 && j!=i && j>=0 && j<nbilder && i>=0 && i<nbilder)
   {int h=jreihenfolge[i];
    jreihenfolge[i]=jreihenfolge[j];
    jreihenfolge[j]=h;
    int j1=jreihenfolge[i],j2=jreihenfolge[j];
    h=bilder[j1].sortiernummer;
    bilder[j1].sortiernummer=bilder[j2].sortiernummer;
    bilder[j2].sortiernummer=h;
    h=bilder[j1].offsetx;
    bilder[j1].offsetx=bilder[j2].offsetx;
    bilder[j2].offsetx=h;
    h=bilder[j1].offsety;
    bilder[j1].offsety=bilder[j2].offsety;
    bilder[j2].offsety=h;
    nochnichtgespeichert=1;
   }
}

int bildnummerausposition(int ix,int iy,int& x1,int& y1,int& x2,int& y2)
{
 int nr,xo,yo;
 for(nr=1,xo=yo=DB;;nr++)
     {x1=xo; y1=yo-sichty; x2=x1+BB; y2=y1+BB;
      if(ix>x1 && ix<x2 && iy>y1 && iy<y2) break;
      if((xo+=BB+DB)>gbreite-BB-DB)
	{yo+=BB+DB; xo=DB;
	 if(yo-sichty>ghoehe-BB) {nr=0; break;}
	}
     }
 if(nr>nbilder+1) nr=0;
 return nr;
}
int bildnummerausposition(int ix,int iy)
{
 int x1,y1,x2,y2;
 return bildnummerausposition(ix,iy,x1,y1,x2,y2);
}

void mausbewegung(int flag)
{
 int ix,iy,tasten;
 static int x1,y1,x2,y2,x10,y10,x20,y20,nr=0;//aktuelle Selektion
 static int xa,ya,xb,yb,nr2=0;//Zielposition
 static int dy=0,ix0,iy0;
 if(ansicht_modus==VOLLBILD) {gedruecktemaustaste=selektbildnr=nr=0; return;}
 tasten=imausposition(&ix,&iy);
 iy-=dy;
 if(flag==1 && nr2>0)
   {flag=2;//verlorenes Maustaste-Loslassen-Event nachholen
   }
 if(flag==1) //Maustaste gedrueckt
  {if(selektbildnr>0)
     {color(hintergrundgrau); idrawbox(x10,y10,x20,y20);//grau
      selektbildnr=0;
     }
   if(test>=2) printf("Mousepress %d x=%d y=%d\n",tasten,ix,iy);
   gedruecktemaustaste=1;
   if(dy==0) {dy=get_menuleistenhoehe(); iy-=dy;}
   nr=bildnummerausposition(ix,iy,x1,y1,x2,y2);
   if(nr>0)
     {mycolor(255,0,0); //roter Rahmen um selektiertes Bild
      idrawbox(x10=x1,y10=y1+dy,x20=x2,y20=y2+dy);
      drawmode(COMPLEMENT);
      idrawbox(x1,y1+dy,x2,y2+dy);
      ix0=ix; iy0=iy;
     }
  }
 else if(flag==2) //Maustaste losgelassen
  {if(test>=2) printf("Mouserelease %d x=%d y=%d\n",tasten,ix,iy);
   gedruecktemaustaste=0;
   if(nr>0)
     {
      drawmode(COMPLEMENT);
      idrawbox(x1,y1+dy,x2,y2+dy);
      drawmode(JAM1);
      if(nr2==0 && bildnummerausposition(ix,iy)==nr && nr<=nbilder)
	selektbildnr=nr;
      else
	{color(hintergrundgrau);idrawbox(x10,y10,x20,y20);}//grauer Rahmen
      if(nr2>0)
	{
	 idrawbox(xa-DB+1,ya+dy,xa-1,yb+dy);
	 if(nr2<nr)
	   {for(;nr>nr2;--nr)
	     {bildertauschen(nr-1,nr-2);//-1 weil jreihenfolge mit 0 beginnt!
	      //printf("vertausche %d mit %d\n",nr,nr-1);//test
	     }
	   }
	 else if(nr2>nr+1)
	   {for(;nr+1<nr2;nr++)
	     {bildertauschen(nr-1,nr);
	      //printf("vertausche %d mit %d\n",nr,nr+1);//test
	     }
	   }
	 else fprintf(STDERR,"Fehler: nr==nr2 (%d==%d)\n",nr,nr2);//test
	 nr2=0;
	 neuzeichnen();
	}
      nr=0;
     }
  }
 else if(flag==3) //Mausbewegung
   {//if(test>=2) printf("Mousemove %d x=%d y=%d\n",tasten,ix,iy);
    if(nr>0)
      {drawmode(COMPLEMENT);
       idrawbox(x1,y1+dy,x2,y2+dy);
       x1+=ix-ix0; y1+=iy-iy0;
       x2+=ix-ix0; y2+=iy-iy0;
       ix0=ix; iy0=iy;
       idrawbox(x1,y1+dy,x2,y2+dy);
       drawmode(JAM1);
       if(nr2>0)
	 {mycolor(128,128,128);
	  idrawbox(xa-DB+1,ya+dy,xa-1,yb+dy);
	 }
       nr2=bildnummerausposition(ix+BB/2,iy,xa,ya,xb,yb);
       if(nr2==nr || nr2==nr+1) nr2=0;
       if(nr2>0)
	 {mycolor(255,0,0);
	  idrawbox(xa-DB+1,ya+dy,xa-1,yb+dy);
	 }

      }
  }
}
void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
//void mausmot() {if(gedruecktemaustaste) mausbewegung(3);}
//test: blockieren im NURLESE-Modus:
void mausmot() {if(gedruecktemaustaste && !argflag['Q']) mausbewegung(3);}

void setautomodus()
{
 int ok;
 // if(automodus<1)
  {autopause/=60;
   automodus=1;
   ok=requester_input(2,"Wartezeit im Automodus:","%d","%d\n",&autopause,
		    "Anzahl Durchlaufen lassen aller Bilder:","%d","%d",&automodus);
   if(ok)
    {if(autopause>2) autopause-=2; //Ladezeit subtrahieren
     autopause *= 60; //Anzahl Bilddurchlaeufe pro Sekunde
     if(automodus<1) automodus=1;
    }
  }
}
