/* rexifsort.cc			letzte Aenderung: 28.10.2017, 11.11.2017 */
#define VERSION "Version 0.06"
/*
Uebersetzen auf Unix (Linux):
> make  ;siehe makefile

 Kurzbeschreibung: Dateien nach Datum im Exif-Header sortieren

History:
10.2.2009	Erstellung (RP)
21.2.09    0.02 Bessere Fehlermeldungen
23.1.2010  0.03	Testausdrucke bei Offset ueberlesen eingebaut,
		und fehlendes nb++ eingesetzt.
11.10.2017 0.04 Fehler in Exif::headerlesen() korrigiert (k+=2 statt k++)
23.10.2017      N80 auf 256 erheoht (wie MAXD in diasort.cc)
25.10.2017 0.05 Klasse in exifklasse.cc ausgelagert
		Tags angefuegt: TAG_PhotoMakerNote, TAG_PhotoUserComment
11.11.2017 0.06 Jetzt auch alle JFIF-Eintraege auflisten

noch zu tun:
- Anpassungen fuer den Fall dass Exif erst weiter hinten kommt
- Ev. exifdatum() auch in exifklasse.cc verschieben
  (noch unterschiedliche Versionen hier und in diasort.cc)

----------------------------------------------------------------------
Zusammenfassung des Aufbaus von JFIF (JPEG File Interchange Format)
====================================
Alle Kennungen haben die Form 0xFFXX (2 Bytes)
Die naechsten 2 Bytes ist die Laenge der Daten (inklusive diese 2 Bytes),
ausser bei SOI, EOI und SOS. Bei SOI und EOI sind keine Daten vorhanden,
und bei SOS wenn ein 0xFF in den Daten vorkommt wird daraus 0xFF00.
Eine Kennung von 0xFFD0 bis 0xFFD7 in SOS kann uebergangen werden.

0xFFD8  SOI Start Of Image

0xFFE0  APP0 Application
        5 Bytes Kennung. z.B.: JFIF

0xFFE1  APP1
        5 Bytes Kennung. z.B.: Exif
	von Pentax-Kamera:
	Ab Adresse 0x0092: "PENTAX Corporation "
	                   "PENTAX *ist D      "
	Ab Adresse 0x00CC: "*ist D      Ver 1.00   "
			   "2007:05:22 21:28:38" "PrintIM"
        von Sony-Kamera:
	Ab Adresse 0x00BE: "SONY" "DSC-W70"
	Ab Adresse 0x00DC: "2007:03:11 12:38:47" "PrintIM"

0xFFFE  Kommentar
	Text

0xFFDB  DQT Define Quantisation Table

0xFFCX  SOF Start Of Frame
	X = 1-3, 5-7, 9-11 oder 13-15

0xFFC4  DHT Define Huffman Table

0xFFDA  SOS Start Of Scan

0xFFD9  EOI End Of Image
----------------------------------------------------------------------


*/
#define REXIFDEBUG 0 //als 0, 1 oder 2 definieren

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

/************************* Vordeklarationen ***************************/
#define MAXD 256  //maximale Laenge der Dateinamen
#define MAXP 1024 //maximale Pfad-Laenge

const int N80=MAXD; //maximale Laenge der Dateinamen
void exifsort(const char *ordner);
void exifsort(int argc,char *argv[]);
void jfiflist(const char *name);
bool jfif_exif_suchen(FILE *fp);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
static int testflag=0;
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='V') testflag++;
  }
}

/*********************** Exif extrahieren *****************************/
#include "exifklasse.cc"

void exiflist(const char *name)
{
 int i,k1;
 const char *s;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {fprintf(STDERR,"rexifsort: '%s' nicht gefunden.\n",name); return;}
 if(exif.headerlesen(fp)==0)
  {
   if(testflag) printf("kein Exif-Header am Dateianfang gefunden\n");//test
   fclose(fp);
   if(argflag['J']) {jfiflist(name); return;}
   fp=fopen(name,"r");
   if(fp==NULL) {fprintf(STDERR,"exiflist: konnte '%s' nicht wieder oeffnen\n",name); return;}
   if(!jfif_exif_suchen(fp) ||
      exif.headerlesen(fp,true)==0)
     {
      if(testflag) printf("auch weiter hinten kein Exif-Header.\n");
      return;
     }
  }
 k1=exif.wordlesen(fp); //Anzahl Tags im 0.IFD
 if(testflag) fprintf(STDERR,"Anzahl Tags im 0.IFD = %d\n",k1);
 exif.tagslesen(fp,k1);
 s=exif.tagauswerten(TAG_DateTime); //identisch mit Aufnahmezeit?
 if(s!=NULL) printf("Zeitstempel: '%s'\n",s);
 s=exif.tagauswerten(TAG_Make);
 if(s!=NULL) printf("Kameraherst: '%s'\n",s);
 s=exif.tagauswerten(TAG_Model);
 if(s!=NULL) printf("  Kameratyp: '%s'\n",s);
 s=exif.tagauswerten(TAG_ExifImageOrient);
 if(s!=NULL) printf("Orientation: '%s'\n",s);
 if(argflag['L'])
   {printf("Alle 0.IFD-Tags auswerten:\n");
    exif.alletagsauswerten();
   }
 exif.tagslesen(fp); //jetzt die Tags im Exif-IFD lesen
 s=exif.tagauswerten(TAG_PhotoUserComment);
 if(s!=NULL) printf("UserComment: '%s'\n",s);
 s=exif.tagauswerten(TAG_DateOrig); //Das muesste die Aufnahmezeit sein
 if(s!=NULL) printf("Zeitstempel2: '%s'\n",s);
 s=exif.tagauswerten(TAG_DateDigi); //identisch oder kurz danach (1 Sek)
 if(s!=NULL) printf("Zeitstempel3: '%s'\n",s);
 s=exif.tagauswerten(TAG_ExifWidth);
 if(s!=NULL)
   {char s1[strlen(s)+1]; strcpy(s1,s);
    s=exif.tagauswerten(TAG_ExifHeight);
    printf("Exif-Aufloesung: %sx%s\n",s1,s);
   }
 fclose(fp);
 if(argflag['L'])
   {printf("Alle Exif-IFD-Tags auswerten:\n");
    exif.alletagsauswerten();
   }
}

char* exifdatum(const char *name)
{
 int i,k1;
 static char szeit[32];
 const char *s;
 *szeit=0;
 FILE *fp=fopen(name,"r");
 if(fp==NULL)
   {fprintf(stderr,"rexifsort: exifdatum() '%s' nicht gefunden.\n",name); return szeit;}
 if(exif.headerlesen(fp)==0) return szeit;
 k1=exif.wordlesen(fp); //Anzahl Tags im 0.IFD
 exif.tagslesen(fp,k1);
 s=exif.tagauswerten(TAG_DateTime); //identisch mit Aufnahmezeit?
 if(s!=NULL)
   {if(strlen(s)!=19) fprintf(stderr,"%s Falscher Zeitstempel: '%s'\n",name,s);
    else strcpy(szeit,s);
   }
 if(testflag>=2) exif.alletagsauswerten();//Alle 0.IFD-Tags auswerten
 exif.tagslesen(fp); //jetzt die Tags im Exif-IFD lesen
 s=exif.tagauswerten(TAG_DateOrig);
 if(s!=NULL)
   {if(strlen(s)!=19) fprintf(stderr,"%s falscher Zeitstempel2: '%s'\n",name,s);
    else if(*szeit==0) strcpy(szeit,s);
    else if((i=strcmp(s,szeit))!=0)
       {fprintf(stderr,"unterschiedlicher Zeitstempel2: '%s'\n",s);
	if(i<0) strcpy(szeit,s);//fruehere Zeit behalten
       }
   }
 s=exif.tagauswerten(TAG_DateDigi);
 if(s!=NULL)
   {if(strlen(s)!=19) fprintf(stderr,"%s falscher Zeitstempel3: '%s'\n",name,s);
    else if(*szeit==0) strcpy(szeit,s);
    else if((i=strcmp(s,szeit))!=0)
       {fprintf(stderr,"unterschiedlicher Zeitstempel3: '%s'\n",s);
	if(i<0) strcpy(szeit,s);//fruehere Zeit behalten
       }
   }
 fclose(fp);
 return szeit;
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char name[MAXP];
 int i,j,c;
 name[0]=0;
#if(REXIFDEBUG>=1)
 fprintf(STDERR,"rexifsort-%s  argc=%d\n",VERSION,argc);
#endif
 if(testflag) printf("rexifsort-%s\n",VERSION);
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(name,argv[i]);
	         //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || (j==0 && !argflag['I']))
	{printf("rexifsort  %s\n",VERSION);
	 printf("Anwendung: rexifsort [-flags] *.jpg\n");
	 printf("  Flags:  L=nur auflisten der Exif-Eintraege\n");
	 printf("          j=auch JFIF auflisten\n");
	 printf("          m=nur wenige Exif-Eintraege auflisten\n");
	 printf("          i=interaktiv nachfragen (geht noch nicht)\n");
	 //printf("          r=rekursiv Unterverzeichnisse durchsuchen\n");
	 printf("          v=mit Testausdrucken\n");
	 printf("          n=nach Nummern in Dateinamen sortieren\n");
	 exit(0);
	}
 if(argflag['L'] || argflag['M'] || argflag['J'])
   {if(*name==0)
       {printf("Dateiname:"); int n=scanf("%s",name);}
    exiflist(name);
   }
 else
   {if(j>0) exifsort(argc,argv);
    else exifsort("");
   }
 return 0;
}/* ende von main */

const int NORM=1,VERZ=2,SPEZ=3,LINK=4;//Dateitypen

class Dateiliste
{
 char name[N80],sort[N80];
public:
 int typ;
 Dateiliste *next;
 Dateiliste() {name[0]=0; typ=0; next=NULL;}
 ~Dateiliste() {if(next!=NULL) delete[] next;}
 char& operator[](int i) {return name[i];}
 bool operator<=(Dateiliste& y);
 Dateiliste* einsortieren(const char *neuername,int t,const char *so="zzz");
 Dateiliste* einsortieren(Dateiliste *neu);
};
bool Dateiliste::operator<=(Dateiliste& y)
{
 int k;
 if((k=strcmp(sort,y.sort))!=0) return (k<=0);
 return (strcmp(name,y.name)<=0);
 /* alte Variante:
 int i,c1,c2;
 for(i=0;(c1=name[i])!=0 && (c2=y[i])!=0;i++)
   {c1 &= 0xFF; c2 &= 0xFF;
    if(c1<c2) return true;
    else if(c1>c2) return false;
   }
 if(name[i]==0) return true;
 if(y[i]==0) return false;
 return true;
 */
}
Dateiliste* Dateiliste::einsortieren(const char *neuername,int t,const char *so)
{
 if(name[0]==0 && next==NULL)
   {//erster Eintrag in leere Liste
    strncpy(name,neuername,N80); name[N80-1]=0;
    strncpy(sort,so,N80); sort[N80-1]=0;
    typ=t;
    return this;
   }
 Dateiliste *neu=new Dateiliste[1];
 if(neu==NULL) {printf("Fehler: new fehlgeschlagen.\n"); return this;}
 strncpy(neu->name,neuername,N80); neu->name[N80-1]=0;
 strncpy(neu->sort,so,N80); neu->sort[N80-1]=0;
 neu->typ=t;
 return einsortieren(neu);
}
Dateiliste* Dateiliste::einsortieren(Dateiliste *neu)
{
 if((*neu) <= (*this)) {neu->next=this; return neu;}
 if(next==NULL) next=neu;
 else next=next->einsortieren(neu);
 return this;
}

const char *typ2str(int typ)
{
 const char *styp;
 static char str[40];
 switch(typ)
      {case NORM: styp="     "; break;
       case VERZ: styp="(dir)"; break;
       case LINK: styp="(lnk)"; break;
       default: sprintf(str,"(%03X)",typ); styp=str;
      }
 return styp;
}

const char *nummerextrakt(const char *s)
{
 static char str[16];
 int c,i,n,nmax=0;
 for(i=0;(c= *s)!=0;s++,i++)
   if(isdigit(c))
     {sscanf(s,"%d",&n); if(n>nmax) nmax=n;
      while(isdigit(c= *++s)) ;
      if(c==0) break;
     }
 sprintf(str,"%06d",n);
 return str;
}
const char *sortstr(const char *name)
{
 if(argflag['N']) return nummerextrakt(name);
 const char *s=exifdatum(name);
 if(strlen(s)!=19)
   {fprintf(stderr,"%s fehlerhafte Zeit:'%s'\n",name,s); s="zzz";}
 return s;
}

void exifsort(const char *ordner) //provi.
{
 char *pfadname=NULL;
 DIR *dp;
 struct dirent *dirp;
 struct stat statbuf;
 int j,typ;
 Dateiliste *liste=new Dateiliste[1];
 if(ordner==NULL || *ordner==0) ordner=".";
 pfadname=new char[strlen(ordner)+N80+2];
 dp=opendir(ordner);
 if(dp==NULL) {printf("kann Ordner '%s' nicht oeffnen.\n",ordner); return;}
 for(j=0;(dirp=readdir(dp))!=NULL;j++)
   {if(strcmp(dirp->d_name,".")==0 || strcmp(dirp->d_name,"..")==0) continue;
    sprintf(pfadname,"%s/%s",ordner,dirp->d_name);
    typ=NORM;
    if(lstat(pfadname,&statbuf) < 0) typ=SPEZ;
    else
      switch(statbuf.st_mode & S_IFMT)
	{case S_IFREG: typ=NORM; break;
	 case S_IFDIR: typ=VERZ; break;
	 case S_IFLNK: typ=LINK; break;
	 case S_IFBLK: case S_IFCHR: case S_IFIFO: case S_IFSOCK:
	 default: typ=SPEZ;
	}
    if(strcmp(ordner,".")==0)
         liste=liste->einsortieren(dirp->d_name,typ,sortstr(dirp->d_name));
    else liste=liste->einsortieren(pfadname,typ,sortstr(dirp->d_name));
    if(argflag['R'] && typ==VERZ)
      {char *neupfad=new char[strlen(ordner)+strlen(dirp->d_name)+2];
       sprintf(neupfad,"%s/%s",ordner,dirp->d_name);
       exifsort(neupfad);
       delete[] neupfad;
      }
   }
 closedir(dp);
 delete[] pfadname;
 Dateiliste *p;
 for(p=liste;p!=NULL;p=p->next)
   if(p->typ==NORM) printf("%s\n",(char*)&p[0]);
   else printf("%s  \t%s\n",(char*)&p[0],typ2str(p->typ));
 printf("%d Dateien.\n",j);
 delete[] liste;
}

void exifsort(int argc,char *argv[])
{
 Dateiliste *liste=new Dateiliste[1];
 const char *s,*name;
 if(testflag>=2) printf("exifsort(argc=%d,*argv[])\n",argc);//test
 for(int i=1;i<argc;i++)
   if(*argv[i]!='-')
     {name=argv[i];
      liste=liste->einsortieren(name,NORM,s=sortstr(name));
      if(testflag) fprintf(stderr,"%s  %s\n",name,s);//test
     }
 Dateiliste *p;
 for(p=liste;p!=NULL;p=p->next)
   if(p->typ==NORM) printf("%s\n",(char*)&p[0]);
   else printf("%s  \t%s\n",(char*)&p[0],typ2str(p->typ));
}

void jfiflist(const char *name) //alle JFIF-Eintraege auflisten
{
 int c1,c2;
 const char *s;
 FILE *fp=fopen(name,"r");
 if(fp==NULL) {printf("jfiflist: konnte '%s' nicht wieder oeffnen\n",name); return;}
 for(;(c1=getc(fp))!=EOF;)
  {
   c1 &= 0xFF;
   c2=getc(fp)&0xFF;
   //printf("c1=0x%02X c2=0x%02X\n",c1,c2);//test
   if(c1!=0xFF)
    {printf("unerwartete Start-Zeichen: 0x%02X 0x%02X\n",c1,c2); break;}
   if(c2==0xD8)
    {printf("SOI-Segment\n");}
   else
    {
     unsigned char c3,c4;
     c3=getc(fp); c4=getc(fp);
     int nbytes=(c3<<8)+c4;
     int i0=2; //schon 2 von den nbytes gelesen
     if(c2==0xE0) {printf(" APP0");}
     else if((c2&0xF0)==0xC0)
      {
       printf(" Art der Kompression: ");
       unsigned char n=c2&0x0F;
       if(n==4) printf("DHT");
       else if(n==8) printf("JPG");
       else if(n==0xC) printf("DAC");
       else printf("SOF%d",n);
      }
     else if(c2==0xDB) {printf(" DQT");}
     else if(c2==0xDD) {printf(" DRI");}
     else if(c2==0xE1)
      {
       char str[60+1]; int i;
       for(i=0;i<60 && i<nbytes-2;i++) {str[i]=getc(fp); i0++;}
       str[i]=0;
       printf(" APP1 %s",str);
      }
     else if(c2==0xEE) {printf(" APP14 z.B. Copyright");}
     else if((c2&0xF0)==0xE0) {printf(" APP%d",c2&0x0F);}
     else if(c2==0xFE) {printf(" COM Kommentare");}
     else if(c2==0xDA) {printf(" SOS");}
     else if(c2==0xD9) {printf(" EOI\n"); break;}
     else {printf(" 0x%02X unbekannt",c2);}
     printf("  %d Bytes\n",nbytes);
     if(c2==0xFE || c2==0xEE) //Kommentar oder Copyright
      {
       int c, n = nbytes>81 ? 81 : nbytes; //maximal 80 Zeichen ausgeben
       char str[n];
       for(int i=0; i<nbytes-2 && (c=getc(fp))!=EOF; i++)
	{if(i<n) str[i]=c;}
       str[n-1]=0;
       printf(" \"%s\"\n",str); //Kommentar als Text ausgeben
      }
     else if(c2==0xDA) //Spezialfall SOS
      { //hier fehlt die Laengenangabe, das naechste 0xFF also suchen:
       while(c3!=0xFF || c4==0x00 || (c4>=0xD0 && c4<=0xD7))
	{
	 int c;
	 while((c=getc(fp))!=EOF && (c3=c)!=0xFF) {}
	 if(c==EOF) break;
	 c4=getc(fp);
	}
       ungetc(c4,fp); //TODO: only one pushback is guaranteed.
       ungetc(c3,fp);
      }
     else
      {
       for(int i=i0;i<nbytes && getc(fp)!=EOF;i++) {}
      }
    }
  }
 fclose(fp);
}

bool jfif_exif_suchen(FILE *fp)
{
 int c1,c2;
 for(;(c1=getc(fp))!=EOF;)
  {
   c1 &= 0xFF;
   c2=getc(fp)&0xFF;
   //printf("c1=0x%02X c2=0x%02X\n",c1,c2);//test
   if(c1!=0xFF)
    {printf("unerwartete Start-Zeichen: 0x%02X 0x%02X\n",c1,c2); break;}
   if(c2==0xD8)
    {//printf("SOI-Segment\n");
    }
   else if(c2==0xE1)
    {
     //printf(" APP1 Exif-Daten gefunden");
     return true;
    }
   else if(c2==0xDA) {return false;}//Spezialfall SOS, so weit hinten darf kein Exif sein?
   else
    {
     unsigned char c3,c4;
     c3=getc(fp); c4=getc(fp);
     int nbytes=(c3<<8)+c4;
     for(int i=2;i<nbytes && getc(fp)!=EOF;i++) {}
    }
  }
 return false;
}
