/* exifklasse.cc	letzte Aenderung: 11.11.2017
Klasse fuer rexifsort.cc

History:
25.10.2017	Erstellung aus rexifsort 0.04 (RP)
11.11.2017      provisorische Anpassung in headerlesen() app1_schon_gefunden
                siehe neue Version 0.06 von rexifsort

*/
#ifndef EXIFKLASSE_CC
#define EXIFKLASSE_CC

//#define REXIFDEBUG 0  //als 0, 1 oder 2 definieren im aufrufenden Programm

#ifndef STDERR
#define STDERR stderr
#endif

const int MAXTAG=200,MAXPU=80000;
static char puffer[MAXPU];//provi.

#include <stdint.h>
typedef uint16_t USHORT;
typedef int32_t LONG;
typedef uint32_t ULONG;

bool ist_wahrscheinlich_ascii(char *a,int max);

class Exif
{
 unsigned char head1[16];
 bool bigendian;
 LONG nb;//Anzahl gelesene Bytes nach "Exif\0\0"
 LONG offset,zeit1,zeit2,zeit3;
 int ntags;
 int tag[MAXTAG],tagtyp[MAXTAG];
 LONG tagwert[MAXTAG],taganz[MAXTAG];
 int pufferlesen2(char *p0=NULL);
 LONG pufferlesen4(char *p0=NULL);
public:
 char szeit[32];
 Exif() {bigendian=false; ntags=0; nb=0; *szeit=0;}
 int headerlesen(FILE *fp,bool app1_schon_gefunden=false);
 int wordlesen(FILE *fp);
 LONG longlesen(FILE *fp);
 void tagslesen(FILE *fp,int n=0);
 const char *tagauswerten(int t);
 const char *einentagauswerten(int i);
 void alletagsauswerten();
};
static Exif exif;

int Exif::headerlesen(FILE *fp,bool app1_schon_gefunden) //Rueckgabe im Fehlerfall=0
{
 int c,i,j;
 ntags=0; nb=0; *szeit=0;
 if(app1_schon_gefunden)
  {
   //head2[2]=0xFF; head3[3]=0xE1; //APP1 Kennung
   for(i=4;i<16 && (c=getc(fp))!=EOF;i++)
     head1[i]=c;
   //printf("Test: head1[4] = %02X %02X %02X %02X\n",head1[4],head1[5],head1[6],head1[7]);//test
  }
 else
  {
   for(i=0;i<16 && (c=getc(fp))!=EOF;i++)
     head1[i]=c;
   if((head1[0]&0xFF)!=0xFF || (head1[1]&0xFF)!=0xD8)
    {if(REXIFDEBUG) fprintf(STDERR,"SOI fehlt\n");
     return 0;
    }
   if((head1[2]&0xFF)!=0xFF || (head1[3]&0xFF)!=0xE1)
    {for(j=0;j<100 && ((head1[2]&0xFF)!=0xFF || (head1[3]&0xFF)!=0xE1);j++)
       {for(int k=2;k<14;k+=2)  //k++ war offenbar falsch, Warnung mit neuerem Compiler
	   {head1[k]=head1[k+2]; head1[k+1]=head1[k+3];}
	head1[14]=getc(fp); head1[15]=getc(fp);
       }
     if(j==100) {if(REXIFDEBUG) fprintf(STDERR,"APP1 fehlt\n");  return 0;}
    }
  }
 const char *head2=(char*)&head1[6];
 if(strcmp(head2,"Exif")!=0)
   {if(REXIFDEBUG) fprintf(STDERR,"Exif fehlt\n"); return 0;}
 nb=4;
 if(REXIFDEBUG) fprintf(STDERR,"Exif ");
 bigendian=(head2[6]=='M');
 if(REXIFDEBUG) fprintf(STDERR,"%s\n",(bigendian)?"Big-Endian":"Little-Endian");
 if(head2[7]!=head2[6])
    fprintf(STDERR,"Fehler im TIFF-Header: Exif %s\n",&head2[6]);
 if(bigendian) c=head2[9]+(head2[8]<<8);
 else c=head2[8]+(head2[9]<<8);
 if(c!=0x2A) fprintf(STDERR,"Fehler im TIFF-Header: %s 0x%04X\n",&head2[6],c);
 LONG n1=longlesen(fp);
 if(REXIFDEBUG) fprintf(STDERR,"Offset nach dem TIFF-Header: ");//test
 for(LONG j=8;j<n1;j++)
  {int c;//test
   c=getc(fp);//Offset nach dem TIFF-Header ueberlesen
   if(REXIFDEBUG) fprintf(STDERR,"%02X ",c);//test
   nb++;
  }
 if(REXIFDEBUG) fprintf(STDERR,"\n");
 return i;
}
LONG Exif::longlesen(FILE *fp)
{
 LONG n;
 unsigned char c1,c2,c3,c4;
 c1=getc(fp); c2=getc(fp); c3=getc(fp); c4=getc(fp);
 nb+=4;
 if(bigendian)
      n=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 else n=(c4<<24)+(c3<<16)+(c2<<8)+c1;
 return n;
}
int Exif::wordlesen(FILE *fp)
{
 int n;
 unsigned char c1,c2;
 c1=getc(fp); c2=getc(fp);
 nb+=2;
 if(bigendian)
      n=(c1<<8)+c2;
 else n=(c2<<8)+c1;
 return n;
}
int Exif::pufferlesen2(char *p0)
{
 static unsigned char *p=NULL;
 int n;
 unsigned char c1,c2;
 if(p0!=NULL) p=(unsigned char*)p0;
 c1= *p++; c2= *p++;
 if(bigendian)
      n=(c1<<8)+c2;
 else n=(c2<<8)+c1;
 return n;
}
LONG Exif::pufferlesen4(char *p0)
{
 static unsigned char *p=NULL;
 LONG n;
 unsigned char c1,c2,c3,c4;
 if(p0!=NULL) p=(unsigned char*)p0;
 c1= *p++; c2= *p++;
 c3= *p++; c4= *p++;
 if(bigendian)
      n=(c1<<24)+(c2<<16)+(c3<<8)+c4;
 else n=(c4<<24)+(c3<<16)+(c2<<8)+c1;
 return n;
}

const int TYP_BYTE=1,TYP_ASCII=2,TYP_SHORT=3,TYP_LONG=4,TYP_RATIONAL=5;
const int TYP_UNDEFINED=7,TYP_SLONG=9,TYP_SRATIONAL=10;

//LONG-Tags:
const int TAG_ExifIFD=0x8769,TAG_GPSIFD=0x8825,TAG_Interop=0xA005,
  TAG_ExifWidth=0xA002,TAG_ExifHeight=0xA003,
//SHORT-Tags:
  TAG_ExifImageOrient=0x112, //Orientierung, also Rotation, 1 bis 8 mit Spiegelungen
//ASCII-Tags:
  TAG_DateTime=0x132, //Datum und Zeit in der Form "2008:11:30 08:15:00"
  TAG_DateOrig=0x9003,//Aufnahme-Datum+Zeit
  TAG_DateDigi=0x9004,//Digitalisierungs-Datum+Zeit
  TAG_Make=0x10F, //Kamera-Hersteller
  TAG_Model=0x110,//Kamera-Modell
  TAG_ImageDesc=0x10E, //Anmerkung als ASCII
  TAG_Software=0x131,TAG_Artist=0x13B,TAG_Copyr=0x8298,
  TAG_PhotoMakerNote=0x927C, //Manufacturer specific information (ASCII)
  TAG_PhotoUserComment=0x9286; //Anmerkung mit Ascii oder Unicode, beginnend mit "ASCII   " oder "UNICODE ",
                               //Bei Unicode ist wenn erstes Byte 0 dann 2.Byte gleich isolatin1 (ISO-8859)

void Exif::tagslesen(FILE *fp,int n)
{
 int i;
 bool nullterifd;
 if(REXIFDEBUG>=2) fprintf(STDERR,"tagslesen() nb=0x%X\n",nb);//test
 if(n==0)
   {n=wordlesen(fp);
    if(REXIFDEBUG) fprintf(STDERR,"Anzahl Exif-Tags n=%d\n",n);
    nb+=offset;
    nullterifd=false;
   }
 else
   nullterifd=true;
 offset=0;
 ntags=0;
 if(n>MAXTAG)
   {fprintf(STDERR,"Fehler: n=%d ist groesser MAXTAG=%d\n",n,MAXTAG); return;}
 for(i=0;i<n;i++)
   {tag[ntags]=wordlesen(fp);
    tagtyp[ntags]=wordlesen(fp);
    taganz[ntags]=longlesen(fp);
    tagwert[ntags]=longlesen(fp);
    if(REXIFDEBUG>=2) fprintf(STDERR,"tag=0x%X typ=%d anzahl=%d wert=0x%04X\n",
			      tag[ntags],tagtyp[ntags],taganz[ntags],tagwert[ntags]);
    if(nullterifd==false)
      {bool istzeiger;
       int k;
       switch(tagtyp[ntags])
	{case TYP_ASCII: case TYP_UNDEFINED:
	                 k=1; istzeiger=(taganz[ntags]>4); break;
	 case TYP_SHORT: k=2; istzeiger=(taganz[ntags]>2); break;
	 case TYP_LONG: case TYP_SLONG: k=4; istzeiger=(taganz[ntags]>1); break;
	 default: k=8; istzeiger=true; //RATIONAL oder SRATIONAL
	}
       if(istzeiger)
	 {LONG m=tagwert[ntags]+k*taganz[ntags];
	  if(m>offset) offset=m;
	 }
      }
    switch(tag[ntags])
      {case TAG_ExifIFD:
	  offset=tagwert[ntags];
	  if(REXIFDEBUG) fprintf(STDERR," ExifID-Pointer Offset=0x%X\n",offset);
	  break;
       case TAG_DateTime: zeit1=tagwert[ntags]; break;
       case TAG_DateOrig: zeit2=tagwert[ntags];	break;
       case TAG_DateDigi: zeit3=tagwert[ntags]; break;
       case TAG_Make: case TAG_Model:
	  break;
       case TAG_ImageDesc: case TAG_Software: case TAG_Artist: case TAG_Copyr:
	  break;
       case TAG_PhotoMakerNote: case TAG_PhotoUserComment:
	  break;
       default:
	 if(REXIFDEBUG>=2) fprintf(STDERR,"Unbekannter Tag: 0x%X Typ=%d\n",
			    tag[ntags],tagtyp[ntags]);
      }
    if(ntags>=MAXTAG-1) fprintf(STDERR,"zu wenig Platz fuer %d Tags\n",n);
    else ntags++;
   }
 if(nullterifd)
   {if(offset==0) {fprintf(STDERR,"fehlender ExifID-Pointer\n"); offset=2000;}
    offset -= nb;
   }
 else
   {if(offset==0) {fprintf(STDERR,"Fehler: offset==0\n"); offset=2000;}
    //else offset+=100;//test
    offset -= nb;
   }
 char *s;
 if(offset<=0) {fprintf(STDERR,"Fehler: offset zu klein\n"); offset=0;}
 if(REXIFDEBUG>=2) fprintf(STDERR,"%d Bytes einlesen\n",offset);
 if(offset>MAXPU)
   {fprintf(STDERR,"Offset=0x%X zu gross\n",offset); offset=MAXPU;}
 for(i=0,s=puffer;i<offset;i++)
   *s++ = getc(fp);
 if(REXIFDEBUG>=2) //test
   for(i=0;i<32;i++) //test
	{fprintf(STDERR,"%02X",puffer[i]);
	 if(i&1) fprintf(STDERR," ");
	 if(i%16==15) fprintf(STDERR,"\n");
	}
}
const char* Exif::tagauswerten(int t)
{
 if(REXIFDEBUG>=2) fprintf(STDERR,"Exif::tagauswerten(0x%X)  nb=0x%X\n",t,nb);//test
 int i;
 for(i=0;i<ntags && tag[i]!=t;i++) ;
 if(i==ntags) return NULL;
 return einentagauswerten(i);
}
const char* Exif::einentagauswerten(int i)
{
 static char str[256];
 LONG uk=nb;
 if(tagtyp[i]==TYP_ASCII)
   {if(taganz[i]<=4)
     {fprintf(STDERR,"taganz[i]<=4  taganz[%d]=0x%04X\n",i,taganz[i]);//test
      return (char*)&tagwert[i];
     }
    return &puffer[tagwert[i]-uk];
   }
 if(tagtyp[i]==TYP_SHORT)
   {USHORT a,b,c;
    if(REXIFDEBUG>=2)
     fprintf(STDERR,"Exif::einentagauswerten(i=%d) taganz[i]=0x%X tagwert[i]=%d\n",i,taganz[i],tagwert[i]);//test
    //if(taganz[i]==1) {a=tagwert[i]>>16; sprintf(str,"%d",a);} //warum? nur an bigendian gedacht?
    if(taganz[i]==1)
       {if(bigendian) a=tagwert[i]>>16;
        else a=tagwert[i]&0xFFFF;
	sprintf(str,"%d",a);
       }
    else if(taganz[i]==2)
       {if(bigendian) {a=tagwert[i]>>16; b=tagwert[i]&0xFFFF;}
        else          {b=tagwert[i]>>16; a=tagwert[i]&0xFFFF;}
	//sprintf(str,"%d",a); //b vergessen?
	sprintf(str,"%d %d",a,b);
       }
    else
       {a=pufferlesen2(&puffer[tagwert[i]-uk]);
	b=pufferlesen2(); c=pufferlesen2();
	if(taganz[i]==3) sprintf(str,"0x%04X 0x%04X 0x%04X",a,b,c);
	else sprintf(str,"0x%04X 0x%04X 0x%04X ...",a,b,c);
       }
    return str;
   }
 if(tagtyp[i]==TYP_LONG)
   {if(taganz[i]==1) sprintf(str,"%d",tagwert[i]);
    else {ULONG a=pufferlesen4(&puffer[tagwert[i]-uk]),
	                b=pufferlesen4();
          if(taganz[i]==2) sprintf(str,"0x%08X 0x%08X",a,b);
          else sprintf(str,"0x%08X 0x%08X ...",a,b);
         }
    return str;
   }
 if(tagtyp[i]==TYP_SLONG)
   {if(taganz[i]==1) sprintf(str,"%d",tagwert[i]);
     else {LONG a=pufferlesen4(&puffer[tagwert[i]-uk]),b=pufferlesen4();
          if(taganz[i]==2) sprintf(str,"0x%08X 0x%08X",a,b);
          else sprintf(str,"0x%08X 0x%08X ...",a,b);
         }
    return str;
   }
 if(tagtyp[i]==TYP_RATIONAL)
   {ULONG a=pufferlesen4(&puffer[tagwert[i]-uk]), b=pufferlesen4();
     sprintf(str,"%d/%d=%f",a,b,a/double(b)); return str;
   }
 if(tagtyp[i]==TYP_SRATIONAL)
   {LONG a=pufferlesen4(&puffer[tagwert[i]-uk]), b=pufferlesen4();
    sprintf(str,"%d/%d=%f",a,b,a/double(b)); return str;
   }
 if(tagtyp[i]==TYP_UNDEFINED)
   {unsigned char *a;
    if(taganz[i]<=4) sprintf(str,"0x%08X",tagwert[i]);
    else
     {a=(unsigned char*)&puffer[tagwert[i]-uk];
      if(strcmp("ASCII",(const char*)a)==0)
       { //in UserComment wird mit "ASCII\0\0\0" gestartet
	strncpy(str,(char*)&a[8],256);
	str[255]=0;
       }
      else if(strcmp("UNICODE",(const char*)a)==0)
       { //in UserComment wird mit "UNICODE\0" gestartet
	sprintf(str,"a[8]=%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X ...",//test
		a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15],a[16],a[17]);//test
	char *s=str;
	for(int i=8;i<8+2*254;i+=2)
	 {//if(a[i]!=0) Sonderzeichen;
	  if(a[i+1]<' ') break;
	  *s++ = a[i+1];
	 }
	*s=0;
       }
      else if(ist_wahrscheinlich_ascii((char*)a,taganz[i]))
       {
	strncpy(str,(char*)a,256); //wie sprintf(str,"%s",a) aber mit Begrenzung
	str[255]=0;
       }
      else
       {
	if(taganz[i]==5)
	 sprintf(str,"%02X %02X %02X %02X %02X",a[0],a[1],a[2],a[3],a[4]);
	else
	 sprintf(str,"%02X %02X %02X %02X %02X %02X %02X %02X %02X %02X ...",
		      a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9]);
	if(REXIFDEBUG) fprintf(STDERR,"TYP_UNDEFINED: als Text: \"%s\"\n",a);//test
       }
     }
    return str;}
 fprintf(STDERR,"unbekannter tagtyp=%d\n",tagtyp[i]);
 return NULL;
}
void Exif::alletagsauswerten()
{
 const char *s;
 for(int i=0;i<ntags;i++)
   {s=einentagauswerten(i);
    printf("Tag=0x%04X Typ=%d '%s'\n",tag[i],tagtyp[i],s);
   }
}

bool ist_wahrscheinlich_ascii(char *a,int max)
{
 int n=0,i;
 for(i=0;i<4 && i<max;i++)
  if(a[i]>=' ' && a[i]<='z') n++;
 return (n >= i-1);
}

#endif //EXIFKLASSE_CC
