/* xtekplot1.h		letzte Aenderung: 23.10.2017 */
/*
letzte Aenderungen:
9.6.2007
12.12.2008      An einigen Stellen "const char *" statt "char *"
                (vorher gabs noch keine "const" in dieser Datei)
27.1.2010	Unterstuetzung von Umlauten: utf8_to_isolatin1()
                ischrift_utf8(), schrift_utf8(), janeinrequester_utf8()
23.1.2012	set_tektitel(const char*)
23.2.2012	In c-Version von nachfilenamefragen() Typ fuer filter korrigiert
20.4.2015	SCROLL_UP und SCROLL_DOWN angefuegt fuer Mausrad
23.10.2017	Anpassung fuer laengere Dateinamen (Version 2.96)

*/
#ifndef XTEKPLOT1_H
#define XTEKPLOT1_H
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#ifndef ULONG_H
#ifdef VAX
#include "h:ulong.h"
#else
#include <ulong.h>
#endif
#endif
#ifdef __cplusplus
extern "C" {
#endif
struct descr {short n,pad; const char *s;};

#ifndef COMPILINGXTEKPLOT
#define inital(x1,y1,x2,y2) qinital(1,x1,y1,x2,y2)
#define plot q2plot
#define tekgrein tek_grein
extern int tekplot_breite,tekplot_hoehe,tekplot_tiefe;
extern int tek_mausx,tek_mausy,maustasten_zustand;
extern FILE *tekplot_fpbild;

//extern char *tekplot_fenstername;//wird nur noch in showit verwendet.
//  in neuen Programmen nur noch set_tektitel() benutzen!

//#define setenv Setenv
//#define getenv Getenv
#endif
/* speziell fuer Fortran: */
void line(short* n,float* xf,float* yf);
void grein(float* x,float* y);
void pen(char* x);

/* allgemeine Funktionen: */
void qinital(int,double,double,double,double);
void q2plot(double,double,int);
void term_exit();
void term_refresh();
void term();
void getmaxsize(int*,int*,int*,int*);
void setsize(int,int,int);
void color(int);
void rgbcolor(int r,int g,int b);
void setcolor(int farbnr,int r,int g,int b);
void getcolor(int farbnr,int *r,int *g,int *b);/*nur zu testzwecken*/
void qpunkt(float* x,float* y);
void tek_line(int n,double* xf,double* yf);
void tek_grein(double* x,double* y);
void qgrein(float* x,float* y);
void qgclear();
void q2esc(char* str);
void plotsave(const char* x);
void tek_pen(const char* x);
void iplotline(int x1,int y1,int x2,int y2,int farbe);
#define UP 3
#define DOWN 2
#define PENUP 3
#define PENDOWN 2
void ipunkt(int x,int y,int farbe);
void ipunkte(void* p,int n,int farbe);
void imausklick(int taste,int *x,int *y);
void mausklick(int taste,double *x,double *y);
int mausposition(double *x,double *y);
int imausposition(int *x,int *y);
int maustasten();
void Delay(int sec50tel);
#define LIMAUS		0x040 /* auf linke Maustaste warten */
#define REMAUS		0x400 /* auf rechte Maustaste warten */
#define MIMAUS		0x100 /* mittlere Maustaste */
#define SCROLL_UP      	0x800 /* Mausrad rauf */
#define SCROLL_DOWN    0x1000 /* Mausrad runter */
#define MAUSMASKE	0x540 /* provisorisch: bisher nur 2 unterstuetzt */
#define MAUSUP		0x001 /* auf Loslassen der Maustaste warten */
#define MAUSDOWN	0x002 /* auf Drcken der Maustaste warten */
#define MAUSUDMASKE	0x003
void iviereck(int x1,int y1,int x2,int y2,int farbe);
void drawmode(int mode);
#define JAM1 1
#define JAM2 2
#define COMPLEMENT 3
#define INVERSEVID 4
void setxsync(int mode);
#ifdef __cplusplus
void screenclear(int farbe= -1);
#else
void screenclear(int farbe);
#endif
void show_total();
void iplot(int,int,int);
void iline(int,int*,int*);
void idrawcircle(int,int,int,int);
void ifillcircle(int,int,int,int);
void idrawbox(int x1,int y1,int x2,int y2);
void ifillbox(int x1,int y1,int x2,int y2);
void drawcircle(double,double,double,double);
void fillcircle(double,double,double,double);
void drawbox(double x1,double y1,double x2,double y2);
void fillbox(double x1,double y1,double x2,double y2);
void moveto(int,int);
void lineto(int,int);
void waitTOF(),waitBOF();
void koordpix2user(int i,int j,double* x,double* y);
void qkoorduser2pix(double x,double y,int *i,int *j);
void koorduser2pix(double x,double y,int *i,int *j);
void deltakoorduser2pix(double x,double y,int *i,int *j);
void deltakoordpix2user(int i,int j,double *x,double *y);
/* xmenu.h */
#define MAXMENU 500
typedef void (*funkzeiger)(long);
typedef void (*funkzeig)(void);
void setmenu(int n,...);
void setsubmenu(int n,...);
void menu_setzen();
int waitmenu(int waitflag);
void changemenu(long idnr,const char *neuertext);
int get_menuleistenhoehe();
void menu_font_anfordern();
#define STATICGRAY      0
#define GRAYSCALE       1
#define STATICCOLOR     2
#define PSEUDOCOLOR     3
#define TRUECOLOR       4
#define DIRECTCOLOR     5
/*** neu ab TEKPLOT1.C ***/
void getsize(int*,int*,int*,int*);
void tek_setdebug(int);
#ifdef __cplusplus
int itextsize(int bx,int hy,const char *font=NULL,int style=0);
double textsize(double bx,double hy,const char *font=NULL,int style=0);
#endif
#define BOLD		1
#define ITALIC		2
#define UNDERLINE	4
void fillpolygon(int n,double *xf,double *yf);
void ifillpolygon(int n,int *xf,int *yf);
int requester_input(int,...);
double rundezahl(double,double);
void tek_punkt(double,double,int);
int keyget(int *n,int *asci,ULONG *rawcode); /* noch nicht endgltig */
#define AUTOMENU (-1)
void automenu_loop();
void tek_flush();
void setzergbtabelle(int n,UBYTE neuetabelle[][3]);
double get_tekplot_version();
double getaspect();
double getraspect();
void setaspect(double);
void setmaxfarben(int max);

#ifdef __cplusplus
void ischrift(int x,int y,const char *,double winkel=0.);
void ischrift_utf8(int x,int y,const char *str,double winkel=0.);
void schrift(double x,double y,const char *,double winkel=0.);
void schrift_utf8(double x,double y,const char *,double winkel=0.);
void inital_new(double xmin=0.,double ymin=0.,double xmax=0.,double ymax=0.);
int janeinrequester(const char *text,const char *jatext=NULL,const char *neintext=NULL);
int janeinrequester_utf8(const char *text,const char *jatext=NULL,const char *neintext=NULL);
void getmenuids(long idnr,long *idfeld,int max=0);
void set_funktions(funkzeig pre,funkzeig rel=NULL,
			funkzeig exp=NULL,funkzeig mot=NULL);
#define MAX_DATEINAME_LAENGE 256
#define MAX_PFADNAME_LAENGE 1024
int nachfilenamefragen(const char *str,char *name,int max,int flgs=0,
	char *filter=NULL, //hier darf kein const sein!
	const char *oktext=NULL,const char *canceltext=" CANCEL",
	const char *parenttext=" Parent",const char *diskstext="  Disks",
	int nfilt=0);
void splitpfad(const char *name,char *pfad,char *file,int max,int max2=0);
char *joinpfad(const char *pfad,const char *file,char *name=NULL,int max=0);
void fullscreen_modus(int modus=1);
int menu_switch(long id,long *ids,int k,int max,char **text,int k1=0,int k2=0);

/* neue Funktionen fuer c++ hier einfuegen */
}
#else /* ohne c++ */
void ischrift(),schrift(), inital_new();
void ischrift_utf8(),schrift_utf8();
int itextsize(),textsize(), janeinrequester(), janeinrequester_utf8();
void getmenuids(long,long*,int);
void set_funktions(funkzeig pre,funkzeig rel,funkzeig exp,funkzeig mot);
int nachfilenamefragen(const char *str,const char *name,int max,int flgs,
		char *filter, //hier darf kein const sein!
		const char *ok,const char *canc,
		const char *pa,const char *disks,int nfilt);
void splitpfad(const char *name,char *pfad,char *file,int max,int max2);
char *joinpfad(const char *pfad,const char *file,char *name,int max);
void fullscreen_modus(int modus);
int menu_switch(long id,long *ids,int k,int max,char **text,int k1,int k2);

/* neue Funktionen fuer c (ohne ++) hier einfuegen */
#endif

void Setenv(const char *name,const char *inhalt);
char *Getenv(const char *name);
void set_tektitel(const char*);
int changebuffer(int,int);
void bpencolor(int farbnr);
void rgbbpencolor(int r,int g,int b);
void utf8_to_isolatin1(char *ziel,const char *von,int max);
XImage *tek_xcreateimage(int xmax,int ymax);
void tek_xputimage(XImage *image,int x0,int y0,int ix0,int iy0,int xmax,int ymax);

/* neue Funktionen, die fuer c und fuer c++ gleich sind, hier einfuegen */

#ifdef USE_INTERNAS
extern Window tekplot_win;
extern Display *tekplot_dpy;
extern Screen *tekplot_screen;
extern GC tekplot_gc;
extern Drawable tekplot_rambild;
extern XEvent tekplot_event;
extern int tekplot_rambildflag,tekplot_refreshflag,tekplot_initalflag,
		tekplot_iffflag,tekplot_postflag;
extern int tekplot_vordergrundfarbe,tekplot_hintergrundfarbe;
extern char *tekplot_bildname, *tekplot_bildname_default;
extern double tekplot_xmin,tekplot_ymin,tekplot_xmax,tekplot_ymax,
		tekplot_xs,tekplot_ys,tekplot_dx,tekplot_dy;
#endif

#define SPRACHE_DEUTSCH 1
#define SPRACHE_ENGLISH 2

/* Taste um Menu ein/aus zu schalten: ALT */
#define MENUTASTE 0xFFE9
#define TABTASTE  0xFF09
#define SHIFTTASTE 0xFFE1
/* Spezialtaste fuer schnelle Menu-Anwahl ueber Tastatur: ESC */
#define AMIGATASTE 0xFF1B

#endif /* XTEKPLOT1_H */
