/* EPS.c				letzte Aenderung: 5.6.2012 */
#define VERSION "1.9"
/* Ausdrucken eines POSTSCRIPT-EPS-Bildes auf Standard-Drucker (OptraSe3455)
   oder Farb-Drucker (Phaser740)

Uebersetzen:
;AVAX> cx eps
;AVAX> blink eps
;AMIGA> gcc eps.c -o eps
;UNIX> gcc -Dunix eps.c -o eps

Autor: Rolf Pfister

Austesten: mit SKALA.PS

History:
7.6.1994 Version 1.4	VAX/ALPHA
10.4.95		 1.5	Anpassung an AMIGA und Einfuegen der Option L
			(fuer mehrseitige von LaTeX erzeugte Dokumente)
27.6.96		 1.6	Anpassung an UNIX (Ausdruck nur auf neuem Drucker)
8.12.97		 1.7	bei BoundingBox einlesen richtig runden
26.5.98			Ausdruck auf Farbdrucker jetzt auch von HENRI aus
6.8.98		 1.8	BoundingBox wird jetzt defaultmssig gesetzt
			(dies verhindert Fehler mit ghostview)
8.6.99			Anpassung fr neuen Farbdrucker Phaser740 auf HENRI
24.3.2000		Werte fr neuen Drucker (noch nicht getestet)
6.11.2000	 1.9	Fehler bei clippath korrigiert
15.11.2000		Flag D eingebaut um neues dict zu erzeugen
4.12.2000		Anpassung an pcicompaq3000: COMPAQ
22.10.2002		Anpassung an neuen pcihenri
15.6.2007		Anpassung an neues System auf pcihenri
10.8.2010		Neuer Farbdrucker: HL-4050CDN-Brother statt hp4650
5.6.2012		Anpassung an Polaron: Druckername SW_Hamm und Color_Hamm
                        Drucken auf SW auch mit "lpr -l"
*/

//#define NEUERDRUCKER
#define VAX

#ifdef unix
#undef VAX
#define HENRI
#define HENRI_OR_COMPAQ
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
/* #include <math.h> */
#define MAXARG 1
#define FP fprintf

#ifdef AMIGA
#define XRAND 10
#define YRAND 0
#define XMAX 560
#define YMAX 780  /* Hardwareabhaengig !  Werte fuer POST und BJC-4000 */
#else /* VAX */
#ifdef NEUERDRUCKER
#define XRAND 0
#define YRAND 0
#define XMAX 596
#define YMAX 843  /* Hardwareabhaengig !  Werte fuer neuen Drucker */
#else
#define XRAND 15
#define YRAND 20
#define XMAX 580
#define YMAX 820  /* Hardwareabhaengig !  Werte fuer VAX oder ALPHA */
#endif
#endif

int suchen(FILE *fp,char *str);
int zsuchen(FILE *fp,char *str);
int naechsteszeichen(FILE *fp);
void zweiteanwendung(FILE *fp,FILE *fp2);
void system1(char *s,char *p1);
void systempr(char *s) {printf("%s\n",s); system(s);}
int abrunden(double);
void fscanf_bbox(FILE *fp,int *xul,int *yul,int *xor,int *yor);

/*************************** globale Parameter ************************/
char name[80],nameps[80],flag['Z'+1];

void setflags(char *s)
{int c; while(c= *s++)  if((c=toupper(c))<='Z')  flag[c]=1;}

/***************************** Hauptprogramm **************************/
main(int argc,char *argv[])
{
 int i,j,xul,yul,xor,yor,x1,y1,dx,dy,c,n;
 short scriptflag=0;
 FILE *fp,*fp2;
 double sx,sy;
/* for(n=0;n<='Z';n++) flag[n]=0; */
 for(name[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-' || *argv[i]=='?') setflags(argv[i]);
   else if(j==1) {strcpy(name,argv[i]); j++;}
 if(flag['?'] || j>MAXARG+1)
	{printf("EPS  Version %s\n",VERSION);
	 printf("1.Anwendung: eps [-Flags] Name.ps\n");
	 printf("     Flags: S=Scaliere auf druckbaren Bereich\n");
	 printf("            R=Rand frei lassen\n");
	 printf("            C=ohne Clipping\n");
#ifdef HENRI_OR_COMPAQ
	 printf("            F=auf Farbdrucker (Color_Hamm)\n");
//	 printf("            F=auf Farbdrucker (HL-4050CDN-Brother)\n");
//	 printf("            F=auf Farbdrucker (hp4650)\n");
//	 printf("            F2=auf Tintenstrahl-Farbdrucker (HP-DeskJet)\n");
#else
	 printf("            F=auf Farbdrucker\n");
#endif
#ifdef VAX
	 printf("            P2=Ausdruck auf 2.Laserdrucker\n");
#endif
	 printf("            L=LaTeX-Option: kein save/restore verwenden\n");
	 printf("            D=nach save \"dict begin\" verwenden\n");
	 printf("            B=Bitte duenne Linien dicker zeichnen\n");
	 printf("            K=keine BoundingBox setzen (Ausgabe ist kein EPS)\n");
	 printf("            T=Test  N=nicht drucken\n");
	 printf("2.Anwendung: EPS [-Flags] Name.scr\n");
	 printf("  Inhalt von Name.scr:\n");
	 printf("	Name1.ps x1 y1 dx dy winkel\n");
	 printf("	Name2.ps x1 y1 dx dy winkel\n");
	 printf("	...\n");
	 exit(0);
	}
 if(name[0]==0) {printf("File:"); scanf("%s",name);}
 fp=fopen(name,"r");
 if(fp==NULL) {strcpy(nameps,name); fp=fopen(strcat(name,".ps"),"r");}
 if(fp==NULL) {strcpy(name,nameps); fp=fopen(strcat(name,".eps"),"r");}
 if(fp==NULL) {strcpy(name,nameps); fp=fopen(strcat(name,".scr"),"r");}
 if(fp==NULL) {printf("'%s' nicht gefunden\n",nameps); exit(0);}
 fp2=fopen("EPS.TMP","w");
 if(fp2==NULL) {printf("Fehler beim Oeffnen von 'EPS.TMP'\n"); exit(0);}
 if(flag['K'])
   fprintf(fp2,"%%!PS-Adobe-3.0\n%%%%Creator: EPS %s\n",VERSION);
 else /* neu ab 1.8 */
   {fprintf(fp2,"%%!PS-Adobe-3.0 EPSF-1.2\n%%%%Creator: EPS %s\n",VERSION);
    fprintf(fp2,"%%%%BoundingBox: 0 0 596 843\n");
   }
/* fprintf(fp2,"0 setgray  1 setlinewidth 0 setlinecap 0 setlinejoin\n"); */
/* fprintf(fp2,"10 setmiterlimit save\n"); */
 if(flag['B']) //provi.
   {fprintf(fp2,"/setlinewidth {\n");
    fprintf(fp2,"  dup 0.1 lt\n  {4 mul} %%sehr duenne Linien viel dicker\n");
    fprintf(fp2,"  {dup 0.5 lt {2 mul} if} %%duenne Linien etwas dicker\n");
    fprintf(fp2,"  ifelse  setlinewidth} bind def\n");
   }
 if(!flag['L'])
   {if(flag['D']) fprintf(fp2,"/neusave save def /showpage {} def\n");
    else fprintf(fp2,"save /showpage {} def\n");
   }
 c=getc(fp);ungetc(c,fp);
 if(c!='%') {zweiteanwendung(fp,fp2); fclose(fp);}
 else
  {if((n=suchen(fp,"%%BoundingBox:"))>=1)
	fscanf_bbox(fp,&xul,&yul,&xor,&yor);
   else	{xul=yul=0; xor=596; yor=843;} /* A4-Seite */
/* if(n==2 || n== -2) {fclose(fp); fp=fopen(name,"r");} */
   fclose(fp);
   if(!flag['R'] && flag['S'])
    {if(flag['L']) FP(fp2,"/epsscal {\n"); /* fuer mehrseitiges Dokument */
     FP(fp2,"clippath pathbbox 3 index 3 index translate\n");
/** Fehlerkorrektur 6.11.2000
     FP(fp2,"exch 4 1 roll exch  sub %d sub %d div 3 1 roll\n",-yul,yor-yul);
     FP(fp2,"sub %d sub %d div exch scale %d %d translate newpath\n",
				-xul,xor-xul, -xul,-yul);
-yul und -xul zuviel subtrahiert !
**/
     FP(fp2,"exch 4 1 roll exch  sub %d div 3 1 roll\n",yor-yul);
     FP(fp2,"sub %d div exch scale %d %d translate newpath\n",
				xor-xul, -xul,-yul);
     if(flag['L']) FP(fp2,"} bind def\n"); /* fuer mehrseitiges Dokument */
    }
   else
    {x1=XRAND-xul; dx=xor-xul;
     y1=YRAND-yul; dy=yor-yul;
     fprintf(fp2,"%d %d translate\n",x1,y1);
     if(flag['S'])
	{sx=((double)(XMAX-XRAND))/dx; sy=((double)(YMAX-YRAND))/dy;
	 if(sx<sy) sy=sx; else sx=sy;
	 fprintf(fp2,"%lf %lf scale\n",sx,sy);
	}
     if(!flag['C'])
	{fprintf(fp2,"newpath %d %d moveto %d %d lineto\n",xul,yul,xul,yor);
	 fprintf(fp2,"%d %d lineto %d %d lineto\n",xor,yor,xor,yul);
	 fprintf(fp2,"closepath clip newpath\n");
    }	}
   fclose(fp2);
/* while((c=getc(fp))!=EOF) putc(c,fp2); */
#ifdef VAX
   system1("append %s EPS.TMP",name);
#else
#ifdef unix
   system1("cat >epsappend.TMP EPS.TMP %s",name);
/*   system("mv epsappend.TMP EPS.TMP");*/
   system("cp epsappend.TMP EPS.TMP");
   system("rm epsappend.TMP");
#else
   system1("join EPS.TMP %s TO RAM:epsappend.tmp",name);
   system("copy RAM:epsappend.tmp EPS.TMP");
#endif
#endif
   fp2=fopen("EPS.TMP","a");
   if(fp2==NULL) printf("Fehler beim Oeffnen:fopen('EPS.TMP','a')\n");
  }
 if(!flag['L'])
   {if(flag['D']) fprintf(fp2,"neusave restore showpage\n");
    else fprintf(fp2,"restore showpage\n");
   }
/* nicht mehr machen, da andere angeschlossene Computer gestrt werden:
/* if(flag['F'] && !flag['N']) /* Timeout unterdrcken, das spart Papier * /
/*   {fprintf(fp2,"/mydict currentsystemparams def\n");
/*    fprintf(fp2,"mydict /WaitTimeout 1728000 put mydict setsystemparams\n");
/*   }
/* :nicht mehr */
 fclose(fp2);
 if(flag['L']) /* fuer mehrseitiges Dokument */
	system("ersatz \"/bop{userdict\" \"/bop{epsscal userdict\" EPS.TMP");
#ifdef AMIGA
 if(!flag['N'])
		{systempr("POST POST:INIT.PS EPS.TMP");
		 if(!flag['T']) system("delete EPS.TMP");
		}
#else
#ifdef unix
 if(!flag['N'])
   {if(flag['F'])
		{
#ifdef COMPAQ
		  systempr("lpr -l -Pcol EPS.TMP");
#else
#ifdef HENRI
//		 if(flag['2']) systempr("lpr -l -Pdeskjet EPS.TMP");
//		 else
		  //systempr("lpr -l -Php4650 EPS.TMP");
		  //systempr("lpr -l -PHL-4050CDN-Brother EPS.TMP");
		  systempr("lpr -l -PColor_Hamm EPS.TMP");
#else
		 systempr("lpr -l EPS.TMP");
		 printf("kein Farbdrucker gefunden\n");
#endif /*HENRI*/
#endif /*COMPAQ*/
		 if(!flag['T']) system("rm EPS.TMP");
		}
    else
		{systempr("lpr -l EPS.TMP");
		 if(!flag['T']) system("rm EPS.TMP");
		}
   }
#else /* VAX */
 if(flag['L']) system("PUR EPS.TMP");
 if(flag['F'] && !flag['N'])
		{if(!flag['T']) systempr("PSCOLOR/DEL EPS.TMP");
		 else systempr("PSCOLOR EPS.TMP");
		}
 else if(flag['P'] && flag['2'] && !flag['N'])
		{if(!flag['T']) systempr("LASER/DEL EPS.TMP");
		 else systempr("LASER EPS.TMP");
		}
 else if(!flag['N'])
		{if(!flag['T']) systempr("PSLASER/DEL EPS.TMP");
		 else systempr("PSLASER EPS.TMP");
		}
#endif
#endif
 return 0;
}/* ende von main */

void system1(char *s,char *p1)
{
 char str[80];
 sprintf(str,s,p1); system(str);
}

int suchen(FILE *fp,char *str)
{
 int c,atendflag=0;
 while((c=getc(fp))!=EOF)
	{if(c=='%')
		{if(zsuchen(fp,&str[1])==1)
			{if((c=naechsteszeichen(fp))=='(') atendflag=1;
			 else  return 1+atendflag;
			}
		 while((c=getc(fp))!=EOF && c!='\n')  ;
		}
	 else if(atendflag==0)
		{ungetc(c,fp); return 0;}
	}
 return -1-atendflag;
}

int zsuchen(FILE *fp,char *str)
{
 int c;
 while((c=getc(fp))!=EOF && c!='\n')
	{if(*str==0) return 1;
	 if(c!= *str++) return 0;
	}
 return 0;
}

int naechsteszeichen(FILE *fp)
{
 int c;
 while((c=getc(fp))==' ' || c=='\t')	;
 ungetc(c,fp);
 return c;
}

void zweiteanwendung(FILE *fp,FILE *fp2)
{
 int xul,yul,xor,yor,x1,y1,dx,dy,winkel,n,c;
 char name[80];
 FILE *fp1;
 if(flag['L']) fprintf(fp2,"/epsscal {\n"); /* fuer mehrseitiges Dokument */
 if(flag['S']) /* test */
    {xul=yul=0; xor=596; yor=843; /* A4-Seite */
     if(flag['R']) xul-=30; /* RAND */
     FP(fp2,"clippath pathbbox 3 index 3 index translate\n");
/** Fehlerkorrektur 6.11.2000
     FP(fp2,"exch 4 1 roll exch  sub %d sub %d div 3 1 roll\n",-yul,yor-yul);
     FP(fp2,"sub %d sub %d div exch scale %d %d translate newpath\n",
				-xul,xor-xul, -xul,-yul);
-yul und -xul zuviel subtrahiert !
**/
     FP(fp2,"exch 4 1 roll exch  sub %d div 3 1 roll\n",yor-yul);
     FP(fp2,"sub %d div exch scale %d %d translate newpath\n",
				xor-xul, -xul,-yul);
    }
 for(;;)
  {n=fscanf(fp,"%s  %d %d  %d %d  %d",name,&x1,&y1,&dx,&dy,&winkel);
   if(n!=6) break;
   if((fp1=fopen(name,"r"))==NULL)
		{printf("'%s' nicht gefunden !\n",name); continue;}
   else printf("reading '%s'\n",name);
   if((n=suchen(fp1,"%%BoundingBox:"))>=1)
	fscanf_bbox(fp1,&xul,&yul,&xor,&yor);
   else	{xul=yul=0; xor=596; yor=843; /* A4-Seite */
	 printf("%%%%BoundingBox: not found. Default: %d %d %d %d\n",
			xul,yul,xor,yor);
	}
   if(n==2 || n== -2) {fclose(fp); fp=fopen(name,"r");}
/* fprintf(fp2,"save %d %d translate\n",x1,y1);*/
/* neu18.4.95: */
   if(!flag['L'])
     {if(flag['D']) fprintf(fp2,"/neu2save save def /neudict 200 dict def neudict begin ");
      else fprintf(fp2,"save ");
     }
   fprintf(fp2,"%d %d translate\n",x1,y1);
/* :neu18.4.95 */
   fprintf(fp2,"%d rotate\n",winkel);
   fprintf(fp2,"%lf %lf scale\n",
	   dx/(double)(xor-xul), dy/(double)(yor-yul));
   fprintf(fp2,"%d %d translate\n",-xul,-yul);
   if(flag['T']) /* test */
	{printf("'%s'  xul=%d yul=%d xor=%d yor=%d\n",name,xul,yul,xor,yor);
	 printf("%d %d translate\n",x1,y1);
	 printf("%d rotate\n",winkel);
	 printf("%lf %lf scale\n",
		dx/(double)(xor-xul), dy/(double)(yor-yul));
	 printf("%d %d translate\n",-xul,-yul);
	}
   if(!flag['C'])
	{fprintf(fp2,"newpath %d %d moveto %d %d lineto\n",xul,yul,xul,yor);
	 fprintf(fp2,"%d %d lineto %d %d lineto\n",xor,yor,xor,yul);
	 fprintf(fp2,"closepath clip newpath\n");
	}
   if(flag['L']) FP(fp2,"} bind def\n"); /* fuer mehrseitiges Dokument test */
   while((c=getc(fp1))!=EOF) putc(c,fp2);
/* fprintf(fp2," restore\n");*/
/* neu18.4.95: */
   if(!flag['L'])
     {if(flag['D']) fprintf(fp2," end neu2save restore");
      else fprintf(fp2," restore");
     }
   fprintf(fp2,"\n");
/* :neu18.4.95 */
   fclose(fp1);
  }
}

int abrunden(double x)
{
 if(x<0.0) return (int)(x-0.9);
 return (int)x;
}

void fscanf_bbox(FILE *fp,int *xul,int *yul,int *xor,int *yor)
{
 double fxul,fyul,fxor,fyor;
 fscanf(fp,"%lf %lf %lf %lf",&fxul,&fyul,&fxor,&fyor);
 *xul=abrunden(fxul); *yul=abrunden(fyul); /* untere Werte abrunden */
 *xor=fxor+0.9; *yor=fyor+0.9; /* obere Werte aufrunden */
 if(*xul >= *xor) *xul = *xor - 1; /* Sicher stellen dass die unteren    */
 if(*yul >= *yor) *yul = *yor - 1; /* Werte kleiner sind als die oberen. */
}
