/* print.cc			letzte Aenderung: 13.2.2009 */
#define VERSION "Version 0.4"
/*
 Kurzbeschreibung: Text ausdrucken auf Postscript-Drucker

History:
9.12.2000	Erstellung (RP)
6.3.2001	Version 0.2  Klammernproblem behoben
9.4.2001	Fehler in getlinetab() korrigiert
2.2.2009  0.3	Neben '(' und ')' auch fuer '\' noch ein '\' davorgesetzt
12.3.09   0.4   Druckerabhaengige Einstellungen an den Anfang gesetzt,
                und noch Einstellung fuer rechten Rand eingefuegt.

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
//#include <ulong.h>
#define CASE break;case
#define DEFAULT break;default

const
/** Druckerabhaengige Einstellungen hier setzen!!! **/
//int ymax=843-75,ymin=60,xmin=30,xmax=596-30;//Voreinstellung mit grossem Rand
int ymax=843-10,ymin=50,xmin=20,xmax=596-20;//Drucker an der Uni/PCI
//int ymax=843-75,ymin=10,xmin=20,xmax=596-20; //Drucker zu Hause
/* nur eine der obigen Zeilen nicht auskommentieren. */

//dieses nicht auskommentieren:
const int s_ymax=843-75,s_ymin=60,s_xmin=30,s_xmax=596-30;//wenn Flag S gesetzt

/************************* Vordeklarationen ***************************/
void print(FILE *fp);

/*************************** kleinkram ***************************/
int umlautersatz(int c)
{
 int x;
 switch(c&0xFF)
   {case 0xE4: x=0x81; //
    CASE 0xF6: x=0x82; //
    CASE 0xFC: x=0x83; //
    CASE 0xC4: x=0x84; //
    CASE 0xD6: x=0x85; //
    CASE 0xDC: x=0x86; //
    DEFAULT: x=c;
   }
 return x;
}

int getlinetab(FILE *fp,char *s,int lim)
{
  // liest eine Textzeile oder maximal lim Zeichen
  // und ersetzt den Zeilentrenner durch 0
  // Tabulatoren werden durch Leerstellen ersetzt, so dass 
  // das nchste Zeichen auf eine durch 8 teilbare Position kommt.
 int c,pos=0;
 while(--lim>0 && (c=getc(fp))!=EOF && c!='\n')
   {if(c=='\t')
     {c=' ';
      while(pos%8!=7 && --lim>1) {*s++ = c; pos++;}
     }
    else if(c&0x80) {c=umlautersatz(c);}
    else if(c=='(' || c==')' || c=='\\')
      {if(--lim==0) {ungetc(c,fp); break;}
       *s++ = '\\';
      }
    *s++ = c;  pos++;
   }
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

static char fontname[80]="Courier", printer[80]="";
static int fontgroesse=10;

void setargflag(char *s)
{
 int c;
 do
 {c = *s++ & 0xFF;
  switch(c)
   {case 'f': case 'F': sscanf(s,"%d",&fontgroesse);
    CASE 'u': case 'U': sscanf(s,"%s",fontname);
    CASE 'p': case 'P': sscanf(s,"%s",printer);
    CASE 0:
    DEFAULT: if(c>='a' && c<='z')  c -= 'a'-'A';
             argflag[c&127]=1; c= -1;
   }
 }
 while(c== -1);
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80];
 FILE *fp1;
 int i,j,c;
 quellname[0]=0;
 if(argc<=0)
   /* es wurde von WorkBench gestartet */
   ;
 else
   /* es wurde von der Shell gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflag(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 //else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("print  %s\n",VERSION);
	 printf("Anwendung: print [-flags] name.txt\n");
	 printf("  Flags: n = nicht drucken, speichern als tmp?.ps\n");
	 printf("         f = Fontgroesse (z.b. print -f12 name.txt)\n");
	 printf("         u = Fontname Helvetica (z.b. -uHelvetica)\n");
	 printf("         P = Printer (z.b. -Plp, -Php4200, -Php4650)\n");
	 printf("         s = grosser Rand verwenden\n");
	 if(*printer==0)
	   printf("  (Voreinstellungen: -f%d -u%s)\n",fontgroesse,fontname);
	 else
	   printf("  (Voreinstellungen: -P%s -f%d -u%s)\n",
		  printer,fontgroesse,fontname);
	 exit(0);
	}
 if(*quellname==0) {printf("Textdatei:"); scanf("%s",quellname);}
 if(!(fp1=fopen(quellname,"r")))
   {printf("Datei '%s' nicht gefunden\n",quellname); exit(0);}
 print(fp1);
 fclose(fp1);
 return 0;
}/* ende von main */

static const char *kopftext=
"%%!PS-Adobe-2.0 EPSF-1.2\n\
%%%%Creator: print.cc\n\
%%%%BoundingBox: 0 0 596 843\n\
%%BeginProlog\n\
/machufont {/temp 1 index length dict def temp begin\n\
 {1 index dup /FID eq exch /Encoding eq or {pop pop} {def} ifelse} forall\n\
 /Encoding StandardEncoding 256 array copy def\n\
 Encoding 16#81 [/adieresis /odieresis /udieresis /Adieresis /Odieresis\n\
 /Udieresis /Aring] putinterval end temp definefont pop}def\n\
/uFont /%s findfont machufont\n\
%%%%EndProlog\n\
/uFont findfont %d scalefont setfont\n";

void closeprint(FILE *fp2)
{
 char str[80]; static int seite=1;
 fprintf(fp2,"showpage\n");
 fclose(fp2);
 if(argflag['N'])
   {sprintf(str,"cp tmp.ps tmp%d.ps",seite++); system(str);}
 else if(*printer==0)
   system("lpr tmp.ps");
 else
   {sprintf(str,"lpr -P%s tmp.ps",printer); system(str);}
}

void print(FILE *fp)
{
 char zeile[200];
 int zeilenabstand=fontgroesse*3/2;
 int yma,ymi,xmi,xma,nz,y;
 FILE *fp2=NULL;
 double bu;//durchschnittliche Buchstabenbreite
 if(argflag['S']) {yma=s_ymax; ymi=s_ymin; xmi=s_xmin; xma=s_xmax;}
 else {yma=ymax; ymi=ymin; xmi=xmin; xma=xmax;}
 if(fontname[0]=='H')
      bu=fontgroesse*0.556; //haengt etwas von der Schriftart ab
 else bu=fontgroesse*0.598;
 nz=int((xma-xmi)/bu)+1;
 if(nz>200) nz=200;
 y=0;//auf 0 gesetzt damit beim ersten Schlaufendurchgang alles
     //genau so gemacht wird wie bei allen neuen Seiten.
 while(getlinetab(fp,zeile,nz))
   {if((y-=zeilenabstand)<ymi)
      {if(fp2) closeprint(fp2);
       if(!(fp2=fopen("tmp.ps","w")))
	 {printf("Kann tmp.ps nicht erstellen\n"); return;}
       fprintf(fp2,kopftext,fontname,fontgroesse);
       y=yma-fontgroesse;
      }
    fprintf(fp2,"%d %d moveto\n",xmi,y);
    fprintf(fp2,"(%s) show\n",zeile);
   }
 closeprint(fp2);
 system("rm tmp.ps");
}
