/* gasber2.cc			letzte Aenderung: 18.11.2016 */
#define VERSION "Version 1.0"
/*

Kurzbeschreibung: Versuch einer Berechnung von Gaskompression
Herleitung der Formeln: Gaskompression.txt, SqHerleitung.txt

History:
18.11.2016       Erstellung (RP)
19.11.           Umrechnung von bar in Pascal und Liter in m^3 eingefuegt
                 und M in kg statt g (ist das richtig?)

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

const double kb=1.380648528e-23; //Boltzmann-Konstante in J/K
const double NL=6.022140857e23; //Avogadro-Konstante in Teilchen pro Mol
const double R=NL*kb; //Gaskonstante, 8.31446 J/mol/K

/*************************** Kleinkram ********************************/
inline double wurzel3(double x) {return pow(x,1.0/3.0);}
double sq(double x) {return x*x;} //Quadrieren

double Sq(double T,double M) //Quadratisch gemittelte Durchschnittsgeschwindigkeit
{
 return sqrt(3*R*T/M);
}

/************** Klassen und Hauptteil des Programms *******************/
inline double gleichung2(double TplusdT,double VminusdV,double P1V1overT1)
{
 return P1V1overT1 * (TplusdT)/(VminusdV);
}

inline double gleichung4(double dV,double T,double P,double Mover3R,double Nmalm)
{
 return  T + 2/(Nmalm)*P*dV*Mover3R;
}

static int Mg=4; //Molmasse in g/mol (He=4, Stickstoff=28)

double berechnung(double T1,double vol1,double vol2,double *druck,int imax)
{                //es soll von vol1 auf vol2 komprimiert werden
 double P1= *druck * 1e5; //Startdruck in Pascal
 vol1 *= 0.001; vol2 *=0.001; //Umrechnung von Liter in m^3
 double T=T1, P=P1, V=vol1; //aktuelle Werte setzen
 double N=P1*vol1/(kb*T1); //Anzahl Teilchen in unserem Gas
 double M=Mg*0.001; //Umrechnung von g/mol in kg/mol
 double m=M/NL; //Masse eines Teilchens in kg
 double Nmalm=N*m;
 printf("Nmalm=%g\n",Nmalm);//test
 printf("R=%g\n",R);//test
 double Mover3R=M/(3*R);
 double P1V1overT1=P1*vol1/T1;
 printf("M/(3*R)=%g\n",Mover3R);//test
 printf("P1*V1/T1=%g\n",P1V1overT1);//test
 printf("Sq=%g\n",Sq(T,M));//test

 int i;
 double dV=(vol1-vol2)/imax;
 printf("dV=%g\n",dV);//test
 for(i=0;i<imax;i++)
  {
   T = gleichung4(dV,T,P,Mover3R,Nmalm);
   V -= dV;
   P = gleichung2(T,V,P1V1overT1);
   //printf("T=%.1f V=%g P=%g dV=%g\n",T,V,P,dV);//test
  }

 printf("Sq=%g\n",Sq(T,M));//test
 *druck = P*1e-5; //Umrechnen von Pascal in bar
 return T;
}

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(const char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
   if(c=='M' && isdigit(*s))
    {for(Mg=0; isdigit(*s); s++) Mg=Mg*10+(*s)-'0';}
  }
}

/************************* Hauptprogramm ******************************/
int main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 int i,j=0,c;
 quellname[0]=zielname[0]=0;
 if(argc<=0)
  {/* es wurde von WorkBench (GUI, Desktop, ...) gestartet */
  }
 else
  {/* es wurde von Shell (Terminal, Konsole, ...) gestartet */
   for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
  }
 int imax=1000000; //ev. variieren um genuegend kleines dV zu erreichen
 double Temp, T1=298; //Temperatur in Kelvin
 double P1=1.0; //Druck in bar
 double vol1=1,vol2=0.1; //Volumen in Liter
 if(argflag['?'] || j>MAXARG)
	{printf("gasber2  %s\n",VERSION);
	 printf("Anwendung: gasber2 [-Flags] [V2] [T1]\n");
	 printf("    V2: Zielvolumen Voreinstellung: %f\n",vol2);
	 printf("        (Startvolumen ist immer 1.0)\n");
	 printf("    T1: Starttemperatur Voreinstellung: %f\n",T1);
	 printf(" Flags: v=verbose, also mit Testausdrucken\n");
	 printf("        i=imax variieren\n");
	 printf("        M=Molmasse setzen (z.B. M28 fuer Stickstoff)\n");
	 printf("          (voreingestellt: M%d\n",Mg);
	 exit(0);
	}
 if(j>=1) {sscanf(quellname,"%lf",&vol2);}
 if(j>=2) {sscanf(zielname,"%lf",&T1);}
 if(argflag['V'])
  {printf("Startbedingungen: T1 = %f K, P1 = %f bar, V1 = %f Liter\n",T1,P1,vol1);
  }
 int imax2=imax;
 if(argflag['I']) {imax=1000; imax2=10000000;}
 for(;imax<=imax2;imax*=10)
  {
   double druck=P1;
   if(argflag['I'] || argflag['V']) printf("\nBerechnung mit imax=%d\n",imax);
   Temp=berechnung(T1,vol1,vol2,&druck,imax);
   if(argflag['V'])
    {printf("Volumen nach der Kompression: V2 = %f Liter\n",vol2);
    }
   printf("berechnete Temperatur nach Kompression: %f K\n",Temp);
   printf("berechneter Druck nach Kompression: %f bar\n",druck);
  }

 return 0;
}// ende von main
