/* gpskarte.cc */
#define VERSION "Version 0.3"
#define LAST_UPDATE "19.9.2004"
/*
History:
1.8.2002	Erstellung (RP)
16.5.2004  0.2	Beginn Anpassung fr MacOSX:
		Proplem gpspoint1 geht nicht auf MacOSX,
		gpspoint2 scheint zu gehen, verhlt sich aber anders
12.9.2004  0.3	Anpassung an Suse9.1, gpspoint2 und etrex-vista
noch machen:
  - auch mit altem gps3 testen
  - alle Wegpunkte mit Hhe versehen
  - neue Symbole zeichnen
  - Route erstellen und uploaden
*/

//#define GPSPOINT1
#define GPSPOINT2

#include <stdio.h>
#include <stdlib.h>

#ifndef GCC_VERSION
#define GCC_VERSION (__GNUC__ * 1000 + __GNUC_MINOR__)
#endif
#if GCC_VERSION>=3000
#include <iostream>
//using namespace std;
#else
#include <stream.h>
#endif

#include <ctype.h>
#include <string.h>
#include <mathpi.h>
#include <xtekplot1.h>

#define TIEFE 8

const double GRAD=PI/180.0;
const int SCHWARZ=0,WEISS=1,ROT=2,GRUEN=3,BLAU=4,VIOLET=5,GELB=6,GRAU=7,
  TUERKIS=8,HELLGRAU=9, HELLROT=10,HELLGRUEN=11,HELLBLAU=12,HELLVIOLET=13,
  HELLGELB=14,DUNKELGRAU=15,HELLTUERKIS=16,BRAUN=17;

/**************************** Debugging *******************************/
//#define DEBUG 1
#ifdef DEBUG
 const int ZMAX=1000000;
class Speicher
{
 void* zeiger[ZMAX]; int j,j2;
public:
 Speicher() {j=0; j2=1; for(int i=0;i<ZMAX;i++) zeiger[i]=NULL;}
 void* mynew(int size,int n)
  {if(j==ZMAX) {printf("zu wenig Zeiger vorhanden\n"); return NULL;}
   if(j2<ZMAX) zeiger[j2++]=zeiger[j]; else j2=j+2;
   zeiger[j]=new char[size*n];
   if(zeiger[j]==NULL) {printf("zuwenig Speicher vorhanden\n"); return NULL;}
   for(int i=j+1;i<j2;i++)
     {if(zeiger[i]==zeiger[j])
       {if(j2>j+1) zeiger[i]=zeiger[--j2]; else zeiger[i]=NULL;}
     }
   //printf("mynew-->%ld\n",zeiger[j]);//test
   return zeiger[j++];
  }
 void mydelete(void* x,char *text)
  {int i,k;
   static int err=0;
   //printf("mydelete(%ld,'%s')\n",x,text);//test
   if(j==0)
     {printf("mydelete(%ld) es wurde schon alles freigegeben\n",x); return;}
   for(i=k=0;i<j;i++)
     {if(zeiger[i]==x)
       {delete (char*)x; if(j2<ZMAX) zeiger[j2++]=zeiger[i];
        zeiger[i]=zeiger[--j]; k=1; break;
       }
     }
   if(k==0)
     {for(i=j;i<j2;i++)
       {if(zeiger[i]==x)
	 {printf("%s mydelete(%ld) Zeiger schon freigegeben\n",text,x);
	  k=1; break;
	 }
       }
      if(k==0) printf("%s mydelete(%ld) Zeiger nicht in der Liste\n",text,x);
      if(++err==3) exit(0);
     }
  }
};
static Speicher mem;
#endif /* DEBUG */

/************************* Vordeklarationen ***************************/
void zeichnepunkt(double x,double y,int sym);
void anschreiben(double x,double y,char *text);
void mauspre();
void mausrel();
void mausmot();
void projektion(double x,double y,double *px,double *py);
void projektion2(double x,double y,double *px,double *py,bool flag=false);
void default_load();
void reversprojektion(double x,double y,double *px,double *py);
void aktpos_erneuern();
void aktpos_zeichnen(double x,double y);
bool istsichtbar(double x,double y);
void zoomshift(int richtung);
void tracksaufteilen(char *name);
void routenaufteilen(char *name);
int dateifilter(char *von,char *ziel,char *start,char *end,char *einsetzen);

//inline double abs(double x) {return x<0.0 ? -x : x;}

/*************************** kleinkram ***************************/
void stradd(const char *s,const char *t,char *z);	/*  s + t --> z */
double sq(double x) {return x*x;}	/* Quadrieren */
void minmaxpunkt(double x,double y,double& x1,double& x2,double& y1,double& y2)
{
 double x0,y0;
 projektion(x,y,&x0,&y0);
 if(x0<x1) x1=x0; else if(x0>x2) x2=x0;
 if(y0<y1) y1=y0; else if(y0>y2) y2=y0;
}

void system2(char *s,char *p1,char *p2=NULL)
{
 char str[200];
 sprintf(str,s,p1,p2); system(str);
}
void system5(char *s,int c,double x1,double x2,double y1,double y2,char*t=NULL)
{
 char str[200];
 sprintf(str,s,c,x1,x2,y1,y2,t);
 printf("system(\"%s\")\n",str);//test
 system(str);
}

bool getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n' && c!='\r')
	*s++ = c;
 *s='\0';
 return (c!=EOF);	/* TRUE wenn erfolgreich, FALSE wenn Fileende */
}

char *strkopie(char *s1)
{
 char *s=new char[strlen(s1)+1], *t;
 if(s==NULL) printf("zu wenig Speicher in strkopie('%s')\n",s1);//test
 for(t=s;*t++ = *s1++;)  ;
 return s;
}

void fehler(char *cstr,void *p1=NULL)
{
 char str[200];
 sprintf(str,cstr,p1);
 janeinrequester(str);
}

int index(char *s1,char *s2) /* Sucht den String s2 innerhalb von s1 und  */
{			     /* gibt Position zurueck (nicht gefunden: -1)*/
 int i,c;
 char *p1,*p2;
 if(*s2==0) return 0;   /* leerer String ist immer enthalten */
 for(i=0;;i++)
	{if((c= *s1++)==0) return -1; /* nicht gefunden */
	 if(c== *s2)
		{for(p1=s1,p2=s2; c= *++p2;)
			if(*p1++!=c) break; /* noch nicht gefunden */
		 if(c==0) break; /* gefunden */
		}
	}
 return i;
}

bool fehlerin(char *name)
{
 char zeile[160];
 bool r=false;
 FILE *fp=fopen(name,"r"); if(fp==NULL) return r;
 while(getline(fp,zeile,160))
   {if(index(zeile,"error")>=0 || index(zeile,"Error")>=0) r=true;}
 fclose(fp);
 return r;
}

int janeinrequester2(char *text,int n,char *s1,char *s2)
{
 char str[200]; sprintf(str,text,n,s1,s2);
 return janeinrequester(str);
}

void stringlesen(char *str,char *s)
{
 int c,c0='"';
 while(*s != c0) if(*s==0) return; else s++;
 while((c= *++s)!=0 && c!=c0)
     *str++ = c;
 *str=0;
}

/************************* Globale Variablen **************************/
static double xmin= -1.33, ymin= -1.0, xmax=1.33,ymax=1.0, dx=(xmax-xmin)/200;
static double mittex=8.5,mittey=47.5,faktor=1.0; //Zoomwerte
const double R2pi=4e9; //Erdumfang in cm
const int SIMPEL=0,TANGENT=1,ZYLINDER=2,PETERS=3;
static int proj_methode=SIMPEL;
static char c_riv[5][20],c_bord[5][20];
static char *tmpdat="tmp.dat";

static int autoaktpos=0;
static double aktposx=0,aktposy=0,aktposx1=0,aktposy1=0,aktposx2=0,aktposy2=0;

static double cosbeta0,sinbeta0,tanbeta0;

inline int sichtbar(double x,double y)
{
 return (x>=xmin && x<=xmax && y>=ymin && y<=ymax);
}

class Parameter
{
public:
 double bbreit,bhoch; //BildBreite und Hhe in cm
 long mass; //Kartenmassstab z.B. 1:50000
 Parameter() {bbreit=32; bhoch=24; mass=100000; calc(); setpos();}
 void calc()
  {xmax=bbreit/2; xmin= -xmax;
   ymax=bhoch/2; ymin= -ymax;
   dx=(xmax-xmin)/200;
   faktor=R2pi/360/mass;
  }
 void setpos()
  {double b=mittey*GRAD;
   cosbeta0=cos(b); sinbeta0=sin(b); tanbeta0=tan(b);
   if(cosbeta0==0) cosbeta0=1e-6;
  }
 void setmass() {mass=long(R2pi/360/faktor+0.5);}
 void getbrho(double *b,double *h)
  {double x,y; reversprojektion(bbreit/2,bhoch/2,&x,&y);
   *b=x-mittex; *h=y-mittey;
  }
};
static Parameter para;

/****************************** Klassen *******************************/
typedef char *string;

struct Zoom {double fa,xx,yy; Zoom *next;};
class Zoomhist
{
 Zoom *next,*p;
public:
 Zoomhist() {next=NULL;}
 ~Zoomhist() {while((p=next)!=NULL) {next=p->next; delete p;}}
 void put(double f,double x,double y)
  {p=new Zoom[1]; p->fa=f; p->xx=x; p->yy=y; p->next=next; next=p;}
 void pop(double *f,double *x,double *y)
   {p=next; *f=p->fa; *x=p->xx; *y=p->yy;
    if(p->next!=NULL) {next=p->next; delete p;}
   }
};
static Zoomhist zoomhist;

const WORD SYMB_DOT=0,SYMB_TOW=1,SYMB_TOWER=2,SYMB_SCITY=3,SYMB_MCITY=4,
  SYMB_LCITY=5,SYMB_SWIM=6,SYMB_GLID=7,SYMB_HOUS=8,SYMB_AIRPORT=9,SYMB_DAM=10,
  SYMB_ULTRA=11, SYMB_LODG=12, SYMB_KREUZ=13, SYMB_TIER=14, SYMB_PARK=15,
  SYMB_BALL=16, SYMB_DOLLAR=17, SYMB_POST=18, SYMB_GEOCACHE=19,
  SYMB_GEOCACHEFOUND=20,
  SYMB_MAX=21;
char *symb_namen[SYMB_MAX]={
  "wpt_dot","short_tower","tall_tower","sml_cty","med_cty",
  "lrg_cty","swimming","glider","house","airport","dam",
  "ultralight","lodging","1st_aid","deer","park",
  "ball","dollar","post_ofc","geocache","geocache_found"};
WORD symb(char *s)
{
 if(s==NULL) return 0;
 for(WORD j=0;j<SYMB_MAX;j++) {if(strcmp(s,symb_namen[j])==0) return j;}
 //printf("Unbekanntes Symbol: '%s'\n",s);//test  
 return 0;
}
const int U=PENUP,D=PENDOWN;
struct xypen {double x,y; int pen;};
static xypen icon_dot[]=
 {-0.15,-0.15,U, -0.15,0.15,D, 0.15,0.15,D, 0.15,-0.15,D, -0.15,-0.15,D,
  -0.15,-0.15,U, 0.15,0.15,D, -0.15,0.15,U, 0.15,-0.15,D, 0,0,0};
static xypen icon_tow[]=
 {-0.2,-0.2,U, 0,0.05,D, 0.2,-0.2,D, -0.02,-0.1,U, 0.02,-0.1,D, 0,0,0};
static xypen icon_tower[]=
 {-0.2,-0.2,U, 0,0.05,D, 0.2,-0.2,D, -0.02,-0.1,U, 0.02,-0.1,D, 0,0.05,U,
  0,0.4,D, -0.05,0.05,U, 0.05,0.05,D, 0,0,0};
static xypen icon_scity[]=
 {-0.06,-0.06,U, -0.06,0.06,D, 0.06,0.06,D, 0.06,-0.06,D, -0.06,-0.06,D,0,0,0};
static xypen icon_mcity[]=
 {-0.08,-0.15,U, -0.15,-0.08,D, -0.15,0.08,D, -0.08,0.15,D, 0.08,0.15,D,
  0.15,0.08,D, 0.15,-0.08,D, 0.08,-0.15,D, -0.08,-0.15,D, 0,0,0};
static xypen icon_lcity[]=
 {-0.12,-0.25,U, -0.25,-0.12,D, -0.25,0.12,D, -0.12,0.25,D, 0.12,0.25,D,
  0.25,0.12,D, 0.25,-0.12,D, 0.12,-0.25,D, -0.12,-0.25,D, 0,0,0};
static xypen icon_swim[]=
{-0.3,-0.2,U, -0.2,-0.1,D, -0.1,-0.2,D, 0,-0.1,D, 0.1,-0.2,D, 0.2,-0.1,D,
 0.3,-0.2,D, -0.25,-0.1,U, 0.05,-0.1,D, 0,-0.05,D, -0.1,-0.025,D, -0.2,-0.05,D,
 -0.25,-0.1,D, -0.22,-0.08,U, 0.02,-0.08,D, -0.2,-0.06,U, 0,-0.06,D,
 0.05,0,U, 0.1,0,D, 0.1,0.05,D, 0.05,0.05,D, 0.05,0,D,
 0.06,0.01,U, 0.09,0.01,D, 0.09,0.04,D, 0.06,0.04,D, 0.06,0.01,D,
 -0.05,-0.05,U, -0.1,0.05,D, -0.2,0.05,D, -0.25,0,D, 0,0,0};
static xypen icon_glid[]=
 {0.2,-0.15,U, -0.2,0.17,D, -0.2,0.22,D, -0.2,0.17,U, -0.23,0.12,D,
  -0.25,-0.15,U, -0.2,-0.15,D, 0,0,D, 0.15,0.2,D,0.15,0.25,D, 0,0,0};
static xypen icon_hous[]=
 {-0.2,0.05,U, -0.2,-0.2,D, 0.2,-0.2,D, 0.2,0.05,D, -0.25,0.05,U, 0.25,0.05,D,
  0.15,0.2,D, -0.15,0.2,D, -0.25,0.05,D, 0.1,0.2,U, 0.1,0.27,D, 0.05,0.27,D,
  0.05,0.2,D, -0.1,-0.1,U, -0.1,-0.04,D,-0.04,-0.04,D,-0.04,-0.1,D,-0.1,-0.1,D,
  0.05,-0.2,U, 0.05,-0.04,D, 0.15,-0.04,D, 0.15,-0.2,D,  0,0,0};
static xypen icon_airport[]=
 {-0.05,-0.25,U, 0.05,-0.25,D, 0,-0.25,U, 0,0.2,D, -0.2,-0.1,U, 0.2,-0.1,D,
  0,0,D, -0.2,-0.1,D,
 -0.13,-0.067,U, 0.13,-0.067,D, -0.067,-0.033,U, 0.067,-0.033,D, 0,0,0};
static xypen icon_dam[]=
 {-0.05,-0.2,U, -0.05,0.1,D, 0.05,0.1,D, 0.05,-0.2,D, -0.05,-0.2,D,
  -0.02,-0.2,U, -0.02,0.1,D, 0.02,-0.2,U, 0.02,0.1,D,
  -0.25,0.05,U, -0.2,0.1,D, -0.15,0.05,D, -0.1,0.1,D, -0.05,0.05,D,
  -0.25,-0.075,U, -0.2,-0.025,D, -0.15,-0.075,D, -0.1,-0.025,D, -0.05,-0.075,D,
  -0.25,-0.2,U, -0.2,-0.15,D, -0.15,-0.2,D, -0.1,-0.15,D, -0.05,-0.2,D,
  0.05,-0.2,U, 0.1,-0.15,D, 0.15,-0.2,D, 0.2,-0.15,D, 0.25,-0.2,D, 0,0,0};
static xypen icon_ultra[]=
 {0.05,-0.2,U, 0,0,D, -0.05,-0.15,D, 0.1,-0.1,D, 0,0,D, 0.1,0.04,D, 0.17,0.1,D,
  0.2,0.2,D, 0.2,0.25,D, 0.1,0.2,D, 0.03,0.1,D, 0,0.05,D, 0,0,D, -0.1,-0.03,D,
  -0.2,-0.03,D, -0.27,0,D, -0.3,0.05,D, -0.25,0.1,D, -0.1,0.1,D, 0,0.05,D,
  -0.26,0,U, 0,0,D, 0.16,0.13,D, -0.28,0.033,U, 0,0.033,D,
  0.01,0.03,U, 0.18,0.19,D,
  -0.26,0.067,U, -0.1,0.067,D, 0.04,0.08,U, 0.14,0.19,D, 0,0,0};
static xypen icon_lodg[]=
 {-0.2,-0.2,U, -0.2,0.05,D, 0,0.2,D, 0.2,0.05,D, 0.2,-0.2,D, -0.2,-0.2,D,
  -0.125,-0.15,U, -0.125,0,D, 0.125,0,U, 0.125,-0.15,D,
  -0.125,-0.1,U, 0.125,-0.1,D, -0.125,-0.025,U, -0.05,-0.1,D, 0,0,0};
static xypen icon_kreuz[]=
 {-0.2,-0.2,U, -0.2,0.2,D, 0.2,0.2,D, 0.2,-0.2,D, -0.2,-0.2,D,
  -0.03,-0.15,U, -0.03,-0.03,D, -0.15,-0.03,D, -0.15,0.03,D,
  -0.03,0.03,D, -0.03,0.15,D, 0.03,0.15,D, 0.03,0.03,D, 0.15,0.03,D,
  0.15,-0.03,D, 0.03,-0.03,D, 0.03,-0.15,D, 0.03,-0.15,D, -0.03,-0.15,D, 0,0,0};
static xypen icon_tier[]=
 {-0.1,-0.2,U, -0.075,-0.015,D, 0.175,-0.015,D, 0.2,-0.2,D,
  0.175,-0.2,U, 0.175,-0.015,D, 0.2,0.1,D,
  -0.125,-0.2,U, -0.1,0.025,D, 0.185,0.025,D,
  -0.1,0,U, -0.125,0.13,D, -0.2,0.13,D, -0.2,0.165,D, -0.122,0.165,D,
  -0.105,0.23,D,
  -0.08,0.22,U, -0.1,0.17,D, -0.074,0.026,D, 0,0,0};
static xypen icon_park[]=
 {-0.01,-0.236,U, -0.01,-0.168,D, -0.05,-0.168,D, -0.2,-0.2,D, -0.1,-0.058,D,
  -0.18,-0.058,D, -0.075,0.05,D, -0.15,0.05,D, 0,0.2,D,
  0.15,0.05,D, 0.075,0.05,D, 0.18,-0.058,D, 0.1,-0.058,D, 0.2,-0.2,D,
  0.05,-0.168,D, 0.01,-0.168,D, 0,0,0};
static xypen icon_ball[]=
 {0.1,-0.2,U, -0.1,-0.2,D, -0.2,-0.1,D, -0.2,0.1,D, -0.1,0.2,D, 0.1,0.2,D,
  0.2,0.1,D, 0.2,-0.1,D, 0.1,-0.2,D,
  0,-0.2,U, 0,-0.15,D, 0.05,-0.05,D, 0.15,0,D, 0.2,0,D,
  -0.2,0,U, -0.15,0,D, -0.05,0.05,D, 0,0.15,D, 0,0.2,D, 0,0,0};
static xypen icon_dollar[]=
 {0.157,0.098,U, 0.101,0.2,D, -0.1,0.2,D, -0.165,0.1,D, -0.099,-0.002,D,
  0.101,0,D, 0.157,-0.102,D, 0.099,-0.202,D, -0.102,-0.2,D, -0.151,-0.132,D,
  0,0.239,U, 0,-0.241,D, 0,0,0};
static xypen icon_post[]=
 {-0.19,-0.15,U, -0.19,0.15,D, 0.19,0.15,D, 0.19,-0.15,D, -0.19,-0.15,D,
  -0.19,0.13,U, 0.0,-0.05,D, 0.19,0.13,D, 0,0,0};
static xypen icon_geocache[]=
 {
  -0.2,-0.2,U, -0.2,0.048,D, 0.144,0.048,D, 0.144,-0.2,D, -0.2,-0.2,D,
  0.145,0.047,U, 0.242,0.101,D, 0.242,-0.143,D, 0.144,-0.201,D,
  0.144,0.048,U, 0.148,0.073,D, 0.161,0.096,D, 0.185,0.116,D, 0.211,0.122,D, 0.23,0.116,D, 0.242,0.102,D,
  0.209,0.121,U, -0.146,0.123,D,
  -0.2,0.048,U, -0.198,0.074,D, -0.185,0.096,D, -0.163,0.115,D, -0.146,0.123,D,
  -0.058,0.0462,U, -0.0511,0.0245,D, -0.0157,0.0245,D, -0.0005,0.048,D, 0,0,0};
static xypen icon_geocachefound[]=
 {
  -0.2,-0.2,U, -0.2,0.048,D, 0.144,0.048,D, 0.144,-0.2,D, -0.2,-0.2,D,
  0.145,0.047,U, 0.242,0.101,D, 0.242,-0.143,D, 0.144,-0.201,D,
  0.242,0.102,U, 0.165,0.191,D, -0.192,0.191,D, -0.136,0.0965,D,
  -0.201,0.0479,U, -0.136,0.0991,D, 0.242,0.0999,D,
  -0.0435,0.191,U, -0.041,0.215,D, -0.00135,0.216,D, 0.0172,0.191,D, 0,0,0};

static xypen *icon[SYMB_MAX]=
  {icon_dot,icon_tow,icon_tower,icon_scity,icon_mcity,icon_lcity,icon_swim,
   icon_glid,icon_hous,icon_airport,icon_dam,icon_ultra,icon_lodg,icon_kreuz,
   icon_tier,icon_park,icon_ball,icon_dollar,icon_post,icon_geocache,
   icon_geocachefound
  };

int symbolname_input(int sym)
{
 int i,ok,neusym=sym;
 char s[80],str[80+SYMB_MAX*20],symname[80];
 sprintf(str,"Es sind folgende Symbolnamen moeglich\n\
Nummer  Name\n");
 for(i=0;i<SYMB_MAX;i++)
   {sprintf(s,"%-8d%s\n",i,symb_namen[i]); stradd(str,s,str);}
 ok=janeinrequester(str);
 if(ok)
   {sprintf(symname,"%s",symb_namen[sym]);
    ok=requester_input(1," Symbol-Name oder Nummer ","%s","%s\n",symname);
    if(ok)
      {if(isdigit(symname[0])) neusym=atoi(symname);
       else neusym=symb(symname);
      }
   }
 return neusym;
}

class Simplerpunkt
{
public:
 double x,y;
 Simplerpunkt *next;
 Simplerpunkt() {next=NULL;} 
 void set(double x1,double y1) {x=x1; y=y1;}
};

const WORD EDFLAG=1;

class Punkt
{
public:
 double x,y;
 char *name; //Wegpunktname (z.B. Ortschaft, Kurzname)
 char *comment; //Beschreibung des Punkts (z.B. Langer Name)
 WORD symbol,flags;
 Punkt *next;
 Punkt() {name=comment=NULL; next=NULL; flags=0;}
// ~Punkt() {if(name) delete name;} //sinnvoll?
 void set(double x1,double y1,char *na=NULL,char *co=NULL,int sym=0)
  {x=x1; y=y1; name=na; symbol=sym; comment=co;}
};

const WORD TYP_STRASSE=1,TYP_FLUSS=2,TYP_GRENZE=3,TYP_WANDERWEG=4,
  TYP_KUESTE=5; //Strecken
const WORD TYP_SEE=101,TYP_KONTINENT=102,TYP_INSEL=103,TYP_WALD=104,
  TYP_LICHTUNG=105,TYP_WUESTE=106,TYP_STEPPE=107,TYP_EIS=108; //Flchen

void schnittpunkt(double x,double y,double& x1,double& y1)
{
 if(x1!=x)
   {if(x1>xmax) {y1=(y1-y)/(x1-x)*(xmax-x)+y; x1=xmax;}
    else if(x1<xmin) {y1=(y1-y)/(x-x1)*(x-xmin)+y; x1=xmin;}
   }
 if(y1!=y)
   {if(y1>ymax) {x1=(x1-x)/(y1-y)*(ymax-y)+x; y1=ymax;}
    else if(y1<ymin) {x1=(x1-x)/(y-y1)*(y-ymin)+x; y1=ymin;}
   }
}

class Grenze
{
 Simplerpunkt *pu,*q;
 UWORD dateinr;
public:
 Grenze() {pu=q=NULL; dateinr=0;}
// ~Grenze() {} //sinnvoll?
// Grenze& operator=(Grenze& a)
//  {pu=a.pu; dateinr=a.dateinr; return *this;}
 void setdateinr(int nr) {dateinr=nr;}
 void put(double x,double y)
  {//printf("Grenze::put(%lf,%lf)\n",x,y);//test
   Simplerpunkt *p;
   if(pu==NULL) {pu=new Simplerpunkt[1]; p=pu;}
   else
     {for(p=pu;p->next!=NULL;p=p->next) ;
      p->next=new Simplerpunkt[1]; p=p->next;
     }
   p->set(x,y);
  }
 void startgetxy() {q=pu;}
 bool getxy(double *x,double *y)
  {if(q==NULL) return false;
   *x=q->x; *y=q->y; q=q->next; return true;
  }
 void loeschen()
  {Simplerpunkt *p;
   while(pu!=NULL) {p=pu->next; delete pu; pu=p;}
   dateinr=0;
  }
 void zeichnen()
  {double x,y,x1,y1,x2,y2; int pen=PENUP,flag;
   Simplerpunkt *p;
   for(flag=1,p=pu;p!=NULL;p=p->next,flag=0)
     {projektion2(p->x,p->y,&x,&y,flag);
      if(sichtbar(x,y))
	{if(flag==0 && pen==PENUP)
	  {schnittpunkt(x,y,x1,y1); plot(x1,y1,pen); pen=PENDOWN;}
	 plot(x,y,pen); pen=PENDOWN;
	 x2=x; y2=y;
	}
      else
	{x1=x; y1=y;
	 if(pen==PENDOWN) {schnittpunkt(x2,y2,x1,y1); plot(x1,y1,pen);}
	 pen=PENUP;
	}
     }
  }
 bool istnr(int nr) {return nr==dateinr;}
};

class Strecke
{
 Punkt *pu,*q;
 char *name; //Streckenname (z.B. Strassenname, Seename)
 WORD typ;
 UWORD dateinr;
 double hoehe; //Hhe ber Meer
 void entfernen(char *nam)
  {Punkt *p,*p0;
   for(p0=NULL,p=pu;p!=NULL;p0=p,p=p->next)
     if(strcmp(nam,p->name)==0)
       {if(p0==NULL) {p0=pu; pu=pu->next; delete p0;}
        else {p0->next=p->next; delete p;}
        return;
       }
  }
public:
 bool istvorhanden(char *nam)
  {Punkt *p;
   for(p=pu;p!=NULL;p=p->next)
     if(strcmp(nam,p->name)==0) return true;
   return false;
  }
 Strecke() {pu=q=NULL; name=NULL; typ=0; dateinr=0; hoehe=0;}
// ~Strecke() {delete pu;}  !! nicht, sonst sind auch kopierte Punkte weg !!
 void setdateinr(int nr) {dateinr=nr;}
 void put(double x,double y,char *nam=NULL,char *com=NULL,char *symbol=NULL,
	  int flgs=0)
  {static int ueberschreiben=0;
   Punkt *p;
   if(nam==NULL) ueberschreiben=0;
   else if(istvorhanden(nam))
     {char s[80]="(Name hier nicht aenderbar)",schon[80];
      int ok,ueb=ueberschreiben;
      if(ueberschreiben<2)
	{sprintf(schon,"Wegpunkt '%s' schon vorhanden",nam);
	 ok=requester_input(2,schon,"%s","%s\n",s,
	   "Ueberschreiben ? (0=nein 1=ja 2=niemals 3=immer ohne Rueckfrage)",
				"%d","%d\n",&ueb);
	 if(ok) {ueberschreiben=ueb;}
	 else {ueberschreiben=0;}
	}
      if(ueberschreiben==0 || ueberschreiben==2) return;
      entfernen(nam);
     }
   if(pu==NULL) {p=pu=new Punkt[1];}
   else
     {for(p=pu;p->next!=NULL;p=p->next) ;
      p=p->next=new Punkt[1];
     }
   p->set(x,y,nam,com,symb(symbol));
   p->flags=flgs;
  }
 bool fastleer() {return (pu==NULL || pu->next==NULL);}
 void loeschen()
  {Punkt *p;
   while(pu!=NULL) {p=pu->next; delete pu; pu=p;}
   name=NULL; typ=0; dateinr=0; hoehe=0;
  }
 void startgetxy() {q=pu;}
 bool getxy(double *x,double *y)
  {if(q==NULL) return false;
   *x=q->x; *y=q->y; q=q->next; return true;
  }
 void startgetxyn() {q=pu;}
 int getxyn(double *x,double *y,char **nam)
  {if(q==NULL) return -1;
   int sy=q->symbol;
   *x=q->x; *y=q->y; *nam=q->name; q=q->next; return sy;
  }
 void settypnamehoehe(int t,char *nam,double h) {typ=t; name=nam; hoehe=h;}
 void zeichnen()
  {double x0,y0,x,y,x1,y1,x2,y2;
   int pen=PENUP,flag;
   Punkt *p;
   if(typ>0)
     {if(typ==TYP_SEE || typ==TYP_FLUSS) color(BLAU);
      else if(typ==TYP_KUESTE) color(HELLBLAU);
      else if(typ==TYP_GRENZE) color(DUNKELGRAU);
      else if(typ==TYP_STRASSE) color(GRAU);
      else if(typ==TYP_WANDERWEG) color(ROT);
      else color(BRAUN);
     }
   for(flag=1,p=pu;p!=NULL;p=p->next,flag=0)
     {projektion2(p->x,p->y,&x,&y,flag);
      if(flag) {x0=x; y0=y;}
      if(sichtbar(x,y))
	{if(flag==0 && pen==PENUP)
	  {schnittpunkt(x,y,x1,y1); plot(x1,y1,pen); pen=PENDOWN;}
	 plot(x,y,pen); pen=PENDOWN;
	 x2=x; y2=y;
	}
      else
	{x1=x; y1=y;
	 if(pen==PENDOWN) {schnittpunkt(x2,y2,x1,y1); plot(x1,y1,pen);}
	 pen=PENUP;
	}
     }
   if(typ>100 && pen==PENDOWN)
     {plot(x0,y0,PENDOWN); //provi. Eigentlich sollte Flche gefllt werden
     }
   if(name!=NULL) schrift(x+1.5*dx,y,name);//provi.
  }
 bool istnr(int nr) {return nr==dateinr;}
 Punkt* naechster_punkt(double x,double y)
   {Punkt *p,*q=NULL; double a1=1000,a2;
    for(p=pu;p!=NULL;p=p->next)
      {a2=sq(x-p->x)+sq(y-p->y);
       if(a2<a1) {a1=a2; q=p;}
      }
    return q;
   }
 void wegpunktauswahl(int c,int nmax,char *dateiname)
  {Punkt *p;
   FILE *fp;
   if(!(fp=fopen(dateiname,"w")))
     {printf("kann '%s' nicht erstellen\n",dateiname); return;}
   fprintf(fp,"type=\"waypointlist\"\n");
   for(p=pu;p!=NULL && nmax>0;p=p->next)
     {if(c=='A' || (c=='E' && (p->flags&EDFLAG)) ||
	 (c=='S' && istsichtbar(p->x,p->y)))
       {fprintf(fp,"type=\"waypoint\" latitude=\"%lf\" longitude=\"%lf\" name=\"%s\" comment=\"%s\" symbol=\"%s\" display_option=\"symbol+name\"\n",
		p->y,p->x,p->name,p->comment,symb_namen[p->symbol]);
        --nmax;
       }
     }
   fprintf(fp,"type=\"waypointlistend\"\n");
   fclose(fp);
  }
 void wegpunkteentfernen(int c,int nmax)
  {Punkt *p,*p0;
   for(p0=NULL,p=pu;p!=NULL && nmax>0;p0=p,p=p->next)
     if(c=='A' || (c=='U' && !istsichtbar(p->x,p->y)) ||
	 (c=='S' && istsichtbar(p->x,p->y)))
       {if(p0==NULL) {p0=pu; pu=pu->next; delete p0; p0=NULL; p=pu;}
        else {p0->next=p->next; delete p; p=p0;}
        --nmax;
       }
  }
};

struct Strecken {Strecke s; Strecken *next;};
struct Grenzen {Grenze s; Grenzen *next;};
class Karte
{
 Strecke weg; //Wegpunkte
 Strecken *rou,*tra; //Routen und Tracks
 Strecken *obj; //Objekte (Flsse, Strassen, Flchen)
 Grenzen *gre,*kue; //Grenzen und Ksten
 WORD typ;
 Strecken *p; Grenzen *q;
public:
 Karte() {rou=tra=obj=NULL; gre=kue=NULL;}
 void wegpunkt(double wx,double wy,char *name,char *comment,char *sym,int flgs)
  {weg.put(wx,wy,name,comment,sym,flgs);}
 void wegpunkt(char *wx,char *wy,char *name,char *comment,char *sym)
  {weg.put(atof(wx),atof(wy),name,comment,sym);}
 void zeichnen()
  {double x,y; char *nam; Strecken *p; Grenzen *q; int sym;
   for(weg.startgetxyn();(sym=weg.getxyn(&x,&y,&nam))>=0;)
     {zeichnepunkt(x,y,sym); anschreiben(x,y,nam);}
   color(HELLROT); for(p=rou;p!=NULL;p=p->next) p->s.zeichnen();
   color(GRUEN); for(p=tra;p!=NULL;p=p->next) p->s.zeichnen();
   for(p=obj;p!=NULL;p=p->next) p->s.zeichnen();
   color(DUNKELGRAU); for(q=gre;q!=NULL;q=q->next) q->s.zeichnen();
   color(HELLBLAU); for(q=kue;q!=NULL;q=q->next) q->s.zeichnen();
   color(ROT); aktpos_zeichnen(aktposx,aktposy);
   color(0);
  }
 double autozoom() //provi.
  {double x,y,x1=xmin,x2=xmax,y1=ymin,y2=ymax,f1=1,f2;
   for(weg.startgetxy();weg.getxy(&x,&y);)  minmaxpunkt(x,y,x1,x2,y1,y2);
   if(x1<xmin) f1=x1/xmin;
   if(x2>xmax && (f2=x2/xmax)>f1) f1=f2;
   if(y1<ymin && (f2=y1/ymin)>f1) f1=f2;
   if(y2>ymax && (f2=y2/ymax)>f1) f1=f2;
   return f1;
  }
//routestart() routeput() und routefertig() in dieser Reihenfolge aufrufen.
 void routestart(char *name,int ordnr,int nr)
  {p=rou; rou=new Strecken[1]; rou->next=p; rou->s.setdateinr(nr);}
 void routeput(char *wx,char *wy)
  {rou->s.put(atof(wx),atof(wy));}
 void routefertig()
  {if(rou!=NULL && rou->s.fastleer())
    {Strecken *p=rou->next; delete rou; rou=p;}
  }
//trackstart() trackput() und trackfertig() in dieser Reihenfolge aufrufen.
 void trackstart(char *name,int ordnr,int nr)
  {p=tra; tra=new Strecken[1]; tra->next=p; tra->s.setdateinr(nr);}
 void trackput(char *wx,char *wy)
  {tra->s.put(atof(wx),atof(wy));}
 void trackfertig()
  {if(tra!=NULL && tra->s.fastleer())
    {Strecken *p=tra->next; delete tra; tra=p;}
  }
 void objektstart(char *ty,char *nam,double hoe,int nr)
  {if(strcmp(ty,"see")==0) typ=TYP_SEE;
   else if(strcmp(ty,"fluss")==0) typ=TYP_FLUSS;
   else if(strcmp(ty,"strasse")==0) typ=TYP_STRASSE;
   else if(strcmp(ty,"kontinent")==0) typ=TYP_KONTINENT;
   else if(strcmp(ty,"insel")==0) typ=TYP_INSEL;
   else if(strcmp(ty,"grenze")==0) typ=TYP_GRENZE;
   else if(strcmp(ty,"wanderweg")==0) typ=TYP_WANDERWEG;
   else if(strcmp(ty,"kueste")==0) typ=TYP_KUESTE;
   else {typ=0; printf("unbekannter Objekt-Typ='%s'\n",ty);}
   if(typ==TYP_GRENZE)
     {q=gre; gre=new Grenzen[1]; gre->next=q; gre->s.setdateinr(nr);}
   else if(typ==TYP_KUESTE)
     {q=kue; kue=new Grenzen[1]; kue->next=q; kue->s.setdateinr(nr);}
   else
     {p=obj; obj=new Strecken[1]; obj->next=p; obj->s.setdateinr(nr);
      obj->s.settypnamehoehe(typ,nam,hoe);
     }
  }
 void objekt(double x,double y)
  {if(typ==TYP_GRENZE)  gre->s.put(x,y);
   else if(typ==TYP_KUESTE) kue->s.put(x,y);
   else  obj->s.put(x,y);
  }
 void objektfertig() {}
 void objektrestart(char *t,char *n,double h,int nr)
  {objektfertig(); objektstart(t,n,h,nr);}
 void objekt_loeschen(int typ,int nr)
  {Grenzen *q1; Strecken *p1;
   if(typ==TYP_GRENZE || typ==0)
    {int n1=0,n2=0;//test
     for(q1=NULL,q=gre;q!=NULL;)
       {if(nr==0 || q->s.istnr(nr))
	 {q->s.loeschen(); n2++;
	  if(q==gre) {gre=q->next; delete q; q=gre;}
	  else {q1->next=q->next; delete q; q=q1->next;}
	 }
        else {q1=q; q=q->next; n1++;}
       }
     printf("noch %d Grenzen vorhanden, %d geloescht\n",n1,n2);//test
    }
   if(typ==TYP_KUESTE || typ==0)
    {int n1=0,n2=0;//test
     for(q1=NULL,q=kue;q!=NULL;)
       {if(nr==0 || q->s.istnr(nr))
	 {q->s.loeschen(); n2++;
	  if(q==kue) {kue=q->next; delete q; q=kue;}
	  else {q1->next=q->next; delete q; q=q1->next;}
	 }
       else {q1=q; q=q->next; n1++;}
       }
     printf("noch %d Kuestenlinien vorhanden, %d geloescht\n",n1,n2);//test
    }
   if((typ!=TYP_GRENZE && typ!=TYP_KUESTE) || typ==0)
    {int n1=0,n2=0;//test
     for(p1=NULL,p=obj;p!=NULL;)
       {if(nr==0 || obj->s.istnr(nr))
	 {obj->s.loeschen(); n2++;
	  if(p==obj) {obj=p->next; delete p; p=obj;}
	  else {p1->next=p->next; delete p; p=p1->next;}
	 }
        else {p1=p; p=p->next; n1++;}
       }
     printf("noch %d Objekte vorhanden, %d geloescht\n",n1,n2);//test
    }
  }
 void entfernen(int nr) {objekt_loeschen(0,nr);}
 Punkt* naechster_punkt(double x,double y)
  {return weg.naechster_punkt(x,y);}
 void wegpunktauswahl(int c,int nmax,char *dateiname)
  {weg.wegpunktauswahl(c,nmax,dateiname);}
 void wegpunkteentfernen(int c,int nmax)
  {weg.wegpunkteentfernen(c,nmax);}
 bool wegpunktvorhanden(char *nam) {return weg.istvorhanden(nam);}
};
static Karte karte;

void neuername_input(char *name)
{
 int ok;
 do
   {ok=requester_input(1,"anderer Name waehlen, maximal 6 Zeichen","%s","%s",name);
   }
 while(karte.wegpunktvorhanden(name));
}

const int MAXDATEIEN=500;

class Geladen
{
 string nam[MAXDATEIEN];
 UWORD dateinr[MAXDATEIEN],nextnr;
 int j;
public:
 Geladen() {j=0; nextnr=1;}
 int getdateinr() {return  (nextnr==0xFFFF||j==MAXDATEIEN) ? 0 : nextnr;}
 void put(char *name) {nam[j]=strkopie(name); dateinr[j++]=nextnr++;}
 int getj() {return j;}
 char* get(int i) {return nam[i];}
 void entfernen(int);
 void entfernen(char *s)
   {int n=strlen(s);
    for(int i=j;--i>=0;) if(strncmp(nam[i],s,n)==0) entfernen(i);
   }
};
void Geladen::entfernen(int i)
{
 int k;
 printf("Karte '%s' entfernen\n",nam[i]);//test
 karte.entfernen(dateinr[i]);
 printf(" fertig entfernt dateinr[%d]=%d j=%d\n",i,dateinr[i],j);//test
 if(dateinr[i]==nextnr-1) --nextnr;
 for(k=i;k<j-1;k++) {nam[k]=nam[k+1]; dateinr[k]=dateinr[k+1];}
 if(--j<0) j=0;
}
static Geladen geladen;

/********************* Weitere Vordeklarationen ***********************/
int parser(char *zeile,string *namen,string *werte,int max);

/************************* Men Behandlung ****************************/
static int exitflag=0;
void menu_exit() {exitflag=1;}
void //Vordeklarationen der Menus
  m_karlad(),m_gpslad(),m_entfkar(),m_entfgps(),m_savew(),m_saver(), m_save(),
  m_zoomout(),m_autozoom(),m_zoomprev(),m_zoomch(),m_zoomeu(),m_zoomwelt(),
  m_dw(),m_dt(),m_dr(),m_aktpos(),m_uw(),m_delw(),m_tracksplit(),m_ut(),m_para(),
  m_detai1(),m_detai2();

void m_proj(long,int);
void m_proj1(long id) {m_proj(id,1);}
void m_proj2(long id) {m_proj(id,2);}
void m_proj3(long id) {m_proj(id,3);}
void m_proj4(long id) {m_proj(id,4);}

#ifdef unix
//Dies ist unter Linux ntig, weil sonst das Programm abstrzt wenn es
//versucht mit menu_switch() die Menu-Texte zu ndern. (SIGSEGV-Fehler)
class CHARS
{
public:
 char *txt;
 CHARS(char *s) {txt=new char[strlen(s)+1]; strcpy(txt,s);}
 char& operator[](int i) {return txt[i];}
};
inline int
 menu_switch(long id,long *ids,int k,int max,CHARS *txt,int k1=0,int k2=0)
{
 return menu_switch(id,ids,k,max,&txt->txt,k1,k2);
}
//inline int menu_flag(long id,long *ids,int k,int max,CHARS *txt,int flag)
//{return menu_flag(id,ids,k,max,&txt->txt,flag);}
//inline void changemenu(long id,CHARS& txt) {changemenu(id,txt.txt);}
#else
typedef char* CHARS;
#endif
#if GCC_VERSION>=3000
inline void setsubmenu(int n,void*p1,CHARS& txt,void*q1,funkzeiger m)
{setsubmenu(n,p1,&txt[0],q1,m);}
inline void setsubmenu(int n,void*p1,void*p2,CHARS& txt,
		       void*q1,void*q2,funkzeiger m)
{setsubmenu(n,p1,p2,&txt[0],q1,q2,m);}
inline void setsubmenu(int n,void*p1,void*p2,void*p3,CHARS& txt,
		       void*q1,void*q2,void*q3,funkzeiger m)
{setsubmenu(n,p1,p2,p3,&(txt[0]),q1,q2,q3,m);}
#endif

static long projids[4];
static CHARS projtext[]={"%r Tangentialflaeche","%r Zylinder","%r Peters",
  "%R Simpel"};

/********************** Projektion, Zeichnen **************************/
void projektion(double x,double y,double *px,double *py)
{
 double xm=x-mittex,x1,y1;
 switch(proj_methode)
   {case TANGENT:
	x1=xm*faktor; y1=(y-mittey)*faktor; //provi.
    CASE ZYLINDER:
	x1=xm*faktor*cosbeta0;
	y1=(tan(y*GRAD)-tanbeta0)*faktor/GRAD/cosbeta0;
    CASE PETERS:
	x1=xm*faktor*cosbeta0;
	y1=(sin(y*GRAD)-sinbeta0)*faktor/GRAD/cosbeta0;
    CASE SIMPEL: default:
	x1=xm*faktor*cosbeta0;
	y1=(y-mittey)*faktor;
   }
 *px=x1; *py=y1;
}
void projektion2(double x,double y,double *px,double *py,bool flag)
{
 static double x0=0;
 double xm;
 if(flag)
   {if((xm=x-mittex)>180.0) x-=360.0; else if(xm<-180.0) x+=360.0;
    x0=x;
   }
 else
   {double x1=x-x0;
    if(x1>180.0) x-=360.0; else if(x1<-180.0) x+=360.0;
   }
 static double x2=0;//test
 if(!flag && abs(x-x2)>180) printf("Fehler: x=%lf x2=%lf\n",x,x2);//test
 x2=x;
 projektion(x,y,px,py);
}
void reversprojektion(double x,double y,double *px,double *py)
{
 double x0,y0;
 switch(proj_methode)
   {case TANGENT:
	x0=x/faktor+mittex; y0=y/faktor+mittey; //provi.
    CASE ZYLINDER:
	x0=x/faktor/cosbeta0+mittex;
	y0=atan(y/faktor*GRAD*cosbeta0+tanbeta0)/GRAD;
    CASE PETERS:
	x0=x/faktor/cosbeta0+mittex;
	y0=asin(y/faktor*GRAD*cosbeta0+sinbeta0)/GRAD;
    CASE SIMPEL: default:
	x0=x/faktor/cosbeta0+mittex;
	y0=y/faktor+mittey;
   }
 *px=x0; *py=y0;
}

bool istsichtbar(double x,double y)
{
 projektion(x,y,&x,&y);
 return (x>=xmin+dx && x<=xmax-dx && y>=ymin+dx && y<=ymax-dx);
}

void zeichnepunkt(double x,double y,int sym)
{
 projektion(x,y,&x,&y);
 if(x>=xmin+dx && x<=xmax-dx && y>=ymin+dx && y<=ymax-dx)
   {if(sym>=SYMB_DOT && sym<SYMB_MAX)
      {struct xypen *ic=icon[sym];
       for(int i=0;ic[i].pen!=0;i++)
	 plot(x+ic[i].x,y+ic[i].y,ic[i].pen);
      }
    else
      fillbox(x-dx,y-dx,x+dx,y+dx);
   }
}

void anschreiben(double x,double y,char *text)
{
 if(text!=NULL)
  {projektion(x,y,&x,&y);
   if(x>=xmin+dx && x<=xmax-dx && y>=ymin+dx && y<=ymax-dx)
      {schrift(x+1.5*dx,y,text);
      }
  }
}

/************************* Hauptprogramm ******************************/
void m_refresh()
{
 inital_new(xmin,ymin,xmax,ymax);
 screenclear(1); color(0);
 karte.zeichnen();
 term_refresh();
}

main(int argc,char *argv[])
{
 int maxcol;
 int breite,hoehe,tiefe,visklasse;
 //tek_setdebug(1);//test
 printf("gpskarte %s  last update %s\n",VERSION,LAST_UPDATE);
 if(argc>1)
        {printf("Anwendung:\n  > gpskarte  (ohne Parameter)\n");
	 exit(0);
	}
 getmaxsize(&breite,&hoehe,&tiefe,&visklasse);
 if(tiefe>TIEFE) tiefe=TIEFE;
 maxcol=(1<<tiefe);
 setsize(breite,hoehe,tiefe);
 setmenu(4,"File","Ansicht","GPS","Einstellungen");
 setmenu(4,"Karte laden ...","zoom zurueck","download Wegpunkte ...","Projektion ->",
	 m_karlad,m_zoomprev,m_dw,NULL);
 setsubmenu(4,NULL,NULL,NULL,projtext[0],NULL,NULL,NULL,m_proj1);
 setsubmenu(4,NULL,NULL,NULL,projtext[1],NULL,NULL,NULL,m_proj2);
 setsubmenu(4,NULL,NULL,NULL,projtext[2],NULL,NULL,NULL,m_proj3);
 setsubmenu(4,NULL,NULL,NULL,projtext[3],NULL,NULL,NULL,m_proj4);
 setmenu(4,"Karte entfernen ...",	"zoom out","download Tracks ...","Parameter ...",	 m_entfkar,m_zoomout,m_dt,m_para);
 setmenu(4,"GPS-Datei laden ...",	"autozoom","download Routen ...","Fluesse ...",	 m_gpslad,m_autozoom,m_dr,m_detai1);
 setmenu(4,"GPS-Daten entfernen ...",	"Schweiz", "aktuelle Position","Grenzen ...",	 m_entfgps,m_zoomch,m_aktpos,m_detai2);
 setmenu(3,"Speichere Wegpunkte ...",	"Europa",  "-----------------",			 m_savew,m_zoomeu,NULL);
 setmenu(3,"Speichere Route ...",	"Welt",    "upload Wegpunkte ...",		 m_saver,m_zoomwelt,m_uw);
 setmenu(3,"-------------------",	"refresh", "loesche Wegpunkte ...",		 NULL,m_refresh,m_delw);
 setmenu(3,"Speichere Status",		NULL,	   "-----------------",			 m_save,NULL,NULL);
 setmenu(3,"Exit",			NULL,	   "Tracks-Datei aufteilen ...",	menu_exit,NULL,m_tracksplit);
 setmenu(3,NULL,			NULL,	   "upload Track ...",			NULL,NULL,m_ut);
 set_funktions(mauspre,mausrel,NULL,mausmot);
 inital(xmin,ymin,xmax,ymax); /* Grafikfenster oeffnen */
 char titel[80]; sprintf(titel,"gpskarte  %s",VERSION);
 set_tektitel(titel);
 screenclear(1);
 setcolor(BRAUN,0x70,0x90,0);
 term_refresh();
 default_load();
 int taste,asci; ULONG rawcode;
 int j=0,jmax=300; //allfaellige Aktualisierung etwa alle 5 Sec.
 while(exitflag==0 && waitmenu(0)==0)
   {waitTOF();
    if(autoaktpos && ++j>=jmax)
      {j=0; aktpos_erneuern();
       inital_new();
       color(WEISS); aktpos_zeichnen(aktposx2,aktposy2);
       color(SCHWARZ); aktpos_zeichnen(aktposx1,aktposy1);
       color(ROT); aktpos_zeichnen(aktposx,aktposy);
       aktposx2=aktposx1; aktposy2=aktposy1;
       aktposx1=aktposx; aktposy1=aktposy;
       drawmode(JAM1);
       term_refresh();
      }
    else if(keyget(&taste,&asci,&rawcode)!=0)
      {if(rawcode>=0xFF51 && rawcode<=0xFF54) zoomshift(rawcode-0xFF50);
      }
   }
 term_exit();
 return 0;
}/* ende von main */

char* nextzahl(char *s)
{
 while(*s!=' ' && *s!=0) s++;
 while(*s==' ') s++;
 return s;
}

int karte_laden(char *name)
{
 //Rckgabewert: -1=Fehler, 0=leere Datei, >1=ok
 char zeile[200],*s;
 int n,dateinr,nz=0;
 double x,y,x1,y1,x2,y2,hoe;
 string wort[20],wert[20];
 if((dateinr=geladen.getdateinr())==0)
   {fehler("zu viele Dateien geladen"); return -1;}
 FILE *fp;
 if(!(fp=fopen(name,"r"))) {printf("'%s' nicht gefunden\n",name); return -1;}
 while(getline(fp,zeile,200))
   {if(*zeile==';' || *zeile=='#') continue;
    nz++;
    if(*zeile=='>')
      {if(strncmp(&zeile[2],"Shore",5)==0)
	strcpy(zeile,"obj=\"kueste\" name=\" \" hoe=0");
       else if(strncmp(&zeile[2],"Border",6)==0)
	strcpy(zeile,"obj=\"grenze\" name=\" \" hoe=0");
       else if(strncmp(&zeile[2],"River",5)==0)
	strcpy(zeile,"obj=\"fluss\" name=\" \" hoe=0");
       else printf("unbekanntes Schluesselwort: %s\n",zeile);//test
      }
    n=parser(zeile,wort,wert,20);
    if(n==0) continue;
    if(strcmp(wort[0],"obj")==0) //Objekt mit x y Reihenfolge der Daten
      {karte.objektstart(wert[0],wert[1],hoe=atof(wert[2]),dateinr);
       while(getline(fp,zeile,200) && zeile[0]!='}')
	 {s=zeile; 
	  if(*s==',' || *s=='>')
	    {karte.objektrestart(wert[0],wert[1],hoe,dateinr);
	     if(*s++ =='>') continue;
	    }
	  if(*s=='{' || *s==' ') {while(*++s==' ') ;}
	  for(;*s!=0;s=nextzahl(s),s=nextzahl(s))
	    {sscanf(s,"%lf%*c%lf",&x,&y);
	     karte.objekt(x,y);
	    }
	 }
       karte.objektfertig();
      }
    else if(strcmp(wort[0],"oby")==0) //Objekt mit y x Reihenfolge
      {karte.objektstart(wert[0],wert[1],atof(wert[2]),dateinr);
       while(getline(fp,zeile,200) && zeile[0]!='}')
	 {s=zeile; if(*s=='{' || *s==' ') {while(*++s==' ') ;}
	  for(;*s!=0;s=nextzahl(s),s=nextzahl(s))
	    {sscanf(s,"%lf %lf",&y,&x);
	     karte.objekt(x,y);
	    }
	 }
       karte.objektfertig();
      }
    else if(strcmp(wort[0],"gmt")==0) //Objekte mit fremdem Datenformat
      {int flag=0;
       x2=y2=400;
       char name2[160]; sprintf(name2,"%s.tmp",wert[1]);
       FILE *fp2;
       fp2=fopen(name2,"w"); printf("%s wird erstellt\n",name2);
       fprintf(fp2,"obj=\"%s\" name=\" \" hoe=0\n{\n",wert[0]);
       while(getline(fp,zeile,200) && zeile[0]!='}')
	 {if(*zeile=='{') continue;
	  n=sscanf(zeile,"%lf %lf %lf %lf",&y,&x,&y1,&x1);
	  if(n!=4) printf("Fehler: keine 4 Werte: '%s'\n",zeile);//test
	  else
	    {if(x!=x2 || y!=y2)
	      {if(flag) fprintf(fp2,",");
	       fprintf(fp2,"%lg %lg\n",x,y); flag=1;
	      }
	     fprintf(fp2,"%lg %lg\n",x1,y1); x2=x1; y2=y1;
	    }
	 }
       if(flag) fprintf(fp2,"}\n");
       fclose(fp2);
       printf("%s fertig erstellt\n",name2);
      }
    else
      {printf("Unbekanntes Schluesselwort '%s' in zeile '%s'\n",wort[0],zeile);
      }
   }
 fclose(fp);
 if(nz==0) {if(strncmp(name,"tmp.",4)!=0) printf("'%s' ist leer\n",name);}
 else geladen.put(name);
 if(strncmp(name,"tmp.",4)!=0) m_refresh();
 return nz;
}

void m_karlad()
{
 static char name[160]="test.karte";
 int ok;
 ok=nachfilenamefragen("lade Karte",name,160);
 if(ok)
   {karte_laden(name);}
}

inline int istblank(int c) {return c==' ' || c=='\t';}

int parser(char *zeile,string *namen,string *werte,int max)
{
 char *t,*s,*p,wert[80];
 int c,a,a2,j,i,j1=0;
 for(j=0,s=zeile;*s!=0;s=t,j++)
   {while(istblank(*s)) s++; //fhrende Leerstellen berlesen
    for(t=s;(c= *t)!=0 && c!='=';t++)  ; //Trennzeichen suchen
    if(c=='=')
      {*t=0;
       namen[j]=strkopie(s);
       *t++ = '=';
       while(istblank(*t)) t++;
       if((a= *t)=='"') {a2=a; t++;}
       else {a=' '; a2='\t';}
       for(i=1,p=wert;i<80 && *t!=0 && *t!=a && *t!=a2;i++)  *p++ = *t++;
       *p=0;
       werte[j]=strkopie(wert);
       if(*t==a) t++;
       if(++j1==max) break;
      }
   }
 return j1;
}

bool vorhanden(char *sym,char *inh,int n,string *wort,string *wert)
{
 for(int i=0;i<n;i++)
   if(strcmp(sym,wort[i])==0 && strcmp(inh,wert[i])==0) return true;
 return false;
}

void pcx5(char *zeile)
{
 static int koord=0,lastc0=0;
 char nam[160],com[42],*sym;
 double lat,lon,latm,lonm,alt; char c1,c2;
 int i,latd,lond,ksym,c0=zeile[0];
 if(c0=='W')
   {if(koord==1)
     {printf("kann noch nicht SWISS-Koordinaten umrechnen\n"); return;}//provi.
    else
      {sscanf(zeile,"W  %6s %c%2d%lf %c%3d%lf %*9s %*8s %lf%*c%40c %*lf %d",
	  nam,&c1,&latd,&latm,&c2,&lond,&lonm,&alt,com,&ksym);
       lat=latd+latm/60; if(c1=='S') lat= -lat;
       lon=lond+lonm/60; if(c2=='W') lon= -lon;
      }
    com[40]=0; for(i=40;--i>0 && com[i]==' ';) com[i]=0;
    switch(ksym)
      {case 18: sym="wpt_dot"; break;
       case 8198: sym="sml_cty"; break;
       case 8199: sym="med_cty"; break;
       case 8200: sym="lrg_cty"; break;
       case 16391: sym="tall_tower"; break;
       case 16392: sym="short_tower"; break;
       case 16393: sym="glider"; break;
      default: sym="wpt_dot"; printf("unknown PCX5-Symbol %d\n",ksym);
      }
    sprintf(zeile,"type=waypoint latitude=%lf longitude=%lf name=\"%s\" comment=\"%s\" symbol=%s display_option=\"symbol+name\"%c",
	    lat,lon,nam,com,sym,0);
   }
 else if(c0=='U')
   {if(strcmp(zeile,"U  LAT LON DM")==0) koord=0;
    else if(strcmp(zeile,"U  SWISS")==0) koord=1;
    else printf("unknown PCX5-Koordinates: '%s'\n",zeile);
   }
 else if(c0=='H')
   {lastc0=c0;
   }
 else if(c0=='T')
   {if(koord==1)
     {printf("kann noch nicht SWISS-Koordinaten umrechnen\n"); return;}//provi.
    else
      {sscanf(zeile,"T  %c%2d%lf %c%3d%lf",&c1,&latd,&latm,&c2,&lond,&lonm);
       lat=latd+latm/60; if(c1=='S') lat= -lat;
       lon=lond+lonm/60; if(c2=='W') lon= -lon;
      }
    if(lastc0=='T')
      sprintf(zeile,"type=trackpoint latitude=%lf longitude=%lf%c",lat,lon,0);
    else
      sprintf(zeile,"type=trackpoint latitude=%lf longitude=%lf newsegment=yes%c",
	      lat,lon,0);
    lastc0=c0;
   }
}

bool istgleich_wort_wert(int n,string *wort,string *wert,char *s1,char *s2)
{
 //printf("istgleich_wort_wert(n,..,%s,%s)\n",n,s1,s2);//test
 for(int i=0;i<n;i++)
   {if(strcmp(wort[i],s1)==0 && strcmp(wert[i],s2)==0) return true;}
 return false;
}
#define istgleich(a,b) istgleich_wort_wert(n,wort,wert,a,b)

char* wert_auslesen(int n,string *wort,string *wert,char *s1)
{
 //printf("wert_auslesen(%d,..,%s)\n",n,s1);//test
 for(int i=0;i<n;i++) if(strcmp(wort[i],s1)==0) return wert[i];
 return "";
}
#define we(s1) wert_auslesen(n,wort,wert,s1)

void locfile(char *zeile)
{
 int n1,n2,n3;
 double lat,lon;
 static char name[80]="";
 if((n1=index(zeile,"<name"))>=0 && (n2=index(zeile,"id="))>n1)
    {stringlesen(name,&zeile[n2+3]); *zeile=0;}
 if((n1=index(zeile,"<coord"))>=0
    && (n2=index(zeile,"lat="))>n1
    && (n3=index(zeile,"lon="))>n1)
   {sscanf(&zeile[n2+5],"%lf",&lat);
    sscanf(&zeile[n3+5],"%lf",&lon);
    sprintf(zeile,
	    "type=\"waypoint\" latitude=\"%lf\" longitude=\"%lf\" name=\"%s\" symbol=\"wpt_dot\" display_option=\"symbol+name\"\0",
	    lat,lon,name);
   }
 else *zeile=0;
}

void m_gpslad()
{
 static char name[160]="test.tracks";
 char zeile[200];
 string wort[20],wert[20];
 FILE *fp;
 int ok,n,dateinr,pcx5flag=0,locflag=0;
 int flags=0;
 const int TRACK=1,ROUTE=2,NEUESWORT=4;
 ok=nachfilenamefragen("lade GPS-Datei",name,160);
 if(ok)
   {if((dateinr=geladen.getdateinr())==0)
	{fehler("zu viele Dateien geladen"); return;}
    if(!(fp=fopen(name,"r"))) printf("%s nicht gefunden\n",name);
    else
      {//printf("Datei %d geladen\n",dateinr);//test
       while(getline(fp,zeile,200))
	{if(*zeile=='#') continue; //Kommentare berlesen
	 if(*zeile=='I')
	   {if(strncmp(&zeile[3],"PCX5",4)==0) pcx5flag=1;}
	 else if(*zeile=='<')
	   {if(strncmp(zeile,"<?xml",5)==0) locflag=1;}
	 if(pcx5flag) pcx5(zeile); //alte Daten umformen
	 else if(locflag) locfile(zeile); //vom loc-Format umformen
	 n=parser(zeile,wort,wert,20);
	 //Daten vom Garmin_GPS_III oder Etrex_Vista auswerten:
	 //printf("zeile='%s'\n",zeile);//test
	 //printf("n=%d %s=\"%s\"\n",n,wort[0],wert[0]);//test
	 if(n>=1)
	  {if(strcmp(wort[0],"type")==0) //beginnt Zeile mit type="..." ?

//Tracks, typische Zeile:
//type="trackpoint"  altitude="507"  latitude="47.39789"  longitude="8.54745"
	    {if(strcmp(wert[0],"track")==0) //ist type="track" gesetzt ?
	      {if(flags==TRACK) karte.trackfertig();
	       if(n>=2 && strcmp(wort[1],"name")==0)
	            {karte.trackstart(wert[1],0,dateinr);}
	       else {karte.trackstart("trackname",0,dateinr);}
	       flags=TRACK;
	      }
	     else if(strcmp(wert[0],"trackpoint")==0) //Trackpunkt
	      {if(flags!=TRACK && istgleich("newsegment","yes"))
		 {karte.trackstart("trackname",0,dateinr); flags=TRACK;}
	       //karte.trackput(we("longitude"),we("latitude"),we("altitude"));
	       karte.trackput(we("longitude"),we("latitude"));
	       //printf("karte.trackput(%s,%s)\n",we("longitude"),we("latitude"));//test
	      }
	     else if(strcmp(wert[0],"trackend")==0) //Track abschliessen
	      {if(flags==TRACK) {karte.trackfertig(); flags=0;}
	      }

//Wegpunkte, typische Zeile:
//type="waypoint"  name="GARMIN"  altitude="325"  latitude="38.85555"  longitude="-94.79902"  symbol="wpt_dot"  display_option="symbol+name"
	     else if(strcmp(wert[0],"waypointlist")==0)
	      {} //Start einer Wegpunktliste - gibt nichts zu tun
	     else if(strcmp(wert[0],"waypoint")==0) //Wegpunkt
	      {karte.wegpunkt(we("longitude"),we("latitude"),we("name"),
			      we("comment"),we("symbol"));
	      //printf("karte.wegpunkt(%s,%s,%s,%s,%s)\n",
	      //      we("longitude"),we("latitude"),we("name"),
	      //      we("comment"),we("symbol"));//test
	      }
	     else if(strcmp(wert[0],"waypointlistend")==0)
	      {} //Ende einer Wegpunktliste - gibt nichts zu tun

//Route, typische Zeile:
//type="routepoint"  name="Binz"  latitude="47.35725"  longitude="8.6277"  symbol="sml_cty"  display_option="symbol+name"
	     else if(strcmp(wert[0],"route")==0)
	      {karte.routestart(we("routename"),
				atoi(we("routenumber")), dateinr);
	       flags=ROUTE;
	      }
	     else if(strcmp(wert[0],"routepoint")==0)
	      {if(flags!=ROUTE)
		 {karte.routestart("UNNAMED ROUTE",0,dateinr); flags=ROUTE;}
	       karte.routeput(we("longitude"),we("latitude"));
	       //printf("karte.routeput(%s,%s)\n",we("longitude"),we("latitude"));//test
	      }
	     else if(strcmp(wert[0],"routeend")==0)
	      {karte.routefertig(); flags=0;}

//Neue Stichworte type="..." hier einprogrammieren (vor dieser Zeile).
	     else printf("Unbekannte Zeile (%d Parameter): %s\n",n,zeile);
	    }
	   else printf("Fehlendes type (n=%d): %s\n",n,zeile);
	  }
	 else {//printf("Leere Zeile: '%s'\n",zeile);//test
	      }
	}
       fclose(fp);
       if(flags==TRACK) karte.trackfertig();
       if(flags==ROUTE) karte.routefertig();
      }
    m_refresh();
   }
}

void fortschritt(char *text,int fertig=0)
{
 double x1= -5, x2=5, bx=0.4, hy=0.6, y1,y2,x,y;
 int n,c;
 char *s,*t,*te=new char[strlen(text)+1];
 strcpy(te,text);
 for(n=1,s=te;(c= *s++)!=0;) if(c=='\n') n++;
 y2=(n+1)/2*hy*1.4+0.1; y1= -y2;
 inital_new();
 color(WEISS); fillbox(x1,y1,x2,y2); color(SCHWARZ);
 drawbox(x1,y1,x2,y2);
 x=x1+bx; y=y2-1.2*hy;
 for(t=te;*t!=0;t=s)
   {for(s=t;(c= *s)!=0 && c!='\n';s++) ;
    if(c=='\n') *s=0;
    schrift(x,y,t); y-=1.4*hy;
    if(c=='\n') s++;
   }
 term_refresh();
 if(fertig) {Delay(2); m_refresh();}
 delete te;
}
void fortschritt(char *text,char *s,int fertig=0)
{
 char *str=new char[strlen(text)+strlen(s)+1];
 sprintf(str,text,s);
 fortschritt(str,fertig);
 delete str;
}
void fortschrittd(char *text,int n,char *s)
{
 char *str=new char[strlen(text)+strlen(s)+20];
 sprintf(str,text,n,s);
 fortschritt(str,0);
 delete str;
}

bool fortschritt_fertig()
{
 if(fehlerin(tmpdat))
   {janeinrequester("Fehler in Uebertragung.\nTip: am GPS Interface auf GARMIN setzen.");
    fortschritt(" ",1);
    return false;
   }
 else fortschritt("Uebertragung erfolgreich beendet.",1);
 return true;
}

void m_dw() //download Wegpunkte
{
 int ok;
 static char name[160]="test.wegpunkte";
 ok=nachfilenamefragen("speichere Wegpunkte",name,160);
 if(ok)
   {fortschritt(
      "Uebertragen der Wegpunkte vom GPS zur Datei\nbitte etwas Geduld ...");
#ifdef GPSPOINT1
    system2("gpspoint -dw %s 2>%s",name,tmpdat);
#else
    system2("gpspoint -dw >%s 2>%s",name,tmpdat);
#endif
    fortschritt_fertig();
   }
}

void m_dt() //download Tracks
{
 int ok;
 static char name[160]="test.tracks";
 ok=nachfilenamefragen("speichere Tracks",name,160);
 if(ok)
   {fortschritt(
      "Uebertragen der Tracks vom GPS zur Datei\nbitte etwas Geduld ...");
#ifdef GPSPOINT1
    system2("gpspoint -dt %s",name);
#else
    system2("gpspoint -dt >%s",name);
#endif
    ok=fortschritt_fertig();
    if(ok)
      {char zeile[160],str[200]; int n=0;
       FILE *fp=fopen(name,"r");
       if(fp!=NULL)
	 {while(getline(fp,zeile,160))
	   {if(index(zeile,"newsegment")>=0) n++;
	    else if(index(zeile,"ACTIVE LOG")>=0) break;
	   }
	  fclose(fp);
	 }
       if(n>1)
	 {sprintf(str,
	      "Die Datei enthaelt %d Tracks.\n\
Soll sie auf mehrere Dateien aufgeteilen werden ?\n\
(Wobei zum Namen dann die Zahlen 1 bis %d angefuegt werden)",n,n);
	  ok=janeinrequester(str,"ja","nein");
	  if(ok)
	    {tracksaufteilen(name);}
	 }
      }
   }
}

void m_dr() //download Routen
{
 int ok;
 static char name[160]="test.routen";
 ok=nachfilenamefragen("speichere Routen",name,160);
 if(ok)
   {
#ifdef GPSPOINT1
    system2("gpspoint -dr %s",name);
#else
    system2("gpspoint -dr >%s",name);
    char zeile[160],str[200]; int n=0;
    FILE *fp=fopen(name,"r");
    if(fp!=NULL)
	 {while(getline(fp,zeile,160))
	   {if(index(zeile,"routename")>=0) n++;
	   }
	  fclose(fp);
	 }
    if(n>1)
	 {sprintf(str,
	      "Die Datei enthaelt %d Routen.\n\
Soll sie auf mehrere Dateien aufgeteilen werden ?\n\
(Wobei zum Namen dann die Zahlen 1 bis %d angefuegt werden)",n,n);
	  ok=janeinrequester(str,"ja","nein");
	  if(ok) routenaufteilen(name);
	 }
#endif
   }
}

bool gpspoint_vorhanden()
{
 bool r=0;
 FILE *fp;
 int c;
 double version;
 system2("rm %s",tmpdat);
 system2("gpspoint -a >%s 2>&1",tmpdat);
 if((fp=fopen(tmpdat,"r"))!=NULL) {r=getc(fp)!=EOF; fclose(fp);}
 if(r)
   {fp=fopen(tmpdat,"r");
    for(version=0;version<1.0 && (c=getc(fp))!=EOF;)
       if(isdigit(c)) {ungetc(c,fp); fscanf(fp,"%lf",&version);}
    fclose(fp);
    printf("gpspoint version=%lf\n",version);
   }
 else printf("gpspoint nicht gefunden\n");//test
 return r;
}

void m_aktpos()
{
/* Typische Antwort von "gpspoint -n -p":
***************** NMEA Interface *******
serial port: /dev/ttyS1
serial port speed: default
mode : nmea
latitude 47.3643   longitude 8.62128
****************************************
*/
 FILE *fp;
 int i,n,ok;
 char zeile[160],r1[160],r2[160];
 double x,y;
 for(ok=0;ok==0;)
 {system2("gpspoint -n -p >%s",tmpdat);
  ok=1;
  fp=fopen(tmpdat,"r");
  for(i=0,*zeile=0;i<10 && strncmp(zeile,"mode",4)!=0;i++)
    {getline(fp,zeile,160); n=sscanf(zeile,"%s %s",r1,r2);
     if(n==2 && strcmp(r1,"remove")==0) {system2("rm %s",r2); ok=0;}
    }
  getline(fp,zeile,160);
  fclose(fp);
  if(sscanf(zeile,"latitude %lf longitude %lf",&y,&x)!=2)
  {char str[160]; sprintf(str,"Kann GPS-Koordinaten nicht erhalten\n%s\n\
Tip: am GPS Interface auf NMEA setzen.",zeile);
   ok=janeinrequester(str,"Abbrechen","Nochmals probieren");
   if(ok && autoaktpos) autoaktpos=!janeinrequester(
	"Automatische Aktualisierung ausschalten","ja","nein"); 
  }
  else
   {char str[160]; sprintf(str,
     "Momentane Position: %lf %lf\nAutomatische Aktualisierung einschalten",
			   x,y);
    aktpos_zeichnen(x,y);
    autoaktpos=janeinrequester(str,"ja","nein");
    if(autoaktpos) {aktposx=x; aktposy=y;}
    ok=1;
   }
 }
}

void m_uw() //upload Wegpunkte
{
 int ok,c;
 static int nmax=10;
 static char we[80]="E";
 char dateiname[160]="tmp.wegpunkte";
 ok=requester_input(2,"Welche Wegpunkte ans GPS schicken ? (Edierte, Sichtbare, oder Datei)","%s","%s\n",we,
		    "Maximale Anzahl Punkte uebertragen (nicht beruecksichtigt bei 'Datei')","%d","%d",&nmax);
 if(ok)
   {c= *we; if(c>='a' && c<='x') c=c-'a'+'A';
    if(c=='D') ok=nachfilenamefragen("lesen von Datei",dateiname,160);
    else if(c=='E' || c=='S') karte.wegpunktauswahl(c,nmax,dateiname);
    else {janeinrequester("Ungueltige Antwort, nichts veraendert."); ok=0;}
    if(ok)
      {fortschritt("Uebertragen der Wegpunkte von '%s' zum GPS\nbitte etwas Geduld ...",dateiname);
#ifdef GPSPOINT1
       system2("gpspoint -uw %s 2>%s",dateiname,tmpdat);
#else
       system2("gpspoint -uw <%s 2>%s",dateiname,tmpdat); //noch nicht getestet
#endif
       fortschritt_fertig();
      }
   }
 m_refresh();
}

void m_delw() //loesche Wegpunkte
{
 int ok,n;
 static char we[80]="E";
 char dateiname[160]="x.wegpunkte";
 char tmpname[160]="tmp.wegpunkte";
 char trcbckname[80]="dollar";
 janeinrequester(
"Vorgehen um Wegpunkte vom GPS zu loeschen:\n\
1. Datei auswaehlen in der die zu loeschenden Wegpunkte gesichert sind\n\
2. Wegpunkte werden vom Programm auf einen bestimmten Typ gesetzt (z.B. trcbck beim GPS3).\n\
3. Auf dem GPS unter 'Delete by Symbol' den entsprechenden Typ waehlen.");
 ok=requester_input(1,"Symbol-Name der zu loeschenden Punkte, oder help",
		    "%s","%s\n",trcbckname);
 if(ok)
 {if(symb(trcbckname)==0) //help oder unbekanntes Symbol
    {n=symbolname_input(0); strcpy(trcbckname,symb_namen[n]);}
  ok=nachfilenamefragen("lese Datei mit den zu loeschenden Wegpunkten",dateiname,160);
  if(ok)
      {fortschritt("Kopieren der Wegpunkte von '%s' nach tmp.wegpunkte",dateiname);
       n=dateifilter(dateiname,tmpname,"symbol=\"","\"",trcbckname);
       if(n>0)
	 {fortschrittd("Uebertragen von %d Wegpunkte als %s-Punkte zum GPS\nbitte etwas Geduld ...",n,trcbckname);
#ifdef GPSPOINT1
	  system2("gpspoint -uw %s 2>%s",tmpname,tmpdat);
#else
	  system2("gpspoint -uw <%s 2>%s",tmpname,tmpdat);
#endif
	  ok=fortschritt_fertig();
	 }
       else
	 {fortschritt(" ",1); janeinrequester("Fehler in dateifilter()"); ok=0;}
       if(ok)
	 janeinrequester2("Wandlung von %d Wegpunkte in %s fertig.\nJetzt also auf dem GPS alle %s-Wegpunkte loeschen.",n,trcbckname,trcbckname);
      }
 }
 m_refresh();
}

void m_tracksplit()
{
 char dateiname[160]="test.tracks";
 nachfilenamefragen("lesen von Datei",dateiname,160);
 tracksaufteilen(dateiname);
}

void m_ut() //upload Track(s)
{
 int ok,c;
 static int nmax=10;
 static char we[80]="D";
 char dateiname[160]="test.tracks1";
 ok=requester_input(1,"Welchen Track ans GPS schicken ? (Edierte, Sichtbare, oder Datei) BISHER GEHT NUR Datei","%s","%s\n",we);
 if(ok)
   {c= *we; if(c>='a' && c<='x') c=c-'a'+'A';
    if(c=='D') nachfilenamefragen("lesen von Datei",dateiname,160);
    //else if(c=='E' || c=='S') karte.wegpunktauswahl(c,nmax,dateiname);
    else {janeinrequester("Ungueltige Antwort, nichts veraendert."); ok=0;}
    if(ok)
      {fortschritt("Uebertragen der Tracks von '%s' zum GPS\n\
bitte etwas Geduld ...\n\
Auf GPS-III: Wenn Uebertragung fertig Menu->TrackLogs->SaveActiveLog",
		   dateiname);
#ifdef GPSPOINT1
       system2("gpspoint -ut %s 2>%s",dateiname,tmpdat);
#else
       system2("gpspoint -ut <%s 2>%s",dateiname,tmpdat); //noch nicht getestet
#endif
       fortschritt_fertig();
      }
   }
 m_refresh();
}

void m_savew() //Speichere Wegpunkte in eine Datei
{
 int ok,c,nmax=10000;
 static char we[80]="E";
 char dateiname[160]="neu.wegpunkte";
 ok=nachfilenamefragen("speichern in Datei",dateiname,160);
 if(ok)
 {ok=requester_input(2,"Welche Wegpunkte in Datei speichern ? (Edierte, Sichtbare, oder Alle)","%s","%s\n",we,
		    "           Dateiname          ","%s","%s",dateiname);
  if(ok)
   {c= *we; if(c>='a' && c<='x') c=c-'a'+'A';
    if(c=='E' || c=='S' || c=='A') karte.wegpunktauswahl(c,nmax,dateiname);
    else {janeinrequester("Ungueltige Antwort, nichts gespeichert."); ok=0;}
   }
 }
 m_refresh();
}

void m_saver() //Speichere Route in eine Datei
{
 janeinrequester("Routen speichern noch nicht fertig programmiert.");
}

static char
  *warn_gmt="Dieses Programm braucht GMT um Kartendaten darzustellen\n\
(Siehe http://gmt.soest.hawaii.edu)",
  *warn_gps="Dieses Programm braucht gpspoint, um Daten mit dem GPS auszutauschen.\n\
http://scampi.physik.uni-konstanz.de/~tschank/gpspoint",
  *warn_gmt_gps="Dieses Programm braucht GMT um Kartendaten darzustellen.\n\
(Siehe http://gmt.soest.hawaii.edu)\n\n\
Um Daten mit dem GPS auszutauschen braucht es noch gpspoint\n\
http://scampi.physik.uni-konstanz.de/~tschank/gpspoint";

int gmtdatenladen()
{
 static int startflag=1;
 double br,ho,x1,x2,y1,y2;
 int i,f,fn,c,gpsflag;
 char str[80],*s;
 if(startflag)
   {gpsflag=gpspoint_vorhanden();
    if(getenv("GMTHOME")==NULL)
      {if(gpsflag==0) janeinrequester(warn_gmt_gps);
       else janeinrequester(warn_gmt);
      }
    else if(gpsflag==0) janeinrequester(warn_gps);
    strcpy(c_riv[0],"1"); strcpy(c_bord[0],"1"); //Voreinstellungen
    strcpy(c_riv[1],"123"); strcpy(c_bord[1],"1");
    strcpy(c_riv[2],"r58"); strcpy(c_bord[2],"13");
    strcpy(c_riv[3],"ri8"); strcpy(c_bord[3],"a");
    strcpy(c_riv[4],"a"); strcpy(c_bord[4],"a");
    startflag=0;
   }
 else
   geladen.entfernen("tmp.");
 para.getbrho(&br,&ho);
 if(br<4 && ho<2) {f='f'; fn=4;}
 else if(br<10 && ho<5) {f='h'; fn=3;}
 else if(br<30 && ho<15) {f='i'; fn=2;}
 else if(br<80 && ho<40) {f='l'; fn=1;}
 else {f='c'; fn=0;}
 if(br>180) br=180;
 if(ho>90) ho=90;
 //printf("br=%lf ho=%lf f=%c\n",br,ho,f);//test
 for(i=0,s=str;i<20 && (c=c_bord[fn][i])!=0;i++)
   {*s++='-'; *s++='N'; *s++=c; *s++=' ';}
 *s=0;
 system5("pscoast -D%c -R%lf/%lf/%lf/%lf %s-M >tmp.1", //Grenzen
	 f,x1=mittex-br,x2=mittex+br,y1=mittey-ho,y2=mittey+ho,str);
 for(i=0,s=str;i<20 && (c=c_riv[fn][i])!=0;i++)
   {*s++='-'; *s++='I'; *s++=c; *s++=' ';}
 *s=0;
 system5("pscoast -D%c -R%lf/%lf/%lf/%lf %s-M >tmp.2",
		    f,   x1, x2, y1, y2, str); //Fluesse
 system5("pscoast -D%c -R%lf/%lf/%lf/%lf -W -M >tmp.3",f,x1,x2,y1,y2); //Kueste
 return karte_laden("tmp.1")+karte_laden("tmp.2")+karte_laden("tmp.3");
}

void mausbewegung(int flag)
{
 static int zoom_modus=0;
 static double x1,y1,x2,y2;
 double x,y,xm,ym,f1,f2;
 int tasten;
 tasten=mausposition(&x,&y);
 //if(zoom_modus==1 || flag==1)
 //  printf("mausbewegung(%d) tasten=%d\n",flag,tasten); //test
 if(zoom_modus==0)
   {if((tasten&LIMAUS)!=0)
     {inital_new();
      drawmode(COMPLEMENT);
      x2=x1=x; y2=y1=y;
      drawbox(x1,y1,x2,y2);
      zoom_modus=1;
     }
   }
 else //zoom_modus==1
   {drawbox(x1,y1,x2,y2);
    x2=x; y2=y;
    if(tasten&LIMAUS)
      {drawbox(x1,y1,x2,y2);}
    else
      {drawmode(JAM1);
       term_refresh();
       zoom_modus=0;
       if(abs(x2-x1)>dx && abs(y2-y1)>dx)
	 {xm=(x1+x2)/2; ym=(y1+y2)/2;
	  zoomhist.put(faktor,mittex,mittey);
	  reversprojektion(xm,ym,&mittex,&mittey); para.setpos();
	  f1=faktor*(xmax-xmin)/abs(x2-x1);
	  f2=faktor*(ymax-ymin)/abs(y2-y1);
	  faktor=f1>f2?f2:f1; para.setmass();
	  gmtdatenladen();
	 }
       else //nur auf _einen_ Punkt geklickt
	 {char name[80],symname[80],com[80];
	  int ok,neusym;
	  xm=(x1+x2)/2; ym=(y1+y2)/2;
	  reversprojektion(xm,ym,&x,&y);
	  Punkt *p; double pxm,pym;
	  p=karte.naechster_punkt(x,y);
	  if(p!=NULL) projektion(p->x,p->y,&pxm,&pym);
	  if(p!=NULL && abs(pxm-xm)+abs(pym-ym)<1.0)
	    {strcpy(name,p->name); strcpy(com,p->comment);
	     x=p->x; y=p->y;
	     strcpy(symname,symb_namen[p->symbol]);
	     ok=requester_input(5," Name ","%s","%s",name,
				"Comment, Langer Name","%s","%s\n",com,
				"latitude","%lf","%lf",&y,
				"longitude","%lf","%lf\n",&x,
				"Symbol (wpt_dot, med_cty, small_tower, ... oder help)", "%s","%s\n",symname);
	     if(ok)
	       {p->x=x; p->y=y;
		if((neusym=symb(symname))!=0 || index(symname,"dot")>=0)
		     p->symbol=neusym;
		else p->symbol=symbolname_input(p->symbol);
		if(strcmp(p->name,name)!=0)
		  {if(karte.wegpunktvorhanden(name)) neuername_input(name);
		   p->name=strkopie(name);
		  }
		if(strcmp(p->comment,com)!=0) p->comment=strkopie(com);
		p->flags |= EDFLAG;
	       }
	    }
	  //else Suche nach naechster Strecke oder Route
	  else
	    {//printf("Position: %lf %lf\n",x,y);//provi.
	     strcpy(name,"NEU"); strcpy(com,"NEUER WEGPUNKT");
	     strcpy(symname,"wpt_dot");
	     ok=requester_input(5," Name ","%s","%s",name,
				"Comment, Langer Name","%s","%s\n",com,
				"latitude","%lf","%lf",&y,
				"longitude","%lf","%lf\n",&x,
				"Symbol","%s","%s\n",symname);
	     if(ok)
	       {karte.wegpunkt(x,y,strkopie(name),strkopie(com),
			       symname,EDFLAG);
	       }
	    }
	 }
       m_refresh();
      }
   }
}
void mauspre() {mausbewegung(1);}
void mausrel() {mausbewegung(2);}
void mausmot() {mausbewegung(0);}

void m_zoomout()
{
 zoomhist.put(faktor,mittex,mittey);
 faktor *= 0.5;
 para.setmass();
 gmtdatenladen();
 m_refresh();
}

void m_autozoom()
{
 zoomhist.put(faktor,mittex,mittey);
 printf("autozoom: alter faktor=%lf\n",faktor);//test
 faktor /= karte.autozoom();
 printf(" neuer faktor=%lf\n",faktor);//test
 para.setmass();
 printf(" neuer Massstab=1:%ld\n",para.mass);//test
 gmtdatenladen();
 m_refresh();
}

void m_zoomprev()
{
 zoomhist.pop(&faktor,&mittex,&mittey);
 para.setpos(); para.setmass();
 gmtdatenladen();
 m_refresh();
}

void m_zoomch()
{
 zoomhist.put(faktor,mittex,mittey);
 para.mass=1100000; mittex=8.25; mittey=46.8;
 para.calc(); para.setpos();
 gmtdatenladen();
 m_refresh();
}

void m_zoomeu()
{
 zoomhist.put(faktor,mittex,mittey);
 para.mass=18000000; mittex=20; mittey=53;
 para.calc(); para.setpos();
 gmtdatenladen();
 m_refresh();
}

void m_zoomwelt()
{
 zoomhist.put(faktor,mittex,mittey);
 para.mass=125000000; mittex=0; mittey=0;
 para.calc(); para.setpos();
 gmtdatenladen();
 m_refresh();
}

void zoomshift(int richtung)
{
 double xm=0,ym=0;
 switch(richtung)
   {case 1: xm=xmin; break;   case 2: ym=ymax; break;
    case 3: xm=xmax; break;   case 4: ym=ymin; break;
   }
 reversprojektion(xm,ym,&mittex,&mittey); 
 para.setpos();
 gmtdatenladen();
 m_refresh();
}

void m_proj(long id,int m)
{
 static int flag=0; if(flag==0) {getmenuids(id,projids,4); flag=1;}
 proj_methode=(m==4)?0:m;
 menu_switch(id,projids,m-1,4,projtext,0,4);
 m_refresh();
}

void m_para()
{
 int ok;
 ok=requester_input(5,"Bildbreite","%.1lf cm","%lf",&para.bbreit,
		    "Bildhoehe","%.1lf cm","%lf\n",&para.bhoch,
		    " KartenMassstab ","1:%ld","1:%ld\n",&para.mass,
		    "alfa0 in Grad","%lf","%lf",&mittex,
		    "beta0 in Grad","%lf","%lf",&mittey);
 if(ok)
   {para.calc(); para.setpos();
    gmtdatenladen();
    m_refresh();
   }
}

void m_detai1()
{
 int ok,i;
 char antw[40]; strcpy(antw,"n");
 ok=requester_input(6,"Fluesse[0] (1...10,a,r,i,c)","%s","%s\n",c_riv[0],
		    "Fluesse[1] (1...10,a,r,i,c)","%s","%s\n",c_riv[1],
		    "Fluesse[2] (1...10,a,r,i,c)","%s","%s\n",c_riv[2],
		    "Fluesse[3] (1...10,a,r,i,c)","%s","%s\n",c_riv[3],
		    "Fluesse[4] (1...10,a,r,i,c)","%s","%s\n",c_riv[4],
		    "Erklaerungen (j/n)","%s","%s",antw);
 if(ok)
  {if(*antw=='j' || *antw=='J')
    janeinrequester("Fluesse: 1=Hauptfluesse 2-7=kleinere Fluesse\n\
8=HauptKanaele 9-10=kleinere Kanaele\n\
r=alle grossen Fluesse (1-4)\n\
i=alle kleinen Fluesse (5-7)\n\
c=alle Kanaele (8-10)\n\
a=alles (genaueres in \"man pscoast\" bei -I)");
   gmtdatenladen();
   m_refresh();
  }
}

void m_detai2()
{
 int ok,i;
 char antw[40]; strcpy(antw,"n");
 ok=requester_input(6,"Grenzen[0] (1...3,a)","%s","%s\n",c_bord[0],
		    "Grenzen[1] (1...3,a)","%s","%s\n",c_bord[1],
		    "Grenzen[2] (1...3,a)","%s","%s\n",c_bord[2],
		    "Grenzen[3] (1...3,a)","%s","%s\n",c_bord[3],
		    "Grenzen[4] (1...3,a)","%s","%s\n",c_bord[4],
		    "Erklaerungen (j/n)","%s","%s",antw);
 if(ok)
  {if(*antw=='j' || *antw=='J')
    janeinrequester("Grenzen: 1=Laender 2=Kantone 3=Grenzen im Meer\n\
a=alles (genaueres in \"man pscoast\" bei -N)");
   gmtdatenladen();
   m_refresh();
  }
}

void m_entfkar()
{
 int ok,k,i,i0,j,n;
 char *txt;
 char text[5][120],antw[5][40];
 j=geladen.getj();
 if(j==0) {janeinrequester("Es ist keine Karte geladen"); return;}
 for(i0=0;i0<j;i0+=5)
   {for(k=0,i=i0;i<j;k++,i++)
     {sprintf(text[k],"Karte \"%.80s\" entfernen ? (ja/nein)",geladen.get(i));
      strcpy(antw[k],"nein");
     }
    if(k==0) ok=0;
    else
      ok=requester_input(k,text[0],"%s","%s\n",antw[0],
			   text[1],"%s","%s\n",antw[1],
			   text[2],"%s","%s\n",antw[2],
			   text[3],"%s","%s\n",antw[3],
			   text[4],"%s","%s\n",antw[4]);
    if(ok)
      for(k=0,i=i0;i<j;k++,i++)
	{if(tolower(*antw[k])!='n') geladen.entfernen(i);}
   }
 m_refresh();
}

void m_entfgps()
{
 static char we[80]="S";
 static int nmax=10000;
 char art[80]="W";
 int ok,c;
 ok=requester_input(1,
   "zu enfernenden GPS-Daten (Wegpunkte, Tracks, Routen)","%s","%s",art);
 if(ok)
  {c=toupper(art[0]);
   if(c=='W')
    {ok=requester_input(2,
      "Welche Wegpunkte entfernen (Sichtbare Unsichtbare Alle)","%s","%s\n",we,
      "Maximale Anzahl","%d","%d",&nmax);
     if(ok)
	{c=toupper(we[0]);
	 karte.wegpunkteentfernen(c,nmax);
	}
    }
   else
      {janeinrequester("Kann bisher nur Wegpunkte entfernen");}//provi.
  }
 m_refresh();
}

static char *defaultfile=".gpskarte";

void m_save()
{
 int i,j;
 char name[160]; sprintf(name,"%s/%s",getenv("HOME"),defaultfile);
 FILE *fp=fopen(name,"w");
 if(fp==NULL) {printf("Error: cant create '%s'\n",name); return;}
 fprintf(fp,";Default-Einstellungen fuer gpskarte\n");
 fprintf(fp,"alfa0=%lf beta0=%lf massstab=%ld\n",mittex,mittey,para.mass);
 j=geladen.getj();
 for(i=0;i<j;i++)
   {if(strncmp(geladen.get(i),"tmp",3)!=0)
     fprintf(fp,"karte=\"%s\"\n",geladen.get(i));
   }
 fclose(fp);
}

void default_load()
{
 char zeile[200];
 int n;
 string wort[20],wert[20];
 char name[160]; sprintf(name,"%s/%s",getenv("HOME"),defaultfile);
 FILE *fp=fopen(name,"r");
 if(fp==NULL) return;
 while(getline(fp,zeile,200))
   {if(*zeile==';') continue;
    n=parser(zeile,wort,wert,20);
    if(n==0) continue;
    if(strcmp(wort[0],"alfa0")==0)
      {mittex=atof(wert[0]); mittey=atof(wert[1]); para.mass=atol(wert[2]);
       para.calc(); para.setpos();
      }
    else if(strcmp(wort[0],"karte")==0)
      {karte_laden(wert[0]);
      }
   }
 fclose(fp);
 gmtdatenladen();
 m_refresh();
}

void aktpos_erneuern()
{
 FILE *fp;
 int i,n;
 char zeile[160],r1[160],r2[160];
 double x,y;
 system2("gpspoint -n -p >%s",tmpdat);
 fp=fopen(tmpdat,"r");
 for(i=0,*zeile=0;i<10 && strncmp(zeile,"mode",4)!=0;i++)
    {getline(fp,zeile,160); n=sscanf(zeile,"%s %s",r1,r2);
     if(n==2 && strcmp(r1,"remove")==0) {system2("rm %s",r2);}
    }
 getline(fp,zeile,160);
 fclose(fp);
 if(sscanf(zeile,"latitude %lf longitude %lf",&y,&x)!=2)
   {printf("Kann GPS-Koordinaten nicht erhalten\n");//test
    aktposx=aktposy=0;
   }
 else
   {aktposx=x; aktposy=y;}
}

void aktpos_zeichnen(double x,double y)
{
 if(x==0 && y==0) return;
 projektion(x,y,&x,&y);
 if(x>=xmin+dx && x<=xmax-dx && y>=ymin+dx && y<=ymax-dx)
   {plot(x-dx,y-dx,PENUP); plot(x,y+2*dx,PENDOWN);
    plot(x+dx,y-dx,PENDOWN); plot(x-dx,y-dx,PENDOWN);
   }
}

void tracksaufteilen(char *name)
{
 char name1[200],zeile[160],trackname[80]="DEFAULT TRACK";
 char *startstring="type=\"track\" name=";
 int ns=strlen(startstring);
 FILE *fp,*fp2=NULL;
 fp=fopen(name,"r");
 int i;
 for(i=0;getline(fp,zeile,160);)
   {if(index(zeile,"ACTIVE LOG")>=0) break;
    if(strncmp(zeile,startstring,ns)==0) stringlesen(trackname,&zeile[ns]);
    if(index(zeile,"newsegment")>=0)
     {++i; sprintf(name1,"%s%d",name,i);
      if(fp2!=NULL) fclose(fp2);
      fp2=fopen(name1,"w");
      fprintf(fp2,"type=\"track\" name=\"%s\"\n",trackname);
      fprintf(fp2,"%s\n",zeile);
     }
    else if(fp2!=NULL)
     {fprintf(fp2,"%s\n",zeile);}
   }
 if(fp2!=NULL) fclose(fp2);
}

void routenaufteilen(char *name)
{
 char name1[200],zeile[160];
 FILE *fp,*fp2=NULL;
 fp=fopen(name,"r");
 int i;
 for(i=0;getline(fp,zeile,160);)
   {if(index(zeile,"routename")>=0)
     {++i; sprintf(name1,"%s%d",name,i);
      if(fp2!=NULL) fclose(fp2);
      fp2=fopen(name1,"w");
      fprintf(fp2,"%s\n",zeile);
     }
    else if(fp2!=NULL)
     {fprintf(fp2,"%s\n",zeile);}
   }
 if(fp2!=NULL) fclose(fp2);
}

int dateifilter(char *von,char *ziel,char *start,char *end,char *einsetzen)
{
 int n=0,k,k1,k2;
 FILE *fp1,*fp2;
 char zeile[400],zeile2[400];
 if(!(fp1=fopen(von,"r"))) return -1;
 if(!(fp2=fopen(ziel,"w"))) {fclose(fp1); return -1;}
 while(getline(fp1,zeile,400))
   {k=index(zeile,start);
    if(k>=0)
      {k1=k+strlen(start);
       k2=index(&zeile[k1],end);
       printf("k1=%d k2=%d zeile[k1]='%s'\n",k1,k2,&zeile[k1]);//test
       if(k2>=0)
	 {strcpy(zeile2,&zeile[k1+k2]);
	  printf("zeile2='%s'\n",zeile2);//test
	  sprintf(&zeile[k1],"%s%s",einsetzen,zeile2);
	  n++;
	 }
      }
    fprintf(fp2,"%s\n",zeile);
   }
 fclose(fp2); fclose(fp1);
 return n;
}
