/* abstest.cc				letzte Aenderung: 5.9.2007 */
/*
 Versucht eine ABS-Datei von WinFirst zu lesen
*/

#include <stdio.h>
#include <stdlib.h>

const int MAX=100;

#define MAXARG 1
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

int main(int argc,char *argv[])
{
 FILE *fp;
 char substanzname[MAX],*s,kennung[4],*quelle=NULL;
 int i,c,npkt,j;
 double x,dx,xmin,xmax;
 float y;
 for(j=0,i=1;i<argc;i++)
        {if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
         else   {if(++j==1) quelle=argv[i];
        }       }
 if(argflag['?'] || j>MAXARG)
   {printf("Anwendung: abstest [-flags] name.abs\n");
    printf("  flags: a=alle Daten zeigen\n");
    exit(0);
   }
 if(sizeof(float)!=4)
   {printf("Fehler: sizeof(float) = %d statt 4\n",(int)sizeof(float));
    printf("Da die Daten in ABS-Dateien in 4-Byte-Fliesszahlen gespeichert\n");
     printf("sind, wird ein entsprechender Fliesszahlentyp benoetigt.\n");
     printf("Moegliche Abhilfe: Compiler entsprechend konfigurieren,\n");
     printf("       oder statt float ein anderer Datentyp verwenden.\n");
    exit(0);
   }
 if((fp=fopen(quelle,"r"))==NULL)
   {printf("'%s' nicht gefunden.\n",quelle);
    exit(0);
   }
 i=0; //Zaehler fuer gelesen Bytes
 fread(kennung,1,4,fp); i+=4;
 for(c=0xAA,j=0;j<4;j++)
   {if((kennung[j]&0xFF)!=c)
      {printf("Kennung falsch - ist moeglicherweise keine IR-Datei\n"); break;}
    if(j==1) c=0x55;
   }
 for(;i<0x0006;i++) getc(fp); //Grenzen auslesen
 fread(&xmin,8,1,fp); i+=8;
 fread(&xmax,8,1,fp); i+=8;
 for(;i<0x00CA;i++) getc(fp);
 for(s=substanzname; ++i<0x00124 && (c=getc(fp))!=0 && c!=EOF;)  *s++ = c;
 *s=0;           
 printf("Komment: %s\n",substanzname);
 if(argflag['A']) printf("Bereich: %.9lg - %.9lg cm-1  ",xmin,xmax);
 else printf("Bereich: %.3lf - %.3lf cm-1  ",xmin,xmax);
 for(;i<0x0124;i++) getc(fp);
 fread(&x,8,1,fp); i+=8;
 if(argflag['A']) printf("Schrittweite = %lf\n",x);
 for(;i<0x012C;i++) getc(fp);
 npkt=getc(fp); i++;
 npkt += 256*getc(fp); i++;
 printf("Anzahl Messpunkte: %d\n",npkt);
 for(;i<0x0200;i++) getc(fp);
 dx=(xmax-xmin)/(npkt-1);
 for(j=0;j<npkt;j++)
   {fread(&y,4,1,fp);
    x=xmin+j*dx;
    if(argflag['A']) printf("%.9lg\t%.9g\n",x,y);
    else if(j<10 || j>npkt-10) printf("%.2lf  %.4f\n",x,y);
    else if(j==10) printf("...\n");
   }
 fclose(fp);
 return 0;
} /* end of main */
