/* abstest.c				letzte Aenderung: 4.9.2007 */
/*
 Versucht eine ABS-Datei von WinFirst zu lesen
*/

#include <stdio.h>
#include <stdlib.h>

const int MAX=100;

main(int argc,char *argv[])
{
 FILE *fp;
 char antw[20],substanzname[MAX],*s,kennung[4];
 int i,c,npkt,j;
 double x,dx,xmin,xmax;
 float y;
 if(argc!=2 || *argv[1]=='-' || *argv[1]=='?')
   {printf("Anwendung: abstest name.abs\n");
    exit(0);
   }
 if(sizeof(float)!=4)
   {printf("Fehler: sizeof(float) = %d statt 4\n",sizeof(float));
    printf("Da die Daten in ABS-Dateien in 4-Byte-Fliesszahlen gespeichert\n");
     printf("sind, wird ein entsprechender Fliesszahlentyp benoetigt.\n");
     printf("Moegliche Abhilfe: Compiler entsprechend konfigurieren,\n");
     printf("       oder statt float ein anderer Datentyp verwenden.\n");
    exit(0);
   }
 if((fp=fopen(argv[1],"r"))==NULL)
   {printf("'%s' nicht gefunden.\n",argv[1]);
    exit(0);
   }
 i=0; //Zaehler fuer gelesen Bytes
 fread(kennung,1,4,fp); i+=4;
 for(c=0xAA,j=0;j<4;j++)
   {if((kennung[j]&0xFF)!=c)
      {printf("Kennung falsch - ist moeglicherweise keine IR-Datei\n"); break;}
    if(j==1) c=0x55;
   }
 for(;i<0x0006;i++) getc(fp); //Grenzen auslesen
 fread(&xmin,8,1,fp); i+=8;
 fread(&xmax,8,1,fp); i+=8;
 for(;i<0x00CA;i++) getc(fp);
 for(s=substanzname; ++i<0x00124 && (c=getc(fp))!=0 && c!=EOF;)  *s++ = c;
 *s=0;           
 printf("Komment: %s\n",substanzname);
 printf("Bereich: %.3lf - %.3lf cm-1  ",xmin,xmax);
 for(;i<0x0124;i++) getc(fp);
 fread(&x,8,1,fp); i+=8;
 printf("Schrittweite = %lf\n",x);//test
 for(;i<0x012C;i++) getc(fp);
 npkt=getc(fp); i++;
 npkt += 256*getc(fp); i++;
 printf("Anzahl Messpunkte: %d\n",npkt);
 for(;i<0x0200;i++) getc(fp);
 dx=(xmax-xmin)/(npkt-1);
 for(j=0;j<npkt;j++)
   {fread(&y,4,1,fp);
    x=xmin+j*dx;
    if(j<10 || j>npkt-10) printf("%.2lf  %.4f\n",x,y);
    else if(j==10) printf("...\n");
   }
 fclose(fp);
} /* end of main */
