/* irlesen.cc					letzte Aenderung: 9.7.1996 */
/*
;AVAX> cx irlesen
;AVAX> BLINK IRSHOW,[PFISTER.OBJ]SHOWIT,XMENU,[PFISTER.IR]IRLESEN,LESEN2

History:
7.6.1994	Version 2.03
8.7.96		
8.7.96	 2.07	Lesen von SPC-Format (Bio-Rad FTIR) eingebaut
		dazu neue Datei "irlesen_spc.cc" erstellt.
		(auch Aenderungen in irshow.c)
*/
#define AVAX

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <ulong.h>
#ifdef unix
#undef AVAX
#endif
#include "irlesen.h"

extern char argflag[];
kopf_2 kopf2;
extern kopf_1 KOPFDA;

/*** Vordeklarationen ***/
void byteslesen(FILE *fp,char *s,int n);
void wordslesen10(FILE *fp,WORD *s);
void packedwordslesen10(FILE *fp,WORD *s);
void bytesschrei(FILE *fp,char *s,int n);
void wordsschrei10(FILE *fp,WORD *s);
void packedwordsschrei10(FILE *fp,WORD *s);
void byteslesen_alt(FILE *fp,char *s,int n);
void wordslesen10_alt(FILE *fp,WORD *s);
void kopfkopieren1(kopf_2 *k2,kopf_1 *k1);
void kopfkopieren2(kopf_2 *k2,kopf_1 *k1);
void lesen2_korr(WORD *feld,char *filename);
void read_word(FILE *fp,WORD *x);
void spc_lesen(char *acht,FILE *fp,WORD *feld,kopf_1 *kopf);
void unbek_float_copy(float *ziel,double x);
inline int ist_spc(char *format) {return (format[1]==0x4B);}
inline long idfix(double x) {return (long)(x<0.?(x-0.5):(x+0.5));}
inline void read_word(FILE *fp,UWORD *x) {read_word(fp,(WORD*)x);}
/******/

void lesen(WORD *feld,char *filename)
/** Einschraenkungen bei PE-Spektrometer:
	WORD *feld[32000]  filename[60]
**/
{
 FILE *fp;
 int i,j;
 char format[10];
 filename[59]=0;
 fp=fopen(filename,"r");
 if(fp==NULL)
   {printf("'%s' nicht gefunden\n",filename); lesen2(feld,filename); return;}
 byteslesen(fp,format,8); format[8]=0;
 if(strcmp(format,"IRTRANS2")==0)
  {byteslesen(fp,KOPFDA.snam,40); KOPFDA.snam[39]=0;
   wordslesen10(fp,(WORD*)&kopf2);
   kopfkopieren2(&kopf2,&KOPFDA);
   packedwordslesen10(NULL,NULL); /* auf Startwert setzen */
   for(i=0;i<KOPFDA.npkt;i+=10)  packedwordslesen10(fp,&feld[i]);
   fclose(fp);
  }
 else if(strcmp(format,"IRTRANS1")==0)
  {byteslesen_alt(fp,KOPFDA.snam,40); KOPFDA.snam[39]=0;
   wordslesen10_alt(fp,(WORD*)&kopf2);
   kopfkopieren2(&kopf2,&KOPFDA);
   for(i=0;i<KOPFDA.npkt;i+=10)  wordslesen10_alt(fp,&feld[i]);
   fclose(fp);
  }
 else if(ist_spc(format))
  {spc_lesen(format,fp,feld,&KOPFDA);
   fclose(fp);
  }
 else
  {fclose(fp);
   if(argflag['A']) lesen2_korr(feld,filename);
   else lesen2(feld,filename);
  }
}

void byteslesen(FILE *fp,char *s,int n)
{
 int i;
 for(i=0;i<n;i++)   *s++=getc(fp);
}

void wordslesen10(FILE *fp,WORD *s)       /* 10 Words lesen */
{
 int i,c,c2;
 for(i=0;i<10;i++)
   {c=getc(fp); c2=getc(fp); *s++=(c<<8)+(c2&0xFF);}
}

void packedwordslesen10(FILE *fp,WORD *s)       /* 10 gepackte Words lesen */
{
 char c,c2;
 static WORD ywert;
 int i;
 if(fp==NULL) {ywert=0; return;}
 for(i=0;i<10;i++)
   {c=getc(fp);
    if(c== -128) {c=getc(fp); c2=getc(fp); ywert=(c<<8)+(c2&0xFF);}
    else ywert+=c;
    *s++=ywert;
   }
 return;
}

void kopfkopieren2(kopf_2 *k2,kopf_1 *k1) /* kopf2 nach kopf1 kopieren */
{
 k1->start = k2->startH + (double)k2->startL/0x10000;
 k1->ende = k2->endeH + (double)k2->endeL/0x10000;
 k1->delta = k2->deltaH + (double)k2->deltaL/0x10000;
 k1->amode = k2->amodeH + (double)k2->amodeL/0x10000;
 k1->npkt=k2->npkt; k1->nmulti=k2->nmulti;
}

/******************* File speichern **********************/
void schrei(WORD *feld,char *filename)
{
 FILE *fp;
 int i,j;
 char format[10];
 filename[59]=0;
 fp=fopen(filename,"w");
 if(fp==NULL) {printf("Fehler beim oeffnen von '%s'\n",filename); return;}
 fprintf(fp,"IRTRANS2");
 KOPFDA.snam[39]=0; bytesschrei(fp,KOPFDA.snam,40);
 kopfkopieren1(&kopf2,&KOPFDA);
 wordsschrei10(fp,(WORD*)&kopf2);
 packedwordsschrei10(NULL,NULL); /* auf Startwert setzen */
 for(i=0;i<KOPFDA.npkt;i+=10)  packedwordsschrei10(fp,&feld[i]);
 fclose(fp);
}

void kopfkopieren1(kopf_2 *k2,kopf_1 *k1)	/* kopf1 nach kopf2 kopieren */
{
 UWORD h;
 k2->startH=h=int(k1->start); k2->startL=int((k1->start-h)*0x10000+0.5);
 k2->endeH=h=int(k1->ende); k2->endeL=int((k1->ende-h)*0x10000+0.5);
 k2->deltaH=h=int(k1->delta); k2->deltaL=int((k1->delta-h)*0x10000+0.5);
 k2->amodeH=h=int(k1->amode); k2->amodeL=int((k1->amode-h)*0x10000+0.5);
 k2->npkt=(int)k1->npkt; k2->nmulti=k1->nmulti;
}

void bytesschrei(FILE *fp,char *s,int n)
{
 int i;
 for(i=0;i<n;i++)   putc(*s++,fp);
}

void wordsschrei10(FILE *fp,WORD *s)       /* 10 Words speichern */
{
 int i,c,c2;
 for(i=0;i<10;i++)
   {putc(*s>>8,fp); putc(*s++,fp);}
}

void packedwordsschrei10(FILE *fp,WORD *s)  /* 10 gepackte Words speichern */
{
 WORD c;
 static WORD ywert;
 int i;
 if(fp==NULL) {ywert=0; return;}
 for(i=0;i<10;i++)
   {c= *s-ywert;
    if(c >= -127 && c<=127)  putc(c,fp);
    else	{putc(-128,fp); putc(*s>>8,fp); putc(*s,fp);}
    ywert= *s++;
   }
}

/******************* altes Format IRTRANS1 **********************/
#define CR 13
#define LF 10
#define SONDER 12  /* Sonderzeichen zur Darstellung von verbotenen Zeichen */
		   /* Der Atari macht aus einem LF ein CR LF. Beim Lesen   */
		   /* ignoriert er alle CRs.				   */

void byteslesen_alt(FILE *fp,char *s,int n)
{
 int i;
 char c;
 for(i=0;i<n;i++)
   {while((c=getc(fp))==CR)  ; /* Atari ignoriert CR beim lesen - wir auch. */
    if(c==SONDER) c+=getc(fp); /* statt <CR> steht <SONDER> <CR-SONDER>,
                                  statt <SONDER> steht <SONDER> <0>      */
    *s++=c;
   }
}

void wordslesen10_alt(FILE *fp,WORD *s)       /* 10 Words lesen */
{
 int i,c,c2,h;
 for(i=0;i<10;i++)
   {while((c=getc(fp))==CR)  ; /* alle CR ueberlesen */
    if(c==SONDER) c+=getc(fp);
    while((c2=getc(fp))==CR)  ;
    if(c2==SONDER) c2+=getc(fp);
    *s++=(c<<8)+(c2&0xFF);
   }
}

/******* Korrektur von sehr altem Fileformat (ab Version 2.03) ************/
static int daten_ok;

void read_word(FILE *fp,WORD *x)
{
 int c1,c2;
 c1=getc(fp)&0xFF; c2=getc(fp);
 *x=c1+(c2<<8);
}
int read_word_uns(FILE *fp,WORD *x)
{
 int c1,c2,uns;
 c1=getc(fp); c2=getc(fp);
 if(daten_ok)
	uns=0;
 else
        {if(c1!=0x0A) /* fehlendes 0A */
                {ungetc(c2,fp); c2=c1;
                 printf("Warnung: fehlendes 0x0A  c2=%02X\n",c2);
                 uns=0x80; c1=0x7F;
                }
         else if(c2==0x0A) {c1=c2; c2=getc(fp); uns=0;}
         else   {uns=0x80; c1=0x7F;}
        }
 *x=(c1&0xFF)+(c2<<8);
 return uns;
}
void read_float(FILE *fp,float *x)
{
 union {char c[4]; float z;} xu;
 xu.c[0]=getc(fp); xu.c[1]=getc(fp);
 xu.c[2]=getc(fp); xu.c[3]=getc(fp);
 *x=xu.z;
}
void read_lf(FILE *fp)
{
 int c;
 if(daten_ok) return;
 c=getc(fp);
 if(c!=0x0D)
	{printf("ERROR: c=%02X statt erwartetem 0D\n",c&0xFF);
	 ungetc(c,fp);
	}
}

void lesen2_korr(WORD *feld,char *filename)
{
/* Umsetzung von SUBROUTINE LESEN2(L,FNAM) */
/*	COMMON /KOPFDA/ SNAM,START,ENDE,DELTA,AMODE,NPKT,NMULTI
/*	{char snam[40]; float start,ende,delta,amode; WORD npkt,nmulti;} */
 FILE *fp;
 double a=4100.,b=170.;
 WORD *pf,*p,nix;
 long last;
 int i,j,c1,c2,uns;
 fp=fopen(filename,"r");
 if(fp==NULL) {printf("'%s' nicht gefunden\n",filename); return;}
 for(i=0;i<40;i++) KOPFDA.snam[i]=getc(fp);
 if(KOPFDA.snam[0]==0x0A)
	{daten_ok=0; KOPFDA.snam[0]='_';}/* verlorenes Zeichen ersetzen */
 else daten_ok=1;
 for(i=1;i<39;i++) if(KOPFDA.snam[i]==0x0D) break;
 KOPFDA.snam[i]=0;
 read_float(fp,&KOPFDA.start); read_float(fp,&KOPFDA.ende);
 read_float(fp,&KOPFDA.delta); read_float(fp,&KOPFDA.amode);
 read_word(fp,&KOPFDA.npkt); read_word(fp,&KOPFDA.nmulti);
 pf=feld; for(i=0;i<226;i++) read_word(fp,pf++);
 if(KOPFDA.start<b || KOPFDA.start>a ||
    KOPFDA.ende<b || KOPFDA.ende>KOPFDA.start) /* ganz altes Format */
   {printf(" ganz altes Fileformat (500Bytes/Record)\n");
    fclose(fp); fp=fopen(filename,"r");
    if(fp==NULL)
	{printf("ERROR: kann '%s' nicht wieder oeffnen\n",filename); return;}
    for(i=0;i<20;i++) KOPFDA.snam[i]=getc(fp);
    if(KOPFDA.snam[0]==0x0A) KOPFDA.snam[0]='_';/*verlorenes Zeichen ersetzen*/
    for(i=0;i<20;i++) if(KOPFDA.snam[i]<' ') KOPFDA.snam[i]=' ';
    for(;i<39;i++) KOPFDA.snam[i]=' ';
    KOPFDA.snam[i]=0;
    read_float(fp,&KOPFDA.start); read_float(fp,&KOPFDA.ende);
    read_float(fp,&KOPFDA.delta); read_float(fp,&KOPFDA.amode);
    read_word(fp,&KOPFDA.npkt); read_word(fp,&KOPFDA.nmulti);
    pf=feld; for(i=0;i<230;i++) read_word(fp,pf++);
    for(j=0;j<6;j++) read_word(fp,&nix); /* Rest des Records berlesen */
    for(i=231;i<=KOPFDA.npkt;i+=250)
	{p=pf;
	 last= *--pf; pf++;
	 read_lf(fp);
	 uns=read_word_uns(fp,pf++);
	 for(j=1;j<250;j++) read_word(fp,pf++);
	 for(j=0;j<6;j++) read_word(fp,&nix); /* Rest des Records berlesen */
	 if(uns) p[0]=(last+p[1])/2; /* erster Punkt des Records korrigieren */
	}
   }
 else
   {printf(" altes Fileformat (512Bytes/Record) ");
    if(daten_ok) printf(" Daten ok\n"); else printf(" Daten korrupt\n");
    for(i=227;i<=KOPFDA.npkt;i+=256)
	{p=pf;
	 last= *--pf; pf++;
	 read_lf(fp);
	 uns=read_word_uns(fp,pf++);
	 for(j=1;j<256;j++) read_word(fp,pf++);
	 if(uns) p[0]=(last+p[1])/2; /* erster Punkt des Records korrigieren */
	}
   }
 c1=getc(fp); c2=getc(fp);
 if((daten_ok && (c1!= -1 || c2!= -1))
    ||(daten_ok==0 && (c1!=0x0D || c2!=EOF)))
	printf("Ueberflssige Bytes an Dateiende: %02X %02X ??\n",c1,c2);
 fclose(fp);
}

#ifdef unix
/** zusammenbinden mit Fortran gibt zu viele Probleme **
extern "C"
void kopieren_(char *snam,float start,float ende,float delta,float amode,
	      short npkt,short nmulti)
{
 for(int i=0;i<40;i++) KOPFDA.snam[i]=snam[i];
 KOPFDA.start=start;
 KOPFDA.ende=ende;
 KOPFDA.delta=delta;
 KOPFDA.amode=amode;
 KOPFDA.npkt=npkt;
 KOPFDA.nmulti=nmulti;
}
**/
void lesen2(WORD *feld,char *filename)
{
 printf("'%s' ist zu altes Spektrum - kann unter UNIX nicht gelesen werden\n");
 printf(" Loesung: VAX/ALPHA verwenden\n");
}
#endif
