/* irlesen_spc.cc				letzte Aenderung: 1.9.1998 */
/*
;AVAX> cxx/float=ieee irlesen_spc
  Da das SPC-Format Fliesszahlen im IEEE-Format enthlt, muss dieser 
  Programmteil (irlesen_spc.cc) mit IEEE rechnen. Auf der VAX/ALPHA rechnen
  aber die andern Programmteile mit einem andern Fliesszahlenformat !

History:
8.7.96	 2.07	Lesen von SPC-Format (Bio-Rad FTIR) eingebaut
		(siehe auch irshow.c)
5.8.96		Lesen von Multidateien (class multidatei)
5.11.96		in kopfkopieren3() auf fehlende Klammern pruefen
1.9.98		Verbesserungen um Transmission-Dateien lesen zu koennen
*/
#define AVAX

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <ulong.h>
#ifdef unix
#undef AVAX
#endif
#include "irlesen.h"

extern kopf_1 KOPFDA;
static bool TRANSMISSION=0; //neu ab 1.9.98

inline double abs(double x) {return (x<0.)?(-x):x;}
inline long idfix(double x) {return (long)(x<0.?(x-0.5):(x+0.5));}
int parse_dateiende(FILE *fp,char *name,int defaultwert);

static void unbek_float_copy(float *ziel,double x)
{  //x ist im ieee-Format und soll nach ziel kopiert werden,
   //wobei ziel ein beliebig anderes Fliesszahlenformat sein kann.
 long y,z;
 z=(long)(log(abs(x)/2.0e9)+1.0); //Auf ganze Zahl aufgerundeter Exponent
 y=idfix(x/exp((double)z)); //Mantisse im Bereich 0.7e9 bis 2.0e9
 machfliesszahl(y,z,ziel); //Muss von externem Programmteil gemacht werden!
}

static void kopfkopieren3(kopf_3 *k3,kopf_1 *k1) //kopf3 nach kopf1 kopieren
{
 int i; char *s,*t;
 unbek_float_copy(&k1->start,k3->start);
 unbek_float_copy(&k1->ende, k3->ende);
 unbek_float_copy(&k1->delta,k3->delta);
 unbek_float_copy(&k1->amode,k3->amode);
 k1->npkt=k3->npkt;
 k1->nmulti=k3->nmulti;
 int imax=N40,kla=0,c;
 for(s=k3->snam,t=k1->snam,i=0;++i<imax;)
	{if((c= *s++)=='(') {kla++; imax--;}
	 else if(c==')' && kla>0) {kla--; imax++;}
	 *t++ = c;
	}
 while(kla>0) {--kla; *t++ = ')';} //fehlende Klammern einsetzen
 *t=0;
}

static double resol2amode(char *fres)
{
 double resol,x;
 int k;
 sscanf(fres,"%lf",&resol);
 for(k=11,x=8;x!=resol && x>=0.25;x/=2.0,k++) ;
 if(x<0.25) k=0;
 return (double)k;
}

/** von spctest.cc kopiert **/
#define DWORD LONG
#ifdef BYTE
#undef BYTE
#endif
#define BYTE unsigned char
#include "spc.h"
const double zweihoch32=4294967296.0, ln2=log(2.0); //minusln10= -log(10.0);

void getbytes(FILE *fp,long n,char *s,char *acht=NULL)
{
 if(acht!=NULL)
	{for(int i=0;i<8;i++) *s++ = *acht++;
	 n-=8;
	}
 while(--n>=0)  *s++ = getc(fp);
}

char *koordxtyp(int n)
{
 switch(n)
   {case XARB: return "Arbitrary";
    CASE XWAVEN: return "Wavenumber (cm-1)";
    CASE XUMETR: return "Micrometers";
    CASE XNMETR: return "Nanometers";
    CASE XSECS: return "Seconds";
    CASE XMINUTS: return "Minutes";
    CASE XHERTZ: return "Hertz";
    CASE XKHERTZ: return "Kilohertz";
    CASE XMHERTZ: return "Megahertz";
    CASE XMUNITS: return "Mass (M/z)";
    CASE XPPM: return "Parts per million";
    CASE XDAYS: return "Days";
    CASE XYEARS: return "Years";
    CASE XRAMANS: return "Raman Shift (cm-1)";
    CASE XDBLIGM: return "Double interferogram";
   }
 return "unbekannt";
}

char *koordytyp(int n)
{
 switch(n)
   {case YARB  : return "Arbitrary Intensity";
    CASE YIGRAM: return "Interferrogram";
    CASE YABSRB: return "Absorbance";
    CASE YKMONK: return "Kubelka-Monk";
    CASE YCOUNT: return "Counts";
    CASE YVOLTS: return "Volts";
    CASE YDEGRS: return "Degrees";
    CASE YAMPS : return "milliamps";
    CASE YMETERS: return "millimeters";
    CASE YMVOLTS: return "millivolts";
    CASE YLOGDR: return "Log (1/R)";
    CASE YPERCNT: return "Percent";
    CASE YTRANS: return "Transmission";
    CASE YREFLEC: return "Reflectance";
    CASE YVALLEY: return "Arbitrary or Single Beam with Valley Peaks";
   }
 return "unbekannt";
}

char *koordztyp(int n)
{
 switch(n)
   {case YARB  : return "Arbitrary Intensity";
    CASE YIGRAM: return "Interferrogram";
   }
 return "unbekannt";
}

void liesdatum(long fdate,int *std,int *min,int *tag,int *monat,int *jahr)
{
 *jahr= (fdate>>20)&0x0FFF;
 *monat=(fdate>>16)&0x0F;
 *tag = (fdate>>11)&0x1F;
 *std = (fdate>>6)&0x1F;
 *min = (fdate)&0x3F;
}

void werte_kopieren(FILE *fp,long n,WORD *feld)
{
 SUBHDR hs;
 float x;
 LONG y;
 double ywert,yfakt,y2;
 long i;
 if(feld==NULL)
   {for(i=0;i<n;i++)
	getbytes(fp,sizeof(float),(char*)&x);
   }
 else
   {getbytes(fp,sizeof(SUBHDR),(char*)&hs);
    yfakt=exp(ln2*hs.subexp)/zweihoch32;
    for(i=0;i<n;i++)
	{getbytes(fp,sizeof(LONG),(char*)&y);
	 if(TRANSMISSION)
		{y2 = yfakt*y*200.0;
		 if(y2>32000.) y2=32000.;
		 else if(y2<-32000.) y2= -32000.;
		 *feld++ = (WORD)(y2+0.5);
		}
	 else	*feld++ = (WORD)(exp(minusln10*yfakt*y)*20000.0+0.5);
	}
   }
}

void spc_lesen(char *acht,FILE *fp,WORD *feld,kopf_1 *kopf1)
{
 kopf_3 kopf;
 SPCHDR he;
 int std,min,tag,monat,jahr;
 getbytes(fp,sizeof(SPCHDR),(char*)&he,acht);
 if(he.ftflgs)
       {printf("ftflgs=%02X\n",he.ftflgs);
	if(he.ftflgs&TMULTI)
	 printf("Dies ist eine Multi-Spektren-Datei (%d Subfiles)\n",he.fnsub);
       }
/*Testausdrucke:
 printf("'%s'\n",he.fcmnt);//test (Kommentarstring)
 printf("Start=%lf Ende=%lf   Anzahl Messpunkte = %ld  (Step=%lf)\n",
	he.ffirst,he.flast,he.fnpts,(he.flast-he.ffirst)/(he.fnpts-1));//test
 printf("Resolution = %s\n",he.fres);//test
 liesdatum(he.fdate,&std,&min,&tag,&monat,&jahr);//test
 printf("Date = %d.%d.%d  %d:%02d\n",tag,monat,jahr,std,min);//test
 printf("fsource='%s'\n",he.fsource);//test
 printf("x-Koordinate ist %s\n",koordxtyp(he.fxtype));//test
 printf("y-Koordinate ist %s\n",koordytyp(he.fytype));//test
 printf("z-Koordinate ist %s\n",koordztyp(he.fztype));//test
/*:Ende Testausdrucke*/
 TRANSMISSION=(he.fytype==YTRANS);
 strcpy(kopf.snam,he.fcmnt);
 kopf.start=he.ffirst; kopf.ende=he.flast;
 kopf.delta=(he.flast-he.ffirst)/(he.fnpts-1);
 kopf.amode=resol2amode(he.fres);
 kopf.npkt=he.fnpts;
 kopf.datum=he.fdate;
 if(he.ftflgs&TXYXYS) //zuerst SUBHDR dann xwerte
   {printf("TXYXYS-Modus noch nicht implementiert\n"); return;}
 if(he.ftflgs&TXVALS)
   {werte_kopieren(fp,he.fnpts,NULL); //x-Werte ueberlesen
   }
 werte_kopieren(fp,he.fnpts,feld);
 if(he.ftflgs&TMULTI) //provi.
   {printf("Um alle Spektren der Multi-Datei zu laden: Menu File->Load\n");}
 kopf.nmulti=parse_dateiende(fp,"Scans_per_scanset",1);
 kopfkopieren3(&kopf,kopf1);
}

int parse_dateiende(FILE *fp,char *name,int defaultwert)
{
 int result=defaultwert,c,c2,i;
 char str[80],*s,*s2;
 while((c=getc(fp))!=EOF)
   {if(c== *name && (c2=getc(fp))==name[1])
      {s=str; *s++ = c; *s++ = c2; s2=NULL;
       for(i=3; i<80 && (c=getc(fp))!=EOF && c>=' '; i++)
	  {if(c=='=') {*s++ = 0; s2=s;}
	   else *s++ = c;
	  }
       *s=0;
       if(s2!=NULL && strcmp(name,str)==0)
	 {sscanf(s2,"%d",&result); return result;}
      }
   }
 return result;
}

/****************** Lesen von Multidateien *********************/
class multidatei
{
 int nsub,nz,erstes_schon_geladen;
 SPCHDR he;
public:
 char muname[200];
 FILE *mufp;
 multidatei() {nsub=nz=erstes_schon_geladen=0; *muname=0; mufp=NULL;}
 int open(char *s,const char *t,int *j);
 void read(WORD *feld);
 void getname(char *s) {strcpy(s,muname);}
 void close() {if(mufp) fclose(mufp); mufp=NULL; nsub=0; clear_muname();}
 void clear_muname();
};
static multidatei mudat;

int istmultifile(char *s) {return mudat.open(s,NULL,NULL);}
int multifile_open(int *j,char *s,char *t) {return mudat.open(s,t,j);}
void multifile_name(char *s) {mudat.getname(s);}
void multifile_lesen(WORD *feld) {mudat.read(feld);}
void multifile_close() {mudat.close();}

int multidatei::open(char *name,const char *erstername,int *subnr)
{
 if(mufp) //schon offen
   {erstes_schon_geladen=(strcmp(muname,erstername)==0);
    *subnr = erstes_schon_geladen?1:0;
    return nsub - *subnr;
   }
 if(!hatpunkt(name)) sprintf(muname,"%s.spc",name);
 else strcpy(muname,name);
 if(mufp=super_fopen(muname,"r"))
    {getbytes(mufp,sizeof(SPCHDR),(char*)&he);
     if((he.fversn!=0x4B && he.fversn!=0x4C) || (he.ftflgs&TMULTI)==0)
       {fclose(mufp); mufp=NULL; nsub=0;}
     else nsub=he.fnsub;//n=Anzahl Subfiles
    }
 else nsub=0;
 if(nsub==0) clear_muname();
 nz=0;
 return nsub;
}

void multidatei::clear_muname()
{
 strcpy(muname,"multifile_not_open");
}

void multidatei::read(WORD *feld)
{
 kopf_1 *kopf1= &KOPFDA;
 kopf_3 kopf;
 int i,imax=1;
 if(erstes_schon_geladen) {imax=2; erstes_schon_geladen=0;}
 for(i=0;i<imax;i++)
 {++nz;
  if(nz>nsub) printf("ERROR-Multifile: nur %d Subfiles vorhanden\n",nsub);
  if(nz==1)
    {strcpy(kopf.snam,he.fcmnt);
     kopf.start=he.ffirst; kopf.ende=he.flast;
     kopf.delta=(he.flast-he.ffirst)/(he.fnpts-1);
     kopf.amode=resol2amode(he.fres);
     kopf.npkt=he.fnpts;
     kopf.datum=he.fdate;
     kopf.nmulti=1; //parse_dateiende(fp,"Scans_per_scanset",1);
     kopfkopieren3(&kopf,kopf1);
   }
  if(he.ftflgs&TXYXYS) //zuerst SUBHDR dann xwerte
    {printf("TXYXYS-Modus noch nicht implementiert\n"); return;}
  if(he.ftflgs&TXVALS)
    {werte_kopieren(mufp,he.fnpts,NULL);} //x-Werte ueberlesen
  werte_kopieren(mufp,he.fnpts,feld);
 }
}
