/* irshow.cc				letzte Aenderung: 5.8.1996 */
static char *VERSION="2.08";
/*
;AVAX> cx irshow
;AVAX> BLINK IRSHOW,[PFISTER.OBJ]SHOWIT,XMENU,[PFISTER.IR]IRLESEN,LESEN2
;AVAX> pur irshow.exe

History:
ca 1991		Erstellung (RPf)
9.11.1994	VERSION 2.04
15.6.95	V2.05	Fehler in file_load korrigiert,
		neue Bemerkungseingabe in file_save,
		Beschriftung im 'mehrere-Kurven-Modus' verbessert
21.6.95  2.06	Darstellung von Epsilonwerten eingebaut
8.7.96	 2.07	Lesen von SPC-Format (Bio-Rad FTIR) eingebaut
		Entschluesselung von Mode um wahre Aufloesung zu ermitteln
		Spektrum von SPC-Datei bekommt Mode >= 11
		gleichzeitig Vorbereitung fuer Anpassung an UNIX
10.7.96		mehrere_files_laden() eingebaut.
12.7.96		bei AUTOPLOT bild.tmp auf bessern Name umbenennen.
24.7.96	 2.08	Anpassung an UNIX
5.8.96		Einlesen von (SPC-)Multifiles
30.4.97		Behebung des Problems mit dem Fadenkreuz in showit.cc
*/
#define AVAX

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <ulong.h>
#ifdef unix
#undef AVAX
#define FILE_NAMES_CASE_SENSITIV
#endif
#ifdef AVAX
#include "h:showit.h"
#else
#include <showit.h>
#endif
#include "irlesen.h"

#define MAXF 40000
#define INTEGRAL 1
#define PEAK	 2
#define MAXSPEKT 15
#define MAXSPE 200

/*********************** Vordeklarationen ********************************/
void feldalloc(int n,float **feld,float **hfeld);
void einlesen(short *lfeld,char *fnam,float *yfeld,char *spename,int flg=0);
void grenz(short *lfeld,int n);
char *machgross(char *s);
void abspeichern(short *lfeld,char *fnam,float *yfeld);
void file_oeffnen(char *name);
void anhaengen(char *str,char *s,int max);
void anhaengen2(char *str,char *s,int max);
void error(int n);
#define CANT_OPEN_NEW_FILE 1
#define ZU_WENIG_RAM 2
int istvorhanden(char *name);
void zeilelesen(char *str,int max);
void snamkopieren(char *von);
double getresolution(int mode);
void sprintf_titel(char *spename,char *fname);
void fprintf_titel(FILE *fp);
/*int exor(int a,int b);*/
void mehrere_files_laden(char *name,int flag);
void ohnepunkt(char *s);

/************************* globale Parameter *****************************/
char argflag['Z'+1];
setargflags(char *s)
{int c; while(c= *s++) if((c=toupper(c))<='Z') argflag[c]=1;}
/** schon in irlesen.h definiert:
typedef struct
  {char snam[40]; float start,ende,delta,amode; UWORD npkt,nmulti;} kopf_1;
**/
kopf_1	KOPFDA;
static short lfeld[MAXF];
static float *hauptfeld=NULL,*hilfsfeld=NULL;
static int odflag,titel=0,npkt=0;
static FILE *fp=NULL;
static char filename[80],spename[MAXSPE],spename2[MAXSPE];
typedef char STRING[120];
STRING substanzname[MAXSPEKT];
typedef char STRING80[80];
STRING80 fname2[MAXSPEKT-1],sname[MAXSPEKT];
static double ymin=0., ymax=1., x,dx,y, konz=0.;
static int modus=2;
static int ntesspektrum=3, sname_i=0;
int PEflag=1;/* nur Perkin-Elmer-Spektren haben kleinere Auflsung ber 2000 */
#define VERTAUSCHE(x,y) h=x; x=y; y=h

#define subflag argflag['N']
#define reversflag argflag['R']

main(int argc,char *argv[])
{
 float xmini,ymini,xmaxi,ymaxi,h;
 int i,j,c;
 float *yfeld,*yfeld2;
 for(*filename= *fname2[0]=0,i=j=1;i<argc;i++)
   if(*argv[i]=='-') setargflags(argv[i]);
   else switch(j++)
	{case 1:strcpy(filename,argv[i]); break;
	 case 2:strcpy(fname2[0],argv[i]); break;
         default:break;
        }
 if(*filename==0) {printf("File:"); scanf("%s",filename); getc(stdin);}
 if(filename[0]=='?' || argc>4 || argflag['?'])
	{printf(" IRSHOW Version %s\n",VERSION);
	 printf("Aufruf: IRSHOW File1 [File2] [-Flags]\n");
	 printf("   Flags: T=Transmission  E=Epsilon   sonst OD\n");
	 printf("          N=Nulliniekorrektur: File2 wird subtrahiert\n");
	 printf("          R=Rueckwaerts darstellen\n");
	 printf("          A=Altes Format korrigiert lesen\n");
	 printf("          P=Postscriptbild speichern, dann exit\n");
	 printf("          D=Debugger\n");
	 exit(0);
	}
 if(argflag['T']) odflag=0; else odflag=1;
 if(!istvorhanden(filename)) exit(0);
 if(*fname2[0]!=0 && istvorhanden(fname2[0]))
	{feldalloc(MAXF,&hauptfeld,&hilfsfeld);
	 yfeld=hauptfeld; yfeld2=hilfsfeld;
	 sname_i=1;
	 einlesen(lfeld,fname2[0],yfeld2,spename2);
	 modus=4;
	}
 else	{feldalloc(MAXF,&hauptfeld,NULL);
	 ntesspektrum=2;
	 yfeld=hauptfeld; yfeld2=hilfsfeld;
	}
 sname_i=0;
 einlesen(lfeld,filename,yfeld,spename);
 if(modus==4) sname_i=2;
 if(subflag && *fname2[0]!=0)
	{for(i=0;i<npkt;i++) yfeld2[i]=yfeld[i]-=yfeld2[i];
	 modus=2; sname_i=1;
	 ntesspektrum=2;
	}
 xmini=KOPFDA.start; ymini=ymin; xmaxi=KOPFDA.ende; ymaxi=ymax;
 if(argflag['P']) modus+=AUTOPLOTEXIT;
 if(reversflag)
	{for(i=0,j=npkt-1;i<j;i++,j--)
		{VERTAUSCHE(yfeld[i],yfeld[j]);
		 if(yfeld2!=NULL) {VERTAUSCHE(yfeld2[i],yfeld2[j]);}
		}
	 showit(&xmaxi,&ymini,&xmini,&ymaxi,&npkt,&modus,yfeld,yfeld2);
	}
 else	showit(&xmini,&ymini,&xmaxi,&ymaxi,&npkt,&modus,yfeld,yfeld2);
} /* ende von main */

void einlesen(short *lfeld,char *fnam,float *yfeld,char *spename,int flg)
{
 int i,j;
 double ymimi;
 int revflag=0;/*provi.*/
 if(argflag['D']) printf("einlesen(lfeld,'%s',yfeld,spenam)\n",fnam);/*test*/
 if(flg) multifile_lesen(lfeld);
 else    lesen(lfeld,fnam);
 grenz(lfeld,KOPFDA.npkt);
/** die Bezeichnung "Aufloesung" war falsch, "Schrittweite" waere besser:
 sprintf(spename,"%s\n%.40s\nvon %.1lf bis %.1lf  Aufloesung %.2lf\n\
%d Messpunkte  Mode=%.1lf\n",
	machgross(fnam),KOPFDA.snam,KOPFDA.start,KOPFDA.ende,KOPFDA.delta,
	KOPFDA.npkt,KOPFDA.amode);
**/
#ifdef AVAX
 sprintf_titel(spename,machgross(fnam));
#else
 sprintf_titel(spename,fnam);
#endif
 if(!flg) printf(spename);
 snamkopieren(KOPFDA.snam);
 if(argflag['E'] && !flg)
	{double d;
	 printf("Konzentration in mol/l:"); scanf("%lf",&konz);
	 printf(" Schichtdicke  in  cm :"); scanf("%lf",&d);
	 konz *= d;
	}
 if(KOPFDA.amode>=11.)
	{float h;
	 PEflag=0; dx=KOPFDA.delta; revflag=1;
	 h=KOPFDA.start; KOPFDA.start=KOPFDA.ende; KOPFDA.ende=h;
	}/*provi.*/
 else	dx=KOPFDA.delta/2.;
 for(ymin=0,ymax=1,j=i=0,x=KOPFDA.start;i<KOPFDA.npkt;i++,j++,x-=dx)
	{int k;/* neu ab Version 2.07 */
	 if(revflag) k=KOPFDA.npkt-1-i; else k=i; /*provi.*/
	 if(j>=MAXF) {printf("Fehler: Feld ueberfuellt\n"); j=0;}
	 if(odflag)	{y = -log10((double)lfeld[k]/20000.);
			 if(argflag['E'] && konz!=0.)
				y /= konz;
			}
	 else		y = lfeld[k]/200.;
	 yfeld[j]=y;
	 if(PEflag && x>2000.) {x-=dx; yfeld[++j]=y;}
	 if(yfeld[j]<ymin) ymin=yfeld[j];
	 if(yfeld[j]>ymax) ymax=yfeld[j];
	}
 if(ymin>(ymimi= -ymax/35.)) ymin=ymimi;
 if(!flg) printf("ymin=%lf  ymax=%lf\n",ymin,ymax);
 if(npkt==0) npkt=j;
}

void grenz(short *lfeld,int n)		/* auf 1/20000 % begrenzen */
{
 int i;
 for(i=0;i<n;i++) {if(lfeld[i]<=0) lfeld[i]=1;}
}

char *machgross(char *s)
{
 char *t=s; int c;
 while(c= *t)  *t++ = toupper(c);
 return s;
}

void abspeichern(short *lfeld,char *fnam,float *yfeld)
{
 int i,j,c0;
 dx=KOPFDA.delta/2.;
 if(argflag['E'])
	{printf("alte Konzent. * Schichtdicke :%lg\n",konz);
	 printf("Konzentration * Schichtdicke :"); scanf("%lf",&konz);
	}
 if(KOPFDA.amode>=11.) {PEflag=0; dx=KOPFDA.delta;}/*provi.*/
 for(j=i=0,x=KOPFDA.start;i<KOPFDA.npkt;i++,j++,x-=dx)
	{if(odflag)	{if(argflag['E'] && konz!=0.)
				y = pow(10.,-yfeld[j]*konz)*20000.;
			 else	y = pow(10.,-yfeld[j])*20000.;
			}
	 else		y = yfeld[j]*200.;
	 if((y+=0.5)<1.0) y=1.0;
	 lfeld[i]=(short)y;
	 if(PEflag && x>2000.) {x-=dx; ++j;}
	}
/* neu ab 2.05: */
 c0= *KOPFDA.snam;
 printf("alte Bemerkungen:%.40s\n",KOPFDA.snam);
 printf("                                                        |\n");
 do {printf("Neue Bemerkungen:"); zeilelesen(KOPFDA.snam,40);}
 while(*KOPFDA.snam==0 && ntesspektrum>2);
 if(*KOPFDA.snam==0) *KOPFDA.snam=c0;
/* :neu ab 2.05 */
 schrei(lfeld,fnam);
}

void file_exit()
{
 if(argflag['P'])
	{char str[120],*tmpname;
	 if(!(tmpname=getenv("PLOTSAVE"))) tmpname="bild.tmp";
	 ohnepunkt(filename);
	 sprintf(str,"ren %s %s.ps",tmpname,filename);
	 system(str);
	}
 exit(1);
}

void file_load()
{
 lower_window();
 if(argflag['D']) printf("file_load() ntesspektrum=%d\n",ntesspektrum);/*test*/
 if(ntesspektrum>MAXSPEKT)
        printf("Anzahl Spektren auf %d beschrnkt\n",MAXSPEKT);
 else
  {int ntes2=ntesspektrum-2,flag=0;
   printf("%d. Spektrum laden\n",ntesspektrum);
   printf(" File:"); scanf("%s",fname2[ntes2]);
   if(fname2[ntes2][0]=='@' || (flag=istmultifile(fname2[ntes2])))
	mehrere_files_laden(&fname2[ntes2][1],flag);
   else if(istvorhanden(fname2[ntes2]))
	{if(hilfsfeld==NULL) feldalloc(MAXF,NULL,&hilfsfeld);
	 if(argflag['D']) printf(" ntes2=%d\n",ntes2);/*test*/
	 sname_i=ntes2+1;
	 einlesen(lfeld,fname2[ntes2],&hilfsfeld[ntes2*npkt],spename2);
	 modus=4; if(ntesspektrum>2) modus+=ntesspektrum;
	 new_hfeld(hilfsfeld,&modus);
	 ntesspektrum++;
	}
  }
 raise_window();
 refresh();
}

void file_save()
{
 char antw[80],c;
 lower_window();
 printf("Speichern unter '%s' ?",filename); scanf("%s",antw);
 if((c=toupper(antw[0]))=='N')
	{printf("Filename:"); scanf("%s",filename);}
 else if(c!='J')
	strcpy(filename,antw);
 printf("Saving '%s'\n",filename);
 abspeichern(lfeld,filename,hauptfeld);
 raise_window();
}

/*************** Funktionen die von user_prog aufgerufen werden **********/
char *ODeps()
{
 if(argflag['E'] && konz!=0.) return "Epsilon";
 return "OD";
}

void int_save(float *z,float *xspitz,float *yspitz,float *grenz)
//float *z,*xspitz,*yspitz,grenz[4];
{
 static double od;
 char *eps=ODeps();
 if(odflag)	od= *yspitz;
 else		od= -log10(*yspitz/100.);
 printf("%7.2lf bis %7.2lfcm-1  Integral=%lf  Maximum: %7.2lf cm-1  %s=%7.5lf\n",
	grenz[0],grenz[2],*z,*xspitz,eps,od);
 if(fp==NULL) file_oeffnen("peak.dat");
 if(titel!=INTEGRAL)
  {fprintf(fp," Integrierter Bereich      Integral     Spitze        %s\n",eps);
   titel=INTEGRAL;
  }
 fprintf(fp,"%7.2lf bis %7.2lfcm-1    %lf    %7.2lfcm-1    %7.5lf\n",
	grenz[0],grenz[2],*z,*xspitz,od);
}

void get_punkt(float *x,float *y)
{
 static double od,proz;
 char *eps=ODeps();
 if(odflag)	{od= *y;
		 if(argflag['E'] && konz!=0.)
			proz=100.*pow(10.,-od*konz);
		 else	proz=100.*pow(10.,-*y);
		}
 else		{od= -log10(*y/100.); proz= *y;}
 printf("Peak: %7.2lf cm-1   %s=%7.5lf  Transmission=%7.3lf %%\n",*x,eps,od,proz);
 if(fp==NULL) file_oeffnen("peak.dat");
 if(titel!=PEAK)
  {fprintf(fp,"   Peak        %s         Transmission\n",eps);
   titel=PEAK;
  }
 fprintf(fp,"%7.2lf cm-1   %7.5lf   %7.3lf %%\n",*x,od,proz);
}

int rac(char *s)
{
 if(s==NULL || *s==0) return 0;
 while(*++s) ;
 return *--s;
}

void texteladen(char **titel,char **xachse,char **yachse)
{
 KOPFDA.snam[39]=0;
 if(modus<=4)
	*titel=spename;
 else	{int max,i; char *str,*t,*s;
	 str=(char*)calloc(max=strlen(spename)+(ntesspektrum-1)*80+1,1);
	 if(str==NULL) error(ZU_WENIG_RAM);
	 for(t=str,s=spename;(i = *t++ = *s++)&& i!='\n' && i!='\r';) ;
	 *--t=0;
	 if(*--t<' ') *t=0; /* ab 2.05 hinter Dateiname noch sname haengen */
	 anhaengen2(str,sname[0],max);
	 for(i=2;i<ntesspektrum;i++)
		{anhaengen(str,fname2[i-2],max);
		 anhaengen2(str,sname[i-1],max);
		/* if(rac(str)!='\n') anhaengen(str,"\n",max);/* warum ?*/
		}
	 *titel=str;
	}
 *xachse="$Wellenzahl/cm^{-1}";
 if(odflag)
   {if(argflag['E'] && konz!=0.)
		*yachse="Epsilon";
    else	*yachse="OD";
   }
 else		*yachse="Transmission";
}

void user_prog(int *fun,POINTER p1,POINTER p2,POINTER p3,POINTER p4)
{
 switch(*fun)
  {case 1: case 2: int_save((float*)p1,(float*)p2,(float*)p3,(float*)p4); break;
   case 3: case 4: get_punkt((float*)p1,(float*)p2); break;
   case 5: texteladen((char**)p1,(char**)p2,(char**)p3); break;
  }
}

void file_oeffnen(char *name)
{
 if((fp=fopen(name,"w"))==NULL) {error(CANT_OPEN_NEW_FILE); return;}
 fprintf_titel(fp);
 fprintf(fp,"%d Messpunkte  Mode=%.1lf\n\n",KOPFDA.npkt,KOPFDA.amode);
}

/************************ ab Version 2.04 ********************************/
void feldalloc(int n,float **feld,float **hfeld)
{
 if(feld!=NULL)
  {if(*feld!=NULL) cfree(*feld);
   *feld=(float*)calloc(n,sizeof(float));
   if(*feld==NULL) error(ZU_WENIG_RAM);
  }
 if(hfeld!=NULL)
  {if(*hfeld!=NULL) cfree(*hfeld);
   *hfeld=(float*)calloc((MAXSPEKT-1)*n,sizeof(float));
   if(*hfeld==NULL) error(ZU_WENIG_RAM);
  }
/* feldgroesse=n; */
}

void anhaengen(char *str,char *s,int max)
{
 char *t;
 int i;
 if(s==NULL) return;
 for(i=1,t=str;*t!=0;t++,i++) ;
 if(++i<max) *t++ = '\n';
 while(++i<max && (*t++ = *s++)) ;
 if(i>=max) *t=0;
}
void anhaengen2(char *str,char *s,int max)
{
 char *t;
 int i;
 if(s==NULL) return;
 for(i=1,t=str;*t!=0;t++,i++) ;
 if(++i<max) *t++ = ' ';
 if(++i<max) *t++ = ' ';
 while(++i<max && (*t++ = *s++)) ;
 if(i>=max) *t=0;
}

void error(int n)
{
 switch(n)
  {case ZU_WENIG_RAM: printf("ERROR: zu wenig RAM\n"); exit(n);
   case CANT_OPEN_NEW_FILE: printf("ERROR: cant open new file\n"); return;
   default: printf("ERROR: %d\n",n); exit(0);
  }
}

int hatpunkt(char *s)
{
 int c;
 while(c= *s++) if(c=='.') return 1;
 return 0;
}
void ohnepunkt(char *s)
{
 while(*s && *s!='.') s++;
 *s=0;
}

FILE *super_fopen(char *name,char *zugriff)
{
 FILE *fp;
 char *liste[]={".ir",".irx",".spc",NULL}, **s;
#ifdef FILE_NAMES_CASE_SENSITIV
 for(int j=0;j<2;j++)
 {
#endif
  if(fp=fopen(name,zugriff)) return fp;
  if(!hatpunkt(name))
    for(s=liste;*s!=NULL;s++)
	{strcat(name,*s);
	 if(fp=fopen(name,zugriff)) return fp;
	 ohnepunkt(name);
	}
#ifdef FILE_NAMES_CASE_SENSITIV
  machgross(name);
  for(s=liste;*s!=NULL;s++) machgross(*s);
 }
#endif
 return NULL;
}

int istvorhanden(char *name)
{
 FILE *fp;
 fp=super_fopen(name,"r");
 if(fp==NULL) {printf("'%s' nicht gefunden\n",name); return 0;}
 fclose(fp);
 return 1;
}

/************************ ab Version 2.05 ********************************/
void zeilelesen(char *str,int max)
{
 int c;
 if((c=getc(stdin))=='\n') c=getc(stdin);
 while(c!='\n' && --max) {*str++=c; c=getc(stdin);}
 *str=0;
 while(c!='\n') c=getc(stdin);
}

void snamkopieren(char *von)
{
 char *s;
 int i,c;
 s=sname[sname_i++];
 for(i=0;i<40 && (c= *von++);i++)  *s++ = c;
 *s=0;
}

/************************ ab Version 2.07 ********************************/
/*
MODE	Slit /cm-1	Noise
------------------------------
1	6.8		0.02
2	5.3		0.03
3	3.0		0.1
4	2.3		0.3
5	1.8		0.4
6	1.4		0.8
7	0.85		1.5
8	0.7		3
9	0.5		6
10	0.4		12
11..16	8..0.25  Bio-Rad-FTIR
*/
static double mode2resol[]=
	{0., /* 0 ist ungltiger Modus */
	 6.8,5.3,3.0,2.3,1.8,1.4,0.85,0.7,0.5,0.4, /* Moden von PE */
	 8,4,2,1,0.5,0.25, /* neue Moden von FTIR */
	 0.
	};

double getresolution(int mode)
{
 return mode2resol[mode];
}

void sprintf_titel(char *spename,char *fname)
{
 double resol=getresolution((int)KOPFDA.amode);
 if(KOPFDA.delta==0.)/*test*/
	{printf("Fehler in KOPFDA: delta nicht gesetzt\n");
	 KOPFDA.delta=(KOPFDA.ende-KOPFDA.start)/(KOPFDA.npkt-1);
	}
 if(KOPFDA.amode<11.) /* Perkin-Elmer ? */
  {sprintf(spename,"%s\n%.40s\nvon %.1lf bis %.1lf  Step=%.2lf Resol.=%.2lf\n\
%d Messpunkte  Mode=%.1lf\n",
	fname,KOPFDA.snam,KOPFDA.start,KOPFDA.ende,KOPFDA.delta,resol,
	KOPFDA.npkt,KOPFDA.amode);
   if(KOPFDA.nmulti!=1)
	{char str[80];
	 sprintf(str,"Multiscan: %d\n",KOPFDA.nmulti);
	 anhaengen(spename,str,MAXSPE);
  }	}
 else /* Bio-Rad-FTIR Spektren brauchen leicht andere Beschriftung */
  sprintf(spename,"%s\n%.40s\nvon %.2lf bis %.2lf  Resol.=%.2lf\n\
%d Messpunkte  %d Scans  Step=%.4lf\n",
	fname,KOPFDA.snam,KOPFDA.start,KOPFDA.ende,resol,
	KOPFDA.npkt,KOPFDA.nmulti,KOPFDA.delta);
}

void fprintf_titel(FILE *fp)
{
 double resol=getresolution((int)KOPFDA.amode);
 if(KOPFDA.amode<11.) /* Perkin-Elmer ? */
  {fprintf(fp,"%.40s\nvon %.1lf bis %.1lf  Step=%.2lf Resol.=%.2lf\n",
	KOPFDA.snam,KOPFDA.start,KOPFDA.ende,KOPFDA.delta,resol);
   if(KOPFDA.nmulti!=1) fprintf(fp,"Multiscan: %d\n",KOPFDA.nmulti);
  }
 else /* Bio-Rad-FTIR Spektren brauchen leicht andere Beschriftung */
  fprintf(fp,"%.40s\nvon %.3lf bis %.3lf  Step=%.4lf n=%d Resol.=%.2lf\n",
	KOPFDA.snam,KOPFDA.start,KOPFDA.ende,KOPFDA.delta,KOPFDA.nmulti,resol);
}

void machfliesszahl(long y,long z,float *ziel)
{
 *ziel=y*exp((double)z);
}

/*
int exor(int a,int b)
{
 return (a||b)&&!(a&&b);
}
*/

void mehrere_files_laden(char *name,int istmulti)
{
 char scriptname[80];
 FILE *fp;
 int i,subj=0;
 if(!hatpunkt(name)) sprintf(scriptname,"%s.%s",name,istmulti?"spc":"script");
 else strcpy(scriptname,name);
 if(istmulti)
   i=multifile_open(&subj,scriptname,filename);
 else
  {if(!(fp=fopen(scriptname,"r")))
	{printf("'%s' nicht gefunden\n",scriptname); return;}
   fscanf(fp,"%d",&i);
   if(i<1 || i>=MAXSPEKT)
       {printf("Scriptfile muss als erste Zahl Anzahl Spektren enthalten !\n");
	printf(" (i=%d ist ungueltig, i sollte zwischen 1 und %d liegen)\n",
		i,MAXSPEKT);
	return;
       }
  }
 while(--i>=0)
  {int ntes2=ntesspektrum-2;
   if(ntesspektrum>MAXSPEKT)
	{printf("Anzahl Spektren auf %d beschrnkt\n",MAXSPEKT); return;}
   if(istmulti)
	{multifile_name(fname2[ntes2]);
	 printf("%d. Spektrum = %s-%d\n",ntesspektrum,fname2[ntes2],++subj);
	}
   else	{fscanf(fp,"%s",fname2[ntes2]);
	 printf("%d. Spektrum = %s\n",ntesspektrum,fname2[ntes2]);
	}
   if(istvorhanden(fname2[ntes2]))
       {if(hilfsfeld==NULL) feldalloc(MAXF,NULL,&hilfsfeld);
	sname_i=ntes2+1;
	einlesen(lfeld,fname2[ntes2],&hilfsfeld[ntes2*npkt],spename2,istmulti);
	modus=4; if(ntesspektrum>2) modus+=ntesspektrum;
	new_hfeld(hilfsfeld,&modus);
	ntesspektrum++;
       }
    else printf("nicht gefunden !!\n");
   }
 if(istmulti) multifile_close();
 else fclose(fp);
}
