/* PSan.cc			letzte nderung: 31.1.1997 */
#define VERSION "Version 1.1"
/*
Uebersetzen:
;AVAX> cx PSan
;AVAX> blink PSan
;AVAX> pur PSan.exe

 Peaks in UV oder IR Spektrum anschreiben
 als Eingabedateien wird eine von UVSHOW oder IRSHOW erzeugte Postscriptdatei
 und eine Textdatei mit den Peakpositionen erwartet.

History:
7.7.1995	Erstellung (RPf)
20.8.96		Direktes Lesen von Datenfiles aus irshow
31.1.97		Korrektur in pars() (IRFILE-Modus)
*/

#include <stdio.h>
//#include <stream.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#define FPF fprintf

/************************* Vordeklarationen ***************************/
void unterprog(FILE *fp1,FILE *fp2);
char *file_einlesen(char *name,long *nb);
void zahlen_einsetzen(FILE *fp1,FILE *fp,char *str,long max);
int getline(FILE *fp,char *s,int lim);
char *enthaelt(char *s,char *text,int n);

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 3
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

char *stradd(char *s1,char *s2)
{
 char *s0=s1;
 while(*s1) s1++;
 while(*s1++ = *s2++) ;
 return s0;
}

FILE *fopen1(char *name,char *rw)
{
 FILE *fp;
 if(!(fp=fopen(name,rw)) && !(fp=fopen(stradd(name,".ps"),rw)))
  {printf("kann '%s' nicht %s\n",name,*rw=='r'?"finden":"oeffnen"); exit(0);}
 return fp;
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80],ziel2name[80];
 FILE *fp1,*fp2;
 int i,j,c;
 long nbytes;
 char *str,*s;
 quellname[0]=zielname[0]=0;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(zielname,argv[i]);
		 else if(j==2) strcpy(quellname,argv[i]);
		 else if(j==3) strcpy(ziel2name,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("PSan  %s\n",VERSION);
	 printf("Anwendung: PSan Name.ps Name.dat [Ziel.ps]\n");
	 exit(0);
	}
 if(*zielname==0)  {printf("PS-Datei:"); scanf("%s",zielname);}
 if(*quellname==0) {strcpy(quellname,"UVSHOW.DAT");}
 str=file_einlesen(zielname,&nbytes);
 if(str==NULL) {printf("'%s' nicht gefunden\n",zielname); exit(0);}
 if(*ziel2name!=0) fp2=fopen1(ziel2name,"w");
 else fp2=fopen1(zielname,"w");
 for(s=str,i=0; i<nbytes;)
	{c= *s++; putc(c,fp2); i++;
	 if(c=='\n' && strncmp(s,"showpage",8)==0) break;
	}
 fp1=fopen1(quellname,"r");
 zahlen_einsetzen(fp1,fp2,str,nbytes);
 fclose(fp1);
 for(;i<nbytes;i++)
	{c= *s++; putc(c,fp2);}
 fclose(fp2);
 return 0;
}/* ende von main */

#define UVFILE 0
#define IRFILE 1
static int pars_modus=UVFILE;

int uvpars(FILE *fp,char *sk,double *za)
{
 int c,ri=0,i;
 char ring[40];
 for(i=0;i<40;i++) ring[i]=' ';
 while((c=getc(fp))!=EOF)
  {if(c=='=')
	{fscanf(fp,"%lf",za);
	 for(i=(ri==0)?39:ri-1;i!=ri;i=(i==0)?39:i-1)
		if(!isalnum(ring[i])) break;
	 if(++i==40) i=0;
	 while(i!=ri) {*sk++ = ring[i++]; if(i==40) i=0;}
	 *sk=0;
	 break;
	}
   else if(c=='\n')
	{c=getc(fp); ungetc(c,fp);
	 if(isdigit(c)) {fscanf(fp,"%lf",za); *sk=0; break;}
	}
   else	{ring[ri++]=c; if(ri==40) ri=0;}
  }
 return c;
}

int pars(FILE *fp,char *sk,double *za)
{
 if(pars_modus==UVFILE) return uvpars(fp,sk,za);
 static char *stry=NULL;
 static char str[80];
 char *s;
 int c;
 *sk=0;
 if(stry) {sscanf(stry,"%lf",za); stry=NULL; return 1;}
 for(;;)
 {do {c=getline(fp,str,80); if(c==EOF) return EOF;
      if(*str==0) printf("leere Zeile\n");//test
     }
  while(*str==0);
  printf("'%s'\n",str);//test
  if(s=enthaelt(str,"cm-1",4))
    {sscanf(str,"%lf",za); stry= &s[4]; return 1;}
 }
 return EOF;
}

/** Beispiel: peak.dat
ClO2  bestrahlt: 30sec. 368nm
von 4499.986 bis 250.026  Step=0.1206 n=100 Resol.=0.25
35255 Messpunkte  Mode=16.0

   Peak        OD         Transmission
1101.01 cm-1   1.51713     3.040 %
1095.10 cm-1   1.23995     5.755 %
1089.31 cm-1   0.70399    19.770 %
 948.75 cm-1   0.63536    23.155 %
 947.30 cm-1   0.50459    31.290 %
 941.27 cm-1   0.44454    35.930 %
 935.37 cm-1   0.13897    72.615 %
** ende peak.dat-Beispiel **/

void zahlen_einsetzen(FILE *fp1,FILE *fp,char *str,long max)
{
 int n;
 char keyword[40];
 double x,y,x1=0.,y1=0.,dy=0.,x2,y2,y0=0.;
 FPF(fp,"/urech {ymi sub ys mul exch xmi sub xs mul exch} bind def\n");
 FPF(fp,"/ushow {urech exch 30 add exch moveto 90 rotate show -90 rotate} def\n");
 FPF(fp,"/ushow2 {urech moveto show} def\n");
 FPF(fp,"/uline {urech moveto urech lineto stroke} def\n");
 while(pars(fp1,keyword,&x)!=EOF)
	{printf("keyword='%s' x=%lf\n",keyword,x);//test
	 while(*keyword!=0)
	  {if(strcmp(keyword,"delta")==0 || strcmp(keyword,"Delta")==0)
		{if(*keyword=='D' && y0!=0.) y=y0/2.-2.5*dy;
		 else y=y1/2.-2.5*dy;
		 y2=y+5*dy;
		 FPF(fp,"%lg %lg %lg %lg uline\n",x1,y,x1,y2);
		 x2=x1-x;
		 FPF(fp,"%lg %lg %lg %lg uline\n",x2,y,x2,y2);
		 y2-=2.5*dy;
		 FPF(fp,"%lg %lg %lg %lg uline\n",x1,y2,x2,y2);
		 x1=(3*x2+x1)/4.;
		 FPF(fp,"(%.2lf) %lg %lg ushow2\n",x,x1,y2+dy);
		}
	   else if(strcmp(keyword,"Step")==0) //Kopf von IR-Datenfile
		{pars_modus=IRFILE; printf("pars_modus=IRFILE\n");//test
		}
	   else
		{printf("unbekanntes Keyword:'%s'=%lf\n",keyword,x1);}
	   if((n=pars(fp1,keyword,&x))==EOF) break;
	   printf("keyword='%s' x=%lf\n",keyword,x);//test
	  }
	 if(n==EOF) break;
	 x1=x; y0=y1;
	 pars(fp1,keyword,&y1);
	 printf("keyword='%s' x1=%lf y1=%lf\n",keyword,x1,y1);//test
	 if(dy==0.) dy=y1*0.02;
	 y2=y1+7*dy; x2=x1;
	 FPF(fp,"%lg %lg %lg %lg uline\n",x1,y1+dy,x1,y2-dy);
	 FPF(fp,"(%.2lf) %lg %lg ushow\n",x1,x2,y2);
	}
}

/** besser entsprechendes PS-Unterprogramm
 double xmi,ymi,xs,ys;
 char *s;
 for(i=n=0,s=str;i<max && n!=0x0F;i++)
	{if((c= *s++)=='/')
	   {if(strncmp(s,"xmi ",4)==0) {sscanf(s,"%lf",&xmi); n|=1;}
	    else if(strncmp(s,"xs ",3)==0) {sscanf(s,"%lf",&xs); n|=2;}
	    else if(strncmp(s,"ymi ",4)==0) {sscanf(s,"%lf",&ymi); n|=4;}
	    else if(strncmp(s,"ys ",3)==0) {sscanf(s,"%lf",&ys); n|=8;}
	   }
	}
**/

/************************* Datei einlesen ********************************/
filelaenge(char *name,int flag)
{
 char str[80];
 FILE *fp;
 int n;
 if(flag==0)
  {sprintf(str,"DIR/SIZ/output=temp.dat %s;",name); system(str);
   fp=fopen("temp.dat","r");
   if(fp==NULL) return -3;
   if(fscanf(fp,"%*s %*s %*s %d",&n)!=1) n= -2;
   fclose(fp);
   system("DEL temp.dat;");
  }
 else
  {fp=fopen1(name,"r");
   if(fp==NULL) return -1;
   for(n=0;getc(fp)!=EOF;n++)  ;
   fclose(fp);
  }
 return n;
}

char *file_einlesen(char *name,long *nb)
{
 char *str,*s;
 int c;
 *nb=filelaenge(name,1);
 if(*nb<=0) return NULL;
 s=str=new char[*nb+1];
 FILE *fp=fopen1(name,"r");
 while((c=getc(fp))!=EOF)
	*s++ = c;
 *s=0;
 return str;
}

/************************* kleinkram ********************************/
getline(FILE *fp,char *s,int lim)
{		/* liest eine Textzeile oder maximal lim Zeichen */
		/* und ersetzt den Zeilentrenner durch 0         */
 int c;
 while(--lim && (c=getc(fp))!=EOF && c!='\n')
	*s++ = c;
 *s='\0';
 return c;	/* EOF wenn Fileende */
}

char *enthaelt(char *s,char *text,int n)  //gibt Position von text in s zurueck
{
 int c,c1= *text++; n--;
 while(c= *s++)
   if(c==c1 && strncmp(s,text,n)==0)  return --s;
 return NULL;
}
