/* spctest.cc			letzte nderung: 1.9.1998 */
#define VERSION "Version 0.0"
/*
Testet .SPC Dateien von Bio-Rad FTIR

History:
3.7.1996	Erstellung (RPf)
1.9.98		in koordxtyp "unbekannt (%d)"
		BYTE fuer spc.h umdefiniert (Transmission sonst nicht erkannt)
8.2.2002	Erweiterung um direkt xy-Datei zu erzeugen (Option 'X')
*/

#include <stdio.h>
#include <iostream>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <ulong.h>
#define DWORD LONG
#undef BYTE
#define BYTE unsigned char
#include "spc.h"

/************************* Vordeklarationen ***************************/
const double zweihoch32=4294967296.0, ln2=log(2.0);

void spctest(FILE *fp1,FILE *fp2);
FILE *fopen_umgeformt(char *name,char *rw);

/***************** Direkte Erzeugung von xy-Datei *********************/
class XYDatei
{
 double xa,xb,dx;
 int np;
 FILE *fp2;
public:
 void start(FILE* fp,double a,double b,double d);
 void put(double y);
 void stop();
};
static XYDatei xydatei;

/**************** Routinen zur Parameterauswertung ********************/
#define MAXARG 2
static char argflag[128];
void setargflags(char *s)
{
 int c;
 while(c= *s++)
  {if(c>='a' && c<='z')  c -= 'a'-'A';
   argflag[c&127]=1;
  }
}

/************************* Hauptprogramm ******************************/
main(int argc,char *argv[])
{
 char quellname[80],zielname[80];
 FILE *fp1,*fp2;
 int i,j,c;
 quellname[0]=zielname[0]=0;
 for(j=0,i=1;i<argc;i++)
	{if((c= *argv[i])=='-' || c=='?') setargflags(argv[i]);
	 else	{if(++j==1) strcpy(quellname,argv[i]);
		 else if(j==2) strcpy(zielname,argv[i]);
	}	}
 if(argflag['?'] || j>MAXARG)
	{printf("SPCtest  %s\n",VERSION);
	 printf("Anwendung: spctest [-Flags] Quelle [Ziel]\n");
	 printf("  Flags:  P = Parameter auch anzeigen\n");
	 printf("  Flags:  X = xy-Datei erstellen\n");
	 exit(0);
	}
 if(*quellname==0) {printf("SPC-Datei:"); scanf("%s",quellname);}
 if(!(fp1=fopen(quellname,"r")) && !(fp1=fopen_umgeformt(quellname,"r")))
   {printf("'%s' nicht gefunden\n",quellname); exit(0);}
 if(*zielname==0) fp2=stdout;
 else if(!(fp2=fopen(zielname,"w")))
   {printf("kann '%s' nicht erstellen\n",zielname); fclose(fp1); exit(0);}
 spctest(fp1,fp2);
 fclose(fp1);
 if(*zielname!=0) fclose(fp2);
 return 0;
}/* ende von main */

FILE *fopen_umgeformt(char *name,char *rw)
{
 char *s; int c;
 FILE *fp;
 for(s=name;c= *s++;) if(c=='.') break;
 if(c==0) //wenn noch kein Punkt vorhanden dann ".spc" anhaengen
   {--s; *s++ = '.'; *s++ = 's'; *s++ = 'p'; *s++ = 'c'; *s=0;
    if(fp=fopen(name,rw)) return fp;
   }
 for(s=name;c= *s;)  *s++ = (islower(c))?(toupper(c)):c;
 return fp=fopen(name,rw);
}

void getbytes(FILE *fp,long n,char *s)
{
 while(--n>=0)  *s++ = getc(fp);
}

char *koordxtyp(int n)
{
 static char unbek[40];
 switch(n)
   {case XARB: return "Arbitrary";
    CASE XWAVEN: return "Wavenumber (cm-1)";
    CASE XUMETR: return "Micrometers";
    CASE XNMETR: return "Nanometers";
    CASE XSECS: return "Seconds";
    CASE XMINUTS: return "Minutes";
    CASE XHERTZ: return "Hertz";
    CASE XKHERTZ: return "Kilohertz";
    CASE XMHERTZ: return "Megahertz";
    CASE XMUNITS: return "Mass (M/z)";
    CASE XPPM: return "Parts per million";
    CASE XDAYS: return "Days";
    CASE XYEARS: return "Years";
    CASE XRAMANS: return "Raman Shift (cm-1)";
    CASE XDBLIGM: return "Double interferogram";
   }
 sprintf(unbek,"unbekannt (%d)",n);
 return unbek;
}

char *koordytyp(int n)
{
 static char unbek[40];
 switch(n)
   {case YARB  : return "Arbitrary Intensity";
    CASE YIGRAM: return "Interferrogram";
    CASE YABSRB: return "Absorbance";
    CASE YKMONK: return "Kubelka-Monk";
    CASE YCOUNT: return "Counts";
    CASE YVOLTS: return "Volts";
    CASE YDEGRS: return "Degrees";
    CASE YAMPS : return "milliamps";
    CASE YMETERS: return "millimeters";
    CASE YMVOLTS: return "millivolts";
    CASE YLOGDR: return "Log (1/R)";
    CASE YPERCNT: return "Percent";
    CASE YTRANS: return "Transmission";
    CASE YREFLEC: return "Reflectance";
    CASE YVALLEY: return "Arbitrary or Single Beam with Valley Peaks";
   }
 sprintf(unbek,"unbekannt (%d)",n);
 return unbek;
}

char *koordztyp(int n)
{
 static char unbek[40];
 switch(n)
   {case YARB  : return "Arbitrary Intensity";
    CASE YIGRAM: return "Interferrogram";
   }
 sprintf(unbek,"unbekannt (%d)",n);
 return unbek;
}

/**
long bitreverse(long x,int n)
{
 long y;
 for(y=0,n<<=3;--n>=0;)
   {y<<=1;
    if(x&1) y++;
    x>>=1;
   }
 return y;
}
**/

void liesdatum(long fdate,int *std,int *min,int *tag,int *monat,int *jahr)
{
 *jahr= (fdate>>20)&0x0FFF;
 *monat=(fdate>>16)&0x0F;
 *tag = (fdate>>11)&0x1F;
 *std = (fdate>>6)&0x1F;
 *min = (fdate)&0x3F;
}

/*** weitere Vordeklarationen ***/
void werte_ausgeben(FILE *fp1,long n,int typ);
#define XWERTE 1
#define YWERTE 2

/*** Hauptteil ***/
void spctest(FILE *fp1,FILE *fp2)
{
 SPCHDR he;
 int std,min,tag,monat,jahr,c;
 getbytes(fp1,sizeof(SPCHDR),(char*)&he);
 if(he.ftflgs) printf("ftflgs=%02X\n",he.ftflgs);
 switch(he.fversn)
   {case 0x4b: //printf("LSB first");
    CASE 0x4c: printf("MSB first, noch nicht getestet !\n");
    CASE 0x4d: printf("Altes Format, mit diesem Programm nicht lesbar.\n");
	       return;
    DEFAULT: printf("fversn=%02x unbekanntes Format\n",he.fversn);
	     return;
   }
 printf("'%s'\n",he.fcmnt);
 printf("Start=%lf Ende=%lf   Anzahl Messpunkte = %ld  (Step=%lf)\n",
	he.ffirst,he.flast,he.fnpts,(he.flast-he.ffirst)/(he.fnpts-1));
 printf("Resolution = %s\n",he.fres);
 if(argflag['X'])
   {xydatei.start(fp2,he.ffirst,he.flast,(he.flast-he.ffirst)/(he.fnpts-1));}
 liesdatum(he.fdate,&std,&min,&tag,&monat,&jahr);
 printf("Date = %d.%d.%d  %d:%02d\n",tag,monat,jahr,std,min);
 printf("fsource='%s'\n",he.fsource);
 printf("x-Koordinate ist %s\n",koordxtyp(he.fxtype));
 printf("y-Koordinate ist %s\n",koordytyp(he.fytype));
 printf("z-Koordinate ist %s\n",koordztyp(he.fztype));
 if(he.ftflgs&TMULTI) printf("Dies ist eine Multi-Spektren-Datei\n");
 if(he.ftflgs&TXYXYS) //zuerst SUBHDR dann xwerte
   {printf("TXYXYS-Modus noch nicht implementiert\n"); return;}
 if(he.ftflgs&TXVALS)
   {printf("x-Werte:\n");
    werte_ausgeben(fp1,he.fnpts,XWERTE);
   }
 printf("y-Werte:\n");
 werte_ausgeben(fp1,he.fnpts,YWERTE);
 for(int i=2;i<=he.fnsub;i++)
    {printf("%d. Spektrum der Multi-Datei\n",i);
     werte_ausgeben(fp1,he.fnpts,YWERTE);
    }
//Dateiende auswerten:
 int c2;
 if(argflag['P'])
   {printf("Parameter am Dateiende:\n");
    while((c=getc(fp1))!=EOF)
     if(c>' ' && (c2=getc(fp1))>' ')
       {printf("%c%c",c,c2);
	while((c=getc(fp1))!=EOF && c>=' ') putc(c,stdout);
	putc('\n',stdout);
   }   }
 if(argflag['X'])
   {xydatei.stop();}
}

void werte_ausgeben(FILE *fp1,long n,int typ)
{
 SUBHDR hs;
 float x;
 LONG y;
 double wert, yfakt;
 long i,j;
 if(typ==YWERTE)
   {getbytes(fp1,sizeof(SUBHDR),(char*)&hs);
    yfakt=exp(ln2*hs.subexp)/zweihoch32;
    //printf("hs.subexp=%d hs.subindx=%d\n",hs.subexp,hs.subindx);//test
    if(hs.subscan!=0) printf("(hs.subscan=%ld)\n",hs.subscan);//test
   }
 for(j=i=0;i<n;i++)
   {if(typ==XWERTE) {getbytes(fp1,sizeof(float),(char*)&x); wert=x;}
    else {getbytes(fp1,sizeof(LONG),(char*)&y); wert=yfakt*y;}
    if(argflag['X'])
      {xydatei.put(wert);}
    else
      {if(i<10 || i>=n-10) {printf("%13lg",wert); if(++j%5==0) printf("\n");}
       else if(i==10) printf("  .....\n");
      }
   }
}

/**** Erweiterung 8.2.2002 um direkt xy-Datei zu erzeugen ****/
void XYDatei::start(FILE *fp,double a,double b,double d)
{
 fp2=fp;
 xa=a; xb=b; dx=d;
 np=0;
}
void XYDatei::put(double y)
{
 fprintf(fp2,"%lg  %lg\n",xa+np*dx,y);
 np++;
}
void XYDatei::stop()
{
 //Datei wird in main() geschlossen
}
