;emacs.el  letzte Aenderung: 21.11.95
;(setenv "TERM" "vt200")
;(setenv "TERM" "AMIGA")

(setq version-control 'never)
(setq KED-version (getenv "KEDVERSION"))
(if (equal KED-version "rzuaix")
 (progn
   ;(setq compile-command "com ")
   (setq inhibit-default-init t)	;defaults nicht laden
   ;(load "default")			;defaults explizit laden.
   (define-key global-map "\C-x\C-a" 'save-buffer) ;Problem mit \C-s auf vt100
))

(setq ked-termtype (getenv "TERM"))
(setq ked-gold nil)
(setq ked-rueck nil)
(setq ked-help-flag nil)
(setq ked-learnmodus nil)

(setq term-file-prefix nil)
;(if (or (equal ked-termtype "vt100") (equal ked-termtype "vt200")
;       (equal ked-termtype "vt300"))
 (send-string-to-terminal "\e=")
;)
(setq SS3-map (make-keymap))

(if (or (equal ked-termtype "AMIGA") (equal ked-termtype nil)) (progn

(global-set-key "\C-b" 'compile)	;test
(global-set-key "\C-n" 'next-error)	;test

(if (eq KED-version nil) (setq KED-version "Amiga-Emacs"))
(global-set-key "\C-x\C-^0~" 'compile)		;F1
(global-set-key "\C-x\C-^1~" 'next-error)	;F2
;(global-set-key "\C-x\C-^?~" 'ked-help) ;schon mit info belegt

(define-key global-map "\C-x\C-^K" SS3-map)
(define-key SS3-map "(" 'ked-gold-taste)    ;PF1 auf Ziffernblock
(define-key SS3-map ")" 'ked-help)	    ;PF2
(define-key SS3-map "/" 'ked-isearch)       ;PF3
(define-key SS3-map "*" 'ked-kill-line)     ;PF4
(define-key SS3-map "\r" 'ked-enter)	    ;ENTER
(define-key SS3-map "+" 'delete-char)	    ; , auf Ziffernblock
(define-key SS3-map "-" 'kill-word)	    ; -
(define-key SS3-map "." 'set-mark-command)  ; .
(define-key SS3-map "0" 'Ked-0)
(define-key SS3-map "1" 'Ked-1)
(define-key SS3-map "2" 'Ked-2)
(define-key SS3-map "3" 'Ked-3)
(define-key SS3-map "4" 'Ked-4)
(define-key SS3-map "5" 'Ked-5)
(define-key SS3-map "6" 'kill-region)	    ;'Ked-6) geht nicht !!
(define-key SS3-map "7" 'Ked-7)
(define-key SS3-map "8" 'Ked-8)
(define-key SS3-map "9" 'Ked-9)

(defun ked-golden ()
  (if (eq ked-gold t)
      (progn (message "GOLD")
	     (define-key SS3-map "6" 'ked-yank)		;6
	     (define-key SS3-map "*" 'ked-yank)		;PF4
	     (define-key SS3-map "-" 'ked-yank)		;DELW
	     (define-key SS3-map "+" 'ked-undel-char)	;DELC
	     (define-key SS3-map "." 'ked-mark-off)	;.
	     (define-key SS3-map "\r" 'query-replace)	;ENTER
	     (local-set-key "l" 'ked-start-kbd-macro)
	     (local-set-key "s" 'ked-end-kbd-macro)
	     (local-set-key "x" 'ked-call-last-kbd-macro))
      (progn (define-key SS3-map "6" 'kill-region)
	     (define-key SS3-map "*" 'ked-kill-line)
	     (define-key SS3-map "-" 'kill-word)
	     (define-key SS3-map "+" 'delete-char)
	     (define-key SS3-map "\r" 'ked-enter)
	     (local-unset-key "l")
	     (local-unset-key "s")
	     (local-unset-key "x")
	     (define-key SS3-map "." 'set-mark-command))))

) (progn  ;#else AMIGA

(if (eq KED-version nil) (setq KED-version "Unix-Emacs"))
(global-set-key "\C-b" 'compile)
(global-set-key "\C-n" 'next-error)
(global-set-key "\e[17~" 'compile)	;F6
(global-set-key "\e[18~" 'next-error)	;F7
(define-key global-map "\eO" SS3-map)
(define-key SS3-map "P" 'ked-gold-taste)    ;PF1 auf Ziffernblock
(define-key SS3-map "Q" 'ked-help)          ;PF2
(define-key SS3-map "R" 'ked-isearch)       ;PF3
;(setq search-repeat-char ?\C-f)       ;geht nicht !?
(define-key SS3-map "S" 'ked-kill-line)     ;PF4
(define-key SS3-map "M" 'ked-enter)         ;ENTER
(define-key SS3-map "N" 'grosses-N)         ;noch unbekannt
(define-key SS3-map "k" 'kleines-k)         ;noch unbekannt
(define-key SS3-map "l" 'delete-char)       ; , auf Ziffernblock
(define-key SS3-map "m" 'kill-word)         ; -
(define-key SS3-map "n" 'set-mark-command)  ; .
(define-key SS3-map "p" 'Ked-0)
(define-key SS3-map "q" 'Ked-1)
(define-key SS3-map "r" 'Ked-2)
(define-key SS3-map "s" 'Ked-3)
(define-key SS3-map "t" 'Ked-4)
(define-key SS3-map "u" 'Ked-5)
(define-key SS3-map "v" 'kill-region)    ;'Ked-6) geht nicht !!
(define-key SS3-map "w" 'Ked-7)
(define-key SS3-map "x" 'Ked-8)
(define-key SS3-map "y" 'Ked-9)
(define-key SS3-map "z" 'kleines-z)         ;noch unbekannt

(defun ked-golden ()
  (if (eq ked-gold t)
      (progn (message "GOLD")
	     (define-key SS3-map "v" 'ked-yank)		;6
	     (define-key SS3-map "S" 'ked-yank)		;PF4
	     (define-key SS3-map "m" 'ked-yank)		;DELW
	     (define-key SS3-map "l" 'ked-undel-char)	;DELC
	     (define-key SS3-map "n" 'ked-mark-off)	;.
	     (define-key SS3-map "M" 'query-replace)    ;ENTER
	     (local-set-key "l" 'ked-start-kbd-macro)
	     (local-set-key "s" 'ked-end-kbd-macro)
	     (local-set-key "x" 'ked-call-last-kbd-macro))
	     (ked-umlaute-on))
      (progn (define-key SS3-map "v" 'kill-region)
	     (define-key SS3-map "S" 'ked-kill-line)
	     (define-key SS3-map "m" 'kill-word)
	     (define-key SS3-map "l" 'delete-char)
	     (define-key SS3-map "n" 'set-mark-command)
	     (define-key SS3-map "M" 'ked-enter)
	     (local-unset-key "l")
	     (local-unset-key "s")
	     (local-unset-key "x")
	     (ked-umlaute-off))))

(defun ked-umlaute-on () "Tasten aouAOU auf entsprechende Umlaute setzen"
  (interactive)
  (local-set-key "a" 'ked-umlaut-a) (local-set-key "A" 'ked-umlaut-A)
  (local-set-key "o" 'ked-umlaut-o) (local-set-key "O" 'ked-umlaut-O)
  (local-set-key "u" 'ked-umlaut-u) (local-set-key "U" 'ked-umlaut-U))

(defun ked-umlaute-off () "Tasten aouAOU wieder normal" (interactive)
  (local-unset-key "A") (local-unset-key "a") (local-unset-key "O")
  (local-unset-key "o") (local-unset-key "U") (local-unset-key "u"))

(defun ked-umlaut-a () (interactive) (insert-char ? 1) (ked-gold-off))
(defun ked-umlaut-A () (interactive) (insert-char ? 1) (ked-gold-off))
(defun ked-umlaut-o () (interactive) (insert-char ? 1) (ked-gold-off))
(defun ked-umlaut-O () (interactive) (insert-char ? 1) (ked-gold-off))
(defun ked-umlaut-u () (interactive) (insert-char ? 1) (ked-gold-off))
(defun ked-umlaut-U () (interactive) (insert-char ? 1) (ked-gold-off))

))  ;#endif AMIGA

(defun ked-undel-char () (interactive)
  (ked-gold-off) (undel-char)) ;provisorisch

(defun ked-gold-taste () (interactive)
  (setq ked-gold (eq ked-gold nil))
  (ked-golden))

(defun ked-gold-off () (setq ked-gold nil) (ked-golden))

(defun ked-yank () (interactive) (yank) (ked-gold-off))
(defun ked-kill-line () (interactive) (kill-line 1))

(defun ked-isearch () "Suche" (interactive)
  (ked-gold-off)
  (if (eq ked-rueck t) (isearch-backward) (isearch-forward)))

(defun ked-help () (interactive) (ked-gold-off)
  (switch-to-buffer "KedHelp")
  (if (eq ked-help-flag 2)
      (if (< ked-help-position 34)
	  (progn (next-line 34) (recenter)(setq ked-help-position 34))
	  (progn (beginning-of-buffer)(setq ked-help-position 0)))
    (progn
	   (beginning-of-buffer)(setq ked-help-position 0)
	   (if (eq ked-help-flag nil) (insert-file "~/hilfe/ked.hilf"))
	   (setq ked-help-flag 2))))

(defun ked-enter () "enter-substitute" (interactive)
  (if (eq ked-gold t)
      (progn (ked-gold-off) ;(query-replace nil nil) geht nicht
	     ) ())
  (if (eq ked-help-flag 2)
      (progn (setq ked-help-flag 1) (switch-to-buffer nil))
    (redraw-display)))

(defun ked-mark-off () (interactive) (ked-gold-off))

(defun ked-start-kbd-macro () "zu erreichen mit GOLD L" (interactive)
  (ked-gold-off) (setq ked-learnmodus t) (start-kbd-macro nil))
(defun ked-end-kbd-macro () (interactive)
  (end-kbd-macro) (setq ked-learnmodus nil) (ked-gold-off))
(defun ked-call-last-kbd-macro () (interactive)
  (if (eq ked-learnmodus t) (ked-end-kbd-macro))
  (ked-gold-off)
  (call-last-kbd-macro)
  (ked-gold-off) ;GOLD-Taste im Macro auch wieder ausschalten !!
)

(defun ked-backdel () "letztes Zeichen lschen" (interactive)
  (ked-gold-off) (backward-delete-char-untabify))

;;Musterfunktion:
;(defun Neuer-Name () "Musterfunktion fuer KED-Tastenbelegung" (interactive)
;  (if (eq ked-gold t)
;      (if (eq ked-rueck t)
;	  ()
;	  ())
;      (if (eq ked-rueck t)
;	  ()
;	  ()))
;  (ked-gold-off))
;;Ende Musterfunktion

(defun zeilenanfang () (interactive)
  (if (eq ked-rueck t)
      (progn (backward-char) (beginning-of-line))
      (progn (end-of-line) (forward-char)))
  (ked-gold-off))

(defun Ked-0 () "line-openline" (interactive)
  (if (eq ked-gold t)
      (progn (newline) (backward-char))
      (if (eq ked-rueck t)
	  (progn (backward-char) (beginning-of-line))
	  (progn (end-of-line) (forward-char))))
  (ked-gold-off))

(defun Ked-1 () "word-chngcase" (interactive)
  (if (eq ked-gold t)
      (if (eq ked-rueck t)
	  (downcase-word)
	  (upcase-word))
      (if (eq ked-rueck t)
	  (backward-word 1)
	  (progn (forward-word 1) (forward-char))))
  (ked-gold-off))

(defun Ked-2 () "eol-del_eol" (interactive)
  (if (eq ked-gold t)
      (kill-line)
      (if (eq ked-rueck t)
	  (progn (beginning-of-line) (backward-char))
	  (progn (forward-char) (end-of-line))))
  (ked-gold-off))

(defun Ked-3 () "char-specins" (interactive)
  (if (eq ked-gold t)
      (ked-specins) ;provi.
      (if (eq ked-rueck t)
	  (backward-char)
	  (forward-char)))
  (ked-gold-off))

(defun Ked-4 () "advance-bottom" (interactive)
  (if (eq ked-gold t)
      (progn (end-of-buffer) (ked-gold-off))
      (setq ked-rueck nil)))

(defun Ked-5 () "back-top" (interactive)
  (if (eq ked-gold t)
      (progn (beginning-of-buffer) (ked-gold-off))
      (setq ked-rueck t)))

;geht aus unerfindlichen Gruenden nicht:
(defun Ked-6 () "cut-paste  GEHT NICHT: FEHLER IN EMACS !?" (interactive)
  (if (eq ked-gold t)
      (ked-yank)
      (kill-region)))

(defun Ked-7 () "page-command" (interactive)
  (if (eq ked-gold t)
      (progn (ked-gold-off) (execute-extended-command t))
      (if (eq ked-rueck t)
	  (progn (previous-line 22)(recenter))   ;(backward-page)
	  (progn (next-line 22)(recenter)))))    ;(forward-page)

(defun Ked-8 () "sect-fill" (interactive)
  (if (eq ked-gold t)
      (if (eq ked-rueck t)
	  ()
	  ())
      (if (eq ked-rueck t)
	  (progn (previous-line 10) (recenter))
	  (progn (next-line 10) (recenter))))
  (ked-gold-off))

(defun Ked-9 () "append-replace" (interactive)
  (if (eq ked-gold t)
      (if (eq ked-rueck t)
	  ()
	  ())
      (if (eq ked-rueck t)
	  ()
	  ()))
  (ked-gold-off))

(defun exit () "wie C-x C-c" (interactive) (save-buffers-kill-emacs))
(defun quit () "Emacs verlassen ohne zu speichern" (interactive) (kill-emacs))
(defun learn () "Start eines Macros" (interactive) (start-kbd-macro nil))

(message "KED-version=\"%s\"  termtype=\"%s\"" KED-version ked-termtype)
