// analogin.cc

#include "labjackclass.h"

void msleep(long msec) {usleep(1000*msec);}

int main (int argc, char *argv[])
{
 double analogout[2]={2.6,2.5};
 double analogin[8],anadiff[4];
 int i,j,k,er;
 char str[80];
 Labjack lab;
 if(lab.printfirmware()<0) exit(0);

 // Test Analog Outs
 lab.aout(analogout[0],analogout[1]);

 // Test Analog Inputs
 lab.calib(0,-0.0296,1.0049);
 lab.calib(1,-0.0286,1.0015);
 lab.calib(2,-0.042,1.0085);
 lab.calib(3,-0.003,1.0054);
 lab.calib(4,-0.019,0.997);
 lab.calib(5,-0.019,0.996);
 lab.calib(6, 0.007,1.003);
 lab.calib(7, 0.002,1.005);
 //lab.calibdiff(2,-0.0237,1/0.997362,-0.0118,1/1.00952);//test
 /*
 lab.calibdiff(0,-0.021,1.0);//test
 lab.calibdiff(1,-0.059,1.0);//test
 lab.calibdiff(3,-0.018,1.0);//test
 */
 double x0;
 for(x0=1.0;x0<4.02;x0+=0.5)
 {lab.aout(x0,2.5);
  msleep(1);
  for(i=0;i<=7;i++)
  {int gain=lab.code2gain(i);
   printf("gain=%d\n",gain);
   lab.setgain(gain);
   msleep(1);
   lab.ain(analogin);
   for(k=0;k<8;k++) printf("%.3lf  ",analogin[k]);
   printf("\n");
   lab.aindiff(anadiff);
   for(k=0;k<4;k++) printf("%12.3lf  ",anadiff[k]);
   printf("\n");
  }
  printf("weiter mit RETURN"); getc(stdin);
 }

 lab.aout(analogout[0],analogout[1]);
 return 0;
}
