/* checklabjack.cc               last update: 5.2.2006 */
static char* version="0.1";
#define CALIB 1

/*
 kleines Testprogramm fuer Labjack U12

 4.2.2006	Erstellung von lauflicht.cc ausgehend
*/

#include "labjackclass.h"
void msleep(long msec) {usleep(1000*msec);}

int main (int argc, char *argv[])
{
 double analogout[2]={2.5,1.0};
 int i,j,k,nocalib=0;
 char str[80];
 Labjack lab;
 if(argc>1) //Argumente-Auswertung
  {for(i=0;i<2;i++)
    {if(argc>=i+2) sscanf(argv[i+1],"%lf",&analogout[i]);
    }
  if(argc>3) nocalib=1;
  if(argc>4 || (argc>=2 && (*argv[1]=='?' || *argv[1]=='-')))
   {printf("%s Version %s\n",argv[0],version);
    printf("Aufruf: checklabjack [ao0 ao1] [nocalib]\n");
    printf(" Es werden die beiden Analogausgaenge ao0 und ao1 gesetzt,\n");
    printf(" dann die Digitalausgaenge io0...io3 getestet,\n");
    printf(" dann die Analogeingaenge ai0...ai7 gelesen.\n");
    printf(" vorausgesetzte Testschaltung:\n");
    printf("  io0...io3--330ohm--LED--GND\n");
    printf("  CAL--1kohm--ai0--ai1\n");
    printf("  ao0-470ohm-ai7-560ohm-ai6-560-ai5-560-ai4-560-ai4-560-ai3-560-ai2-470-GND\n");
    return 0;
   }
  }
 if(lab.printfirmware()<0) exit(0);

 // Test Analog Outs
 printf("Testing analog outs  AO0: %.3lf AO1: %.3lf\n",analogout[0],analogout[1]);
 lab.aout(analogout[0],analogout[1]);

 // Test Digital Outs
 UWORD trisD=0xFFFF,stateD=0;
 UBYTE trisIO=0,stateIO=0;
 const int update=1;
 for(k=0;k<=16;k++)
    {stateIO=k;
     lab.dio(trisD,trisIO,stateD,stateIO,update);
     if(k==15) msleep(500); else msleep(100);
    }
 msleep(500);

#ifdef CALIB
 // Analog Inputs Calibrating
 if(nocalib)
   {double a[8]={ 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    double b[8]={ 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    for(j=0;j<8;j++) lab.calib(j,a[j],b[j]);
   }
 else
   {double a[8]={-0.0296,-0.0286,-0.042,-0.003,-0.019,-0.019, 0.007, 0.002};
    double b[8]={ 1.0049, 1.0015,1.0085,1.0054, 0.997, 0.996, 1.003, 1.005};
    for(j=0;j<8;j++) lab.calib(j,a[j],b[j]);
    printf("analogin calibrated\n");
   }
#endif

 // Test Analog Inputs
 double analogin[8],anacalc[8];
 anacalc[0]=anacalc[1]=2.49;
 for(j=2;j<8;j++)
   anacalc[j]=analogout[0]/(5*560+2*470)*(470+(j-2)*560);
 printf("Testing Analog Inputs:\n");
 lab.ain(analogin);
 printf("PIN  measured calculated diff\n");
 for(j=0;j<8;j++)
   {printf("AI%d  %.3lf V   %.3lf     %6.3lf\n",j,analogin[j],anacalc[j],
	   analogin[j]-anacalc[j]);
   }
}
