// labjackclass.cc

#define LABJACKBUG 1

#include "labjackclass.h"

void Labjack::bufdump()
{
 for(int i=0;i<8;i++) printf("%02X ",buf[i]);
 printf("\n");
}
int Labjack::ljopen()
{
 fd=open("/dev/usb/labjack0",O_RDWR);
 for(int i=1;fd<0 && i<1000;i*=2)
   {usleep(1000*i); fd=open("/dev/usb/labjack0",O_RDWR);}
 if(fd<0) fprintf(stderr,"%s: %s: open error\n",__FILE__,__func__);
 //else fprintf(stderr,"open(/dev/usb/labjack0,O_RDWR) war erfolgreich.\n");//test
 return fd;
}
void Labjack::ljclose()
{
 if(fd>=0) {close(fd); fd= -1;}
}
int Labjack::labjopen()
{
 if(fd>=0) fprintf(stderr,"%s: %s: allready opened\n",__FILE__,__func__);
 else fd=ljopen();
 return fd;
}
void Labjack::labjclose()
{
 if(fd<0) fprintf(stderr,"%s: %s: not opened\n",__FILE__,__func__);
 ljclose();
}
//quick converting between code and real gain
static char cod2gain[]={1,2,4,5,8,10,16,20};
static char gain2cod[]={0,0,1,1,2,3,3,3,4,4,5,5,5,5,5,5,6,6,6,6,7};
int Labjack::code2gain(int cod)
{
 if(cod<0) cod=0; else if(cod>7) cod=7;
 return int(cod2gain[char(cod)]);
}
int Labjack::gain2code(int g)
{
 if(g>20) g=20; else if(g<1) g=1;
 return gain2cod[char(g)];
}
Labjack::Labjack()
{
 memset(buf,0,8); memset(pwmbuf,0,8);
 IOout=0;
 memset(gain,gain2cod[1],4);
 fd= -1;
 for(int i=0;i<8;i++) {caliba[i]=0.0; calibb[i]=1.0;}
 for(int i=0;i<4;i++) {caldia[i]=caldic[i]=0.0; caldib[i]=caldid[i]=1.0;}
#ifdef LABJACKBUG
 /** Umgehung des Labjack-Bugs: ** /
 int pid=fork();
 if(pid==0)
   {fd=open("/dev/usb/labjack0",O_RDWR); //Kind-Prozess
    if(fd>=0)
      {buf[5]=0x53; buf[0]=1;
       write(fd,buf,8); //Bug im Labjack: erster Zugriff wird ignoriert
       read(fd,buf,8);
       close(fd);
      }
    //printf("Fork endet.\n");//test
    exit(0);
   }
 else
   {sleep(1); //Eltern-Prozess
    if(kill(pid,SIGKILL)==0) //SIGKILL oder SIGTERM
      //printf("Fork wird gekillt\n") //test
      ;
    else
      //printf("Kindprozess ist schon beendet.\n")//test
      ;
    usleep(100000);
   }
 /**/
 /** Einfachere Umgehung des Bugs: **/
 if(fd<0) ljopen();
 buf[5]=0x53; buf[0]=1;
 write(fd,buf,8);
 /**/
#endif /*LABJACKBUG*/
}

Labjack::~Labjack()
{
 ljclose();
}
int Labjack::printfirmware()
{
 int n,er=0,oflag=(fd<0);
 //printf("fd=%d oflag=%d\n",fd,oflag);//test
 if(oflag) ljopen();
 if(oflag) printf("fd=%d\n",fd);//test
 if(fd<0) {printf("kein Labjack gefunden\n"); return -1;}
 memset(buf,0,8); buf[5]=0x53; buf[0]=1;
 if((n=write(fd,buf,8))!=8) {printf("Fehler in write: %d\n",n); er= -1;}
 else if((n=read(fd,buf,8))!=8) {printf("Fehler in read: %d\n",n); er= -2;}
 if(oflag) ljclose();
 printf("Firmware: %d.%02d\n",buf[0],buf[1]);
 return er;
}
int Labjack::dio(UWORD Dtris, UBYTE IOtris,
		 UWORD& Dstate,UBYTE& IOstate,int update,UWORD* Dlatch)
{
 int n,er=0,oflag=(fd<0);
 if(oflag) ljopen();
 buf[0]=(Dtris>>8)&0xFF;
 buf[1]=Dtris&0xFF;
 buf[2]=(Dstate>>8)&0xFF;
 buf[3]=Dstate&0xFF;
 IOout=(IOstate&0x0F);
 buf[4]=(IOtris<<4)+IOout;
 buf[5]=0x57;
 buf[6]=update;
 //bufdump();//test
 if((n=write(fd,buf,8))!=8)
   {fprintf(stderr,"%s: %s: write error n=%d\n",__FILE__,__func__,n);
    er= -1;
   }
 else if((n=read(fd,buf,8))!=8)
   {fprintf(stderr,"%s: %s: read error n=%d\n",__FILE__,__func__,n);
    er= -2;
   }
 Dstate=(buf[1]<<8)+buf[2];
 IOstate=(buf[3]>>4)&0x0F;
 Dtris=(buf[4]<<8)+buf[5];
 if(Dlatch!=NULL) *Dlatch=(buf[6]<<8)+buf[7];
 if(oflag) ljclose();
 return er;
}
UWORD Labjack::aoutdigits(double a)
{
 UWORD bits;
 const UWORD MAX=0x400;
 if(a<0.0) a=0.0;
 else if(a>5.0) a=5.0;
 bits=int(MAX/5.0*a+0.5); if(bits>=MAX) bits=MAX-1;
 return bits;
}
int Labjack::aout(double a0,double a1)
{
 int n,er=0,oflag=(fd<0);
 if(oflag) ljopen();
 UWORD b0=aoutdigits(a0),b1=aoutdigits(a1);
 pwmbuf[5]=((b0<<2)&0x0C)+(b1&0x03);
 pwmbuf[6]=(b0>>2);
 pwmbuf[7]=(b1>>2);
 if((n=write(fd,pwmbuf,8))!=8)
   {fprintf(stderr,"%s: %s: write error n=%d\n",__FILE__,__func__,n);
    er= -1;
   }
 else if((n=read(fd,buf,8))!=8)
   {fprintf(stderr,"%s: %s: read error n=%d\n",__FILE__,__func__,n);
    er= -2;
   }
 if(oflag) ljclose();
 return er;
}
int Labjack::ain(double* analogin)
{
 int n,er=0,ch0,led=0,oflag=(fd<0);
 if(oflag) ljopen();
 for(ch0=0;ch0<=4;ch0+=4,led=1-led)
 {buf[0]=0x08+ch0; //(gain0<<4)+8+chan0
  buf[1]=0x09+ch0;
  buf[2]=0x0A+ch0;
  buf[3]=0x0B+ch0;
  buf[4]=2+led;
  buf[5]=0xC0+IOout;
  buf[7]=0x5A; //echo
  if((n=write(fd,buf,8))!=8)
    {fprintf(stderr,"%s: %s: write error n=%d\n",__FILE__,__func__,n); er= -1;}
  else if((n=read(fd,buf,8))!=8)
    {fprintf(stderr,"%s: %s: read error n=%d\n",__FILE__,__func__,n); er= -2;}
  analogin[0+ch0]=digitsain(((buf[2]&0xF0)<<4)+buf[3]);
  analogin[1+ch0]=digitsain(((buf[2]&0x0F)<<8)+buf[4]);
  analogin[2+ch0]=digitsain(((buf[5]&0xF0)<<4)+buf[6]);
  analogin[3+ch0]=digitsain(((buf[5]&0x0F)<<8)+buf[7]);
  if(er==0)
   {char *s; n=buf[0];
    if(n&0xC0!=0xC0) {s="unusual response"; er= -3;}
    if(n&0x20!=0) {s="buffer ovwerflow or checksum error"; er= -3;}
    if(n&0x10!=0) {s="pga overvolt"; er= -3;}
    if(er==0 && buf[1]!=0x5A) {s="wrong echo"; er= -3;}
    if(er<0) fprintf(stderr,"%s: %s: AnalogIn error 0x%02X %s\n",
		     __FILE__,__func__,n,s);
   }
 }
 if(oflag) ljclose();
 for(int i=0;i<8;i++)
   analogin[i]=caliba[i]+calibb[i]*analogin[i];
 return er;
}
double Labjack::digitsain(UWORD u,int g)
{
 if(g==0) return -10.0+20.0/4096*u;
 return (40.0/4096*u-20.0)/g;
}
int Labjack::setgain(int g[4])
{
 int gi,er=0;
 for(int i=0;i<4;i++)
   {if(g[i]<0 || g[i]>20)
      {fprintf(stderr,"%s: %s: Error wrong gain g[%d]=%d\n",
	       __FILE__,__func__,i,g[i]);
       er=1;
       if(g[i]>20) gi=gain2cod[20];
       else gi=gain2cod[1];
      }
    else
      {gi=gain2cod[g[i]];
/*     if(cod2gain[gi]!=g[i])
         fprintf(stderr,"%s: %s: Warning wrong gain g[%d]=%d\n",
	         __FILE__,__func__,i,g[i]);
*/
      }
    gain[i]=gi;
   }
 return er;
}
int Labjack::setgain(int g)
{
 int ga[4];
 for(int i=0;i<4;i++) ga[i]=g;
 return setgain(ga);
}
int Labjack::aindiff(double* analogin)
{
 int n,er=0,ch0,led=1,oflag=(fd<0);
 if(oflag) ljopen();
 buf[0]=(gain[0]<<4)+0;
 buf[1]=(gain[1]<<4)+1;
 buf[2]=(gain[2]<<4)+2;
 buf[3]=(gain[3]<<4)+3;
 buf[4]=2+led;
 buf[5]=0xC0+IOout;
 buf[7]=0x5A; //echo
 if((n=write(fd,buf,8))!=8)
    {fprintf(stderr,"%s: %s: write error n=%d\n",__FILE__,__func__,n); er= -1;}
 else if((n=read(fd,buf,8))!=8)
    {fprintf(stderr,"%s: %s: read error n=%d\n",__FILE__,__func__,n); er= -2;}
 analogin[0]=digitsain(((buf[2]&0xF0)<<4)+buf[3],cod2gain[gain[0]]);
 analogin[1]=digitsain(((buf[2]&0x0F)<<8)+buf[4],cod2gain[gain[1]]);
 analogin[2]=digitsain(((buf[5]&0xF0)<<4)+buf[6],cod2gain[gain[2]]);
 analogin[3]=digitsain(((buf[5]&0x0F)<<8)+buf[7],cod2gain[gain[3]]);
 if(er==0)
   {char *s; n=buf[0];
    if(n&0xC0!=0xC0) {s="unusual response"; er= -3;}
    if(n&0x20!=0) {s="buffer ovwerflow or checksum error"; er= -3;}
    if(n&0x10!=0) {s="pga overvolt"; er= -3;}
    if(er==0 && buf[1]!=0x5A) {s="wrong echo"; er= -3;}
    if(er<0) fprintf(stderr,"%s: %s: DiffAnalogIn error 0x%02X %s\n",
		     __FILE__,__func__,n,s);
   }
 if(oflag) ljclose();
 for(int i=0;i<4;i++)
   {if(analogin[i]>=0)
	  analogin[i]=caldia[i]+caldib[i]*analogin[i];
    else  analogin[i]=caldic[i]+caldid[i]*analogin[i];
   }
 return er;
}
void Labjack::calib(int i,double a,double b)
{
 caliba[i]=a; calibb[i]=b;
}
void Labjack::calibdiff(int i,double a,double b,double c,double d)
{
 caldia[i]=a; caldib[i]=b; caldic[i]=c; caldid[i]=d;
}
