// analogin.cc
#include <stdio.h>
#include <unistd.h>
#include "ljackv112.h"

void printerror(char *s,long er)
{
 char str[80];
 GetErrorString(er,str); printf("%s%s\n",s,str);
}

int main (int argc, char *argv[])
{
  double analogout[2]={0.5,1.0};
  float analogin[8];
  double ana[8];
  long id=0, er;
  int i,j,k,n=10;

  InitLabjack();

  // Test Analog Outs (Using EAnalogOut)
  printf("%s: Testing analog outs  AO0: %.3lf AO1: %.3lf\n",
	 argv[0], analogout[0],analogout[1]);
  er=EAnalogOut(&id,0,analogout[0],analogout[1]);
  if(er!=0) printerror("Error Analog Outs: ",er);
  printf("id=%ld\n",id);//test

  // Test Analog In  and setting IO0..IO3
  long stateio=1,updateio=1,ledon=0,numchan=4,notcal=0,overvoltage=0;
  long channels[8]={0,1,2,3,4,5,6,7};
  long gains[8]  = {0,0,0,0,0,0,0,0}; // 0=1, 1=2, ... ,7=20

  for(k=0;k<10;k++)
   {if(k==9) ledon=1;
    for(i=0;i<8;i++) ana[i]=analogin[i]=0;
    for(j=0;j<n;j++)
     {er=EAnalogOut(&id,0,analogout[0]+0.005*k,analogout[1]+0.005*k);
      if(er!=0) printerror("Error Analog Outs2: ",er);
      er=AISample(&id,0,&stateio,updateio,ledon,numchan,
		  channels,gains,notcal,&overvoltage,analogin);
      if(er!=0) printerror("Error Analog In: ",er);
      for(i=0;i<8;i++)
	{ana[i]+=analogin[i]; analogin[i]=0.0;}
     }
    printf("%s:  AI0=%.3lf  AI1=%.3lf  AI2=%.3lf  AI3=%.3lf\n",
	     argv[0], ana[0]/n, ana[1]/n, ana[2]/n, ana[3]/n);
   }
}
